"use strict";

import React from 'react';
import { useEffect, useRef } from 'react';
import { Animated, StyleSheet, View } from 'react-native';
import { useTheme } from 'react-native-paper';
import { sharedStyles } from '../shared/styles';
import { jsx as _jsx, jsxs as _jsxs } from "react/jsx-runtime";
export default function AnimatedCrossView({
  collapsed,
  calendar,
  calendarEdit
}) {
  const theme = useTheme();
  const calendarOpacity = useRef(new Animated.Value(collapsed ? 1 : 0));
  useEffect(() => {
    Animated.timing(calendarOpacity.current, {
      toValue: collapsed ? 1 : 0,
      duration: 250,
      useNativeDriver: true
    }).start();
  }, [collapsed]);
  return /*#__PURE__*/_jsxs(View, {
    style: sharedStyles.root,
    children: [/*#__PURE__*/_jsx(Animated.View, {
      pointerEvents: collapsed ? 'auto' : 'none',
      style: [sharedStyles.root, {
        opacity: calendarOpacity.current,
        transform: [{
          scaleY: calendarOpacity.current.interpolate({
            inputRange: [0, 1],
            outputRange: [0.85, 1]
          })
        }, {
          scaleX: calendarOpacity.current.interpolate({
            inputRange: [0, 1],
            outputRange: [0.95, 1]
          })
        }]
      }],
      children: calendar
    }), /*#__PURE__*/_jsx(Animated.View, {
      pointerEvents: collapsed ? 'none' : 'auto',
      style: [styles.calendarEdit, {
        backgroundColor: theme.colors.surface,
        opacity: calendarOpacity.current.interpolate({
          inputRange: [0, 1],
          outputRange: [1, 0]
        }),
        transform: [{
          scale: calendarOpacity.current.interpolate({
            inputRange: [0, 1],
            outputRange: [1, 0.95]
          })
        }]
      }],
      children: calendarEdit
    })]
  });
}
const styles = StyleSheet.create({
  calendarEdit: {
    position: 'absolute',
    left: 0,
    right: 0
  }
});
//# sourceMappingURL=AnimatedCrossView.js.map