"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useYearChange = useYearChange;
var _react = require("react");
var _utils = require("../shared/utils");
var _dateUtils = require("./dateUtils");
function useYearChange(onChange, {
  selectedYear,
  currentIndexRef
}) {
  const onChangeRef = (0, _utils.useLatest)(onChange);
  (0, _react.useEffect)(() => {
    if (selectedYear) {
      const currentIndex = currentIndexRef.current || 0;
      const currentDate = (0, _dateUtils.addMonths)(new Date(), (0, _dateUtils.getRealIndex)(currentIndex));
      currentDate.setFullYear(selectedYear);
      const today = new Date();
      const months = (0, _dateUtils.differenceInMonths)(today, currentDate);
      const newIndex = _dateUtils.startAtIndex + months;
      if (currentIndex !== newIndex) {
        onChangeRef.current(newIndex);
      }
    }
  }, [currentIndexRef, onChangeRef, selectedYear]);
}
//# sourceMappingURL=SwiperUtils.js.map