"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
exports.useDebouncedCallback = useDebouncedCallback;
var _reactNative = require("react-native");
var _Month = require("./Month");
var _dateUtils = require("./dateUtils");
var _utils = require("../shared/utils");
var _SwiperUtils = require("./SwiperUtils");
var _AutoSizer = _interopRequireDefault(require("./AutoSizer"));
var _react = _interopRequireWildcard(require("react"));
var _styles = require("../shared/styles");
var _jsxRuntime = require("react/jsx-runtime");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
const useIsomorphicLayoutEffect = typeof window !== 'undefined' ? _react.useLayoutEffect : _react.useEffect;
function Swiper({
  scrollMode,
  renderItem,
  renderHeader,
  renderFooter,
  selectedYear,
  initialIndex,
  startWeekOnMonday
}) {
  const isHorizontal = scrollMode === 'horizontal';
  const [index, setIndex] = (0, _react.useState)(initialIndex);
  const onPrev = (0, _react.useCallback)(() => {
    setIndex(prev => prev - 1);
  }, [setIndex]);
  const onNext = (0, _react.useCallback)(() => {
    setIndex(prev => prev + 1);
  }, [setIndex]);
  const renderProps = {
    index,
    onPrev,
    onNext
  };
  const indexRef = (0, _utils.useLatest)(index);
  (0, _SwiperUtils.useYearChange)(newIndex => {
    if (newIndex) {
      setIndex(newIndex);
    }
  }, {
    selectedYear,
    currentIndexRef: indexRef
  });
  return /*#__PURE__*/(0, _jsxRuntime.jsxs)(_jsxRuntime.Fragment, {
    children: [renderHeader && renderHeader(renderProps), isHorizontal ? /*#__PURE__*/(0, _jsxRuntime.jsx)(_reactNative.View, {
      style: _styles.sharedStyles.root,
      children: renderItem({
        index,
        onPrev,
        onNext
      })
    }) : /*#__PURE__*/(0, _jsxRuntime.jsx)(_AutoSizer.default, {
      children: ({
        width,
        height
      }) => /*#__PURE__*/(0, _jsxRuntime.jsx)(VerticalScroller, {
        width: width,
        height: height,
        initialIndex: initialIndex,
        estimatedHeight: _dateUtils.estimatedMonthHeight,
        renderItem: renderItem,
        startWeekOnMonday: startWeekOnMonday
      })
    }), renderFooter && renderFooter(renderProps)]
  });
}
const visibleArray = i => [i - 2, i - 1, i, i + 1, i + 2];
function VerticalScroller({
  width,
  height,
  initialIndex,
  estimatedHeight,
  renderItem,
  startWeekOnMonday
}) {
  const [visibleIndexes, setVisibleIndexes] = (0, _react.useState)(visibleArray(initialIndex));
  const idx = (0, _react.useRef)(initialIndex);
  const parentRef = (0, _react.useRef)(null);
  useIsomorphicLayoutEffect(() => {
    const element = parentRef.current;
    if (!element) {
      return;
    }
    const top = (0, _Month.getVerticalMonthsOffset)(idx.current, startWeekOnMonday) - _Month.montHeaderHeight;
    element.scrollTo({
      top
    });
  }, [parentRef, idx]);
  const setVisibleIndexesThrottled = useDebouncedCallback(setVisibleIndexes);
  const onScroll = (0, _react.useCallback)(e => {
    const top = e.currentTarget?.scrollTop;
    if (top === 0) {
      return;
    }
    const offset = top - _dateUtils.beginOffset;
    const index = (0, _Month.getIndexFromVerticalOffset)(offset, startWeekOnMonday);
    if (idx.current !== index) {
      idx.current = index;
      setVisibleIndexesThrottled(visibleArray(index));
    }
  }, [setVisibleIndexesThrottled, startWeekOnMonday]);
  return /*#__PURE__*/(0, _jsxRuntime.jsx)("div", {
    ref: parentRef
    // eslint-disable-next-line react-native/no-inline-styles
    ,
    style: {
      height,
      width,
      overflow: 'auto'
    },
    onScroll: onScroll,
    children: /*#__PURE__*/(0, _jsxRuntime.jsx)("div", {
      // eslint-disable-next-line react-native/no-inline-styles
      style: {
        height: estimatedHeight * _dateUtils.totalMonths,
        position: 'relative'
      },
      children: [0, 1, 2, 3, 4].map(vi => /*#__PURE__*/(0, _jsxRuntime.jsx)("div", {
        // eslint-disable-next-line react-native/no-inline-styles
        style: {
          willChange: 'transform',
          transform: `translateY(${(0, _Month.getVerticalMonthsOffset)(visibleIndexes[vi], startWeekOnMonday)}px)`,
          left: 0,
          right: 0,
          position: 'absolute',
          height: (0, _Month.getMonthHeight)('vertical', visibleIndexes[vi], startWeekOnMonday)
        },
        children: renderItem({
          index: visibleIndexes[vi],
          onPrev: empty,
          onNext: empty
        })
      }, vi))
    })
  });
}
const empty = () => null;
function useDebouncedCallback(callback) {
  const mounted = (0, _react.useRef)(true);
  const timerId = (0, _react.useRef)(null);
  const latest = (0, _utils.useLatest)(callback);
  (0, _react.useEffect)(() => {
    return () => {
      mounted.current = false;
      if (timerId.current) {
        window.cancelAnimationFrame(timerId.current);
      }
    };
  }, [mounted, timerId]);
  return (0, _react.useCallback)(args => {
    if (timerId.current) {
      window.cancelAnimationFrame(timerId.current);
    }
    timerId.current = window.requestAnimationFrame(function () {
      if (mounted.current) {
        latest.current(args);
      }
    });
  }, [mounted, timerId, latest]);
}
var _default = exports.default = /*#__PURE__*/(0, _react.memo)(Swiper);
//# sourceMappingURL=Swiper.js.map