"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = exports.EmptyDay = void 0;
var _reactNativePaper = require("react-native-paper");
var _reactNative = require("react-native");
var _DayRange = _interopRequireDefault(require("./DayRange"));
var _dateUtils = require("./dateUtils");
var _react = _interopRequireWildcard(require("react"));
var _jsxRuntime = require("react/jsx-runtime");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
function EmptyDayPure() {
  return /*#__PURE__*/(0, _jsxRuntime.jsx)(_reactNative.View, {
    style: styles.empty
  });
}
const EmptyDay = exports.EmptyDay = /*#__PURE__*/(0, _react.memo)(EmptyDayPure);
function Day(props) {
  const {
    day,
    month,
    year,
    selected,
    inRange,
    leftCrop,
    rightCrop,
    onPressDate,
    primaryColor,
    selectColor,
    isToday,
    disabled,
    textColorOnPrimary,
    theme
  } = props;
  const borderColorFallback = theme.dark ? '#fff' : '#000';
  const selectedOrInRangeDarkMode = selected || inRange && theme.dark;
  const v2BorderColor = selectedOrInRangeDarkMode ? textColorOnPrimary : borderColorFallback;
  const borderColor = theme.isV3 ? theme.colors.primary : v2BorderColor;
  const onPress = (0, _react.useCallback)(() => {
    onPressDate(new Date(year, month, day));
  }, [onPressDate, year, month, day]);

  // TODO: check if this can be simplified
  // converted with Chat-GPT for now from enormous conditional to if-else
  let baseTextColor;
  let finalTextColor;
  if (theme.isV3) {
    // Theme V3 specific logic for base text color
    if (selected) {
      baseTextColor = theme.colors.onPrimary;
    } else if (inRange && theme.dark) {
      baseTextColor = theme.colors.onPrimaryContainer;
    } else {
      baseTextColor = theme.colors.onSurface;
    }

    // Theme V3 specific logic for final text color
    if (isToday) {
      finalTextColor = selected ? baseTextColor : theme.colors.primary;
    } else {
      finalTextColor = baseTextColor;
    }
  } else {
    // Logic for themes other than V3
    if (selected || inRange && theme.dark) {
      baseTextColor = textColorOnPrimary;
    }
    // Since there's no additional logic provided for non-V3 themes in the step 2,
    // the final text color for non-V3 themes will simply be the base text color.
    finalTextColor = baseTextColor;
  }
  let textFont = theme?.isV3 ? theme.fonts.bodySmall : theme.fonts.medium;
  return /*#__PURE__*/(0, _jsxRuntime.jsxs)(_reactNative.View, {
    style: [styles.root, disabled && styles.disabled],
    children: [/*#__PURE__*/(0, _jsxRuntime.jsx)(_DayRange.default, {
      inRange: inRange,
      leftCrop: leftCrop,
      rightCrop: rightCrop,
      selectColor: selectColor
    }), /*#__PURE__*/(0, _jsxRuntime.jsx)(_reactNativePaper.TouchableRipple, {
      testID: `react-native-paper-dates-day-${year}-${month}-${day}`,
      disabled: disabled,
      borderless: true,
      onPress: disabled ? undefined : onPress,
      style: [styles.button, {
        backgroundColor: inRange ? selectColor : undefined
      }],
      accessibilityRole: "button",
      children: /*#__PURE__*/(0, _jsxRuntime.jsx)(_reactNative.View, {
        style: [styles.day, isToday ? {
          borderColor: borderColor
        } : null, selected ? {
          backgroundColor: primaryColor
        } : null],
        children: /*#__PURE__*/(0, _jsxRuntime.jsx)(_reactNativePaper.Text, {
          maxFontSizeMultiplier: 1.5,
          style: [baseTextColor ? {
            color: finalTextColor
          } : undefined, {
            ...textFont
          }],
          selectable: false,
          children: day
        })
      })
    })]
  });
}
const styles = _reactNative.StyleSheet.create({
  button: {
    width: _dateUtils.daySize,
    height: _dateUtils.daySize,
    overflow: 'hidden',
    borderRadius: _dateUtils.daySize / 2
  },
  day: {
    flexBasis: 0,
    flex: 1,
    borderRadius: _dateUtils.daySize / 2,
    width: _dateUtils.daySize,
    height: _dateUtils.daySize,
    justifyContent: 'center',
    alignItems: 'center',
    borderWidth: 1,
    borderColor: 'transparent'
  },
  disabled: {
    opacity: 0.3
  },
  empty: {
    flex: 1,
    flexBasis: 0
  },
  root: {
    flexBasis: 0,
    flex: 1,
    justifyContent: 'center',
    alignItems: 'center',
    position: 'relative'
  }
});
var _default = exports.default = /*#__PURE__*/(0, _react.memo)(Day);
//# sourceMappingURL=Day.js.map