"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = DatePickerModalHeaderBackground;
var _react = _interopRequireDefault(require("react"));
var _reactNative = require("react-native");
var _utils = require("../shared/utils");
var _reactNativeSafeAreaContext = require("react-native-safe-area-context");
var _jsxRuntime = require("react/jsx-runtime");
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
function DatePickerModalHeaderBackground({
  children
}) {
  const backgroundColor = (0, _utils.useHeaderBackgroundColor)();
  const insets = (0, _reactNativeSafeAreaContext.useSafeAreaInsets)();
  return /*#__PURE__*/(0, _jsxRuntime.jsx)(_reactNative.Animated.View, {
    style: [styles.animated, {
      backgroundColor,
      paddingLeft: insets.left,
      paddingRight: insets.right
    }],
    children: children
  });
}
const styles = _reactNative.StyleSheet.create({
  animated: {
    elevation: 4
  }
});
//# sourceMappingURL=DatePickerModalHeaderBackground.js.map