"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DatePickerModal = DatePickerModal;
exports.default = void 0;
var _reactNative = require("react-native");
var _reactNativePaper = require("react-native-paper");
var _DatePickerModalContent = _interopRequireDefault(require("./DatePickerModalContent"));
var _react = _interopRequireWildcard(require("react"));
var _styles = require("../shared/styles");
var _utils = require("../shared/utils");
var _jsxRuntime = require("react/jsx-runtime");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
function DatePickerModal(props) {
  const {
    visible,
    animationType,
    disableStatusBar,
    disableStatusBarPadding,
    inputEnabled,
    presentationStyle,
    statusBarOnTopOfBackdrop,
    ...rest
  } = props;
  const animationTypeCalculated = animationType || _reactNative.Platform.select({
    web: 'none',
    default: 'slide'
  });
  const isPageSheet = presentationStyle === 'pageSheet' && _reactNative.Platform.OS === 'ios';
  const theme = (0, _reactNativePaper.useTheme)();
  const dimensions = (0, _reactNative.useWindowDimensions)();
  return /*#__PURE__*/(0, _jsxRuntime.jsx)(_reactNative.View, {
    style: _reactNative.StyleSheet.absoluteFill,
    pointerEvents: "box-none",
    children: /*#__PURE__*/(0, _jsxRuntime.jsxs)(_reactNative.Modal, {
      animationType: animationTypeCalculated,
      transparent: !isPageSheet,
      visible: visible,
      onRequestClose: rest.onDismiss,
      presentationStyle: isPageSheet ? 'pageSheet' : 'overFullScreen',
      supportedOrientations: _utils.supportedOrientations,
      statusBarTranslucent: true,
      children: [/*#__PURE__*/(0, _jsxRuntime.jsx)(_reactNative.TouchableWithoutFeedback, {
        onPress: rest.onDismiss,
        children: /*#__PURE__*/(0, _jsxRuntime.jsx)(_reactNative.View, {
          style: [_reactNative.StyleSheet.absoluteFill, _styles.sharedStyles.root, {
            backgroundColor: theme.colors.backdrop
          }]
        })
      }), /*#__PURE__*/(0, _jsxRuntime.jsx)(_reactNative.View, {
        style: [_reactNative.StyleSheet.absoluteFill, styles.modalRoot],
        pointerEvents: "box-none",
        children: /*#__PURE__*/(0, _jsxRuntime.jsx)(_reactNative.View, {
          style: [styles.modalContent, {
            backgroundColor: theme.colors.surface
          }, dimensions.width > 650 ? styles.modalContentBig : null],
          children: /*#__PURE__*/(0, _jsxRuntime.jsx)(_DatePickerModalContent.default, {
            ...rest,
            inputEnabled: inputEnabled,
            disableSafeTop: disableStatusBarPadding,
            disableStatusBar: disableStatusBar,
            statusBarOnTopOfBackdrop: isPageSheet || statusBarOnTopOfBackdrop,
            withDateFormatInLabel: props.withDateFormatInLabel,
            placeholder: props.placeholder
          })
        })
      })]
    })
  });
}
const styles = _reactNative.StyleSheet.create({
  modalContent: {
    flex: 1,
    width: '100%'
  },
  modalContentBig: {
    maxWidth: 400,
    maxHeight: 600,
    borderRadius: 10,
    width: '100%',
    overflow: 'hidden'
  },
  modalRoot: {
    justifyContent: 'center',
    alignItems: 'center',
    flex: 1
  }
});
var _default = exports.default = /*#__PURE__*/(0, _react.memo)(DatePickerModal);
//# sourceMappingURL=DatePickerModal.js.map