"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _reactNative = require("react-native");
var _Swiper = _interopRequireDefault(require("./Swiper"));
var _Month = _interopRequireDefault(require("./Month"));
var _dateUtils = require("./dateUtils");
var _CalendarHeader = _interopRequireDefault(require("./CalendarHeader"));
var _react = _interopRequireWildcard(require("react"));
var _YearPicker = _interopRequireDefault(require("./YearPicker"));
var _color = _interopRequireDefault(require("color"));
var _reactNativePaper = require("react-native-paper");
var _utils = require("../shared/utils");
var _styles = require("../shared/styles");
var _jsxRuntime = require("react/jsx-runtime");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
function Calendar(props) {
  const {
    locale,
    mode,
    onChange,
    startDate,
    endDate,
    date,
    disableWeekDays,
    startYear,
    endYear,
    dates,
    validRange,
    dateMode,
    startWeekOnMonday
  } = props;
  const scrollMode = mode === 'range' || mode === 'multiple' ? 'vertical' : 'horizontal';
  const firstDate = startDate || date || dates?.[0];
  const theme = (0, _reactNativePaper.useTheme)();
  const [selectedYear, setSelectedYear] = (0, _react.useState)(undefined);
  const [selectingYear, setSelectingYear] = (0, _react.useState)(false);

  // prevent re-rendering all months when something changed we only need the
  // latest version of the props and we don't want the useCallback to change
  const startDateRef = (0, _utils.useLatest)(startDate);
  const endDateRef = (0, _utils.useLatest)(endDate);
  const onChangeRef = (0, _utils.useLatest)(onChange);
  const datesRef = (0, _utils.useLatest)(dates);
  const onPressYear = (0, _react.useCallback)(year => {
    setSelectedYear(year);
    setSelectingYear(prev => !prev);
  }, [setSelectingYear]);
  const onPressDate = (0, _react.useCallback)(d => {
    if (mode === 'single') {
      ;
      onChangeRef.current({
        date: dateMode === 'start' ? d : (0, _dateUtils.getEndOfDay)(d)
      });
    } else if (mode === 'range') {
      const sd = startDateRef.current;
      const ed = endDateRef.current;
      let isStart = true;
      if (sd && !ed && (0, _dateUtils.dateToUnix)(d) >= (0, _dateUtils.dateToUnix)(sd)) {
        isStart = false;
      }
      ;
      onChangeRef.current({
        startDate: isStart ? d : sd,
        endDate: !isStart ? (0, _dateUtils.getEndOfDay)(d) : undefined
      });
    } else if (mode === 'multiple') {
      datesRef.current = datesRef.current || [];
      const exists = datesRef.current.some(ed => (0, _dateUtils.areDatesOnSameDay)(ed, d));
      const newDates = exists ? datesRef.current.filter(ed => !(0, _dateUtils.areDatesOnSameDay)(ed, d)) : [...datesRef.current, d];
      newDates.sort((a, b) => a.getTime() - b.getTime());
      onChangeRef.current({
        dates: newDates,
        datePressed: d,
        change: exists ? 'removed' : 'added'
      });
    }
  }, [mode, dateMode, onChangeRef, startDateRef, endDateRef, datesRef]);
  const selectColor = (0, _react.useMemo)(() => {
    if (theme.isV3) {
      return theme.colors.primaryContainer;
    }
    if (theme.dark) {
      return (0, _utils.darkenBy)((0, _color.default)(theme.colors.primary), 0.1).hex();
    }
    return (0, _utils.lightenBy)((0, _color.default)(theme.colors.primary), 0.9).hex();
  }, [theme]);
  return /*#__PURE__*/(0, _jsxRuntime.jsxs)(_reactNative.View, {
    style: _styles.sharedStyles.root,
    children: [/*#__PURE__*/(0, _jsxRuntime.jsx)(_Swiper.default, {
      initialIndex: (0, _dateUtils.getInitialIndex)(firstDate),
      selectedYear: selectedYear,
      scrollMode: scrollMode,
      startWeekOnMonday: startWeekOnMonday || false,
      renderItem: ({
        index
      }) => /*#__PURE__*/(0, _jsxRuntime.jsx)(_Month.default, {
        locale: locale,
        mode: mode,
        validRange: validRange,
        index: index,
        startDate: startDate,
        endDate: endDate,
        date: date,
        dates: dates,
        onPressYear: onPressYear,
        selectingYear: selectingYear,
        onPressDate: onPressDate,
        scrollMode: scrollMode,
        primaryColor: theme.colors.primary,
        selectColor: selectColor,
        roundness: theme.roundness,
        disableWeekDays: disableWeekDays,
        startWeekOnMonday: startWeekOnMonday || false
      }, index),
      renderHeader: ({
        onPrev,
        onNext
      }) => /*#__PURE__*/(0, _jsxRuntime.jsx)(_CalendarHeader.default, {
        locale: locale,
        onPrev: onPrev,
        onNext: onNext,
        scrollMode: scrollMode,
        disableWeekDays: disableWeekDays,
        startWeekOnMonday: startWeekOnMonday || false
      })
    }), scrollMode === 'horizontal' ? /*#__PURE__*/(0, _jsxRuntime.jsx)(_YearPicker.default, {
      selectedYear: selectedYear,
      selectingYear: selectingYear,
      onPressYear: onPressYear,
      startYear: startYear || 1800,
      endYear: endYear || 2200
    }) : null]
  });
}
var _default = exports.default = /*#__PURE__*/(0, _react.memo)(Calendar);
//# sourceMappingURL=Calendar.js.map