import React, { Component } from 'react';
import PropTypes from 'prop-types'
import {
  View,
} from 'react-native';

// Warning: Card: Support for defaultProps will be removed from function components in a future major release. Use JavaScript default parameters instead.
const Card = ({
  style = {},
  children,
  onSwiped = () => {},
  onSwipedLeft = () => {},
  onSwipedRight = () => {},
  onSwipedTop = () => {},
  onSwipedBottom = () => {},
}) => (
  <View style={style} >
    {children}
  </View>);

Card.propTypes = {
  children: PropTypes.oneOfType([PropTypes.array, PropTypes.object]).isRequired,
  style: PropTypes.oneOfType([PropTypes.number, PropTypes.object, PropTypes.array]),
  onSwipedLeft: PropTypes.func,
  onSwipedRight:PropTypes.func,
  onSwipedTop: PropTypes.func,
  onSwipedBottom: PropTypes.func,
  onSwiped: PropTypes.func,
}

export default Card;
