import { Match, MatchConfig } from 'autolinker/dist/es2015';
import React from 'react';
import { StyleProp, TextStyle } from 'react-native';
export type ReplacerArgs = [string, ...any[]];
export interface CustomMatcher {
    pattern: RegExp;
    onPress?: (match: CustomMatch) => void;
    onLongPress?: (match: CustomMatch) => void;
    style?: StyleProp<TextStyle>;
    type?: string;
    getLinkText?: (replacerArgs: ReplacerArgs) => string;
    getLinkUrl?: (replacerArgs: ReplacerArgs) => string;
    renderLink?: (text: string, match: CustomMatch, index: number) => React.ReactNode;
}
export interface CustomMatchConfig extends MatchConfig {
    matcher: CustomMatcher;
    replacerArgs: ReplacerArgs;
}
export declare class CustomMatch extends Match {
    private matcher;
    private replacerArgs;
    constructor({ matcher, replacerArgs, ...config }: CustomMatchConfig);
    getType(): string;
    getAnchorHref(): string;
    getAnchorText(): string;
    getMatcher(): CustomMatcher;
    getReplacerArgs(): ReplacerArgs;
    getRenderFn(): CustomMatcher['renderLink'];
}
