/*!
 * React Native Autolink
 *
 * Copyright 2016-2023 Josh Swan
 * Released under the MIT license
 * https://github.com/joshswan/react-native-autolink/blob/master/LICENSE
 */
import React from 'react';
import { Match } from 'autolinker/dist/es2015';
import { StyleProp, Text, TextStyle, TextProps } from 'react-native';
import { CustomMatcher } from './CustomMatch';
import { PolymorphicComponentProps } from './types';
export interface AutolinkProps {
    email?: boolean;
    hashtag?: false | 'facebook' | 'instagram' | 'twitter';
    linkProps?: TextProps;
    linkStyle?: StyleProp<TextStyle>;
    matchers?: CustomMatcher[];
    mention?: false | 'instagram' | 'soundcloud' | 'twitter';
    onPress?: (url: string, match: Match) => void;
    onLongPress?: (url: string, match: Match) => void;
    phone?: boolean | 'text' | 'sms';
    renderLink?: (text: string, match: Match, index: number) => React.ReactNode;
    renderText?: (text: string, index: number) => React.ReactNode;
    showAlert?: boolean;
    stripPrefix?: boolean;
    stripTrailingSlash?: boolean;
    text: string;
    textProps?: TextProps;
    truncate?: number;
    truncateChars?: string;
    truncateLocation?: 'end' | 'middle' | 'smart';
    url?: boolean | {
        schemeMatches?: boolean;
        wwwMatches?: boolean;
        tldMatches?: boolean;
    };
    useNativeSchemes?: boolean;
}
export type AutolinkComponentProps<C extends React.ElementType = typeof Text> = PolymorphicComponentProps<C, AutolinkProps>;
export declare const Autolink: React.MemoExoticComponent<(<C extends React.ElementType<any> = typeof Text>({ as, component, email, hashtag, linkProps, linkStyle, matchers, mention, onPress: onPressProp, onLongPress: onLongPressProp, phone, renderLink: renderLinkProp, renderText, showAlert, stripPrefix, stripTrailingSlash, text, textProps, truncate: truncateProp, truncateChars, truncateLocation, url, useNativeSchemes, ...props }: AutolinkComponentProps<C>) => JSX.Element | null)>;
