#!/usr/bin/env node
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const tslib_1 = require("tslib");
const arg_1 = tslib_1.__importDefault(require("arg"));
const chalk_1 = tslib_1.__importDefault(require("chalk"));
const debug_1 = tslib_1.__importDefault(require("debug"));
const getenv_1 = require("getenv");
const Log = tslib_1.__importStar(require("./utils/log"));
// Setup before requiring `debug`.
if ((0, getenv_1.boolish)('EXPO_DEBUG', false)) {
    debug_1.default.enable('expo-updates:*');
}
else if (debug_1.default.enabled('expo-updates:')) {
    process.env.EXPO_DEBUG = '1';
}
const commands = {
    // Add a new command here
    'codesigning:generate': () => import('./generateCodeSigning.js').then((i) => i.generateCodeSigning),
    'codesigning:configure': () => import('./configureCodeSigning.js').then((i) => i.configureCodeSigning),
    'assets:verify': () => import('./assetsVerify.js').then((i) => i.expoAssetsVerify),
};
const args = (0, arg_1.default)({
    // Types
    '--help': Boolean,
    // Aliases
    '-h': '--help',
}, {
    permissive: true,
});
const command = args._[0];
const commandArgs = args._.slice(1);
// Handle `--help` flag
if ((args['--help'] && !command) || !command) {
    Log.exit((0, chalk_1.default) `
{bold Usage}
  {dim $} npx expo-updates <command>

{bold Commands}
  ${Object.keys(commands).sort().join(', ')}

{bold Options}
  --help, -h      Displays this message

For more information run a command with the --help flag
  {dim $} npx expo-updates codesigning:generate --help
  `, 0);
}
// Push the help flag to the subcommand args.
if (args['--help']) {
    commandArgs.push('--help');
}
// Install exit hooks
process.on('SIGINT', () => process.exit(0));
process.on('SIGTERM', () => process.exit(0));
commands[command]().then((exec) => exec(commandArgs));
