"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useSyncState = useSyncState;
var React = _interopRequireWildcard(require("react"));
var _useLatestCallback = _interopRequireDefault(require("use-latest-callback"));
var _deepFreeze = require("./deepFreeze.js");
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const createStore = getInitialState => {
  const listeners = [];
  let initialized = false;
  let state;
  const getState = () => {
    if (initialized) {
      return state;
    }
    initialized = true;
    state = (0, _deepFreeze.deepFreeze)(getInitialState());
    return state;
  };
  let isBatching = false;
  let didUpdate = false;
  const setState = newState => {
    state = (0, _deepFreeze.deepFreeze)(newState);
    didUpdate = true;
    if (!isBatching) {
      listeners.forEach(listener => listener());
    }
  };
  const subscribe = callback => {
    listeners.push(callback);
    return () => {
      const index = listeners.indexOf(callback);
      if (index > -1) {
        listeners.splice(index, 1);
      }
    };
  };
  const batchUpdates = callback => {
    isBatching = true;
    callback();
    isBatching = false;
    if (didUpdate) {
      didUpdate = false;
      listeners.forEach(listener => listener());
    }
  };
  return {
    getState,
    setState,
    batchUpdates,
    subscribe
  };
};
function useSyncState(getInitialState) {
  const store = React.useRef(createStore(getInitialState)).current;
  const state = React.useSyncExternalStore(store.subscribe, store.getState, store.getState);
  React.useDebugValue(state);
  const pendingUpdatesRef = React.useRef([]);
  const scheduleUpdate = (0, _useLatestCallback.default)(callback => {
    pendingUpdatesRef.current.push(callback);
  });
  const flushUpdates = (0, _useLatestCallback.default)(() => {
    const pendingUpdates = pendingUpdatesRef.current;
    pendingUpdatesRef.current = [];
    if (pendingUpdates.length !== 0) {
      store.batchUpdates(() => {
        // Flush all the pending updates
        for (const update of pendingUpdates) {
          update();
        }
      });
    }
  });
  return {
    state,
    getState: store.getState,
    setState: store.setState,
    scheduleUpdate,
    flushUpdates
  };
}
//# sourceMappingURL=useSyncState.js.map