"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SceneView = SceneView;
var React = _interopRequireWildcard(require("react"));
var _EnsureSingleNavigator = require("./EnsureSingleNavigator.js");
var _NavigationStateContext = require("./NavigationStateContext.js");
var _StaticContainer = require("./StaticContainer.js");
var _useOptionsGetters = require("./useOptionsGetters.js");
var _jsxRuntime = require("react/jsx-runtime");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/**
 * Component which takes care of rendering the screen for a route.
 * It provides all required contexts and applies optimizations when applicable.
 */
function SceneView({
  screen,
  route,
  navigation,
  routeState,
  getState,
  setState,
  options,
  clearOptions
}) {
  const navigatorKeyRef = React.useRef();
  const getKey = React.useCallback(() => navigatorKeyRef.current, []);
  const {
    addOptionsGetter
  } = (0, _useOptionsGetters.useOptionsGetters)({
    key: route.key,
    options,
    navigation
  });
  const setKey = React.useCallback(key => {
    navigatorKeyRef.current = key;
  }, []);
  const getCurrentState = React.useCallback(() => {
    const state = getState();
    const currentRoute = state.routes.find(r => r.key === route.key);
    return currentRoute ? currentRoute.state : undefined;
  }, [getState, route.key]);
  const setCurrentState = React.useCallback(child => {
    const state = getState();
    setState({
      ...state,
      routes: state.routes.map(r => {
        if (r.key !== route.key) {
          return r;
        }
        const nextRoute = {
          ...r,
          state: child
        };

        // Before updating the state, cleanup any nested screen and state
        // This will avoid the navigator trying to handle them again
        if (nextRoute.params && ('state' in nextRoute.params && typeof nextRoute.params.state === 'object' && nextRoute.params.state !== null || 'screen' in nextRoute.params && typeof nextRoute.params.screen === 'string')) {
          // @ts-expect-error: we don't have correct type for params
          // eslint-disable-next-line @typescript-eslint/no-unused-vars
          const {
            state,
            screen,
            params,
            initial,
            ...rest
          } = nextRoute.params;
          if (Object.keys(rest).length) {
            nextRoute.params = rest;
          } else {
            delete nextRoute.params;
          }
        }
        return nextRoute;
      })
    });
  }, [getState, route.key, setState]);
  const isInitialRef = React.useRef(true);
  React.useEffect(() => {
    isInitialRef.current = false;
  });

  // Clear options set by this screen when it is unmounted
  React.useEffect(() => {
    return clearOptions;
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, []);
  const getIsInitial = React.useCallback(() => isInitialRef.current, []);
  const context = React.useMemo(() => ({
    state: routeState,
    getState: getCurrentState,
    setState: setCurrentState,
    getKey,
    setKey,
    getIsInitial,
    addOptionsGetter
  }), [routeState, getCurrentState, setCurrentState, getKey, setKey, getIsInitial, addOptionsGetter]);
  const ScreenComponent = screen.getComponent ? screen.getComponent() : screen.component;
  return /*#__PURE__*/(0, _jsxRuntime.jsx)(_NavigationStateContext.NavigationStateContext.Provider, {
    value: context,
    children: /*#__PURE__*/(0, _jsxRuntime.jsx)(_EnsureSingleNavigator.EnsureSingleNavigator, {
      children: /*#__PURE__*/(0, _jsxRuntime.jsx)(_StaticContainer.StaticContainer, {
        name: screen.name,
        render: ScreenComponent || screen.children,
        navigation: navigation,
        route: route,
        children: ScreenComponent !== undefined ? /*#__PURE__*/(0, _jsxRuntime.jsx)(ScreenComponent, {
          navigation: navigation,
          route: route
        }) : screen.children !== undefined ? screen.children({
          navigation,
          route
        }) : null
      })
    })
  });
}
//# sourceMappingURL=SceneView.js.map