import { useState } from 'react';
export const useZoomableLayout = ({
  onLayout
}) => {
  const [state, setState] = useState({
    x: 0,
    y: 0,
    width: 0,
    height: 0,
    center: {
      x: 0,
      y: 0
    }
  });
  const onZoomableLayout = event => {
    const {
      layout
    } = event.nativeEvent;
    const {
      x,
      y,
      width,
      height
    } = layout;
    const center = {
      x: x + width / 2,
      y: y + height / 2
    };
    if (typeof onLayout === 'function') {
      onLayout(event);
    }
    setState({
      ...layout,
      center
    });
  };
  return {
    ...state,
    onZoomableLayout
  };
};
//# sourceMappingURL=useZoomableLayout.js.map