function _extends() { return _extends = Object.assign ? Object.assign.bind() : function (n) { for (var e = 1; e < arguments.length; e++) { var t = arguments[e]; for (var r in t) ({}).hasOwnProperty.call(t, r) && (n[r] = t[r]); } return n; }, _extends.apply(null, arguments); }
import React, { forwardRef } from 'react';
import { StyleSheet } from 'react-native';
import { GestureDetector } from 'react-native-gesture-handler';
import Animated from 'react-native-reanimated';
import { useZoomable } from '../hooks/useZoomable';
const styles = StyleSheet.create({
  container: {
    flex: 1
  }
});
const Zoomable = ({
  minScale,
  maxScale,
  scale,
  doubleTapScale,
  maxPanPointers,
  isPanEnabled,
  isPinchEnabled,
  isSingleTapEnabled,
  isDoubleTapEnabled,
  onInteractionStart,
  onInteractionEnd,
  onPinchStart,
  onPinchEnd,
  onPanStart,
  onPanEnd,
  onSingleTap,
  onDoubleTap,
  onProgrammaticZoom,
  onResetAnimationEnd,
  onLayout,
  style = {},
  children,
  ...props
}, ref) => {
  const {
    animatedStyle,
    gestures,
    onZoomableLayout
  } = useZoomable({
    minScale,
    maxScale,
    scale,
    doubleTapScale,
    maxPanPointers,
    isPanEnabled,
    isPinchEnabled,
    isSingleTapEnabled,
    isDoubleTapEnabled,
    onInteractionStart,
    onInteractionEnd,
    onPinchStart,
    onPinchEnd,
    onPanStart,
    onPanEnd,
    onSingleTap,
    onDoubleTap,
    onProgrammaticZoom,
    onResetAnimationEnd,
    onLayout,
    ref
  });
  return /*#__PURE__*/React.createElement(GestureDetector, {
    gesture: gestures
  }, /*#__PURE__*/React.createElement(Animated.View, _extends({
    style: [styles.container, style, animatedStyle],
    onLayout: onZoomableLayout
  }, props), children));
};
export default /*#__PURE__*/forwardRef(Zoomable);
//# sourceMappingURL=Zoomable.js.map