"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useZoomableLayout = void 0;
var _react = require("react");
const useZoomableLayout = ({
  onLayout
}) => {
  const [state, setState] = (0, _react.useState)({
    x: 0,
    y: 0,
    width: 0,
    height: 0,
    center: {
      x: 0,
      y: 0
    }
  });
  const onZoomableLayout = event => {
    const {
      layout
    } = event.nativeEvent;
    const {
      x,
      y,
      width,
      height
    } = layout;
    const center = {
      x: x + width / 2,
      y: y + height / 2
    };
    if (typeof onLayout === 'function') {
      onLayout(event);
    }
    setState({
      ...layout,
      center
    });
  };
  return {
    ...state,
    onZoomableLayout
  };
};
exports.useZoomableLayout = useZoomableLayout;
//# sourceMappingURL=useZoomableLayout.js.map