"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useZoomable = void 0;
var _useGestures = require("../hooks/useGestures");
var _useZoomableLayout = require("../hooks/useZoomableLayout");
var _useZoomableHandle = require("../hooks/useZoomableHandle");
const useZoomable = ({
  minScale,
  maxScale,
  scale,
  doubleTapScale,
  maxPanPointers,
  isPanEnabled,
  isPinchEnabled,
  isSingleTapEnabled,
  isDoubleTapEnabled,
  onInteractionStart,
  onInteractionEnd,
  onPinchStart,
  onPinchEnd,
  onPanStart,
  onPanEnd,
  onSingleTap,
  onDoubleTap,
  onProgrammaticZoom,
  onResetAnimationEnd,
  onLayout,
  ref
}) => {
  const {
    width,
    height,
    center,
    onZoomableLayout
  } = (0, _useZoomableLayout.useZoomableLayout)({
    onLayout
  });
  const {
    animatedStyle,
    gestures,
    reset,
    zoom,
    getInfo
  } = (0, _useGestures.useGestures)({
    width,
    height,
    center,
    minScale,
    maxScale,
    scale,
    doubleTapScale,
    maxPanPointers,
    isPanEnabled,
    isPinchEnabled,
    isSingleTapEnabled,
    isDoubleTapEnabled,
    onInteractionStart,
    onInteractionEnd,
    onPinchStart,
    onPinchEnd,
    onPanStart,
    onPanEnd,
    onSingleTap,
    onDoubleTap,
    onProgrammaticZoom,
    onResetAnimationEnd
  });
  (0, _useZoomableHandle.useZoomableHandle)(ref, reset, zoom, getInfo);
  return {
    animatedStyle,
    gestures,
    onZoomableLayout
  };
};
exports.useZoomable = useZoomable;
//# sourceMappingURL=useZoomable.js.map