'use strict';

Object.defineProperty(exports, '__esModule', {
  value: true,
});
exports.PreviewText = PreviewText;
var _react = _interopRequireDefault(require('react'));
var _reactNative = require('react-native');
var _reactNativeReanimated = _interopRequireWildcard(require('react-native-reanimated'));
var _AppContext = _interopRequireDefault(require('../AppContext'));
var _styles = require('../styles');
var _utils = require('../utils');
function _getRequireWildcardCache(e) {
  if ('function' != typeof WeakMap) return null;
  var r = new WeakMap(),
    t = new WeakMap();
  return (_getRequireWildcardCache = function (e) {
    return e ? t : r;
  })(e);
}
function _interopRequireWildcard(e, r) {
  if (!r && e && e.__esModule) return e;
  if (null === e || ('object' != typeof e && 'function' != typeof e)) return { default: e };
  var t = _getRequireWildcardCache(r);
  if (t && t.has(e)) return t.get(e);
  var n = { __proto__: null },
    a = Object.defineProperty && Object.getOwnPropertyDescriptor;
  for (var u in e)
    if ('default' !== u && Object.prototype.hasOwnProperty.call(e, u)) {
      var i = a ? Object.getOwnPropertyDescriptor(e, u) : null;
      i && (i.get || i.set) ? Object.defineProperty(n, u, i) : (n[u] = e[u]);
    }
  return (n.default = e), t && t.set(e, n), n;
}
function _interopRequireDefault(obj) {
  return obj && obj.__esModule ? obj : { default: obj };
}
_reactNativeReanimated.default.addWhitelistedNativeProps({
  text: true,
});
const AnimatedTextInput = _reactNativeReanimated.default.createAnimatedComponent(_reactNative.TextInput);
function PreviewText({ style = {}, colorFormat = 'hex' }) {
  const { returnedResults, hueValue, saturationValue, brightnessValue, alphaValue } = (0, _AppContext.default)();
  const inputRef = (0, _reactNativeReanimated.useAnimatedRef)();
  const colorString = (0, _reactNativeReanimated.useDerivedValue)(() => {
    [colorFormat, hueValue, saturationValue, brightnessValue, alphaValue]; // track changes on Native

    if (_utils.isWeb && inputRef.current) {
      // @ts-expect-error value doesn't exist
      inputRef.current.value = returnedResults()[colorFormat];
      return;
    }
    return returnedResults()[colorFormat];
  }, [colorFormat, hueValue, saturationValue, brightnessValue, alphaValue]); // track changes on WEB

  const animatedProps = (0, _reactNativeReanimated.useAnimatedProps)(
    () => ({
      text: colorString.value,
    }),
    [colorString],
  );
  return /*#__PURE__*/ _react.default.createElement(AnimatedTextInput, {
    ref: inputRef,
    underlineColorAndroid: 'transparent',
    editable: false,
    defaultValue: colorString.value,
    style: [_styles.styles.previewText, style],
    animatedProps: animatedProps,
    pointerEvents: 'none',
  });
}
