"use strict";

import { View, StyleSheet } from 'react-native';
import { Text, TouchableRipple, useTheme } from 'react-native-paper';
import { useContext, useMemo } from 'react';
import Color from 'color';
import { inputTypes, useSwitchColors } from './timeUtils';
import { DisplayModeContext } from '../contexts/DisplayModeContext';
import React from 'react';
import { sharedStyles } from '../shared/styles';
import { jsx as _jsx, jsxs as _jsxs } from "react/jsx-runtime";
export default function AmPmSwitcher({
  onChange,
  hours,
  inputType
}) {
  const theme = useTheme();
  const {
    setMode,
    mode
  } = useContext(DisplayModeContext);
  const backgroundColor = useMemo(() => {
    if (theme.isV3) {
      return theme.colors.outline;
    }
    return Color(theme.dark ? Color(theme.colors.surface).lighten(1.2).hex() : theme.colors.surface).darken(0.1).hex();
  }, [theme]);
  const isAM = mode === 'AM';
  return /*#__PURE__*/_jsxs(View, {
    style: [styles.root,
    // eslint-disable-next-line react-native/no-inline-styles
    {
      borderColor: backgroundColor,
      borderRadius: theme.roundness * 2,
      height: inputType === inputTypes.keyboard ? 72 : 80,
      marginBottom: inputType === 'keyboard' ? 16 : 0
    }],
    children: [/*#__PURE__*/_jsx(SwitchButton, {
      label: "AM",
      onPress: () => {
        setMode('AM');
        if (hours - 12 >= 0) {
          onChange(hours - 12);
        }
      },
      selected: isAM,
      disabled: isAM
    }), /*#__PURE__*/_jsx(View, {
      style: [styles.switchSeparator, {
        backgroundColor
      }]
    }), /*#__PURE__*/_jsx(SwitchButton, {
      label: "PM",
      onPress: () => {
        setMode('PM');
        if (hours + 12 <= 24) {
          onChange(hours + 12);
        }
      },
      selected: !isAM,
      disabled: !isAM
    })]
  });
}
function SwitchButton({
  label,
  onPress,
  selected,
  disabled
}) {
  const theme = useTheme();
  const {
    backgroundColor,
    color
  } = useSwitchColors(selected);
  let textFont = theme?.isV3 ? theme.fonts.titleMedium : theme.fonts.medium;
  return /*#__PURE__*/_jsx(TouchableRipple, {
    onPress: onPress,
    style: sharedStyles.root,
    accessibilityLabel: label
    // @ts-ignore old React Native versions
    ,
    accessibilityTraits: disabled ? ['button', 'disabled'] : 'button'
    // @ts-ignore old React Native versions
    ,
    accessibilityComponentType: "button",
    accessibilityRole: "button",
    accessibilityState: {
      disabled
    },
    disabled: disabled,
    children: /*#__PURE__*/_jsx(View, {
      style: [styles.switchButtonInner, {
        backgroundColor
      }],
      children: /*#__PURE__*/_jsx(Text, {
        maxFontSizeMultiplier: 1.5,
        selectable: false,
        style: [{
          ...textFont,
          color: color
        }],
        children: label
      })
    })
  });
}
const styles = StyleSheet.create({
  root: {
    width: 52,
    borderWidth: 1,
    overflow: 'hidden'
  },
  switchSeparator: {
    height: 1,
    width: 52
  },
  switchButtonInner: {
    flex: 1,
    alignItems: 'center',
    justifyContent: 'center'
  }
});
//# sourceMappingURL=AmPmSwitcher.js.map