"use strict";

import React, { memo } from 'react';
import { StyleSheet, View } from 'react-native';
import { Text, useTheme } from 'react-native-paper';
import { jsx as _jsx } from "react/jsx-runtime";
function DayName({
  label
}) {
  const theme = useTheme();
  let textFont = theme?.isV3 ? theme.fonts.bodySmall : theme.fonts.medium;
  return /*#__PURE__*/_jsx(View, {
    style: styles.dayName,
    children: /*#__PURE__*/_jsx(Text, {
      maxFontSizeMultiplier: 1.5,
      style: [styles.dayNameLabel, {
        ...textFont,
        color: theme.colors.onSurface
      }],
      selectable: false,
      children: label
    })
  });
}
const styles = StyleSheet.create({
  dayName: {
    alignItems: 'center',
    flex: 1
  },
  dayNameLabel: {
    fontSize: 14,
    opacity: 0.7
  }
});
export default /*#__PURE__*/memo(DayName);
//# sourceMappingURL=DayName.js.map