"use strict";

import Calendar from './Calendar';
import AnimatedCrossView from './AnimatedCrossView';
import DatePickerModalHeader from './DatePickerModalHeader';
import DatePickerModalContentHeader from './DatePickerModalContentHeader';
import CalendarEdit from './CalendarEdit';
import DatePickerModalHeaderBackground from './DatePickerModalHeaderBackground';
import { useTheme } from 'react-native-paper';
import DatePickerModalStatusBar from './DatePickerModalStatusBar';
import React, { memo, useCallback, useEffect, useState } from 'react';
import { jsx as _jsx, jsxs as _jsxs, Fragment as _Fragment } from "react/jsx-runtime";
export function DatePickerModalContent(props) {
  const {
    mode,
    onChange,
    onConfirm,
    onDismiss,
    disableSafeTop,
    disableStatusBar,
    disableWeekDays,
    locale,
    validRange,
    dateMode,
    startYear,
    endYear,
    statusBarOnTopOfBackdrop,
    startWeekOnMonday
  } = props;
  const theme = useTheme();
  const anyProps = props;
  const defaultUppercase = !theme.isV3;

  // use local state to add only onConfirm state changes
  const [state, setState] = useState({
    date: anyProps.date,
    startDate: anyProps.startDate,
    endDate: anyProps.endDate,
    dates: anyProps.dates
  });
  const [collapsed, setCollapsed] = useState(true);

  // update local state if changed from outside or if modal is opened
  useEffect(() => {
    setState({
      date: anyProps.date,
      startDate: anyProps.startDate,
      endDate: anyProps.endDate,
      dates: anyProps.dates
    });
  }, [anyProps.date, anyProps.startDate, anyProps.endDate, anyProps.dates]);
  const onInnerChange = useCallback(params => {
    onChange && onChange(params);
    setState(prev => ({
      ...prev,
      ...params
    }));
  }, [onChange, setState]);
  const onInnerConfirm = useCallback(() => {
    if (mode === 'single') {
      ;
      onConfirm({
        date: state.date
      });
    } else if (mode === 'range') {
      ;
      onConfirm({
        startDate: state.startDate,
        endDate: state.endDate
      });
    } else if (mode === 'multiple') {
      ;
      onConfirm({
        dates: state.dates || []
      });
    }
  }, [state, mode, onConfirm]);
  const onToggleCollapse = useCallback(() => {
    setCollapsed(prev => !prev);
  }, [setCollapsed]);
  return /*#__PURE__*/_jsxs(_Fragment, {
    children: [/*#__PURE__*/_jsxs(DatePickerModalHeaderBackground, {
      children: [/*#__PURE__*/_jsx(DatePickerModalStatusBar, {
        disableSafeTop: !!disableSafeTop,
        disableStatusBar: !!disableStatusBar,
        statusBarOnTopOfBackdrop: !!statusBarOnTopOfBackdrop
      }), /*#__PURE__*/_jsx(DatePickerModalHeader, {
        locale: locale,
        onSave: onInnerConfirm,
        onDismiss: onDismiss,
        saveLabel: props.saveLabel,
        saveLabelDisabled: props.saveLabelDisabled ?? false,
        uppercase: props.uppercase ?? defaultUppercase,
        closeIcon: props.closeIcon
      }), /*#__PURE__*/_jsx(DatePickerModalContentHeader, {
        state: state,
        mode: mode,
        collapsed: collapsed,
        onToggle: onToggleCollapse,
        headerSeparator: props.headerSeparator,
        emptyLabel: props.emptyLabel,
        label: props.label,
        moreLabel: props.moreLabel,
        startLabel: props.startLabel,
        endLabel: props.endLabel,
        uppercase: props.uppercase ?? defaultUppercase,
        locale: locale,
        editIcon: props?.editIcon,
        calendarIcon: props.calendarIcon,
        allowEditing: props.allowEditing ?? true
      })]
    }), /*#__PURE__*/_jsx(AnimatedCrossView, {
      collapsed: collapsed,
      calendar: /*#__PURE__*/_jsx(Calendar, {
        locale: locale,
        mode: mode,
        startDate: state.startDate,
        endDate: state.endDate,
        date: state.date,
        onChange: onInnerChange,
        disableWeekDays: disableWeekDays,
        dates: state.dates,
        validRange: validRange,
        dateMode: dateMode,
        startYear: startYear,
        endYear: endYear,
        startWeekOnMonday: startWeekOnMonday
      }),
      calendarEdit: /*#__PURE__*/_jsx(CalendarEdit, {
        mode: mode,
        state: state,
        label: props.label,
        startLabel: props.startLabel,
        endLabel: props.endLabel,
        collapsed: collapsed,
        onChange: onInnerChange,
        validRange: validRange,
        locale: locale,
        inputEnabled: props.inputEnabled,
        withDateFormatInLabel: props.withDateFormatInLabel,
        placeholder: props.placeholder
      })
    })]
  });
}
export default /*#__PURE__*/memo(DatePickerModalContent);
//# sourceMappingURL=DatePickerModalContent.js.map