"use strict";

import TextInputWithMask from '../TextInputMask';
import { HelperText, useTheme } from 'react-native-paper';
import { View, StyleSheet } from 'react-native';
import useDateInput from './inputUtils';
import React, { forwardRef } from 'react';
import { jsx as _jsx, jsxs as _jsxs, Fragment as _Fragment } from "react/jsx-runtime";
function DatePickerInputWithoutModal({
  label,
  value,
  onChange,
  style,
  locale,
  validRange,
  inputMode,
  withDateFormatInLabel = true,
  hasError,
  hideValidationErrors,
  onValidationError,
  modal,
  inputButton,
  saveLabel,
  saveLabelDisabled,
  uppercase,
  startYear,
  endYear,
  onChangeText,
  inputEnabled,
  disableStatusBarPadding,
  startWeekOnMonday,
  ...rest
}, ref) {
  const theme = useTheme();
  const {
    formattedValue,
    inputFormat,
    onChangeText: onDateInputChangeText,
    error
  } = useDateInput({
    locale,
    value,
    validRange,
    inputMode,
    onChange,
    onValidationError
  });
  let disabled;
  if (inputEnabled !== undefined) {
    disabled = !inputEnabled;
  }
  if (rest.disabled) {
    disabled = rest.disabled;
  }
  return /*#__PURE__*/_jsxs(_Fragment, {
    children: [/*#__PURE__*/_jsxs(View, {
      style: styles.root,
      children: [/*#__PURE__*/_jsx(View, {
        style: styles.inputContainer,
        children: /*#__PURE__*/_jsx(TextInputWithMask, {
          ...rest,
          ref: ref,
          label: getLabel({
            // TODO: support label components?
            label: label,
            inputFormat,
            withDateFormatInLabel
          }),
          value: formattedValue,
          keyboardType: rest.keyboardType ?? 'number-pad',
          mask: inputFormat,
          disabled: disabled,
          onChangeText: onDateInputChangeText,
          onChange: e => onChangeText && onChangeText(e.nativeEvent.text),
          keyboardAppearance: rest.keyboardAppearance ?? (theme.dark ? 'dark' : 'default'),
          error: !!error && !hideValidationErrors || !!hasError,
          style: [styles.input, style],
          inputButton: inputButton
        })
      }), error && !hideValidationErrors ? /*#__PURE__*/_jsx(HelperText, {
        type: "error",
        visible: !!error,
        children: error
      }) : null]
    }), modal?.({
      value,
      locale,
      inputMode,
      validRange,
      saveLabel,
      saveLabelDisabled,
      uppercase,
      startYear,
      endYear,
      inputEnabled,
      disableStatusBarPadding,
      startWeekOnMonday
    })]
  });
}
function getLabel({
  withDateFormatInLabel,
  inputFormat,
  label
}) {
  if (withDateFormatInLabel) {
    return label ? `${label} (${inputFormat})` : inputFormat;
  }
  return label || '';
}
const styles = StyleSheet.create({
  root: {
    flex: 1,
    flexGrow: 1,
    justifyContent: 'center',
    alignItems: 'flex-start',
    width: '100%'
  },
  inputContainer: {
    flexGrow: 1,
    flexDirection: 'row',
    alignItems: 'center',
    justifyContent: 'flex-start',
    width: '100%'
  },
  input: {
    flexGrow: 1,
    width: '100%'
  }
});
export default /*#__PURE__*/forwardRef(DatePickerInputWithoutModal);
//# sourceMappingURL=DatePickerInputWithoutModal.js.map