"use strict";

import { StyleSheet, View } from 'react-native';
import { IconButton, useTheme } from 'react-native-paper';
import DayNames, { dayNamesHeight } from './DayNames';
import { getTranslation } from '../translations/utils';
import { sharedStyles } from '../shared/styles';
import React, { memo } from 'react';
import { jsx as _jsx, jsxs as _jsxs } from "react/jsx-runtime";
const buttonContainerHeight = 56;
const buttonContainerMarginTop = 4;
const buttonContainerMarginBottom = 8;
export function getCalendarHeaderHeight(scrollMode) {
  if (scrollMode === 'horizontal') {
    return buttonContainerHeight + buttonContainerMarginTop + buttonContainerMarginBottom + dayNamesHeight;
  }
  return dayNamesHeight;
}
function CalendarHeader({
  scrollMode,
  onPrev,
  onNext,
  disableWeekDays,
  locale,
  startWeekOnMonday
}) {
  const isHorizontal = scrollMode === 'horizontal';
  const theme = useTheme();
  return /*#__PURE__*/_jsxs(View, {
    style: styles.datePickerHeader,
    pointerEvents: 'box-none',
    children: [isHorizontal ? /*#__PURE__*/_jsxs(View, {
      style: styles.buttonContainer,
      pointerEvents: 'box-none',
      children: [/*#__PURE__*/_jsx(View, {
        style: sharedStyles.root,
        pointerEvents: 'box-none'
      }), /*#__PURE__*/_jsx(View, {
        style: {
          backgroundColor: theme.colors.surface
        },
        children: /*#__PURE__*/_jsx(IconButton, {
          icon: "chevron-left",
          accessibilityLabel: getTranslation(locale, 'previous'),
          onPress: onPrev
        })
      }), /*#__PURE__*/_jsx(View, {
        style: {
          backgroundColor: theme.colors.surface
        },
        children: /*#__PURE__*/_jsx(IconButton, {
          icon: "chevron-right",
          accessibilityLabel: getTranslation(locale, 'next'),
          onPress: onNext
        })
      })]
    }) : null, /*#__PURE__*/_jsx(DayNames, {
      disableWeekDays: disableWeekDays,
      locale: locale,
      startWeekOnMonday: startWeekOnMonday
    })]
  });
}
const styles = StyleSheet.create({
  datePickerHeader: {
    position: 'absolute',
    top: 0,
    right: 0,
    left: 0,
    zIndex: 10
  },
  buttonContainer: {
    height: buttonContainerHeight,
    marginTop: buttonContainerMarginTop,
    marginBottom: buttonContainerMarginBottom,
    flexDirection: 'row',
    alignItems: 'center'
  }
});
export default /*#__PURE__*/memo(CalendarHeader);
//# sourceMappingURL=CalendarHeader.js.map