"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _reactNative = require("react-native");
var _reactNativePaper = require("react-native-paper");
var _color = _interopRequireDefault(require("color"));
var _timeUtils = require("./timeUtils");
var _react = _interopRequireWildcard(require("react"));
var _styles = require("../shared/styles");
var _jsxRuntime = require("react/jsx-runtime");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
function TimeInput({
  value,
  clockType,
  pressed,
  onPress,
  onChanged,
  inputType,
  inputFontSize = 57,
  ...rest
}, ref) {
  const theme = (0, _reactNativePaper.useTheme)();
  const [inputFocused, setInputFocused] = (0, _react.useState)(false);
  const [controlledValue, setControlledValue] = (0, _react.useState)(`${value}`);
  const highlighted = inputType === _timeUtils.inputTypes.picker ? pressed : inputFocused;
  const {
    color,
    backgroundColor
  } = (0, _timeUtils.useInputColors)(highlighted);
  (0, _react.useEffect)(() => {
    setControlledValue(`${value}`);
  }, [value]);
  const onInnerChange = number => {
    setControlledValue(`${number}`);
    if (number >= 0) {
      onChanged(Number(number));
    }
  };
  let formattedValue = controlledValue;
  if (!inputFocused) {
    formattedValue = controlledValue.length === 1 ? `0${controlledValue}` : `${controlledValue}`;
  }
  return /*#__PURE__*/(0, _jsxRuntime.jsxs)(_reactNative.View, {
    style: [styles.root,
    // eslint-disable-next-line react-native/no-inline-styles
    {
      backgroundColor,
      borderRadius: theme.roundness * 2,
      borderColor: theme.isV3 && highlighted ? theme.colors.onPrimaryContainer : undefined,
      borderWidth: theme.isV3 && highlighted ? 2 : 0,
      height: inputType === _timeUtils.inputTypes.keyboard ? 72 : 80
    }],
    children: [/*#__PURE__*/(0, _jsxRuntime.jsx)(_reactNative.TextInput, {
      ref: ref,
      textAlign: "center",
      style: [
      // eslint-disable-next-line react-native/no-inline-styles
      {
        color,
        fontFamily: theme?.isV3 ? theme.fonts.titleMedium.fontFamily : theme.fonts.medium.fontFamily,
        fontSize: inputFontSize,
        lineHeight: _reactNative.Platform.OS === 'android' ? Math.max(inputFontSize, 48) : undefined,
        paddingTop: _reactNative.Platform.OS === 'android' ? 10 : undefined,
        paddingBottom: _reactNative.Platform.OS === 'android' ? 0 : undefined
      }],
      maxFontSizeMultiplier: 1.5,
      value: formattedValue,
      maxLength: 2,
      onFocus: () => setInputFocused(true),
      onBlur: () => setInputFocused(false),
      keyboardAppearance: theme.dark ? 'dark' : 'default',
      keyboardType: "number-pad",
      onChangeText: e => onInnerChange(Number(e)),
      ...rest
    }), onPress && inputType === _timeUtils.inputTypes.picker ? /*#__PURE__*/(0, _jsxRuntime.jsx)(_reactNativePaper.TouchableRipple, {
      style: [_reactNative.StyleSheet.absoluteFill, _styles.sharedStyles.overflowHidden, {
        borderRadius: theme.roundness
      }],
      rippleColor: _reactNative.Platform.OS !== 'ios' ? (0, _color.default)(theme.colors.onSurface).fade(0.7).hex() : undefined,
      onPress: () => onPress(clockType),
      borderless: true,
      children: /*#__PURE__*/(0, _jsxRuntime.jsx)(_reactNative.View, {})
    }) : null]
  });
}
const styles = _reactNative.StyleSheet.create({
  root: {
    alignItems: 'center',
    justifyContent: 'center',
    width: 96
  }
});
var _default = exports.default = /*#__PURE__*/(0, _react.forwardRef)(TimeInput);
//# sourceMappingURL=TimeInput.js.map