"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = AmPmSwitcher;
var _reactNative = require("react-native");
var _reactNativePaper = require("react-native-paper");
var _react = _interopRequireWildcard(require("react"));
var _color = _interopRequireDefault(require("color"));
var _timeUtils = require("./timeUtils");
var _DisplayModeContext = require("../contexts/DisplayModeContext");
var _styles = require("../shared/styles");
var _jsxRuntime = require("react/jsx-runtime");
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function AmPmSwitcher({
  onChange,
  hours,
  inputType
}) {
  const theme = (0, _reactNativePaper.useTheme)();
  const {
    setMode,
    mode
  } = (0, _react.useContext)(_DisplayModeContext.DisplayModeContext);
  const backgroundColor = (0, _react.useMemo)(() => {
    if (theme.isV3) {
      return theme.colors.outline;
    }
    return (0, _color.default)(theme.dark ? (0, _color.default)(theme.colors.surface).lighten(1.2).hex() : theme.colors.surface).darken(0.1).hex();
  }, [theme]);
  const isAM = mode === 'AM';
  return /*#__PURE__*/(0, _jsxRuntime.jsxs)(_reactNative.View, {
    style: [styles.root,
    // eslint-disable-next-line react-native/no-inline-styles
    {
      borderColor: backgroundColor,
      borderRadius: theme.roundness * 2,
      height: inputType === _timeUtils.inputTypes.keyboard ? 72 : 80,
      marginBottom: inputType === 'keyboard' ? 16 : 0
    }],
    children: [/*#__PURE__*/(0, _jsxRuntime.jsx)(SwitchButton, {
      label: "AM",
      onPress: () => {
        setMode('AM');
        if (hours - 12 >= 0) {
          onChange(hours - 12);
        }
      },
      selected: isAM,
      disabled: isAM
    }), /*#__PURE__*/(0, _jsxRuntime.jsx)(_reactNative.View, {
      style: [styles.switchSeparator, {
        backgroundColor
      }]
    }), /*#__PURE__*/(0, _jsxRuntime.jsx)(SwitchButton, {
      label: "PM",
      onPress: () => {
        setMode('PM');
        if (hours + 12 <= 24) {
          onChange(hours + 12);
        }
      },
      selected: !isAM,
      disabled: !isAM
    })]
  });
}
function SwitchButton({
  label,
  onPress,
  selected,
  disabled
}) {
  const theme = (0, _reactNativePaper.useTheme)();
  const {
    backgroundColor,
    color
  } = (0, _timeUtils.useSwitchColors)(selected);
  let textFont = theme?.isV3 ? theme.fonts.titleMedium : theme.fonts.medium;
  return /*#__PURE__*/(0, _jsxRuntime.jsx)(_reactNativePaper.TouchableRipple, {
    onPress: onPress,
    style: _styles.sharedStyles.root,
    accessibilityLabel: label
    // @ts-ignore old React Native versions
    ,
    accessibilityTraits: disabled ? ['button', 'disabled'] : 'button'
    // @ts-ignore old React Native versions
    ,
    accessibilityComponentType: "button",
    accessibilityRole: "button",
    accessibilityState: {
      disabled
    },
    disabled: disabled,
    children: /*#__PURE__*/(0, _jsxRuntime.jsx)(_reactNative.View, {
      style: [styles.switchButtonInner, {
        backgroundColor
      }],
      children: /*#__PURE__*/(0, _jsxRuntime.jsx)(_reactNativePaper.Text, {
        maxFontSizeMultiplier: 1.5,
        selectable: false,
        style: [{
          ...textFont,
          color: color
        }],
        children: label
      })
    })
  });
}
const styles = _reactNative.StyleSheet.create({
  root: {
    width: 52,
    borderWidth: 1,
    overflow: 'hidden'
  },
  switchSeparator: {
    height: 1,
    width: 52
  },
  switchButtonInner: {
    flex: 1,
    alignItems: 'center',
    justifyContent: 'center'
  }
});
//# sourceMappingURL=AmPmSwitcher.js.map