"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _reactNative = require("react-native");
var _Month = require("./Month");
var _SwiperUtils = require("./SwiperUtils");
var _dateUtils = require("./dateUtils");
var _AutoSizer = _interopRequireDefault(require("./AutoSizer"));
var _react = _interopRequireWildcard(require("react"));
var _styles = require("../shared/styles");
var _jsxRuntime = require("react/jsx-runtime");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
function getVisibleArray(i, {
  isHorizontal,
  height
}) {
  if (isHorizontal || height < 700) {
    return [i - 1, i, i + 1];
  }
  return [i - 2, i - 1, i, i + 1, i + 2];
}
function Swiper(props) {
  return /*#__PURE__*/(0, _jsxRuntime.jsx)(_AutoSizer.default, {
    children: ({
      width,
      height
    }) => /*#__PURE__*/(0, _jsxRuntime.jsx)(SwiperInner, {
      ...props,
      width: width,
      height: height
    })
  });
}
function SwiperInner({
  scrollMode,
  renderItem,
  renderHeader,
  renderFooter,
  selectedYear,
  initialIndex,
  width,
  height,
  startWeekOnMonday
}) {
  const idx = (0, _react.useRef)(initialIndex);
  const isHorizontal = scrollMode === 'horizontal';
  const [visibleIndexes, setVisibleIndexes] = (0, _react.useState)(getVisibleArray(initialIndex, {
    isHorizontal,
    height
  }));
  const parentRef = (0, _react.useRef)(null);
  const scrollTo = (0, _react.useCallback)((index, animated) => {
    idx.current = index;
    setVisibleIndexes(getVisibleArray(index, {
      isHorizontal,
      height
    }));
    if (!parentRef.current) {
      return;
    }
    const offset = isHorizontal ? (0, _Month.getHorizontalMonthOffset)(index, width) : (0, _Month.getVerticalMonthsOffset)(index, startWeekOnMonday) - _Month.montHeaderHeight;
    if (isHorizontal) {
      parentRef.current.scrollTo({
        y: 0,
        x: offset,
        animated
      });
    } else {
      parentRef.current.scrollTo({
        y: offset,
        x: 0,
        animated
      });
    }
  }, [parentRef, isHorizontal, width, height, startWeekOnMonday]);
  const onPrev = (0, _react.useCallback)(() => {
    scrollTo(idx.current - 1, true);
  }, [scrollTo, idx]);
  const onNext = (0, _react.useCallback)(() => {
    scrollTo(idx.current + 1, true);
  }, [scrollTo, idx]);
  const scrollToInitial = (0, _react.useCallback)(() => {
    scrollTo(idx.current, false);
  }, [scrollTo]);
  const onMomentumScrollEnd = (0, _react.useCallback)(e => {
    const contentOffset = e.nativeEvent.contentOffset;
    const viewSize = e.nativeEvent.layoutMeasurement;
    const newIndex = isHorizontal ? Math.floor(contentOffset.x / viewSize.width) : (0, _Month.getIndexFromVerticalOffset)(contentOffset.y - _dateUtils.beginOffset, startWeekOnMonday);
    if (newIndex === 0) {
      return;
    }
    if (idx.current !== newIndex) {
      idx.current = newIndex;
      setVisibleIndexes(getVisibleArray(newIndex, {
        isHorizontal,
        height
      }));
    }
  }, [idx, height, isHorizontal, startWeekOnMonday]);
  const renderProps = {
    index: 0,
    onPrev,
    onNext
  };
  (0, _SwiperUtils.useYearChange)(newIndex => {
    if (newIndex) {
      scrollTo(newIndex, false);
    }
  }, {
    selectedYear,
    currentIndexRef: idx
  });
  return /*#__PURE__*/(0, _jsxRuntime.jsxs)(_jsxRuntime.Fragment, {
    children: [/*#__PURE__*/(0, _jsxRuntime.jsx)(_reactNative.ScrollView, {
      scrollsToTop: false,
      ref: parentRef,
      horizontal: isHorizontal,
      pagingEnabled: isHorizontal,
      style: _styles.sharedStyles.root,
      onMomentumScrollEnd: onMomentumScrollEnd,
      onScrollEndDrag: onMomentumScrollEnd,
      onLayout: scrollToInitial,
      showsHorizontalScrollIndicator: false,
      showsVerticalScrollIndicator: false,
      decelerationRate: "fast",
      scrollEventThrottle: 10,
      children: /*#__PURE__*/(0, _jsxRuntime.jsx)(_reactNative.View, {
        style: [styles.inner, {
          height: isHorizontal ? height : _dateUtils.estimatedMonthHeight * _dateUtils.totalMonths,
          width: isHorizontal ? width * _dateUtils.totalMonths : width
        }],
        children: visibleIndexes ? new Array(visibleIndexes.length).fill(undefined).map((_, vi) => /*#__PURE__*/(0, _jsxRuntime.jsx)(_reactNative.View, {
          // eslint-disable-next-line react-native/no-inline-styles
          style: {
            top: isHorizontal ? 0 : (0, _Month.getVerticalMonthsOffset)(visibleIndexes[vi], startWeekOnMonday),
            left: isHorizontal ? (0, _Month.getHorizontalMonthOffset)(visibleIndexes[vi], width) : 0,
            right: isHorizontal ? undefined : 0,
            bottom: isHorizontal ? 0 : undefined,
            position: 'absolute',
            width: isHorizontal ? width : undefined,
            height: isHorizontal ? undefined : (0, _Month.getMonthHeight)(scrollMode, visibleIndexes[vi], startWeekOnMonday)
          },
          children: renderItem({
            index: visibleIndexes[vi],
            onPrev: onPrev,
            onNext: onNext
          })
        }, vi)) : null
      })
    }), renderHeader && renderHeader(renderProps), renderFooter && renderFooter(renderProps)]
  });
}
const styles = _reactNative.StyleSheet.create({
  inner: {
    position: 'relative'
  }
});
var _default = exports.default = /*#__PURE__*/(0, _react.memo)(Swiper);
//# sourceMappingURL=Swiper.native.js.map