"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _reactNative = require("react-native");
var _dateUtils = require("./dateUtils");
var _react = _interopRequireWildcard(require("react"));
var _styles = require("../shared/styles");
var _jsxRuntime = require("react/jsx-runtime");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function DayRange({
  leftCrop,
  rightCrop,
  inRange,
  selectColor
}) {
  const bothWays = inRange && leftCrop && rightCrop;
  const isCrop = inRange && (leftCrop || rightCrop) && !(leftCrop && rightCrop);
  if (inRange || isCrop) {
    return /*#__PURE__*/(0, _jsxRuntime.jsx)(_reactNative.View, {
      pointerEvents: "none",
      style: [_reactNative.StyleSheet.absoluteFill, _styles.sharedStyles.flexDirectionRow, bothWays && styles.rangeRootBoth, inRange && !isCrop ? {
        backgroundColor: selectColor
      } : null],
      children: isCrop && /*#__PURE__*/(0, _jsxRuntime.jsxs)(_jsxRuntime.Fragment, {
        children: [/*#__PURE__*/(0, _jsxRuntime.jsx)(_reactNative.View, {
          style: [_styles.sharedStyles.root, rightCrop ? {
            backgroundColor: selectColor
          } : null]
        }), /*#__PURE__*/(0, _jsxRuntime.jsx)(_reactNative.View, {
          style: [{
            backgroundColor: selectColor,
            minWidth: _dateUtils.daySize,
            minHeight: _dateUtils.daySize
          }, leftCrop ? styles.leftRadius : null, rightCrop ? styles.rightRadius : null]
        }), /*#__PURE__*/(0, _jsxRuntime.jsx)(_reactNative.View, {
          style: [_styles.sharedStyles.root, leftCrop ? {
            backgroundColor: selectColor
          } : null]
        })]
      })
    });
  }
  return null;
}
const styles = _reactNative.StyleSheet.create({
  leftRadius: {
    borderBottomLeftRadius: _dateUtils.daySize / 2,
    borderTopLeftRadius: _dateUtils.daySize / 2
  },
  rightRadius: {
    borderBottomRightRadius: _dateUtils.daySize / 2,
    borderTopRightRadius: _dateUtils.daySize / 2
  },
  rangeRootBoth: {
    borderRadius: _dateUtils.daySize / 2
  }
});
var _default = exports.default = /*#__PURE__*/(0, _react.memo)(DayRange);
//# sourceMappingURL=DayRange.js.map