"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.HeaderContentMulti = HeaderContentMulti;
exports.HeaderContentRange = HeaderContentRange;
exports.HeaderContentSingle = HeaderContentSingle;
exports.default = DatePickerModalContentHeader;
var _reactNative = require("react-native");
var _reactNativePaper = require("react-native-paper");
var _utils = require("../shared/utils");
var _color = _interopRequireDefault(require("color"));
var _utils2 = require("../translations/utils");
var _react = _interopRequireWildcard(require("react"));
var _styles = require("../shared/styles");
var _jsxRuntime = require("react/jsx-runtime");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
function getLabel(locale, mode, configuredLabel) {
  if (configuredLabel) {
    return configuredLabel;
  }
  if (mode === 'range') {
    return (0, _utils2.getTranslation)(locale, 'selectRange');
  }
  if (mode === 'multiple') {
    return (0, _utils2.getTranslation)(locale, 'selectMultiple');
  }
  if (mode === 'single') {
    return (0, _utils2.getTranslation)(locale, 'selectSingle');
  }
  return '...?';
}
function DatePickerModalContentHeader(props) {
  const {
    onToggle,
    collapsed,
    mode,
    moreLabel,
    uppercase,
    editIcon,
    calendarIcon,
    allowEditing
  } = props;
  const theme = (0, _reactNativePaper.useTheme)();
  const label = getLabel(props.locale, props.mode, props.label);
  const color = (0, _utils.useHeaderTextColor)();
  const isEditingEnabled = allowEditing && mode !== 'multiple';
  const supportingTextColor = theme.isV3 ? theme.colors.onSurfaceVariant : color;
  const textFont = theme?.isV3 ? theme.fonts.labelMedium : theme.fonts.medium;
  const collapsedIcon = theme.isV3 ? 'pencil-outline' : 'pencil';
  const expandedIcon = theme.isV3 ? 'calendar-blank' : 'calendar';
  const finalCollapsedIcon = editIcon ?? collapsedIcon;
  const finalExpandedIcon = calendarIcon ?? expandedIcon;
  return /*#__PURE__*/(0, _jsxRuntime.jsxs)(_reactNative.View, {
    style: styles.header,
    children: [/*#__PURE__*/(0, _jsxRuntime.jsxs)(_reactNative.View, {
      children: [/*#__PURE__*/(0, _jsxRuntime.jsx)(_reactNativePaper.Text, {
        maxFontSizeMultiplier: 1.5,
        style: [styles.label, {
          color: supportingTextColor,
          ...textFont
        }],
        children: uppercase ? label.toUpperCase() : label
      }), /*#__PURE__*/(0, _jsxRuntime.jsxs)(_reactNative.View, {
        style: styles.headerContentContainer,
        children: [mode === 'range' ? /*#__PURE__*/(0, _jsxRuntime.jsx)(HeaderContentRange, {
          ...props,
          color: color
        }) : null, mode === 'single' ? /*#__PURE__*/(0, _jsxRuntime.jsx)(HeaderContentSingle, {
          ...props,
          color: color
        }) : null, mode === 'multiple' ? /*#__PURE__*/(0, _jsxRuntime.jsx)(HeaderContentMulti, {
          ...props,
          color: color,
          moreLabel: moreLabel
        }) : null]
      })]
    }), /*#__PURE__*/(0, _jsxRuntime.jsx)(_reactNative.View, {
      style: _styles.sharedStyles.root
    }), isEditingEnabled ? /*#__PURE__*/(0, _jsxRuntime.jsx)(_reactNativePaper.IconButton, {
      icon: collapsed ? finalCollapsedIcon : finalExpandedIcon,
      accessibilityLabel: collapsed ? (0, _utils2.getTranslation)(props.locale, 'typeInDate') : (0, _utils2.getTranslation)(props.locale, 'pickDateFromCalendar'),
      iconColor: theme.isV3 ? theme.colors.onSurface : color,
      onPress: onToggle
    }) : null]
  });
}
function HeaderContentSingle({
  state,
  emptyLabel = ' ',
  color,
  locale
}) {
  const theme = (0, _reactNativePaper.useTheme)();
  const lighterColor = (0, _color.default)(color).fade(0.5).rgb().toString();
  const dateColor = state.date ? theme.isV3 ? theme.colors.onSurface : color : lighterColor;
  const formatter = (0, _react.useMemo)(() => {
    return new Intl.DateTimeFormat(locale, {
      month: 'short',
      day: 'numeric'
    });
  }, [locale]);
  return /*#__PURE__*/(0, _jsxRuntime.jsx)(_reactNativePaper.Text, {
    maxFontSizeMultiplier: 1.5,
    style: [styles.text, {
      color: dateColor
    }],
    children: state.date ? formatter.format(state.date) : emptyLabel
  });
}
function HeaderContentMulti({
  state,
  emptyLabel = ' ',
  moreLabel = 'more',
  color,
  locale
}) {
  const theme = (0, _reactNativePaper.useTheme)();
  const dateCount = state.dates?.length || 0;
  const lighterColor = (0, _color.default)(color).fade(0.5).rgb().toString();
  const dateColor = dateCount ? theme.isV3 ? theme.colors.onSurface : color : lighterColor;
  const formatter = (0, _react.useMemo)(() => {
    return new Intl.DateTimeFormat(locale, {
      month: 'short',
      day: 'numeric'
    });
  }, [locale]);
  let label = emptyLabel;
  if (dateCount) {
    if (dateCount <= 2) {
      label = state.dates.map(date => formatter.format(date)).join(', ');
    } else {
      label = formatter.format(state.dates[0]) + ` (+ ${dateCount - 1} ${moreLabel})`;
    }
  }
  return /*#__PURE__*/(0, _jsxRuntime.jsx)(_reactNativePaper.Text, {
    maxFontSizeMultiplier: 1.5,
    style: [styles.text, {
      color: dateColor
    }],
    children: label
  });
}
function HeaderContentRange({
  locale,
  state,
  headerSeparator = '-',
  startLabel = 'Start',
  endLabel = 'End',
  color
}) {
  const theme = (0, _reactNativePaper.useTheme)();
  const lighterColor = (0, _color.default)(color).fade(0.5).rgb().toString();
  const startColorFilled = theme.isV3 ? theme.colors.onSurface : color;
  const endColorFilled = theme.isV3 ? theme.colors.onSurface : color;
  const startColor = state.startDate ? startColorFilled : lighterColor;
  const endColor = state.endDate ? endColorFilled : lighterColor;
  const formatter = (0, _react.useMemo)(() => {
    return new Intl.DateTimeFormat(locale, {
      month: 'short',
      day: 'numeric'
    });
  }, [locale]);
  return /*#__PURE__*/(0, _jsxRuntime.jsxs)(_jsxRuntime.Fragment, {
    children: [/*#__PURE__*/(0, _jsxRuntime.jsx)(_reactNativePaper.Text, {
      maxFontSizeMultiplier: 1.5,
      style: [styles.text, {
        color: startColor
      }],
      children: state.startDate ? formatter.format(state.startDate) : startLabel
    }), /*#__PURE__*/(0, _jsxRuntime.jsx)(_reactNativePaper.Text, {
      maxFontSizeMultiplier: 1.5,
      style: [styles.headerSeparator, {
        color
      }],
      children: headerSeparator
    }), /*#__PURE__*/(0, _jsxRuntime.jsx)(_reactNativePaper.Text, {
      maxFontSizeMultiplier: 1.5,
      style: [styles.text, {
        color: endColor
      }],
      children: state.endDate ? formatter.format(state.endDate) : endLabel
    })]
  });
}
const styles = _reactNative.StyleSheet.create({
  header: {
    height: 75,
    alignItems: 'center',
    flexDirection: 'row',
    paddingLeft: 24,
    paddingRight: 12
  },
  headerContentContainer: {
    flexDirection: 'row',
    marginTop: 5
  },
  headerSeparator: {
    color: 'rgba(255,255,255,1)',
    fontSize: 25,
    paddingLeft: 6,
    paddingRight: 6
  },
  label: {
    color: '#fff',
    fontSize: 13,
    letterSpacing: 1
  },
  text: {
    color: '#fff',
    fontSize: 25
  }
});
//# sourceMappingURL=DatePickerModalContentHeader.js.map