"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _TextInputMask = _interopRequireDefault(require("../TextInputMask"));
var _reactNativePaper = require("react-native-paper");
var _reactNative = require("react-native");
var _inputUtils = _interopRequireDefault(require("./inputUtils"));
var _react = _interopRequireWildcard(require("react"));
var _jsxRuntime = require("react/jsx-runtime");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
function DatePickerInputWithoutModal({
  label,
  value,
  onChange,
  style,
  locale,
  validRange,
  inputMode,
  withDateFormatInLabel = true,
  hasError,
  hideValidationErrors,
  onValidationError,
  modal,
  inputButton,
  saveLabel,
  saveLabelDisabled,
  uppercase,
  startYear,
  endYear,
  onChangeText,
  inputEnabled,
  disableStatusBarPadding,
  startWeekOnMonday,
  ...rest
}, ref) {
  const theme = (0, _reactNativePaper.useTheme)();
  const {
    formattedValue,
    inputFormat,
    onChangeText: onDateInputChangeText,
    error
  } = (0, _inputUtils.default)({
    locale,
    value,
    validRange,
    inputMode,
    onChange,
    onValidationError
  });
  let disabled;
  if (inputEnabled !== undefined) {
    disabled = !inputEnabled;
  }
  if (rest.disabled) {
    disabled = rest.disabled;
  }
  return /*#__PURE__*/(0, _jsxRuntime.jsxs)(_jsxRuntime.Fragment, {
    children: [/*#__PURE__*/(0, _jsxRuntime.jsxs)(_reactNative.View, {
      style: styles.root,
      children: [/*#__PURE__*/(0, _jsxRuntime.jsx)(_reactNative.View, {
        style: styles.inputContainer,
        children: /*#__PURE__*/(0, _jsxRuntime.jsx)(_TextInputMask.default, {
          ...rest,
          ref: ref,
          label: getLabel({
            // TODO: support label components?
            label: label,
            inputFormat,
            withDateFormatInLabel
          }),
          value: formattedValue,
          keyboardType: rest.keyboardType ?? 'number-pad',
          mask: inputFormat,
          disabled: disabled,
          onChangeText: onDateInputChangeText,
          onChange: e => onChangeText && onChangeText(e.nativeEvent.text),
          keyboardAppearance: rest.keyboardAppearance ?? (theme.dark ? 'dark' : 'default'),
          error: !!error && !hideValidationErrors || !!hasError,
          style: [styles.input, style],
          inputButton: inputButton
        })
      }), error && !hideValidationErrors ? /*#__PURE__*/(0, _jsxRuntime.jsx)(_reactNativePaper.HelperText, {
        type: "error",
        visible: !!error,
        children: error
      }) : null]
    }), modal?.({
      value,
      locale,
      inputMode,
      validRange,
      saveLabel,
      saveLabelDisabled,
      uppercase,
      startYear,
      endYear,
      inputEnabled,
      disableStatusBarPadding,
      startWeekOnMonday
    })]
  });
}
function getLabel({
  withDateFormatInLabel,
  inputFormat,
  label
}) {
  if (withDateFormatInLabel) {
    return label ? `${label} (${inputFormat})` : inputFormat;
  }
  return label || '';
}
const styles = _reactNative.StyleSheet.create({
  root: {
    flex: 1,
    flexGrow: 1,
    justifyContent: 'center',
    alignItems: 'flex-start',
    width: '100%'
  },
  inputContainer: {
    flexGrow: 1,
    flexDirection: 'row',
    alignItems: 'center',
    justifyContent: 'flex-start',
    width: '100%'
  },
  input: {
    flexGrow: 1,
    width: '100%'
  }
});
var _default = exports.default = /*#__PURE__*/(0, _react.forwardRef)(DatePickerInputWithoutModal);
//# sourceMappingURL=DatePickerInputWithoutModal.js.map