"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _reactNativePaper = require("react-native-paper");
var _DatePickerModal = _interopRequireDefault(require("./DatePickerModal"));
var _utils = require("../shared/utils");
var _DatePickerInputWithoutModal = _interopRequireDefault(require("./DatePickerInputWithoutModal"));
var _reactNative = require("react-native");
var _react = _interopRequireWildcard(require("react"));
var _jsxRuntime = require("react/jsx-runtime");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
function DatePickerInput({
  withModal = true,
  calendarIcon = 'calendar',
  animationType = _reactNative.Platform.select({
    web: 'none',
    default: 'slide'
  }),
  presentationStyle = 'overFullScreen',
  ...rest
}, ref) {
  const [visible, setVisible] = (0, _react.useState)(false);
  const onChangeRef = (0, _utils.useLatest)(rest.onChange);
  const onDismiss = (0, _react.useCallback)(() => {
    setVisible(false);
  }, [setVisible]);
  const onInnerConfirm = (0, _react.useCallback)(({
    date
  }) => {
    setVisible(false);
    onChangeRef.current(date);
  }, [setVisible, onChangeRef]);
  return /*#__PURE__*/(0, _jsxRuntime.jsx)(_DatePickerInputWithoutModal.default, {
    ref: ref,
    ...rest,
    inputButton: withModal ? /*#__PURE__*/(0, _jsxRuntime.jsx)(_reactNativePaper.TextInput.Icon, {
      size: rest.iconSize ?? 24,
      icon: calendarIcon,
      color: rest.iconColor ?? undefined,
      forceTextInputFocus: false,
      disabled: rest.disabled,
      onPress: () => setVisible(true),
      style: rest.iconStyle,
      testID: `${rest.testID || 'date-picker'}-icon-button`
    }) : null
    // eslint-disable-next-line react/no-unstable-nested-components
    ,
    modal: ({
      value,
      locale,
      inputMode,
      validRange,
      saveLabel,
      saveLabelDisabled,
      uppercase,
      startYear,
      endYear,
      inputEnabled,
      disableStatusBarPadding,
      startWeekOnMonday
    }) => withModal ? /*#__PURE__*/(0, _jsxRuntime.jsx)(_DatePickerModal.default, {
      date: value,
      mode: "single",
      visible: visible,
      onDismiss: onDismiss,
      onConfirm: onInnerConfirm,
      locale: locale,
      dateMode: inputMode,
      validRange: validRange,
      saveLabel: saveLabel,
      saveLabelDisabled: saveLabelDisabled ?? false,
      uppercase: uppercase,
      startYear: startYear ?? 1800,
      endYear: endYear ?? 2200,
      inputEnabled: inputEnabled,
      disableStatusBarPadding: disableStatusBarPadding ?? false,
      animationType: animationType,
      presentationStyle: presentationStyle,
      label: rest.label,
      startWeekOnMonday: startWeekOnMonday,
      withDateFormatInLabel: rest.withDateFormatInLabel,
      placeholder: rest.placeholder
    }) : null
  });
}
var _default = exports.default = /*#__PURE__*/(0, _react.forwardRef)(DatePickerInput);
//# sourceMappingURL=DatePickerInput.js.map