"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
exports.getCalendarHeaderHeight = getCalendarHeaderHeight;
var _reactNative = require("react-native");
var _reactNativePaper = require("react-native-paper");
var _DayNames = _interopRequireWildcard(require("./DayNames"));
var _utils = require("../translations/utils");
var _styles = require("../shared/styles");
var _react = _interopRequireWildcard(require("react"));
var _jsxRuntime = require("react/jsx-runtime");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const buttonContainerHeight = 56;
const buttonContainerMarginTop = 4;
const buttonContainerMarginBottom = 8;
function getCalendarHeaderHeight(scrollMode) {
  if (scrollMode === 'horizontal') {
    return buttonContainerHeight + buttonContainerMarginTop + buttonContainerMarginBottom + _DayNames.dayNamesHeight;
  }
  return _DayNames.dayNamesHeight;
}
function CalendarHeader({
  scrollMode,
  onPrev,
  onNext,
  disableWeekDays,
  locale,
  startWeekOnMonday
}) {
  const isHorizontal = scrollMode === 'horizontal';
  const theme = (0, _reactNativePaper.useTheme)();
  return /*#__PURE__*/(0, _jsxRuntime.jsxs)(_reactNative.View, {
    style: styles.datePickerHeader,
    pointerEvents: 'box-none',
    children: [isHorizontal ? /*#__PURE__*/(0, _jsxRuntime.jsxs)(_reactNative.View, {
      style: styles.buttonContainer,
      pointerEvents: 'box-none',
      children: [/*#__PURE__*/(0, _jsxRuntime.jsx)(_reactNative.View, {
        style: _styles.sharedStyles.root,
        pointerEvents: 'box-none'
      }), /*#__PURE__*/(0, _jsxRuntime.jsx)(_reactNative.View, {
        style: {
          backgroundColor: theme.colors.surface
        },
        children: /*#__PURE__*/(0, _jsxRuntime.jsx)(_reactNativePaper.IconButton, {
          icon: "chevron-left",
          accessibilityLabel: (0, _utils.getTranslation)(locale, 'previous'),
          onPress: onPrev
        })
      }), /*#__PURE__*/(0, _jsxRuntime.jsx)(_reactNative.View, {
        style: {
          backgroundColor: theme.colors.surface
        },
        children: /*#__PURE__*/(0, _jsxRuntime.jsx)(_reactNativePaper.IconButton, {
          icon: "chevron-right",
          accessibilityLabel: (0, _utils.getTranslation)(locale, 'next'),
          onPress: onNext
        })
      })]
    }) : null, /*#__PURE__*/(0, _jsxRuntime.jsx)(_DayNames.default, {
      disableWeekDays: disableWeekDays,
      locale: locale,
      startWeekOnMonday: startWeekOnMonday
    })]
  });
}
const styles = _reactNative.StyleSheet.create({
  datePickerHeader: {
    position: 'absolute',
    top: 0,
    right: 0,
    left: 0,
    zIndex: 10
  },
  buttonContainer: {
    height: buttonContainerHeight,
    marginTop: buttonContainerMarginTop,
    marginBottom: buttonContainerMarginBottom,
    flexDirection: 'row',
    alignItems: 'center'
  }
});
var _default = exports.default = /*#__PURE__*/(0, _react.memo)(CalendarHeader);
//# sourceMappingURL=CalendarHeader.js.map