"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = AutoSizer;
var _react = _interopRequireWildcard(require("react"));
var _reactNative = require("react-native");
var _styles = require("../shared/styles");
var _jsxRuntime = require("react/jsx-runtime");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function AutoSizer({
  children
}) {
  const [layout, setLayout] = (0, _react.useState)(null);
  const onLayout = (0, _react.useCallback)(event => {
    const nl = event.nativeEvent.layout;
    // https://github.com/necolas/react-native-web/issues/1704
    if (!layout || layout.width !== nl.width || layout.height !== nl.height) {
      setLayout({
        width: nl.width,
        height: nl.height
      });
    }
  }, [layout, setLayout]);
  return /*#__PURE__*/(0, _jsxRuntime.jsx)(_reactNative.View, {
    onLayout: onLayout,
    style: [_styles.sharedStyles.overflowHidden, _styles.sharedStyles.root, layout && layout],
    children: layout ? children(layout) : null
  });
}
//# sourceMappingURL=AutoSizer.js.map