"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true,
});
exports.matchSubpathFromExportsLike = matchSubpathFromExportsLike;
var _matchSubpathPattern = require("./matchSubpathPattern");
var _reduceExportsLikeMap = require("./reduceExportsLikeMap");
function matchSubpathFromExportsLike(
  context,
  subpath,
  exportsLikeMap,
  platform,
  createConfigError
) {
  const conditionNames = new Set([
    "default",
    context.isESMImport === true ? "import" : "require",
    ...context.unstable_conditionNames,
    ...(platform != null
      ? context.unstable_conditionsByPlatform[platform] ?? []
      : []),
  ]);
  const exportsLikeMapAfterConditions = (0,
  _reduceExportsLikeMap.reduceExportsLikeMap)(
    exportsLikeMap,
    conditionNames,
    createConfigError
  );
  let target = exportsLikeMapAfterConditions.get(subpath);
  let patternMatch = null;
  if (target == null) {
    const expansionKeys = [...exportsLikeMapAfterConditions.keys()]
      .filter((key) => key.includes("*"))
      .sort((key) => key.split("*")[0].length)
      .reverse();
    for (const key of expansionKeys) {
      const value = exportsLikeMapAfterConditions.get(key);
      if (typeof value === "string" && value.split("*").length !== 2) {
        break;
      }
      patternMatch = (0, _matchSubpathPattern.matchSubpathPattern)(
        key,
        subpath
      );
      if (patternMatch != null) {
        target = value;
        break;
      }
    }
  }
  return {
    target: target ?? null,
    patternMatch,
  };
}
