/**
 * Lighthouse v11.6.0 (Feb 21 2024)
 *
 * Automated auditing, performance metrics, and best practices for the web.
 *
 * @homepage https://github.com/GoogleChrome/lighthouse#readme
 * @author   Copyright 2023 Google LLC
 * @license  Apache-2.0
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except in compliance with the License. You may obtain a copy of the License at http://www.apache.org/licenses/LICENSE-2.0
 * Unless required by applicable law or agreed to in writing, software distributed under the License is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions and limitations under the License.
 */
"use strict";(()=>{var RV=Object.create;var Hu=Object.defineProperty;var _V=Object.getOwnPropertyDescriptor;var IV=Object.getOwnPropertyNames;var FV=Object.getPrototypeOf,NV=Object.prototype.hasOwnProperty;var s=(e,t)=>Hu(e,"name",{value:t,configurable:!0});var v=(e,t)=>()=>(e&&(t=e(e=0)),t);var P=(e,t)=>()=>(t||e((t={exports:{}}).exports,t),t.exports),T=(e,t)=>{for(var n in t)Hu(e,n,{get:t[n],enumerable:!0})},RR=(e,t,n,r)=>{if(t&&typeof t=="object"||typeof t=="function")for(let a of IV(t))!NV.call(e,a)&&a!==n&&Hu(e,a,{get:()=>t[a],enumerable:!(r=_V(t,a))||r.enumerable});return e};var Ht=(e,t,n)=>(n=e!=null?RV(FV(e)):{},RR(t||!e||!e.__esModule?Hu(n,"default",{value:e,enumerable:!0}):n,e)),MV=e=>RR(Hu({},"__esModule",{value:!0}),e);function _R(){throw new Error("setTimeout has not been defined")}function IR(){throw new Error("clearTimeout has not been defined")}function FR(e){if(Ja===setTimeout)return setTimeout(e,0);if((Ja===_R||!Ja)&&setTimeout)return Ja=setTimeout,setTimeout(e,0);try{return Ja(e,0)}catch{try{return Ja.call(null,e,0)}catch{return Ja.call(this,e,0)}}}function LV(e){if(Za===clearTimeout)return clearTimeout(e);if((Za===IR||!Za)&&clearTimeout)return Za=clearTimeout,clearTimeout(e);try{return Za(e)}catch{try{return Za.call(null,e)}catch{return Za.call(this,e)}}}function PV(){!gs||!ao||(gs=!1,ao.length?va=ao.concat(va):Vp=-1,va.length&&NR())}function NR(){if(!gs){var e=FR(PV);gs=!0;for(var t=va.length;t;){for(ao=va,va=[];++Vp<t;)ao&&ao[Vp].run();Vp=-1,t=va.length}ao=null,gs=!1,LV(e)}}function fn(e){var t=new Array(arguments.length-1);if(arguments.length>1)for(var n=1;n<arguments.length;n++)t[n-1]=arguments[n];va.push(new MR(e,t)),va.length===1&&!gs&&FR(NR)}function MR(e,t){this.fun=e,this.array=t}function io(){}
function QV(e){throw new Error("process.binding is not supported")}function e$(){return"/"}function t$(e){throw new Error("process.chdir is not supported")}function n$(){return 0}function a$(e){var t=r$.call(hs)*.001,n=Math.floor(t),r=Math.floor(t%1*1e9);return e&&(n=n-e[0],r=r-e[1],r<0&&(n--,r+=1e9)),[n,r]}function o$(){var e=new Date,t=e-i$;return t/1e3}var Ja,Za,va,gs,ao,Vp,OV,BV,UV,jV,qV,zV,HV,GV,WV,VV,$V,YV,KV,XV,JV,ZV,hs,r$,i$,hn,Qa=v(()=>{d();s(_R,"defaultSetTimout");s(IR,"defaultClearTimeout");Ja=_R,Za=IR;typeof globalThis.setTimeout=="function"&&(Ja=setTimeout);typeof globalThis.clearTimeout=="function"&&(Za=clearTimeout);s(FR,"runTimeout");s(LV,"runClearTimeout");va=[],gs=!1,Vp=-1;s(PV,"cleanUpNextTick");s(NR,"drainQueue");s(fn,"nextTick");s(MR,"Item");MR.prototype.run=function(){this.fun.apply(null,this.array)};OV="browser",BV="browser",UV=!0,jV={},qV=[],zV="",HV={},GV={},WV={};s(io,"noop");VV=io,$V=io,YV=io,KV=io,XV=io,JV=io,ZV=io;s(QV,"binding");s(e$,"cwd");s(t$,"chdir");s(
n$,"umask");hs=globalThis.performance||{},r$=hs.now||hs.mozNow||hs.msNow||hs.oNow||hs.webkitNow||function(){return new Date().getTime()};s(a$,"hrtime");i$=new Date;s(o$,"uptime");hn={nextTick:fn,title:OV,browser:UV,env:jV,argv:qV,version:zV,versions:HV,on:VV,addListener:$V,once:YV,off:KV,removeListener:XV,removeAllListeners:JV,emit:ZV,binding:QV,cwd:e$,chdir:t$,umask:n$,hrtime:a$,platform:BV,release:GV,config:WV,uptime:o$}});var d=v(()=>{"use strict";Qa();globalThis.process=hn});function BR(){by=!0;for(var e="ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/",t=0,n=e.length;t<n;++t)Br[t]=e[t],tr[e.charCodeAt(t)]=t;tr[45]=62,tr[95]=63}function c$(e){by||BR();var t,n,r,a,i,o,c=e.length;if(c%4>0)throw new Error("Invalid string. Length must be a multiple of 4");i=e[c-2]==="="?2:e[c-1]==="="?1:0,o=new s$(c*3/4-i),r=i>0?c-4:c;var u=0;for(t=0,n=0;t<r;t+=4,n+=3)a=tr[e.charCodeAt(t)]<<18|tr[e.charCodeAt(t+1)]<<12|tr[e.charCodeAt(t+2)]<<6|tr[e.charCodeAt(t+3)],o[u++]=a>>16&255,o[u++]=a>>8&255,o[u++]=a&255;return i===2?(a=tr[e.charCodeAt(t)]<<2|tr[e.charCodeAt(t+1)]>>4,o[u++]=a&255):i===1&&(a=tr[e.charCodeAt(t)]<<10|tr[e.charCodeAt(t+1)]<<4|tr[e.charCodeAt(t+2)]>>2,o[u++]=a>>8&255,o[u++]=a&255),o}function u$(e){return Br[e>>18&63]+Br[e>>12&63]+Br[e>>6&63]+Br[e&63]}function l$(e,t,n){for(var r,a=[],i=t;i<n;i+=3)r=(e[i]<<16)+(e[i+1]<<8)+e[i+2],a.push(u$(r));return a.join("")}function LR(e){by||BR();for(var t,n=e.length,r=n%3,a="",i=[],o=16383,c=0,u=n-r;c<u;c+=
o)i.push(l$(e,c,c+o>u?u:c+o));return r===1?(t=e[n-1],a+=Br[t>>2],a+=Br[t<<4&63],a+="=="):r===2&&(t=(e[n-2]<<8)+e[n-1],a+=Br[t>>10],a+=Br[t>>4&63],a+=Br[t<<2&63],a+="="),i.push(a),i.join("")}function Kp(e,t,n,r,a){var i,o,c=a*8-r-1,u=(1<<c)-1,l=u>>1,m=-7,p=n?a-1:0,h=n?-1:1,f=e[t+p];for(p+=h,i=f&(1<<-m)-1,f>>=-m,m+=c;m>0;i=i*256+e[t+p],p+=h,m-=8);for(o=i&(1<<-m)-1,i>>=-m,m+=r;m>0;o=o*256+e[t+p],p+=h,m-=8);if(i===0)i=1-l;else{if(i===u)return o?NaN:(f?-1:1)*(1/0);o=o+Math.pow(2,r),i=i-l}return(f?-1:1)*o*Math.pow(2,i-r)}function UR(e,t,n,r,a,i){var o,c,u,l=i*8-a-1,m=(1<<l)-1,p=m>>1,h=a===23?Math.pow(2,-24)-Math.pow(2,-77):0,f=r?0:i-1,g=r?1:-1,b=t<0||t===0&&1/t<0?1:0;for(t=Math.abs(t),isNaN(t)||t===1/0?(c=isNaN(t)?1:0,o=m):(o=Math.floor(Math.log(t)/Math.LN2),t*(u=Math.pow(2,-o))<1&&(o--,u*=2),o+p>=1?t+=h/u:t+=h*Math.pow(2,1-p),t*u>=2&&(o++,u/=2),o+p>=m?(c=0,o=m):o+p>=1?(c=(t*u-1)*Math.pow(2,a),o=o+p):(c=t*Math.pow(2,p-1)*Math.pow(2,a),o=0));a>=8;e[n+f]=c&255,f+=g,c/=256,a-=8);for(o=o<<a|c,l+=
a;l>0;e[n+f]=o&255,f+=g,o/=256,l-=8);e[n+f-g]|=b*128}function $p(){return z.TYPED_ARRAY_SUPPORT?2147483647:1073741823}function ba(e,t){if($p()<t)throw new RangeError("Invalid typed array length");return z.TYPED_ARRAY_SUPPORT?(e=new Uint8Array(t),e.__proto__=z.prototype):(e===null&&(e=new z(t)),e.length=t),e}function z(e,t,n){if(!z.TYPED_ARRAY_SUPPORT&&!(this instanceof z))return new z(e,t,n);if(typeof e=="number"){if(typeof t=="string")throw new Error("If encoding is specified then the first argument must be a string");return wy(this,e)}return qR(this,e,t,n)}function qR(e,t,n,r){if(typeof t=="number")throw new TypeError('"value" argument must not be a number');return typeof ArrayBuffer<"u"&&t instanceof ArrayBuffer?h$(e,t,n,r):typeof t=="string"?f$(e,t,n):g$(e,t)}function zR(e){if(typeof e!="number")throw new TypeError('"size" argument must be a number');if(e<0)throw new RangeError('"size" argument must not be negative')}function p$(e,t,n,r){return zR(t),t<=0?ba(e,t):n!==void 0?typeof r==
"string"?ba(e,t).fill(n,r):ba(e,t).fill(n):ba(e,t)}function wy(e,t){if(zR(t),e=ba(e,t<0?0:Dy(t)|0),!z.TYPED_ARRAY_SUPPORT)for(var n=0;n<t;++n)e[n]=0;return e}function f$(e,t,n){if((typeof n!="string"||n==="")&&(n="utf8"),!z.isEncoding(n))throw new TypeError('"encoding" must be a valid string encoding');var r=HR(t,n)|0;e=ba(e,r);var a=e.write(t,n);return a!==r&&(e=e.slice(0,a)),e}function vy(e,t){var n=t.length<0?0:Dy(t.length)|0;e=ba(e,n);for(var r=0;r<n;r+=1)e[r]=t[r]&255;return e}function h$(e,t,n,r){if(t.byteLength,n<0||t.byteLength<n)throw new RangeError("'offset' is out of bounds");if(t.byteLength<n+(r||0))throw new RangeError("'length' is out of bounds");return n===void 0&&r===void 0?t=new Uint8Array(t):r===void 0?t=new Uint8Array(t,n):t=new Uint8Array(t,n,r),z.TYPED_ARRAY_SUPPORT?(e=t,e.__proto__=z.prototype):e=vy(e,t),e}function g$(e,t){if(Ur(t)){var n=Dy(t.length)|0;return e=ba(e,n),e.length===0||t.copy(e,0,0,n),e}if(t){if(typeof ArrayBuffer<"u"&&t.buffer instanceof ArrayBuffer||
"length"in t)return typeof t.length!="number"||L$(t.length)?ba(e,0):vy(e,t);if(t.type==="Buffer"&&jR(t.data))return vy(e,t.data)}throw new TypeError("First argument must be a string, Buffer, ArrayBuffer, Array, or array-like object.")}function Dy(e){if(e>=$p())throw new RangeError("Attempt to allocate Buffer larger than maximum size: 0x"+$p().toString(16)+" bytes");return e|0}function Ur(e){return!!(e!=null&&e._isBuffer)}function HR(e,t){if(Ur(e))return e.length;if(typeof ArrayBuffer<"u"&&typeof ArrayBuffer.isView=="function"&&(ArrayBuffer.isView(e)||e instanceof ArrayBuffer))return e.byteLength;typeof e!="string"&&(e=""+e);var n=e.length;if(n===0)return 0;for(var r=!1;;)switch(t){case"ascii":case"latin1":case"binary":return n;case"utf8":case"utf-8":case void 0:return Yp(e).length;case"ucs2":case"ucs-2":case"utf16le":case"utf-16le":return n*2;case"hex":return n>>>1;case"base64":return XR(e).length;default:if(r)return Yp(e).length;t=(""+t).toLowerCase(),r=!0}}function y$(e,t,n){var r=!1;
if((t===void 0||t<0)&&(t=0),t>this.length||((n===void 0||n>this.length)&&(n=this.length),n<=0)||(n>>>=0,t>>>=0,n<=t))return"";for(e||(e="utf8");;)switch(e){case"hex":return k$(this,t,n);case"utf8":case"utf-8":return VR(this,t,n);case"ascii":return S$(this,t,n);case"latin1":case"binary":return C$(this,t,n);case"base64":return T$(this,t,n);case"ucs2":case"ucs-2":case"utf16le":case"utf-16le":return A$(this,t,n);default:if(r)throw new TypeError("Unknown encoding: "+e);e=(e+"").toLowerCase(),r=!0}}function oo(e,t,n){var r=e[t];e[t]=e[n],e[n]=r}function GR(e,t,n,r,a){if(e.length===0)return-1;if(typeof n=="string"?(r=n,n=0):n>2147483647?n=2147483647:n<-2147483648&&(n=-2147483648),n=+n,isNaN(n)&&(n=a?0:e.length-1),n<0&&(n=e.length+n),n>=e.length){if(a)return-1;n=e.length-1}else if(n<0)if(a)n=0;else return-1;if(typeof t=="string"&&(t=z.from(t,r)),Ur(t))return t.length===0?-1:PR(e,t,n,r,a);if(typeof t=="number")return t=t&255,z.TYPED_ARRAY_SUPPORT&&typeof Uint8Array.prototype.indexOf=="function"?
a?Uint8Array.prototype.indexOf.call(e,t,n):Uint8Array.prototype.lastIndexOf.call(e,t,n):PR(e,[t],n,r,a);throw new TypeError("val must be string, number or Buffer")}function PR(e,t,n,r,a){var i=1,o=e.length,c=t.length;if(r!==void 0&&(r=String(r).toLowerCase(),r==="ucs2"||r==="ucs-2"||r==="utf16le"||r==="utf-16le")){if(e.length<2||t.length<2)return-1;i=2,o/=2,c/=2,n/=2}function u(f,g){return i===1?f[g]:f.readUInt16BE(g*i)}s(u,"read");var l;if(a){var m=-1;for(l=n;l<o;l++)if(u(e,l)===u(t,m===-1?0:l-m)){if(m===-1&&(m=l),l-m+1===c)return m*i}else m!==-1&&(l-=l-m),m=-1}else for(n+c>o&&(n=o-c),l=n;l>=0;l--){for(var p=!0,h=0;h<c;h++)if(u(e,l+h)!==u(t,h)){p=!1;break}if(p)return l}return-1}function v$(e,t,n,r){n=Number(n)||0;var a=e.length-n;r?(r=Number(r),r>a&&(r=a)):r=a;var i=t.length;if(i%2!==0)throw new TypeError("Invalid hex string");r>i/2&&(r=i/2);for(var o=0;o<r;++o){var c=parseInt(t.substr(o*2,2),16);if(isNaN(c))return o;e[n+o]=c}return o}function b$(e,t,n,r){return Zp(Yp(t,e.length-n),e,
n,r)}function WR(e,t,n,r){return Zp(N$(t),e,n,r)}function w$(e,t,n,r){return WR(e,t,n,r)}function D$(e,t,n,r){return Zp(XR(t),e,n,r)}function E$(e,t,n,r){return Zp(M$(t,e.length-n),e,n,r)}function T$(e,t,n){return t===0&&n===e.length?LR(e):LR(e.slice(t,n))}function VR(e,t,n){n=Math.min(e.length,n);for(var r=[],a=t;a<n;){var i=e[a],o=null,c=i>239?4:i>223?3:i>191?2:1;if(a+c<=n){var u,l,m,p;switch(c){case 1:i<128&&(o=i);break;case 2:u=e[a+1],(u&192)===128&&(p=(i&31)<<6|u&63,p>127&&(o=p));break;case 3:u=e[a+1],l=e[a+2],(u&192)===128&&(l&192)===128&&(p=(i&15)<<12|(u&63)<<6|l&63,p>2047&&(p<55296||p>57343)&&(o=p));break;case 4:u=e[a+1],l=e[a+2],m=e[a+3],(u&192)===128&&(l&192)===128&&(m&192)===128&&(p=(i&15)<<18|(u&63)<<12|(l&63)<<6|m&63,p>65535&&p<1114112&&(o=p))}}o===null?(o=65533,c=1):o>65535&&(o-=65536,r.push(o>>>10&1023|55296),o=56320|o&1023),r.push(o),a+=c}return x$(r)}function x$(e){var t=e.length;if(t<=OR)return String.fromCharCode.apply(String,e);for(var n="",r=0;r<t;)n+=String.fromCharCode.
apply(String,e.slice(r,r+=OR));return n}function S$(e,t,n){var r="";n=Math.min(e.length,n);for(var a=t;a<n;++a)r+=String.fromCharCode(e[a]&127);return r}function C$(e,t,n){var r="";n=Math.min(e.length,n);for(var a=t;a<n;++a)r+=String.fromCharCode(e[a]);return r}function k$(e,t,n){var r=e.length;(!t||t<0)&&(t=0),(!n||n<0||n>r)&&(n=r);for(var a="",i=t;i<n;++i)a+=F$(e[i]);return a}function A$(e,t,n){for(var r=e.slice(t,n),a="",i=0;i<r.length;i+=2)a+=String.fromCharCode(r[i]+r[i+1]*256);return a}function rn(e,t,n){if(e%1!==0||e<0)throw new RangeError("offset is not uint");if(e+t>n)throw new RangeError("Trying to access beyond buffer length")}function Bn(e,t,n,r,a,i){if(!Ur(e))throw new TypeError('"buffer" argument must be a Buffer instance');if(t>a||t<i)throw new RangeError('"value" argument is out of bounds');if(n+r>e.length)throw new RangeError("Index out of range")}function Xp(e,t,n,r){t<0&&(t=65535+t+1);for(var a=0,i=Math.min(e.length-n,2);a<i;++a)e[n+a]=(t&255<<8*(r?a:1-a))>>>(r?a:1-a)*
8}function Jp(e,t,n,r){t<0&&(t=4294967295+t+1);for(var a=0,i=Math.min(e.length-n,4);a<i;++a)e[n+a]=t>>>(r?a:3-a)*8&255}function $R(e,t,n,r,a,i){if(n+r>e.length)throw new RangeError("Index out of range");if(n<0)throw new RangeError("Index out of range")}function YR(e,t,n,r,a){return a||$R(e,t,n,4),UR(e,t,n,r,23,4),n+4}function KR(e,t,n,r,a){return a||$R(e,t,n,8),UR(e,t,n,r,52,8),n+8}function _$(e){if(e=I$(e).replace(R$,""),e.length<2)return"";for(;e.length%4!==0;)e=e+"=";return e}function I$(e){return e.trim?e.trim():e.replace(/^\s+|\s+$/g,"")}function F$(e){return e<16?"0"+e.toString(16):e.toString(16)}function Yp(e,t){t=t||1/0;for(var n,r=e.length,a=null,i=[],o=0;o<r;++o){if(n=e.charCodeAt(o),n>55295&&n<57344){if(!a){if(n>56319){(t-=3)>-1&&i.push(239,191,189);continue}else if(o+1===r){(t-=3)>-1&&i.push(239,191,189);continue}a=n;continue}if(n<56320){(t-=3)>-1&&i.push(239,191,189),a=n;continue}n=(a-55296<<10|n-56320)+65536}else a&&(t-=3)>-1&&i.push(239,191,189);if(a=null,n<128){if((t-=1)<
0)break;i.push(n)}else if(n<2048){if((t-=2)<0)break;i.push(n>>6|192,n&63|128)}else if(n<65536){if((t-=3)<0)break;i.push(n>>12|224,n>>6&63|128,n&63|128)}else if(n<1114112){if((t-=4)<0)break;i.push(n>>18|240,n>>12&63|128,n>>6&63|128,n&63|128)}else throw new Error("Invalid code point")}return i}function N$(e){for(var t=[],n=0;n<e.length;++n)t.push(e.charCodeAt(n)&255);return t}function M$(e,t){for(var n,r,a,i=[],o=0;o<e.length&&!((t-=2)<0);++o)n=e.charCodeAt(o),r=n>>8,a=n%256,i.push(a),i.push(r);return i}function XR(e){return c$(_$(e))}function Zp(e,t,n,r){for(var a=0;a<r&&!(a+n>=t.length||a>=e.length);++a)t[a+n]=e[a];return a}function L$(e){return e!==e}function P$(e){return e!=null&&(!!e._isBuffer||JR(e)||O$(e))}function JR(e){return!!e.constructor&&typeof e.constructor.isBuffer=="function"&&e.constructor.isBuffer(e)}function O$(e){return typeof e.readFloatLE=="function"&&typeof e.slice=="function"&&JR(e.slice(0,0))}var Br,tr,s$,by,d$,jR,m$,g0e,OR,R$,ys=v(()=>{d();Br=[],tr=[],s$=typeof Uint8Array<
"u"?Uint8Array:Array,by=!1;s(BR,"init");s(c$,"toByteArray");s(u$,"tripletToBase64");s(l$,"encodeChunk");s(LR,"fromByteArray");s(Kp,"read");s(UR,"write");d$={}.toString,jR=Array.isArray||function(e){return d$.call(e)=="[object Array]"};m$=50;z.TYPED_ARRAY_SUPPORT=globalThis.TYPED_ARRAY_SUPPORT!==void 0?globalThis.TYPED_ARRAY_SUPPORT:!0;g0e=$p();s($p,"kMaxLength");s(ba,"createBuffer");s(z,"Buffer");z.poolSize=8192;z._augment=function(e){return e.__proto__=z.prototype,e};s(qR,"from");z.from=function(e,t,n){return qR(null,e,t,n)};z.TYPED_ARRAY_SUPPORT&&(z.prototype.__proto__=Uint8Array.prototype,z.__proto__=Uint8Array,typeof Symbol<"u"&&Symbol.species&&z[Symbol.species]);s(zR,"assertSize");s(p$,"alloc");z.alloc=function(e,t,n){return p$(null,e,t,n)};s(wy,"allocUnsafe");z.allocUnsafe=function(e){return wy(null,e)};z.allocUnsafeSlow=function(e){return wy(null,e)};s(f$,"fromString");s(vy,"fromArrayLike");s(h$,"fromArrayBuffer");s(g$,"fromObject");s(Dy,"checked");z.isBuffer=P$;s(Ur,"internalIs\
Buffer");z.compare=s(function(t,n){if(!Ur(t)||!Ur(n))throw new TypeError("Arguments must be Buffers");if(t===n)return 0;for(var r=t.length,a=n.length,i=0,o=Math.min(r,a);i<o;++i)if(t[i]!==n[i]){r=t[i],a=n[i];break}return r<a?-1:a<r?1:0},"compare");z.isEncoding=s(function(t){switch(String(t).toLowerCase()){case"hex":case"utf8":case"utf-8":case"ascii":case"latin1":case"binary":case"base64":case"ucs2":case"ucs-2":case"utf16le":case"utf-16le":return!0;default:return!1}},"isEncoding");z.concat=s(function(t,n){if(!jR(t))throw new TypeError('"list" argument must be an Array of Buffers');if(t.length===0)return z.alloc(0);var r;if(n===void 0)for(n=0,r=0;r<t.length;++r)n+=t[r].length;var a=z.allocUnsafe(n),i=0;for(r=0;r<t.length;++r){var o=t[r];if(!Ur(o))throw new TypeError('"list" argument must be an Array of Buffers');o.copy(a,i),i+=o.length}return a},"concat");s(HR,"byteLength");z.byteLength=HR;s(y$,"slowToString");z.prototype._isBuffer=!0;s(oo,"swap");z.prototype.swap16=s(function(){var t=this.
length;if(t%2!==0)throw new RangeError("Buffer size must be a multiple of 16-bits");for(var n=0;n<t;n+=2)oo(this,n,n+1);return this},"swap16");z.prototype.swap32=s(function(){var t=this.length;if(t%4!==0)throw new RangeError("Buffer size must be a multiple of 32-bits");for(var n=0;n<t;n+=4)oo(this,n,n+3),oo(this,n+1,n+2);return this},"swap32");z.prototype.swap64=s(function(){var t=this.length;if(t%8!==0)throw new RangeError("Buffer size must be a multiple of 64-bits");for(var n=0;n<t;n+=8)oo(this,n,n+7),oo(this,n+1,n+6),oo(this,n+2,n+5),oo(this,n+3,n+4);return this},"swap64");z.prototype.toString=s(function(){var t=this.length|0;return t===0?"":arguments.length===0?VR(this,0,t):y$.apply(this,arguments)},"toString");z.prototype.equals=s(function(t){if(!Ur(t))throw new TypeError("Argument must be a Buffer");return this===t?!0:z.compare(this,t)===0},"equals");z.prototype.inspect=s(function(){var t="",n=m$;return this.length>0&&(t=this.toString("hex",0,n).match(/.{2}/g).join(" "),this.length>
n&&(t+=" ... ")),"<Buffer "+t+">"},"inspect");z.prototype.compare=s(function(t,n,r,a,i){if(!Ur(t))throw new TypeError("Argument must be a Buffer");if(n===void 0&&(n=0),r===void 0&&(r=t?t.length:0),a===void 0&&(a=0),i===void 0&&(i=this.length),n<0||r>t.length||a<0||i>this.length)throw new RangeError("out of range index");if(a>=i&&n>=r)return 0;if(a>=i)return-1;if(n>=r)return 1;if(n>>>=0,r>>>=0,a>>>=0,i>>>=0,this===t)return 0;for(var o=i-a,c=r-n,u=Math.min(o,c),l=this.slice(a,i),m=t.slice(n,r),p=0;p<u;++p)if(l[p]!==m[p]){o=l[p],c=m[p];break}return o<c?-1:c<o?1:0},"compare");s(GR,"bidirectionalIndexOf");s(PR,"arrayIndexOf");z.prototype.includes=s(function(t,n,r){return this.indexOf(t,n,r)!==-1},"includes");z.prototype.indexOf=s(function(t,n,r){return GR(this,t,n,r,!0)},"indexOf");z.prototype.lastIndexOf=s(function(t,n,r){return GR(this,t,n,r,!1)},"lastIndexOf");s(v$,"hexWrite");s(b$,"utf8Write");s(WR,"asciiWrite");s(w$,"latin1Write");s(D$,"base64Write");s(E$,"ucs2Write");z.prototype.write=
s(function(t,n,r,a){if(n===void 0)a="utf8",r=this.length,n=0;else if(r===void 0&&typeof n=="string")a=n,r=this.length,n=0;else if(isFinite(n))n=n|0,isFinite(r)?(r=r|0,a===void 0&&(a="utf8")):(a=r,r=void 0);else throw new Error("Buffer.write(string, encoding, offset[, length]) is no longer supported");var i=this.length-n;if((r===void 0||r>i)&&(r=i),t.length>0&&(r<0||n<0)||n>this.length)throw new RangeError("Attempt to write outside buffer bounds");a||(a="utf8");for(var o=!1;;)switch(a){case"hex":return v$(this,t,n,r);case"utf8":case"utf-8":return b$(this,t,n,r);case"ascii":return WR(this,t,n,r);case"latin1":case"binary":return w$(this,t,n,r);case"base64":return D$(this,t,n,r);case"ucs2":case"ucs-2":case"utf16le":case"utf-16le":return E$(this,t,n,r);default:if(o)throw new TypeError("Unknown encoding: "+a);a=(""+a).toLowerCase(),o=!0}},"write");z.prototype.toJSON=s(function(){return{type:"Buffer",data:Array.prototype.slice.call(this._arr||this,0)}},"toJSON");s(T$,"base64Slice");s(VR,"utf8\
Slice");OR=4096;s(x$,"decodeCodePointsArray");s(S$,"asciiSlice");s(C$,"latin1Slice");s(k$,"hexSlice");s(A$,"utf16leSlice");z.prototype.slice=s(function(t,n){var r=this.length;t=~~t,n=n===void 0?r:~~n,t<0?(t+=r,t<0&&(t=0)):t>r&&(t=r),n<0?(n+=r,n<0&&(n=0)):n>r&&(n=r),n<t&&(n=t);var a;if(z.TYPED_ARRAY_SUPPORT)a=this.subarray(t,n),a.__proto__=z.prototype;else{var i=n-t;a=new z(i,void 0);for(var o=0;o<i;++o)a[o]=this[o+t]}return a},"slice");s(rn,"checkOffset");z.prototype.readUIntLE=s(function(t,n,r){t=t|0,n=n|0,r||rn(t,n,this.length);for(var a=this[t],i=1,o=0;++o<n&&(i*=256);)a+=this[t+o]*i;return a},"readUIntLE");z.prototype.readUIntBE=s(function(t,n,r){t=t|0,n=n|0,r||rn(t,n,this.length);for(var a=this[t+--n],i=1;n>0&&(i*=256);)a+=this[t+--n]*i;return a},"readUIntBE");z.prototype.readUInt8=s(function(t,n){return n||rn(t,1,this.length),this[t]},"readUInt8");z.prototype.readUInt16LE=s(function(t,n){return n||rn(t,2,this.length),this[t]|this[t+1]<<8},"readUInt16LE");z.prototype.readUInt16BE=
s(function(t,n){return n||rn(t,2,this.length),this[t]<<8|this[t+1]},"readUInt16BE");z.prototype.readUInt32LE=s(function(t,n){return n||rn(t,4,this.length),(this[t]|this[t+1]<<8|this[t+2]<<16)+this[t+3]*16777216},"readUInt32LE");z.prototype.readUInt32BE=s(function(t,n){return n||rn(t,4,this.length),this[t]*16777216+(this[t+1]<<16|this[t+2]<<8|this[t+3])},"readUInt32BE");z.prototype.readIntLE=s(function(t,n,r){t=t|0,n=n|0,r||rn(t,n,this.length);for(var a=this[t],i=1,o=0;++o<n&&(i*=256);)a+=this[t+o]*i;return i*=128,a>=i&&(a-=Math.pow(2,8*n)),a},"readIntLE");z.prototype.readIntBE=s(function(t,n,r){t=t|0,n=n|0,r||rn(t,n,this.length);for(var a=n,i=1,o=this[t+--a];a>0&&(i*=256);)o+=this[t+--a]*i;return i*=128,o>=i&&(o-=Math.pow(2,8*n)),o},"readIntBE");z.prototype.readInt8=s(function(t,n){return n||rn(t,1,this.length),this[t]&128?(255-this[t]+1)*-1:this[t]},"readInt8");z.prototype.readInt16LE=s(function(t,n){n||rn(t,2,this.length);var r=this[t]|this[t+1]<<8;return r&32768?r|4294901760:r},"rea\
dInt16LE");z.prototype.readInt16BE=s(function(t,n){n||rn(t,2,this.length);var r=this[t+1]|this[t]<<8;return r&32768?r|4294901760:r},"readInt16BE");z.prototype.readInt32LE=s(function(t,n){return n||rn(t,4,this.length),this[t]|this[t+1]<<8|this[t+2]<<16|this[t+3]<<24},"readInt32LE");z.prototype.readInt32BE=s(function(t,n){return n||rn(t,4,this.length),this[t]<<24|this[t+1]<<16|this[t+2]<<8|this[t+3]},"readInt32BE");z.prototype.readFloatLE=s(function(t,n){return n||rn(t,4,this.length),Kp(this,t,!0,23,4)},"readFloatLE");z.prototype.readFloatBE=s(function(t,n){return n||rn(t,4,this.length),Kp(this,t,!1,23,4)},"readFloatBE");z.prototype.readDoubleLE=s(function(t,n){return n||rn(t,8,this.length),Kp(this,t,!0,52,8)},"readDoubleLE");z.prototype.readDoubleBE=s(function(t,n){return n||rn(t,8,this.length),Kp(this,t,!1,52,8)},"readDoubleBE");s(Bn,"checkInt");z.prototype.writeUIntLE=s(function(t,n,r,a){if(t=+t,n=n|0,r=r|0,!a){var i=Math.pow(2,8*r)-1;Bn(this,t,n,r,i,0)}var o=1,c=0;for(this[n]=t&255;++c<
r&&(o*=256);)this[n+c]=t/o&255;return n+r},"writeUIntLE");z.prototype.writeUIntBE=s(function(t,n,r,a){if(t=+t,n=n|0,r=r|0,!a){var i=Math.pow(2,8*r)-1;Bn(this,t,n,r,i,0)}var o=r-1,c=1;for(this[n+o]=t&255;--o>=0&&(c*=256);)this[n+o]=t/c&255;return n+r},"writeUIntBE");z.prototype.writeUInt8=s(function(t,n,r){return t=+t,n=n|0,r||Bn(this,t,n,1,255,0),z.TYPED_ARRAY_SUPPORT||(t=Math.floor(t)),this[n]=t&255,n+1},"writeUInt8");s(Xp,"objectWriteUInt16");z.prototype.writeUInt16LE=s(function(t,n,r){return t=+t,n=n|0,r||Bn(this,t,n,2,65535,0),z.TYPED_ARRAY_SUPPORT?(this[n]=t&255,this[n+1]=t>>>8):Xp(this,t,n,!0),n+2},"writeUInt16LE");z.prototype.writeUInt16BE=s(function(t,n,r){return t=+t,n=n|0,r||Bn(this,t,n,2,65535,0),z.TYPED_ARRAY_SUPPORT?(this[n]=t>>>8,this[n+1]=t&255):Xp(this,t,n,!1),n+2},"writeUInt16BE");s(Jp,"objectWriteUInt32");z.prototype.writeUInt32LE=s(function(t,n,r){return t=+t,n=n|0,r||Bn(this,t,n,4,4294967295,0),z.TYPED_ARRAY_SUPPORT?(this[n+3]=t>>>24,this[n+2]=t>>>16,this[n+1]=t>>>8,
this[n]=t&255):Jp(this,t,n,!0),n+4},"writeUInt32LE");z.prototype.writeUInt32BE=s(function(t,n,r){return t=+t,n=n|0,r||Bn(this,t,n,4,4294967295,0),z.TYPED_ARRAY_SUPPORT?(this[n]=t>>>24,this[n+1]=t>>>16,this[n+2]=t>>>8,this[n+3]=t&255):Jp(this,t,n,!1),n+4},"writeUInt32BE");z.prototype.writeIntLE=s(function(t,n,r,a){if(t=+t,n=n|0,!a){var i=Math.pow(2,8*r-1);Bn(this,t,n,r,i-1,-i)}var o=0,c=1,u=0;for(this[n]=t&255;++o<r&&(c*=256);)t<0&&u===0&&this[n+o-1]!==0&&(u=1),this[n+o]=(t/c>>0)-u&255;return n+r},"writeIntLE");z.prototype.writeIntBE=s(function(t,n,r,a){if(t=+t,n=n|0,!a){var i=Math.pow(2,8*r-1);Bn(this,t,n,r,i-1,-i)}var o=r-1,c=1,u=0;for(this[n+o]=t&255;--o>=0&&(c*=256);)t<0&&u===0&&this[n+o+1]!==0&&(u=1),this[n+o]=(t/c>>0)-u&255;return n+r},"writeIntBE");z.prototype.writeInt8=s(function(t,n,r){return t=+t,n=n|0,r||Bn(this,t,n,1,127,-128),z.TYPED_ARRAY_SUPPORT||(t=Math.floor(t)),t<0&&(t=255+t+1),this[n]=t&255,n+1},"writeInt8");z.prototype.writeInt16LE=s(function(t,n,r){return t=+t,n=n|0,
r||Bn(this,t,n,2,32767,-32768),z.TYPED_ARRAY_SUPPORT?(this[n]=t&255,this[n+1]=t>>>8):Xp(this,t,n,!0),n+2},"writeInt16LE");z.prototype.writeInt16BE=s(function(t,n,r){return t=+t,n=n|0,r||Bn(this,t,n,2,32767,-32768),z.TYPED_ARRAY_SUPPORT?(this[n]=t>>>8,this[n+1]=t&255):Xp(this,t,n,!1),n+2},"writeInt16BE");z.prototype.writeInt32LE=s(function(t,n,r){return t=+t,n=n|0,r||Bn(this,t,n,4,2147483647,-2147483648),z.TYPED_ARRAY_SUPPORT?(this[n]=t&255,this[n+1]=t>>>8,this[n+2]=t>>>16,this[n+3]=t>>>24):Jp(this,t,n,!0),n+4},"writeInt32LE");z.prototype.writeInt32BE=s(function(t,n,r){return t=+t,n=n|0,r||Bn(this,t,n,4,2147483647,-2147483648),t<0&&(t=4294967295+t+1),z.TYPED_ARRAY_SUPPORT?(this[n]=t>>>24,this[n+1]=t>>>16,this[n+2]=t>>>8,this[n+3]=t&255):Jp(this,t,n,!1),n+4},"writeInt32BE");s($R,"checkIEEE754");s(YR,"writeFloat");z.prototype.writeFloatLE=s(function(t,n,r){return YR(this,t,n,!0,r)},"writeFloatLE");z.prototype.writeFloatBE=s(function(t,n,r){return YR(this,t,n,!1,r)},"writeFloatBE");s(KR,"w\
riteDouble");z.prototype.writeDoubleLE=s(function(t,n,r){return KR(this,t,n,!0,r)},"writeDoubleLE");z.prototype.writeDoubleBE=s(function(t,n,r){return KR(this,t,n,!1,r)},"writeDoubleBE");z.prototype.copy=s(function(t,n,r,a){if(r||(r=0),!a&&a!==0&&(a=this.length),n>=t.length&&(n=t.length),n||(n=0),a>0&&a<r&&(a=r),a===r||t.length===0||this.length===0)return 0;if(n<0)throw new RangeError("targetStart out of bounds");if(r<0||r>=this.length)throw new RangeError("sourceStart out of bounds");if(a<0)throw new RangeError("sourceEnd out of bounds");a>this.length&&(a=this.length),t.length-n<a-r&&(a=t.length-n+r);var i=a-r,o;if(this===t&&r<n&&n<a)for(o=i-1;o>=0;--o)t[o+n]=this[o+r];else if(i<1e3||!z.TYPED_ARRAY_SUPPORT)for(o=0;o<i;++o)t[o+n]=this[o+r];else Uint8Array.prototype.set.call(t,this.subarray(r,r+i),n);return i},"copy");z.prototype.fill=s(function(t,n,r,a){if(typeof t=="string"){if(typeof n=="string"?(a=n,n=0,r=this.length):typeof r=="string"&&(a=r,r=this.length),t.length===1){var i=t.charCodeAt(
0);i<256&&(t=i)}if(a!==void 0&&typeof a!="string")throw new TypeError("encoding must be a string");if(typeof a=="string"&&!z.isEncoding(a))throw new TypeError("Unknown encoding: "+a)}else typeof t=="number"&&(t=t&255);if(n<0||this.length<n||this.length<r)throw new RangeError("Out of range index");if(r<=n)return this;n=n>>>0,r=r===void 0?this.length:r>>>0,t||(t=0);var o;if(typeof t=="number")for(o=n;o<r;++o)this[o]=t;else{var c=Ur(t)?t:Yp(new z(t,a).toString()),u=c.length;for(o=0;o<r-n;++o)this[o+n]=c[o%u]}return this},"fill");R$=/[^+\/0-9A-Za-z-_]/g;s(_$,"base64clean");s(I$,"stringtrim");s(F$,"toHex");s(Yp,"utf8ToBytes");s(N$,"asciiToBytes");s(M$,"utf16leToBytes");s(XR,"base64ToBytes");s(Zp,"blitBuffer");s(L$,"isnan");s(P$,"isBuffer");s(JR,"isFastBuffer");s(O$,"isSlowBuffer")});function ei(){}function Ve(){Ve.init.call(this)}function ZR(e){return e._maxListeners===void 0?Ve.defaultMaxListeners:e._maxListeners}function B$(e,t,n){if(t)e.call(n);else for(var r=e.length,a=Gu(e,r),i=0;i<r;++i)a[i].call(n)}function U$(e,t,n,r){if(t)e.call(n,r);else for(var a=e.length,i=Gu(e,a),o=0;o<a;++o)i[o].call(n,r)}function j$(e,t,n,r,a){if(t)e.call(n,r,a);else for(var i=e.length,o=Gu(e,i),c=0;c<i;++c)o[c].call(n,r,a)}function q$(e,t,n,r,a,i){if(t)e.call(n,r,a,i);else for(var o=e.length,c=Gu(e,o),u=0;u<o;++u)c[u].call(n,r,a,i)}function z$(e,t,n,r){if(t)e.apply(n,r);else for(var a=e.length,i=Gu(e,a),o=0;o<a;++o)i[o].apply(n,r)}function QR(e,t,n,r){var a,i,o;if(typeof n!="function")throw new TypeError('"listener" argument must be a function');if(i=e._events,i?(i.newListener&&(e.emit("newListener",t,n.listener?n.listener:n),i=e._events),o=i[t]):(i=e._events=new ei,e._eventsCount=0),!o)o=i[t]=n,++e._eventsCount;else if(typeof o=="function"?o=i[t]=r?[n,o]:[o,n]:r?o.unshift(n):o.push(
n),!o.warned&&(a=ZR(e),a&&a>0&&o.length>a)){o.warned=!0;var c=new Error("Possible EventEmitter memory leak detected. "+o.length+" "+t+" listeners added. Use emitter.setMaxListeners() to increase limit");c.name="MaxListenersExceededWarning",c.emitter=e,c.type=t,c.count=o.length,H$(c)}return e}function H$(e){typeof console.warn=="function"?console.warn(e):console.log(e)}function e_(e,t,n){var r=!1;function a(){e.removeListener(t,a),r||(r=!0,n.apply(e,arguments))}return s(a,"g"),a.listener=n,a}function t_(e){var t=this._events;if(t){var n=t[e];if(typeof n=="function")return 1;if(n)return n.length}return 0}function G$(e,t){for(var n=t,r=n+1,a=e.length;r<a;n+=1,r+=1)e[n]=e[r];e.pop()}function Gu(e,t){for(var n=new Array(t);t--;)n[t]=e[t];return n}function W$(e){for(var t=new Array(e.length),n=0;n<t.length;++n)t[n]=e[n].listener||e[n];return t}var Ey,nr,wa=v(()=>{"use strict";d();s(ei,"EventHandlers");ei.prototype=Object.create(null);s(Ve,"EventEmitter");nr=Ve;Ve.EventEmitter=Ve;Ve.usingDomains=
!1;Ve.prototype.domain=void 0;Ve.prototype._events=void 0;Ve.prototype._maxListeners=void 0;Ve.defaultMaxListeners=10;Ve.init=function(){this.domain=null,Ve.usingDomains&&Ey.active&&!(this instanceof Ey.Domain)&&(this.domain=Ey.active),(!this._events||this._events===Object.getPrototypeOf(this)._events)&&(this._events=new ei,this._eventsCount=0),this._maxListeners=this._maxListeners||void 0};Ve.prototype.setMaxListeners=s(function(t){if(typeof t!="number"||t<0||isNaN(t))throw new TypeError('"n" argument must be a positive number');return this._maxListeners=t,this},"setMaxListeners");s(ZR,"$getMaxListeners");Ve.prototype.getMaxListeners=s(function(){return ZR(this)},"getMaxListeners");s(B$,"emitNone");s(U$,"emitOne");s(j$,"emitTwo");s(q$,"emitThree");s(z$,"emitMany");Ve.prototype.emit=s(function(t){var n,r,a,i,o,c,u,l=!1,m=t==="error";if(c=this._events,c)m=m&&c.error==null;else if(!m)return!1;if(u=this.domain,m){if(n=arguments[1],u)n||(n=new Error('Uncaught, unspecified "error" event')),
n.domainEmitter=this,n.domain=u,n.domainThrown=!1,u.emit("error",n);else{if(n instanceof Error)throw n;var p=new Error('Uncaught, unspecified "error" event. ('+n+")");throw p.context=n,p}return!1}if(r=c[t],!r)return!1;var h=typeof r=="function";switch(a=arguments.length,a){case 1:B$(r,h,this);break;case 2:U$(r,h,this,arguments[1]);break;case 3:j$(r,h,this,arguments[1],arguments[2]);break;case 4:q$(r,h,this,arguments[1],arguments[2],arguments[3]);break;default:for(i=new Array(a-1),o=1;o<a;o++)i[o-1]=arguments[o];z$(r,h,this,i)}return l&&u.exit(),!0},"emit");s(QR,"_addListener");s(H$,"emitWarning");Ve.prototype.addListener=s(function(t,n){return QR(this,t,n,!1)},"addListener");Ve.prototype.on=Ve.prototype.addListener;Ve.prototype.prependListener=s(function(t,n){return QR(this,t,n,!0)},"prependListener");s(e_,"_onceWrap");Ve.prototype.once=s(function(t,n){if(typeof n!="function")throw new TypeError('"listener" argument must be a function');return this.on(t,e_(this,t,n)),this},"once");Ve.prototype.
prependOnceListener=s(function(t,n){if(typeof n!="function")throw new TypeError('"listener" argument must be a function');return this.prependListener(t,e_(this,t,n)),this},"prependOnceListener");Ve.prototype.removeListener=s(function(t,n){var r,a,i,o,c;if(typeof n!="function")throw new TypeError('"listener" argument must be a function');if(a=this._events,!a)return this;if(r=a[t],!r)return this;if(r===n||r.listener&&r.listener===n)--this._eventsCount===0?this._events=new ei:(delete a[t],a.removeListener&&this.emit("removeListener",t,r.listener||n));else if(typeof r!="function"){for(i=-1,o=r.length;o-- >0;)if(r[o]===n||r[o].listener&&r[o].listener===n){c=r[o].listener,i=o;break}if(i<0)return this;if(r.length===1){if(r[0]=void 0,--this._eventsCount===0)return this._events=new ei,this;delete a[t]}else G$(r,i);a.removeListener&&this.emit("removeListener",t,c||n)}return this},"removeListener");Ve.prototype.off=function(e,t){return this.removeListener(e,t)};Ve.prototype.removeAllListeners=s(function(t){
var n,r;if(r=this._events,!r)return this;if(!r.removeListener)return arguments.length===0?(this._events=new ei,this._eventsCount=0):r[t]&&(--this._eventsCount===0?this._events=new ei:delete r[t]),this;if(arguments.length===0){for(var a=Object.keys(r),i=0,o;i<a.length;++i)o=a[i],o!=="removeListener"&&this.removeAllListeners(o);return this.removeAllListeners("removeListener"),this._events=new ei,this._eventsCount=0,this}if(n=r[t],typeof n=="function")this.removeListener(t,n);else if(n)do this.removeListener(t,n[n.length-1]);while(n[0]);return this},"removeAllListeners");Ve.prototype.listeners=s(function(t){var n,r,a=this._events;return a?(n=a[t],n?typeof n=="function"?r=[n.listener||n]:r=W$(n):r=[]):r=[],r},"listeners");Ve.listenerCount=function(e,t){return typeof e.listenerCount=="function"?e.listenerCount(t):t_.call(e,t)};Ve.prototype.listenerCount=t_;s(t_,"listenerCount");Ve.prototype.eventNames=s(function(){return this._eventsCount>0?Reflect.ownKeys(this._events):[]},"eventNames");s(
G$,"spliceOne");s(Gu,"arrayClone");s(W$,"unwrapListeners")});var r_=P((T0e,n_)=>{d();var vs=1e3,bs=vs*60,ws=bs*60,so=ws*24,V$=so*7,$$=so*365.25;n_.exports=function(e,t){t=t||{};var n=typeof e;if(n==="string"&&e.length>0)return Y$(e);if(n==="number"&&isFinite(e))return t.long?X$(e):K$(e);throw new Error("val is not a non-empty string or a valid number. val="+JSON.stringify(e))};function Y$(e){if(e=String(e),!(e.length>100)){var t=/^(-?(?:\d+)?\.?\d+) *(milliseconds?|msecs?|ms|seconds?|secs?|s|minutes?|mins?|m|hours?|hrs?|h|days?|d|weeks?|w|years?|yrs?|y)?$/i.exec(e);if(t){var n=parseFloat(t[1]),r=(t[2]||"ms").toLowerCase();switch(r){case"years":case"year":case"yrs":case"yr":case"y":return n*$$;case"weeks":case"week":case"w":return n*V$;case"days":case"day":case"d":return n*so;case"hours":case"hour":case"hrs":case"hr":case"h":return n*ws;case"minutes":case"minute":case"mins":case"min":case"m":return n*bs;case"seconds":case"second":case"secs":case"sec":case"s":return n*vs;case"milliseconds":case"millisecond":case"msecs":case"msec":case"ms":return n;default:
return}}}}s(Y$,"parse");function K$(e){var t=Math.abs(e);return t>=so?Math.round(e/so)+"d":t>=ws?Math.round(e/ws)+"h":t>=bs?Math.round(e/bs)+"m":t>=vs?Math.round(e/vs)+"s":e+"ms"}s(K$,"fmtShort");function X$(e){var t=Math.abs(e);return t>=so?Qp(e,t,so,"day"):t>=ws?Qp(e,t,ws,"hour"):t>=bs?Qp(e,t,bs,"minute"):t>=vs?Qp(e,t,vs,"second"):e+" ms"}s(X$,"fmtLong");function Qp(e,t,n,r){var a=t>=n*1.5;return Math.round(e/n)+" "+r+(a?"s":"")}s(Qp,"plural")});var i_=P((C0e,a_)=>{d();function J$(e){n.debug=n,n.default=n,n.coerce=u,n.disable=i,n.enable=a,n.enabled=o,n.humanize=r_(),n.destroy=l,Object.keys(e).forEach(m=>{n[m]=e[m]}),n.names=[],n.skips=[],n.formatters={};function t(m){let p=0;for(let h=0;h<m.length;h++)p=(p<<5)-p+m.charCodeAt(h),p|=0;return n.colors[Math.abs(p)%n.colors.length]}s(t,"selectColor"),n.selectColor=t;function n(m){let p,h=null,f,g;function b(...w){if(!b.enabled)return;let E=b,x=Number(new Date),S=x-(p||x);E.diff=S,E.prev=p,E.curr=x,p=x,w[0]=n.coerce(w[0]),typeof w[0]!="string"&&w.unshift("%O");let k=0;w[0]=w[0].replace(/%([a-zA-Z%])/g,(L,N)=>{if(L==="%%")return"%";k++;let $=n.formatters[N];if(typeof $=="function"){let re=w[k];L=$.call(E,re),w.splice(k,1),k--}return L}),n.formatArgs.call(E,w),(E.log||n.log).apply(E,w)}return s(b,"debug"),b.namespace=m,b.useColors=n.useColors(),b.color=n.selectColor(m),b.extend=r,b.destroy=n.destroy,Object.defineProperty(b,"enabled",{enumerable:!0,configurable:!1,get:()=>h!==null?h:(f!==
n.namespaces&&(f=n.namespaces,g=n.enabled(m)),g),set:w=>{h=w}}),typeof n.init=="function"&&n.init(b),b}s(n,"createDebug");function r(m,p){let h=n(this.namespace+(typeof p>"u"?":":p)+m);return h.log=this.log,h}s(r,"extend");function a(m){n.save(m),n.namespaces=m,n.names=[],n.skips=[];let p,h=(typeof m=="string"?m:"").split(/[\s,]+/),f=h.length;for(p=0;p<f;p++)h[p]&&(m=h[p].replace(/\*/g,".*?"),m[0]==="-"?n.skips.push(new RegExp("^"+m.slice(1)+"$")):n.names.push(new RegExp("^"+m+"$")))}s(a,"enable");function i(){let m=[...n.names.map(c),...n.skips.map(c).map(p=>"-"+p)].join(",");return n.enable(""),m}s(i,"disable");function o(m){if(m[m.length-1]==="*")return!0;let p,h;for(p=0,h=n.skips.length;p<h;p++)if(n.skips[p].test(m))return!1;for(p=0,h=n.names.length;p<h;p++)if(n.names[p].test(m))return!0;return!1}s(o,"enabled");function c(m){return m.toString().substring(2,m.toString().length-2).replace(/\.\*\?$/,"*")}s(c,"toNamespace");function u(m){return m instanceof Error?m.stack||m.message:m}s(
u,"coerce");function l(){console.warn("Instance method `debug.destroy()` is deprecated and no longer does anything. It will be removed in the next major version of `debug`.")}return s(l,"destroy"),n.enable(n.load()),n}s(J$,"setup");a_.exports=J$});var o_=P((Wn,ef)=>{d();Wn.formatArgs=Q$;Wn.save=eY;Wn.load=tY;Wn.useColors=Z$;Wn.storage=nY();Wn.destroy=(()=>{let e=!1;return()=>{e||(e=!0,console.warn("Instance method `debug.destroy()` is deprecated and no longer does anything. It will be removed in the next major version of `debug`."))}})();Wn.colors=["#0000CC","#0000FF","#0033CC","#0033FF","#0066CC","#0066FF","#0099CC","#0099FF","#00CC00","#00CC33","#00CC66","#00CC99","#00CCCC","#00CCFF","#3300CC","#3300FF","#3333CC","#3333FF","#3366CC","#3366FF","#3399CC","#3399FF","#33CC00","#33CC33","#33CC66","#33CC99","#33CCCC","#33CCFF","#6600CC","#6600FF","#6633CC","#6633FF","#66CC00","#66CC33","#9900CC","#9900FF","#9933CC","#9933FF","#99CC00","#99CC33","#CC0000","#CC0033","#CC0066","#CC0099","#CC00CC","#CC00FF","#CC3300","#CC3333","#CC3366","#CC3399","#CC33CC","#CC33FF","#CC6600","#CC6633","#CC9900","#CC9933","#CCCC00","#CCCC33","#FF0000","#FF0033","#FF0066","#FF0099","#FF00CC","#FF00FF","#FF3300","#FF3333","#FF3366","#FF3399","#FF33CC","#F\
F33FF","#FF6600","#FF6633","#FF9900","#FF9933","#FFCC00","#FFCC33"];function Z$(){return typeof window<"u"&&window.process&&(window.process.type==="renderer"||window.process.__nwjs)?!0:typeof navigator<"u"&&navigator.userAgent&&navigator.userAgent.toLowerCase().match(/(edge|trident)\/(\d+)/)?!1:typeof document<"u"&&document.documentElement&&document.documentElement.style&&document.documentElement.style.WebkitAppearance||typeof window<"u"&&window.console&&(window.console.firebug||window.console.exception&&window.console.table)||typeof navigator<"u"&&navigator.userAgent&&navigator.userAgent.toLowerCase().match(/firefox\/(\d+)/)&&parseInt(RegExp.$1,10)>=31||typeof navigator<"u"&&navigator.userAgent&&navigator.userAgent.toLowerCase().match(/applewebkit\/(\d+)/)}s(Z$,"useColors");function Q$(e){if(e[0]=(this.useColors?"%c":"")+this.namespace+(this.useColors?" %c":" ")+e[0]+(this.useColors?"%c ":" ")+"+"+ef.exports.humanize(this.diff),!this.useColors)return;let t="color: "+this.color;e.splice(
1,0,t,"color: inherit");let n=0,r=0;e[0].replace(/%[a-zA-Z%]/g,a=>{a!=="%%"&&(n++,a==="%c"&&(r=n))}),e.splice(r,0,t)}s(Q$,"formatArgs");Wn.log=console.debug||console.log||(()=>{});function eY(e){try{e?Wn.storage.setItem("debug",e):Wn.storage.removeItem("debug")}catch{}}s(eY,"save");function tY(){let e;try{e=Wn.storage.getItem("debug")}catch{}return!e&&typeof process<"u"&&"env"in process&&(e=process.env.DEBUG),e}s(tY,"load");function nY(){try{return localStorage}catch{}}s(nY,"localstorage");ef.exports=i_()(Wn);var{formatters:rY}=ef.exports;rY.j=function(e){try{return JSON.stringify(e)}catch(t){return"[UnexpectedJSONParseError]: "+t.message}}});function tf(e){if(!e)throw new Error("name must be non-empty")}function aY(e,t){for(var n=0,r=e.length,a;n<r;)a=n+r>>>1,e[a].startTime<t.startTime?n=a+1:r=a;e.splice(n,0,t)}var Cn,s_,af,of,Wu,sf,nf,rf,c_=v(()=>{d();Cn=typeof performance<"u"&&performance,s_=Cn&&Cn.now?function(){return Cn.now()}:function(){return Date.now()};s(tf,"throwIfEmpty");s(aY,"insertSorted");Cn&&Cn.mark&&Cn.getEntriesByName&&Cn.getEntriesByType&&Cn.clearMeasures?(af=s(function(e){tf(e),Cn.mark("start "+e)},"mark"),of=s(function(e){tf(e),Cn.mark("end "+e),Cn.measure(e,"start "+e,"end "+e);var t=Cn.getEntriesByName(e);return t[t.length-1]},"stop"),Wu=s(function(){return Cn.getEntriesByType("measure")},"getEntries"),sf=s(function(){Cn.clearMarks(),Cn.clearMeasures()},"clear")):(nf={},rf=[],af=s(function(e){tf(e);var t=s_();nf["$"+e]=t},"mark"),of=s(function(e){tf(e);var t=s_(),n=nf["$"+e];if(!n)throw new Error("no known mark: "+e);var r={startTime:n,name:e,duration:t-n,entryType:"measure"};return aY(rf,r),r},"stop"),
Wu=s(function(){return rf},"getEntries"),sf=s(function(){nf={},rf=[]},"clear"))});var ni,ti,Ds,Es,Ty,u_,oY,l_,Ts,F,Pe=v(()=>{d();Qa();wa();ni=Ht(o_());c_();ti=hn.platform==="win32",Ds=hn.browser,Es={red:Ds?"crimson":1,yellow:Ds?"gold":3,cyan:Ds?"darkturquoise":6,green:Ds?"forestgreen":2,blue:Ds?"steelblue":4,magenta:Ds?"palevioletred":5};ni.default.colors=[Es.cyan,Es.green,Es.blue,Es.magenta];Ty=class extends Ve{static{s(this,"Emitter")}issueStatus(t,n){(t==="status"||t==="statusEnd")&&this.emit(t,[t,...n])}issueWarning(t,n){this.emit("warning",[t,...n])}},u_={},oY=25,Ts=class e{static{s(this,"Log")}static _logToStdErr(t,n){e.loggerfn(t)(...n)}static loggerfn(t){t=`LH:${t}`;let n=u_[t];return n||(n=(0,ni.default)(t),u_[t]=n,t.endsWith("error")?n.color=Es.red:t.endsWith("warn")&&(n.color=Es.yellow)),n}static setLevel(t){switch(l_=t,t){case"silent":ni.default.enable("-LH:*");break;case"verbose":ni.default.enable("LH:*");break;case"warn":ni.default.enable("-LH:*, LH:*:warn, LH:*:error");break;case"error":ni.default.enable("-LH:*, LH:*:error");break;default:ni.default.enable(
"LH:*, -LH:*:verbose")}}static formatProtocol(t,n,r){let a=!hn||hn.browser?1/0:hn.stdout.columns,i=n.method||"?????",o=a-i.length-t.length-oY,c=n.params&&i!=="IO.read"?JSON.stringify(n.params).substr(0,o):"";e._logToStdErr(`${t}:${r||""}`,[i,c])}static isVerbose(){return l_==="verbose"}static time({msg:t,id:n,args:r=[]},a="log"){af(n),e[a]("status",t,...r)}static timeEnd({msg:t,id:n,args:r=[]},a="verbose"){e[a]("statusEnd",t,...r),of(n)}static log(t,...n){return e.events.issueStatus(t,n),e._logToStdErr(t,n)}static warn(t,...n){return e.events.issueWarning(t,n),e._logToStdErr(`${t}:warn`,n)}static error(t,...n){return e._logToStdErr(`${t}:error`,n)}static verbose(t,...n){return e.events.issueStatus(t,n),e._logToStdErr(`${t}:verbose`,n)}static greenify(t){return`${e.green}${t}${e.reset}`}static redify(t){return`${e.red}${t}${e.reset}`}static get green(){return"\x1B[32m"}static get red(){return"\x1B[31m"}static get yellow(){return"\x1B[33m"}static get purple(){return"\x1B[95m"}static get reset(){
return"\x1B[0m"}static get bold(){return"\x1B[1m"}static get dim(){return"\x1B[2m"}static get tick(){return ti?"√":"✓"}static get cross(){return ti?"×":"✘"}static get whiteSmallSquare(){return ti?"·":"▫"}static get heavyHorizontal(){return ti?"─":"━"}static get heavyVertical(){return ti?"│ ":"┃ "}static get heavyUpAndRight(){return ti?"└":"┗"}static get heavyVerticalAndRight(){return ti?"├":"┣"}static get heavyDownAndHorizontal(){return ti?"┬":"┳"}static get doubleLightHorizontal(){return"──"}};Ts.events=new Ty;Ts.takeTimeEntries=()=>{let e=Wu();return sf(),e};Ts.getTimeEntries=()=>Wu();F=Ts});var Yt=v(()=>{"use strict";d();});var xy,X,Ie=v(()=>{"use strict";d();Yt();xy=class{static{s(this,"BaseGatherer")}meta={supportedModes:[]};startInstrumentation(t){}startSensitiveInstrumentation(t){}stopSensitiveInstrumentation(t){}stopInstrumentation(t){}getArtifact(t){}},X=xy});var sY,cY,uY,lY,dY,mY,Kt,jr=v(()=>{"use strict";d();Pe();sY=/^(chrome|https?):/,cY=16,uY="RunTask",lY="ThreadControllerImpl::RunTask",dY="ThreadControllerImpl::DoWork",mY="TaskQueueManager::ProcessTaskFromWorkQueue",Kt=class e{static{s(this,"TraceProcessor")}static get TIMESPAN_MARKER_ID(){return"__lighthouseTimespanStart__"}static createNoNavstartError(){return new Error("No navigationStart event found")}static createNoResourceSendRequestError(){return new Error("No ResourceSendRequest event found")}static createNoTracingStartedError(){return new Error("No tracingStartedInBrowser event found")}static createNoFirstContentfulPaintError(){return new Error("No FirstContentfulPaint event found")}static createNoLighthouseMarkerError(){return new Error("No Lighthouse timespan marker event found")}static _isNavigationStartOfInterest(t){return t.name!=="navigationStart"?!1:t.args.data?.documentLoaderURL===void 0?!0:t.args.data?.documentLoaderURL?sY.test(t.args.data.documentLoaderURL):!1}static _sortTimestampEventGroup(t,n,r,a){
let i=s(p=>n[p],"lookupArrayIndexByTsIndex"),o=s(p=>a[i(p)],"lookupEventByTsIndex"),c=[],u=[],l=[];for(let p of t){let h=i(p),f=o(p);f.ph==="E"?c.push(h):f.ph==="X"||f.ph==="B"?u.push(h):l.push(h)}let m=new Map;for(let p of u){let h=a[p];if(h.ph==="X")m.set(p,h.dur);else{let f=Number.MAX_SAFE_INTEGER,g=0,b=r+t.length;for(let w=b;w<n.length;w++){let E=o(w);if(E.name===h.name&&E.pid===h.pid&&E.tid===h.tid)if(E.ph==="E"&&g===0){f=E.ts-h.ts;break}else E.ph==="E"?g--:E.ph==="B"&&g++}m.set(p,f)}}return u.sort((p,h)=>(m.get(h)||0)-(m.get(p)||0)||p-h),l.sort((p,h)=>p-h),[...c,...u,...l]}static filteredTraceSort(t,n){let r=[];for(let i=0;i<t.length;i++)n(t[i])&&r.push(i);r.sort((i,o)=>t[i].ts-t[o].ts);for(let i=0;i<r.length-1;i++){let o=t[r[i]].ts,c=[i];for(let l=i+1;l<r.length&&t[r[l]].ts===o;l++)c.push(l);if(c.length===1)continue;let u=e._sortTimestampEventGroup(c,r,i,t);r.splice(i,u.length,...u),i+=c.length-1}let a=[];for(let i=0;i<r.length;i++)a.push(t[r[i]]);return a}static assertHasToplevelEvents(t){
if(!t.some(this.isScheduleableTask))throw new Error("Could not find any top level events")}static _riskPercentiles(t,n,r,a=0){let i=0;for(let h=0;h<t.length;h++)i+=t[h];i-=a;let o=n-i,c=0,u=o,l=[],m=-1,p=t.length+1;a>0&&p--;for(let h of r){let f=h*n;for(;u<f&&m<t.length-1;)o+=c,p-=c<0?-1:1,a>0&&a<t[m+1]?(c=-a,a=0):(m++,c=t[m]),u=o+Math.abs(c)*p;l.push({percentile:h,time:Math.max(0,(f-o)/p)+cY})}return l}static getRiskToResponsiveness(t,n,r,a=[.5,.75,.9,.99,1]){let i=r-n;a.sort((c,u)=>c-u);let o=this.getMainThreadTopLevelEventDurations(t,n,r);return this._riskPercentiles(o.durations,i,a,o.clippedLength)}static getMainThreadTopLevelEventDurations(t,n=0,r=1/0){let a=[],i=0;for(let o of t){if(o.end<n||o.start>r)continue;let c=o.duration,u=o.start;u<n&&(u=n,c=o.end-n),o.end>r&&(i=c-(r-u)),a.push(c)}return a.sort((o,c)=>o-c),{durations:a,clippedLength:i}}static getMainThreadTopLevelEvents(t,n=0,r=1/0){let a=[];for(let i of t.mainThreadEvents){if(!this.isScheduleableTask(i)||!i.dur)continue;let o=(i.
ts-t.timeOriginEvt.ts)/1e3,c=(i.ts+i.dur-t.timeOriginEvt.ts)/1e3;o>r||c<n||a.push({start:o,end:c,duration:i.dur/1e3})}return a}static findMainFrameIds(t){let n=t.find(o=>o.name==="TracingStartedInBrowser");if(n?.args.data?.frames){let o=n.args.data.frames.find(l=>!l.parent),c=o?.frame,u=o?.processId;if(u&&c)return{startingPid:u,frameId:c}}let r=t.find(o=>o.name==="TracingStartedInPage");if(r?.args?.data){let o=r.args.data.page;if(o)return{startingPid:r.pid,frameId:o}}let a=t.find(o=>this._isNavigationStartOfInterest(o)&&o.args.data?.isLoadingMainFrame),i=t.find(o=>o.name==="ResourceSendRequest");if(a?.args?.data&&i&&i.pid===a.pid&&i.tid===a.tid){let o=a.args.frame;if(o)return{startingPid:a.pid,frameId:o}}throw this.createNoTracingStartedError()}static findMainFramePidTids(t,n){let r=n.filter(o=>(o.name==="FrameCommittedInBrowser"||o.name==="ProcessReadyInBrowser")&&o.args?.data?.frame===t.frameId&&o?.args?.data?.processId),a=r.length?r.map(o=>o?.args?.data?.processId):[t.startingPid],i=new Map;
for(let o of new Set(a)){let c=n.filter(m=>m.cat==="__metadata"&&m.pid===o&&m.ph==="M"&&m.name==="thread_name"),u=c.find(m=>m.args.name==="CrRendererMain");u||(u=c.find(m=>m.args.name==="CrBrowserMain"));let l=u?.tid;if(!l)throw new Error("Unable to determine tid for renderer process");i.set(o,l)}return i}static isScheduleableTask(t){return t.name===uY||t.name===lY||t.name===dY||t.name===mY}static isLCPEvent(t){return t.name!=="largestContentfulPaint::Invalidate"&&t.name!=="largestContentfulPaint::Candidate"?!1:!!t.args?.frame}static isLCPCandidateEvent(t){return!!(t.name==="largestContentfulPaint::Candidate"&&t.args?.frame&&t.args.data&&t.args.data.size!==void 0)}static getFrameId(t){return t.args?.data?.frame||t.args.data?.frameID||t.args.frame}static computeValidLCPAllFrames(t,n){let r=t.filter(this.isLCPEvent).reverse(),a=new Map;for(let o of r){if(o.ts<=n.ts)break;let c=o.args.frame;a.has(c)||a.set(c,o)}let i;for(let o of a.values())this.isLCPCandidateEvent(o)&&(!i||o.args.data.size>
i.args.data.size)&&(i=o);return{lcp:i,invalidated:!!(!i&&a.size)}}static resolveRootFrames(t){let n=new Map;for(let a of t)a.parent&&n.set(a.id,a.parent);let r=new Map;for(let a of t){let i=a.id;for(;n.has(i);)i=n.get(i);if(i===void 0)throw new Error("Unexpected undefined frameId");r.set(a.id,i)}return r}static processTrace(t,n){let{timeOriginDeterminationMethod:r="auto"}=n||{},a=this.filteredTraceSort(t.traceEvents,k=>k.cat.includes("blink.user_timing")||k.cat.includes("loading")||k.cat.includes("devtools.timeline")||k.cat==="__metadata"),i=this.findMainFrameIds(a),o=this.findMainFramePidTids(i,a),c=e.filteredTraceSort(t.traceEvents,k=>o.has(k.pid)),u=new Map,l=a.find(k=>k.name==="TracingStartedInBrowser")?.args?.data?.frames;if(l)for(let k of l)u.set(k.frame,{id:k.frame,url:k.url,parent:k.parent});a.filter(k=>!!(k.name==="FrameCommittedInBrowser"&&k.args.data?.frame&&k.args.data.url!==void 0)).forEach(k=>{u.set(k.args.data.frame,{id:k.args.data.frame,url:k.args.data.url,parent:k.args.
data.parent})});let m=[...u.values()],p=this.resolveRootFrames(m),h=[...p.entries()].filter(([,k])=>k===i.frameId).map(([k])=>k);function f(k){return e.getFrameId(k)===i.frameId}s(f,"associatedToMainFrame");function g(k){let A=e.getFrameId(k);return A?h.includes(A):!1}s(g,"associatedToAllFrames");let b=a.filter(k=>f(k)),w=[];p.has(i.frameId)?w=a.filter(k=>g(k)):(F.warn("TraceProcessor","frameTreeEvents may be incomplete, make sure the trace has frame events"),p.set(i.frameId,i.frameId),w=b);let E=this.computeTimeOrigin({keyEvents:a,frameEvents:b,mainFrameInfo:i},r),x=c.filter(k=>k.tid===o.get(k.pid)),S=this.computeTraceEnd(t.traceEvents,E);return{frames:m,mainThreadEvents:x,frameEvents:b,frameTreeEvents:w,processEvents:c,mainFrameInfo:i,timeOriginEvt:E,timings:{timeOrigin:0,traceEnd:S.timing},timestamps:{timeOrigin:E.ts,traceEnd:S.timestamp},_keyEvents:a,_rendererPidToTid:o}}static processNavigation(t){let{frameEvents:n,frameTreeEvents:r,timeOriginEvt:a,timings:i,timestamps:o}=t,c=this.
computeNavigationTimingsForFrame(n,{timeOriginEvt:a}),u=r.find(h=>h.name==="firstContentfulPaint"&&h.ts>a.ts);if(!u)throw this.createNoFirstContentfulPaintError();let l=this.computeValidLCPAllFrames(r,a).lcp,m=s(h=>(h-a.ts)/1e3,"getTiming"),p=s(h=>h===void 0?void 0:m(h),"maybeGetTiming");return{timings:{timeOrigin:i.timeOrigin,firstPaint:c.timings.firstPaint,firstContentfulPaint:c.timings.firstContentfulPaint,firstContentfulPaintAllFrames:m(u.ts),firstMeaningfulPaint:c.timings.firstMeaningfulPaint,largestContentfulPaint:c.timings.largestContentfulPaint,largestContentfulPaintAllFrames:p(l?.ts),load:c.timings.load,domContentLoaded:c.timings.domContentLoaded,traceEnd:i.traceEnd},timestamps:{timeOrigin:o.timeOrigin,firstPaint:c.timestamps.firstPaint,firstContentfulPaint:c.timestamps.firstContentfulPaint,firstContentfulPaintAllFrames:u.ts,firstMeaningfulPaint:c.timestamps.firstMeaningfulPaint,largestContentfulPaint:c.timestamps.largestContentfulPaint,largestContentfulPaintAllFrames:l?.ts,load:c.
timestamps.load,domContentLoaded:c.timestamps.domContentLoaded,traceEnd:o.traceEnd},firstPaintEvt:c.firstPaintEvt,firstContentfulPaintEvt:c.firstContentfulPaintEvt,firstContentfulPaintAllFramesEvt:u,firstMeaningfulPaintEvt:c.firstMeaningfulPaintEvt,largestContentfulPaintEvt:c.largestContentfulPaintEvt,largestContentfulPaintAllFramesEvt:l,loadEvt:c.loadEvt,domContentLoadedEvt:c.domContentLoadedEvt,fmpFellBack:c.fmpFellBack,lcpInvalidated:c.lcpInvalidated}}static computeTraceEnd(t,n){let r=-1/0;for(let a of t)r=Math.max(a.ts+(a.dur||0),r);return{timestamp:r,timing:(r-n.ts)/1e3}}static computeTimeOrigin(t,n){let r=s(()=>t.frameEvents.filter(this._isNavigationStartOfInterest).pop(),"lastNavigationStart"),a=s(()=>t.keyEvents.find(o=>o.name==="clock_sync"&&o.args.sync_id===e.TIMESPAN_MARKER_ID),"lighthouseMarker");switch(n){case"firstResourceSendRequest":{let i=t.keyEvents.find(o=>o.name!=="ResourceSendRequest"?!1:(o.args.data||{}).frame===t.mainFrameInfo.frameId);if(!i)throw this.createNoResourceSendRequestError();
return i}case"lastNavigationStart":{let i=r();if(!i)throw this.createNoNavstartError();return i}case"lighthouseMarker":{let i=a();if(!i)throw this.createNoLighthouseMarkerError();return i}case"auto":{let i=a()||r();if(!i)throw this.createNoNavstartError();return i}}}static computeNavigationTimingsForFrame(t,n){let{timeOriginEvt:r}=n,a=t.find(w=>w.name==="firstPaint"&&w.ts>r.ts),i=t.find(w=>w.name==="firstContentfulPaint"&&w.ts>r.ts);if(!i)throw this.createNoFirstContentfulPaintError();let o=t.find(w=>w.name==="firstMeaningfulPaint"&&w.ts>r.ts),c=!1;if(!o){let w="firstMeaningfulPaintCandidate";c=!0,F.verbose("TraceProcessor",`No firstMeaningfulPaint found, falling back to last ${w}`);let E=t.filter(x=>x.name===w).pop();E||F.verbose("TraceProcessor","No `firstMeaningfulPaintCandidate` events found in trace"),o=E}let u=this.computeValidLCPAllFrames(t,r),l=t.find(w=>w.name==="loadEventEnd"&&w.ts>r.ts),m=t.find(w=>w.name==="domContentLoadedEventEnd"&&w.ts>r.ts),p=s(w=>w?.ts,"getTimestamp"),
h={timeOrigin:r.ts,firstPaint:p(a),firstContentfulPaint:i.ts,firstMeaningfulPaint:p(o),largestContentfulPaint:p(u.lcp),load:p(l),domContentLoaded:p(m)},f=s(w=>(w-r.ts)/1e3,"getTiming"),g=s(w=>w===void 0?void 0:f(w),"maybeGetTiming");return{timings:{timeOrigin:0,firstPaint:g(h.firstPaint),firstContentfulPaint:f(h.firstContentfulPaint),firstMeaningfulPaint:g(h.firstMeaningfulPaint),largestContentfulPaint:g(h.largestContentfulPaint),load:g(h.load),domContentLoaded:g(h.domContentLoaded)},timestamps:h,timeOriginEvt:r,firstPaintEvt:a,firstContentfulPaintEvt:i,firstMeaningfulPaintEvt:o,largestContentfulPaintEvt:u.lcp,loadEvt:l,domContentLoadedEvt:m,fmpFellBack:c,lcpInvalidated:u.invalidated}}}});var d_={};T(d_,{default:()=>Dr});var Sy,Dr,co=v(()=>{"use strict";d();Ie();jr();Sy=class e extends X{static{s(this,"Trace")}_trace={traceEvents:[]};static getDefaultTraceCategories(){return["-*","disabled-by-default-lighthouse","loading","v8","v8.execute","blink.user_timing","blink.console","devtools.timeline","disabled-by-default-devtools.timeline","disabled-by-default-devtools.screenshot","disabled-by-default-devtools.timeline.stack","disabled-by-default-devtools.timeline.frame","latencyInfo","disabled-by-default-devtools.timeline.invalidationTracking"]}static async endTraceAndCollectEvents(t){let n=[],r=s(function(a){n.push(...a.value)},"dataListener");return t.on("Tracing.dataCollected",r),new Promise((a,i)=>{t.once("Tracing.tracingComplete",o=>{t.off("Tracing.dataCollected",r),a({traceEvents:n})}),t.sendCommand("Tracing.end").catch(i)})}static symbol=Symbol("Trace");meta={symbol:e.symbol,supportedModes:["timespan","navigation"]};async startSensitiveInstrumentation({driver:t,gatherMode:n,
settings:r}){let a=e.getDefaultTraceCategories().concat(r.additionalTraceCategories||[]);await t.defaultSession.sendCommand("Page.enable"),await t.defaultSession.sendCommand("Tracing.start",{categories:a.join(","),options:"sampling-frequency=10000"}),n==="timespan"&&await t.defaultSession.sendCommand("Tracing.recordClockSyncMarker",{syncId:Kt.TIMESPAN_MARKER_ID})}async stopSensitiveInstrumentation({driver:t}){this._trace=await e.endTraceAndCollectEvents(t.defaultSession)}getArtifact(){return this._trace}},Dr=Sy});var m_={};T(m_,{default:()=>Un});var Un,Da=v(()=>{d();Un={}});function p_(e,t){for(var n=0,r=e.length-1;r>=0;r--){var a=e[r];a==="."?e.splice(r,1):a===".."?(e.splice(r,1),n++):n&&(e.splice(r,1),n--)}if(t)for(;n--;n)e.unshift("..");return e}function Cy(){for(var e="",t=!1,n=arguments.length-1;n>=-1&&!t;n--){var r=n>=0?arguments[n]:"/";if(typeof r!="string")throw new TypeError("Arguments to path.resolve must be strings");if(!r)continue;e=r+"/"+e,t=r.charAt(0)==="/"}return e=p_(Ay(e.split("/"),function(a){return!!a}),!t).join("/"),(t?"/":"")+e||"."}function f_(e){var t=h_(e),n=DY(e,-1)==="/";return e=p_(Ay(e.split("/"),function(r){return!!r}),!t).join("/"),!e&&!t&&(e="."),e&&n&&(e+="/"),(t?"/":"")+e}function h_(e){return e.charAt(0)==="/"}function fY(){var e=Array.prototype.slice.call(arguments,0);return f_(Ay(e,function(t,n){if(typeof t!="string")throw new TypeError("Arguments to path.join must be strings");return t}).join("/"))}function hY(e,t){e=Cy(e).substr(1),t=Cy(t).substr(1);function n(l){for(var m=0;m<l.length&&l[m]==="";m++);for(var p=l.length-
1;p>=0&&l[p]==="";p--);return m>p?[]:l.slice(m,p-m+1)}s(n,"trim");for(var r=n(e.split("/")),a=n(t.split("/")),i=Math.min(r.length,a.length),o=i,c=0;c<i;c++)if(r[c]!==a[c]){o=c;break}for(var u=[],c=o;c<r.length;c++)u.push("..");return u=u.concat(a.slice(o)),u.join("/")}function vY(e){var t=ky(e),n=t[0],r=t[1];return!n&&!r?".":(r&&(r=r.substr(0,r.length-1)),n+r)}function bY(e,t){var n=ky(e)[2];return t&&n.substr(-1*t.length)===t&&(n=n.substr(0,n.length-t.length)),n}function wY(e){return ky(e)[3]}function Ay(e,t){if(e.filter)return e.filter(t);for(var n=[],r=0;r<e.length;r++)t(e[r],r,e)&&n.push(e[r]);return n}var pY,ky,gY,yY,Rt,DY,ri=v(()=>{d();s(p_,"normalizeArray");pY=/^(\/?|)([\s\S]*?)((?:\.{1,2}|[^\/]+?|)(\.[^.\/]*|))(?:[\/]*)$/,ky=s(function(e){return pY.exec(e).slice(1)},"splitPath");s(Cy,"resolve");s(f_,"normalize");s(h_,"isAbsolute");s(fY,"join");s(hY,"relative");gY="/",yY=":";s(vY,"dirname");s(bY,"basename");s(wY,"extname");Rt={extname:wY,basename:bY,dirname:vY,sep:gY,delimiter:yY,
relative:hY,join:fY,isAbsolute:h_,normalize:f_,resolve:Cy};s(Ay,"filter");DY="ab".substr(-1)==="b"?function(e,t,n){return e.substr(t,n)}:function(e,t,n){return t<0&&(t=e.length+t),e.substr(t,n)}});var y_=P((tDe,g_)=>{d();function EY(){this.__data__=[],this.size=0}s(EY,"listCacheClear");g_.exports=EY});var Ry=P((aDe,v_)=>{d();function TY(e,t){return e===t||e!==e&&t!==t}s(TY,"eq");v_.exports=TY});var Vu=P((sDe,b_)=>{d();var xY=Ry();function SY(e,t){for(var n=e.length;n--;)if(xY(e[n][0],t))return n;return-1}s(SY,"assocIndexOf");b_.exports=SY});var D_=P((lDe,w_)=>{d();var CY=Vu(),kY=Array.prototype,AY=kY.splice;function RY(e){var t=this.__data__,n=CY(t,e);if(n<0)return!1;var r=t.length-1;return n==r?t.pop():AY.call(t,n,1),--this.size,!0}s(RY,"listCacheDelete");w_.exports=RY});var T_=P((pDe,E_)=>{d();var _Y=Vu();function IY(e){var t=this.__data__,n=_Y(t,e);return n<0?void 0:t[n][1]}s(IY,"listCacheGet");E_.exports=IY});var S_=P((gDe,x_)=>{d();var FY=Vu();function NY(e){return FY(this.__data__,e)>-1}s(NY,"listCacheHas");x_.exports=NY});var k_=P((bDe,C_)=>{d();var MY=Vu();function LY(e,t){var n=this.__data__,r=MY(n,e);return r<0?(++this.size,n.push([e,t])):n[r][1]=t,this}s(LY,"listCacheSet");C_.exports=LY});var $u=P((EDe,A_)=>{d();var PY=y_(),OY=D_(),BY=T_(),UY=S_(),jY=k_();function xs(e){var t=-1,n=e==null?0:e.length;for(this.clear();++t<n;){var r=e[t];this.set(r[0],r[1])}}s(xs,"ListCache");xs.prototype.clear=PY;xs.prototype.delete=OY;xs.prototype.get=BY;xs.prototype.has=UY;xs.prototype.set=jY;A_.exports=xs});var __=P((SDe,R_)=>{d();var qY=$u();function zY(){this.__data__=new qY,this.size=0}s(zY,"stackClear");R_.exports=zY});var F_=P((ADe,I_)=>{d();function HY(e){var t=this.__data__,n=t.delete(e);return this.size=t.size,n}s(HY,"stackDelete");I_.exports=HY});var M_=P((IDe,N_)=>{d();function GY(e){return this.__data__.get(e)}s(GY,"stackGet");N_.exports=GY});var P_=P((MDe,L_)=>{d();function WY(e){return this.__data__.has(e)}s(WY,"stackHas");L_.exports=WY});var _y=P((ODe,O_)=>{d();var VY=typeof globalThis=="object"&&globalThis&&globalThis.Object===Object&&globalThis;O_.exports=VY});var qr=P((UDe,B_)=>{d();var $Y=_y(),YY=typeof self=="object"&&self&&self.Object===Object&&self,KY=$Y||YY||Function("return this")();B_.exports=KY});var cf=P((qDe,U_)=>{d();var XY=qr(),JY=XY.Symbol;U_.exports=JY});var H_=P((HDe,z_)=>{d();var j_=cf(),q_=Object.prototype,ZY=q_.hasOwnProperty,QY=q_.toString,Yu=j_?j_.toStringTag:void 0;function eK(e){var t=ZY.call(e,Yu),n=e[Yu];try{e[Yu]=void 0;var r=!0}catch{}var a=QY.call(e);return r&&(t?e[Yu]=n:delete e[Yu]),a}s(eK,"getRawTag");z_.exports=eK});var W_=P((VDe,G_)=>{d();var tK=Object.prototype,nK=tK.toString;function rK(e){return nK.call(e)}s(rK,"objectToString");G_.exports=rK});var Ku=P((KDe,Y_)=>{d();var V_=cf(),aK=H_(),iK=W_(),oK="[object Null]",sK="[object Undefined]",$_=V_?V_.toStringTag:void 0;function cK(e){return e==null?e===void 0?sK:oK:$_&&$_ in Object(e)?aK(e):iK(e)}s(cK,"baseGetTag");Y_.exports=cK});var Iy=P((ZDe,K_)=>{d();function uK(e){var t=typeof e;return e!=null&&(t=="object"||t=="function")}s(uK,"isObject");K_.exports=uK});var Fy=P((tEe,X_)=>{d();var lK=Ku(),dK=Iy(),mK="[object AsyncFunction]",pK="[object Function]",fK="[object GeneratorFunction]",hK="[object Proxy]";function gK(e){if(!dK(e))return!1;var t=lK(e);return t==pK||t==fK||t==mK||t==hK}s(gK,"isFunction");X_.exports=gK});var Z_=P((aEe,J_)=>{d();var yK=qr(),vK=yK["__core-js_shared__"];J_.exports=vK});var tI=P((oEe,eI)=>{d();var Ny=Z_(),Q_=function(){var e=/[^.]+$/.exec(Ny&&Ny.keys&&Ny.keys.IE_PROTO||"");return e?"Symbol(src)_1."+e:""}();function bK(e){return!!Q_&&Q_ in e}s(bK,"isMasked");eI.exports=bK});var My=P((uEe,nI)=>{d();var wK=Function.prototype,DK=wK.toString;function EK(e){if(e!=null){try{return DK.call(e)}catch{}try{return e+""}catch{}}return""}s(EK,"toSource");nI.exports=EK});var aI=P((mEe,rI)=>{d();var TK=Fy(),xK=tI(),SK=Iy(),CK=My(),kK=/[\\^$.*+?()[\]{}|]/g,AK=/^\[object .+?Constructor\]$/,RK=Function.prototype,_K=Object.prototype,IK=RK.toString,FK=_K.hasOwnProperty,NK=RegExp("^"+IK.call(FK).replace(kK,"\\$&").replace(/hasOwnProperty|(function).*?(?=\\\()| for .+?(?=\\\])/g,"$1.*?")+"$");function MK(e){if(!SK(e)||xK(e))return!1;var t=TK(e)?NK:AK;return t.test(CK(e))}s(MK,"baseIsNative");rI.exports=MK});var oI=P((hEe,iI)=>{d();function LK(e,t){return e?.[t]}s(LK,"getValue");iI.exports=LK});var uo=P((vEe,sI)=>{d();var PK=aI(),OK=oI();function BK(e,t){var n=OK(e,t);return PK(n)?n:void 0}s(BK,"getNative");sI.exports=BK});var uf=P((DEe,cI)=>{d();var UK=uo(),jK=qr(),qK=UK(jK,"Map");cI.exports=qK});var Xu=P((TEe,uI)=>{d();var zK=uo(),HK=zK(Object,"create");uI.exports=HK});var mI=P((SEe,dI)=>{d();var lI=Xu();function GK(){this.__data__=lI?lI(null):{},this.size=0}s(GK,"hashClear");dI.exports=GK});var fI=P((AEe,pI)=>{d();function WK(e){var t=this.has(e)&&delete this.__data__[e];return this.size-=t?1:0,t}s(WK,"hashDelete");pI.exports=WK});var gI=P((IEe,hI)=>{d();var VK=Xu(),$K="__lodash_hash_undefined__",YK=Object.prototype,KK=YK.hasOwnProperty;function XK(e){var t=this.__data__;if(VK){var n=t[e];return n===$K?void 0:n}return KK.call(t,e)?t[e]:void 0}s(XK,"hashGet");hI.exports=XK});var vI=P((MEe,yI)=>{d();var JK=Xu(),ZK=Object.prototype,QK=ZK.hasOwnProperty;function eX(e){var t=this.__data__;return JK?t[e]!==void 0:QK.call(t,e)}s(eX,"hashHas");yI.exports=eX});var wI=P((OEe,bI)=>{d();var tX=Xu(),nX="__lodash_hash_undefined__";function rX(e,t){var n=this.__data__;return this.size+=this.has(e)?0:1,n[e]=tX&&t===void 0?nX:t,this}s(rX,"hashSet");bI.exports=rX});var EI=P((jEe,DI)=>{d();var aX=mI(),iX=fI(),oX=gI(),sX=vI(),cX=wI();function Ss(e){var t=-1,n=e==null?0:e.length;for(this.clear();++t<n;){var r=e[t];this.set(r[0],r[1])}}s(Ss,"Hash");Ss.prototype.clear=aX;Ss.prototype.delete=iX;Ss.prototype.get=oX;Ss.prototype.has=sX;Ss.prototype.set=cX;DI.exports=Ss});var SI=P((HEe,xI)=>{d();var TI=EI(),uX=$u(),lX=uf();function dX(){this.size=0,this.__data__={hash:new TI,map:new(lX||uX),string:new TI}}s(dX,"mapCacheClear");xI.exports=dX});var kI=P((VEe,CI)=>{d();function mX(e){var t=typeof e;return t=="string"||t=="number"||t=="symbol"||t=="boolean"?e!=="__proto__":e===null}s(mX,"isKeyable");CI.exports=mX});var Ju=P((KEe,AI)=>{d();var pX=kI();function fX(e,t){var n=e.__data__;return pX(t)?n[typeof t=="string"?"string":"hash"]:n.map}s(fX,"getMapData");AI.exports=fX});var _I=P((ZEe,RI)=>{d();var hX=Ju();function gX(e){var t=hX(this,e).delete(e);return this.size-=t?1:0,t}s(gX,"mapCacheDelete");RI.exports=gX});var FI=P((tTe,II)=>{d();var yX=Ju();function vX(e){return yX(this,e).get(e)}s(vX,"mapCacheGet");II.exports=vX});var MI=P((aTe,NI)=>{d();var bX=Ju();function wX(e){return bX(this,e).has(e)}s(wX,"mapCacheHas");NI.exports=wX});var PI=P((sTe,LI)=>{d();var DX=Ju();function EX(e,t){var n=DX(this,e),r=n.size;return n.set(e,t),this.size+=n.size==r?0:1,this}s(EX,"mapCacheSet");LI.exports=EX});var Ly=P((lTe,OI)=>{d();var TX=SI(),xX=_I(),SX=FI(),CX=MI(),kX=PI();function Cs(e){var t=-1,n=e==null?0:e.length;for(this.clear();++t<n;){var r=e[t];this.set(r[0],r[1])}}s(Cs,"MapCache");Cs.prototype.clear=TX;Cs.prototype.delete=xX;Cs.prototype.get=SX;Cs.prototype.has=CX;Cs.prototype.set=kX;OI.exports=Cs});var UI=P((pTe,BI)=>{d();var AX=$u(),RX=uf(),_X=Ly(),IX=200;function FX(e,t){var n=this.__data__;if(n instanceof AX){var r=n.__data__;if(!RX||r.length<IX-1)return r.push([e,t]),this.size=++n.size,this;n=this.__data__=new _X(r)}return n.set(e,t),this.size=n.size,this}s(FX,"stackSet");BI.exports=FX});var qI=P((gTe,jI)=>{d();var NX=$u(),MX=__(),LX=F_(),PX=M_(),OX=P_(),BX=UI();function ks(e){var t=this.__data__=new NX(e);this.size=t.size}s(ks,"Stack");ks.prototype.clear=MX;ks.prototype.delete=LX;ks.prototype.get=PX;ks.prototype.has=OX;ks.prototype.set=BX;jI.exports=ks});var HI=P((bTe,zI)=>{d();var UX="__lodash_hash_undefined__";function jX(e){return this.__data__.set(e,UX),this}s(jX,"setCacheAdd");zI.exports=jX});var WI=P((ETe,GI)=>{d();function qX(e){return this.__data__.has(e)}s(qX,"setCacheHas");GI.exports=qX});var $I=P((STe,VI)=>{d();var zX=Ly(),HX=HI(),GX=WI();function lf(e){var t=-1,n=e==null?0:e.length;for(this.__data__=new zX;++t<n;)this.add(e[t])}s(lf,"SetCache");lf.prototype.add=lf.prototype.push=HX;lf.prototype.has=GX;VI.exports=lf});var KI=P((ATe,YI)=>{d();function WX(e,t){for(var n=-1,r=e==null?0:e.length;++n<r;)if(t(e[n],n,e))return!0;return!1}s(WX,"arraySome");YI.exports=WX});var JI=P((ITe,XI)=>{d();function VX(e,t){return e.has(t)}s(VX,"cacheHas");XI.exports=VX});var Py=P((MTe,ZI)=>{d();var $X=$I(),YX=KI(),KX=JI(),XX=1,JX=2;function ZX(e,t,n,r,a,i){var o=n&XX,c=e.length,u=t.length;if(c!=u&&!(o&&u>c))return!1;var l=i.get(e),m=i.get(t);if(l&&m)return l==t&&m==e;var p=-1,h=!0,f=n&JX?new $X:void 0;for(i.set(e,t),i.set(t,e);++p<c;){var g=e[p],b=t[p];if(r)var w=o?r(b,g,p,t,e,i):r(g,b,p,e,t,i);if(w!==void 0){if(w)continue;h=!1;break}if(f){if(!YX(t,function(E,x){if(!KX(f,x)&&(g===E||a(g,E,n,r,i)))return f.push(x)})){h=!1;break}}else if(!(g===b||a(g,b,n,r,i))){h=!1;break}}return i.delete(e),i.delete(t),h}s(ZX,"equalArrays");ZI.exports=ZX});var eF=P((OTe,QI)=>{d();var QX=qr(),eJ=QX.Uint8Array;QI.exports=eJ});var nF=P((UTe,tF)=>{d();function tJ(e){var t=-1,n=Array(e.size);return e.forEach(function(r,a){n[++t]=[a,r]}),n}s(tJ,"mapToArray");tF.exports=tJ});var aF=P((zTe,rF)=>{d();function nJ(e){var t=-1,n=Array(e.size);return e.forEach(function(r){n[++t]=r}),n}s(nJ,"setToArray");rF.exports=nJ});var uF=P((WTe,cF)=>{d();var iF=cf(),oF=eF(),rJ=Ry(),aJ=Py(),iJ=nF(),oJ=aF(),sJ=1,cJ=2,uJ="[object Boolean]",lJ="[object Date]",dJ="[object Error]",mJ="[object Map]",pJ="[object Number]",fJ="[object RegExp]",hJ="[object Set]",gJ="[object String]",yJ="[object Symbol]",vJ="[object ArrayBuffer]",bJ="[object DataView]",sF=iF?iF.prototype:void 0,Oy=sF?sF.valueOf:void 0;function wJ(e,t,n,r,a,i,o){switch(n){case bJ:if(e.byteLength!=t.byteLength||e.byteOffset!=t.byteOffset)return!1;e=e.buffer,t=t.buffer;case vJ:return!(e.byteLength!=t.byteLength||!i(new oF(e),new oF(t)));case uJ:case lJ:case pJ:return rJ(+e,+t);case dJ:return e.name==t.name&&e.message==t.message;case fJ:case gJ:return e==t+"";case mJ:var c=iJ;case hJ:var u=r&sJ;if(c||(c=oJ),e.size!=t.size&&!u)return!1;var l=o.get(e);if(l)return l==t;r|=cJ,o.set(e,t);var m=aJ(c(e),c(t),r,a,i,o);return o.delete(e),m;case yJ:if(Oy)return Oy.call(e)==Oy.call(t)}return!1}s(wJ,"equalByTag");cF.exports=wJ});var dF=P((YTe,lF)=>{d();function DJ(e,t){for(var n=-1,r=t.length,a=e.length;++n<r;)e[a+n]=t[n];return e}s(DJ,"arrayPush");lF.exports=DJ});var df=P((JTe,mF)=>{d();var EJ=Array.isArray;mF.exports=EJ});var fF=P((QTe,pF)=>{d();var TJ=dF(),xJ=df();function SJ(e,t,n){var r=t(e);return xJ(e)?r:TJ(r,n(e))}s(SJ,"baseGetAllKeys");pF.exports=SJ});var gF=P((nxe,hF)=>{d();function CJ(e,t){for(var n=-1,r=e==null?0:e.length,a=0,i=[];++n<r;){var o=e[n];t(o,n,e)&&(i[a++]=o)}return i}s(CJ,"arrayFilter");hF.exports=CJ});var vF=P((ixe,yF)=>{d();function kJ(){return[]}s(kJ,"stubArray");yF.exports=kJ});var DF=P((cxe,wF)=>{d();var AJ=gF(),RJ=vF(),_J=Object.prototype,IJ=_J.propertyIsEnumerable,bF=Object.getOwnPropertySymbols,FJ=bF?function(e){return e==null?[]:(e=Object(e),AJ(bF(e),function(t){return IJ.call(e,t)}))}:RJ;wF.exports=FJ});var TF=P((lxe,EF)=>{d();function NJ(e,t){for(var n=-1,r=Array(e);++n<e;)r[n]=t(n);return r}s(NJ,"baseTimes");EF.exports=NJ});var Zu=P((pxe,xF)=>{d();function MJ(e){return e!=null&&typeof e=="object"}s(MJ,"isObjectLike");xF.exports=MJ});var CF=P((gxe,SF)=>{d();var LJ=Ku(),PJ=Zu(),OJ="[object Arguments]";function BJ(e){return PJ(e)&&LJ(e)==OJ}s(BJ,"baseIsArguments");SF.exports=BJ});var _F=P((bxe,RF)=>{d();var kF=CF(),UJ=Zu(),AF=Object.prototype,jJ=AF.hasOwnProperty,qJ=AF.propertyIsEnumerable,zJ=kF(function(){return arguments}())?kF:function(e){return UJ(e)&&jJ.call(e,"callee")&&!qJ.call(e,"callee")};RF.exports=zJ});var FF=P((Dxe,IF)=>{d();function HJ(){return!1}s(HJ,"stubFalse");IF.exports=HJ});var By=P((Qu,As)=>{d();var GJ=qr(),WJ=FF(),LF=typeof Qu=="object"&&Qu&&!Qu.nodeType&&Qu,NF=LF&&typeof As=="object"&&As&&!As.nodeType&&As,VJ=NF&&NF.exports===LF,MF=VJ?GJ.Buffer:void 0,$J=MF?MF.isBuffer:void 0,YJ=$J||WJ;As.exports=YJ});var OF=P((Sxe,PF)=>{d();var KJ=9007199254740991,XJ=/^(?:0|[1-9]\d*)$/;function JJ(e,t){var n=typeof e;return t=t??KJ,!!t&&(n=="number"||n!="symbol"&&XJ.test(e))&&e>-1&&e%1==0&&e<t}s(JJ,"isIndex");PF.exports=JJ});var Uy=P((Axe,BF)=>{d();var ZJ=9007199254740991;function QJ(e){return typeof e=="number"&&e>-1&&e%1==0&&e<=ZJ}s(QJ,"isLength");BF.exports=QJ});var jF=P((Ixe,UF)=>{d();var eZ=Ku(),tZ=Uy(),nZ=Zu(),rZ="[object Arguments]",aZ="[object Array]",iZ="[object Boolean]",oZ="[object Date]",sZ="[object Error]",cZ="[object Function]",uZ="[object Map]",lZ="[object Number]",dZ="[object Object]",mZ="[object RegExp]",pZ="[object Set]",fZ="[object String]",hZ="[object WeakMap]",gZ="[object ArrayBuffer]",yZ="[object DataView]",vZ="[object Float32Array]",bZ="[object Float64Array]",wZ="[object Int8Array]",DZ="[object Int16Array]",EZ="[object Int32Array]",TZ="[object Uint8Array]",xZ="[object Uint8ClampedArray]",SZ="[object Uint16Array]",CZ="[object Uint32Array]",xt={};xt[vZ]=xt[bZ]=xt[wZ]=xt[DZ]=xt[EZ]=xt[TZ]=xt[xZ]=xt[SZ]=xt[CZ]=!0;xt[rZ]=xt[aZ]=xt[gZ]=xt[iZ]=xt[yZ]=xt[oZ]=xt[sZ]=xt[cZ]=xt[uZ]=xt[lZ]=xt[dZ]=xt[mZ]=xt[pZ]=xt[fZ]=xt[hZ]=!1;function kZ(e){return nZ(e)&&tZ(e.length)&&!!xt[eZ(e)]}s(kZ,"baseIsTypedArray");UF.exports=kZ});var zF=P((Mxe,qF)=>{d();function AZ(e){return function(t){return e(t)}}s(AZ,"baseUnary");qF.exports=AZ});var GF=P((el,Rs)=>{d();var RZ=_y(),HF=typeof el=="object"&&el&&!el.nodeType&&el,tl=HF&&typeof Rs=="object"&&Rs&&!Rs.nodeType&&Rs,_Z=tl&&tl.exports===HF,jy=_Z&&RZ.process,IZ=function(){try{var e=tl&&tl.require&&tl.require("util").types;return e||jy&&jy.binding&&jy.binding("util")}catch{}}();Rs.exports=IZ});var qy=P((Bxe,$F)=>{d();var FZ=jF(),NZ=zF(),WF=GF(),VF=WF&&WF.isTypedArray,MZ=VF?NZ(VF):FZ;$F.exports=MZ});var KF=P((jxe,YF)=>{d();var LZ=TF(),PZ=_F(),OZ=df(),BZ=By(),UZ=OF(),jZ=qy(),qZ=Object.prototype,zZ=qZ.hasOwnProperty;function HZ(e,t){var n=OZ(e),r=!n&&PZ(e),a=!n&&!r&&BZ(e),i=!n&&!r&&!a&&jZ(e),o=n||r||a||i,c=o?LZ(e.length,String):[],u=c.length;for(var l in e)(t||zZ.call(e,l))&&!(o&&(l=="length"||a&&(l=="offset"||l=="parent")||i&&(l=="buffer"||l=="byteLength"||l=="byteOffset")||UZ(l,u)))&&c.push(l);return c}s(HZ,"arrayLikeKeys");YF.exports=HZ});var JF=P((Hxe,XF)=>{d();var GZ=Object.prototype;function WZ(e){var t=e&&e.constructor,n=typeof t=="function"&&t.prototype||GZ;return e===n}s(WZ,"isPrototype");XF.exports=WZ});var QF=P((Vxe,ZF)=>{d();function VZ(e,t){return function(n){return e(t(n))}}s(VZ,"overArg");ZF.exports=VZ});var tN=P((Kxe,eN)=>{d();var $Z=QF(),YZ=$Z(Object.keys,Object);eN.exports=YZ});var rN=P((Jxe,nN)=>{d();var KZ=JF(),XZ=tN(),JZ=Object.prototype,ZZ=JZ.hasOwnProperty;function QZ(e){if(!KZ(e))return XZ(e);var t=[];for(var n in Object(e))ZZ.call(e,n)&&n!="constructor"&&t.push(n);return t}s(QZ,"baseKeys");nN.exports=QZ});var iN=P((eSe,aN)=>{d();var eQ=Fy(),tQ=Uy();function nQ(e){return e!=null&&tQ(e.length)&&!eQ(e)}s(nQ,"isArrayLike");aN.exports=nQ});var sN=P((rSe,oN)=>{d();var rQ=KF(),aQ=rN(),iQ=iN();function oQ(e){return iQ(e)?rQ(e):aQ(e)}s(oQ,"keys");oN.exports=oQ});var uN=P((oSe,cN)=>{d();var sQ=fF(),cQ=DF(),uQ=sN();function lQ(e){return sQ(e,uQ,cQ)}s(lQ,"getAllKeys");cN.exports=lQ});var mN=P((uSe,dN)=>{d();var lN=uN(),dQ=1,mQ=Object.prototype,pQ=mQ.hasOwnProperty;function fQ(e,t,n,r,a,i){var o=n&dQ,c=lN(e),u=c.length,l=lN(t),m=l.length;if(u!=m&&!o)return!1;for(var p=u;p--;){var h=c[p];if(!(o?h in t:pQ.call(t,h)))return!1}var f=i.get(e),g=i.get(t);if(f&&g)return f==t&&g==e;var b=!0;i.set(e,t),i.set(t,e);for(var w=o;++p<u;){h=c[p];var E=e[h],x=t[h];if(r)var S=o?r(x,E,h,t,e,i):r(E,x,h,e,t,i);if(!(S===void 0?E===x||a(E,x,n,r,i):S)){b=!1;break}w||(w=h=="constructor")}if(b&&!w){var k=e.constructor,A=t.constructor;k!=A&&"constructor"in e&&"constructor"in t&&!(typeof k=="function"&&k instanceof k&&typeof A=="function"&&A instanceof A)&&(b=!1)}return i.delete(e),i.delete(t),b}s(fQ,"equalObjects");dN.exports=fQ});var fN=P((mSe,pN)=>{d();var hQ=uo(),gQ=qr(),yQ=hQ(gQ,"DataView");pN.exports=yQ});var gN=P((fSe,hN)=>{d();var vQ=uo(),bQ=qr(),wQ=vQ(bQ,"Promise");hN.exports=wQ});var vN=P((gSe,yN)=>{d();var DQ=uo(),EQ=qr(),TQ=DQ(EQ,"Set");yN.exports=TQ});var wN=P((vSe,bN)=>{d();var xQ=uo(),SQ=qr(),CQ=xQ(SQ,"WeakMap");bN.exports=CQ});var AN=P((wSe,kN)=>{d();var zy=fN(),Hy=uf(),Gy=gN(),Wy=vN(),Vy=wN(),CN=Ku(),_s=My(),DN="[object Map]",kQ="[object Object]",EN="[object Promise]",TN="[object Set]",xN="[object WeakMap]",SN="[object DataView]",AQ=_s(zy),RQ=_s(Hy),_Q=_s(Gy),IQ=_s(Wy),FQ=_s(Vy),lo=CN;(zy&&lo(new zy(new ArrayBuffer(1)))!=SN||Hy&&lo(new Hy)!=DN||Gy&&lo(Gy.resolve())!=EN||Wy&&lo(new Wy)!=TN||Vy&&lo(new Vy)!=xN)&&(lo=s(function(e){var t=CN(e),n=t==kQ?e.constructor:void 0,r=n?_s(n):"";if(r)switch(r){case AQ:return SN;case RQ:return DN;case _Q:return EN;case IQ:return TN;case FQ:return xN}return t},"getTag"));kN.exports=lo});var PN=P((TSe,LN)=>{d();var $y=qI(),NQ=Py(),MQ=uF(),LQ=mN(),RN=AN(),_N=df(),IN=By(),PQ=qy(),OQ=1,FN="[object Arguments]",NN="[object Array]",mf="[object Object]",BQ=Object.prototype,MN=BQ.hasOwnProperty;function UQ(e,t,n,r,a,i){var o=_N(e),c=_N(t),u=o?NN:RN(e),l=c?NN:RN(t);u=u==FN?mf:u,l=l==FN?mf:l;var m=u==mf,p=l==mf,h=u==l;if(h&&IN(e)){if(!IN(t))return!1;o=!0,m=!1}if(h&&!m)return i||(i=new $y),o||PQ(e)?NQ(e,t,n,r,a,i):MQ(e,t,u,n,r,a,i);if(!(n&OQ)){var f=m&&MN.call(e,"__wrapped__"),g=p&&MN.call(t,"__wrapped__");if(f||g){var b=f?e.value():e,w=g?t.value():t;return i||(i=new $y),a(b,w,n,r,i)}}return h?(i||(i=new $y),LQ(e,t,n,r,a,i)):!1}s(UQ,"baseIsEqualDeep");LN.exports=UQ});var jN=P((CSe,UN)=>{d();var jQ=PN(),ON=Zu();function BN(e,t,n,r,a){return e===t?!0:e==null||t==null||!ON(e)&&!ON(t)?e!==e&&t!==t:jQ(e,t,n,r,BN,a)}s(BN,"baseIsEqual");UN.exports=BN});var nl=P((RSe,qN)=>{d();var qQ=jN();function zQ(e,t){return qQ(e,t)}s(zQ,"isEqual");qN.exports=zQ});var zN,HN=v(()=>{"use strict";d();Qa();zN=!!hn.env.CI||hn.env.NODE_ENV==="test"});function VQ(e){let t=Math.sign(e);e=Math.abs(e);let n=.254829592,r=-.284496736,a=1.421413741,i=-1.453152027,o=1.061405429,u=1/(1+.3275911*e),l=u*(n+u*(r+u*(a+u*(i+u*o))));return t*(1-l*Math.exp(-e*e))}function GN({median:e,p10:t},n){if(e<=0)throw new Error("median must be greater than zero");if(t<=0)throw new Error("p10 must be greater than zero");if(t>=e)throw new Error("p10 must be less than the median");if(n<=0)return 1;let r=.9061938024368232,a=Math.max(Number.MIN_VALUE,n/e),i=Math.log(a),o=Math.max(Number.MIN_VALUE,t/e),c=-Math.log(o),u=i*r/c,l=(1-VQ(u))/2,m;return n<=t?m=Math.max(.9,Math.min(1,l)):n<=e?m=Math.max(GQ,Math.min(HQ,l)):m=Math.max(0,Math.min(WQ,l)),m}function WN(e,t,n,r,a){let i=(r-t)/(n-e);return t+(a-e)*i}var HQ,GQ,WQ,Yy=v(()=>{"use strict";d();HQ=.8999999999999999,GQ=.5,WQ=.49999999999999994;s(VQ,"erf");s(GN,"getLogNormalScore");s(WN,"linearInterpolation")});var Ea,YQ,VN,KQ,XQ,ze,Vn=v(()=>{"use strict";d();Yy();Ea="…",YQ=" ",VN=.9,KQ={PASS:{label:"pass",minScore:VN},AVERAGE:{label:"average",minScore:.5},FAIL:{label:"fail"},ERROR:{label:"error"}},XQ=["com","co","gov","edu","ac","org","go","gob","or","net","in","ne","nic","gouv","web","spb","blog","jus","kiev","mil","wi","qc","ca","bel","on"],ze=class e{static{s(this,"Util")}static get RATINGS(){return KQ}static get PASS_THRESHOLD(){return VN}static get MS_DISPLAY_VALUE(){return`%10d${YQ}ms`}static getFinalDisplayedUrl(t){if(t.finalDisplayedUrl)return t.finalDisplayedUrl;if(t.finalUrl)return t.finalUrl;throw new Error("Could not determine final displayed URL")}static getMainDocumentUrl(t){return t.mainDocumentUrl||t.finalUrl}static getFullPageScreenshot(t){return t.fullPageScreenshot?t.fullPageScreenshot:t.audits["full-page-screenshot"]?.details}static getEntityFromUrl(t,n){return n&&n.find(a=>a.origins.find(i=>t.startsWith(i)))||e.getPseudoRootDomain(t)}static splitMarkdownCodeSpans(t){let n=[],
r=t.split(/`(.*?)`/g);for(let a=0;a<r.length;a++){let i=r[a];if(!i)continue;let o=a%2!==0;n.push({isCode:o,text:i})}return n}static splitMarkdownLink(t){let n=[],r=t.split(/\[([^\]]+?)\]\((https?:\/\/.*?)\)/g);for(;r.length;){let[a,i,o]=r.splice(0,3);a&&n.push({isLink:!1,text:a}),i&&o&&n.push({isLink:!0,text:i,linkHref:o})}return n}static truncate(t,n,r="…"){if(t.length<=n)return t;let i=new Intl.Segmenter(void 0,{granularity:"grapheme"}).segment(t)[Symbol.iterator](),o=0;for(let c=0;c<=n-r.length;c++){let u=i.next();if(u.done)return t;o=u.value.index}for(let c=0;c<r.length;c++)if(i.next().done)return t;return t.slice(0,o)+r}static getURLDisplayName(t,n){n=n||{numPathParts:void 0,preserveQuery:void 0,preserveHost:void 0};let r=n.numPathParts!==void 0?n.numPathParts:2,a=n.preserveQuery!==void 0?n.preserveQuery:!0,i=n.preserveHost||!1,o;if(t.protocol==="about:"||t.protocol==="data:")o=t.href;else{o=t.pathname;let u=o.split("/").filter(l=>l.length);r&&u.length>r&&(o=Ea+u.slice(-1*r).join(
"/")),i&&(o=`${t.host}/${o.replace(/^\//,"")}`),a&&(o=`${o}${t.search}`)}let c=64;if(t.protocol!=="data:"&&(o=o.slice(0,200),o=o.replace(/([a-f0-9]{7})[a-f0-9]{13}[a-f0-9]*/g,`$1${Ea}`),o=o.replace(/([a-zA-Z0-9-_]{9})(?=.*[a-z])(?=.*[A-Z])(?=.*[0-9])[a-zA-Z0-9-_]{10,}/g,`$1${Ea}`),o=o.replace(/(\d{3})\d{6,}/g,`$1${Ea}`),o=o.replace(/\u2026+/g,Ea),o.length>c&&o.includes("?")&&(o=o.replace(/\?([^=]*)(=)?.*/,`?$1$2${Ea}`),o.length>c&&(o=o.replace(/\?.*/,`?${Ea}`)))),o.length>c){let u=o.lastIndexOf(".");u>=0?o=o.slice(0,c-1-(o.length-u))+`${Ea}${o.slice(u)}`:o=o.slice(0,c-1)+Ea}return o}static getChromeExtensionOrigin(t){let n=new URL(t);return n.protocol+"//"+n.host}static parseURL(t){let n=new URL(t);return{file:e.getURLDisplayName(n),hostname:n.hostname,origin:n.protocol==="chrome-extension:"?e.getChromeExtensionOrigin(t):n.origin}}static createOrReturnURL(t){return t instanceof URL?t:new URL(t)}static getPseudoTld(t){let n=t.split(".").slice(-2);return XQ.includes(n[0])?`.${n.join(".")}`:
`.${n[n.length-1]}`}static getPseudoRootDomain(t){let n=e.createOrReturnURL(t).hostname,a=e.getPseudoTld(n).split(".");return n.split(".").slice(-a.length).join(".")}static filterRelevantLines(t,n,r){if(n.length===0)return t.slice(0,r*2+1);let a=3,i=new Set;return n=n.sort((o,c)=>(o.lineNumber||0)-(c.lineNumber||0)),n.forEach(({lineNumber:o})=>{let c=o-r,u=o+r;for(;c<1;)c++,u++;i.has(c-a-1)&&(c-=a);for(let l=c;l<=u;l++){let m=l;i.add(m)}}),t.filter(o=>i.has(o.lineNumber))}static computeLogNormalScore(t,n){let r=GN(t,n);return r>.9&&(r+=.05*(r-.9)),Math.floor(r*100)/100}}});var JQ,ZQ,QQ,y,Y=v(()=>{"use strict";d();Yt();HN();Vn();JQ="defaultPass",ZQ={FCP:50,LCP:50,INP:50,TBT:50,CLS:.001},QQ=s(e=>Math.round(e*100)/100,"clampTo2Decimals"),y=class e{static{s(this,"Audit")}static get DEFAULT_PASS(){return JQ}static get SCORING_MODES(){return{NUMERIC:"numeric",METRIC_SAVINGS:"metricSavings",BINARY:"binary",MANUAL:"manual",INFORMATIVE:"informative",NOT_APPLICABLE:"notApplicable",ERROR:"error"}}static get meta(){throw new Error("Audit meta information must be overridden.")}static get defaultOptions(){return{}}static audit(t,n){throw new Error("audit() method must be overridden")}static computeLogNormalScore(t,n){return ze.computeLogNormalScore(t,n)}static assertHeadingKeysExist(t,n){if(n.length&&zN)for(let r of t){if(r.key===null)continue;let a=r.key;if(!n.some(i=>a in i))throw new Error(`"${r.key}" is missing from items`)}}static makeTableDetails(t,n,r={}){let{wastedBytes:a,wastedMs:i,sortedBy:o,skipSumming:c,isEntityGrouped:u}=r,l=a||i?{wastedBytes:a,wastedMs:i}:
void 0;return n.length===0?{type:"table",headings:[],items:[],summary:l}:(e.assertHeadingKeysExist(t,n),{type:"table",headings:t,items:n,summary:l,sortedBy:o,skipSumming:c,isEntityGrouped:u})}static makeListDetails(t){return{type:"list",items:t}}static makeSnippetDetails({content:t,title:n,lineMessages:r,generalMessages:a,node:i,maxLineLength:o=200,maxLinesAroundMessage:c=20}){let u=e._makeSnippetLinesArray(t,o);return{type:"snippet",lines:ze.filterRelevantLines(u,r,c),title:n,lineMessages:r,generalMessages:a,lineCount:u.length,node:i}}static _makeSnippetLinesArray(t,n){return t.split(`
`).map((r,a)=>{let i=a+1,o={content:ze.truncate(r,n),lineNumber:i};return r.length>n&&(o.truncated=!0),o})}static makeOpportunityDetails(t,n,r){e.assertHeadingKeysExist(t,n);let{overallSavingsMs:a,overallSavingsBytes:i,sortedBy:o,skipSumming:c,isEntityGrouped:u}=r;return{type:"opportunity",headings:n.length===0?[]:t,items:n,overallSavingsMs:a,overallSavingsBytes:i,sortedBy:o,skipSumming:c,isEntityGrouped:u}}static makeNodeItem(t){return{type:"node",lhId:t.lhId,path:t.devtoolsNodePath,selector:t.selector,boundingRect:t.boundingRect,snippet:t.snippet,nodeLabel:t.nodeLabel}}static _findOriginalLocation(t,n,r){let a=t?.map.findEntry(n,r);if(a)return{file:a.sourceURL||"",line:a.sourceLineNumber||0,column:a.sourceColumnNumber||0}}static makeSourceLocation(t,n,r,a){return{type:"source-location",url:t,urlProvider:"network",line:n,column:r,original:a&&this._findOriginalLocation(a,n,r)}}static makeSourceLocationFromConsoleMessage(t,n){if(!t.url)return;let r=t.lineNumber||0,a=t.columnNumber||0;return this.
makeSourceLocation(t.url,r,a,n)}static _normalizeAuditScore(t,n,r){if(n===e.SCORING_MODES.INFORMATIVE)return 1;if(n!==e.SCORING_MODES.BINARY&&n!==e.SCORING_MODES.NUMERIC&&n!==e.SCORING_MODES.METRIC_SAVINGS)return null;if(t===null||!Number.isFinite(t))throw new Error(`Invalid score for ${r}: ${t}`);if(t>1)throw new Error(`Audit score for ${r} is > 1`);if(t<0)throw new Error(`Audit score for ${r} is < 0`);return t=QQ(t),t}static _quantizeMetricSavings(t){if(!t)return;let n={...t};for(let r of Object.keys(t)){let a=t[r];if(a===void 0)continue;a=Math.max(a,0);let i=ZQ[r];i!==void 0&&(a=Math.round(a/i)*i),n[r]=a}return n}static generateErrorAuditResult(t,n,r){return e.generateAuditResult(t,{score:null,errorMessage:n,errorStack:r})}static generateAuditResult(t,n){if(n.score===void 0)throw new Error("generateAuditResult requires a score");let r=t.meta.scoreDisplayMode||e.SCORING_MODES.BINARY,a=n.score;n.errorMessage!==void 0?r=e.SCORING_MODES.ERROR:n.notApplicable?r=e.SCORING_MODES.NOT_APPLICABLE:
n.scoreDisplayMode&&(r=n.scoreDisplayMode);let i=e._quantizeMetricSavings(n.metricSavings),o=Object.values(i||{}).some(l=>l);r===e.SCORING_MODES.METRIC_SAVINGS&&(a&&a>=ze.PASS_THRESHOLD?a=1:o?a=0:a=.5),a=e._normalizeAuditScore(a,r,t.meta.id);let c=t.meta.title;t.meta.failureTitle&&a!==null&&a<ze.PASS_THRESHOLD&&(c=t.meta.failureTitle);let u="numericUnit"in n?n:void 0;return{id:t.meta.id,title:c,description:t.meta.description,score:a,scoreDisplayMode:r,numericValue:u?.numericValue,numericUnit:u?.numericUnit,displayValue:n.displayValue,explanation:n.explanation,errorMessage:n.errorMessage,errorStack:n.errorStack,warnings:n.warnings,scoringOptions:n.scoringOptions,metricSavings:i,details:n.details,guidanceLevel:t.meta.guidanceLevel}}static makeMetricComputationDataInput(t,n){let r=t.traces[e.DEFAULT_PASS],a=t.devtoolsLogs[e.DEFAULT_PASS],i=t.GatherContext;return{trace:r,devtoolsLog:a,gatherContext:i,settings:n.settings,URL:t.URL}}}});var eee,pf,$N=v(()=>{"use strict";d();Y();eee=s(e=>Math.round(e*100)/100,"clampTo2Decimals"),pf=class e{static{s(this,"ReportScoring")}static arithmeticMean(t){if(t=t.filter(r=>r.weight>0),t.some(r=>r.score===null))return null;let n=t.reduce((r,a)=>{let i=a.score,o=a.weight;return{weight:r.weight+o,sum:r.sum+i*o}},{weight:0,sum:0});return eee(n.sum/n.weight||0)}static scoreAllCategories(t,n){let r={};for(let[a,i]of Object.entries(t)){let o=i.auditRefs.map(l=>{let m={...l},p=n[m.id];return(p.scoreDisplayMode===y.SCORING_MODES.NOT_APPLICABLE||p.scoreDisplayMode===y.SCORING_MODES.INFORMATIVE||p.scoreDisplayMode===y.SCORING_MODES.MANUAL)&&(m.weight=0),m}),c=o.map(l=>({score:n[l.id].score,weight:l.weight})),u=e.arithmeticMean(c);r[a]={...i,auditRefs:o,id:a,score:u}}return r}}});function rl(e,t){if(typeof t!="function"&&t!==null)throw new TypeError("Class extends value "+String(t)+" is not a constructor or null");Ky(e,t);function n(){this.constructor=e}s(n,"__"),e.prototype=t===null?Object.create(t):(n.prototype=t.prototype,new n)}function YN(e,t){var n={};for(var r in e)Object.prototype.hasOwnProperty.call(e,r)&&t.indexOf(r)<0&&(n[r]=e[r]);if(e!=null&&typeof Object.getOwnPropertySymbols=="function")for(var a=0,r=Object.getOwnPropertySymbols(e);a<r.length;a++)t.indexOf(r[a])<0&&Object.prototype.propertyIsEnumerable.call(e,r[a])&&(n[r[a]]=e[r[a]]);return n}function ff(e,t,n){if(n||arguments.length===2)for(var r=0,a=t.length,i;r<a;r++)(i||!(r in t))&&(i||(i=Array.prototype.slice.call(t,0,r)),i[r]=t[r]);return e.concat(i||Array.prototype.slice.call(t))}var Ky,Er,Xy=v(()=>{d();Ky=s(function(e,t){return Ky=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(n,r){n.__proto__=r}||function(n,r){for(var a in r)Object.prototype.hasOwnProperty.call(r,a)&&(n[a]=
r[a])},Ky(e,t)},"extendStatics");s(rl,"__extends");Er=s(function(){return Er=Object.assign||s(function(t){for(var n,r=1,a=arguments.length;r<a;r++){n=arguments[r];for(var i in n)Object.prototype.hasOwnProperty.call(n,i)&&(t[i]=n[i])}return t},"__assign"),Er.apply(this,arguments)},"__assign");s(YN,"__rest");s(ff,"__spreadArray")});var Is,Jy=v(()=>{d();Is=s(function(){return Is=Object.assign||s(function(t){for(var n,r=1,a=arguments.length;r<a;r++){n=arguments[r];for(var i in n)Object.prototype.hasOwnProperty.call(n,i)&&(t[i]=n[i])}return t},"__assign"),Is.apply(this,arguments)},"__assign")});var $e,Zy=v(()=>{d();(function(e){e[e.EXPECT_ARGUMENT_CLOSING_BRACE=1]="EXPECT_ARGUMENT_CLOSING_BRACE",e[e.EMPTY_ARGUMENT=2]="EMPTY_ARGUMENT",e[e.MALFORMED_ARGUMENT=3]="MALFORMED_ARGUMENT",e[e.EXPECT_ARGUMENT_TYPE=4]="EXPECT_ARGUMENT_TYPE",e[e.INVALID_ARGUMENT_TYPE=5]="INVALID_ARGUMENT_TYPE",e[e.EXPECT_ARGUMENT_STYLE=6]="EXPECT_ARGUMENT_STYLE",e[e.INVALID_NUMBER_SKELETON=7]="INVALID_NUMBER_SKELETON",e[e.INVALID_DATE_TIME_SKELETON=8]="INVALID_DATE_TIME_SKELETON",e[e.EXPECT_NUMBER_SKELETON=9]="EXPECT_NUMBER_SKELETON",e[e.EXPECT_DATE_TIME_SKELETON=10]="EXPECT_DATE_TIME_SKELETON",e[e.UNCLOSED_QUOTE_IN_ARGUMENT_STYLE=11]="UNCLOSED_QUOTE_IN_ARGUMENT_STYLE",e[e.EXPECT_SELECT_ARGUMENT_OPTIONS=12]="EXPECT_SELECT_ARGUMENT_OPTIONS",e[e.EXPECT_PLURAL_ARGUMENT_OFFSET_VALUE=13]="EXPECT_PLURAL_ARGUMENT_OFFSET_VALUE",e[e.INVALID_PLURAL_ARGUMENT_OFFSET_VALUE=14]="INVALID_PLURAL_ARGUMENT_OFFSET_VALUE",e[e.EXPECT_SELECT_ARGUMENT_SELECTOR=15]="EXPECT_SELECT_ARGUMENT_SELECTOR",e[e.EXPECT_PLURAL_ARGUMENT_SELECTOR=
16]="EXPECT_PLURAL_ARGUMENT_SELECTOR",e[e.EXPECT_SELECT_ARGUMENT_SELECTOR_FRAGMENT=17]="EXPECT_SELECT_ARGUMENT_SELECTOR_FRAGMENT",e[e.EXPECT_PLURAL_ARGUMENT_SELECTOR_FRAGMENT=18]="EXPECT_PLURAL_ARGUMENT_SELECTOR_FRAGMENT",e[e.INVALID_PLURAL_ARGUMENT_SELECTOR=19]="INVALID_PLURAL_ARGUMENT_SELECTOR",e[e.DUPLICATE_PLURAL_ARGUMENT_SELECTOR=20]="DUPLICATE_PLURAL_ARGUMENT_SELECTOR",e[e.DUPLICATE_SELECT_ARGUMENT_SELECTOR=21]="DUPLICATE_SELECT_ARGUMENT_SELECTOR",e[e.MISSING_OTHER_CLAUSE=22]="MISSING_OTHER_CLAUSE",e[e.INVALID_TAG=23]="INVALID_TAG",e[e.INVALID_TAG_NAME=25]="INVALID_TAG_NAME",e[e.UNMATCHED_CLOSING_TAG=26]="UNMATCHED_CLOSING_TAG",e[e.UNCLOSED_TAG=27]="UNCLOSED_TAG"})($e||($e={}))});function Qy(e){return e.type===St.literal}function KN(e){return e.type===St.argument}function hf(e){return e.type===St.number}function gf(e){return e.type===St.date}function yf(e){return e.type===St.time}function vf(e){return e.type===St.select}function bf(e){return e.type===St.plural}function XN(e){return e.type===St.pound}function wf(e){return e.type===St.tag}function Df(e){return!!(e&&typeof e=="object"&&e.type===mo.number)}function al(e){return!!(e&&typeof e=="object"&&e.type===mo.dateTime)}var St,mo,Ef=v(()=>{d();(function(e){e[e.literal=0]="literal",e[e.argument=1]="argument",e[e.number=2]="number",e[e.date=3]="date",e[e.time=4]="time",e[e.select=5]="select",e[e.plural=6]="plural",e[e.pound=7]="pound",e[e.tag=8]="tag"})(St||(St={}));(function(e){e[e.number=0]="number",e[e.dateTime=1]="dateTime"})(mo||(mo={}));s(Qy,"isLiteralElement");s(KN,"isArgumentElement");s(hf,"isNumberElement");s(gf,"isDateElement");s(yf,"isTimeElement");s(vf,"isSelectElement");s(bf,"isPluralElement");s(XN,"\
isPoundElement");s(wf,"isTagElement");s(Df,"isNumberSkeleton");s(al,"isDateTimeSkeleton")});var ev,JN=v(()=>{d();ev=/[ \xA0\u1680\u2000-\u200A\u202F\u205F\u3000]/});function ZN(e){var t={};return e.replace(tee,function(n){var r=n.length;switch(n[0]){case"G":t.era=r===4?"long":r===5?"narrow":"short";break;case"y":t.year=r===2?"2-digit":"numeric";break;case"Y":case"u":case"U":case"r":throw new RangeError("`Y/u/U/r` (year) patterns are not supported, use `y` instead");case"q":case"Q":throw new RangeError("`q/Q` (quarter) patterns are not supported");case"M":case"L":t.month=["numeric","2-digit","short","long","narrow"][r-1];break;case"w":case"W":throw new RangeError("`w/W` (week) patterns are not supported");case"d":t.day=["numeric","2-digit"][r-1];break;case"D":case"F":case"g":throw new RangeError("`D/F/g` (day) patterns are not supported, use `d` instead");case"E":t.weekday=r===4?"short":r===5?"narrow":"short";break;case"e":if(r<4)throw new RangeError("`e..eee` (weekday) patterns are not supported");t.weekday=["short","long","narrow","short"][r-4];break;case"c":if(r<4)throw new RangeError("`c..ccc` (weekday) patterns are not supported");t.weekday=["\
short","long","narrow","short"][r-4];break;case"a":t.hour12=!0;break;case"b":case"B":throw new RangeError("`b/B` (period) patterns are not supported, use `a` instead");case"h":t.hourCycle="h12",t.hour=["numeric","2-digit"][r-1];break;case"H":t.hourCycle="h23",t.hour=["numeric","2-digit"][r-1];break;case"K":t.hourCycle="h11",t.hour=["numeric","2-digit"][r-1];break;case"k":t.hourCycle="h24",t.hour=["numeric","2-digit"][r-1];break;case"j":case"J":case"C":throw new RangeError("`j/J/C` (hour) patterns are not supported, use `h/H/K/k` instead");case"m":t.minute=["numeric","2-digit"][r-1];break;case"s":t.second=["numeric","2-digit"][r-1];break;case"S":case"A":throw new RangeError("`S/A` (second) patterns are not supported, use `s` instead");case"z":t.timeZoneName=r<4?"short":"long";break;case"Z":case"O":case"v":case"V":case"X":case"x":throw new RangeError("`Z/O/v/V/X/x` (timeZone) patterns are not supported, use `z` instead")}return""}),t}var tee,QN=v(()=>{d();tee=/(?:[Eec]{1,6}|G{1,5}|[Qq]{1,5}|(?:[yYur]+|U{1,5})|[ML]{1,5}|d{1,2}|D{1,3}|F{1}|[abB]{1,5}|[hkHK]{1,2}|w{1,2}|W{1}|m{1,2}|s{1,2}|[zZOvVxX]{1,4})(?=([^']*'[^']*')*[^']*$)/g;
s(ZN,"parseDateTimeSkeleton")});var Pt,eM=v(()=>{d();Pt=s(function(){return Pt=Object.assign||s(function(t){for(var n,r=1,a=arguments.length;r<a;r++){n=arguments[r];for(var i in n)Object.prototype.hasOwnProperty.call(n,i)&&(t[i]=n[i])}return t},"__assign"),Pt.apply(this,arguments)},"__assign")});var tM,nM=v(()=>{d();tM=/[\t-\r \x85\u200E\u200F\u2028\u2029]/i});function oM(e){if(e.length===0)throw new Error("Number skeleton cannot be empty");for(var t=e.split(tM).filter(function(h){return h.length>0}),n=[],r=0,a=t;r<a.length;r++){var i=a[r],o=i.split("/");if(o.length===0)throw new Error("Invalid number skeleton");for(var c=o[0],u=o.slice(1),l=0,m=u;l<m.length;l++){var p=m[l];if(p.length===0)throw new Error("Invalid number skeleton")}n.push({stem:c,options:u})}return n}function nee(e){return e.replace(/^(.*?)-/,"")}function aM(e){var t={};return e[e.length-1]==="r"?t.roundingPriority="morePrecision":e[e.length-1]==="s"&&(t.roundingPriority="lessPrecision"),e.replace(sM,function(n,r,a){return typeof a!="string"?(t.minimumSignificantDigits=r.length,t.maximumSignificantDigits=r.length):a==="+"?t.minimumSignificantDigits=r.length:r[0]==="#"?t.maximumSignificantDigits=r.length:(t.minimumSignificantDigits=r.length,t.maximumSignificantDigits=r.length+(typeof a=="string"?a.length:0)),""}),t}function uM(e){switch(e){case"sign-auto":return{signDisplay:"\
auto"};case"sign-accounting":case"()":return{currencySign:"accounting"};case"sign-always":case"+!":return{signDisplay:"always"};case"sign-accounting-always":case"()!":return{signDisplay:"always",currencySign:"accounting"};case"sign-except-zero":case"+?":return{signDisplay:"exceptZero"};case"sign-accounting-except-zero":case"()?":return{signDisplay:"exceptZero",currencySign:"accounting"};case"sign-never":case"+_":return{signDisplay:"never"}}}function aee(e){var t;if(e[0]==="E"&&e[1]==="E"?(t={notation:"engineering"},e=e.slice(2)):e[0]==="E"&&(t={notation:"scientific"},e=e.slice(1)),t){var n=e.slice(0,2);if(n==="+!"?(t.signDisplay="always",e=e.slice(2)):n==="+?"&&(t.signDisplay="exceptZero",e=e.slice(2)),!cM.test(e))throw new Error("Malformed concise eng/scientific notation");t.minimumIntegerDigits=e.length}return t}function iM(e){var t={},n=uM(e);return n||t}function lM(e){for(var t={},n=0,r=e;n<r.length;n++){var a=r[n];switch(a.stem){case"percent":case"%":t.style="percent";continue;case"\
%x100":t.style="percent",t.scale=100;continue;case"currency":t.style="currency",t.currency=a.options[0];continue;case"group-off":case",_":t.useGrouping=!1;continue;case"precision-integer":case".":t.maximumFractionDigits=0;continue;case"measure-unit":case"unit":t.style="unit",t.unit=nee(a.options[0]);continue;case"compact-short":case"K":t.notation="compact",t.compactDisplay="short";continue;case"compact-long":case"KK":t.notation="compact",t.compactDisplay="long";continue;case"scientific":t=Pt(Pt(Pt({},t),{notation:"scientific"}),a.options.reduce(function(u,l){return Pt(Pt({},u),iM(l))},{}));continue;case"engineering":t=Pt(Pt(Pt({},t),{notation:"engineering"}),a.options.reduce(function(u,l){return Pt(Pt({},u),iM(l))},{}));continue;case"notation-simple":t.notation="standard";continue;case"unit-width-narrow":t.currencyDisplay="narrowSymbol",t.unitDisplay="narrow";continue;case"unit-width-short":t.currencyDisplay="code",t.unitDisplay="short";continue;case"unit-width-full-name":t.currencyDisplay=
"name",t.unitDisplay="long";continue;case"unit-width-iso-code":t.currencyDisplay="symbol";continue;case"scale":t.scale=parseFloat(a.options[0]);continue;case"integer-width":if(a.options.length>1)throw new RangeError("integer-width stems only accept a single optional option");a.options[0].replace(ree,function(u,l,m,p,h,f){if(l)t.minimumIntegerDigits=m.length;else{if(p&&h)throw new Error("We currently do not support maximum integer digits");if(f)throw new Error("We currently do not support exact integer digits")}return""});continue}if(cM.test(a.stem)){t.minimumIntegerDigits=a.stem.length;continue}if(rM.test(a.stem)){if(a.options.length>1)throw new RangeError("Fraction-precision stems only accept a single optional option");a.stem.replace(rM,function(u,l,m,p,h,f){return m==="*"?t.minimumFractionDigits=l.length:p&&p[0]==="#"?t.maximumFractionDigits=p.length:h&&f?(t.minimumFractionDigits=h.length,t.maximumFractionDigits=h.length+f.length):(t.minimumFractionDigits=l.length,t.maximumFractionDigits=
l.length),""});var i=a.options[0];i==="w"?t=Pt(Pt({},t),{trailingZeroDisplay:"stripIfInteger"}):i&&(t=Pt(Pt({},t),aM(i)));continue}if(sM.test(a.stem)){t=Pt(Pt({},t),aM(a.stem));continue}var o=uM(a.stem);o&&(t=Pt(Pt({},t),o));var c=aee(a.stem);c&&(t=Pt(Pt({},t),c))}return t}var rM,sM,ree,cM,dM=v(()=>{d();eM();nM();s(oM,"parseNumberSkeletonFromString");s(nee,"icuUnitToEcma");rM=/^\.(?:(0+)(\*)?|(#+)|(0+)(#+))$/g,sM=/^(@+)?(\+|#+)?[rs]?$/g,ree=/(\*)(0+)|(#+)(0+)|(0+)/g,cM=/^(0+)$/;s(aM,"parseSignificantPrecision");s(uM,"parseSign");s(aee,"parseConciseScientificAndEngineeringStem");s(iM,"parseNotationOptions");s(lM,"parseNumberSkeleton")});var mM=v(()=>{d();QN();dM()});var il,pM=v(()=>{d();il={"001":["H","h"],AC:["H","h","hb","hB"],AD:["H","hB"],AE:["h","hB","hb","H"],AF:["H","hb","hB","h"],AG:["h","hb","H","hB"],AI:["H","h","hb","hB"],AL:["h","H","hB"],AM:["H","hB"],AO:["H","hB"],AR:["H","h","hB","hb"],AS:["h","H"],AT:["H","hB"],AU:["h","hb","H","hB"],AW:["H","hB"],AX:["H"],AZ:["H","hB","h"],BA:["H","hB","h"],BB:["h","hb","H","hB"],BD:["h","hB","H"],BE:["H","hB"],BF:["H","hB"],BG:["H","hB","h"],BH:["h","hB","hb","H"],BJ:["H","hB"],BL:["H","hB"],BM:["h","hb","H","hB"],BN:["hb","hB","h","H"],BO:["H","hB","h","hb"],BQ:["H"],BR:["H","hB"],BS:["h","hb","H","hB"],BT:["h","H"],BW:["H","h","hb","hB"],BZ:["H","h","hb","hB"],CA:["h","hb","H","hB"],CC:["H","h","hb","hB"],CD:["hB","H"],CF:["H","h","hB"],CG:["H","hB"],CH:["H","hB","h"],CI:["H","hB"],CK:["H","h","hb","hB"],CL:["H","h","hB","hb"],CM:["H","h","hB"],CN:["H","hB","hb","h"],CO:["h","H","hB","hb"],CP:["H"],CR:["H","h","hB","hb"],CU:["H","h","hB","hb"],CV:["H","hB"],CX:["H","h","hb","hB"],CY:["h","H","h\
b","hB"],CZ:["H"],DE:["H","hB"],DG:["H","h","hb","hB"],DJ:["h","H"],DK:["H"],DM:["h","hb","H","hB"],DO:["h","H","hB","hb"],DZ:["h","hB","hb","H"],EA:["H","h","hB","hb"],EC:["H","hB","h","hb"],EE:["H","hB"],EG:["h","hB","hb","H"],EH:["h","hB","hb","H"],ER:["h","H"],ES:["H","hB","h","hb"],ET:["hB","hb","h","H"],FI:["H"],FJ:["h","hb","H","hB"],FK:["H","h","hb","hB"],FM:["h","hb","H","hB"],FR:["H","hB"],GA:["H","hB"],GB:["H","h","hb","hB"],GD:["h","hb","H","hB"],GE:["H","hB","h"],GF:["H","hB"],GG:["H","h","hb","hB"],GH:["h","H"],GI:["H","h","hb","hB"],GM:["h","hb","H","hB"],GN:["H","hB"],GP:["H","hB"],GQ:["H","hB","h","hb"],GR:["h","H","hb","hB"],GT:["H","h","hB","hb"],GU:["h","hb","H","hB"],GW:["H","hB"],GY:["h","hb","H","hB"],HK:["h","hB","hb","H"],HN:["H","h","hB","hb"],HR:["H","hB"],IC:["H","h","hB","hb"],ID:["H"],IE:["H","h","hb","hB"],IL:["H","hB"],IM:["H","h","hb","hB"],IN:["h","H"],IO:["H","h","hb","hB"],IQ:["h","hB","hb","H"],IR:["hB","H"],IS:["H"],IT:["H","hB"],JE:["H","h","hb","\
hB"],JM:["h","hb","H","hB"],JO:["h","hB","hb","H"],JP:["H","h","K"],KE:["hB","hb","H","h"],KG:["H","h","hB","hb"],KH:["hB","h","H","hb"],KI:["h","hb","H","hB"],KM:["H","h","hB","hb"],KN:["h","hb","H","hB"],KP:["h","H","hB","hb"],KR:["h","H","hB","hb"],KW:["h","hB","hb","H"],KY:["h","hb","H","hB"],KZ:["H","hB"],LA:["H","hb","hB","h"],LB:["h","hB","hb","H"],LC:["h","hb","H","hB"],LI:["H","hB","h"],LK:["H","h","hB","hb"],LR:["h","hb","H","hB"],LS:["h","H"],LT:["H","h","hb","hB"],LU:["H","h","hB"],LV:["H","hB","hb","h"],LY:["h","hB","hb","H"],MA:["H","h","hB","hb"],MC:["H","hB"],MD:["H","hB"],ME:["H","hB","h"],MF:["H","hB"],MH:["h","hb","H","hB"],MK:["H","h","hb","hB"],ML:["H"],MM:["hB","hb","H","h"],MN:["H","h","hb","hB"],MO:["h","hB","hb","H"],MP:["h","hb","H","hB"],MQ:["H","hB"],MR:["h","hB","hb","H"],MS:["H","h","hb","hB"],MW:["h","hb","H","hB"],MX:["H","h","hB","hb"],MY:["hb","hB","h","H"],MZ:["H","hB"],NA:["h","H","hB","hb"],NC:["H","hB"],NE:["H"],NF:["H","h","hb","hB"],NG:["H","h","\
hb","hB"],NI:["H","h","hB","hb"],NL:["H","hB"],NP:["H","h","hB"],NR:["H","h","hb","hB"],NU:["H","h","hb","hB"],NZ:["h","hb","H","hB"],OM:["h","hB","hb","H"],PA:["h","H","hB","hb"],PE:["H","hB","h","hb"],PF:["H","h","hB"],PG:["h","H"],PH:["h","hB","hb","H"],PK:["h","hB","H"],PM:["H","hB"],PN:["H","h","hb","hB"],PR:["h","H","hB","hb"],PS:["h","hB","hb","H"],PT:["H","hB"],PW:["h","H"],PY:["H","h","hB","hb"],QA:["h","hB","hb","H"],RE:["H","hB"],RO:["H","hB"],RS:["H","hB","h"],RU:["H"],SA:["h","hB","hb","H"],SB:["h","hb","H","hB"],SC:["H","h","hB"],SD:["h","hB","hb","H"],SE:["H"],SG:["h","hb","H","hB"],SH:["H","h","hb","hB"],SI:["H","hB"],SJ:["H"],SK:["H"],SL:["h","hb","H","hB"],SM:["H","h","hB"],SN:["H","h","hB"],SO:["h","H"],SR:["H","hB"],SS:["h","hb","H","hB"],ST:["H","hB"],SV:["H","h","hB","hb"],SX:["H","h","hb","hB"],SY:["h","hB","hb","H"],SZ:["h","hb","H","hB"],TA:["H","h","hb","hB"],TC:["h","hb","H","hB"],TD:["h","H","hB"],TF:["H","h","hB"],TG:["H","hB"],TL:["H","hB","hb","h"],TN:["h",
"hB","hb","H"],TO:["h","H"],TR:["H","hB"],TT:["h","hb","H","hB"],TW:["hB","hb","h","H"],TZ:["hB","hb","H","h"],UA:["H","hB","h"],UG:["hB","hb","H","h"],UM:["h","hb","H","hB"],US:["h","hb","H","hB"],UY:["H","h","hB","hb"],UZ:["H","hB","h"],VA:["H","h","hB"],VC:["h","hb","H","hB"],VE:["h","H","hB","hb"],VG:["h","hb","H","hB"],VI:["h","hb","H","hB"],VU:["h","H"],WF:["H","hB"],WS:["h","H"],XK:["H","hB","h"],YE:["h","hB","hb","H"],YT:["H","hB"],ZA:["H","h","hb","hB"],ZM:["h","hb","H","hB"],"af-ZA":["H","h","hB","hb"],"ar-001":["h","hB","hb","H"],"ca-ES":["H","h","hB"],"en-001":["h","hb","H","hB"],"es-BO":["H","h","hB","hb"],"es-BR":["H","h","hB","hb"],"es-EC":["H","h","hB","hb"],"es-ES":["H","h","hB","hb"],"es-GQ":["H","h","hB","hb"],"es-PE":["H","h","hB","hb"],"fr-CA":["H","h","hB"],"gl-ES":["H","h","hB"],"gu-IN":["hB","hb","h","H"],"hi-IN":["hB","h","H"],"it-CH":["H","h","hB"],"it-IT":["H","h","hB"],"kn-IN":["hB","h","H"],"ml-IN":["hB","h","H"],"mr-IN":["hB","hb","h","H"],"pa-IN":["hB","h\
b","h","H"],"ta-IN":["hB","h","hb","H"],"te-IN":["hB","h","H"],"zu-ZA":["H","hB","hb","h"]}});function fM(e,t){for(var n="",r=0;r<e.length;r++){var a=e.charAt(r);if(a==="j"){for(var i=0;r+1<e.length&&e.charAt(r+1)===a;)i++,r++;var o=1+(i&1),c=i<2?1:3+(i>>1),u="a",l=iee(t);for((l=="H"||l=="k")&&(c=0);c-- >0;)n+=u;for(;o-- >0;)n=l+n}else a==="J"?n+="H":n+=a}return n}function iee(e){var t=e.hourCycle;if(t===void 0&&e.hourCycles&&e.hourCycles.length&&(t=e.hourCycles[0]),t)switch(t){case"h24":return"k";case"h23":return"H";case"h12":return"h";case"h11":return"K";default:throw new Error("Invalid hourCycle")}var n=e.language,r;n!=="root"&&(r=e.maximize().region);var a=il[r||""]||il[n||""]||il["".concat(n,"-001")]||il["001"];return a[0]}var hM=v(()=>{d();pM();s(fM,"getBestPattern");s(iee,"getDefaultHourSymbolFromLocale")});function Je(e,t){return{start:e,end:t}}function wM(e,t){return new RegExp(e,t)}function ov(e){return e>=97&&e<=122||e>=65&&e<=90}function vee(e){return ov(e)||e===47}function bee(e){return e===45||e===46||e>=48&&e<=57||e===95||e>=97&&e<=122||e>=65&&e<=90||e==183||e>=192&&e<=214||e>=216&&e<=246||e>=248&&e<=893||e>=895&&e<=8191||e>=8204&&e<=8205||e>=8255&&e<=8256||e>=8304&&e<=8591||e>=11264&&e<=12271||e>=12289&&e<=55295||e>=63744&&e<=64975||e>=65008&&e<=65533||e>=65536&&e<=983039}function EM(e){return e>=9&&e<=13||e===32||e===133||e>=8206&&e<=8207||e===8232||e===8233}function wee(e){return e>=33&&e<=35||e===36||e>=37&&e<=39||e===40||e===41||e===42||e===43||e===44||e===45||e>=46&&e<=47||e>=58&&e<=59||e>=60&&e<=62||e>=63&&e<=64||e===91||e===92||e===93||e===94||e===96||e===123||e===124||e===125||e===126||e===161||e>=162&&e<=165||e===166||e===167||e===169||e===171||e===172||e===174||e===176||e===177||e===182||e===187||e===191||e===215||e===247||e>=8208&&e<=8213||e>=8214&&e<=8215||e===8216||e===
8217||e===8218||e>=8219&&e<=8220||e===8221||e===8222||e===8223||e>=8224&&e<=8231||e>=8240&&e<=8248||e===8249||e===8250||e>=8251&&e<=8254||e>=8257&&e<=8259||e===8260||e===8261||e===8262||e>=8263&&e<=8273||e===8274||e===8275||e>=8277&&e<=8286||e>=8592&&e<=8596||e>=8597&&e<=8601||e>=8602&&e<=8603||e>=8604&&e<=8607||e===8608||e>=8609&&e<=8610||e===8611||e>=8612&&e<=8613||e===8614||e>=8615&&e<=8621||e===8622||e>=8623&&e<=8653||e>=8654&&e<=8655||e>=8656&&e<=8657||e===8658||e===8659||e===8660||e>=8661&&e<=8691||e>=8692&&e<=8959||e>=8960&&e<=8967||e===8968||e===8969||e===8970||e===8971||e>=8972&&e<=8991||e>=8992&&e<=8993||e>=8994&&e<=9e3||e===9001||e===9002||e>=9003&&e<=9083||e===9084||e>=9085&&e<=9114||e>=9115&&e<=9139||e>=9140&&e<=9179||e>=9180&&e<=9185||e>=9186&&e<=9254||e>=9255&&e<=9279||e>=9280&&e<=9290||e>=9291&&e<=9311||e>=9472&&e<=9654||e===9655||e>=9656&&e<=9664||e===9665||e>=9666&&e<=9719||e>=9720&&e<=9727||e>=9728&&e<=9838||e===9839||e>=9840&&e<=10087||e===10088||e===10089||e===10090||
e===10091||e===10092||e===10093||e===10094||e===10095||e===10096||e===10097||e===10098||e===10099||e===10100||e===10101||e>=10132&&e<=10175||e>=10176&&e<=10180||e===10181||e===10182||e>=10183&&e<=10213||e===10214||e===10215||e===10216||e===10217||e===10218||e===10219||e===10220||e===10221||e===10222||e===10223||e>=10224&&e<=10239||e>=10240&&e<=10495||e>=10496&&e<=10626||e===10627||e===10628||e===10629||e===10630||e===10631||e===10632||e===10633||e===10634||e===10635||e===10636||e===10637||e===10638||e===10639||e===10640||e===10641||e===10642||e===10643||e===10644||e===10645||e===10646||e===10647||e===10648||e>=10649&&e<=10711||e===10712||e===10713||e===10714||e===10715||e>=10716&&e<=10747||e===10748||e===10749||e>=10750&&e<=11007||e>=11008&&e<=11055||e>=11056&&e<=11076||e>=11077&&e<=11078||e>=11079&&e<=11084||e>=11085&&e<=11123||e>=11124&&e<=11125||e>=11126&&e<=11157||e===11158||e>=11159&&e<=11263||e>=11776&&e<=11777||e===11778||e===11779||e===11780||e===11781||e>=11782&&e<=11784||e===
11785||e===11786||e===11787||e===11788||e===11789||e>=11790&&e<=11798||e===11799||e>=11800&&e<=11801||e===11802||e===11803||e===11804||e===11805||e>=11806&&e<=11807||e===11808||e===11809||e===11810||e===11811||e===11812||e===11813||e===11814||e===11815||e===11816||e===11817||e>=11818&&e<=11822||e===11823||e>=11824&&e<=11833||e>=11834&&e<=11835||e>=11836&&e<=11839||e===11840||e===11841||e===11842||e>=11843&&e<=11855||e>=11856&&e<=11857||e===11858||e>=11859&&e<=11903||e>=12289&&e<=12291||e===12296||e===12297||e===12298||e===12299||e===12300||e===12301||e===12302||e===12303||e===12304||e===12305||e>=12306&&e<=12307||e===12308||e===12309||e===12310||e===12311||e===12312||e===12313||e===12314||e===12315||e===12316||e===12317||e>=12318&&e<=12319||e===12320||e===12336||e===64830||e===64831||e>=65093&&e<=65094}var tv,oee,see,cee,uee,lee,dee,mee,pee,fee,hee,rv,gM,yM,av,vM,bM,gee,yee,iv,nv,DM,TM=v(()=>{d();Jy();Zy();Ef();JN();mM();hM();oee=new RegExp("^".concat(ev.source,"*")),see=new RegExp("".
concat(ev.source,"*$"));s(Je,"createLocation");cee=!!String.prototype.startsWith&&"_a".startsWith("a",1),uee=!!String.fromCodePoint,lee=!!Object.fromEntries,dee=!!String.prototype.codePointAt,mee=!!String.prototype.trimStart,pee=!!String.prototype.trimEnd,fee=!!Number.isSafeInteger,hee=fee?Number.isSafeInteger:function(e){return typeof e=="number"&&isFinite(e)&&Math.floor(e)===e&&Math.abs(e)<=9007199254740991},rv=!0;try{gM=wM("([^\\p{White_Space}\\p{Pattern_Syntax}]*)","yu"),rv=((tv=gM.exec("a"))===null||tv===void 0?void 0:tv[0])==="a"}catch{rv=!1}yM=s(cee?function(t,n,r){return t.startsWith(n,r)}:function(t,n,r){return t.slice(r,r+n.length)===n},"startsWith"),av=uee?String.fromCodePoint:s(function(){for(var t=[],n=0;n<arguments.length;n++)t[n]=arguments[n];for(var r="",a=t.length,i=0,o;a>i;){if(o=t[i++],o>1114111)throw RangeError(o+" is not a valid code point");r+=o<65536?String.fromCharCode(o):String.fromCharCode(((o-=65536)>>10)+55296,o%1024+56320)}return r},"fromCodePoint"),vM=lee?
Object.fromEntries:s(function(t){for(var n={},r=0,a=t;r<a.length;r++){var i=a[r],o=i[0],c=i[1];n[o]=c}return n},"fromEntries"),bM=s(dee?function(t,n){return t.codePointAt(n)}:function(t,n){var r=t.length;if(!(n<0||n>=r)){var a=t.charCodeAt(n),i;return a<55296||a>56319||n+1===r||(i=t.charCodeAt(n+1))<56320||i>57343?a:(a-55296<<10)+(i-56320)+65536}},"codePointAt"),gee=s(mee?function(t){return t.trimStart()}:function(t){return t.replace(oee,"")},"trimStart"),yee=s(pee?function(t){return t.trimEnd()}:function(t){return t.replace(see,"")},"trimEnd");s(wM,"RE");rv?(nv=wM("([^\\p{White_Space}\\p{Pattern_Syntax}]*)","yu"),iv=s(function(t,n){var r;nv.lastIndex=n;var a=nv.exec(t);return(r=a[1])!==null&&r!==void 0?r:""},"matchIdentifierAtIndex")):iv=s(function(t,n){for(var r=[];;){var a=bM(t,n);if(a===void 0||EM(a)||wee(a))break;r.push(a),n+=a>=65536?2:1}return av.apply(void 0,r)},"matchIdentifierAtIndex");DM=function(){function e(t,n){n===void 0&&(n={}),this.message=t,this.position={offset:0,line:1,
column:1},this.ignoreTag=!!n.ignoreTag,this.locale=n.locale,this.requiresOtherClause=!!n.requiresOtherClause,this.shouldParseSkeletons=!!n.shouldParseSkeletons}return s(e,"Parser"),e.prototype.parse=function(){if(this.offset()!==0)throw Error("parser can only be used once");return this.parseMessage(0,"",!1)},e.prototype.parseMessage=function(t,n,r){for(var a=[];!this.isEOF();){var i=this.char();if(i===123){var o=this.parseArgument(t,r);if(o.err)return o;a.push(o.val)}else{if(i===125&&t>0)break;if(i===35&&(n==="plural"||n==="selectordinal")){var c=this.clonePosition();this.bump(),a.push({type:St.pound,location:Je(c,this.clonePosition())})}else if(i===60&&!this.ignoreTag&&this.peek()===47){if(r)break;return this.error($e.UNMATCHED_CLOSING_TAG,Je(this.clonePosition(),this.clonePosition()))}else if(i===60&&!this.ignoreTag&&ov(this.peek()||0)){var o=this.parseTag(t,n);if(o.err)return o;a.push(o.val)}else{var o=this.parseLiteral(t,n);if(o.err)return o;a.push(o.val)}}}return{val:a,err:null}},
e.prototype.parseTag=function(t,n){var r=this.clonePosition();this.bump();var a=this.parseTagName();if(this.bumpSpace(),this.bumpIf("/>"))return{val:{type:St.literal,value:"<".concat(a,"/>"),location:Je(r,this.clonePosition())},err:null};if(this.bumpIf(">")){var i=this.parseMessage(t+1,n,!0);if(i.err)return i;var o=i.val,c=this.clonePosition();if(this.bumpIf("</")){if(this.isEOF()||!ov(this.char()))return this.error($e.INVALID_TAG,Je(c,this.clonePosition()));var u=this.clonePosition(),l=this.parseTagName();return a!==l?this.error($e.UNMATCHED_CLOSING_TAG,Je(u,this.clonePosition())):(this.bumpSpace(),this.bumpIf(">")?{val:{type:St.tag,value:a,children:o,location:Je(r,this.clonePosition())},err:null}:this.error($e.INVALID_TAG,Je(c,this.clonePosition())))}else return this.error($e.UNCLOSED_TAG,Je(r,this.clonePosition()))}else return this.error($e.INVALID_TAG,Je(r,this.clonePosition()))},e.prototype.parseTagName=function(){var t=this.offset();for(this.bump();!this.isEOF()&&bee(this.char());)
this.bump();return this.message.slice(t,this.offset())},e.prototype.parseLiteral=function(t,n){for(var r=this.clonePosition(),a="";;){var i=this.tryParseQuote(n);if(i){a+=i;continue}var o=this.tryParseUnquoted(t,n);if(o){a+=o;continue}var c=this.tryParseLeftAngleBracket();if(c){a+=c;continue}break}var u=Je(r,this.clonePosition());return{val:{type:St.literal,value:a,location:u},err:null}},e.prototype.tryParseLeftAngleBracket=function(){return!this.isEOF()&&this.char()===60&&(this.ignoreTag||!vee(this.peek()||0))?(this.bump(),"<"):null},e.prototype.tryParseQuote=function(t){if(this.isEOF()||this.char()!==39)return null;switch(this.peek()){case 39:return this.bump(),this.bump(),"'";case 123:case 60:case 62:case 125:break;case 35:if(t==="plural"||t==="selectordinal")break;return null;default:return null}this.bump();var n=[this.char()];for(this.bump();!this.isEOF();){var r=this.char();if(r===39)if(this.peek()===39)n.push(39),this.bump();else{this.bump();break}else n.push(r);this.bump()}return av.
apply(void 0,n)},e.prototype.tryParseUnquoted=function(t,n){if(this.isEOF())return null;var r=this.char();return r===60||r===123||r===35&&(n==="plural"||n==="selectordinal")||r===125&&t>0?null:(this.bump(),av(r))},e.prototype.parseArgument=function(t,n){var r=this.clonePosition();if(this.bump(),this.bumpSpace(),this.isEOF())return this.error($e.EXPECT_ARGUMENT_CLOSING_BRACE,Je(r,this.clonePosition()));if(this.char()===125)return this.bump(),this.error($e.EMPTY_ARGUMENT,Je(r,this.clonePosition()));var a=this.parseIdentifierIfPossible().value;if(!a)return this.error($e.MALFORMED_ARGUMENT,Je(r,this.clonePosition()));if(this.bumpSpace(),this.isEOF())return this.error($e.EXPECT_ARGUMENT_CLOSING_BRACE,Je(r,this.clonePosition()));switch(this.char()){case 125:return this.bump(),{val:{type:St.argument,value:a,location:Je(r,this.clonePosition())},err:null};case 44:return this.bump(),this.bumpSpace(),this.isEOF()?this.error($e.EXPECT_ARGUMENT_CLOSING_BRACE,Je(r,this.clonePosition())):this.parseArgumentOptions(
t,n,a,r);default:return this.error($e.MALFORMED_ARGUMENT,Je(r,this.clonePosition()))}},e.prototype.parseIdentifierIfPossible=function(){var t=this.clonePosition(),n=this.offset(),r=iv(this.message,n),a=n+r.length;this.bumpTo(a);var i=this.clonePosition(),o=Je(t,i);return{value:r,location:o}},e.prototype.parseArgumentOptions=function(t,n,r,a){var i,o=this.clonePosition(),c=this.parseIdentifierIfPossible().value,u=this.clonePosition();switch(c){case"":return this.error($e.EXPECT_ARGUMENT_TYPE,Je(o,u));case"number":case"date":case"time":{this.bumpSpace();var l=null;if(this.bumpIf(",")){this.bumpSpace();var m=this.clonePosition(),p=this.parseSimpleArgStyleIfPossible();if(p.err)return p;var h=yee(p.val);if(h.length===0)return this.error($e.EXPECT_ARGUMENT_STYLE,Je(this.clonePosition(),this.clonePosition()));var f=Je(m,this.clonePosition());l={style:h,styleLocation:f}}var g=this.tryParseArgumentClose(a);if(g.err)return g;var b=Je(a,this.clonePosition());if(l&&yM(l?.style,"::",0)){var w=gee(l.
style.slice(2));if(c==="number"){var p=this.parseNumberSkeletonFromString(w,l.styleLocation);return p.err?p:{val:{type:St.number,value:r,location:b,style:p.val},err:null}}else{if(w.length===0)return this.error($e.EXPECT_DATE_TIME_SKELETON,b);var E=w;this.locale&&(E=fM(w,this.locale));var h={type:mo.dateTime,pattern:E,location:l.styleLocation,parsedOptions:this.shouldParseSkeletons?ZN(E):{}},x=c==="date"?St.date:St.time;return{val:{type:x,value:r,location:b,style:h},err:null}}}return{val:{type:c==="number"?St.number:c==="date"?St.date:St.time,value:r,location:b,style:(i=l?.style)!==null&&i!==void 0?i:null},err:null}}case"plural":case"selectordinal":case"select":{var S=this.clonePosition();if(this.bumpSpace(),!this.bumpIf(","))return this.error($e.EXPECT_SELECT_ARGUMENT_OPTIONS,Je(S,Is({},S)));this.bumpSpace();var k=this.parseIdentifierIfPossible(),A=0;if(c!=="select"&&k.value==="offset"){if(!this.bumpIf(":"))return this.error($e.EXPECT_PLURAL_ARGUMENT_OFFSET_VALUE,Je(this.clonePosition(),
this.clonePosition()));this.bumpSpace();var p=this.tryParseDecimalInteger($e.EXPECT_PLURAL_ARGUMENT_OFFSET_VALUE,$e.INVALID_PLURAL_ARGUMENT_OFFSET_VALUE);if(p.err)return p;this.bumpSpace(),k=this.parseIdentifierIfPossible(),A=p.val}var L=this.tryParsePluralOrSelectOptions(t,c,n,k);if(L.err)return L;var g=this.tryParseArgumentClose(a);if(g.err)return g;var N=Je(a,this.clonePosition());return c==="select"?{val:{type:St.select,value:r,options:vM(L.val),location:N},err:null}:{val:{type:St.plural,value:r,options:vM(L.val),offset:A,pluralType:c==="plural"?"cardinal":"ordinal",location:N},err:null}}default:return this.error($e.INVALID_ARGUMENT_TYPE,Je(o,u))}},e.prototype.tryParseArgumentClose=function(t){return this.isEOF()||this.char()!==125?this.error($e.EXPECT_ARGUMENT_CLOSING_BRACE,Je(t,this.clonePosition())):(this.bump(),{val:!0,err:null})},e.prototype.parseSimpleArgStyleIfPossible=function(){for(var t=0,n=this.clonePosition();!this.isEOF();){var r=this.char();switch(r){case 39:{this.bump();
var a=this.clonePosition();if(!this.bumpUntil("'"))return this.error($e.UNCLOSED_QUOTE_IN_ARGUMENT_STYLE,Je(a,this.clonePosition()));this.bump();break}case 123:{t+=1,this.bump();break}case 125:{if(t>0)t-=1;else return{val:this.message.slice(n.offset,this.offset()),err:null};break}default:this.bump();break}}return{val:this.message.slice(n.offset,this.offset()),err:null}},e.prototype.parseNumberSkeletonFromString=function(t,n){var r=[];try{r=oM(t)}catch{return this.error($e.INVALID_NUMBER_SKELETON,n)}return{val:{type:mo.number,tokens:r,location:n,parsedOptions:this.shouldParseSkeletons?lM(r):{}},err:null}},e.prototype.tryParsePluralOrSelectOptions=function(t,n,r,a){for(var i,o=!1,c=[],u=new Set,l=a.value,m=a.location;;){if(l.length===0){var p=this.clonePosition();if(n!=="select"&&this.bumpIf("=")){var h=this.tryParseDecimalInteger($e.EXPECT_PLURAL_ARGUMENT_SELECTOR,$e.INVALID_PLURAL_ARGUMENT_SELECTOR);if(h.err)return h;m=Je(p,this.clonePosition()),l=this.message.slice(p.offset,this.offset())}else
break}if(u.has(l))return this.error(n==="select"?$e.DUPLICATE_SELECT_ARGUMENT_SELECTOR:$e.DUPLICATE_PLURAL_ARGUMENT_SELECTOR,m);l==="other"&&(o=!0),this.bumpSpace();var f=this.clonePosition();if(!this.bumpIf("{"))return this.error(n==="select"?$e.EXPECT_SELECT_ARGUMENT_SELECTOR_FRAGMENT:$e.EXPECT_PLURAL_ARGUMENT_SELECTOR_FRAGMENT,Je(this.clonePosition(),this.clonePosition()));var g=this.parseMessage(t+1,n,r);if(g.err)return g;var b=this.tryParseArgumentClose(f);if(b.err)return b;c.push([l,{value:g.val,location:Je(f,this.clonePosition())}]),u.add(l),this.bumpSpace(),i=this.parseIdentifierIfPossible(),l=i.value,m=i.location}return c.length===0?this.error(n==="select"?$e.EXPECT_SELECT_ARGUMENT_SELECTOR:$e.EXPECT_PLURAL_ARGUMENT_SELECTOR,Je(this.clonePosition(),this.clonePosition())):this.requiresOtherClause&&!o?this.error($e.MISSING_OTHER_CLAUSE,Je(this.clonePosition(),this.clonePosition())):{val:c,err:null}},e.prototype.tryParseDecimalInteger=function(t,n){var r=1,a=this.clonePosition();
this.bumpIf("+")||this.bumpIf("-")&&(r=-1);for(var i=!1,o=0;!this.isEOF();){var c=this.char();if(c>=48&&c<=57)i=!0,o=o*10+(c-48),this.bump();else break}var u=Je(a,this.clonePosition());return i?(o*=r,hee(o)?{val:o,err:null}:this.error(n,u)):this.error(t,u)},e.prototype.offset=function(){return this.position.offset},e.prototype.isEOF=function(){return this.offset()===this.message.length},e.prototype.clonePosition=function(){return{offset:this.position.offset,line:this.position.line,column:this.position.column}},e.prototype.char=function(){var t=this.position.offset;if(t>=this.message.length)throw Error("out of bound");var n=bM(this.message,t);if(n===void 0)throw Error("Offset ".concat(t," is at invalid UTF-16 code unit boundary"));return n},e.prototype.error=function(t,n){return{val:null,err:{kind:t,message:this.message,location:n}}},e.prototype.bump=function(){if(!this.isEOF()){var t=this.char();t===10?(this.position.line+=1,this.position.column=1,this.position.offset+=1):(this.position.
column+=1,this.position.offset+=t<65536?1:2)}},e.prototype.bumpIf=function(t){if(yM(this.message,t,this.offset())){for(var n=0;n<t.length;n++)this.bump();return!0}return!1},e.prototype.bumpUntil=function(t){var n=this.offset(),r=this.message.indexOf(t,n);return r>=0?(this.bumpTo(r),!0):(this.bumpTo(this.message.length),!1)},e.prototype.bumpTo=function(t){if(this.offset()>t)throw Error("targetOffset ".concat(t," must be greater than or equal to the current offset ").concat(this.offset()));for(t=Math.min(t,this.message.length);;){var n=this.offset();if(n===t)break;if(n>t)throw Error("targetOffset ".concat(t," is at invalid UTF-16 code unit boundary"));if(this.bump(),this.isEOF())break}},e.prototype.bumpSpace=function(){for(;!this.isEOF()&&EM(this.char());)this.bump()},e.prototype.peek=function(){if(this.isEOF())return null;var t=this.char(),n=this.offset(),r=this.message.charCodeAt(n+(t>=65536?2:1));return r??null},e}();s(ov,"_isAlpha");s(vee,"_isAlphaOrSlash");s(bee,"_isPotentialElement\
NameChar");s(EM,"_isWhiteSpace");s(wee,"_isPatternSyntax")});function sv(e){e.forEach(function(t){if(delete t.location,vf(t)||bf(t))for(var n in t.options)delete t.options[n].location,sv(t.options[n].value);else hf(t)&&Df(t.style)||(gf(t)||yf(t))&&al(t.style)?delete t.style.location:wf(t)&&sv(t.children)})}function xM(e,t){t===void 0&&(t={}),t=Is({shouldParseSkeletons:!0,requiresOtherClause:!0},t);var n=new DM(e,t).parse();if(n.err){var r=SyntaxError($e[n.err.kind]);throw r.location=n.err.location,r.originalMessage=n.err.message,r}return t?.captureLocation||sv(n.val),n.val}var cv=v(()=>{d();Jy();Zy();TM();Ef();Ef();s(sv,"pruneLocation");s(xM,"parse")});function Tf(e,t){var n=t&&t.cache?t.cache:Cee,r=t&&t.serializer?t.serializer:See,a=t&&t.strategy?t.strategy:Eee;return a(e,{cache:n,serializer:r})}function Dee(e){return e==null||typeof e=="number"||typeof e=="boolean"}function SM(e,t,n,r){var a=Dee(r)?r:n(r),i=t.get(a);return typeof i>"u"&&(i=e.call(this,r),t.set(a,i)),i}function CM(e,t,n){var r=Array.prototype.slice.call(arguments,3),a=n(r),i=t.get(a);return typeof i>"u"&&(i=e.apply(this,r),t.set(a,i)),i}function uv(e,t,n,r,a){return n.bind(t,e,r,a)}function Eee(e,t){var n=e.length===1?SM:CM;return uv(e,this,n,t.cache.create(),t.serializer)}function Tee(e,t){return uv(e,this,CM,t.cache.create(),t.serializer)}function xee(e,t){return uv(e,this,SM,t.cache.create(),t.serializer)}function lv(){this.cache=Object.create(null)}var See,Cee,xf,kM=v(()=>{d();s(Tf,"memoize");s(Dee,"isPrimitive");s(SM,"monadic");s(CM,"variadic");s(uv,"assemble");s(Eee,"strategyDefault");s(Tee,"strategyVariadic");s(xee,"strategyMonadic");See=s(function(){return JSON.
stringify(arguments)},"serializerDefault");s(lv,"ObjectWithoutPrototypeCache");lv.prototype.get=function(e){return this.cache[e]};lv.prototype.set=function(e,t){this.cache[e]=t};Cee={create:s(function(){return new lv},"create")},xf={variadic:Tee,monadic:xee}});var po,ol,dv,AM,RM,mv=v(()=>{d();Xy();(function(e){e.MISSING_VALUE="MISSING_VALUE",e.INVALID_VALUE="INVALID_VALUE",e.MISSING_INTL_API="MISSING_INTL_API"})(po||(po={}));ol=function(e){rl(t,e);function t(n,r,a){var i=e.call(this,n)||this;return i.code=r,i.originalMessage=a,i}return s(t,"FormatError"),t.prototype.toString=function(){return"[formatjs Error: ".concat(this.code,"] ").concat(this.message)},t}(Error),dv=function(e){rl(t,e);function t(n,r,a,i){return e.call(this,'Invalid values for "'.concat(n,'": "').concat(r,'". Options are "').concat(Object.keys(a).join('", "'),'"'),po.INVALID_VALUE,i)||this}return s(t,"InvalidValueError"),t}(ol),AM=function(e){rl(t,e);function t(n,r,a){return e.call(this,'Value for "'.concat(n,'" must be of type ').concat(r),po.INVALID_VALUE,a)||this}return s(t,"InvalidValueTypeError"),t}(ol),RM=function(e){rl(t,e);function t(n,r){return e.call(this,'The intl string context variable "'.concat(n,'" was not provided to the string "').concat(r,'"'),po.MISSING_VALUE,
r)||this}return s(t,"MissingValueError"),t}(ol)});function kee(e){return e.length<2?e:e.reduce(function(t,n){var r=t[t.length-1];return!r||r.type!==gn.literal||n.type!==gn.literal?t.push(n):r.value+=n.value,t},[])}function Aee(e){return typeof e=="function"}function sl(e,t,n,r,a,i,o){if(e.length===1&&Qy(e[0]))return[{type:gn.literal,value:e[0].value}];for(var c=[],u=0,l=e;u<l.length;u++){var m=l[u];if(Qy(m)){c.push({type:gn.literal,value:m.value});continue}if(XN(m)){typeof i=="number"&&c.push({type:gn.literal,value:n.getNumberFormat(t).format(i)});continue}var p=m.value;if(!(a&&p in a))throw new RM(p,o);var h=a[p];if(KN(m)){(!h||typeof h=="string"||typeof h=="number")&&(h=typeof h=="string"||typeof h=="number"?String(h):""),c.push({type:typeof h=="string"?gn.literal:gn.object,value:h});continue}if(gf(m)){var f=typeof m.style=="string"?r.date[m.style]:al(m.style)?m.style.parsedOptions:void 0;c.push({type:gn.literal,value:n.getDateTimeFormat(t,f).format(h)});continue}if(yf(m)){var f=typeof m.style=="string"?r.time[m.style]:al(m.style)?m.
style.parsedOptions:r.time.medium;c.push({type:gn.literal,value:n.getDateTimeFormat(t,f).format(h)});continue}if(hf(m)){var f=typeof m.style=="string"?r.number[m.style]:Df(m.style)?m.style.parsedOptions:void 0;f&&f.scale&&(h=h*(f.scale||1)),c.push({type:gn.literal,value:n.getNumberFormat(t,f).format(h)});continue}if(wf(m)){var g=m.children,b=m.value,w=a[b];if(!Aee(w))throw new AM(b,"function",o);var E=sl(g,t,n,r,a,i),x=w(E.map(function(A){return A.value}));Array.isArray(x)||(x=[x]),c.push.apply(c,x.map(function(A){return{type:typeof A=="string"?gn.literal:gn.object,value:A}}))}if(vf(m)){var S=m.options[h]||m.options.other;if(!S)throw new dv(m.value,h,Object.keys(m.options),o);c.push.apply(c,sl(S.value,t,n,r,a));continue}if(bf(m)){var S=m.options["=".concat(h)];if(!S){if(!Intl.PluralRules)throw new ol(`Intl.PluralRules is not available in this environment.
Try polyfilling it using "@formatjs/intl-pluralrules"
`,po.MISSING_INTL_API,o);var k=n.getPluralRules(t,{type:m.pluralType}).select(h-(m.offset||0));S=m.options[k]||m.options.other}if(!S)throw new dv(m.value,h,Object.keys(m.options),o);c.push.apply(c,sl(S.value,t,n,r,a,h-(m.offset||0)));continue}}return kee(c)}var gn,pv=v(()=>{d();cv();mv();(function(e){e[e.literal=0]="literal",e[e.object=1]="object"})(gn||(gn={}));s(kee,"mergeLiteral");s(Aee,"isFormatXMLElementFn");s(sl,"formatToParts")});function Ree(e,t){return t?Er(Er(Er({},e||{}),t||{}),Object.keys(e).reduce(function(n,r){return n[r]=Er(Er({},e[r]),t[r]||{}),n},{})):e}function _ee(e,t){return t?Object.keys(e).reduce(function(n,r){return n[r]=Ree(e[r],t[r]),n},Er({},e)):e}function fv(e){return{create:function(){return{get:function(t){return e[t]},set:function(t,n){e[t]=n}}}}}function Iee(e){return e===void 0&&(e={number:{},dateTime:{},pluralRules:{}}),{getNumberFormat:Tf(function(){for(var t,n=[],r=0;r<arguments.length;r++)n[r]=arguments[r];return new((t=Intl.NumberFormat).bind.apply(t,ff([void 0],n,!1)))},{cache:fv(e.number),strategy:xf.variadic}),getDateTimeFormat:Tf(function(){for(var t,n=[],r=0;r<arguments.length;r++)n[r]=arguments[r];return new((t=Intl.DateTimeFormat).bind.apply(t,ff([void 0],n,!1)))},{cache:fv(e.dateTime),strategy:xf.variadic}),getPluralRules:Tf(function(){for(var t,n=[],r=0;r<arguments.length;r++)n[r]=arguments[r];return new((t=Intl.PluralRules).bind.apply(t,ff([void 0],n,!1)))},{cache:fv(e.pluralRules),
strategy:xf.variadic})}}var _M,hv=v(()=>{d();Xy();cv();kM();pv();s(Ree,"mergeConfig");s(_ee,"mergeConfigs");s(fv,"createFastMemoizeCache");s(Iee,"createDefaultFormatters");_M=function(){function e(t,n,r,a){n===void 0&&(n=e.defaultLocale);var i=this;if(this.formatterCache={number:{},dateTime:{},pluralRules:{}},this.format=function(l){var m=i.formatToParts(l);if(m.length===1)return m[0].value;var p=m.reduce(function(h,f){return!h.length||f.type!==gn.literal||typeof h[h.length-1]!="string"?h.push(f.value):h[h.length-1]+=f.value,h},[]);return p.length<=1?p[0]||"":p},this.formatToParts=function(l){return sl(i.ast,i.locales,i.formatters,i.formats,l,void 0,i.message)},this.resolvedOptions=function(){var l;return{locale:((l=i.resolvedLocale)===null||l===void 0?void 0:l.toString())||Intl.NumberFormat.supportedLocalesOf(i.locales)[0]}},this.getAst=function(){return i.ast},this.locales=n,this.resolvedLocale=e.resolveLocale(n),typeof t=="string"){if(this.message=t,!e.__parse)throw new TypeError("I\
ntlMessageFormat.__parse must be set to process `message` of type `string`");var o=a||{},c=o.formatters,u=YN(o,["formatters"]);this.ast=e.__parse(t,Er(Er({},u),{locale:this.resolvedLocale}))}else this.ast=t;if(!Array.isArray(this.ast))throw new TypeError("A message must be provided as a String or AST.");this.formats=_ee(e.formats,r),this.formatters=a&&a.formatters||Iee(this.formatterCache)}return s(e,"IntlMessageFormat"),Object.defineProperty(e,"defaultLocale",{get:function(){return e.memoizedDefaultLocale||(e.memoizedDefaultLocale=new Intl.NumberFormat().resolvedOptions().locale),e.memoizedDefaultLocale},enumerable:!1,configurable:!0}),e.memoizedDefaultLocale=null,e.resolveLocale=function(t){if(!(typeof Intl.Locale>"u")){var n=Intl.NumberFormat.supportedLocalesOf(t);return n.length>0?new Intl.Locale(n[0]):new Intl.Locale(typeof t=="string"?t:t[0])}},e.__parse=xM,e.formats={number:{integer:{maximumFractionDigits:0},currency:{style:"currency"},percent:{style:"percent"}},date:{short:{month:"\
numeric",day:"numeric",year:"2-digit"},medium:{month:"short",day:"numeric",year:"numeric"},long:{month:"long",day:"numeric",year:"numeric"},full:{weekday:"long",month:"long",day:"numeric",year:"numeric"}},time:{short:{hour:"numeric",minute:"numeric"},medium:{hour:"numeric",minute:"numeric",second:"numeric"},long:{hour:"numeric",minute:"numeric",second:"numeric",timeZoneName:"short"},full:{hour:"numeric",minute:"numeric",second:"numeric",timeZoneName:"short"}}},e}()});var gv,IM=v(()=>{d();hv();pv();hv();mv();gv=_M});var fo,Fs=v(()=>{d();fo=s(()=>({resolve(){throw new Error("createRequire.resolve is not supported in bundled Lighthouse")}}),"createRequire")});var Fee,Nee,ho,cl=v(()=>{d();Fee=globalThis.URL,Nee=s(e=>e,"fileURLToPath"),ho={URL:Fee,fileURLToPath:Nee}});function FM(e){return ho.fileURLToPath(e.url)}var go=v(()=>{"use strict";d();Fs();cl();ri();s(FM,"getModulePath")});function yv(e){return typeof e=="object"&&e!==null&&!Array.isArray(e)}function NM(e){return typeof e=="object"&&e!==null}var MM=v(()=>{"use strict";d();s(yv,"isObjectOfUnknownValues");s(NM,"isObjectOrArrayOfUnknownValues")});var LM,PM=v(()=>{d();LM={}});function BM(e,t=new Map){for(let n of e)if(!(n.type===Sf.literal||n.type===Sf.pound)&&(t.set(n.value,n),n.type===Sf.plural))for(let r of Object.values(n.options))BM(r.value,t);return t}function Pee(e,t={},n){let r=BM(e.getAst()),a={};for(let[i,o]of r){if(!(i in t))throw new Error(`ICU Message "${n}" contains a value reference ("${i}") that wasn't provided`);let c=t[i];if(o.type!==Sf.number){a[i]=c;continue}if(typeof c!="number")throw new Error(`ICU Message "${n}" contains a numeric reference ("${i}") but provided value was not a number`);o.style==="milliseconds"?a[i]=Math.round(c/10)*10:o.style==="seconds"&&i==="timeInMs"?a[i]=Math.round(c/100)/10:o.style==="bytes"?a[i]=c/1024:a[i]=c}for(let i of Object.keys(t))if(!(i in a)){if(i==="errorCode"){a.errorCode=t.errorCode;continue}throw new Error(`Provided value "${i}" does not match any placeholder in ICU message "${n}"`)}return a}function Oee(e){return e.replace(/'/g,"''").replace(/\\{/g,"'{").replace(/\\}/g,"'}")}function bv(e,t,n){e=Oee(
e);let r=n==="en-XA"||n==="en-XL"?"de-DE":n,a=gv.IntlMessageFormat||gv,i=new a(e,r,Lee,{ignoreTag:!0}),o=Pee(i,t,e),c=i.format(o);if(typeof c!="string")throw new Error("unexpected formatted result");return c}function Bee(e,t){let r=jM(t)[e.i18nId];return r?bv(r.message,e.values,t):e.formattedDefault}function UM(e){let t=jM(e),n=Object.keys(t).filter(a=>a.startsWith("report/renderer/report-utils.js")),r={};for(let a of n){let{filename:i,key:o}=jee(a);if(!i.endsWith("report-utils.js"))throw new Error(`Unexpected message: ${a}`);r[o]=t[a].message}return r}function Ms(e){if(!yv(e))return!1;let{i18nId:t,values:n,formattedDefault:r}=e;if(typeof t!="string"||typeof r!="string")return!1;if(n!==void 0){if(!yv(n))return!1;for(let a of Object.values(n))if(typeof a!="string"&&typeof a!="number")return!1}return OM.test(t)}function yo(e,t){if(Ms(e))return Bee(e,t);if(typeof e=="string")return e;throw new Error("Attempted to format invalid icuMessage type")}function Uee(e){let t="";for(let n of e)if(/^[a-z]+$/i.
test(n))t.length&&(t+="."),t+=n;else{if(/]|"|'|\s/.test(n))throw new Error(`Cannot handle "${n}" in i18n`);t+=`[${n}]`}return t}function wv(e,t){function n(a,i,o=[]){if(NM(a))for(let[c,u]of Object.entries(a)){let l=o.concat([c]);if(Ms(u)){let m=yo(u,t),p=i[u.i18nId]||[],h=Uee(l);p.push(u.values?{values:u.values,path:h}:h),a[c]=m,i[u.i18nId]=p}else n(u,i,l)}}s(n,"replaceInObject");let r={};return n(e,r),r}function jM(e){let t=vv[e];if(!t){if(e===Ns)return{};throw new Error(`Unsupported locale '${e}'`)}return t}function qM(){return Mee}function zM(){return[...new Set([...Object.keys(vv),Ns])].sort()}function HM(e,t){vv[e]=t}function jee(e){if(!OM.test(e))throw Error(`"${e}" does not appear to be a valid ICU message id`);let[t,n]=e.split(" | ");return{filename:t,key:n}}var Sf,vv,Ns,Mee,OM,Lee,Ta=v(()=>{"use strict";d();Da();IM();go();MM();PM();Sf={literal:0,argument:1,number:2,date:3,time:4,select:5,plural:6,pound:7,tag:8},vv=LM,Ns="en-US",Mee=["ar-XB.json","ar.json","bg.json","ca.json","\
cs.json","da.json","de.json","el.json","en-GB.json","en-US.ctc.json","en-US.json","en-XA.json","en-XL.ctc.json","en-XL.json","es-419.json","es.json","fi.json","fil.json","fr.json","he.json","hi.json","hr.json","hu.json","id.json","it.json","ja.json","ko.json","lt.json","lv.json","nl.json","no.json","pl.json","pt-PT.json","pt.json","ro.json","ru.json","sk.json","sl.json","sr-Latn.json","sr.json","sv.json","ta.json","te.json","th.json","tr.json","uk.json","vi.json","zh-HK.json","zh-TW.json","zh.json"].filter(e=>e.endsWith(".json")&&!e.endsWith(".ctc.json")).map(e=>e.replace(".json","")).sort(),OM=/ | [^\s]+$/,Lee={number:{bytes:{maximumFractionDigits:0},milliseconds:{maximumFractionDigits:0},seconds:{minimumFractionDigits:1,maximumFractionDigits:1},extendedPercent:{maximumFractionDigits:2,style:"percent"}}};s(BM,"collectAllCustomElementsFromICU");s(Pee,"_preformatValues");s(Oee,"escapeIcuMessage");s(bv,"formatMessage");s(Bee,"_localizeIcuMessage");s(UM,"getRendererFormattedStrings");s(Ms,
"isIcuMessage");s(yo,"getFormatted");s(Uee,"_formatPathAsString");s(wv,"replaceIcuMessages");s(jM,"_getLocaleMessages");s(qM,"getCanonicalLocales");s(zM,"getAvailableLocales");s(HM,"registerLocaleData");s(jee,"getIcuMessageIdParts")});var WM=P((VCe,GM)=>{d();var qee='data:image/svg+xml,<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 256 256"><path fill="%230379c4" fill-rule="evenodd" d="m171.887 116.28-53.696 89.36h-9.728l9.617-58.227-30.2.047a4.852 4.852 0 0 1-4.855-4.855c0-1.152 1.07-3.102 1.07-3.102l53.52-89.254 9.9.043-9.86 58.317 30.413-.043a4.852 4.852 0 0 1 4.855 4.855c0 1.088-.427 2.044-1.033 2.854l.004.004zM128 0C57.306 0 0 57.3 0 128s57.306 128 128 128 128-57.306 128-128S198.7 0 128 0z"/></svg>',zee={"modern-image-formats":"Consider displaying all [`amp-img`](https://amp.dev/documentation/components/amp-img/?format=websites) components in WebP formats while specifying an appropriate fallback for other browsers. [Learn more](https://amp.dev/documentation/components/amp-img/#example:-specifying-a-fallback-image).","offscreen-images":"Ensure that you are using [`amp-img`](https://amp.dev/documentation/components/amp-img/?format=websites) for images to automatically lazy-load. [Learn more](https://amp.dev\
/documentation/guides-and-tutorials/develop/media_iframes_3p/?format=websites#images).","render-blocking-resources":"Use tools such as [AMP Optimizer](https://github.com/ampproject/amp-toolbox/tree/master/packages/optimizer) to [server-side render AMP layouts](https://amp.dev/documentation/guides-and-tutorials/optimize-and-measure/server-side-rendering/).","unminified-css":"Refer to the [AMP documentation](https://amp.dev/documentation/guides-and-tutorials/develop/style_and_layout/style_pages/) to ensure all styles are supported.","efficient-animated-content":"For animated content, use [`amp-anim`](https://amp.dev/documentation/components/amp-anim/) to minimize CPU usage when the content is offscreen.","uses-responsive-images":"The [`amp-img`](https://amp.dev/documentation/components/amp-img/?format=websites) component supports the [`srcset`](https://web.dev/use-srcset-to-automatically-choose-the-right-image/) attribute to specify which image assets to use based on the screen size. [Le\
arn more](https://amp.dev/documentation/guides-and-tutorials/develop/style_and_layout/art_direction/)."};GM.exports={id:"amp",title:"AMP",icon:qee,UIStrings:zee}});var $M=P((YCe,VM)=>{d();var Hee='data:image/svg+xml,<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 250 250"><path fill="%23dd0031" d="M125 30 31.9 63.2l14.2 123.1L125 230l78.9-43.7 14.2-123.1z"/><path fill="%23c3002f" d="M125 30v22.2-.1V230l78.9-43.7 14.2-123.1L125 30z"/><path fill="%23fff" d="M125 52.1 66.8 182.6h21.7l11.7-29.2h49.4l11.7 29.2H183L125 52.1zm17 83.3h-34l17-40.9 17 40.9z"/></svg>',Gee={"total-byte-weight":"Apply [route-level code splitting](https://web.dev/route-level-code-splitting-in-angular/) to minimize the size of your JavaScript bundles. Also, consider precaching assets with the [Angular service worker](https://web.dev/precaching-with-the-angular-service-worker/).","unminified-warning":"If you are using Angular CLI, ensure that builds are generated in production mode. [Learn more](https://angular.io/guide/deployment#enable-runtime-production-mode).","unused-javascript":"If you are using Angular CLI, include source maps in your production build to inspect your\
 bundles. [Learn more](https://angular.io/guide/deployment#inspect-the-bundles).","uses-responsive-images":"Consider using the `BreakpointObserver` utility in the Component Dev Kit (CDK) to manage image breakpoints. [Learn more](https://material.angular.io/cdk/layout/overview).","uses-rel-preload":"Preload routes ahead of time to speed up navigation. [Learn more](https://web.dev/route-preloading-in-angular/).","dom-size":"Consider virtual scrolling with the Component Dev Kit (CDK) if very large lists are being rendered. [Learn more](https://web.dev/virtualize-lists-with-angular-cdk/)."};VM.exports={id:"angular",title:"Angular",icon:Hee,UIStrings:Gee}});var KM=P((XCe,YM)=>{d();var Wee='data:image/svg+xml,<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 186.525 243.713"><path fill="%23009cde" d="M131.64 51.91C114.491 34.769 98.13 18.429 93.26 0c-4.87 18.429-21.234 34.769-38.38 51.91C29.16 77.613 0 106.743 0 150.434a93.263 93.263 0 1 0 186.525 0c0-43.688-29.158-72.821-54.885-98.524m-92 120.256c-5.719-.194-26.824-36.571 12.329-75.303l25.909 28.3a2.215 2.215 0 0 1-.173 3.306c-6.183 6.34-32.534 32.765-35.81 41.902-.675 1.886-1.663 1.815-2.256 1.795m53.624 47.943a32.075 32.075 0 0 1-32.076-32.075 33.423 33.423 0 0 1 7.995-21.187c5.784-7.072 24.077-26.963 24.077-26.963s18.012 20.183 24.033 26.896a31.368 31.368 0 0 1 8.046 21.254 32.076 32.076 0 0 1-32.075 32.075m61.392-52.015c-.691 1.512-2.26 4.036-4.376 4.113-3.773.138-4.176-1.796-6.965-5.923-6.122-9.06-59.551-64.9-69.545-75.699-8.79-9.498-1.238-16.195 2.266-19.704 4.395-4.403 17.224-17.225 17.224-17.225s38.255 36.296 54.19 61.096 10.444 46.26 7.206 53.342"/></svg>',Vee={"unused-css-rul\
es":"Consider removing unused CSS rules and only attach the needed Drupal libraries to the relevant page or component in a page. See the [Drupal documentation link](https://www.drupal.org/docs/8/creating-custom-modules/adding-stylesheets-css-and-javascript-js-to-a-drupal-8-module#library) for details. To identify attached libraries that are adding extraneous CSS, try running [code coverage](https://developers.google.com/web/updates/2017/04/devtools-release-notes#coverage) in Chrome DevTools. You can identify the theme/module responsible from the URL of the stylesheet when CSS aggregation is disabled in your Drupal site. Look out for themes/modules that have many stylesheets in the list which have a lot of red in code coverage. A theme/module should only enqueue a stylesheet if it is actually used on the page.","unused-javascript":"Consider removing unused JavaScript assets and only attach the needed Drupal libraries to the relevant page or component in a page. See the [Drupal documenta\
tion link](https://www.drupal.org/docs/8/creating-custom-modules/adding-stylesheets-css-and-javascript-js-to-a-drupal-8-module#library) for details. To identify attached libraries that are adding extraneous JavaScript, try running [code coverage](https://developers.google.com/web/updates/2017/04/devtools-release-notes#coverage) in Chrome DevTools. You can identify the theme/module responsible from the URL of the script when JavaScript aggregation is disabled in your Drupal site. Look out for themes/modules that have many scripts in the list which have a lot of red in code coverage. A theme/module should only enqueue a script if it is actually used on the page.","modern-image-formats":"Consider configuring [WebP image formats with a Convert image style](https://www.drupal.org/docs/core-modules-and-themes/core-modules/image-module/working-with-images#styles) on your site.","offscreen-images":"Install [a Drupal module](https://www.drupal.org/project/project_module?f%5B0%5D=&f%5B1%5D=&f%5B\
2%5D=im_vid_3%3A67&f%5B3%5D=&f%5B4%5D=sm_field_project_type%3Afull&f%5B5%5D=&f%5B6%5D=&text=%22lazy+load%22&solrsort=iss_project_release_usage+desc&op=Search) that can lazy load images. Such modules provide the ability to defer any offscreen images to improve performance.","total-byte-weight":"Consider using [Responsive Image Styles](https://www.drupal.org/docs/8/mobile-guide/responsive-images-in-drupal-8) to reduce the size of images loaded on your page. If you are using Views to show multiple content items on a page, consider implementing pagination to limit the number of content items shown on a given page.","render-blocking-resources":"Consider using a module to inline critical CSS and JavaScript, and use the defer attribute for non-critical CSS or JavaScript.","unminified-css":'Ensure you have enabled "Aggregate CSS files" in the "Administration » Configuration » Development" page.  Ensure your Drupal site is running at least Drupal 10.1 for improved asset aggregation support.',
"unminified-javascript":'Ensure you have enabled "Aggregate JavaScript files" in the "Administration » Configuration » Development" page.  Ensure your Drupal site is running at least Drupal 10.1 for improved asset aggregation support.',"efficient-animated-content":"Consider uploading your GIF to a service which will make it available to embed as an HTML5 video.","uses-long-cache-ttl":'Set the "Browser and proxy cache maximum age" in the "Administration » Configuration » Development" page. Read about [Drupal cache and optimizing for performance](https://www.drupal.org/docs/7/managing-site-performance-and-scalability/caching-to-improve-performance/caching-overview#s-drupal-performance-resources).',"uses-optimized-images":"Consider using [a module](https://www.drupal.org/project/project_module?f%5B0%5D=&f%5B1%5D=&f%5B2%5D=im_vid_3%3A123&f%5B3%5D=&f%5B4%5D=sm_field_project_type%3Afull&f%5B5%5D=&f%5B6%5D=&text=optimize+images&solrsort=iss_project_release_usage+desc&op=Search) that autom\
atically optimizes and reduces the size of images uploaded through the site while retaining quality. Also, ensure you are using the native [Responsive Image Styles](https://www.drupal.org/docs/8/mobile-guide/responsive-images-in-drupal-8) provided from Drupal (available in Drupal 8 and above) for all images rendered on the site.","uses-responsive-images":"Ensure that you are using the native [Responsive Image Styles](https://www.drupal.org/docs/8/mobile-guide/responsive-images-in-drupal-8) provided from Drupal (available in Drupal 8 and above). Use the Responsive Image Styles when rendering image fields through view modes, views, or images uploaded through the WYSIWYG editor.","server-response-time":"Themes, modules, and server specifications all contribute to server response time. Consider finding a more optimized theme, carefully selecting an optimization module, and/or upgrading your server. Your hosting servers should make use of PHP opcode caching, memory-caching to reduce databas\
e query times such as Redis or Memcached, as well as optimized application logic to prepare pages faster.","uses-rel-preconnect":"Preconnect or dns-prefetch resource hints can be added by installing and configuring [a module](https://www.drupal.org/project/project_module?f%5B0%5D=&f%5B1%5D=&f%5B2%5D=&f%5B3%5D=&f%5B4%5D=sm_field_project_type%3Afull&f%5B5%5D=&f%5B6%5D=&text=dns-prefetch&solrsort=iss_project_release_usage+desc&op=Search) that provides facilities for user agent resource hints.","font-display":"Specify `@font-display` when defining custom fonts in your theme."};YM.exports={id:"drupal",title:"Drupal",icon:Wee,UIStrings:Vee}});var JM=P((ZCe,XM)=>{d();var $ee='data:image/svg+xml,<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 82 82"><path fill="%235FA624" fill-rule="evenodd" d="M81.37 48.117C85.301 25.821 70.413 4.56 48.117.63 25.821-3.3 4.56 11.586.63 33.883-3.3 56.178 11.586 77.44 33.883 81.37 56.18 85.301 77.44 70.412 81.37 48.117Zm-8.935-14.17c2.77 12.357-1.942 25.721-12.96 33.436-14.57 10.203-34.656 6.662-44.859-7.909a32.434 32.434 0 0 1-2.869-4.98l28.7-20.097a6.53 6.53 0 1 0-3.744-5.347L9.564 48.054c-2.768-12.359 1.943-25.724 12.96-33.439 14.572-10.203 34.656-6.662 44.86 7.91a32.349 32.349 0 0 1 2.868 4.98L41.554 47.6a6.53 6.53 0 1 0 3.746 5.35l27.136-19.003Z"/></svg>',Yee={"unused-css-rules":"Use [Ezoic Leap](https://pubdash.ezoic.com/speed) and enable `Remove Unused CSS` to help with this issue. It will identify the CSS classes that are actually used on each page of your site, and remove any others to keep the file size small.","modern-image-formats":"Use [Ezoic Leap](https://pubdash.ezoic.com/sp\
eed) and enable `Next-Gen Formats` to convert images to WebP.","offscreen-images":"Use [Ezoic Leap](https://pubdash.ezoic.com/speed) and enable `Lazy Load Images` to defer loading off-screen images until they are needed.","render-blocking-resources":"Use [Ezoic Leap](https://pubdash.ezoic.com/speed) and enable `Critical CSS` and `Script Delay` to defer non-critical JS/CSS.","unminified-css":"Use [Ezoic Leap](https://pubdash.ezoic.com/speed) and enable `Minify CSS` to automatically minify your CSS to reduce network payload sizes.","unminified-javascript":"Use [Ezoic Leap](https://pubdash.ezoic.com/speed) and enable `Minify Javascript` to automatically minify your JS to reduce network payload sizes.","uses-long-cache-ttl":"Use [Ezoic Leap](https://pubdash.ezoic.com/speed) and enable `Efficient Static Cache Policy` to set recommended values in the caching header for static assests.","uses-optimized-images":"Use [Ezoic Leap](https://pubdash.ezoic.com/speed) and enable `Next-Gen Formats` to\
 convert images to WebP.","uses-responsive-images":"Use [Ezoic Leap](https://pubdash.ezoic.com/speed) and enable `Resize Images` to resize images to a device appropriate size, reducing network payload sizes.","server-response-time":"Use [Ezoic Cloud Caching](https://pubdash.ezoic.com/speed/caching) to cache your content across our world wide network, improving time to first byte.","uses-rel-preconnect":"Use [Ezoic Leap](https://pubdash.ezoic.com/speed) and enable `Pre-Connect Origins` to automatically add `preconnect` resource hints to establish early connections to important third-party origins.","uses-rel-preload":"Use [Ezoic Leap](https://pubdash.ezoic.com/speed) and enable `Preload Fonts` and `Preload Background Images` to add `preload` links to prioritize fetching resources that are currently requested later in page load.","font-display":"Use [Ezoic Leap](https://pubdash.ezoic.com/speed) and enable `Optimize Fonts` to automatically leverage the `font-display` CSS feature to ensure\
 text is user-visible while webfonts are loading."};XM.exports={id:"ezoic",title:"Ezoic",icon:$ee,UIStrings:Yee}});var QM=P((eke,ZM)=>{d();var Kee='data:image/svg+xml,<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 28 28"><circle cx="14" cy="14" r="14" fill="%23639"/><path fill="%23fff" d="M6.2 21.8C4.1 19.7 3 16.9 3 14.2L13.9 25c-2.8-.1-5.6-1.1-7.7-3.2zm10.2 2.9L3.3 11.6C4.4 6.7 8.8 3 14 3c3.7 0 6.9 1.8 8.9 4.5l-1.5 1.3C19.7 6.5 17 5 14 5c-3.9 0-7.2 2.5-8.5 6L17 22.5c2.9-1 5.1-3.5 5.8-6.5H18v-2h7c0 5.2-3.7 9.6-8.6 10.7z"/></svg>',Xee={"unused-css-rules":"Use the `PurgeCSS` `Gatsby` plugin to remove unused rules from stylesheets. [Learn more](https://purgecss.com/plugins/gatsby.html).","modern-image-formats":"Use the `gatsby-plugin-image` component instead of `<img>` to automatically optimize image format. [Learn more](https://www.gatsbyjs.com/docs/how-to/images-and-media/using-gatsby-plugin-image).","offscreen-images":"Use the `gatsby-plugin-image` component instead of `<img>` to automatically lazy-load images. [Learn more](https://www.gatsbyjs.com/docs/how-to/images-and-media/using-gatsby-pl\
ugin-image).","render-blocking-resources":"Use the `Gatsby Script API` to defer loading of non-critical third-party scripts. [Learn more](https://www.gatsbyjs.com/docs/reference/built-in-components/gatsby-script/).","unused-javascript":"Use `Webpack Bundle Analyzer` to detect unused JavaScript code. [Learn more](https://www.gatsbyjs.com/plugins/gatsby-plugin-webpack-bundle-analyser-v2/)","uses-long-cache-ttl":"Configure caching for immutable assets. [Learn more](https://www.gatsbyjs.com/docs/how-to/previews-deploys-hosting/caching/).","uses-optimized-images":"Use the `gatsby-plugin-image` component instead of `<img>` to adjust image quality. [Learn more](https://www.gatsbyjs.com/docs/how-to/images-and-media/using-gatsby-plugin-image).","uses-responsive-images":"Use the `gatsby-plugin-image` component to set appropriate `sizes`. [Learn more](https://www.gatsbyjs.com/docs/how-to/images-and-media/using-gatsby-plugin-image).","prioritize-lcp-image":"Use the `gatsby-plugin-image` component \
and set the `loading` prop to `eager`. [Learn more](https://www.gatsbyjs.com/docs/reference/built-in-components/gatsby-plugin-image#shared-props)."};ZM.exports={id:"gatsby",title:"Gatsby",icon:Kee,UIStrings:Xee}});var tL=P((nke,eL)=>{"use strict";d();var Jee='data:image/svg+xml,<svg xmlns="http://www.w3.org/2000/svg" preserveAspectRatio="xMidYMid" viewBox="0 0 256 258"><path fill="%23F9AE41" d="M255.7 35.6a33.7 33.7 0 0 0-67-4.8l-.4-.2c-27.6-12.4-50.8 9.6-50.8 9.6l-61.4 61.7 24.3 23.4 49.4-48.6c23-23 35.6-7.4 35.6-7.4 17.4 14.6.6 32 .6 32l24.9 24c20.3-22 21.5-41.1 15.3-56.3a33.7 33.7 0 0 0 29.5-33.4"/><path fill="%23EE4035" d="m226.5 190.5.2-.3c12.4-27.6-9.6-50.8-9.6-50.8L155.4 78l-23.3 24.3 48.5 49.4c23 23 7.5 35.6 7.5 35.6-14.7 17.4-32 .6-32 .6l-24 24.9c21.9 20.3 41 21.5 56.2 15.3a33.7 33.7 0 1 0 38.2-37.6"/><path fill="%234F91CD" d="m156 133-49.5 48.6c-23 23-35.6 7.4-35.6 7.4-17.4-14.6-.6-32-.6-32l-24.9-24c-20.3 22-21.4 41.1-15.3 56.3a33.7 33.7 0 1 0 37.6 38.2l.3.2c27.6 12.4 50.8-9.6 50.8-9.6l61.4-61.7-24.3-23.4"/><path fill="%237AC043" d="M75.7 106.6c-23-23-7.4-35.6-7.4-35.6 14.6-17.4 32-.6 32-.6l24-24.9c-22-20.3-41-21.5-56.3-15.3a33.7 33.7 0 1 0-38.2 37.6l-.2.3C17.2 95.7 39.2 119 39.2 119l6\
1.7 61.4 23.4-24.3-48.6-49.4"/></svg>',Zee={"unused-css-rules":"Consider reducing, or switching, the number of [Joomla extensions](https://extensions.joomla.org/) loading unused CSS in your page. To identify extensions that are adding extraneous CSS, try running [code coverage](https://developers.google.com/web/updates/2017/04/devtools-release-notes#coverage) in Chrome DevTools. You can identify the theme/plugin responsible from the URL of the stylesheet. Look out for plugins that have many stylesheets in the list which have a lot of red in code coverage. A plugin should only enqueue a stylesheet if it is actually used on the page.","modern-image-formats":"Consider using a [plugin](https://extensions.joomla.org/instant-search/?jed_live%5Bquery%5D=webp) or service that will automatically convert your uploaded images to the optimal formats.","offscreen-images":"Install a [lazy-load Joomla plugin](https://extensions.joomla.org/instant-search/?jed_live%5Bquery%5D=lazy%20loading) that provi\
des the ability to defer any offscreen images, or switch to a template that provides that functionality. Starting with Joomla 4.0, all new images will [automatically](https://github.com/joomla/joomla-cms/pull/30748) get the `loading` attribute from the core.","total-byte-weight":"Consider showing excerpts in your article categories (e.g. via the read more link), reducing the number of articles shown on a given page, breaking your long posts into multiple pages, or using a plugin to lazy-load comments.","render-blocking-resources":"There are a number of Joomla plugins that can help you [inline critical assets](https://extensions.joomla.org/instant-search/?jed_live%5Bquery%5D=performance) or [defer less important resources](https://extensions.joomla.org/instant-search/?jed_live%5Bquery%5D=performance). Beware that optimizations provided by these plugins may break features of your templates or plugins, so you will need to test these thoroughly.","unminified-css":"A number of [Joomla exten\
sions](https://extensions.joomla.org/instant-search/?jed_live%5Bquery%5D=performance) can speed up your site by concatenating, minifying, and compressing your css styles. There are also templates that provide this functionality.","unminified-javascript":"A number of [Joomla extensions](https://extensions.joomla.org/instant-search/?jed_live%5Bquery%5D=performance) can speed up your site by concatenating, minifying, and compressing your scripts. There are also templates that provide this functionality.","efficient-animated-content":"Consider uploading your GIF to a service which will make it available to embed as an HTML5 video.","unused-javascript":"Consider reducing, or switching, the number of [Joomla extensions](https://extensions.joomla.org/) loading unused JavaScript in your page. To identify plugins that are adding extraneous JS, try running [code coverage](https://developers.google.com/web/updates/2017/04/devtools-release-notes#coverage) in Chrome DevTools. You can identify the e\
xtension responsible from the URL of the script. Look out for extensions that have many scripts in the list which have a lot of red in code coverage. An extension should only enqueue a script if it is actually used on the page.","uses-long-cache-ttl":"Read about [Browser Caching in Joomla](https://docs.joomla.org/Cache).","uses-optimized-images":"Consider using an [image optimization plugin](https://extensions.joomla.org/instant-search/?jed_live%5Bquery%5D=performance) that compresses your images while retaining quality.","uses-text-compression":"You can enable text compression by enabling Gzip Page Compression in Joomla (System > Global configuration > Server).","uses-responsive-images":"Consider using a [responsive images plugin](https://extensions.joomla.org/instant-search/?jed_live%5Bquery%5D=responsive%20images) to use responsive images in your content.","server-response-time":"Templates, extensions, and server specifications all contribute to server response time. Consider findin\
g a more optimized template, carefully selecting an optimization extension, and/or upgrading your server."};eL.exports={id:"joomla",title:"Joomla",icon:Jee,UIStrings:Zee}});var rL=P((ake,nL)=>{d();var Qee='data:image/svg+xml,<svg xmlns="http://www.w3.org/2000/svg" fill="%23f26322" viewBox="0 0 1000 1000"><path d="M916.9 267.4v465.3l-111.3 67.4V331.4l-1.5-.9-303.9-189-304.6 189.2-1.2.8V799L83.1 732.6V267.4l.7-.4L500.3 10l416 257 .6.4zM560.7 468.5v383.3L500.3 890l-61-38.2V306.7l-136 84.3v476.6l197 122.5 196.4-122.5V391l-136-84.3v161.8z"/></svg>',ete={"modern-image-formats":"Consider searching the [Magento Marketplace](https://marketplace.magento.com/catalogsearch/result/?q=webp) for a variety of third-party extensions to leverage newer image formats.","offscreen-images":"Consider modifying your product and catalog templates to make use of the web platform's [lazy loading](https://web.dev/native-lazy-loading) feature.","disable-bundling":"Disable Magento's built-in [JavaScript bundling and minification](https://devdocs.magento.com/guides/v2.3/frontend-dev-guide/themes/js-bundling.html), and consider using [baler](https://github.com/magento/baler/) instead.",
"unminified-css":`Enable the "Minify CSS Files" option in your store's Developer settings. [Learn more](https://devdocs.magento.com/guides/v2.3/performance-best-practices/configuration.html?itm_source=devdocs&itm_medium=search_page&itm_campaign=federated_search&itm_term=minify%20css%20files).`,"unminified-javascript":"Use [Terser](https://www.npmjs.com/package/terser) to minify all JavaScript assets from static content deployment, and disable the built-in minification feature.","unused-javascript":"Disable Magento's built-in [JavaScript bundling](https://devdocs.magento.com/guides/v2.3/frontend-dev-guide/themes/js-bundling.html).","uses-optimized-images":"Consider searching the [Magento Marketplace](https://marketplace.magento.com/catalogsearch/result/?q=optimize%20image) for a variety of third party extensions to optimize images.","server-response-time":"Use Magento's [Varnish integration](https://devdocs.magento.com/guides/v2.3/config-guide/varnish/config-varnish.html).","uses-rel-pr\
econnect":"Preconnect or dns-prefetch resource hints can be added by [modifying a themes's layout](https://devdocs.magento.com/guides/v2.3/frontend-dev-guide/layouts/xml-manage.html).","uses-rel-preload":"`<link rel=preload>` tags can be added by [modifying a themes's layout](https://devdocs.magento.com/guides/v2.3/frontend-dev-guide/layouts/xml-manage.html).","critical-request-chains":"If you are not bundling your JavaScript assets, consider using [baler](https://github.com/magento/baler).","font-display":"Specify `@font-display` when [defining custom fonts](https://devdocs.magento.com/guides/v2.3/frontend-dev-guide/css-topics/using-fonts.html)."};nL.exports={id:"magento",title:"Magento",icon:Qee,UIStrings:ete}});var iL=P((oke,aL)=>{d();var tte='data:image/svg+xml,<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 207 124"><path fill="%23000" d="M48.942 32.632h38.96v3.082h-35.39v23.193H85.79v3.082H52.513v25.464h35.794v3.081H48.942V32.632Zm42.45 0h4.139l18.343 25.464 18.749-25.464L158.124.287l-41.896 60.485 21.59 29.762h-4.302l-19.642-27.086L94.15 90.534h-4.22l21.751-29.762-20.29-28.14Zm47.967 3.082v-3.082h44.397v3.082h-20.453v54.82h-3.571v-54.82h-20.373ZM.203 32.632h4.464l61.557 91.671-25.439-33.769L3.936 37.011l-.162 53.523H.203zm183.194 53.891c.738 0 1.276-.563 1.276-1.29 0-.727-.538-1.29-1.276-1.29-.73 0-1.277.563-1.277 1.29 0 .727.547 1.29 1.277 1.29Zm3.509-3.393c0 2.146 1.555 3.549 3.822 3.549 2.414 0 3.874-1.446 3.874-3.956v-8.837h-1.946v8.828c0 1.394-.704 2.138-1.946 2.138-1.112 0-1.867-.692-1.893-1.722h-1.911Zm10.24-.113c.14 2.233 2.007 3.662 4.787 3.662 2.97 0 4.83-1.498 4.83-3.887 0-1.878-1.06-2.917-3.632-3.514l-1.38-.338c-1.634-.38-2.294-.891-2.294-1.783 0-1.125 1.025-1.86 2.563-1.\
86 1.459 0 2.466.718 2.649 1.869h1.893c-.113-2.103-1.971-3.583-4.516-3.583-2.737 0-4.56 1.48-4.56 3.704 0 1.835 1.033 2.926 3.3 3.454l1.616.39c1.659.389 2.388.96 2.388 1.912 0 1.108-1.146 1.913-2.71 1.913-1.676 0-2.84-.753-3.005-1.939h-1.928Z"/></svg>',nte={"unused-css-rules":"Consider setting up `PurgeCSS` in `Next.js` configuration to remove unused rules from stylesheets. [Learn more](https://purgecss.com/guides/next.html).","modern-image-formats":"Use the `next/image` component instead of `<img>` to automatically optimize image format. [Learn more](https://nextjs.org/docs/basic-features/image-optimization).","offscreen-images":"Use the `next/image` component instead of `<img>` to automatically lazy-load images. [Learn more](https://nextjs.org/docs/basic-features/image-optimization).","render-blocking-resources":"Use the `next/script` component to defer loading of non-critical third-party scripts. [Learn more](https://nextjs.org/docs/basic-features/script).","unused-javascript":"Use \
`Webpack Bundle Analyzer` to detect unused JavaScript code. [Learn more](https://github.com/vercel/next.js/tree/canary/packages/next-bundle-analyzer)","uses-long-cache-ttl":"Configure caching for immutable assets and `Server-side Rendered` (SSR) pages. [Learn more](https://nextjs.org/docs/going-to-production#caching).","uses-optimized-images":"Use the `next/image` component instead of `<img>` to adjust image quality. [Learn more](https://nextjs.org/docs/basic-features/image-optimization).","uses-text-compression":"Enable compression on your Next.js server. [Learn more](https://nextjs.org/docs/api-reference/next.config.js/compression).","uses-responsive-images":"Use the `next/image` component to set the appropriate `sizes`. [Learn more](https://nextjs.org/docs/api-reference/next/image#sizes).","user-timings":"Consider using `Next.js Analytics` to measure your app's real-world performance. [Learn more](https://nextjs.org/docs/advanced-features/measuring-performance).","prioritize-lcp-ima\
ge":'Use the `next/image` component and set "priority" to true to preload LCP image. [Learn more](https://nextjs.org/docs/api-reference/next/image#priority).',"unsized-images":"Use the `next/image` component to make sure images are always sized appropriately. [Learn more](https://nextjs.org/docs/api-reference/next/image#width)."};aL.exports={id:"next.js",title:"Next.js",icon:tte,UIStrings:nte}});var sL=P((cke,oL)=>{d();var rte='data:image/svg+xml,<svg xmlns="http://www.w3.org/2000/svg" width="142" height="54"><g fill="none" fill-rule="evenodd"><g fill="%231B004E"><path d="M19.486 53.24h-3.891L4.682 39.247v13.936H0V32.946h5.444l9.475 12.398V32.946h4.567zM21.346 32.94h4.647v3.57h-4.647v-3.57Zm0 5.477h4.647V53.18h-4.647V38.417ZM40.569 53.183H36c-3.408 0-4.991-1.625-4.991-4.697v-6.22h-3.777V38.42h3.777v-5.474h4.598v5.474h4.958v3.846h-4.958v4.588c0 1.597.477 2.252 2.197 2.252h2.764v4.077ZM46.688 53.183h-4.57V38.42h4.57v2.308c.31-.686 1.351-2.336 4.425-2.336h3.13v4.56h-4.004c-2.593 0-3.55.967-3.55 3.019v7.212ZM70.612 45.802c0 4.56-3.409 7.75-8.01 7.75s-8.006-3.19-8.006-7.75c0-4.56 3.408-7.755 8.006-7.755 4.598 0 8.01 3.195 8.01 7.755Zm-4.599 0c0-2.14-1.35-3.733-3.408-3.733-2.057 0-3.44 1.594-3.44 3.733 0 2.139 1.41 3.733 3.44 3.733 2.03 0 3.408-1.598 3.408-3.733ZM72.47 32.946h11.7c4.543 0 7.192 2.28 7.192 6.526 0 4.247-2.649 6.577-7.191 6.577h-6.935v7.125h-4.765V32.946Zm4.766 4.218v\
4.676h6.485c1.832 0 2.736-.883 2.736-2.34 0-1.565-.904-2.336-2.736-2.336h-6.485ZM102.662 51.016c-.254.485-1.636 2.48-4.71 2.48-3.665 0-6.627-2.906-6.627-7.694 0-4.789 2.962-7.667 6.656-7.667 2.962 0 4.372 1.851 4.626 2.336v-2.05h4.567v14.762h-4.512v-2.167Zm-3.327-8.932c-2.03 0-3.384 1.594-3.384 3.733 0 2.14 1.354 3.733 3.384 3.733s3.327-1.597 3.327-3.733-1.298-3.733-3.327-3.733ZM119.184 43.578a2.98 2.98 0 0 0-2.749-1.494c-1.918 0-3.13 1.594-3.13 3.733 0 2.14 1.24 3.758 3.158 3.758 1.807 0 2.625-1.168 2.764-1.51h4.4c-.143 2.052-2.116 5.5-7.275 5.5-4.286 0-7.641-3.078-7.641-7.75 0-4.673 3.328-7.755 7.585-7.755 5.159 0 7.105 3.392 7.33 5.53l-4.442-.012ZM129.712 46.6v6.577h-4.567V32.194h4.567v11.998l5.838-5.784h5.751l-6.994 6.811 7.362 7.952h-5.921z"/></g><g fill="%2325F5CE"><path d="M49.159 4.65c12.832 0 23.235 10.41 23.235 23.251h4.648C77.042 12.491 64.558 0 49.159 0c-15.4 0-27.883 12.492-27.883 27.901h4.647c0-12.841 10.403-23.25 23.236-23.25Z"/><path d="M44.852 25.793a3.632 3.632 0 0 1 \
2.6-5.097L63.8 16.951 50.426 27.09a3.626 3.626 0 0 1-5.574-1.296Z"/></g></g></svg>',ate={"unused-css-rules":"Enable [`Reduce Unused CSS`](https://support.nitropack.io/hc/en-us/articles/360020418457-Reduce-Unused-CSS) to remove CSS rules that are not applicable to this page.","modern-image-formats":"Use [`Image Optimization`](https://support.nitropack.io/hc/en-us/articles/16547237162513) to automatically convert your images to WebP.","offscreen-images":"Defer offscreen images by enabling [`Automatic Image Lazy Loading`](https://support.nitropack.io/hc/en-us/articles/12457493524369-NitroPack-Lazy-Loading-Feature-for-Images).","render-blocking-resources":"Enable [`Remove render-blocking resources`](https://support.nitropack.io/hc/en-us/articles/13820893500049-How-to-Deal-with-Render-Blocking-Resources-in-NitroPack) in NitroPack for faster initial load times.","unminified-css":"Enable [`Minify resources`](https://support.nitropack.io/hc/en-us/articles/360061059394-Minify-Resources) in your\
 Caching settings to reduce the size of your CSS, HTML, and JavaScript files for faster load times.","unminified-javascript":"Enable [`Minify resources`](https://support.nitropack.io/hc/en-us/articles/360061059394-Minify-Resources) in your Caching settings to reduce the size of your JS, HTML, and CSS files for faster load times.","unused-javascript":"Configure [`Delayed Scripts`](https://support.nitropack.io/hc/en-us/articles/1500002600942-Delayed-Scripts) in NitroPack to delay loading of scripts until they are needed.","uses-long-cache-ttl":"Go to the [`Improve Server Response Time`](https://support.nitropack.io/hc/en-us/articles/1500002321821-Improve-Server-Response-Time) feature in the `Caching` menu and adjust your page cache expiration time to improve loading times and user experience.","uses-optimized-images":"Automatically compress, optimize, and convert your images into WebP by enabling the [`Image Optimization`](https://support.nitropack.io/hc/en-us/articles/14177271695121-How\
-to-serve-images-in-next-gen-formats-using-NitroPack) setting.","uses-text-compression":"Use [`Gzip compression`](https://support.nitropack.io/hc/en-us/articles/13229297479313-Enabling-GZIP-compression) in NitroPack to reduce the size of the files that are sent to the browser.","uses-responsive-images":"Enable [`Adaptive Image Sizing`](https://support.nitropack.io/hc/en-us/articles/10123833029905-How-to-Enable-Adaptive-Image-Sizing-For-Your-Site) to preemptively optimize your images and make them match the dimensions of the containers they’re displayed in across all devices.","server-response-time":"Improve server response time and optimize perceived performance by activating [`Instant Load`](https://support.nitropack.io/hc/en-us/articles/16547340617361).","dom-size":"Contact your account manager to enable [`HTML Lazy Load`](https://support.nitropack.io/hc/en-us/articles/17144942904337). Configuring it will prioritize and optimize your page rendering performance.","font-display":"Use\
 the [`Override Font Rendering Behavior`](https://support.nitropack.io/hc/en-us/articles/16547358865041) option in NitroPack to set a desired value for the CSS font-display rule."};oL.exports={id:"nitropack",title:"NitroPack",icon:rte,UIStrings:ate}});var uL=P((lke,cL)=>{d();var ite='data:image/svg+xml,<svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 512 512"><path fill="%2300DC82" d="M281.44 397.667h156.88c5.006 0 9.798-1.759 14.133-4.244.336-2.481 8.805-5.596 11.307-9.894 2.502-4.297 4.242-9.173 4.24-14.134-.002-4.962-1.734-9.836-4.24-14.131l-106-182.321c-2.502-4.297-5.559-7.413-9.893-9.894-4.335-2.48-10.542-4.24-15.547-4.24-5.005 0-9.799 1.76-14.133 4.24-4.335 2.481-7.392 5.597-9.894 9.894l-26.853 46.64-53.707-90.457c-2.504-4.296-5.557-8.823-9.893-11.303-4.336-2.481-9.127-2.827-14.133-2.827-5.006 0-9.798.346-14.134 2.827-4.335 2.48-8.802 7.007-11.306 11.303L46.827 355.268c-2.506 4.295-2.8259.169-2.827 14.131-.002 4.961.325 9.836 2.827 14.134 2.502 4.297 6.97 7.413 11.306 9.894 4.336 2.481 9.127 4.24 14.134 4.24H171.2c39.201 0 67.734-17.585 87.627-50.88L306.88 263.4l25.44-43.813 77.733 132.853H306.88l-25.44 45.227ZM169.787 352.44h-69.254l103.174-178.08L256 263.4l-34.639 60.384c-13.21 21.603-28.272 28.656-51.574 28.\
656Z"/></svg>',ote={"modern-image-formats":'Use the `nuxt/image` component and set `format="webp"`. [Learn more](https://image.nuxt.com/usage/nuxt-img#format).',"offscreen-images":'Use the `nuxt/image` component and set `loading="lazy"` for offscreen images. [Learn more](https://image.nuxt.com/usage/nuxt-img#loading).',"uses-optimized-images":"Use the `nuxt/image` component and set the appropriate `quality`. [Learn more](https://image.nuxt.com/usage/nuxt-img#quality).","uses-responsive-images":"Use the `nuxt/image` component and set the appropriate `sizes`. [Learn more](https://image.nuxt.com/usage/nuxt-img#sizes).","prioritize-lcp-image":"Use the `nuxt/image` component and specify `preload` for LCP image. [Learn more](https://image.nuxt.com/usage/nuxt-img#preload).","unsized-images":"Use the `nuxt/image` component and specify explicit `width` and `height`. [Learn more](https://image.nuxt.com/usage/nuxt-img#width-height)."};cL.exports={id:"nuxt",title:"Nuxt",icon:ite,UIStrings:ote}});var dL=P((mke,lL)=>{d();var ste='data:image/svg+xml,<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 310 310"><path fill="none" d="M-1-1h802v602H-1z"/><path fill="%23de6c26" d="M135 6.9c-14.2 4.4-34.9 21.8-49.9 42C55.8 88.5 39.6 135.8 41.4 177c.8 20.2 4.9 35.5 14.4 54.5 13.6 27.4 40.8 55.1 65.5 66.9 14.1 6.7 13.4 6.9 14.1-2.8.3-4.4 1-32.4 1.6-62.1 2.7-137.3 4.4-176 8.2-191.3.6-2.3 1.4-4.2 1.9-4.2 1.2 0 3.6 9.1 4.9 18.3.5 4.3 1 17.7 1 29.8 0 12 .3 21.9.7 21.9.3 0 5.7-5 11.9-11 6.9-6.8 12-11 13.3-11 1.8 0 1.9.3 1 2.7-1.2 3.1-7.9 13.2-19.1 28.5L153 128l.1 31.2c.1 17.2.4 37.4.8 44.9l.6 13.7 11-12.6c14-16 35.1-37.1 39.5-39.6l3.3-1.9-.6 3.2c-2 9.8-9.5 20.7-37.4 54.3L154 240.8v31.1c0 18.3.4 31.1.9 31.1 2.8 0 19.3-6.4 26.8-10.5 13.8-7.3 23.8-15 38.3-29.5 15.7-15.7 24.4-27.4 33.4-45.2 20.5-40 21-80.3 1.6-119-17.8-35.6-54.6-72.1-87.8-86.9-11.7-5.3-24.6-7.3-32.2-5z"/></svg>',cte={"unused-css-rules":"Consider reviewing the [plugins](https://octobercms.com/plugins) loading unused CSS on the web\
site. To identify plugins that add unnecessary CSS, run [code coverage](https://developers.google.com/web/updates/2017/04/devtools-release-notes#coverage) in Chrome DevTools. Identify the theme/plugin responsible from the stylesheet URL. Look for plugins with many stylesheets with lots of red in code coverage. A plugin should only add a stylesheet if it is actually used on the web page.","modern-image-formats":"Consider using a [plugin](https://octobercms.com/plugins?search=image) or service that will automatically convert the uploaded images to the optimal formats. [WebP lossless images](https://developers.google.com/speed/webp) are 26% smaller in size compared to PNGs and 25-34% smaller than comparable JPEG images at the equivalent SSIM quality index. Another next-gen image format to consider is [AVIF](https://jakearchibald.com/2020/avif-has-landed/).","offscreen-images":"Consider installing an [image lazy loading plugin](https://octobercms.com/plugins?search=lazy) that provides the \
ability to defer any offscreen images, or switch to a theme that provides that functionality. Also consider using [the AMP plugin](https://octobercms.com/plugins?search=Accelerated+Mobile+Pages).","total-byte-weight":"Consider showing excerpts in the post lists (e.g. using a `show more` button), reducing the number of posts shown on a given web page, breaking long posts into multiple web pages, or using a plugin to lazy-load comments.","render-blocking-resources":"There are many plugins that help [inline critical assets](https://octobercms.com/plugins?search=css). These plugins may break other plugins, so you should test thoroughly.","unminified-css":"There are many [plugins](https://octobercms.com/plugins?search=css) that can speed up a website by concatenating, minifying and compressing the styles. Using a build process to do this minification up-front can speed up development.","unminified-javascript":"There are many [plugins](https://octobercms.com/plugins?search=javascript) that c\
an speed up a website by concatenating, minifying and compressing the scripts. Using a build process to do this minification up-front can speed up development.","efficient-animated-content":"[Replace animated GIFs with video](https://web.dev/replace-gifs-with-videos/) for faster web page loads and consider using modern file formats such as [WebM](https://web.dev/replace-gifs-with-videos/#create-webm-videos) or [AV1](https://developers.google.com/web/updates/2018/09/chrome-70-media-updates#av1-decoder) to improve compression efficiency by greater than 30% over the current state-of-the-art video codec, VP9.","unused-javascript":"Consider reviewing the [plugins](https://octobercms.com/plugins?search=javascript) that load unused JavaScript in the web page. To identify plugins that add unnecessary JavaScript, run [code coverage](https://developers.google.com/web/updates/2017/04/devtools-release-notes#coverage) in Chrome DevTools. Identify the theme/plugin responsible from the URL of the scr\
ipt. Look for plugins with many scripts with lots of red in code coverage. A plugin should only add a script if it is actually used on the web page.","uses-long-cache-ttl":"Read about [preventing unnecessary network requests with the HTTP Cache](https://web.dev/http-cache/#caching-checklist). There are many [plugins](https://octobercms.com/plugins?search=Caching) that can be used to speed up caching.","uses-optimized-images":"Consider using an [image optimization plugin](https://octobercms.com/plugins?search=image) to compresses images while retaining the quality.","uses-text-compression":"Enable text compression in the web server configuration.","uses-responsive-images":"Upload images directly in the media manager to ensure the required image sizes are available. Consider using the [resize filter](https://octobercms.com/docs/markup/filter-resize) or an [image resizing plugin](https://octobercms.com/plugins?search=image) to ensure the optimal image sizes are used.","server-response-tim\
e":"Themes, plugins and server specifications all contribute to the server response time. Consider finding a more optimized theme, carefully selecting an optimization plugin and/or upgrade the server. October CMS also allows developers to use [`Queues`](https://octobercms.com/docs/services/queues) to defer the processing of a time consuming task, such as sending an e-mail. This drastically speeds up web requests."};lL.exports={id:"octobercms",title:"October CMS",icon:ste,UIStrings:cte}});var pL=P((fke,mL)=>{d();var ute='data:image/svg+xml,<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 841.9 595.3"><g fill="%2361DAFB"><path d="M666.3 296.5c0-32.5-40.7-63.3-103.1-82.4 14.4-63.6 8-114.2-20.2-130.4-6.5-3.8-14.1-5.6-22.4-5.6v22.3c4.6 0 8.3.9 11.4 2.6 13.6 7.8 19.5 37.5 14.9 75.7-1.1 9.4-2.9 19.3-5.1 29.4-19.6-4.8-41-8.5-63.5-10.9-13.5-18.5-27.5-35.3-41.6-50 32.6-30.3 63.2-46.9 84-46.9V78c-27.5 0-63.5 19.6-99.9 53.6-36.4-33.8-72.4-53.2-99.9-53.2v22.3c20.7 0 51.4 16.5 84 46.6-14 14.7-28 31.4-41.3 49.9-22.6 2.4-44 6.1-63.6 11-2.3-10-4-19.7-5.2-29-4.7-38.2 1.1-67.9 14.6-75.8 3-1.8 6.9-2.6 11.5-2.6V78.5c-8.4 0-16 1.8-22.6 5.6-28.1 16.2-34.4 66.7-19.9 130.1-62.2 19.2-102.7 49.9-102.7 82.3 0 32.5 40.7 63.3 103.1 82.4-14.4 63.6-8 114.2 20.2 130.4 6.5 3.8 14.1 5.6 22.5 5.6 27.5 0 63.5-19.6 99.9-53.6 36.4 33.8 72.4 53.2 99.9 53.2 8.4 0 16-1.8 22.6-5.6 28.1-16.2 34.4-66.7 19.9-130.1 62-19.1 102.5-49.9 102.5-82.3zm-130.2-66.7c-3.7 12.9-8.3 26.2-13.5 39.5-4.1-8-8.4-16-13.1-24-4.6-\
8-9.5-15.8-14.4-23.4 14.2 2.1 27.9 4.7 41 7.9zm-45.8 106.5c-7.8 13.5-15.8 26.3-24.1 38.2-14.9 1.3-30 2-45.2 2-15.1 0-30.2-.7-45-1.9-8.3-11.9-16.4-24.6-24.2-38-7.6-13.1-14.5-26.4-20.8-39.8 6.2-13.4 13.2-26.8 20.7-39.9 7.8-13.5 15.8-26.3 24.1-38.2 14.9-1.3 30-2 45.2-2 15.1 0 30.2.7 45 1.9 8.3 11.9 16.4 24.6 24.2 38 7.6 13.1 14.5 26.4 20.8 39.8-6.3 13.4-13.2 26.8-20.7 39.9zm32.3-13c5.4 13.4 10 26.8 13.8 39.8-13.1 3.2-26.9 5.9-41.2 8 4.9-7.7 9.8-15.6 14.4-23.7 4.6-8 8.9-16.1 13-24.1zM421.2 430c-9.3-9.6-18.6-20.3-27.8-32 9 .4 18.2.7 27.5.7 9.4 0 18.7-.2 27.8-.7-9 11.7-18.3 22.4-27.5 32zm-74.4-58.9c-14.2-2.1-27.9-4.7-41-7.9 3.7-12.9 8.3-26.2 13.5-39.5 4.1 8 8.4 16 13.1 24 4.7 8 9.5 15.8 14.4 23.4zM420.7 163c9.3 9.6 18.6 20.3 27.8 32-9-.4-18.2-.7-27.5-.7-9.4 0-18.7.2-27.8.7 9-11.7 18.3-22.4 27.5-32zm-74 58.9c-4.9 7.7-9.8 15.6-14.4 23.7-4.6 8-8.9 16-13 24-5.4-13.4-10-26.8-13.8-39.8 13.1-3.1 26.9-5.8 41.2-7.9zm-90.5 125.2c-35.4-15.1-58.3-34.9-58.3-50.6 0-15.7 22.9-35.6 58.3-50.6 8.6-3.7 18-7 27\
.7-10.1 5.7 19.6 13.2 40 22.5 60.9-9.2 20.8-16.6 41.1-22.2 60.6-9.9-3.1-19.3-6.5-28-10.2zM310 490c-13.6-7.8-19.5-37.5-14.9-75.7 1.1-9.4 2.9-19.3 5.1-29.4 19.6 4.8 41 8.5 63.5 10.9 13.5 18.5 27.5 35.3 41.6 50-32.6 30.3-63.2 46.9-84 46.9-4.5-.1-8.3-1-11.3-2.7zm237.2-76.2c4.7 38.2-1.1 67.9-14.6 75.8-3 1.8-6.9 2.6-11.5 2.6-20.7 0-51.4-16.5-84-46.6 14-14.7 28-31.4 41.3-49.9 22.6-2.4 44-6.1 63.6-11 2.3 10.1 4.1 19.8 5.2 29.1zm38.5-66.7c-8.6 3.7-18 7-27.7 10.1-5.7-19.6-13.2-40-22.5-60.9 9.2-20.8 16.6-41.1 22.2-60.6 9.9 3.1 19.3 6.5 28.1 10.2 35.4 15.1 58.3 34.9 58.3 50.6-.1 15.7-23 35.6-58.4 50.6zM320.8 78.4z"/><circle cx="420.9" cy="296.5" r="45.7"/><path d="M520.5 78.1z"/></g></svg>',lte={"unminified-css":"If your build system minifies CSS files automatically, ensure that you are deploying the production build of your application. You can check this with the React Developer Tools extension. [Learn more](https://reactjs.org/docs/optimizing-performance.html#use-the-production-build).","unmini\
fied-javascript":"If your build system minifies JS files automatically, ensure that you are deploying the production build of your application. You can check this with the React Developer Tools extension. [Learn more](https://reactjs.org/docs/optimizing-performance.html#use-the-production-build).","unused-javascript":"If you are not server-side rendering, [split your JavaScript bundles](https://web.dev/code-splitting-suspense/) with `React.lazy()`. Otherwise, code-split using a third-party library such as [loadable-components](https://www.smooth-code.com/open-source/loadable-components/docs/getting-started/).","server-response-time":"If you are server-side rendering any React components, consider using `renderToPipeableStream()` or `renderToStaticNodeStream()` to allow the client to receive and hydrate different parts of the markup instead of all at once. [Learn more](https://reactjs.org/docs/react-dom-server.html#renderToPipeableStream).",redirects:"If you are using React Router, mini\
mize usage of the `<Redirect>` component for [route navigations](https://reacttraining.com/react-router/web/api/Redirect).","user-timings":"Use the React DevTools Profiler, which makes use of the Profiler API, to measure the rendering performance of your components. [Learn more.](https://reactjs.org/blog/2018/09/10/introducing-the-react-profiler.html)","dom-size":'Consider using a "windowing" library like `react-window` to minimize the number of DOM nodes created if you are rendering many repeated elements on the page. [Learn more](https://web.dev/virtualize-long-lists-react-window/). Also, minimize unnecessary re-renders using [`shouldComponentUpdate`](https://reactjs.org/docs/optimizing-performance.html#shouldcomponentupdate-in-action), [`PureComponent`](https://reactjs.org/docs/react-api.html#reactpurecomponent), or [`React.memo`](https://reactjs.org/docs/react-api.html#reactmemo) and [skip effects](https://reactjs.org/docs/hooks-effect.html#tip-optimizing-performance-by-skipping-ef\
fects) only until certain dependencies have changed if you are using the `Effect` hook to improve runtime performance.'};mL.exports={id:"react",title:"React",icon:ute,UIStrings:lte}});var hL=P((gke,fL)=>{d();var dte='data:image/svg+xml,<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 71 28"><path fill-rule="evenodd" d="M0 .032s2.796-.356 4.66 1.31C5.81 2.37 6.145 4.008 6.145 4.008L9.952 18.96l3.165-12.239c.309-1.301.864-2.909 1.743-3.997 1.121-1.385 3.398-1.472 3.641-1.472.242 0 2.519.087 3.639 1.472.88 1.088 1.435 2.696 1.744 3.997l3.165 12.239 3.806-14.953s.336-1.638 1.486-2.666C34.205-.324 37 .032 37 .032l-7.289 27.945s-2.404.176-3.607-.446c-1.58-.816-2.332-1.447-3.289-5.249l-.099-.395c-.349-1.399-.883-3.59-1.424-5.813l-.162-.667-.162-.664c-.779-3.198-1.497-6.143-1.612-6.517-.108-.351-.236-1.187-.855-1.187-.607 0-.746.837-.857 1.187-.13.412-.99 3.955-1.856 7.514l-.162.667c-.512 2.107-1.01 4.151-1.341 5.48l-.1.395c-.956 3.802-1.708 4.433-3.288 5.249-1.204.622-3.608.446-3.608.446zM43.998 5v.995L44 5.994v16.628c-.014 3.413-.373 4.17-1.933 4.956-1.213.61-3.067.379-3.067.379V9.332c0-.935.315-1.548 1.477-2.098.693-.329 1.34-.58 2.012-.953C43.54 5.703 43.998 5 43.99\
8 5zM46 .125s3.877-.673 5.797 1.107c1.228 1.14 2.602 3.19 2.602 3.19l3.38 4.965c.164.258.378.54.72.54.343 0 .558-.282.722-.54l3.38-4.965s1.374-2.05 2.602-3.19C67.123-.548 71 .125 71 .125l-9.186 13.923 9.161 13.881-.032.004c-.38.045-4.036.423-5.855-1.266-1.229-1.138-2.487-2.992-2.487-2.992l-3.38-4.964c-.164-.26-.379-.54-.721-.54-.343 0-.557.28-.721.54l-3.38 4.964s-1.19 1.854-2.418 2.992c-1.92 1.783-5.957 1.262-5.957 1.262l9.161-13.88zM43.96 0H44c0 1.91-.186 3.042-1.387 3.923-.384.28-1.048.71-1.826.992C39.719 5.304 39 6 39 6c0-3.476.53-4.734 1.95-5.48.865-.452 2.272-.514 2.82-.52z"></path></svg>',mte={"modern-image-formats":"Upload images using `Wix Media Manager` to ensure they are automatically served as WebP. Find [more ways to optimize](https://support.wix.com/en/article/site-performance-optimizing-your-media) your site's media.","render-blocking-resources":"When [adding third-party code](https://support.wix.com/en/article/site-performance-using-third-party-code-on-your-site) in the \
`Custom Code` tab of your site's dashboard, make sure it's deferred or loaded at the end of the code body. Where possible, use Wix’s [integrations](https://support.wix.com/en/article/about-marketing-integrations) to embed marketing tools on your site. ","efficient-animated-content":"Place videos inside `VideoBoxes`, customize them using `Video Masks` or add `Transparent Videos`. [Learn more](https://support.wix.com/en/article/wix-video-about-wix-video).","unused-javascript":"Review any third-party code you've added to your site in the `Custom Code` tab of your site's dashboard and only keep the services that are necessary to your site. [Find out more](https://support.wix.com/en/article/site-performance-removing-unused-javascript).","server-response-time":"Wix utilizes CDNs and caching to serve responses as fast as possible for most visitors. Consider [manually enabling caching](https://support.wix.com/en/article/site-performance-caching-pages-to-optimize-loading-speed) for your site,\
 especially if using `Velo`."};fL.exports={id:"wix",title:"Wix",icon:dte,UIStrings:mte}});var yL=P((vke,gL)=>{d();var pte='data:image/svg+xml,<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 122.5 122.5"><g fill="%232f3439"><path d="M8.7 61.3c0 20.8 12.1 38.7 29.6 47.3l-25-68.7c-3 6.5-4.6 13.7-4.6 21.4zm88-2.7c0-6.5-2.3-11-4.3-14.5-2.7-4.3-5.2-8-5.2-12.3 0-4.8 3.7-9.3 8.9-9.3h.7a52.4 52.4 0 0 0-79.4 9.9h3.3c5.5 0 14-.6 14-.6 2.9-.2 3.2 4 .4 4.3 0 0-2.9.4-6 .5l19.1 57L59.7 59l-8.2-22.5c-2.8-.1-5.5-.5-5.5-.5-2.8-.1-2.5-4.5.3-4.3 0 0 8.7.7 13.9.7 5.5 0 14-.7 14-.7 2.8-.2 3.2 4 .3 4.3 0 0-2.8.4-6 .5l19 56.5 5.2-17.5c2.3-7.3 4-12.5 4-17z"/><path d="m62.2 65.9-15.8 45.8a52.6 52.6 0 0 0 32.3-.9l-.4-.7zM107.4 36a49.6 49.6 0 0 1-3.6 24.2l-16.1 46.5A52.5 52.5 0 0 0 107.4 36z"/><path d="M61.3 0a61.3 61.3 0 1 0 .1 122.7A61.3 61.3 0 0 0 61.3 0zm0 119.7a58.5 58.5 0 1 1 .1-117 58.5 58.5 0 0 1-.1 117z"/></g></svg>',fte={"unused-css-rules":"Consider reducing, or switching, the number of [WordPress plugins](https://wordpress.org/plugins/) loading unused CSS in your page. To identify plug\
ins that are adding extraneous CSS, try running [code coverage](https://developer.chrome.com/docs/devtools/coverage/) in Chrome DevTools. You can identify the theme/plugin responsible from the URL of the stylesheet. Look out for plugins that have many stylesheets in the list which have a lot of red in code coverage. A plugin should only enqueue a stylesheet if it is actually used on the page.","modern-image-formats":"Consider using the [Performance Lab](https://wordpress.org/plugins/performance-lab/) plugin to automatically convert your uploaded JPEG images into WebP, wherever supported.","offscreen-images":"Install a [lazy-load WordPress plugin](https://wordpress.org/plugins/search/lazy+load/) that provides the ability to defer any offscreen images, or switch to a theme that provides that functionality. Also consider using [the AMP plugin](https://wordpress.org/plugins/amp/).","total-byte-weight":"Consider showing excerpts in your post lists (e.g. via the more tag), reducing the numbe\
r of posts shown on a given page, breaking your long posts into multiple pages, or using a plugin to lazy-load comments.","render-blocking-resources":"There are a number of WordPress plugins that can help you [inline critical assets](https://wordpress.org/plugins/search/critical+css/) or [defer less important resources](https://wordpress.org/plugins/search/defer+css+javascript/). Beware that optimizations provided by these plugins may break features of your theme or plugins, so you will likely need to make code changes.","unminified-css":"A number of [WordPress plugins](https://wordpress.org/plugins/search/minify+css/) can speed up your site by concatenating, minifying, and compressing your styles. You may also want to use a build process to do this minification up-front if possible.","unminified-javascript":"A number of [WordPress plugins](https://wordpress.org/plugins/search/minify+javascript/) can speed up your site by concatenating, minifying, and compressing your scripts. You may \
also want to use a build process to do this minification up front if possible.","efficient-animated-content":"Consider uploading your GIF to a service which will make it available to embed as an HTML5 video.","unused-javascript":"Consider reducing, or switching, the number of [WordPress plugins](https://wordpress.org/plugins/) loading unused JavaScript in your page. To identify plugins that are adding extraneous JS, try running [code coverage](https://developer.chrome.com/docs/devtools/coverage/) in Chrome DevTools. You can identify the theme/plugin responsible from the URL of the script. Look out for plugins that have many scripts in the list which have a lot of red in code coverage. A plugin should only enqueue a script if it is actually used on the page.","uses-long-cache-ttl":"Read about [Browser Caching in WordPress](https://wordpress.org/support/article/optimization/#browser-caching).","uses-optimized-images":"Consider using an [image optimization WordPress plugin](https://wordpr\
ess.org/plugins/search/optimize+images/) that compresses your images while retaining quality.","uses-text-compression":"You can enable text compression in your web server configuration.","uses-responsive-images":"Upload images directly through the [media library](https://wordpress.org/support/article/media-library-screen/) to ensure that the required image sizes are available, and then insert them from the media library or use the image widget to ensure the optimal image sizes are used (including those for the responsive breakpoints). Avoid using `Full Size` images unless the dimensions are adequate for their usage. [Learn More](https://wordpress.org/support/article/inserting-images-into-posts-and-pages/).","server-response-time":"Themes, plugins, and server specifications all contribute to server response time. Consider finding a more optimized theme, carefully selecting an optimization plugin, and/or upgrading your server."};gL.exports={id:"wordpress",title:"WordPress",icon:pte,UIStrings:fte}});var bL=P((wke,vL)=>{d();var hte='data:image/svg+xml,<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 294 524"><defs><linearGradient id="a" x1="36.742%" x2="37.116%" y1="100.518%" y2="-.001%"><stop offset="0%" stop-color="%23DD5F29"/><stop offset="26.042%" stop-color="%23F26B32"/><stop offset="100%" stop-color="%23FAC932"/></linearGradient><linearGradient id="b" x1="28.046%" x2="28.421%" y1="100.518%" y2="-.003%"><stop offset="0%" stop-color="%23DD5F29"/><stop offset="26.042%" stop-color="%23F26B32"/><stop offset="100%" stop-color="%23FAC932"/></linearGradient><linearGradient id="c" x1="38.215%" x2="38.589%" y1="100.518%" y2="0%"><stop offset="0%" stop-color="%23DD5F29"/><stop offset="26.042%" stop-color="%23F26B32"/><stop offset="100%" stop-color="%23FAC932"/></linearGradient></defs><g fill="none" fill-rule="evenodd"><path fill="url(%23a)" d="M218.617 270.615c-9.752 0-18.896-5.689-23.366-14.63l-7.72-17.27h-76.6l-7.722 17.27c-4.47 8.941-13.613 14.63-23.366 14.63H75.78l32.712 249.306\
c1.625 4.671 4.673 4.671 6.502 0l32.51-79.648 28.242 79.442c1.625 4.676 4.673 4.676 6.501 0L220.04 270.82l-1.423-.204Z" transform="translate(-1.58 -.2)"/><path fill="url(%23b)" d="M184.47 231.784h-70.3l-10.77 24.179c-3.657 7.314-10.768 12.597-18.489 14.02L109.7 423.791c1.625 2.844 4.673 2.844 6.501 0l31.697-48.155 29.055 47.951c1.829 2.845 4.673 2.845 6.502 0l28.039-154.012c-6.908-2.032-13.004-6.908-16.255-13.613l-10.768-24.18Z" transform="translate(-1.58 -.2)"/><path fill="url(%23c)" d="m195.259 255.988-46.123-103.014-45.92 103.014c-1.625 3.048-3.656 5.69-6.095 7.925l19.1 102.2c1.015 1.423 3.657 1.83 5.485 0l25.601-33.931 25.602 33.728c1.625 2.032 4.47 1.626 5.485 0l21.131-103.42c-1.625-2.032-3.047-4.064-4.266-6.502Z" transform="translate(-1.58 -.2)"/><path fill="%23F56F46" d="M.439 12.559c-1.422-4.877 1.422-8.33 6.299-8.33H47.17c2.845 0 5.486 2.437 6.299 4.876l29.665 116.83h1.422l53.437-121.3c1.016-2.032 3.048-3.86 5.892-3.86h6.299c3.047 0 5.08 1.625 5.892 3.86l53.437 121.3h1.423L240\
.6 9.105c.61-2.439 3.454-4.877 6.299-4.877h40.433c4.877 0 7.518 3.454 6.299 8.33l-65.221 231.63c-.61 2.845-3.454 4.876-6.298 4.876h-5.487c-2.438 0-4.876-1.625-5.892-3.86l-63.19-141.009h-1.015L83.744 245.203c-1.016 2.032-3.454 3.86-5.892 3.86h-5.486c-2.845 0-5.486-2.031-6.299-4.876L.44 12.559Z"/></g></svg>',gte={"unused-css-rules":"Enable [Remove Unused CSS](https://docs.wp-rocket.me/article/1529-remove-unused-css) in 'WP Rocket' to fix this issue. It reduces page size by removing all CSS and stylesheets that are not used while keeping only the used CSS for each page.","modern-image-formats":"Enable 'Imagify' from the Image Optimization tab in 'WP Rocket' to convert your images to WebP.","unused-javascript":"Enable [Delay JavaScript execution](https://docs.wp-rocket.me/article/1349-delay-javascript-execution) in 'WP Rocket' to fix this problem. It will improve the loading of your page by delaying the execution of scripts until user interaction. If your site has iframes, you can use WP R\
ocket's [LazyLoad for iframes and videos](https://docs.wp-rocket.me/article/1674-lazyload-for-iframes-and-videos) and [Replace YouTube iframe with preview image](https://docs.wp-rocket.me/article/1488-replace-youtube-iframe-with-preview-image) as well.","render-blocking-resources":"Enable [Remove Unused CSS](https://docs.wp-rocket.me/article/1529-remove-unused-css) and [Load JavaScript deferred](https://docs.wp-rocket.me/article/1265-load-javascript-deferred) in 'WP Rocket' to address this recommendation. These features will respectively optimize the CSS and JavaScript files so that they don't block the rendering of your page.","unminified-css":"Enable [Minify CSS files](https://docs.wp-rocket.me/article/1350-css-minify-combine) in 'WP Rocket' to fix this issue. Any spaces and comments in your site's CSS files will be removed to make the file size smaller and faster to download.","unminified-javascript":"Enable [Minify JavaScript files](https://docs.wp-rocket.me/article/1351-javascript\
-minify-combine) in 'WP Rocket' to fix this issue. Empty spaces and comments will be removed from JavaScript files to make their size smaller and faster to download.","uses-optimized-images":"Enable 'Imagify' from the Image Optimization tab in 'WP Rocket' and run Bulk Optimization to compress your images.","uses-rel-preconnect":`Use [Prefetch DNS Requests](https://docs.wp-rocket.me/article/1302-prefetch-dns-requests) in 'WP Rocket' to add "dns-prefetch" and speed up the connection with external domains. Also, 'WP Rocket' automatically adds "preconnect" to [Google Fonts domain](https://docs.wp-rocket.me/article/1312-optimize-google-fonts) and any CNAME(S) added via the [Enable CDN](https://docs.wp-rocket.me/article/42-using-wp-rocket-with-a-cdn) feature.`,"uses-rel-preload":"To fix this issue for fonts, enable [Remove Unused CSS](https://docs.wp-rocket.me/article/1529-remove-unused-css) in 'WP Rocket'. Your site's critical fonts will be preloaded with priority.","offscreen-images":"Enab\
le [LazyLoad](https://docs.wp-rocket.me/article/1141-lazyload-for-images) in WP Rocket to fix this recommendation. This feature delays the loading of the images until the visitor scrolls down the page and actually needs to see them."};vL.exports={id:"wp-rocket",title:"WP Rocket",icon:hte,UIStrings:gte}});var DL=P((Eke,wL)=>{d();var yte=[WM(),$M(),KM(),JM(),QM(),tL(),rL(),iL(),sL(),uL(),dL(),pL(),hL(),yL(),bL()];wL.exports=yte});var TL=P((xke,EL)=>{d();EL.exports=s(function(t,n){if(typeof t=="string"&&n[t])return t;for(var r=[].concat(t||[]),a=0,i=r.length;a<i;++a)for(var o=r[a].split("-");o.length;){var c=o.join("-");if(n[c])return c;o.pop()}},"lookupClosestLocale")});var Cf,vte,kf,Ls=v(()=>{"use strict";d();Da();ri();go();Cf=Rt.dirname(""),vte=JSON.parse(`{
  "name": "lighthouse",
  "type": "module",
  "version": "11.6.0",
  "description": "Automated auditing, performance metrics, and best practices for the web.",
  "main": "./core/index.js",
  "bin": {
    "lighthouse": "./cli/index.js",
    "chrome-debug": "./core/scripts/manual-chrome-launcher.js",
    "smokehouse": "./cli/test/smokehouse/frontends/smokehouse-bin.js"
  },
  "engines": {
    "node": ">=18.16"
  },
  "scripts": {
    "prepack": "yarn build-report --standalone --flow --esm && yarn build-types",
    "postpack": "yarn clean-types",
    "build-all": "npm-run-posix-or-windows build-all:task",
    "build-all:task": "yarn build-report && yarn build-cdt-lib && yarn build-devtools && concurrently 'yarn build-extension' 'yarn build-lr' 'yarn build-viewer' 'yarn build-treemap' 'yarn build-smokehouse-bundle' && yarn build-pack",
    "build-all:task:windows": "yarn build-report && yarn build-cdt-lib && yarn build-extension && yarn build-devtools && yarn build-lr && yarn build-viewer && yarn build-treemap && yarn build-smokehouse-bundle",
    "build-cdt-lib": "node ./build/build-cdt-lib.js",
    "build-extension": "yarn build-extension-chrome && yarn build-extension-firefox",
    "build-extension-chrome": "node ./build/build-extension.js chrome",
    "build-extension-firefox": "node ./build/build-extension.js firefox",
    "build-devtools": "yarn reset-link && node ./build/build-bundle.js clients/devtools/devtools-entry.js dist/lighthouse-dt-bundle.js && node ./build/build-dt-report-resources.js",
    "build-smokehouse-bundle": "node ./build/build-smokehouse-bundle.js",
    "build-lr": "yarn reset-link && node --max-old-space-size=4096 ./build/build-lightrider-bundles.js",
    "build-pack": "bash build/build-pack.sh",
    "build-report": "node build/build-report-components.js && node build/build-report.js",
    "build-sample-reports": "yarn build-report && node build/build-sample-reports.js",
    "build-treemap": "node ./build/build-treemap.js",
    "build-viewer": "node ./build/build-viewer.js",
    "build-types": "yarn type-check && rsync -a .tmp/tsbuildinfo/ ./ --include='*.d.ts' --include='*.d.cts' --exclude='*.map' --exclude='*.tsbuildinfo'",
    "reset-link": "(yarn unlink || true) && yarn link && yarn link lighthouse",
    "c8": "bash core/scripts/c8.sh",
    "clean": "rm -r dist proto/scripts/*.json proto/scripts/*_pb2.* proto/scripts/*_pb.* proto/scripts/__pycache__ proto/scripts/*.pyc *.report.html *.report.dom.html *.report.json *.devtoolslog.json *.trace.json shared/localization/locales/*.ctc.json || true",
    "clean-types": "git clean -xfq '*.d.ts' '*.d.cts' -e 'node_modules/' -e 'dist/' -e '.tmp/' -e '**/types/'",
    "lint": "[ \\"$CI\\" = true ] && eslint --quiet -f codeframe . || eslint .",
    "smoke": "node -r source-map-support/register cli/test/smokehouse/frontends/smokehouse-bin.js",
    "debug": "node --inspect-brk ./cli/index.js",
    "start": "yarn build-report --standalone && node ./cli/index.js",
    "mocha": "node --loader=testdouble core/test/scripts/run-mocha-tests.js",
    "test": "yarn diff:sample-json && yarn lint --quiet && yarn unit && yarn type-check",
    "test-bundle": "yarn smoke --runner bundle",
    "test-clients": "yarn mocha --testMatch clients/**/*-test.js && yarn mocha --testMatch clients/**/*-test-pptr.js",
    "test-viewer": "yarn unit-viewer && yarn mocha --testMatch viewer/**/*-test-pptr.js --timeout 35000",
    "test-treemap": "yarn unit-treemap && yarn mocha --testMatch treemap/**/*-test-pptr.js --timeout 35000",
    "test-lantern": "bash core/scripts/test-lantern.sh",
    "test-legacy-javascript": "bash core/scripts/test-legacy-javascript.sh",
    "test-docs": "yarn --cwd docs/recipes/ test",
    "test-proto": "yarn compile-proto && yarn build-proto-roundtrip",
    "unit-core": "yarn mocha core",
    "unit-cli": "yarn mocha --testMatch cli/**/*-test.js",
    "unit-report": "yarn mocha --testMatch report/**/*-test.js",
    "unit-treemap": "yarn mocha --testMatch treemap/**/*-test.js",
    "unit-viewer": "yarn mocha --testMatch viewer/**/*-test.js",
    "unit-flow": "bash flow-report/test/run-flow-report-tests.sh",
    "unit": "yarn unit-flow && yarn mocha",
    "unit:ci": "NODE_OPTIONS=--max-old-space-size=8192 npm run unit",
    "core-unit": "yarn unit-core",
    "cli-unit": "yarn unit-cli",
    "viewer-unit": "yarn unit-viewer",
    "watch": "yarn unit-core --watch",
    "unit:cicoverage": "yarn c8 --all yarn unit:ci",
    "coverage": "yarn unit:cicoverage && c8 report --reporter html",
    "coverage:smoke": "yarn c8 yarn smoke -j=1 && c8 report --reporter html",
    "devtools": "bash core/scripts/roll-to-devtools.sh",
    "chrome": "node core/scripts/manual-chrome-launcher.js",
    "fast": "node ./cli/index.js --preset=desktop --throttlingMethod=provided",
    "deploy-treemap": "yarn build-treemap --deploy",
    "deploy-viewer": "yarn build-viewer --deploy",
    "vercel-build": "yarn build-sample-reports && yarn build-viewer && yarn build-treemap",
    "dogfood-lhci": "./core/scripts/dogfood-lhci.sh",
    "timing-trace": "node core/scripts/generate-timing-trace.js",
    "changelog": "conventional-changelog --config ./build/changelog-generator/index.cjs --infile changelog.md --same-file",
    "type-check": "tsc --build ./tsconfig-all.json",
    "i18n:checks": "./core/scripts/i18n/assert-strings-collected.sh",
    "i18n:collect-strings": "node core/scripts/i18n/collect-strings.js",
    "update:lantern-baseline": "node core/scripts/lantern/update-baseline-lantern-values.js",
    "update:sample-artifacts": "node core/scripts/update-report-fixtures.js",
    "update:sample-json": "yarn i18n:collect-strings && node ./cli -A=./core/test/results/artifacts --config-path=./core/test/results/sample-config.js --output=json --output-path=./core/test/results/sample_v2.json && node core/scripts/cleanup-LHR-for-diff.js ./core/test/results/sample_v2.json --only-remove-timing && node ./core/scripts/update-flow-fixtures.js",
    "update:flow-sample-json": "yarn i18n:collect-strings && node ./core/scripts/update-flow-fixtures.js",
    "test-devtools": "bash core/test/devtools-tests/test-locally.sh",
    "open-devtools": "bash core/scripts/open-devtools.sh",
    "run-devtools": "node core/scripts/pptr-run-devtools.js",
    "diff:sample-json": "yarn i18n:checks && bash core/scripts/assert-golden-lhr-unchanged.sh",
    "diff:flow-sample-json": "yarn i18n:collect-strings && bash core/scripts/assert-baseline-flow-result-unchanged.sh",
    "computeBenchmarkIndex": "./core/scripts/benchmark.js",
    "save-latest-run": "./core/scripts/save-latest-run.sh",
    "compile-proto": "protoc --python_out=./ ./proto/lighthouse-result.proto && mv ./proto/*_pb2.py ./proto/scripts || (echo \\"❌ Install protobuf = 3.20.x to compile the proto file.\\" && false)",
    "build-proto-roundtrip": "mkdir -p .tmp && python3 proto/scripts/json_roundtrip_via_proto.py",
    "static-server": "node cli/test/fixtures/static-server.js",
    "serve-dist": "cd dist && python3 -m http.server 7878",
    "serve-gh-pages": "cd dist/gh-pages && python3 -m http.server 7333",
    "serve-treemap": "yarn serve-gh-pages",
    "serve-viewer": "yarn serve-gh-pages",
    "flow-report": "yarn build-report --flow && node ./core/scripts/build-test-flow-report.js"
  },
  "devDependencies": {
    "@build-tracker/cli": "^1.0.0-beta.15",
    "@esbuild-kit/esm-loader": "^2.1.1",
    "@esbuild-plugins/node-modules-polyfill": "^0.1.4",
    "@formatjs/icu-messageformat-parser": "^2.6.2",
    "@jest/fake-timers": "^28.1.0",
    "@testing-library/preact": "^3.1.1",
    "@testing-library/preact-hooks": "^1.1.0",
    "@types/archiver": "^2.1.2",
    "@types/chrome": "^0.0.154",
    "@types/configstore": "^4.0.0",
    "@types/cpy": "^5.1.0",
    "@types/debug": "^4.1.7",
    "@types/eslint": "^8.2.1",
    "@types/estree": "^0.0.50",
    "@types/gh-pages": "^2.0.0",
    "@types/google.analytics": "0.0.39",
    "@types/jpeg-js": "^0.3.7",
    "@types/jsdom": "^16.2.13",
    "@types/lodash": "^4.14.178",
    "@types/mocha": "^9.0.0",
    "@types/node": "*",
    "@types/pako": "^1.0.1",
    "@types/resize-observer-browser": "^0.1.1",
    "@types/resolve": "^1.20.2",
    "@types/semver": "^5.5.0",
    "@types/tabulator-tables": "^4.9.1",
    "@types/ws": "^7.0.0",
    "@types/yargs": "^17.0.8",
    "@types/yargs-parser": "^20.2.1",
    "@typescript-eslint/eslint-plugin": "^5.48.0",
    "@typescript-eslint/parser": "^5.48.0",
    "acorn": "^8.5.0",
    "angular": "^1.7.4",
    "archiver": "^3.0.0",
    "builtin-modules": "^3.3.0",
    "c8": "^7.11.3",
    "chalk": "^2.4.1",
    "chrome-devtools-frontend": "1.0.1153166",
    "concurrently": "^6.4.0",
    "conventional-changelog-cli": "^2.1.1",
    "cpy": "^8.1.2",
    "cross-env": "^7.0.2",
    "csv-validator": "^0.0.3",
    "es-main": "^1.2.0",
    "esbuild": "0.19.11",
    "eslint": "^8.4.1",
    "eslint-config-google": "^0.14.0",
    "eslint-formatter-codeframe": "^7.32.1",
    "eslint-plugin-import": "^2.25.3",
    "eslint-plugin-local-rules": "1.1.0",
    "event-target-shim": "^6.0.2",
    "expect": "^28.1.0",
    "firebase": "^9.0.2",
    "gh-pages": "^2.0.1",
    "glob": "^7.1.3",
    "idb-keyval": "2.2.0",
    "jest-mock": "^27.3.0",
    "jest-snapshot": "^28.1.0",
    "jsdom": "^12.2.0",
    "lighthouse-plugin-publisher-ads": "1.5.7-beta",
    "lighthouse-plugin-soft-navigation": "^1.0.1",
    "magic-string": "^0.25.7",
    "mime-types": "^2.1.30",
    "mocha": "^10.0.0",
    "node-fetch": "^2.6.1",
    "npm-run-posix-or-windows": "^2.0.2",
    "pako": "^2.0.3",
    "preact": "^10.7.2",
    "pretty-json-stringify": "^0.0.2",
    "puppeteer": "^22.1.0",
    "resolve": "^1.22.1",
    "rollup": "^2.52.7",
    "rollup-plugin-polyfill-node": "^0.12.0",
    "source-map-support": "^0.5.21",
    "tabulator-tables": "^4.9.3",
    "terser": "^5.18.2",
    "testdouble": "^3.18.0",
    "typed-query-selector": "^2.6.1",
    "typescript": "^5.0.4",
    "wait-for-expect": "^3.0.2",
    "webtreemap-cdt": "^3.2.1"
  },
  "dependencies": {
    "@paulirish/trace_engine": "^0.0.12",
    "@sentry/node": "^6.17.4",
    "axe-core": "^4.8.4",
    "chrome-launcher": "^1.1.0",
    "configstore": "^5.0.1",
    "csp_evaluator": "1.1.1",
    "devtools-protocol": "0.0.1232444",
    "enquirer": "^2.3.6",
    "http-link-header": "^1.1.1",
    "intl-messageformat": "^10.5.3",
    "jpeg-js": "^0.4.4",
    "js-library-detector": "^6.7.0",
    "lighthouse-logger": "^2.0.1",
    "lighthouse-stack-packs": "1.12.1",
    "lodash": "^4.17.21",
    "lookup-closest-locale": "6.2.0",
    "metaviewport-parser": "0.3.0",
    "open": "^8.4.0",
    "parse-cache-control": "1.0.1",
    "ps-list": "^8.0.0",
    "puppeteer-core": "^22.1.0",
    "robots-parser": "^3.0.1",
    "semver": "^5.3.0",
    "speedline-core": "^1.4.3",
    "third-party-web": "^0.24.1",
    "tldts-icann": "^6.1.0",
    "ws": "^7.0.0",
    "yargs": "^17.3.1",
    "yargs-parser": "^21.0.0"
  },
  "resolutions": {
    "puppeteer/**/devtools-protocol": "0.0.1232444",
    "puppeteer-core/**/devtools-protocol": "0.0.1232444"
  },
  "repository": "GoogleChrome/lighthouse",
  "keywords": [
    "google",
    "chrome",
    "devtools"
  ],
  "author": "Google LLC",
  "license": "Apache-2.0",
  "bugs": {
    "url": "https://github.com/GoogleChrome/lighthouse/issues"
  },
  "homepage": "https://github.com/GoogleChrome/lighthouse#readme"
}
`),kf=vte.version});function Af(e,t){if(typeof Intl!="object")throw new Error("Lighthouse must be run in Node with `Intl` support. See https://nodejs.org/api/intl.html for help");let n=Intl.getCanonicalLocales(e),r=Intl.NumberFormat.supportedLocalesOf(n),a=t||zM(),i=Object.fromEntries(a.map(c=>[c,{}])),o=(0,xL.default)(r,i);return o||(Intl.NumberFormat.supportedLocalesOf("es").length===0&&F.warn("i18n","Requested locale not available in this version of node. The `full-icu` npm module can provide additional locales. For help, see https://github.com/GoogleChrome/lighthouse/blob/main/readme.md#how-do-i-get-localized-lighthouse-results-via-the-cli"),F.warn("i18n",`locale(s) '${e}' not available. Falling back to default '${Ns}'`)),o||Ns}function D(e,t={}){e.startsWith("file://")&&(e=ho.fileURLToPath(e)),Rt.isAbsolute(e)&&(e=Rt.relative(Cf,e));let n={...C,...t};return s((a,i)=>{let o=Object.keys(n).find(m=>n[m]===a);if(!o)throw new Error(`Could not locate: ${a}`);return{i18nId:`${(o in t?e:Rt.relative(Cf,FM({url:"\
core/lib/i18n/i18n.js"}))).replace(/\\/g,"/")} | ${o}`,values:i,formattedDefault:bv(a,i,Ns)}},"getIcuMessageFn")}function zr(e){return typeof e=="string"||Ms(e)}var xL,C,R=v(()=>{"use strict";d();ri();cl();xL=Ht(TL(),1);Pe();Ta();Ls();Ta();go();C={ms:"{timeInMs, number, milliseconds} ms",seconds:"{timeInMs, number, seconds} s",displayValueByteSavings:"Potential savings of {wastedBytes, number, bytes} KiB",displayValueMsSavings:"Potential savings of {wastedMs, number, milliseconds} ms",displayValueElementsFound:"{nodeCount, plural, =1 {1 element found} other {# elements found}}",columnURL:"URL",columnSize:"Size",columnResourceSize:"Resource Size",columnTransferSize:"Transfer Size",columnCacheTTL:"Cache TTL",columnWastedBytes:"Potential Savings",columnWastedMs:"Potential Savings",columnBlockingTime:"Main-Thread Blocking Time",columnTimeSpent:"Time Spent",columnLocation:"Location",columnResourceType:"Resource Type",columnRequests:"Requests",columnName:"Name",columnSource:"Source",columnOverBudget:"\
Over Budget",columnElement:"Element",columnStartTime:"Start Time",columnDuration:"Duration",columnFailingElem:"Failing Elements",columnDescription:"Description",totalResourceType:"Total",documentResourceType:"Document",scriptResourceType:"Script",stylesheetResourceType:"Stylesheet",imageResourceType:"Image",mediaResourceType:"Media",fontResourceType:"Font",otherResourceType:"Other",thirdPartyResourceType:"Third-party",otherResourcesLabel:"Other resources",firstContentfulPaintMetric:"First Contentful Paint",interactiveMetric:"Time to Interactive",firstMeaningfulPaintMetric:"First Meaningful Paint",totalBlockingTimeMetric:"Total Blocking Time",maxPotentialFIDMetric:"Max Potential First Input Delay",speedIndexMetric:"Speed Index",largestContentfulPaintMetric:"Largest Contentful Paint",cumulativeLayoutShiftMetric:"Cumulative Layout Shift",interactionToNextPaint:"Interaction to Next Paint",itemSeverityLow:"Low",itemSeverityMedium:"Medium",itemSeverityHigh:"High"};s(Af,"lookupLocale");s(D,"c\
reateIcuMessageFn");s(zr,"isStringOrIcuMessage")});function CL(e){if(!e)return[];let t=[];for(let n of e){let r=Ev.find(u=>u.requiredStacks.includes(`${n.detector}:${n.id}`));if(!r)continue;let a=SL.default.find(u=>u.id===r.packId);if(!a){F.warn("StackPacks",`'${r.packId}' stack pack was matched but is not found in stack-packs lib`);continue}let i=D(`node_modules/lighthouse-stack-packs/packs/${a.id}.js`,a.UIStrings),o={},c=a.UIStrings;for(let u in c)c[u]&&(o[u]=i(c[u]));t.push({id:a.id,title:a.title,iconDataURL:a.icon,descriptions:o})}return t.sort((n,r)=>{let a=Ev.findIndex(o=>o.packId===n.id),i=Ev.findIndex(o=>o.packId===r.id);return a-i})}var SL,Ev,kL=v(()=>{"use strict";d();Pe();SL=Ht(DL(),1);R();Ev=[{packId:"gatsby",requiredStacks:["js:gatsby"]},{packId:"wordpress",requiredStacks:["js:wordpress"]},{packId:"wix",requiredStacks:["js:wix"]},{packId:"wp-rocket",requiredStacks:["js:wp-rocket"]},{packId:"ezoic",requiredStacks:["js:ezoic"]},{packId:"drupal",requiredStacks:["js:drupal"]},{packId:"nitropack",requiredStacks:["js:nitropack"]},
{packId:"amp",requiredStacks:["js:amp"]},{packId:"magento",requiredStacks:["js:magento"]},{packId:"octobercms",requiredStacks:["js:octobercms"]},{packId:"joomla",requiredStacks:["js:joomla"]},{packId:"next.js",requiredStacks:["js:next"]},{packId:"nuxt",requiredStacks:["js:nuxt"]},{packId:"angular",requiredStacks:["js:@angular/core"]},{packId:"react",requiredStacks:["js:react"]}];s(CL,"getStackPacks")});var Tv,jt,AL=v(()=>{d();typeof Object.create=="function"?Tv=s(function(t,n){t.super_=n,t.prototype=Object.create(n.prototype,{constructor:{value:t,enumerable:!1,writable:!0,configurable:!0}})},"inherits"):Tv=s(function(t,n){t.super_=n;var r=s(function(){},"TempCtor");r.prototype=n.prototype,t.prototype=new r,t.prototype.constructor=t},"inherits");jt=Tv});function Ete(e){if(!Fv(e)){for(var t=[],n=0;n<arguments.length;n++)t.push(ii(arguments[n]));return t.join(" ")}for(var n=1,r=arguments,a=r.length,i=String(e).replace(Dte,function(c){if(c==="%%")return"%";if(n>=a)return c;switch(c){case"%s":return String(r[n++]);case"%d":return Number(r[n++]);case"%j":try{return JSON.stringify(r[n++])}catch{return"[Circular]"}default:return c}}),o=r[n];n<a;o=r[++n])Iv(o)||!ul(o)?i+=" "+o:i+=" "+ii(o);return i}function _v(e,t){if(ai(globalThis.process))return function(){return _v(e,t).apply(this,arguments)};if(hn.noDeprecation===!0)return e;var n=!1;function r(){if(!n){if(hn.throwDeprecation)throw new Error(t);hn.traceDeprecation?console.trace(t):console.error(t),n=!0}return e.apply(this,arguments)}return s(r,"deprecated"),r}function _L(e){if(ai(xv)&&(xv=hn.env.NODE_DEBUG||""),e=e.toUpperCase(),!Rf[e])if(new RegExp("\\b"+e+"\\b","i").test(xv)){var t=0;Rf[e]=function(){var n=Ete.apply(null,arguments);console.error("%s %d: %s",e,t,n)}}else Rf[e]=function(){};
return Rf[e]}function ii(e,t){var n={seen:[],stylize:xte};return arguments.length>=3&&(n.depth=arguments[2]),arguments.length>=4&&(n.colors=arguments[3]),IL(t)?n.showHidden=t:t&&Ite(n,t),ai(n.showHidden)&&(n.showHidden=!1),ai(n.depth)&&(n.depth=2),ai(n.colors)&&(n.colors=!1),ai(n.customInspect)&&(n.customInspect=!0),n.colors&&(n.stylize=Tte),_f(n,e,n.depth)}function Tte(e,t){var n=ii.styles[t];return n?"\x1B["+ii.colors[n][0]+"m"+e+"\x1B["+ii.colors[n][1]+"m":e}function xte(e,t){return e}function Ste(e){var t={};return e.forEach(function(n,r){t[n]=!0}),t}function _f(e,t,n){if(e.customInspect&&t&&Av(t.inspect)&&t.inspect!==ii&&!(t.constructor&&t.constructor.prototype===t)){var r=t.inspect(n,e);return Fv(r)||(r=_f(e,r,n)),r}var a=Cte(e,t);if(a)return a;var i=Object.keys(t),o=Ste(i);if(e.showHidden&&(i=Object.getOwnPropertyNames(t)),kv(t)&&(i.indexOf("message")>=0||i.indexOf("description")>=0))return Sv(t);if(i.length===0){if(Av(t)){var c=t.name?": "+t.name:"";return e.stylize("[Function"+
c+"]","special")}if(Cv(t))return e.stylize(RegExp.prototype.toString.call(t),"regexp");if(RL(t))return e.stylize(Date.prototype.toString.call(t),"date");if(kv(t))return Sv(t)}var u="",l=!1,m=["{","}"];if(Rte(t)&&(l=!0,m=["[","]"]),Av(t)){var p=t.name?": "+t.name:"";u=" [Function"+p+"]"}if(Cv(t)&&(u=" "+RegExp.prototype.toString.call(t)),RL(t)&&(u=" "+Date.prototype.toUTCString.call(t)),kv(t)&&(u=" "+Sv(t)),i.length===0&&(!l||t.length==0))return m[0]+u+m[1];if(n<0)return Cv(t)?e.stylize(RegExp.prototype.toString.call(t),"regexp"):e.stylize("[Object]","special");e.seen.push(t);var h;return l?h=kte(e,t,n,o,i):h=i.map(function(f){return Rv(e,t,n,o,f,l)}),e.seen.pop(),Ate(h,u,m)}function Cte(e,t){if(ai(t))return e.stylize("undefined","undefined");if(Fv(t)){var n="'"+JSON.stringify(t).replace(/^"|"$/g,"").replace(/'/g,"\\'").replace(/\\"/g,'"')+"'";return e.stylize(n,"string")}if(_te(t))return e.stylize(""+t,"number");if(IL(t))return e.stylize(""+t,"boolean");if(Iv(t))return e.stylize("null",
"null")}function Sv(e){return"["+Error.prototype.toString.call(e)+"]"}function kte(e,t,n,r,a){for(var i=[],o=0,c=t.length;o<c;++o)FL(t,String(o))?i.push(Rv(e,t,n,r,String(o),!0)):i.push("");return a.forEach(function(u){u.match(/^\d+$/)||i.push(Rv(e,t,n,r,u,!0))}),i}function Rv(e,t,n,r,a,i){var o,c,u;if(u=Object.getOwnPropertyDescriptor(t,a)||{value:t[a]},u.get?u.set?c=e.stylize("[Getter/Setter]","special"):c=e.stylize("[Getter]","special"):u.set&&(c=e.stylize("[Setter]","special")),FL(r,a)||(o="["+a+"]"),c||(e.seen.indexOf(u.value)<0?(Iv(n)?c=_f(e,u.value,null):c=_f(e,u.value,n-1),c.indexOf(`
`)>-1&&(i?c=c.split(`
`).map(function(l){return"  "+l}).join(`
`).substr(2):c=`
`+c.split(`
`).map(function(l){return"   "+l}).join(`
`))):c=e.stylize("[Circular]","special")),ai(o)){if(i&&a.match(/^\d+$/))return c;o=JSON.stringify(""+a),o.match(/^"([a-zA-Z_][a-zA-Z_0-9]*)"$/)?(o=o.substr(1,o.length-2),o=e.stylize(o,"name")):(o=o.replace(/'/g,"\\'").replace(/\\"/g,'"').replace(/(^"|"$)/g,"'"),o=e.stylize(o,"string"))}return o+": "+c}function Ate(e,t,n){var r=0,a=e.reduce(function(i,o){return r++,o.indexOf(`
`)>=0&&r++,i+o.replace(/\u001b\[\d\d?m/g,"").length+1},0);return a>60?n[0]+(t===""?"":t+`
 `)+" "+e.join(`,
  `)+" "+n[1]:n[0]+t+" "+e.join(", ")+" "+n[1]}function Rte(e){return Array.isArray(e)}function IL(e){return typeof e=="boolean"}function Iv(e){return e===null}function _te(e){return typeof e=="number"}function Fv(e){return typeof e=="string"}function ai(e){return e===void 0}function Cv(e){return ul(e)&&Nv(e)==="[object RegExp]"}function ul(e){return typeof e=="object"&&e!==null}function RL(e){return ul(e)&&Nv(e)==="[object Date]"}function kv(e){return ul(e)&&(Nv(e)==="[object Error]"||e instanceof Error)}function Av(e){return typeof e=="function"}function Nv(e){return Object.prototype.toString.call(e)}function Ite(e,t){if(!t||!ul(t))return e;for(var n=Object.keys(t),r=n.length;r--;)e[n[r]]=t[n[r]];return e}function FL(e,t){return Object.prototype.hasOwnProperty.call(e,t)}function Fte(e){if(typeof e!="function")throw new TypeError('The "original" argument must be of type Function');if(vo&&e[vo]){var t=e[vo];if(typeof t!="function")throw new TypeError('The "util.promisify.custom" argume\
nt must be of type Function');return Object.defineProperty(t,vo,{value:t,enumerable:!1,writable:!1,configurable:!0}),t}function t(){for(var n,r,a=new Promise(function(c,u){n=c,r=u}),i=[],o=0;o<arguments.length;o++)i.push(arguments[o]);i.push(function(c,u){c?r(c):n(u)});try{e.apply(this,i)}catch(c){r(c)}return a}return s(t,"fn"),Object.setPrototypeOf(t,Object.getPrototypeOf(e)),vo&&Object.defineProperty(t,vo,{value:t,enumerable:!1,writable:!1,configurable:!0}),Object.defineProperties(t,wte(e))}var wte,Dte,Rf,xv,vo,oi=v(()=>{d();Qa();AL();wte=Object.getOwnPropertyDescriptors||s(function(t){for(var n=Object.keys(t),r={},a=0;a<n.length;a++)r[n[a]]=Object.getOwnPropertyDescriptor(t,n[a]);return r},"getOwnPropertyDescriptors"),Dte=/%[sdj%]/g;s(Ete,"format");s(_v,"deprecate");Rf={};s(_L,"debuglog");s(ii,"inspect");ii.colors={bold:[1,22],italic:[3,23],underline:[4,24],inverse:[7,27],white:[37,39],grey:[90,39],black:[30,39],blue:[34,39],cyan:[36,39],green:[32,39],magenta:[35,39],red:[31,39],yellow:[
33,39]};ii.styles={special:"cyan",number:"yellow",boolean:"yellow",undefined:"grey",null:"bold",string:"green",date:"magenta",regexp:"red"};s(Tte,"stylizeWithColor");s(xte,"stylizeNoColor");s(Ste,"arrayToHash");s(_f,"formatValue");s(Cte,"formatPrimitive");s(Sv,"formatError");s(kte,"formatArray");s(Rv,"formatProperty");s(Ate,"reduceToSingleString");s(Rte,"isArray");s(IL,"isBoolean");s(Iv,"isNull");s(_te,"isNumber");s(Fv,"isString");s(ai,"isUndefined");s(Cv,"isRegExp");s(ul,"isObject");s(RL,"isDate");s(kv,"isError");s(Av,"isFunction");s(Nv,"objectToString");s(Ite,"_extend");s(FL,"hasOwnProperty");vo=typeof Symbol<"u"?Symbol("util.promisify.custom"):void 0;s(Fte,"promisify");Fte.custom=vo});function bo(){this.head=null,this.tail=null,this.length=0}var NL,ML=v(()=>{d();ys();NL=bo;s(bo,"BufferList");bo.prototype.push=function(e){var t={data:e,next:null};this.length>0?this.tail.next=t:this.head=t,this.tail=t,++this.length};bo.prototype.unshift=function(e){var t={data:e,next:this.head};this.length===0&&(this.tail=t),this.head=t,++this.length};bo.prototype.shift=function(){if(this.length!==0){var e=this.head.data;return this.length===1?this.head=this.tail=null:this.head=this.head.next,--this.length,e}};bo.prototype.clear=function(){this.head=this.tail=null,this.length=0};bo.prototype.join=function(e){if(this.length===0)return"";for(var t=this.head,n=""+t.data;t=t.next;)n+=e+t.data;return n};bo.prototype.concat=function(e){if(this.length===0)return z.alloc(0);if(this.length===1)return this.head.data;for(var t=z.allocUnsafe(e>>>0),n=this.head,r=0;n;)n.data.copy(t,r),r+=n.data.length,n=n.next;return t}});function Mte(e){if(e&&!Nte(e))throw new Error("Unknown encoding: "+e)}function Ps(e){switch(this.encoding=(e||"utf8").toLowerCase().replace(/[-_]/,""),Mte(e),this.encoding){case"utf8":this.surrogateSize=3;break;case"ucs2":case"utf16le":this.surrogateSize=2,this.detectIncompleteChar=Pte;break;case"base64":this.surrogateSize=3,this.detectIncompleteChar=Ote;break;default:this.write=Lte;return}this.charBuffer=new z(6),this.charReceived=0,this.charLength=0}function Lte(e){return e.toString(this.encoding)}function Pte(e){this.charReceived=e.length%2,this.charLength=this.charReceived?2:0}function Ote(e){this.charReceived=e.length%3,this.charLength=this.charReceived?3:0}var Nte,LL=v(()=>{d();ys();Nte=z.isEncoding||function(e){switch(e&&e.toLowerCase()){case"hex":case"utf8":case"utf-8":case"ascii":case"binary":case"base64":case"ucs2":case"ucs-2":case"utf16le":case"utf-16le":case"raw":return!0;default:return!1}};s(Mte,"assertEncoding");s(Ps,"StringDecoder");Ps.prototype.write=function(e){for(var t="";this.
charLength;){var n=e.length>=this.charLength-this.charReceived?this.charLength-this.charReceived:e.length;if(e.copy(this.charBuffer,this.charReceived,0,n),this.charReceived+=n,this.charReceived<this.charLength)return"";e=e.slice(n,e.length),t=this.charBuffer.slice(0,this.charLength).toString(this.encoding);var a=t.charCodeAt(t.length-1);if(a>=55296&&a<=56319){this.charLength+=this.surrogateSize,t="";continue}if(this.charReceived=this.charLength=0,e.length===0)return t;break}this.detectIncompleteChar(e);var r=e.length;this.charLength&&(e.copy(this.charBuffer,0,e.length-this.charReceived,r),r-=this.charReceived),t+=e.toString(this.encoding,0,r);var r=t.length-1,a=t.charCodeAt(r);if(a>=55296&&a<=56319){var i=this.surrogateSize;return this.charLength+=i,this.charReceived+=i,this.charBuffer.copy(this.charBuffer,i,0,i),e.copy(this.charBuffer,0,0,i),t.substring(0,r)}return t};Ps.prototype.detectIncompleteChar=function(e){for(var t=e.length>=3?3:e.length;t>0;t--){var n=e[e.length-t];if(t==1&&n>>
5==6){this.charLength=2;break}if(t<=2&&n>>4==14){this.charLength=3;break}if(t<=3&&n>>3==30){this.charLength=4;break}}this.charReceived=t};Ps.prototype.end=function(e){var t="";if(e&&e.length&&(t=this.write(e)),this.charReceived){var n=this.charReceived,r=this.charBuffer,a=this.encoding;t+=r.slice(0,n).toString(a)}return t};s(Lte,"passThroughWrite");s(Pte,"utf16DetectIncompleteChar");s(Ote,"base64DetectIncompleteChar")});function Bte(e,t,n){if(typeof e.prependListener=="function")return e.prependListener(t,n);!e._events||!e._events[t]?e.on(t,n):Array.isArray(e._events[t])?e._events[t].unshift(n):e._events[t]=[n,e._events[t]]}function Ute(e,t){return e.listeners(t).length}function UL(e,t){e=e||{},this.objectMode=!!e.objectMode,t instanceof yn&&(this.objectMode=this.objectMode||!!e.readableObjectMode);var n=e.highWaterMark,r=this.objectMode?16:16*1024;this.highWaterMark=n||n===0?n:r,this.highWaterMark=~~this.highWaterMark,this.buffer=new NL,this.length=0,this.pipes=null,this.pipesCount=0,this.flowing=null,this.ended=!1,this.endEmitted=!1,this.reading=!1,this.sync=!0,this.needReadable=!1,this.emittedReadable=!1,this.readableListening=!1,this.resumeScheduled=!1,this.defaultEncoding=e.defaultEncoding||"utf8",this.ranOut=!1,this.awaitDrain=0,this.readingMore=!1,this.decoder=null,this.encoding=null,e.encoding&&(this.decoder=new Ps(e.encoding),this.encoding=e.encoding)}function _t(e){if(!(this instanceof _t))return new _t(
e);this._readableState=new UL(e,this),this.readable=!0,e&&typeof e.read=="function"&&(this._read=e.read),nr.call(this)}function jL(e,t,n,r,a){var i=zte(t,n);if(i)e.emit("error",i);else if(n===null)t.reading=!1,Hte(e,t);else if(t.objectMode||n&&n.length>0)if(t.ended&&!a){var o=new Error("stream.push() after EOF");e.emit("error",o)}else if(t.endEmitted&&a){var c=new Error("stream.unshift() after end event");e.emit("error",c)}else{var u;t.decoder&&!a&&!r&&(n=t.decoder.write(n),u=!t.objectMode&&n.length===0),a||(t.reading=!1),u||(t.flowing&&t.length===0&&!t.sync?(e.emit("data",n),e.read(0)):(t.length+=t.objectMode?1:n.length,a?t.buffer.unshift(n):t.buffer.push(n),t.needReadable&&If(e))),Gte(e,t)}else a||(t.reading=!1);return jte(t)}function jte(e){return!e.ended&&(e.needReadable||e.length<e.highWaterMark||e.length===0)}function qte(e){return e>=PL?e=PL:(e--,e|=e>>>1,e|=e>>>2,e|=e>>>4,e|=e>>>8,e|=e>>>16,e++),e}function OL(e,t){return e<=0||t.length===0&&t.ended?0:t.objectMode?1:e!==e?t.flowing&&
t.length?t.buffer.head.data.length:t.length:(e>t.highWaterMark&&(t.highWaterMark=qte(e)),e<=t.length?e:t.ended?t.length:(t.needReadable=!0,0))}function zte(e,t){var n=null;return!Buffer.isBuffer(t)&&typeof t!="string"&&t!==null&&t!==void 0&&!e.objectMode&&(n=new TypeError("Invalid non-string/buffer chunk")),n}function Hte(e,t){if(!t.ended){if(t.decoder){var n=t.decoder.end();n&&n.length&&(t.buffer.push(n),t.length+=t.objectMode?1:n.length)}t.ended=!0,If(e)}}function If(e){var t=e._readableState;t.needReadable=!1,t.emittedReadable||(dt("emitReadable",t.flowing),t.emittedReadable=!0,t.sync?fn(BL,e):BL(e))}function BL(e){dt("emit readable"),e.emit("readable"),Lv(e)}function Gte(e,t){t.readingMore||(t.readingMore=!0,fn(Wte,e,t))}function Wte(e,t){for(var n=t.length;!t.reading&&!t.flowing&&!t.ended&&t.length<t.highWaterMark&&(dt("maybeReadMore read 0"),e.read(0),n!==t.length);)n=t.length;t.readingMore=!1}function Vte(e){return function(){var t=e._readableState;dt("pipeOnDrain",t.awaitDrain),
t.awaitDrain&&t.awaitDrain--,t.awaitDrain===0&&e.listeners("data").length&&(t.flowing=!0,Lv(e))}}function $te(e){dt("readable nexttick read 0"),e.read(0)}function Yte(e,t){t.resumeScheduled||(t.resumeScheduled=!0,fn(Kte,e,t))}function Kte(e,t){t.reading||(dt("resume read 0"),e.read(0)),t.resumeScheduled=!1,t.awaitDrain=0,e.emit("resume"),Lv(e),t.flowing&&!t.reading&&e.read(0)}function Lv(e){var t=e._readableState;for(dt("flow",t.flowing);t.flowing&&e.read()!==null;);}function qL(e,t){if(t.length===0)return null;var n;return t.objectMode?n=t.buffer.shift():!e||e>=t.length?(t.decoder?n=t.buffer.join(""):t.buffer.length===1?n=t.buffer.head.data:n=t.buffer.concat(t.length),t.buffer.clear()):n=Xte(e,t.buffer,t.decoder),n}function Xte(e,t,n){var r;return e<t.head.data.length?(r=t.head.data.slice(0,e),t.head.data=t.head.data.slice(e)):e===t.head.data.length?r=t.shift():r=n?Jte(e,t):Zte(e,t),r}function Jte(e,t){var n=t.head,r=1,a=n.data;for(e-=a.length;n=n.next;){var i=n.data,o=e>i.length?i.length:
e;if(o===i.length?a+=i:a+=i.slice(0,e),e-=o,e===0){o===i.length?(++r,n.next?t.head=n.next:t.head=t.tail=null):(t.head=n,n.data=i.slice(o));break}++r}return t.length-=r,a}function Zte(e,t){var n=Buffer.allocUnsafe(e),r=t.head,a=1;for(r.data.copy(n),e-=r.data.length;r=r.next;){var i=r.data,o=e>i.length?i.length:e;if(i.copy(n,n.length-e,0,o),e-=o,e===0){o===i.length?(++a,r.next?t.head=r.next:t.head=t.tail=null):(t.head=r,r.data=i.slice(o));break}++a}return t.length-=a,n}function Mv(e){var t=e._readableState;if(t.length>0)throw new Error('"endReadable()" called on non-empty stream');t.endEmitted||(t.ended=!0,fn(Qte,t,e))}function Qte(e,t){!e.endEmitted&&e.length===0&&(e.endEmitted=!0,t.readable=!1,t.emit("end"))}function ene(e,t){for(var n=0,r=e.length;n<r;n++)t(e[n],n)}function zL(e,t){for(var n=0,r=e.length;n<r;n++)if(e[n]===t)return n;return-1}var dt,PL,Pv=v(()=>{"use strict";d();wa();oi();ML();LL();ll();Qa();_t.ReadableState=UL;dt=_L("stream");jt(_t,nr);s(Bte,"prependListener");s(Ute,"\
listenerCount");s(UL,"ReadableState");s(_t,"Readable");_t.prototype.push=function(e,t){var n=this._readableState;return!n.objectMode&&typeof e=="string"&&(t=t||n.defaultEncoding,t!==n.encoding&&(e=Buffer.from(e,t),t="")),jL(this,n,e,t,!1)};_t.prototype.unshift=function(e){var t=this._readableState;return jL(this,t,e,"",!0)};_t.prototype.isPaused=function(){return this._readableState.flowing===!1};s(jL,"readableAddChunk");s(jte,"needMoreData");_t.prototype.setEncoding=function(e){return this._readableState.decoder=new Ps(e),this._readableState.encoding=e,this};PL=8388608;s(qte,"computeNewHighWaterMark");s(OL,"howMuchToRead");_t.prototype.read=function(e){dt("read",e),e=parseInt(e,10);var t=this._readableState,n=e;if(e!==0&&(t.emittedReadable=!1),e===0&&t.needReadable&&(t.length>=t.highWaterMark||t.ended))return dt("read: emitReadable",t.length,t.ended),t.length===0&&t.ended?Mv(this):If(this),null;if(e=OL(e,t),e===0&&t.ended)return t.length===0&&Mv(this),null;var r=t.needReadable;dt("nee\
d readable",r),(t.length===0||t.length-e<t.highWaterMark)&&(r=!0,dt("length less than watermark",r)),t.ended||t.reading?(r=!1,dt("reading or ended",r)):r&&(dt("do read"),t.reading=!0,t.sync=!0,t.length===0&&(t.needReadable=!0),this._read(t.highWaterMark),t.sync=!1,t.reading||(e=OL(n,t)));var a;return e>0?a=qL(e,t):a=null,a===null?(t.needReadable=!0,e=0):t.length-=e,t.length===0&&(t.ended||(t.needReadable=!0),n!==e&&t.ended&&Mv(this)),a!==null&&this.emit("data",a),a};s(zte,"chunkInvalid");s(Hte,"onEofChunk");s(If,"emitReadable");s(BL,"emitReadable_");s(Gte,"maybeReadMore");s(Wte,"maybeReadMore_");_t.prototype._read=function(e){this.emit("error",new Error("not implemented"))};_t.prototype.pipe=function(e,t){var n=this,r=this._readableState;switch(r.pipesCount){case 0:r.pipes=e;break;case 1:r.pipes=[r.pipes,e];break;default:r.pipes.push(e);break}r.pipesCount+=1,dt("pipe count=%d opts=%j",r.pipesCount,t);var a=!t||t.end!==!1,i=a?c:m;r.endEmitted?fn(i):n.once("end",i),e.on("unpipe",o);function o(E){
dt("onunpipe"),E===n&&m()}s(o,"onunpipe");function c(){dt("onend"),e.end()}s(c,"onend");var u=Vte(n);e.on("drain",u);var l=!1;function m(){dt("cleanup"),e.removeListener("close",g),e.removeListener("finish",b),e.removeListener("drain",u),e.removeListener("error",f),e.removeListener("unpipe",o),n.removeListener("end",c),n.removeListener("end",m),n.removeListener("data",h),l=!0,r.awaitDrain&&(!e._writableState||e._writableState.needDrain)&&u()}s(m,"cleanup");var p=!1;n.on("data",h);function h(E){dt("ondata"),p=!1;var x=e.write(E);x===!1&&!p&&((r.pipesCount===1&&r.pipes===e||r.pipesCount>1&&zL(r.pipes,e)!==-1)&&!l&&(dt("false write response, pause",n._readableState.awaitDrain),n._readableState.awaitDrain++,p=!0),n.pause())}s(h,"ondata");function f(E){dt("onerror",E),w(),e.removeListener("error",f),Ute(e,"error")===0&&e.emit("error",E)}s(f,"onerror"),Bte(e,"error",f);function g(){e.removeListener("finish",b),w()}s(g,"onclose"),e.once("close",g);function b(){dt("onfinish"),e.removeListener(
"close",g),w()}s(b,"onfinish"),e.once("finish",b);function w(){dt("unpipe"),n.unpipe(e)}return s(w,"unpipe"),e.emit("pipe",n),r.flowing||(dt("pipe resume"),n.resume()),e};s(Vte,"pipeOnDrain");_t.prototype.unpipe=function(e){var t=this._readableState;if(t.pipesCount===0)return this;if(t.pipesCount===1)return e&&e!==t.pipes?this:(e||(e=t.pipes),t.pipes=null,t.pipesCount=0,t.flowing=!1,e&&e.emit("unpipe",this),this);if(!e){var n=t.pipes,r=t.pipesCount;t.pipes=null,t.pipesCount=0,t.flowing=!1;for(var a=0;a<r;a++)n[a].emit("unpipe",this);return this}var i=zL(t.pipes,e);return i===-1?this:(t.pipes.splice(i,1),t.pipesCount-=1,t.pipesCount===1&&(t.pipes=t.pipes[0]),e.emit("unpipe",this),this)};_t.prototype.on=function(e,t){var n=nr.prototype.on.call(this,e,t);if(e==="data")this._readableState.flowing!==!1&&this.resume();else if(e==="readable"){var r=this._readableState;!r.endEmitted&&!r.readableListening&&(r.readableListening=r.needReadable=!0,r.emittedReadable=!1,r.reading?r.length&&If(this,r):
fn($te,this))}return n};_t.prototype.addListener=_t.prototype.on;s($te,"nReadingNextTick");_t.prototype.resume=function(){var e=this._readableState;return e.flowing||(dt("resume"),e.flowing=!0,Yte(this,e)),this};s(Yte,"resume");s(Kte,"resume_");_t.prototype.pause=function(){return dt("call pause flowing=%j",this._readableState.flowing),this._readableState.flowing!==!1&&(dt("pause"),this._readableState.flowing=!1,this.emit("pause")),this};s(Lv,"flow");_t.prototype.wrap=function(e){var t=this._readableState,n=!1,r=this;e.on("end",function(){if(dt("wrapped end"),t.decoder&&!t.ended){var o=t.decoder.end();o&&o.length&&r.push(o)}r.push(null)}),e.on("data",function(o){if(dt("wrapped data"),t.decoder&&(o=t.decoder.write(o)),!(t.objectMode&&o==null)&&!(!t.objectMode&&(!o||!o.length))){var c=r.push(o);c||(n=!0,e.pause())}});for(var a in e)this[a]===void 0&&typeof e[a]=="function"&&(this[a]=function(o){return function(){return e[o].apply(e,arguments)}}(a));var i=["error","close","destroy","pause",
"resume"];return ene(i,function(o){e.on(o,r.emit.bind(r,o))}),r._read=function(o){dt("wrapped _read",o),n&&(n=!1,e.resume())},r};_t._fromList=qL;s(qL,"fromList");s(Xte,"fromListPartial");s(Jte,"copyFromBufferString");s(Zte,"copyFromBuffer");s(Mv,"endReadable");s(Qte,"endReadableNT");s(ene,"forEach");s(zL,"indexOf")});function tne(){}function nne(e,t,n){this.chunk=e,this.encoding=t,this.callback=n,this.next=null}function Bv(e,t){Object.defineProperty(this,"buffer",{get:_v(function(){return this.getBuffer()},"_writableState.buffer is deprecated. Use _writableState.getBuffer instead.")}),e=e||{},this.objectMode=!!e.objectMode,t instanceof yn&&(this.objectMode=this.objectMode||!!e.writableObjectMode);var n=e.highWaterMark,r=this.objectMode?16:16*1024;this.highWaterMark=n||n===0?n:r,this.highWaterMark=~~this.highWaterMark,this.needDrain=!1,this.ending=!1,this.ended=!1,this.finished=!1;var a=e.decodeStrings===!1;this.decodeStrings=!a,this.defaultEncoding=e.defaultEncoding||"utf8",this.length=0,this.writing=!1,this.corked=0,this.sync=!0,this.bufferProcessing=!1,this.onwrite=function(i){une(t,i)},this.writecb=null,this.writelen=0,this.bufferedRequest=null,this.lastBufferedRequest=null,this.pendingcb=0,this.prefinished=!1,this.errorEmitted=!1,this.bufferedRequestCount=0,this.corkedRequestsFree=new YL(this)}
function an(e){if(!(this instanceof an)&&!(this instanceof yn))return new an(e);this._writableState=new Bv(e,this),this.writable=!0,e&&(typeof e.write=="function"&&(this._write=e.write),typeof e.writev=="function"&&(this._writev=e.writev)),Ve.call(this)}function rne(e,t){var n=new Error("write after end");e.emit("error",n),fn(t,n)}function ane(e,t,n,r){var a=!0,i=!1;return n===null?i=new TypeError("May not write null values to stream"):!z.isBuffer(n)&&typeof n!="string"&&n!==void 0&&!t.objectMode&&(i=new TypeError("Invalid non-string/buffer chunk")),i&&(e.emit("error",i),fn(r,i),a=!1),a}function ine(e,t,n){return!e.objectMode&&e.decodeStrings!==!1&&typeof t=="string"&&(t=z.from(t,n)),t}function one(e,t,n,r,a){n=ine(t,n,r),z.isBuffer(n)&&(r="buffer");var i=t.objectMode?1:n.length;t.length+=i;var o=t.length<t.highWaterMark;if(o||(t.needDrain=!0),t.writing||t.corked){var c=t.lastBufferedRequest;t.lastBufferedRequest=new nne(n,r,a),c?c.next=t.lastBufferedRequest:t.bufferedRequest=t.lastBufferedRequest,
t.bufferedRequestCount+=1}else Ov(e,t,!1,i,n,r,a);return o}function Ov(e,t,n,r,a,i,o){t.writelen=r,t.writecb=o,t.writing=!0,t.sync=!0,n?e._writev(a,t.onwrite):e._write(a,i,t.onwrite),t.sync=!1}function sne(e,t,n,r,a){--t.pendingcb,n?fn(a,r):a(r),e._writableState.errorEmitted=!0,e.emit("error",r)}function cne(e){e.writing=!1,e.writecb=null,e.length-=e.writelen,e.writelen=0}function une(e,t){var n=e._writableState,r=n.sync,a=n.writecb;if(cne(n),t)sne(e,n,r,t,a);else{var i=VL(n);!i&&!n.corked&&!n.bufferProcessing&&n.bufferedRequest&&WL(e,n),r?fn(HL,e,n,i,a):HL(e,n,i,a)}}function HL(e,t,n,r){n||lne(e,t),t.pendingcb--,r(),$L(e,t)}function lne(e,t){t.length===0&&t.needDrain&&(t.needDrain=!1,e.emit("drain"))}function WL(e,t){t.bufferProcessing=!0;var n=t.bufferedRequest;if(e._writev&&n&&n.next){var r=t.bufferedRequestCount,a=new Array(r),i=t.corkedRequestsFree;i.entry=n;for(var o=0;n;)a[o]=n,n=n.next,o+=1;Ov(e,t,!0,t.length,a,"",i.finish),t.pendingcb++,t.lastBufferedRequest=null,i.next?(t.corkedRequestsFree=
i.next,i.next=null):t.corkedRequestsFree=new YL(t)}else{for(;n;){var c=n.chunk,u=n.encoding,l=n.callback,m=t.objectMode?1:c.length;if(Ov(e,t,!1,m,c,u,l),n=n.next,t.writing)break}n===null&&(t.lastBufferedRequest=null)}t.bufferedRequestCount=0,t.bufferedRequest=n,t.bufferProcessing=!1}function VL(e){return e.ending&&e.length===0&&e.bufferedRequest===null&&!e.finished&&!e.writing}function GL(e,t){t.prefinished||(t.prefinished=!0,e.emit("prefinish"))}function $L(e,t){var n=VL(t);return n&&(t.pendingcb===0?(GL(e,t),t.finished=!0,e.emit("finish")):GL(e,t)),n}function dne(e,t,n){t.ending=!0,$L(e,t),n&&(t.finished?fn(n):e.once("finish",n)),t.ended=!0,e.writable=!1}function YL(e){var t=this;this.next=null,this.entry=null,this.finish=function(n){var r=t.entry;for(t.entry=null;r;){var a=r.callback;e.pendingcb--,a(n),r=r.next}e.corkedRequestsFree?e.corkedRequestsFree.next=t:e.corkedRequestsFree=t}}var Uv=v(()=>{d();oi();ys();wa();ll();Qa();an.WritableState=Bv;jt(an,Ve);s(tne,"nop");s(nne,"WriteReq");
s(Bv,"WritableState");Bv.prototype.getBuffer=s(function(){for(var t=this.bufferedRequest,n=[];t;)n.push(t),t=t.next;return n},"writableStateGetBuffer");s(an,"Writable");an.prototype.pipe=function(){this.emit("error",new Error("Cannot pipe, not readable"))};s(rne,"writeAfterEnd");s(ane,"validChunk");an.prototype.write=function(e,t,n){var r=this._writableState,a=!1;return typeof t=="function"&&(n=t,t=null),z.isBuffer(e)?t="buffer":t||(t=r.defaultEncoding),typeof n!="function"&&(n=tne),r.ended?rne(this,n):ane(this,r,e,n)&&(r.pendingcb++,a=one(this,r,e,t,n)),a};an.prototype.cork=function(){var e=this._writableState;e.corked++};an.prototype.uncork=function(){var e=this._writableState;e.corked&&(e.corked--,!e.writing&&!e.corked&&!e.finished&&!e.bufferProcessing&&e.bufferedRequest&&WL(this,e))};an.prototype.setDefaultEncoding=s(function(t){if(typeof t=="string"&&(t=t.toLowerCase()),!(["hex","utf8","utf-8","ascii","binary","base64","ucs2","ucs-2","utf16le","utf-16le","raw"].indexOf((t+"").toLowerCase())>
-1))throw new TypeError("Unknown encoding: "+t);return this._writableState.defaultEncoding=t,this},"setDefaultEncoding");s(ine,"decodeChunk");s(one,"writeOrBuffer");s(Ov,"doWrite");s(sne,"onwriteError");s(cne,"onwriteStateUpdate");s(une,"onwrite");s(HL,"afterWrite");s(lne,"onwriteDrain");s(WL,"clearBuffer");an.prototype._write=function(e,t,n){n(new Error("not implemented"))};an.prototype._writev=null;an.prototype.end=function(e,t,n){var r=this._writableState;typeof e=="function"?(n=e,e=null,t=null):typeof t=="function"&&(n=t,t=null),e!=null&&this.write(e,t),r.corked&&(r.corked=1,this.uncork()),!r.ending&&!r.finished&&dne(this,r,n)};s(VL,"needFinish");s(GL,"prefinish");s($L,"finishMaybe");s(dne,"endWritable");s(YL,"CorkedRequest")});function yn(e){if(!(this instanceof yn))return new yn(e);_t.call(this,e),an.call(this,e),e&&e.readable===!1&&(this.readable=!1),e&&e.writable===!1&&(this.writable=!1),this.allowHalfOpen=!0,e&&e.allowHalfOpen===!1&&(this.allowHalfOpen=!1),this.once("end",mne)}function mne(){this.allowHalfOpen||this._writableState.ended||fn(pne,this)}function pne(e){e.end()}var KL,Nf,Ff,ll=v(()=>{d();oi();Qa();Pv();Uv();jt(yn,_t);KL=Object.keys(an.prototype);for(Ff=0;Ff<KL.length;Ff++)Nf=KL[Ff],yn.prototype[Nf]||(yn.prototype[Nf]=an.prototype[Nf]);s(yn,"Duplex");s(mne,"onend");s(pne,"onEndNT")});function fne(e){this.afterTransform=function(t,n){return hne(e,t,n)},this.needTransform=!1,this.transforming=!1,this.writecb=null,this.writechunk=null,this.writeencoding=null}function hne(e,t,n){var r=e._transformState;r.transforming=!1;var a=r.writecb;if(!a)return e.emit("error",new Error("no writecb in Transform class"));r.writechunk=null,r.writecb=null,n!=null&&e.push(n),a(t);var i=e._readableState;i.reading=!1,(i.needReadable||i.length<i.highWaterMark)&&e._read(i.highWaterMark)}function kn(e){if(!(this instanceof kn))return new kn(e);yn.call(this,e),this._transformState=new fne(this);var t=this;this._readableState.needReadable=!0,this._readableState.sync=!1,e&&(typeof e.transform=="function"&&(this._transform=e.transform),typeof e.flush=="function"&&(this._flush=e.flush)),this.once("prefinish",function(){typeof this._flush=="function"?this._flush(function(n){XL(t,n)}):XL(t)})}function XL(e,t){if(t)return e.emit("error",t);var n=e._writableState,r=e._transformState;if(n.length)throw new Error(
"Calling transform done when ws.length != 0");if(r.transforming)throw new Error("Calling transform done when still transforming");return e.push(null)}var jv=v(()=>{d();ll();oi();jt(kn,yn);s(fne,"TransformState");s(hne,"afterTransform");s(kn,"Transform");kn.prototype.push=function(e,t){return this._transformState.needTransform=!1,yn.prototype.push.call(this,e,t)};kn.prototype._transform=function(e,t,n){throw new Error("Not implemented")};kn.prototype._write=function(e,t,n){var r=this._transformState;if(r.writecb=n,r.writechunk=e,r.writeencoding=t,!r.transforming){var a=this._readableState;(r.needTransform||a.needReadable||a.length<a.highWaterMark)&&this._read(a.highWaterMark)}};kn.prototype._read=function(e){var t=this._transformState;t.writechunk!==null&&t.writecb&&!t.transforming?(t.transforming=!0,this._transform(t.writechunk,t.writeencoding,t.afterTransform)):t.needTransform=!0};s(XL,"done")});function Os(e){if(!(this instanceof Os))return new Os(e);kn.call(this,e)}var JL=v(()=>{d();jv();oi();jt(Os,kn);s(Os,"PassThrough");Os.prototype._transform=function(e,t,n){n(null,e)}});function Hr(){nr.call(this)}var qv,zv=v(()=>{d();wa();oi();ll();Pv();Uv();jv();JL();jt(Hr,nr);Hr.Readable=_t;Hr.Writable=an;Hr.Duplex=yn;Hr.Transform=kn;Hr.PassThrough=Os;Hr.Stream=Hr;qv=Hr;s(Hr,"Stream");Hr.prototype.pipe=function(e,t){var n=this;function r(m){e.writable&&e.write(m)===!1&&n.pause&&n.pause()}s(r,"ondata"),n.on("data",r);function a(){n.readable&&n.resume&&n.resume()}s(a,"ondrain"),e.on("drain",a),!e._isStdio&&(!t||t.end!==!1)&&(n.on("end",o),n.on("close",c));var i=!1;function o(){i||(i=!0,e.end())}s(o,"onend");function c(){i||(i=!0,typeof e.destroy=="function"&&e.destroy())}s(c,"onclose");function u(m){if(l(),nr.listenerCount(this,"error")===0)throw m}s(u,"onerror"),n.on("error",u),e.on("error",u);function l(){n.removeListener("data",r),e.removeListener("drain",a),n.removeListener("end",o),n.removeListener("close",c),n.removeListener("error",u),e.removeListener("error",u),n.removeListener("end",l),n.removeListener("close",l),e.removeListener("close",l)}return s(l,"clean\
up"),n.on("end",l),n.on("close",l),e.on("close",l),e.emit("pipe",n),e}});var De,An=v(()=>{"use strict";d();De=class e{static{s(this,"BaseNode")}constructor(t){this._id=t,this._isMainDocument=!1,this._dependents=[],this._dependencies=[]}get id(){return this._id}get type(){throw new Error("Unimplemented")}get startTime(){throw new Error("Unimplemented")}get endTime(){throw new Error("Unimplemented")}setIsMainDocument(t){this._isMainDocument=t}isMainDocument(){return this._isMainDocument}getDependents(){return this._dependents.slice()}getNumberOfDependents(){return this._dependents.length}getDependencies(){return this._dependencies.slice()}getNumberOfDependencies(){return this._dependencies.length}getRootNode(){let t=this;for(;t._dependencies.length;)t=t._dependencies[0];return t}addDependent(t){t.addDependency(this)}addDependency(t){if(t===this)throw new Error("Cannot add dependency on itself");this._dependencies.includes(t)||(t._dependents.push(this),this._dependencies.push(t))}removeDependent(t){t.removeDependency(this)}removeDependency(t){if(!this._dependencies.
includes(t))return;let n=t._dependents.indexOf(this);t._dependents.splice(n,1),this._dependencies.splice(this._dependencies.indexOf(t),1)}removeAllDependencies(){for(let t of this._dependencies.slice())this.removeDependency(t)}isDependentOn(t){let n=!1;return this.traverse(r=>{n||(n=r===t)},r=>n?[]:r.getDependencies()),n}cloneWithoutRelationships(){let t=new e(this.id);return t.setIsMainDocument(this._isMainDocument),t}cloneWithRelationships(t){let n=this.getRootNode(),r=new Map;n.traverse(i=>{if(!r.has(i.id)){if(t===void 0){r.set(i.id,i.cloneWithoutRelationships());return}t(i)&&i.traverse(o=>r.set(o.id,o.cloneWithoutRelationships()),o=>o._dependencies.filter(c=>!r.has(c.id)))}}),n.traverse(i=>{let o=r.get(i.id);if(o)for(let c of i._dependencies){let u=r.get(c.id);if(!u)throw new Error("Dependency somehow not cloned");o.addDependency(u)}});let a=r.get(this.id);if(!a)throw new Error("Cloned graph missing node");return a}traverse(t,n){for(let{node:r,traversalPath:a}of this.traverseGenerator(
n))t(r,a)}*traverseGenerator(t){t||(t=s(a=>a.getDependents(),"getNextNodes"));let n=[[this]],r=new Set([this.id]);for(;n.length;){let a=n.shift(),i=a[0];yield{node:i,traversalPath:a};for(let o of t(i))r.has(o.id)||(r.add(o.id),n.push([o,...a]))}}static hasCycle(t,n="both"){if(n==="both")return e.hasCycle(t,"dependents")||e.hasCycle(t,"dependencies");let r=new Set,a=[],i=[t],o=new Map([[t,0]]);for(;i.length;){let c=i.pop();if(a.includes(c))return!0;if(r.has(c))continue;for(;a.length>o.get(c);)a.pop();r.add(c),a.push(c);let u=n==="dependents"?c._dependents:c._dependencies;for(let l of u)i.includes(l)||(i.push(l),o.set(l,a.length))}return!1}canDependOn(t){return t.startTime<=this.startTime}};De.TYPES={NETWORK:"network",CPU:"cpu"}});var Bs,Hv=v(()=>{"use strict";d();Bs=class e{static{s(this,"TcpConnection")}constructor(t,n,r=0,a=!0,i=!1){this._warmed=!1,this._ssl=a,this._h2=i,this._rtt=t,this._throughput=n,this._serverLatency=r,this._congestionWindow=10,this._h2OverflowBytesDownloaded=0}static maximumSaturatedConnections(t,n){let o=1e3/t*1460*8;return Math.floor(n/o)}_computeMaximumCongestionWindowInSegments(){let t=this._throughput/8,n=this._rtt/1e3,r=t*n;return Math.floor(r/1460)}setThroughput(t){this._throughput=t}setCongestionWindow(t){this._congestionWindow=t}setWarmed(t){this._warmed=t}isWarm(){return this._warmed}isH2(){return this._h2}get congestionWindow(){return this._congestionWindow}setH2OverflowBytesDownloaded(t){this._h2&&(this._h2OverflowBytesDownloaded=t)}clone(){return Object.assign(new e(this._rtt,this._throughput),this)}simulateDownloadUntil(t,n){let{timeAlreadyElapsed:r=0,maximumTimeToElapse:a=1/0,dnsResolutionTime:i=0}=n||{};this._warmed&&this._h2&&(t-=this._h2OverflowBytesDownloaded);let o=this.
_rtt,c=o/2,u=this._computeMaximumCongestionWindowInSegments(),l=c;this._warmed||(l=i+c+c+c+(this._ssl?o:0));let m=Math.ceil(l/o),p=l+this._serverLatency+c;this._warmed&&this._h2&&(p=0);let h=Math.max(p-r,0),f=a-h,g=Math.min(this._congestionWindow,u),b=0;h>0?b=g*1460:m=0;let w=0,E=t-b;for(;E>0&&w<=f;){m++,w+=o,g=Math.max(Math.min(u,g*2),1);let L=g*1460;b+=L,E-=L}let x=h+w,S=this._h2?Math.max(b-t,0):0,k=Math.max(Math.min(b,t),0),A;return this._warmed?this._h2?A={timeToFirstByte:p}:A={connectionTime:l,timeToFirstByte:p}:A={dnsResolutionTime:i,connectionTime:l-i,sslTime:this._ssl?o:void 0,timeToFirstByte:p},{roundTrips:m,timeElapsed:x,bytesDownloaded:k,extraBytesDownloaded:S,congestionWindow:g,connectionTiming:A}}}});function gne(e,t){return e.endsWith(t)?e.length===t.length||e[e.length-t.length-1]===".":!1}function yne(e,t){let n=e.length-t.length-2,r=e.lastIndexOf(".",n);return r===-1?e:e.slice(r+1)}function Gv(e,t,n){if(n.validHosts!==null){let a=n.validHosts;for(let i of a)if(gne(t,i))return i}let r=0;if(t.startsWith("."))for(;r<t.length&&t[r]===".";)r+=1;return e.length===t.length-r?null:yne(t,e)}var ZL=v(()=>{d();s(gne,"shareSameDomainSuffix");s(yne,"extractDomainWithSuffix");s(Gv,"getDomain")});function Wv(e,t){return e.slice(0,-t.length-1)}var QL=v(()=>{d();s(Wv,"getDomainWithoutSuffix")});function Mf(e,t){let n=0,r=e.length,a=!1;if(!t){if(e.startsWith("data:"))return null;for(;n<e.length&&e.charCodeAt(n)<=32;)n+=1;for(;r>n+1&&e.charCodeAt(r-1)<=32;)r-=1;if(e.charCodeAt(n)===47&&e.charCodeAt(n+1)===47)n+=2;else{let l=e.indexOf(":/",n);if(l!==-1){let m=l-n,p=e.charCodeAt(n),h=e.charCodeAt(n+1),f=e.charCodeAt(n+2),g=e.charCodeAt(n+3),b=e.charCodeAt(n+4);if(!(m===5&&p===104&&h===116&&f===116&&g===112&&b===115)){if(!(m===4&&p===104&&h===116&&f===116&&g===112)){if(!(m===3&&p===119&&h===115&&f===115)){if(!(m===2&&p===119&&h===115))for(let w=n;w<l;w+=1){let E=e.charCodeAt(w)|32;if(!(E>=97&&E<=122||E>=48&&E<=57||E===46||E===45||E===43))return null}}}}for(n=l+2;e.charCodeAt(n)===47;)n+=1}}let o=-1,c=-1,u=-1;for(let l=n;l<r;l+=1){let m=e.charCodeAt(l);if(m===35||m===47||m===63){r=l;break}else m===64?o=l:m===93?c=l:m===58?u=l:m>=65&&m<=90&&(a=!0)}if(o!==-1&&o>n&&o<r&&(n=o+1),e.charCodeAt(n)===91)return c!==-1?e.slice(n+1,c).toLowerCase():null;u!==-1&&u>n&&u<r&&(r=u)}for(;r>n+1&&e.charCodeAt(
r-1)===46;)r-=1;let i=n!==0||r!==e.length?e.slice(n,r):e;return a?i.toLowerCase():i}var e3=v(()=>{d();s(Mf,"extractHostname")});function vne(e){if(e.length<7||e.length>15)return!1;let t=0;for(let n=0;n<e.length;n+=1){let r=e.charCodeAt(n);if(r===46)t+=1;else if(r<48||r>57)return!1}return t===3&&e.charCodeAt(0)!==46&&e.charCodeAt(e.length-1)!==46}function bne(e){if(e.length<3)return!1;let t=e.startsWith("[")?1:0,n=e.length;if(e[n-1]==="]"&&(n-=1),n-t>39)return!1;let r=!1;for(;t<n;t+=1){let a=e.charCodeAt(t);if(a===58)r=!0;else if(!(a>=48&&a<=57||a>=97&&a<=102||a>=65&&a<=90))return!1}return r}function Vv(e){return bne(e)||vne(e)}var t3=v(()=>{d();s(vne,"isProbablyIpv4");s(bne,"isProbablyIpv6");s(Vv,"isIp")});function n3(e){return e>=97&&e<=122||e>=48&&e<=57||e>127}function Lf(e){if(e.length>255||e.length===0||!n3(e.charCodeAt(0))&&e.charCodeAt(0)!==46&&e.charCodeAt(0)!==95)return!1;let t=-1,n=-1,r=e.length;for(let a=0;a<r;a+=1){let i=e.charCodeAt(a);if(i===46){if(a-t>64||n===46||n===45||n===95)return!1;t=a}else if(!(n3(i)||i===45||i===95))return!1;n=i}return r-t-1<=63&&n!==45}var r3=v(()=>{d();s(n3,"isValidAscii");s(Lf,"default")});function a3({allowIcannDomains:e=!0,allowPrivateDomains:t=!1,detectIp:n=!0,extractHostname:r=!0,mixedInputs:a=!0,validHosts:i=null,validateHostname:o=!0}){return{allowIcannDomains:e,allowPrivateDomains:t,detectIp:n,extractHostname:r,mixedInputs:a,validHosts:i,validateHostname:o}}function $v(e){return e===void 0?wne:a3(e)}var wne,Yv=v(()=>{d();s(a3,"setDefaultsImpl");wne=a3({});s($v,"setDefaults")});function Kv(e,t){return t.length===e.length?"":e.slice(0,-t.length-1)}var i3=v(()=>{d();s(Kv,"getSubdomain")});function Xv(){return{domain:null,domainWithoutSuffix:null,hostname:null,isIcann:null,isIp:null,isPrivate:null,publicSuffix:null,subdomain:null}}function Jv(e){e.domain=null,e.domainWithoutSuffix=null,e.hostname=null,e.isIcann=null,e.isIp=null,e.isPrivate=null,e.publicSuffix=null,e.subdomain=null}function Zv(e,t,n,r,a){let i=$v(r);return typeof e!="string"||(i.extractHostname?i.mixedInputs?a.hostname=Mf(e,Lf(e)):a.hostname=Mf(e,!1):a.hostname=e,t===0||a.hostname===null)||i.detectIp&&(a.isIp=Vv(a.hostname),a.isIp)?a:i.validateHostname&&i.extractHostname&&!Lf(a.hostname)?(a.hostname=null,a):(n(a.hostname,i,a),t===2||a.publicSuffix===null||(a.domain=Gv(a.publicSuffix,a.hostname,i),t===3||a.domain===null)||(a.subdomain=Kv(a.hostname,a.domain),t===4)||(a.domainWithoutSuffix=Wv(a.domain,a.publicSuffix)),a)}var o3=v(()=>{d();ZL();QL();e3();t3();r3();Yv();i3();s(Xv,"getEmptyResult");s(Jv,"resetResult");s(Zv,"parseImpl")});function Pf(e,t,n){if(!t.allowPrivateDomains&&e.length>3){let r=e.length-1,a=e.charCodeAt(r),i=e.charCodeAt(r-1),o=e.charCodeAt(r-2),c=e.charCodeAt(r-3);if(a===109&&i===111&&o===99&&c===46)return n.isIcann=!0,n.isPrivate=!1,n.publicSuffix="com",!0;if(a===103&&i===114&&o===111&&c===46)return n.isIcann=!0,n.isPrivate=!1,n.publicSuffix="org",!0;if(a===117&&i===100&&o===101&&c===46)return n.isIcann=!0,n.isPrivate=!1,n.publicSuffix="edu",!0;if(a===118&&i===111&&o===103&&c===46)return n.isIcann=!0,n.isPrivate=!1,n.publicSuffix="gov",!0;if(a===116&&i===101&&o===110&&c===46)return n.isIcann=!0,n.isPrivate=!1,n.publicSuffix="net",!0;if(a===101&&i===100&&o===46)return n.isIcann=!0,n.isPrivate=!1,n.publicSuffix="de",!0}return!1}var s3=v(()=>{d();s(Pf,"default")});var Qv=v(()=>{d();o3();s3();Yv()});var c3,u3,l3=v(()=>{d();c3=function(){let e=[1,{}],t=[0,{city:e}];return[0,{ck:[0,{www:e}],jp:[0,{kawasaki:t,kitakyushu:t,kobe:t,nagoya:t,sapporo:t,sendai:t,yokohama:t}]}]}(),u3=function(){let e=[1,{}],t=[1,{com:e,edu:e,gov:e,net:e,mil:e,org:e}],n=[1,{gov:e,com:e,org:e,net:e,edu:e}],r=[1,{gov:e}],a=[1,{com:e}],i=[0,{"*":e}],o=[1,{com:e,edu:e,net:e,org:e}],c=[1,{co:e,net:e,org:e}],u=[1,{co:e,com:e,edu:e,gov:e,net:e,org:e}],l=[1,{com:e,org:e,net:e,edu:e,sch:e,gov:e,mil:e,name:e}],m=[1,{edu:e,biz:e,net:e,org:e,gov:e,info:e,com:e}],p=[1,{gs:e}],h=[0,{nes:e}],f=[1,{k12:e,cc:e,lib:e}],g=[1,{cc:e}],b=[1,{cc:e,lib:e}];return[0,{ac:t,ad:[1,{nom:e}],ae:[1,{co:e,net:e,org:e,sch:e,ac:e,gov:e,mil:e}],aero:[1,{"accident-investigation":e,"accident-prevention":e,aerobatic:e,aeroclub:e,aerodrome:e,agents:e,aircraft:e,airline:e,airport:e,"air-surveillance":e,airtraffic:e,"air-traffic-control":e,ambulance:e,amusement:e,association:e,author:e,ballooning:e,broker:e,caa:e,cargo:e,catering:e,certification:e,
championship:e,charter:e,civilaviation:e,club:e,conference:e,consultant:e,consulting:e,control:e,council:e,crew:e,design:e,dgca:e,educator:e,emergency:e,engine:e,engineer:e,entertainment:e,equipment:e,exchange:e,express:e,federation:e,flight:e,fuel:e,gliding:e,government:e,groundhandling:e,group:e,hanggliding:e,homebuilt:e,insurance:e,journal:e,journalist:e,leasing:e,logistics:e,magazine:e,maintenance:e,media:e,microlight:e,modelling:e,navigation:e,parachuting:e,paragliding:e,"passenger-association":e,pilot:e,press:e,production:e,recreation:e,repbody:e,res:e,research:e,rotorcraft:e,safety:e,scientist:e,services:e,show:e,skydiving:e,software:e,student:e,trader:e,trading:e,trainer:e,union:e,workinggroup:e,works:e}],af:n,ag:[1,{com:e,org:e,net:e,co:e,nom:e}],ai:[1,{off:e,com:e,net:e,org:e}],al:t,am:[1,{co:e,com:e,commune:e,net:e,org:e}],ao:[1,{ed:e,gv:e,og:e,co:e,pb:e,it:e}],aq:e,ar:[1,{bet:e,com:e,coop:e,edu:e,gob:e,gov:e,int:e,mil:e,musica:e,mutual:e,net:e,org:e,senasa:e,tur:e}],arpa:[1,
{e164:e,"in-addr":e,ip6:e,iris:e,uri:e,urn:e}],as:r,asia:e,at:[1,{ac:[1,{sth:e}],co:e,gv:e,or:e}],au:[1,{com:e,net:e,org:e,edu:[1,{act:e,catholic:e,nsw:[1,{schools:e}],nt:e,qld:e,sa:e,tas:e,vic:e,wa:e}],gov:[1,{qld:e,sa:e,tas:e,vic:e,wa:e}],asn:e,id:e,info:e,conf:e,oz:e,act:e,nsw:e,nt:e,qld:e,sa:e,tas:e,vic:e,wa:e}],aw:a,ax:e,az:[1,{com:e,net:e,int:e,gov:e,org:e,edu:e,info:e,pp:e,mil:e,name:e,pro:e,biz:e}],ba:t,bb:[1,{biz:e,co:e,com:e,edu:e,gov:e,info:e,net:e,org:e,store:e,tv:e}],bd:i,be:[1,{ac:e}],bf:r,bg:[1,{0:e,1:e,2:e,3:e,4:e,5:e,6:e,7:e,8:e,9:e,a:e,b:e,c:e,d:e,e,f:e,g:e,h:e,i:e,j:e,k:e,l:e,m:e,n:e,o:e,p:e,q:e,r:e,s:e,t:e,u:e,v:e,w:e,x:e,y:e,z:e}],bh:n,bi:[1,{co:e,com:e,edu:e,or:e,org:e}],biz:e,bj:[1,{africa:e,agro:e,architectes:e,assur:e,avocats:e,co:e,com:e,eco:e,econo:e,edu:e,info:e,loisirs:e,money:e,net:e,org:e,ote:e,resto:e,restaurant:e,tourism:e,univ:e}],bm:n,bn:n,bo:[1,{com:e,edu:e,gob:e,int:e,org:e,net:e,mil:e,tv:e,web:e,academia:e,agro:e,arte:e,blog:e,bolivia:e,ciencia:e,cooperativa:e,
democracia:e,deporte:e,ecologia:e,economia:e,empresa:e,indigena:e,industria:e,info:e,medicina:e,movimiento:e,musica:e,natural:e,nombre:e,noticias:e,patria:e,politica:e,profesional:e,plurinacional:e,pueblo:e,revista:e,salud:e,tecnologia:e,tksat:e,transporte:e,wiki:e}],br:[1,{"9guacu":e,abc:e,adm:e,adv:e,agr:e,aju:e,am:e,anani:e,aparecida:e,app:e,arq:e,art:e,ato:e,b:e,barueri:e,belem:e,bhz:e,bib:e,bio:e,blog:e,bmd:e,boavista:e,bsb:e,campinagrande:e,campinas:e,caxias:e,cim:e,cng:e,cnt:e,com:e,contagem:e,coop:e,coz:e,cri:e,cuiaba:e,curitiba:e,def:e,des:e,det:e,dev:e,ecn:e,eco:e,edu:e,emp:e,enf:e,eng:e,esp:e,etc:e,eti:e,far:e,feira:e,flog:e,floripa:e,fm:e,fnd:e,fortal:e,fot:e,foz:e,fst:e,g12:e,geo:e,ggf:e,goiania:e,gov:[1,{ac:e,al:e,am:e,ap:e,ba:e,ce:e,df:e,es:e,go:e,ma:e,mg:e,ms:e,mt:e,pa:e,pb:e,pe:e,pi:e,pr:e,rj:e,rn:e,ro:e,rr:e,rs:e,sc:e,se:e,sp:e,to:e}],gru:e,imb:e,ind:e,inf:e,jab:e,jampa:e,jdf:e,joinville:e,jor:e,jus:e,leg:e,lel:e,log:e,londrina:e,macapa:e,maceio:e,manaus:e,maringa:e,mat:e,
med:e,mil:e,morena:e,mp:e,mus:e,natal:e,net:e,niteroi:e,nom:i,not:e,ntr:e,odo:e,ong:e,org:e,osasco:e,palmas:e,poa:e,ppg:e,pro:e,psc:e,psi:e,pvh:e,qsl:e,radio:e,rec:e,recife:e,rep:e,ribeirao:e,rio:e,riobranco:e,riopreto:e,salvador:e,sampa:e,santamaria:e,santoandre:e,saobernardo:e,saogonca:e,seg:e,sjc:e,slg:e,slz:e,sorocaba:e,srv:e,taxi:e,tc:e,tec:e,teo:e,the:e,tmp:e,trd:e,tur:e,tv:e,udi:e,vet:e,vix:e,vlog:e,wiki:e,zlg:e}],bs:n,bt:n,bv:e,bw:[1,{co:e,org:e}],by:[1,{gov:e,mil:e,com:e,of:e}],bz:n,ca:[1,{ab:e,bc:e,mb:e,nb:e,nf:e,nl:e,ns:e,nt:e,nu:e,on:e,pe:e,qc:e,sk:e,yk:e,gc:e}],cat:e,cc:e,cd:r,cf:e,cg:e,ch:e,ci:[1,{org:e,or:e,com:e,co:e,edu:e,ed:e,ac:e,net:e,go:e,asso:e,"xn--aroport-bya":e,aéroport:e,int:e,presse:e,md:e,gouv:e}],ck:i,cl:[1,{co:e,gob:e,gov:e,mil:e}],cm:[1,{co:e,com:e,gov:e,net:e}],cn:[1,{ac:e,com:e,edu:e,gov:e,net:e,org:e,mil:e,"xn--55qx5d":e,公司:e,"xn--io0a7i":e,网络:e,"xn--od0alg":e,網絡:e,ah:e,bj:e,cq:e,fj:e,gd:e,gs:e,gz:e,gx:e,ha:e,hb:e,he:e,hi:e,hl:e,hn:e,jl:e,
js:e,jx:e,ln:e,nm:e,nx:e,qh:e,sc:e,sd:e,sh:e,sn:e,sx:e,tj:e,xj:e,xz:e,yn:e,zj:e,hk:e,mo:e,tw:e}],co:[1,{arts:e,com:e,edu:e,firm:e,gov:e,info:e,int:e,mil:e,net:e,nom:e,org:e,rec:e,web:e}],com:e,coop:e,cr:[1,{ac:e,co:e,ed:e,fi:e,go:e,or:e,sa:e}],cu:[1,{com:e,edu:e,org:e,net:e,gov:e,inf:e}],cv:[1,{com:e,edu:e,int:e,nome:e,org:e}],cw:o,cx:r,cy:[1,{ac:e,biz:e,com:e,ekloges:e,gov:e,ltd:e,mil:e,net:e,org:e,press:e,pro:e,tm:e}],cz:e,de:e,dj:e,dk:e,dm:n,do:[1,{art:e,com:e,edu:e,gob:e,gov:e,mil:e,net:e,org:e,sld:e,web:e}],dz:[1,{art:e,asso:e,com:e,edu:e,gov:e,org:e,net:e,pol:e,soc:e,tm:e}],ec:[1,{com:e,info:e,net:e,fin:e,k12:e,med:e,pro:e,org:e,edu:e,gov:e,gob:e,mil:e}],edu:e,ee:[1,{edu:e,gov:e,riik:e,lib:e,med:e,com:e,pri:e,aip:e,org:e,fie:e}],eg:[1,{com:e,edu:e,eun:e,gov:e,mil:e,name:e,net:e,org:e,sci:e}],er:i,es:[1,{com:e,nom:e,org:e,gob:e,edu:e}],et:[1,{com:e,gov:e,org:e,edu:e,biz:e,name:e,info:e,net:e}],eu:e,fi:[1,{aland:e}],fj:[1,{ac:e,biz:e,com:e,gov:e,info:e,mil:e,name:e,net:e,org:e,pro:e}],
fk:i,fm:o,fo:e,fr:[1,{asso:e,com:e,gouv:e,nom:e,prd:e,tm:e,avoues:e,cci:e,greta:e,"huissier-justice":e}],ga:e,gb:e,gd:[1,{edu:e,gov:e}],ge:[1,{com:e,edu:e,gov:e,org:e,mil:e,net:e,pvt:e}],gf:e,gg:c,gh:[1,{com:e,edu:e,gov:e,org:e,mil:e}],gi:[1,{com:e,ltd:e,gov:e,mod:e,edu:e,org:e}],gl:[1,{co:e,com:e,edu:e,net:e,org:e}],gm:e,gn:[1,{ac:e,com:e,edu:e,gov:e,org:e,net:e}],gov:e,gp:[1,{com:e,net:e,mobi:e,edu:e,org:e,asso:e}],gq:e,gr:n,gs:e,gt:[1,{com:e,edu:e,gob:e,ind:e,mil:e,net:e,org:e}],gu:[1,{com:e,edu:e,gov:e,guam:e,info:e,net:e,org:e,web:e}],gw:e,gy:u,hk:[1,{com:e,edu:e,gov:e,idv:e,net:e,org:e,"xn--55qx5d":e,公司:e,"xn--wcvs22d":e,教育:e,"xn--lcvr32d":e,敎育:e,"xn--mxtq1m":e,政府:e,"xn--gmqw5a":e,個人:e,"xn--ciqpn":e,个人:e,"xn--gmq050i":e,箇人:e,"xn--zf0avx":e,網络:e,"xn--io0a7i":e,网络:e,"xn--mk0axi":e,组織:e,"xn--od0alg":e,網絡:e,"xn--od0aq3b":e,网絡:e,"xn--tn0ag":e,组织:e,"xn--uc0atv":e,組織:e,"xn--uc0ay4a":e,組织:e}],hm:e,hn:[1,{com:e,edu:e,org:e,net:e,
mil:e,gob:e}],hr:[1,{iz:e,from:e,name:e,com:e}],ht:[1,{com:e,shop:e,firm:e,info:e,adult:e,net:e,pro:e,org:e,med:e,art:e,coop:e,pol:e,asso:e,edu:e,rel:e,gouv:e,perso:e}],hu:[1,{2e3:e,co:e,info:e,org:e,priv:e,sport:e,tm:e,agrar:e,bolt:e,casino:e,city:e,erotica:e,erotika:e,film:e,forum:e,games:e,hotel:e,ingatlan:e,jogasz:e,konyvelo:e,lakas:e,media:e,news:e,reklam:e,sex:e,shop:e,suli:e,szex:e,tozsde:e,utazas:e,video:e}],id:[1,{ac:e,biz:e,co:e,desa:e,go:e,mil:e,my:e,net:e,or:e,ponpes:e,sch:e,web:e}],ie:r,il:[1,{ac:e,co:e,gov:e,idf:e,k12:e,muni:e,net:e,org:e}],"xn--4dbrk0ce":[1,{"xn--4dbgdty6c":e,"xn--5dbhl8d":e,"xn--8dbq2a":e,"xn--hebda8b":e}],ישראל:[1,{אקדמיה:e,ישוב:e,צהל:e,ממשל:e}],im:[1,{ac:e,co:[1,{ltd:e,plc:e}],com:e,net:e,org:e,tt:e,tv:e}],in:[1,{"5g":e,"6g":e,ac:e,ai:e,am:e,bihar:e,biz:e,business:e,ca:e,cn:e,co:e,com:e,coop:e,cs:e,delhi:e,dr:e,edu:e,er:e,firm:e,gen:e,gov:e,gujarat:e,ind:e,info:e,int:e,internet:e,io:e,me:e,mil:e,net:e,nic:e,org:e,pg:e,post:e,pro:e,
res:e,travel:e,tv:e,uk:e,up:e,us:e}],info:e,int:[1,{eu:e}],io:a,iq:t,ir:[1,{ac:e,co:e,gov:e,id:e,net:e,org:e,sch:e,"xn--mgba3a4f16a":e,ایران:e,"xn--mgba3a4fra":e,ايران:e}],is:[1,{net:e,com:e,edu:e,gov:e,org:e,int:e}],it:[1,{gov:e,edu:e,abr:e,abruzzo:e,"aosta-valley":e,aostavalley:e,bas:e,basilicata:e,cal:e,calabria:e,cam:e,campania:e,"emilia-romagna":e,emiliaromagna:e,emr:e,"friuli-v-giulia":e,"friuli-ve-giulia":e,"friuli-vegiulia":e,"friuli-venezia-giulia":e,"friuli-veneziagiulia":e,"friuli-vgiulia":e,"friuliv-giulia":e,"friulive-giulia":e,friulivegiulia:e,"friulivenezia-giulia":e,friuliveneziagiulia:e,friulivgiulia:e,fvg:e,laz:e,lazio:e,lig:e,liguria:e,lom:e,lombardia:e,lombardy:e,lucania:e,mar:e,marche:e,mol:e,molise:e,piedmont:e,piemonte:e,pmn:e,pug:e,puglia:e,sar:e,sardegna:e,sardinia:e,sic:e,sicilia:e,sicily:e,taa:e,tos:e,toscana:e,"trentin-sud-tirol":e,"xn--trentin-sd-tirol-rzb":e,"trentin-süd-tirol":e,"trentin-sudtirol":e,"xn--trentin-sdtirol-7vb":e,"trentin-südtirol":e,
"trentin-sued-tirol":e,"trentin-suedtirol":e,"trentino-a-adige":e,"trentino-aadige":e,"trentino-alto-adige":e,"trentino-altoadige":e,"trentino-s-tirol":e,"trentino-stirol":e,"trentino-sud-tirol":e,"xn--trentino-sd-tirol-c3b":e,"trentino-süd-tirol":e,"trentino-sudtirol":e,"xn--trentino-sdtirol-szb":e,"trentino-südtirol":e,"trentino-sued-tirol":e,"trentino-suedtirol":e,trentino:e,"trentinoa-adige":e,trentinoaadige:e,"trentinoalto-adige":e,trentinoaltoadige:e,"trentinos-tirol":e,trentinostirol:e,"trentinosud-tirol":e,"xn--trentinosd-tirol-rzb":e,"trentinosüd-tirol":e,trentinosudtirol:e,"xn--trentinosdtirol-7vb":e,trentinosüdtirol:e,"trentinosued-tirol":e,trentinosuedtirol:e,"trentinsud-tirol":e,"xn--trentinsd-tirol-6vb":e,"trentinsüd-tirol":e,trentinsudtirol:e,"xn--trentinsdtirol-nsb":e,trentinsüdtirol:e,"trentinsued-tirol":e,trentinsuedtirol:e,tuscany:e,umb:e,umbria:e,"val-d-aosta":e,"val-daosta":e,"vald-aosta":e,valdaosta:e,"valle-aosta":e,"valle-d-aosta":e,"valle-daosta":e,valleaosta:e,
"valled-aosta":e,valledaosta:e,"vallee-aoste":e,"xn--valle-aoste-ebb":e,"vallée-aoste":e,"vallee-d-aoste":e,"xn--valle-d-aoste-ehb":e,"vallée-d-aoste":e,valleeaoste:e,"xn--valleaoste-e7a":e,valléeaoste:e,valleedaoste:e,"xn--valledaoste-ebb":e,valléedaoste:e,vao:e,vda:e,ven:e,veneto:e,ag:e,agrigento:e,al:e,alessandria:e,"alto-adige":e,altoadige:e,an:e,ancona:e,"andria-barletta-trani":e,"andria-trani-barletta":e,andriabarlettatrani:e,andriatranibarletta:e,ao:e,aosta:e,aoste:e,ap:e,aq:e,aquila:e,ar:e,arezzo:e,"ascoli-piceno":e,ascolipiceno:e,asti:e,at:e,av:e,avellino:e,ba:e,"balsan-sudtirol":e,"xn--balsan-sdtirol-nsb":e,"balsan-südtirol":e,"balsan-suedtirol":e,balsan:e,bari:e,"barletta-trani-andria":e,barlettatraniandria:e,belluno:e,benevento:e,bergamo:e,bg:e,bi:e,biella:e,bl:e,bn:e,bo:e,bologna:e,"bolzano-altoadige":e,bolzano:e,"bozen-sudtirol":e,"xn--bozen-sdtirol-2ob":e,"bozen-südtirol":e,"bozen-suedtirol":e,bozen:e,br:e,brescia:e,brindisi:e,bs:e,bt:e,"bulsan-sudtirol":e,"xn--bul\
san-sdtirol-nsb":e,"bulsan-südtirol":e,"bulsan-suedtirol":e,bulsan:e,bz:e,ca:e,cagliari:e,caltanissetta:e,"campidano-medio":e,campidanomedio:e,campobasso:e,"carbonia-iglesias":e,carboniaiglesias:e,"carrara-massa":e,carraramassa:e,caserta:e,catania:e,catanzaro:e,cb:e,ce:e,"cesena-forli":e,"xn--cesena-forl-mcb":e,"cesena-forlì":e,cesenaforli:e,"xn--cesenaforl-i8a":e,cesenaforlì:e,ch:e,chieti:e,ci:e,cl:e,cn:e,co:e,como:e,cosenza:e,cr:e,cremona:e,crotone:e,cs:e,ct:e,cuneo:e,cz:e,"dell-ogliastra":e,dellogliastra:e,en:e,enna:e,fc:e,fe:e,fermo:e,ferrara:e,fg:e,fi:e,firenze:e,florence:e,fm:e,foggia:e,"forli-cesena":e,"xn--forl-cesena-fcb":e,"forlì-cesena":e,forlicesena:e,"xn--forlcesena-c8a":e,forlìcesena:e,fr:e,frosinone:e,ge:e,genoa:e,genova:e,go:e,gorizia:e,gr:e,grosseto:e,"iglesias-carbonia":e,iglesiascarbonia:e,im:e,imperia:e,is:e,isernia:e,kr:e,"la-spezia":e,laquila:e,laspezia:e,latina:e,lc:e,le:e,lecce:e,lecco:e,li:e,livorno:e,lo:e,lodi:e,lt:e,lu:e,lucca:e,macerata:e,mantova:e,"mas\
sa-carrara":e,massacarrara:e,matera:e,mb:e,mc:e,me:e,"medio-campidano":e,mediocampidano:e,messina:e,mi:e,milan:e,milano:e,mn:e,mo:e,modena:e,"monza-brianza":e,"monza-e-della-brianza":e,monza:e,monzabrianza:e,monzaebrianza:e,monzaedellabrianza:e,ms:e,mt:e,na:e,naples:e,napoli:e,no:e,novara:e,nu:e,nuoro:e,og:e,ogliastra:e,"olbia-tempio":e,olbiatempio:e,or:e,oristano:e,ot:e,pa:e,padova:e,padua:e,palermo:e,parma:e,pavia:e,pc:e,pd:e,pe:e,perugia:e,"pesaro-urbino":e,pesarourbino:e,pescara:e,pg:e,pi:e,piacenza:e,pisa:e,pistoia:e,pn:e,po:e,pordenone:e,potenza:e,pr:e,prato:e,pt:e,pu:e,pv:e,pz:e,ra:e,ragusa:e,ravenna:e,rc:e,re:e,"reggio-calabria":e,"reggio-emilia":e,reggiocalabria:e,reggioemilia:e,rg:e,ri:e,rieti:e,rimini:e,rm:e,rn:e,ro:e,roma:e,rome:e,rovigo:e,sa:e,salerno:e,sassari:e,savona:e,si:e,siena:e,siracusa:e,so:e,sondrio:e,sp:e,sr:e,ss:e,suedtirol:e,"xn--sdtirol-n2a":e,südtirol:e,sv:e,ta:e,taranto:e,te:e,"tempio-olbia":e,tempioolbia:e,teramo:e,terni:e,tn:e,to:e,torino:e,tp:e,tr:e,"tra\
ni-andria-barletta":e,"trani-barletta-andria":e,traniandriabarletta:e,tranibarlettaandria:e,trapani:e,trento:e,treviso:e,trieste:e,ts:e,turin:e,tv:e,ud:e,udine:e,"urbino-pesaro":e,urbinopesaro:e,va:e,varese:e,vb:e,vc:e,ve:e,venezia:e,venice:e,verbania:e,vercelli:e,verona:e,vi:e,"vibo-valentia":e,vibovalentia:e,vicenza:e,viterbo:e,vr:e,vs:e,vt:e,vv:e}],je:c,jm:i,jo:l,jobs:e,jp:[1,{ac:e,ad:e,co:e,ed:e,go:e,gr:e,lg:e,ne:e,or:e,aichi:[1,{aisai:e,ama:e,anjo:e,asuke:e,chiryu:e,chita:e,fuso:e,gamagori:e,handa:e,hazu:e,hekinan:e,higashiura:e,ichinomiya:e,inazawa:e,inuyama:e,isshiki:e,iwakura:e,kanie:e,kariya:e,kasugai:e,kira:e,kiyosu:e,komaki:e,konan:e,kota:e,mihama:e,miyoshi:e,nishio:e,nisshin:e,obu:e,oguchi:e,oharu:e,okazaki:e,owariasahi:e,seto:e,shikatsu:e,shinshiro:e,shitara:e,tahara:e,takahama:e,tobishima:e,toei:e,togo:e,tokai:e,tokoname:e,toyoake:e,toyohashi:e,toyokawa:e,toyone:e,toyota:e,tsushima:e,yatomi:e}],akita:[1,{akita:e,daisen:e,fujisato:e,gojome:e,hachirogata:e,happou:e,higashinaruse:e,
honjo:e,honjyo:e,ikawa:e,kamikoani:e,kamioka:e,katagami:e,kazuno:e,kitaakita:e,kosaka:e,kyowa:e,misato:e,mitane:e,moriyoshi:e,nikaho:e,noshiro:e,odate:e,oga:e,ogata:e,semboku:e,yokote:e,yurihonjo:e}],aomori:[1,{aomori:e,gonohe:e,hachinohe:e,hashikami:e,hiranai:e,hirosaki:e,itayanagi:e,kuroishi:e,misawa:e,mutsu:e,nakadomari:e,noheji:e,oirase:e,owani:e,rokunohe:e,sannohe:e,shichinohe:e,shingo:e,takko:e,towada:e,tsugaru:e,tsuruta:e}],chiba:[1,{abiko:e,asahi:e,chonan:e,chosei:e,choshi:e,chuo:e,funabashi:e,futtsu:e,hanamigawa:e,ichihara:e,ichikawa:e,ichinomiya:e,inzai:e,isumi:e,kamagaya:e,kamogawa:e,kashiwa:e,katori:e,katsuura:e,kimitsu:e,kisarazu:e,kozaki:e,kujukuri:e,kyonan:e,matsudo:e,midori:e,mihama:e,minamiboso:e,mobara:e,mutsuzawa:e,nagara:e,nagareyama:e,narashino:e,narita:e,noda:e,oamishirasato:e,omigawa:e,onjuku:e,otaki:e,sakae:e,sakura:e,shimofusa:e,shirako:e,shiroi:e,shisui:e,sodegaura:e,sosa:e,tako:e,tateyama:e,togane:e,tohnosho:e,tomisato:e,urayasu:e,yachimata:e,yachiyo:e,yokaichiba:e,
yokoshibahikari:e,yotsukaido:e}],ehime:[1,{ainan:e,honai:e,ikata:e,imabari:e,iyo:e,kamijima:e,kihoku:e,kumakogen:e,masaki:e,matsuno:e,matsuyama:e,namikata:e,niihama:e,ozu:e,saijo:e,seiyo:e,shikokuchuo:e,tobe:e,toon:e,uchiko:e,uwajima:e,yawatahama:e}],fukui:[1,{echizen:e,eiheiji:e,fukui:e,ikeda:e,katsuyama:e,mihama:e,minamiechizen:e,obama:e,ohi:e,ono:e,sabae:e,sakai:e,takahama:e,tsuruga:e,wakasa:e}],fukuoka:[1,{ashiya:e,buzen:e,chikugo:e,chikuho:e,chikujo:e,chikushino:e,chikuzen:e,chuo:e,dazaifu:e,fukuchi:e,hakata:e,higashi:e,hirokawa:e,hisayama:e,iizuka:e,inatsuki:e,kaho:e,kasuga:e,kasuya:e,kawara:e,keisen:e,koga:e,kurate:e,kurogi:e,kurume:e,minami:e,miyako:e,miyama:e,miyawaka:e,mizumaki:e,munakata:e,nakagawa:e,nakama:e,nishi:e,nogata:e,ogori:e,okagaki:e,okawa:e,oki:e,omuta:e,onga:e,onojo:e,oto:e,saigawa:e,sasaguri:e,shingu:e,shinyoshitomi:e,shonai:e,soeda:e,sue:e,tachiarai:e,tagawa:e,takata:e,toho:e,toyotsu:e,tsuiki:e,ukiha:e,umi:e,usui:e,yamada:e,yame:e,yanagawa:e,yukuhashi:e}],fukushima:[
1,{aizubange:e,aizumisato:e,aizuwakamatsu:e,asakawa:e,bandai:e,date:e,fukushima:e,furudono:e,futaba:e,hanawa:e,higashi:e,hirata:e,hirono:e,iitate:e,inawashiro:e,ishikawa:e,iwaki:e,izumizaki:e,kagamiishi:e,kaneyama:e,kawamata:e,kitakata:e,kitashiobara:e,koori:e,koriyama:e,kunimi:e,miharu:e,mishima:e,namie:e,nango:e,nishiaizu:e,nishigo:e,okuma:e,omotego:e,ono:e,otama:e,samegawa:e,shimogo:e,shirakawa:e,showa:e,soma:e,sukagawa:e,taishin:e,tamakawa:e,tanagura:e,tenei:e,yabuki:e,yamato:e,yamatsuri:e,yanaizu:e,yugawa:e}],gifu:[1,{anpachi:e,ena:e,gifu:e,ginan:e,godo:e,gujo:e,hashima:e,hichiso:e,hida:e,higashishirakawa:e,ibigawa:e,ikeda:e,kakamigahara:e,kani:e,kasahara:e,kasamatsu:e,kawaue:e,kitagata:e,mino:e,minokamo:e,mitake:e,mizunami:e,motosu:e,nakatsugawa:e,ogaki:e,sakahogi:e,seki:e,sekigahara:e,shirakawa:e,tajimi:e,takayama:e,tarui:e,toki:e,tomika:e,wanouchi:e,yamagata:e,yaotsu:e,yoro:e}],gunma:[1,{annaka:e,chiyoda:e,fujioka:e,higashiagatsuma:e,isesaki:e,itakura:e,kanna:e,kanra:e,katashina:e,
kawaba:e,kiryu:e,kusatsu:e,maebashi:e,meiwa:e,midori:e,minakami:e,naganohara:e,nakanojo:e,nanmoku:e,numata:e,oizumi:e,ora:e,ota:e,shibukawa:e,shimonita:e,shinto:e,showa:e,takasaki:e,takayama:e,tamamura:e,tatebayashi:e,tomioka:e,tsukiyono:e,tsumagoi:e,ueno:e,yoshioka:e}],hiroshima:[1,{asaminami:e,daiwa:e,etajima:e,fuchu:e,fukuyama:e,hatsukaichi:e,higashihiroshima:e,hongo:e,jinsekikogen:e,kaita:e,kui:e,kumano:e,kure:e,mihara:e,miyoshi:e,naka:e,onomichi:e,osakikamijima:e,otake:e,saka:e,sera:e,seranishi:e,shinichi:e,shobara:e,takehara:e}],hokkaido:[1,{abashiri:e,abira:e,aibetsu:e,akabira:e,akkeshi:e,asahikawa:e,ashibetsu:e,ashoro:e,assabu:e,atsuma:e,bibai:e,biei:e,bifuka:e,bihoro:e,biratori:e,chippubetsu:e,chitose:e,date:e,ebetsu:e,embetsu:e,eniwa:e,erimo:e,esan:e,esashi:e,fukagawa:e,fukushima:e,furano:e,furubira:e,haboro:e,hakodate:e,hamatonbetsu:e,hidaka:e,higashikagura:e,higashikawa:e,hiroo:e,hokuryu:e,hokuto:e,honbetsu:e,horokanai:e,horonobe:e,ikeda:e,imakane:e,ishikari:e,iwamizawa:e,iwanai:e,
kamifurano:e,kamikawa:e,kamishihoro:e,kamisunagawa:e,kamoenai:e,kayabe:e,kembuchi:e,kikonai:e,kimobetsu:e,kitahiroshima:e,kitami:e,kiyosato:e,koshimizu:e,kunneppu:e,kuriyama:e,kuromatsunai:e,kushiro:e,kutchan:e,kyowa:e,mashike:e,matsumae:e,mikasa:e,minamifurano:e,mombetsu:e,moseushi:e,mukawa:e,muroran:e,naie:e,nakagawa:e,nakasatsunai:e,nakatombetsu:e,nanae:e,nanporo:e,nayoro:e,nemuro:e,niikappu:e,niki:e,nishiokoppe:e,noboribetsu:e,numata:e,obihiro:e,obira:e,oketo:e,okoppe:e,otaru:e,otobe:e,otofuke:e,otoineppu:e,oumu:e,ozora:e,pippu:e,rankoshi:e,rebun:e,rikubetsu:e,rishiri:e,rishirifuji:e,saroma:e,sarufutsu:e,shakotan:e,shari:e,shibecha:e,shibetsu:e,shikabe:e,shikaoi:e,shimamaki:e,shimizu:e,shimokawa:e,shinshinotsu:e,shintoku:e,shiranuka:e,shiraoi:e,shiriuchi:e,sobetsu:e,sunagawa:e,taiki:e,takasu:e,takikawa:e,takinoue:e,teshikaga:e,tobetsu:e,tohma:e,tomakomai:e,tomari:e,toya:e,toyako:e,toyotomi:e,toyoura:e,tsubetsu:e,tsukigata:e,urakawa:e,urausu:e,uryu:e,utashinai:e,wakkanai:e,wassamu:e,
yakumo:e,yoichi:e}],hyogo:[1,{aioi:e,akashi:e,ako:e,amagasaki:e,aogaki:e,asago:e,ashiya:e,awaji:e,fukusaki:e,goshiki:e,harima:e,himeji:e,ichikawa:e,inagawa:e,itami:e,kakogawa:e,kamigori:e,kamikawa:e,kasai:e,kasuga:e,kawanishi:e,miki:e,minamiawaji:e,nishinomiya:e,nishiwaki:e,ono:e,sanda:e,sannan:e,sasayama:e,sayo:e,shingu:e,shinonsen:e,shiso:e,sumoto:e,taishi:e,taka:e,takarazuka:e,takasago:e,takino:e,tamba:e,tatsuno:e,toyooka:e,yabu:e,yashiro:e,yoka:e,yokawa:e}],ibaraki:[1,{ami:e,asahi:e,bando:e,chikusei:e,daigo:e,fujishiro:e,hitachi:e,hitachinaka:e,hitachiomiya:e,hitachiota:e,ibaraki:e,ina:e,inashiki:e,itako:e,iwama:e,joso:e,kamisu:e,kasama:e,kashima:e,kasumigaura:e,koga:e,miho:e,mito:e,moriya:e,naka:e,namegata:e,oarai:e,ogawa:e,omitama:e,ryugasaki:e,sakai:e,sakuragawa:e,shimodate:e,shimotsuma:e,shirosato:e,sowa:e,suifu:e,takahagi:e,tamatsukuri:e,tokai:e,tomobe:e,tone:e,toride:e,tsuchiura:e,tsukuba:e,uchihara:e,ushiku:e,yachiyo:e,yamagata:e,yawara:e,yuki:e}],ishikawa:[1,{anamizu:e,hakui:e,
hakusan:e,kaga:e,kahoku:e,kanazawa:e,kawakita:e,komatsu:e,nakanoto:e,nanao:e,nomi:e,nonoichi:e,noto:e,shika:e,suzu:e,tsubata:e,tsurugi:e,uchinada:e,wajima:e}],iwate:[1,{fudai:e,fujisawa:e,hanamaki:e,hiraizumi:e,hirono:e,ichinohe:e,ichinoseki:e,iwaizumi:e,iwate:e,joboji:e,kamaishi:e,kanegasaki:e,karumai:e,kawai:e,kitakami:e,kuji:e,kunohe:e,kuzumaki:e,miyako:e,mizusawa:e,morioka:e,ninohe:e,noda:e,ofunato:e,oshu:e,otsuchi:e,rikuzentakata:e,shiwa:e,shizukuishi:e,sumita:e,tanohata:e,tono:e,yahaba:e,yamada:e}],kagawa:[1,{ayagawa:e,higashikagawa:e,kanonji:e,kotohira:e,manno:e,marugame:e,mitoyo:e,naoshima:e,sanuki:e,tadotsu:e,takamatsu:e,tonosho:e,uchinomi:e,utazu:e,zentsuji:e}],kagoshima:[1,{akune:e,amami:e,hioki:e,isa:e,isen:e,izumi:e,kagoshima:e,kanoya:e,kawanabe:e,kinko:e,kouyama:e,makurazaki:e,matsumoto:e,minamitane:e,nakatane:e,nishinoomote:e,satsumasendai:e,soo:e,tarumizu:e,yusui:e}],kanagawa:[1,{aikawa:e,atsugi:e,ayase:e,chigasaki:e,ebina:e,fujisawa:e,hadano:e,hakone:e,hiratsuka:e,isehara:e,
kaisei:e,kamakura:e,kiyokawa:e,matsuda:e,minamiashigara:e,miura:e,nakai:e,ninomiya:e,odawara:e,oi:e,oiso:e,sagamihara:e,samukawa:e,tsukui:e,yamakita:e,yamato:e,yokosuka:e,yugawara:e,zama:e,zushi:e}],kochi:[1,{aki:e,geisei:e,hidaka:e,higashitsuno:e,ino:e,kagami:e,kami:e,kitagawa:e,kochi:e,mihara:e,motoyama:e,muroto:e,nahari:e,nakamura:e,nankoku:e,nishitosa:e,niyodogawa:e,ochi:e,okawa:e,otoyo:e,otsuki:e,sakawa:e,sukumo:e,susaki:e,tosa:e,tosashimizu:e,toyo:e,tsuno:e,umaji:e,yasuda:e,yusuhara:e}],kumamoto:[1,{amakusa:e,arao:e,aso:e,choyo:e,gyokuto:e,kamiamakusa:e,kikuchi:e,kumamoto:e,mashiki:e,mifune:e,minamata:e,minamioguni:e,nagasu:e,nishihara:e,oguni:e,ozu:e,sumoto:e,takamori:e,uki:e,uto:e,yamaga:e,yamato:e,yatsushiro:e}],kyoto:[1,{ayabe:e,fukuchiyama:e,higashiyama:e,ide:e,ine:e,joyo:e,kameoka:e,kamo:e,kita:e,kizu:e,kumiyama:e,kyotamba:e,kyotanabe:e,kyotango:e,maizuru:e,minami:e,minamiyamashiro:e,miyazu:e,muko:e,nagaokakyo:e,nakagyo:e,nantan:e,oyamazaki:e,sakyo:e,seika:e,tanabe:e,uji:e,
ujitawara:e,wazuka:e,yamashina:e,yawata:e}],mie:[1,{asahi:e,inabe:e,ise:e,kameyama:e,kawagoe:e,kiho:e,kisosaki:e,kiwa:e,komono:e,kumano:e,kuwana:e,matsusaka:e,meiwa:e,mihama:e,minamiise:e,misugi:e,miyama:e,nabari:e,shima:e,suzuka:e,tado:e,taiki:e,taki:e,tamaki:e,toba:e,tsu:e,udono:e,ureshino:e,watarai:e,yokkaichi:e}],miyagi:[1,{furukawa:e,higashimatsushima:e,ishinomaki:e,iwanuma:e,kakuda:e,kami:e,kawasaki:e,marumori:e,matsushima:e,minamisanriku:e,misato:e,murata:e,natori:e,ogawara:e,ohira:e,onagawa:e,osaki:e,rifu:e,semine:e,shibata:e,shichikashuku:e,shikama:e,shiogama:e,shiroishi:e,tagajo:e,taiwa:e,tome:e,tomiya:e,wakuya:e,watari:e,yamamoto:e,zao:e}],miyazaki:[1,{aya:e,ebino:e,gokase:e,hyuga:e,kadogawa:e,kawaminami:e,kijo:e,kitagawa:e,kitakata:e,kitaura:e,kobayashi:e,kunitomi:e,kushima:e,mimata:e,miyakonojo:e,miyazaki:e,morotsuka:e,nichinan:e,nishimera:e,nobeoka:e,saito:e,shiiba:e,shintomi:e,takaharu:e,takanabe:e,takazaki:e,tsuno:e}],nagano:[1,{achi:e,agematsu:e,anan:e,aoki:e,asahi:e,azumino:e,
chikuhoku:e,chikuma:e,chino:e,fujimi:e,hakuba:e,hara:e,hiraya:e,iida:e,iijima:e,iiyama:e,iizuna:e,ikeda:e,ikusaka:e,ina:e,karuizawa:e,kawakami:e,kiso:e,kisofukushima:e,kitaaiki:e,komagane:e,komoro:e,matsukawa:e,matsumoto:e,miasa:e,minamiaiki:e,minamimaki:e,minamiminowa:e,minowa:e,miyada:e,miyota:e,mochizuki:e,nagano:e,nagawa:e,nagiso:e,nakagawa:e,nakano:e,nozawaonsen:e,obuse:e,ogawa:e,okaya:e,omachi:e,omi:e,ookuwa:e,ooshika:e,otaki:e,otari:e,sakae:e,sakaki:e,saku:e,sakuho:e,shimosuwa:e,shinanomachi:e,shiojiri:e,suwa:e,suzaka:e,takagi:e,takamori:e,takayama:e,tateshina:e,tatsuno:e,togakushi:e,togura:e,tomi:e,ueda:e,wada:e,yamagata:e,yamanouchi:e,yasaka:e,yasuoka:e}],nagasaki:[1,{chijiwa:e,futsu:e,goto:e,hasami:e,hirado:e,iki:e,isahaya:e,kawatana:e,kuchinotsu:e,matsuura:e,nagasaki:e,obama:e,omura:e,oseto:e,saikai:e,sasebo:e,seihi:e,shimabara:e,shinkamigoto:e,togitsu:e,tsushima:e,unzen:e}],nara:[1,{ando:e,gose:e,heguri:e,higashiyoshino:e,ikaruga:e,ikoma:e,kamikitayama:e,kanmaki:e,kashiba:e,
kashihara:e,katsuragi:e,kawai:e,kawakami:e,kawanishi:e,koryo:e,kurotaki:e,mitsue:e,miyake:e,nara:e,nosegawa:e,oji:e,ouda:e,oyodo:e,sakurai:e,sango:e,shimoichi:e,shimokitayama:e,shinjo:e,soni:e,takatori:e,tawaramoto:e,tenkawa:e,tenri:e,uda:e,yamatokoriyama:e,yamatotakada:e,yamazoe:e,yoshino:e}],niigata:[1,{aga:e,agano:e,gosen:e,itoigawa:e,izumozaki:e,joetsu:e,kamo:e,kariwa:e,kashiwazaki:e,minamiuonuma:e,mitsuke:e,muika:e,murakami:e,myoko:e,nagaoka:e,niigata:e,ojiya:e,omi:e,sado:e,sanjo:e,seiro:e,seirou:e,sekikawa:e,shibata:e,tagami:e,tainai:e,tochio:e,tokamachi:e,tsubame:e,tsunan:e,uonuma:e,yahiko:e,yoita:e,yuzawa:e}],oita:[1,{beppu:e,bungoono:e,bungotakada:e,hasama:e,hiji:e,himeshima:e,hita:e,kamitsue:e,kokonoe:e,kuju:e,kunisaki:e,kusu:e,oita:e,saiki:e,taketa:e,tsukumi:e,usa:e,usuki:e,yufu:e}],okayama:[1,{akaiwa:e,asakuchi:e,bizen:e,hayashima:e,ibara:e,kagamino:e,kasaoka:e,kibichuo:e,kumenan:e,kurashiki:e,maniwa:e,misaki:e,nagi:e,niimi:e,nishiawakura:e,okayama:e,satosho:e,setouchi:e,shinjo:e,
shoo:e,soja:e,takahashi:e,tamano:e,tsuyama:e,wake:e,yakage:e}],okinawa:[1,{aguni:e,ginowan:e,ginoza:e,gushikami:e,haebaru:e,higashi:e,hirara:e,iheya:e,ishigaki:e,ishikawa:e,itoman:e,izena:e,kadena:e,kin:e,kitadaito:e,kitanakagusuku:e,kumejima:e,kunigami:e,minamidaito:e,motobu:e,nago:e,naha:e,nakagusuku:e,nakijin:e,nanjo:e,nishihara:e,ogimi:e,okinawa:e,onna:e,shimoji:e,taketomi:e,tarama:e,tokashiki:e,tomigusuku:e,tonaki:e,urasoe:e,uruma:e,yaese:e,yomitan:e,yonabaru:e,yonaguni:e,zamami:e}],osaka:[1,{abeno:e,chihayaakasaka:e,chuo:e,daito:e,fujiidera:e,habikino:e,hannan:e,higashiosaka:e,higashisumiyoshi:e,higashiyodogawa:e,hirakata:e,ibaraki:e,ikeda:e,izumi:e,izumiotsu:e,izumisano:e,kadoma:e,kaizuka:e,kanan:e,kashiwara:e,katano:e,kawachinagano:e,kishiwada:e,kita:e,kumatori:e,matsubara:e,minato:e,minoh:e,misaki:e,moriguchi:e,neyagawa:e,nishi:e,nose:e,osakasayama:e,sakai:e,sayama:e,sennan:e,settsu:e,shijonawate:e,shimamoto:e,suita:e,tadaoka:e,taishi:e,tajiri:e,takaishi:e,takatsuki:e,tondabayashi:e,
toyonaka:e,toyono:e,yao:e}],saga:[1,{ariake:e,arita:e,fukudomi:e,genkai:e,hamatama:e,hizen:e,imari:e,kamimine:e,kanzaki:e,karatsu:e,kashima:e,kitagata:e,kitahata:e,kiyama:e,kouhoku:e,kyuragi:e,nishiarita:e,ogi:e,omachi:e,ouchi:e,saga:e,shiroishi:e,taku:e,tara:e,tosu:e,yoshinogari:e}],saitama:[1,{arakawa:e,asaka:e,chichibu:e,fujimi:e,fujimino:e,fukaya:e,hanno:e,hanyu:e,hasuda:e,hatogaya:e,hatoyama:e,hidaka:e,higashichichibu:e,higashimatsuyama:e,honjo:e,ina:e,iruma:e,iwatsuki:e,kamiizumi:e,kamikawa:e,kamisato:e,kasukabe:e,kawagoe:e,kawaguchi:e,kawajima:e,kazo:e,kitamoto:e,koshigaya:e,kounosu:e,kuki:e,kumagaya:e,matsubushi:e,minano:e,misato:e,miyashiro:e,miyoshi:e,moroyama:e,nagatoro:e,namegawa:e,niiza:e,ogano:e,ogawa:e,ogose:e,okegawa:e,omiya:e,otaki:e,ranzan:e,ryokami:e,saitama:e,sakado:e,satte:e,sayama:e,shiki:e,shiraoka:e,soka:e,sugito:e,toda:e,tokigawa:e,tokorozawa:e,tsurugashima:e,urawa:e,warabi:e,yashio:e,yokoze:e,yono:e,yorii:e,yoshida:e,yoshikawa:e,yoshimi:e}],shiga:[1,{aisho:e,gamo:e,
higashiomi:e,hikone:e,koka:e,konan:e,kosei:e,koto:e,kusatsu:e,maibara:e,moriyama:e,nagahama:e,nishiazai:e,notogawa:e,omihachiman:e,otsu:e,ritto:e,ryuoh:e,takashima:e,takatsuki:e,torahime:e,toyosato:e,yasu:e}],shimane:[1,{akagi:e,ama:e,gotsu:e,hamada:e,higashiizumo:e,hikawa:e,hikimi:e,izumo:e,kakinoki:e,masuda:e,matsue:e,misato:e,nishinoshima:e,ohda:e,okinoshima:e,okuizumo:e,shimane:e,tamayu:e,tsuwano:e,unnan:e,yakumo:e,yasugi:e,yatsuka:e}],shizuoka:[1,{arai:e,atami:e,fuji:e,fujieda:e,fujikawa:e,fujinomiya:e,fukuroi:e,gotemba:e,haibara:e,hamamatsu:e,higashiizu:e,ito:e,iwata:e,izu:e,izunokuni:e,kakegawa:e,kannami:e,kawanehon:e,kawazu:e,kikugawa:e,kosai:e,makinohara:e,matsuzaki:e,minamiizu:e,mishima:e,morimachi:e,nishiizu:e,numazu:e,omaezaki:e,shimada:e,shimizu:e,shimoda:e,shizuoka:e,susono:e,yaizu:e,yoshida:e}],tochigi:[1,{ashikaga:e,bato:e,haga:e,ichikai:e,iwafune:e,kaminokawa:e,kanuma:e,karasuyama:e,kuroiso:e,mashiko:e,mibu:e,moka:e,motegi:e,nasu:e,nasushiobara:e,nikko:e,nishikata:e,nogi:e,
ohira:e,ohtawara:e,oyama:e,sakura:e,sano:e,shimotsuke:e,shioya:e,takanezawa:e,tochigi:e,tsuga:e,ujiie:e,utsunomiya:e,yaita:e}],tokushima:[1,{aizumi:e,anan:e,ichiba:e,itano:e,kainan:e,komatsushima:e,matsushige:e,mima:e,minami:e,miyoshi:e,mugi:e,nakagawa:e,naruto:e,sanagochi:e,shishikui:e,tokushima:e,wajiki:e}],tokyo:[1,{adachi:e,akiruno:e,akishima:e,aogashima:e,arakawa:e,bunkyo:e,chiyoda:e,chofu:e,chuo:e,edogawa:e,fuchu:e,fussa:e,hachijo:e,hachioji:e,hamura:e,higashikurume:e,higashimurayama:e,higashiyamato:e,hino:e,hinode:e,hinohara:e,inagi:e,itabashi:e,katsushika:e,kita:e,kiyose:e,kodaira:e,koganei:e,kokubunji:e,komae:e,koto:e,kouzushima:e,kunitachi:e,machida:e,meguro:e,minato:e,mitaka:e,mizuho:e,musashimurayama:e,musashino:e,nakano:e,nerima:e,ogasawara:e,okutama:e,ome:e,oshima:e,ota:e,setagaya:e,shibuya:e,shinagawa:e,shinjuku:e,suginami:e,sumida:e,tachikawa:e,taito:e,tama:e,toshima:e}],tottori:[1,{chizu:e,hino:e,kawahara:e,koge:e,kotoura:e,misasa:e,nanbu:e,nichinan:e,sakaiminato:e,tottori:e,
wakasa:e,yazu:e,yonago:e}],toyama:[1,{asahi:e,fuchu:e,fukumitsu:e,funahashi:e,himi:e,imizu:e,inami:e,johana:e,kamiichi:e,kurobe:e,nakaniikawa:e,namerikawa:e,nanto:e,nyuzen:e,oyabe:e,taira:e,takaoka:e,tateyama:e,toga:e,tonami:e,toyama:e,unazuki:e,uozu:e,yamada:e}],wakayama:[1,{arida:e,aridagawa:e,gobo:e,hashimoto:e,hidaka:e,hirogawa:e,inami:e,iwade:e,kainan:e,kamitonda:e,katsuragi:e,kimino:e,kinokawa:e,kitayama:e,koya:e,koza:e,kozagawa:e,kudoyama:e,kushimoto:e,mihama:e,misato:e,nachikatsuura:e,shingu:e,shirahama:e,taiji:e,tanabe:e,wakayama:e,yuasa:e,yura:e}],yamagata:[1,{asahi:e,funagata:e,higashine:e,iide:e,kahoku:e,kaminoyama:e,kaneyama:e,kawanishi:e,mamurogawa:e,mikawa:e,murayama:e,nagai:e,nakayama:e,nanyo:e,nishikawa:e,obanazawa:e,oe:e,oguni:e,ohkura:e,oishida:e,sagae:e,sakata:e,sakegawa:e,shinjo:e,shirataka:e,shonai:e,takahata:e,tendo:e,tozawa:e,tsuruoka:e,yamagata:e,yamanobe:e,yonezawa:e,yuza:e}],yamaguchi:[1,{abu:e,hagi:e,hikari:e,hofu:e,iwakuni:e,kudamatsu:e,mitou:e,nagato:e,oshima:e,
shimonoseki:e,shunan:e,tabuse:e,tokuyama:e,toyota:e,ube:e,yuu:e}],yamanashi:[1,{chuo:e,doshi:e,fuefuki:e,fujikawa:e,fujikawaguchiko:e,fujiyoshida:e,hayakawa:e,hokuto:e,ichikawamisato:e,kai:e,kofu:e,koshu:e,kosuge:e,"minami-alps":e,minobu:e,nakamichi:e,nanbu:e,narusawa:e,nirasaki:e,nishikatsura:e,oshino:e,otsuki:e,showa:e,tabayama:e,tsuru:e,uenohara:e,yamanakako:e,yamanashi:e}],"xn--4pvxs":e,栃木:e,"xn--vgu402c":e,愛知:e,"xn--c3s14m":e,愛媛:e,"xn--f6qx53a":e,兵庫:e,"xn--8pvr4u":e,熊本:e,"xn--uist22h":e,茨城:e,"xn--djrs72d6uy":e,北海道:e,"xn--mkru45i":e,千葉:e,"xn--0trq7p7nn":e,和歌山:e,"xn--8ltr62k":e,長崎:e,"xn--2m4a15e":e,長野:e,"xn--efvn9s":e,新潟:e,"xn--32vp30h":e,青森:e,"xn--4it797k":e,静岡:e,"xn--1lqs71d":e,東京:e,"xn--5rtp49c":e,石川:e,"xn--5js045d":e,埼玉:e,"xn--ehqz56n":e,三重:e,"xn--1lqs03n":e,京都:e,"xn--qqqt11m":e,佐賀:e,"xn--kbrq7o":e,大分:e,"xn--pssu33l":e,大阪:e,"xn--ntsq17g":e,奈良:e,"xn--uisz3g":e,宮城:e,"xn--6btw5a":e,宮崎:e,
"xn--1ctwo":e,富山:e,"xn--6orx2r":e,山口:e,"xn--rht61e":e,山形:e,"xn--rht27z":e,山梨:e,"xn--djty4k":e,岩手:e,"xn--nit225k":e,岐阜:e,"xn--rht3d":e,岡山:e,"xn--klty5x":e,島根:e,"xn--kltx9a":e,広島:e,"xn--kltp7d":e,徳島:e,"xn--uuwu58a":e,沖縄:e,"xn--zbx025d":e,滋賀:e,"xn--ntso0iqx3a":e,神奈川:e,"xn--elqq16h":e,福井:e,"xn--4it168d":e,福岡:e,"xn--klt787d":e,福島:e,"xn--rny31h":e,秋田:e,"xn--7t0a264c":e,群馬:e,"xn--5rtq34k":e,香川:e,"xn--k7yn95e":e,高知:e,"xn--tor131o":e,鳥取:e,"xn--d5qv7z876c":e,鹿児島:e,kawasaki:i,kitakyushu:i,kobe:i,nagoya:i,sapporo:i,sendai:i,yokohama:i}],ke:[1,{ac:e,co:e,go:e,info:e,me:e,mobi:e,ne:e,or:e,sc:e}],kg:t,kh:i,ki:m,km:[1,{org:e,nom:e,gov:e,prd:e,tm:e,edu:e,mil:e,ass:e,com:e,coop:e,asso:e,presse:e,medecin:e,notaires:e,pharmaciens:e,veterinaire:e,gouv:e}],kn:[1,{net:e,org:e,edu:e,gov:e}],kp:[1,{com:e,edu:e,gov:e,org:e,rep:e,tra:e}],kr:[1,{ac:e,co:e,es:e,go:e,hs:e,kg:e,mil:e,ms:e,ne:e,or:e,pe:e,re:e,sc:e,busan:e,chungbuk:e,
chungnam:e,daegu:e,daejeon:e,gangwon:e,gwangju:e,gyeongbuk:e,gyeonggi:e,gyeongnam:e,incheon:e,jeju:e,jeonbuk:e,jeonnam:e,seoul:e,ulsan:e}],kw:[1,{com:e,edu:e,emb:e,gov:e,ind:e,net:e,org:e}],ky:o,kz:t,la:[1,{int:e,net:e,info:e,edu:e,gov:e,per:e,com:e,org:e}],lb:n,lc:u,li:e,lk:[1,{gov:e,sch:e,net:e,int:e,com:e,org:e,edu:e,ngo:e,soc:e,web:e,ltd:e,assn:e,grp:e,hotel:e,ac:e}],lr:n,ls:[1,{ac:e,biz:e,co:e,edu:e,gov:e,info:e,net:e,org:e,sc:e}],lt:r,lu:e,lv:[1,{com:e,edu:e,gov:e,org:e,mil:e,id:e,net:e,asn:e,conf:e}],ly:[1,{com:e,net:e,gov:e,plc:e,edu:e,sch:e,med:e,org:e,id:e}],ma:[1,{co:e,net:e,gov:e,org:e,ac:e,press:e}],mc:[1,{tm:e,asso:e}],md:e,me:[1,{co:e,net:e,org:e,edu:e,ac:e,gov:e,its:e,priv:e}],mg:[1,{org:e,nom:e,gov:e,prd:e,tm:e,edu:e,mil:e,com:e,co:e}],mh:e,mil:e,mk:[1,{com:e,org:e,net:e,edu:e,gov:e,inf:e,name:e}],ml:[1,{com:e,edu:e,gouv:e,gov:e,net:e,org:e,presse:e}],mm:i,mn:[1,{gov:e,edu:e,org:e}],mo:n,mobi:e,mp:e,mq:e,mr:r,ms:n,mt:o,mu:[1,{com:e,net:e,org:e,gov:e,ac:e,co:e,or:e}],museum:e,
mv:[1,{aero:e,biz:e,com:e,coop:e,edu:e,gov:e,info:e,int:e,mil:e,museum:e,name:e,net:e,org:e,pro:e}],mw:[1,{ac:e,biz:e,co:e,com:e,coop:e,edu:e,gov:e,int:e,museum:e,net:e,org:e}],mx:[1,{com:e,org:e,gob:e,edu:e,net:e}],my:[1,{biz:e,com:e,edu:e,gov:e,mil:e,name:e,net:e,org:e}],mz:[1,{ac:e,adv:e,co:e,edu:e,gov:e,mil:e,net:e,org:e}],na:[1,{info:e,pro:e,name:e,school:e,or:e,dr:e,us:e,mx:e,ca:e,in:e,cc:e,tv:e,ws:e,mobi:e,co:e,com:e,org:e}],name:e,nc:[1,{asso:e,nom:e}],ne:e,net:e,nf:[1,{com:e,net:e,per:e,rec:e,web:e,arts:e,firm:e,info:e,other:e,store:e}],ng:[1,{com:e,edu:e,gov:e,i:e,mil:e,mobi:e,name:e,net:e,org:e,sch:e}],ni:[1,{ac:e,biz:e,co:e,com:e,edu:e,gob:e,in:e,info:e,int:e,mil:e,net:e,nom:e,org:e,web:e}],nl:e,no:[1,{fhs:e,vgs:e,fylkesbibl:e,folkebibl:e,museum:e,idrett:e,priv:e,mil:e,stat:e,dep:e,kommune:e,herad:e,aa:p,ah:p,bu:p,fm:p,hl:p,hm:p,"jan-mayen":p,mr:p,nl:p,nt:p,of:p,ol:p,oslo:p,rl:p,sf:p,st:p,svalbard:p,tm:p,tr:p,va:p,vf:p,akrehamn:e,"xn--krehamn-dxa":e,åkrehamn:e,algard:e,"xn\
--lgrd-poac":e,ålgård:e,arna:e,brumunddal:e,bryne:e,bronnoysund:e,"xn--brnnysund-m8ac":e,brønnøysund:e,drobak:e,"xn--drbak-wua":e,drøbak:e,egersund:e,fetsund:e,floro:e,"xn--flor-jra":e,florø:e,fredrikstad:e,hokksund:e,honefoss:e,"xn--hnefoss-q1a":e,hønefoss:e,jessheim:e,jorpeland:e,"xn--jrpeland-54a":e,jørpeland:e,kirkenes:e,kopervik:e,krokstadelva:e,langevag:e,"xn--langevg-jxa":e,langevåg:e,leirvik:e,mjondalen:e,"xn--mjndalen-64a":e,mjøndalen:e,"mo-i-rana":e,mosjoen:e,"xn--mosjen-eya":e,mosjøen:e,nesoddtangen:e,orkanger:e,osoyro:e,"xn--osyro-wua":e,osøyro:e,raholt:e,"xn--rholt-mra":e,råholt:e,sandnessjoen:e,"xn--sandnessjen-ogb":e,sandnessjøen:e,skedsmokorset:e,slattum:e,spjelkavik:e,stathelle:e,stavern:e,stjordalshalsen:e,"xn--stjrdalshalsen-sqb":e,stjørdalshalsen:e,tananger:e,tranby:e,vossevangen:e,afjord:e,"xn--fjord-lra":e,åfjord:e,agdenes:e,al:e,"xn--l-1fa":e,ål:e,alesund:e,"xn--lesund-hua":e,ålesund:e,alstahaug:e,alta:e,"xn--lt-liac":e,áltá:e,alaheadju:e,"xn-\
-laheadju-7ya":e,álaheadju:e,alvdal:e,amli:e,"xn--mli-tla":e,åmli:e,amot:e,"xn--mot-tla":e,åmot:e,andebu:e,andoy:e,"xn--andy-ira":e,andøy:e,andasuolo:e,ardal:e,"xn--rdal-poa":e,årdal:e,aremark:e,arendal:e,"xn--s-1fa":e,ås:e,aseral:e,"xn--seral-lra":e,åseral:e,asker:e,askim:e,askvoll:e,askoy:e,"xn--asky-ira":e,askøy:e,asnes:e,"xn--snes-poa":e,åsnes:e,audnedaln:e,aukra:e,aure:e,aurland:e,"aurskog-holand":e,"xn--aurskog-hland-jnb":e,"aurskog-høland":e,austevoll:e,austrheim:e,averoy:e,"xn--avery-yua":e,averøy:e,balestrand:e,ballangen:e,balat:e,"xn--blt-elab":e,bálát:e,balsfjord:e,bahccavuotna:e,"xn--bhccavuotna-k7a":e,báhccavuotna:e,bamble:e,bardu:e,beardu:e,beiarn:e,bajddar:e,"xn--bjddar-pta":e,bájddar:e,baidar:e,"xn--bidr-5nac":e,báidár:e,berg:e,bergen:e,berlevag:e,"xn--berlevg-jxa":e,berlevåg:e,bearalvahki:e,"xn--bearalvhki-y4a":e,bearalváhki:e,bindal:e,birkenes:e,bjarkoy:e,"xn--bjarky-fya":e,bjarkøy:e,bjerkreim:e,bjugn:e,bodo:e,"xn--bod-2na":e,bodø:e,badaddja:e,"xn\
--bdddj-mrabd":e,bådåddjå:e,budejju:e,bokn:e,bremanger:e,bronnoy:e,"xn--brnny-wuac":e,brønnøy:e,bygland:e,bykle:e,barum:e,"xn--brum-voa":e,bærum:e,telemark:[0,{bo:e,"xn--b-5ga":e,bø:e}],nordland:[0,{bo:e,"xn--b-5ga":e,bø:e,heroy:e,"xn--hery-ira":e,herøy:e}],bievat:e,"xn--bievt-0qa":e,bievát:e,bomlo:e,"xn--bmlo-gra":e,bømlo:e,batsfjord:e,"xn--btsfjord-9za":e,båtsfjord:e,bahcavuotna:e,"xn--bhcavuotna-s4a":e,báhcavuotna:e,dovre:e,drammen:e,drangedal:e,dyroy:e,"xn--dyry-ira":e,dyrøy:e,donna:e,"xn--dnna-gra":e,dønna:e,eid:e,eidfjord:e,eidsberg:e,eidskog:e,eidsvoll:e,eigersund:e,elverum:e,enebakk:e,engerdal:e,etne:e,etnedal:e,evenes:e,evenassi:e,"xn--eveni-0qa01ga":e,evenášši:e,"evje-og-hornnes":e,farsund:e,fauske:e,fuossko:e,fuoisku:e,fedje:e,fet:e,finnoy:e,"xn--finny-yua":e,finnøy:e,fitjar:e,fjaler:e,fjell:e,flakstad:e,flatanger:e,flekkefjord:e,flesberg:e,flora:e,fla:e,"xn--fl-zia":e,flå:e,folldal:e,forsand:e,fosnes:e,frei:e,frogn:e,froland:e,frosta:e,frana:e,"xn--frna-\
woa":e,fræna:e,froya:e,"xn--frya-hra":e,frøya:e,fusa:e,fyresdal:e,forde:e,"xn--frde-gra":e,førde:e,gamvik:e,gangaviika:e,"xn--ggaviika-8ya47h":e,gáŋgaviika:e,gaular:e,gausdal:e,gildeskal:e,"xn--gildeskl-g0a":e,gildeskål:e,giske:e,gjemnes:e,gjerdrum:e,gjerstad:e,gjesdal:e,gjovik:e,"xn--gjvik-wua":e,gjøvik:e,gloppen:e,gol:e,gran:e,grane:e,granvin:e,gratangen:e,grimstad:e,grong:e,kraanghke:e,"xn--kranghke-b0a":e,kråanghke:e,grue:e,gulen:e,hadsel:e,halden:e,halsa:e,hamar:e,hamaroy:e,habmer:e,"xn--hbmer-xqa":e,hábmer:e,hapmir:e,"xn--hpmir-xqa":e,hápmir:e,hammerfest:e,hammarfeasta:e,"xn--hmmrfeasta-s4ac":e,hámmárfeasta:e,haram:e,hareid:e,harstad:e,hasvik:e,aknoluokta:e,"xn--koluokta-7ya57h":e,ákŋoluokta:e,hattfjelldal:e,aarborte:e,haugesund:e,hemne:e,hemnes:e,hemsedal:e,"more-og-romsdal":[0,{heroy:e,sande:e}],"xn--mre-og-romsdal-qqb":[0,{"xn--hery-ira":e,sande:e}],"møre-og-romsdal":[0,{herøy:e,sande:e}],hitra:e,hjartdal:e,hjelmeland:e,hobol:e,"xn--hobl-ira":e,hobøl:e,hof:e,hol:e,
hole:e,holmestrand:e,holtalen:e,"xn--holtlen-hxa":e,holtålen:e,hornindal:e,horten:e,hurdal:e,hurum:e,hvaler:e,hyllestad:e,hagebostad:e,"xn--hgebostad-g3a":e,hægebostad:e,hoyanger:e,"xn--hyanger-q1a":e,høyanger:e,hoylandet:e,"xn--hylandet-54a":e,høylandet:e,ha:e,"xn--h-2fa":e,hå:e,ibestad:e,inderoy:e,"xn--indery-fya":e,inderøy:e,iveland:e,jevnaker:e,jondal:e,jolster:e,"xn--jlster-bya":e,jølster:e,karasjok:e,karasjohka:e,"xn--krjohka-hwab49j":e,kárášjohka:e,karlsoy:e,galsa:e,"xn--gls-elac":e,gálsá:e,karmoy:e,"xn--karmy-yua":e,karmøy:e,kautokeino:e,guovdageaidnu:e,klepp:e,klabu:e,"xn--klbu-woa":e,klæbu:e,kongsberg:e,kongsvinger:e,kragero:e,"xn--krager-gya":e,kragerø:e,kristiansand:e,kristiansund:e,krodsherad:e,"xn--krdsherad-m8a":e,krødsherad:e,kvalsund:e,rahkkeravju:e,"xn--rhkkervju-01af":e,ráhkkerávju:e,kvam:e,kvinesdal:e,kvinnherad:e,kviteseid:e,kvitsoy:e,"xn--kvitsy-fya":e,kvitsøy:e,kvafjord:e,"xn--kvfjord-nxa":e,kvæfjord:e,giehtavuoatna:e,kvanangen:e,"xn--kvnangen\
-k0a":e,kvænangen:e,navuotna:e,"xn--nvuotna-hwa":e,návuotna:e,kafjord:e,"xn--kfjord-iua":e,kåfjord:e,gaivuotna:e,"xn--givuotna-8ya":e,gáivuotna:e,larvik:e,lavangen:e,lavagis:e,loabat:e,"xn--loabt-0qa":e,loabát:e,lebesby:e,davvesiida:e,leikanger:e,leirfjord:e,leka:e,leksvik:e,lenvik:e,leangaviika:e,"xn--leagaviika-52b":e,leaŋgaviika:e,lesja:e,levanger:e,lier:e,lierne:e,lillehammer:e,lillesand:e,lindesnes:e,lindas:e,"xn--linds-pra":e,lindås:e,lom:e,loppa:e,lahppi:e,"xn--lhppi-xqa":e,láhppi:e,lund:e,lunner:e,luroy:e,"xn--lury-ira":e,lurøy:e,luster:e,lyngdal:e,lyngen:e,ivgu:e,lardal:e,lerdal:e,"xn--lrdal-sra":e,lærdal:e,lodingen:e,"xn--ldingen-q1a":e,lødingen:e,lorenskog:e,"xn--lrenskog-54a":e,lørenskog:e,loten:e,"xn--lten-gra":e,løten:e,malvik:e,masoy:e,"xn--msy-ula0h":e,måsøy:e,muosat:e,"xn--muost-0qa":e,muosát:e,mandal:e,marker:e,marnardal:e,masfjorden:e,meland:e,meldal:e,melhus:e,meloy:e,"xn--mely-ira":e,meløy:e,meraker:e,"xn--merker-kua":e,meråker:e,moareke:e,"xn--mo\
reke-jua":e,moåreke:e,midsund:e,"midtre-gauldal":e,modalen:e,modum:e,molde:e,moskenes:e,moss:e,mosvik:e,malselv:e,"xn--mlselv-iua":e,målselv:e,malatvuopmi:e,"xn--mlatvuopmi-s4a":e,málatvuopmi:e,namdalseid:e,aejrie:e,namsos:e,namsskogan:e,naamesjevuemie:e,"xn--nmesjevuemie-tcba":e,nååmesjevuemie:e,laakesvuemie:e,nannestad:e,narvik:e,narviika:e,naustdal:e,"nedre-eiker":e,akershus:h,buskerud:h,nesna:e,nesodden:e,nesseby:e,unjarga:e,"xn--unjrga-rta":e,unjárga:e,nesset:e,nissedal:e,nittedal:e,"nord-aurdal":e,"nord-fron":e,"nord-odal":e,norddal:e,nordkapp:e,davvenjarga:e,"xn--davvenjrga-y4a":e,davvenjárga:e,"nordre-land":e,nordreisa:e,raisa:e,"xn--risa-5na":e,ráisa:e,"nore-og-uvdal":e,notodden:e,naroy:e,"xn--nry-yla5g":e,nærøy:e,notteroy:e,"xn--nttery-byae":e,nøtterøy:e,odda:e,oksnes:e,"xn--ksnes-uua":e,øksnes:e,oppdal:e,oppegard:e,"xn--oppegrd-ixa":e,oppegård:e,orkdal:e,orland:e,"xn--rland-uua":e,ørland:e,orskog:e,"xn--rskog-uua":e,ørskog:e,orsta:e,"xn--rsta-fra":e,ørsta:e,
hedmark:[0,{os:e,valer:e,"xn--vler-qoa":e,våler:e}],hordaland:[0,{os:e}],osen:e,osteroy:e,"xn--ostery-fya":e,osterøy:e,"ostre-toten":e,"xn--stre-toten-zcb":e,"østre-toten":e,overhalla:e,"ovre-eiker":e,"xn--vre-eiker-k8a":e,"øvre-eiker":e,oyer:e,"xn--yer-zna":e,øyer:e,oygarden:e,"xn--ygarden-p1a":e,øygarden:e,"oystre-slidre":e,"xn--ystre-slidre-ujb":e,"øystre-slidre":e,porsanger:e,porsangu:e,"xn--porsgu-sta26f":e,porsáŋgu:e,porsgrunn:e,radoy:e,"xn--rady-ira":e,radøy:e,rakkestad:e,rana:e,ruovat:e,randaberg:e,rauma:e,rendalen:e,rennebu:e,rennesoy:e,"xn--rennesy-v1a":e,rennesøy:e,rindal:e,ringebu:e,ringerike:e,ringsaker:e,rissa:e,risor:e,"xn--risr-ira":e,risør:e,roan:e,rollag:e,rygge:e,ralingen:e,"xn--rlingen-mxa":e,rælingen:e,rodoy:e,"xn--rdy-0nab":e,rødøy:e,romskog:e,"xn--rmskog-bya":e,rømskog:e,roros:e,"xn--rros-gra":e,røros:e,rost:e,"xn--rst-0na":e,røst:e,royken:e,"xn--ryken-vua":e,røyken:e,royrvik:e,"xn--ryrvik-bya":e,røyrvik:e,rade:e,"xn--rde-ula":e,råde:e,salangen:e,
siellak:e,saltdal:e,salat:e,"xn--slt-elab":e,sálát:e,"xn--slat-5na":e,sálat:e,samnanger:e,vestfold:[0,{sande:e}],sandefjord:e,sandnes:e,sandoy:e,"xn--sandy-yua":e,sandøy:e,sarpsborg:e,sauda:e,sauherad:e,sel:e,selbu:e,selje:e,seljord:e,sigdal:e,siljan:e,sirdal:e,skaun:e,skedsmo:e,ski:e,skien:e,skiptvet:e,skjervoy:e,"xn--skjervy-v1a":e,skjervøy:e,skierva:e,"xn--skierv-uta":e,skiervá:e,skjak:e,"xn--skjk-soa":e,skjåk:e,skodje:e,skanland:e,"xn--sknland-fxa":e,skånland:e,skanit:e,"xn--sknit-yqa":e,skánit:e,smola:e,"xn--smla-hra":e,smøla:e,snillfjord:e,snasa:e,"xn--snsa-roa":e,snåsa:e,snoasa:e,snaase:e,"xn--snase-nra":e,snåase:e,sogndal:e,sokndal:e,sola:e,solund:e,songdalen:e,sortland:e,spydeberg:e,stange:e,stavanger:e,steigen:e,steinkjer:e,stjordal:e,"xn--stjrdal-s1a":e,stjørdal:e,stokke:e,"stor-elvdal":e,stord:e,stordal:e,storfjord:e,omasvuotna:e,strand:e,stranda:e,stryn:e,sula:e,suldal:e,sund:e,sunndal:e,surnadal:e,sveio:e,svelvik:e,sykkylven:e,sogne:e,"xn--sgne-gra":e,søgne:e,
somna:e,"xn--smna-gra":e,sømna:e,"sondre-land":e,"xn--sndre-land-0cb":e,"søndre-land":e,"sor-aurdal":e,"xn--sr-aurdal-l8a":e,"sør-aurdal":e,"sor-fron":e,"xn--sr-fron-q1a":e,"sør-fron":e,"sor-odal":e,"xn--sr-odal-q1a":e,"sør-odal":e,"sor-varanger":e,"xn--sr-varanger-ggb":e,"sør-varanger":e,"matta-varjjat":e,"xn--mtta-vrjjat-k7af":e,"mátta-várjjat":e,sorfold:e,"xn--srfold-bya":e,sørfold:e,sorreisa:e,"xn--srreisa-q1a":e,sørreisa:e,sorum:e,"xn--srum-gra":e,sørum:e,tana:e,deatnu:e,time:e,tingvoll:e,tinn:e,tjeldsund:e,dielddanuorri:e,tjome:e,"xn--tjme-hra":e,tjøme:e,tokke:e,tolga:e,torsken:e,tranoy:e,"xn--trany-yua":e,tranøy:e,tromso:e,"xn--troms-zua":e,tromsø:e,tromsa:e,romsa:e,trondheim:e,troandin:e,trysil:e,trana:e,"xn--trna-woa":e,træna:e,trogstad:e,"xn--trgstad-r1a":e,trøgstad:e,tvedestrand:e,tydal:e,tynset:e,tysfjord:e,divtasvuodna:e,divttasvuotna:e,tysnes:e,tysvar:e,"xn--tysvr-vra":e,tysvær:e,tonsberg:e,"xn--tnsberg-q1a":e,tønsberg:e,ullensaker:e,ullensvang:e,ulvik:e,
utsira:e,vadso:e,"xn--vads-jra":e,vadsø:e,cahcesuolo:e,"xn--hcesuolo-7ya35b":e,čáhcesuolo:e,vaksdal:e,valle:e,vang:e,vanylven:e,vardo:e,"xn--vard-jra":e,vardø:e,varggat:e,"xn--vrggt-xqad":e,várggát:e,vefsn:e,vaapste:e,vega:e,vegarshei:e,"xn--vegrshei-c0a":e,vegårshei:e,vennesla:e,verdal:e,verran:e,vestby:e,vestnes:e,"vestre-slidre":e,"vestre-toten":e,vestvagoy:e,"xn--vestvgy-ixa6o":e,vestvågøy:e,vevelstad:e,vik:e,vikna:e,vindafjord:e,volda:e,voss:e,varoy:e,"xn--vry-yla5g":e,værøy:e,vagan:e,"xn--vgan-qoa":e,vågan:e,voagat:e,vagsoy:e,"xn--vgsy-qoa0j":e,vågsøy:e,vaga:e,"xn--vg-yiab":e,vågå:e,ostfold:[0,{valer:e}],"xn--stfold-9xa":[0,{"xn--vler-qoa":e}],østfold:[0,{våler:e}]}],np:i,nr:m,nu:e,nz:[1,{ac:e,co:e,cri:e,geek:e,gen:e,govt:e,health:e,iwi:e,kiwi:e,maori:e,mil:e,"xn--mori-qsa":e,māori:e,net:e,org:e,parliament:e,school:e}],om:[1,{co:e,com:e,edu:e,gov:e,med:e,museum:e,net:e,org:e,pro:e}],onion:e,org:e,pa:[1,{ac:e,gob:e,com:e,org:e,sld:e,edu:e,net:e,ing:e,abo:e,med:e,
nom:e}],pe:[1,{edu:e,gob:e,nom:e,mil:e,org:e,com:e,net:e}],pf:[1,{com:e,org:e,edu:e}],pg:i,ph:[1,{com:e,net:e,org:e,gov:e,edu:e,ngo:e,mil:e,i:e}],pk:[1,{com:e,net:e,edu:e,org:e,fam:e,biz:e,web:e,gov:e,gob:e,gok:e,gon:e,gop:e,gos:e,info:e}],pl:[1,{com:e,net:e,org:e,aid:e,agro:e,atm:e,auto:e,biz:e,edu:e,gmina:e,gsm:e,info:e,mail:e,miasta:e,media:e,mil:e,nieruchomosci:e,nom:e,pc:e,powiat:e,priv:e,realestate:e,rel:e,sex:e,shop:e,sklep:e,sos:e,szkola:e,targi:e,tm:e,tourism:e,travel:e,turystyka:e,gov:[1,{ap:e,griw:e,ic:e,is:e,kmpsp:e,konsulat:e,kppsp:e,kwp:e,kwpsp:e,mup:e,mw:e,oia:e,oirm:e,oke:e,oow:e,oschr:e,oum:e,pa:e,pinb:e,piw:e,po:e,pr:e,psp:e,psse:e,pup:e,rzgw:e,sa:e,sdn:e,sko:e,so:e,sr:e,starostwo:e,ug:e,ugim:e,um:e,umig:e,upow:e,uppo:e,us:e,uw:e,uzs:e,wif:e,wiih:e,winb:e,wios:e,witd:e,wiw:e,wkz:e,wsa:e,wskr:e,wsse:e,wuoz:e,wzmiuw:e,zp:e,zpisdn:e}],augustow:e,"babia-gora":e,bedzin:e,beskidy:e,bialowieza:e,bialystok:e,bielawa:e,bieszczady:e,boleslawiec:e,bydgoszcz:e,bytom:e,cieszyn:e,czeladz:e,
czest:e,dlugoleka:e,elblag:e,elk:e,glogow:e,gniezno:e,gorlice:e,grajewo:e,ilawa:e,jaworzno:e,"jelenia-gora":e,jgora:e,kalisz:e,"kazimierz-dolny":e,karpacz:e,kartuzy:e,kaszuby:e,katowice:e,kepno:e,ketrzyn:e,klodzko:e,kobierzyce:e,kolobrzeg:e,konin:e,konskowola:e,kutno:e,lapy:e,lebork:e,legnica:e,lezajsk:e,limanowa:e,lomza:e,lowicz:e,lubin:e,lukow:e,malbork:e,malopolska:e,mazowsze:e,mazury:e,mielec:e,mielno:e,mragowo:e,naklo:e,nowaruda:e,nysa:e,olawa:e,olecko:e,olkusz:e,olsztyn:e,opoczno:e,opole:e,ostroda:e,ostroleka:e,ostrowiec:e,ostrowwlkp:e,pila:e,pisz:e,podhale:e,podlasie:e,polkowice:e,pomorze:e,pomorskie:e,prochowice:e,pruszkow:e,przeworsk:e,pulawy:e,radom:e,"rawa-maz":e,rybnik:e,rzeszow:e,sanok:e,sejny:e,slask:e,slupsk:e,sosnowiec:e,"stalowa-wola":e,skoczow:e,starachowice:e,stargard:e,suwalki:e,swidnica:e,swiebodzin:e,swinoujscie:e,szczecin:e,szczytno:e,tarnobrzeg:e,tgory:e,turek:e,tychy:e,ustka:e,walbrzych:e,warmia:e,warszawa:e,waw:e,wegrow:e,wielun:e,wlocl:e,wloclawek:e,wodzislaw:e,
wolomin:e,wroclaw:e,zachpomor:e,zagan:e,zarow:e,zgora:e,zgorzelec:e}],pm:e,pn:[1,{gov:e,co:e,org:e,edu:e,net:e}],post:e,pr:[1,{com:e,net:e,org:e,gov:e,edu:e,isla:e,pro:e,biz:e,info:e,name:e,est:e,prof:e,ac:e}],pro:[1,{aaa:e,aca:e,acct:e,avocat:e,bar:e,cpa:e,eng:e,jur:e,law:e,med:e,recht:e}],ps:[1,{edu:e,gov:e,sec:e,plo:e,com:e,org:e,net:e}],pt:[1,{net:e,gov:e,org:e,edu:e,int:e,publ:e,com:e,nome:e}],pw:[1,{co:e,ne:e,or:e,ed:e,go:e,belau:e}],py:[1,{com:e,coop:e,edu:e,gov:e,mil:e,net:e,org:e}],qa:l,re:[1,{asso:e,com:e,nom:e}],ro:[1,{arts:e,com:e,firm:e,info:e,nom:e,nt:e,org:e,rec:e,store:e,tm:e,www:e}],rs:[1,{ac:e,co:e,edu:e,gov:e,in:e,org:e}],ru:e,rw:[1,{ac:e,co:e,coop:e,gov:e,mil:e,net:e,org:e}],sa:[1,{com:e,net:e,org:e,gov:e,med:e,pub:e,edu:e,sch:e}],sb:n,sc:n,sd:[1,{com:e,net:e,org:e,edu:e,med:e,tv:e,gov:e,info:e}],se:[1,{a:e,ac:e,b:e,bd:e,brand:e,c:e,d:e,e,f:e,fh:e,fhsk:e,fhv:e,g:e,h:e,i:e,k:e,komforb:e,kommunalforbund:e,komvux:e,l:e,lanbib:e,m:e,n:e,naturbruksgymn:e,o:e,org:e,p:e,parti:e,
pp:e,press:e,r:e,s:e,t:e,tm:e,u:e,w:e,x:e,y:e,z:e}],sg:[1,{com:e,net:e,org:e,gov:e,edu:e,per:e}],sh:[1,{com:e,net:e,gov:e,org:e,mil:e}],si:e,sj:e,sk:e,sl:n,sm:e,sn:[1,{art:e,com:e,edu:e,gouv:e,org:e,perso:e,univ:e}],so:[1,{com:e,edu:e,gov:e,me:e,net:e,org:e}],sr:e,ss:[1,{biz:e,com:e,edu:e,gov:e,me:e,net:e,org:e,sch:e}],st:[1,{co:e,com:e,consulado:e,edu:e,embaixada:e,mil:e,net:e,org:e,principe:e,saotome:e,store:e}],su:e,sv:[1,{com:e,edu:e,gob:e,org:e,red:e}],sx:r,sy:t,sz:[1,{co:e,ac:e,org:e}],tc:e,td:e,tel:e,tf:e,tg:e,th:[1,{ac:e,co:e,go:e,in:e,mi:e,net:e,or:e}],tj:[1,{ac:e,biz:e,co:e,com:e,edu:e,go:e,gov:e,int:e,mil:e,name:e,net:e,nic:e,org:e,test:e,web:e}],tk:e,tl:r,tm:[1,{com:e,co:e,org:e,net:e,nom:e,gov:e,mil:e,edu:e}],tn:[1,{com:e,ens:e,fin:e,gov:e,ind:e,info:e,intl:e,mincom:e,nat:e,net:e,org:e,perso:e,tourism:e}],to:t,tr:[1,{av:e,bbs:e,bel:e,biz:e,com:e,dr:e,edu:e,gen:e,gov:e,info:e,mil:e,k12:e,kep:e,name:e,net:e,org:e,pol:e,tel:e,tsk:e,tv:e,web:e,nc:r}],tt:[1,{co:e,com:e,org:e,net:e,
biz:e,info:e,pro:e,int:e,coop:e,jobs:e,mobi:e,travel:e,museum:e,aero:e,name:e,gov:e,edu:e}],tv:e,tw:[1,{edu:e,gov:e,mil:e,com:e,net:e,org:e,idv:e,game:e,ebiz:e,club:e,"xn--zf0ao64a":e,網路:e,"xn--uc0atv":e,組織:e,"xn--czrw28b":e,商業:e}],tz:[1,{ac:e,co:e,go:e,hotel:e,info:e,me:e,mil:e,mobi:e,ne:e,or:e,sc:e,tv:e}],ua:[1,{com:e,edu:e,gov:e,in:e,net:e,org:e,cherkassy:e,cherkasy:e,chernigov:e,chernihiv:e,chernivtsi:e,chernovtsy:e,ck:e,cn:e,cr:e,crimea:e,cv:e,dn:e,dnepropetrovsk:e,dnipropetrovsk:e,donetsk:e,dp:e,if:e,"ivano-frankivsk":e,kh:e,kharkiv:e,kharkov:e,kherson:e,khmelnitskiy:e,khmelnytskyi:e,kiev:e,kirovograd:e,km:e,kr:e,kropyvnytskyi:e,krym:e,ks:e,kv:e,kyiv:e,lg:e,lt:e,lugansk:e,luhansk:e,lutsk:e,lv:e,lviv:e,mk:e,mykolaiv:e,nikolaev:e,od:e,odesa:e,odessa:e,pl:e,poltava:e,rivne:e,rovno:e,rv:e,sb:e,sebastopol:e,sevastopol:e,sm:e,sumy:e,te:e,ternopil:e,uz:e,uzhgorod:e,uzhhorod:e,vinnica:e,vinnytsia:e,vn:e,volyn:e,yalta:e,zakarpattia:e,zaporizhzhe:e,zaporizhzhia:e,zhitomir:e,zhytomyr:e,
zp:e,zt:e}],ug:[1,{co:e,or:e,ac:e,sc:e,go:e,ne:e,com:e,org:e}],uk:[1,{ac:e,co:e,gov:e,ltd:e,me:e,net:e,nhs:e,org:e,plc:e,police:e,sch:i}],us:[1,{dni:e,fed:e,isa:e,kids:e,nsn:e,ak:f,al:f,ar:f,as:f,az:f,ca:f,co:f,ct:f,dc:f,de:g,fl:f,ga:f,gu:f,hi:b,ia:f,id:f,il:f,in:f,ks:f,ky:f,la:f,ma:[1,{k12:[1,{pvt:e,chtr:e,paroch:e}],cc:e,lib:e}],md:f,me:f,mi:[1,{k12:e,cc:e,lib:e,"ann-arbor":e,cog:e,dst:e,eaton:e,gen:e,mus:e,tec:e,washtenaw:e}],mn:f,mo:f,ms:f,mt:f,nc:f,nd:b,ne:f,nh:f,nj:f,nm:f,nv:f,ny:f,oh:f,ok:f,or:f,pa:f,pr:f,ri:b,sc:f,sd:b,tn:f,tx:f,ut:f,vi:f,vt:f,va:f,wa:f,wi:f,wv:g,wy:f}],uy:[1,{com:e,edu:e,gub:e,mil:e,net:e,org:e}],uz:[1,{co:e,com:e,net:e,org:e}],va:e,vc:t,ve:[1,{arts:e,bib:e,co:e,com:e,e12:e,edu:e,firm:e,gob:e,gov:e,info:e,int:e,mil:e,net:e,nom:e,org:e,rar:e,rec:e,store:e,tec:e,web:e}],vg:e,vi:[1,{co:e,com:e,k12:e,net:e,org:e}],vn:[1,{ac:e,ai:e,biz:e,com:e,edu:e,gov:e,health:e,id:e,info:e,int:e,io:e,name:e,net:e,org:e,pro:e,angiang:e,bacgiang:e,backan:e,baclieu:e,bacninh:e,"bar\
ia-vungtau":e,bentre:e,binhdinh:e,binhduong:e,binhphuoc:e,binhthuan:e,camau:e,cantho:e,caobang:e,daklak:e,daknong:e,danang:e,dienbien:e,dongnai:e,dongthap:e,gialai:e,hagiang:e,haiduong:e,haiphong:e,hanam:e,hanoi:e,hatinh:e,haugiang:e,hoabinh:e,hungyen:e,khanhhoa:e,kiengiang:e,kontum:e,laichau:e,lamdong:e,langson:e,laocai:e,longan:e,namdinh:e,nghean:e,ninhbinh:e,ninhthuan:e,phutho:e,phuyen:e,quangbinh:e,quangnam:e,quangngai:e,quangninh:e,quangtri:e,soctrang:e,sonla:e,tayninh:e,thaibinh:e,thainguyen:e,thanhhoa:e,thanhphohochiminh:e,thuathienhue:e,tiengiang:e,travinh:e,tuyenquang:e,vinhlong:e,vinhphuc:e,yenbai:e}],vu:o,wf:e,ws:n,yt:e,"xn--mgbaam7a8h":e,امارات:e,"xn--y9a3aq":e,հայ:e,"xn--54b7fta0cc":e,বাংলা:e,"xn--90ae":e,бг:e,"xn--mgbcpq6gpa1a":e,البحرين:e,"xn--90ais":e,бел:e,"xn--fiqs8s":e,中国:e,"xn--fiqz9s":e,中國:e,"xn--lgbbat1ad8j":e,الجزائر:e,"xn--wgbh1c":e,مصر:e,"xn--e1a4c":e,ею:e,"xn--qxa6a":e,ευ:e,"xn--mgbah1a3hjkrd":e,موريتانيا:e,
"xn--node":e,გე:e,"xn--qxam":e,ελ:e,"xn--j6w193g":[1,{"xn--55qx5d":e,"xn--wcvs22d":e,"xn--mxtq1m":e,"xn--gmqw5a":e,"xn--od0alg":e,"xn--uc0atv":e}],香港:[1,{公司:e,教育:e,政府:e,個人:e,網絡:e,組織:e}],"xn--2scrj9c":e,ಭಾರತ:e,"xn--3hcrj9c":e,ଭାରତ:e,"xn--45br5cyl":e,ভাৰত:e,"xn--h2breg3eve":e,भारतम्:e,"xn--h2brj9c8c":e,भारोत:e,"xn--mgbgu82a":e,ڀارت:e,"xn--rvc1e0am3e":e,ഭാരതം:e,"xn--h2brj9c":e,भारत:e,"xn--mgbbh1a":e,بارت:e,"xn--mgbbh1a71e":e,بھارت:e,"xn--fpcrj9c3d":e,భారత్:e,"xn--gecrj9c":e,ભારત:e,"xn--s9brj9c":e,ਭਾਰਤ:e,"xn--45brj9c":e,ভারত:e,"xn--xkc2dl3a5ee0h":e,இந்தியா:e,"xn--mgba3a4f16a":e,ایران:e,"xn--mgba3a4fra":e,ايران:e,"xn--mgbtx2b":e,عراق:e,"xn--mgbayh7gpa":e,الاردن:e,"xn--3e0b707e":e,한국:e,"xn--80ao21a":e,қаз:e,"xn--q7ce6a":e,ລາວ:e,"xn--fzc2c9e2c":e,ලංකා:e,"xn--xkc2al3hye2a":e,இலங்கை:e,"\
xn--mgbc0a9azcg":e,المغرب:e,"xn--d1alf":e,мкд:e,"xn--l1acc":e,мон:e,"xn--mix891f":e,澳門:e,"xn--mix082f":e,澳门:e,"xn--mgbx4cd0ab":e,مليسيا:e,"xn--mgb9awbf":e,عمان:e,"xn--mgbai9azgqp6j":e,پاکستان:e,"xn--mgbai9a5eva00b":e,پاكستان:e,"xn--ygbi2ammx":e,فلسطين:e,"xn--90a3ac":[1,{"xn--o1ac":e,"xn--c1avg":e,"xn--90azh":e,"xn--d1at":e,"xn--o1ach":e,"xn--80au":e}],срб:[1,{пр:e,орг:e,обр:e,од:e,упр:e,ак:e}],"xn--p1ai":e,рф:e,"xn--wgbl6a":e,قطر:e,"xn--mgberp4a5d4ar":e,السعودية:e,"xn--mgberp4a5d4a87g":e,السعودیة:e,"xn--mgbqly7c0a67fbc":e,السعودیۃ:e,"xn--mgbqly7cvafr":e,السعوديه:e,"xn--mgbpl2fh":e,سودان:e,"xn--yfro4i67o":e,新加坡:e,"xn--clchc0ea0b2g2a9gcd":e,சிங்கப்பூர்:e,"xn--ogbpf8fl":e,سورية:e,"xn--mgbtf8fl":e,سوريا:e,"xn--o3cw4h":[1,{"xn--12c1fe0br":e,"xn--12co0c3b4eva":e,"xn--h3cuzk1di":e,"xn--o3cyx2a":e,"xn--m3ch0j3a":e,"xn--12cfi8ixb8l":e}],ไทย:[1,
{ศึกษา:e,ธุรกิจ:e,รัฐบาล:e,ทหาร:e,เน็ต:e,องค์กร:e}],"xn--pgbs0dh":e,تونس:e,"xn--kpry57d":e,台灣:e,"xn--kprw13d":e,台湾:e,"xn--nnx388a":e,臺灣:e,"xn--j1amh":e,укр:e,"xn--mgb2ddes":e,اليمن:e,xxx:e,ye:t,za:[0,{ac:e,agric:e,alt:e,co:e,edu:e,gov:e,grondar:e,law:e,mil:e,net:e,ngo:e,nic:e,nis:e,nom:e,org:e,school:e,tm:e,web:e}],zm:[1,{ac:e,biz:e,co:e,com:e,edu:e,gov:e,info:e,mil:e,net:e,org:e,sch:e}],zw:[1,{ac:e,co:e,gov:e,mil:e,org:e}],aaa:e,aarp:e,abb:e,abbott:e,abbvie:e,abc:e,able:e,abogado:e,abudhabi:e,academy:e,accenture:e,accountant:e,accountants:e,aco:e,actor:e,ads:e,adult:e,aeg:e,aetna:e,afl:e,africa:e,agakhan:e,agency:e,aig:e,airbus:e,airforce:e,airtel:e,akdn:e,alibaba:e,alipay:e,allfinanz:e,allstate:e,ally:e,alsace:e,alstom:e,amazon:e,americanexpress:e,americanfamily:e,amex:e,amfam:e,amica:e,amsterdam:e,analytics:e,android:e,anquan:e,anz:e,aol:e,apartments:e,app:e,apple:e,aquarelle:e,arab:e,aramco:e,archi:e,
army:e,art:e,arte:e,asda:e,associates:e,athleta:e,attorney:e,auction:e,audi:e,audible:e,audio:e,auspost:e,author:e,auto:e,autos:e,avianca:e,aws:e,axa:e,azure:e,baby:e,baidu:e,banamex:e,bananarepublic:e,band:e,bank:e,bar:e,barcelona:e,barclaycard:e,barclays:e,barefoot:e,bargains:e,baseball:e,basketball:e,bauhaus:e,bayern:e,bbc:e,bbt:e,bbva:e,bcg:e,bcn:e,beats:e,beauty:e,beer:e,bentley:e,berlin:e,best:e,bestbuy:e,bet:e,bharti:e,bible:e,bid:e,bike:e,bing:e,bingo:e,bio:e,black:e,blackfriday:e,blockbuster:e,blog:e,bloomberg:e,blue:e,bms:e,bmw:e,bnpparibas:e,boats:e,boehringer:e,bofa:e,bom:e,bond:e,boo:e,book:e,booking:e,bosch:e,bostik:e,boston:e,bot:e,boutique:e,box:e,bradesco:e,bridgestone:e,broadway:e,broker:e,brother:e,brussels:e,build:e,builders:e,business:e,buy:e,buzz:e,bzh:e,cab:e,cafe:e,cal:e,call:e,calvinklein:e,cam:e,camera:e,camp:e,canon:e,capetown:e,capital:e,capitalone:e,car:e,caravan:e,cards:e,care:e,career:e,careers:e,cars:e,casa:e,case:e,cash:e,casino:e,catering:e,catholic:e,
cba:e,cbn:e,cbre:e,center:e,ceo:e,cern:e,cfa:e,cfd:e,chanel:e,channel:e,charity:e,chase:e,chat:e,cheap:e,chintai:e,christmas:e,chrome:e,church:e,cipriani:e,circle:e,cisco:e,citadel:e,citi:e,citic:e,city:e,claims:e,cleaning:e,click:e,clinic:e,clinique:e,clothing:e,cloud:e,club:e,clubmed:e,coach:e,codes:e,coffee:e,college:e,cologne:e,comcast:e,commbank:e,community:e,company:e,compare:e,computer:e,comsec:e,condos:e,construction:e,consulting:e,contact:e,contractors:e,cooking:e,cool:e,corsica:e,country:e,coupon:e,coupons:e,courses:e,cpa:e,credit:e,creditcard:e,creditunion:e,cricket:e,crown:e,crs:e,cruise:e,cruises:e,cuisinella:e,cymru:e,cyou:e,dabur:e,dad:e,dance:e,data:e,date:e,dating:e,datsun:e,day:e,dclk:e,dds:e,deal:e,dealer:e,deals:e,degree:e,delivery:e,dell:e,deloitte:e,delta:e,democrat:e,dental:e,dentist:e,desi:e,design:e,dev:e,dhl:e,diamonds:e,diet:e,digital:e,direct:e,directory:e,discount:e,discover:e,dish:e,diy:e,dnp:e,docs:e,doctor:e,dog:e,domains:e,dot:e,download:e,drive:e,dtv:e,
dubai:e,dunlop:e,dupont:e,durban:e,dvag:e,dvr:e,earth:e,eat:e,eco:e,edeka:e,education:e,email:e,emerck:e,energy:e,engineer:e,engineering:e,enterprises:e,epson:e,equipment:e,ericsson:e,erni:e,esq:e,estate:e,eurovision:e,eus:e,events:e,exchange:e,expert:e,exposed:e,express:e,extraspace:e,fage:e,fail:e,fairwinds:e,faith:e,family:e,fan:e,fans:e,farm:e,farmers:e,fashion:e,fast:e,fedex:e,feedback:e,ferrari:e,ferrero:e,fidelity:e,fido:e,film:e,final:e,finance:e,financial:e,fire:e,firestone:e,firmdale:e,fish:e,fishing:e,fit:e,fitness:e,flickr:e,flights:e,flir:e,florist:e,flowers:e,fly:e,foo:e,food:e,football:e,ford:e,forex:e,forsale:e,forum:e,foundation:e,fox:e,free:e,fresenius:e,frl:e,frogans:e,frontier:e,ftr:e,fujitsu:e,fun:e,fund:e,furniture:e,futbol:e,fyi:e,gal:e,gallery:e,gallo:e,gallup:e,game:e,games:e,gap:e,garden:e,gay:e,gbiz:e,gdn:e,gea:e,gent:e,genting:e,george:e,ggee:e,gift:e,gifts:e,gives:e,giving:e,glass:e,gle:e,global:e,globo:e,gmail:e,gmbh:e,gmo:e,gmx:e,godaddy:e,gold:e,goldpoint:e,
golf:e,goo:e,goodyear:e,goog:e,google:e,gop:e,got:e,grainger:e,graphics:e,gratis:e,green:e,gripe:e,grocery:e,group:e,guardian:e,gucci:e,guge:e,guide:e,guitars:e,guru:e,hair:e,hamburg:e,hangout:e,haus:e,hbo:e,hdfc:e,hdfcbank:e,health:e,healthcare:e,help:e,helsinki:e,here:e,hermes:e,hiphop:e,hisamitsu:e,hitachi:e,hiv:e,hkt:e,hockey:e,holdings:e,holiday:e,homedepot:e,homegoods:e,homes:e,homesense:e,honda:e,horse:e,hospital:e,host:e,hosting:e,hot:e,hotels:e,hotmail:e,house:e,how:e,hsbc:e,hughes:e,hyatt:e,hyundai:e,ibm:e,icbc:e,ice:e,icu:e,ieee:e,ifm:e,ikano:e,imamat:e,imdb:e,immo:e,immobilien:e,inc:e,industries:e,infiniti:e,ing:e,ink:e,institute:e,insurance:e,insure:e,international:e,intuit:e,investments:e,ipiranga:e,irish:e,ismaili:e,ist:e,istanbul:e,itau:e,itv:e,jaguar:e,java:e,jcb:e,jeep:e,jetzt:e,jewelry:e,jio:e,jll:e,jmp:e,jnj:e,joburg:e,jot:e,joy:e,jpmorgan:e,jprs:e,juegos:e,juniper:e,kaufen:e,kddi:e,kerryhotels:e,kerrylogistics:e,kerryproperties:e,kfh:e,kia:e,kids:e,kim:e,kindle:e,kitchen:e,
kiwi:e,koeln:e,komatsu:e,kosher:e,kpmg:e,kpn:e,krd:e,kred:e,kuokgroup:e,kyoto:e,lacaixa:e,lamborghini:e,lamer:e,lancaster:e,land:e,landrover:e,lanxess:e,lasalle:e,lat:e,latino:e,latrobe:e,law:e,lawyer:e,lds:e,lease:e,leclerc:e,lefrak:e,legal:e,lego:e,lexus:e,lgbt:e,lidl:e,life:e,lifeinsurance:e,lifestyle:e,lighting:e,like:e,lilly:e,limited:e,limo:e,lincoln:e,link:e,lipsy:e,live:e,living:e,llc:e,llp:e,loan:e,loans:e,locker:e,locus:e,lol:e,london:e,lotte:e,lotto:e,love:e,lpl:e,lplfinancial:e,ltd:e,ltda:e,lundbeck:e,luxe:e,luxury:e,madrid:e,maif:e,maison:e,makeup:e,man:e,management:e,mango:e,map:e,market:e,marketing:e,markets:e,marriott:e,marshalls:e,mattel:e,mba:e,mckinsey:e,med:e,media:e,meet:e,melbourne:e,meme:e,memorial:e,men:e,menu:e,merckmsd:e,miami:e,microsoft:e,mini:e,mint:e,mit:e,mitsubishi:e,mlb:e,mls:e,mma:e,mobile:e,moda:e,moe:e,moi:e,mom:e,monash:e,money:e,monster:e,mormon:e,mortgage:e,moscow:e,moto:e,motorcycles:e,mov:e,movie:e,msd:e,mtn:e,mtr:e,music:e,nab:e,nagoya:e,natura:e,
navy:e,nba:e,nec:e,netbank:e,netflix:e,network:e,neustar:e,new:e,news:e,next:e,nextdirect:e,nexus:e,nfl:e,ngo:e,nhk:e,nico:e,nike:e,nikon:e,ninja:e,nissan:e,nissay:e,nokia:e,norton:e,now:e,nowruz:e,nowtv:e,nra:e,nrw:e,ntt:e,nyc:e,obi:e,observer:e,office:e,okinawa:e,olayan:e,olayangroup:e,oldnavy:e,ollo:e,omega:e,one:e,ong:e,onl:e,online:e,ooo:e,open:e,oracle:e,orange:e,organic:e,origins:e,osaka:e,otsuka:e,ott:e,ovh:e,page:e,panasonic:e,paris:e,pars:e,partners:e,parts:e,party:e,pay:e,pccw:e,pet:e,pfizer:e,pharmacy:e,phd:e,philips:e,phone:e,photo:e,photography:e,photos:e,physio:e,pics:e,pictet:e,pictures:e,pid:e,pin:e,ping:e,pink:e,pioneer:e,pizza:e,place:e,play:e,playstation:e,plumbing:e,plus:e,pnc:e,pohl:e,poker:e,politie:e,porn:e,pramerica:e,praxi:e,press:e,prime:e,prod:e,productions:e,prof:e,progressive:e,promo:e,properties:e,property:e,protection:e,pru:e,prudential:e,pub:e,pwc:e,qpon:e,quebec:e,quest:e,racing:e,radio:e,read:e,realestate:e,realtor:e,realty:e,recipes:e,red:e,redstone:e,
redumbrella:e,rehab:e,reise:e,reisen:e,reit:e,reliance:e,ren:e,rent:e,rentals:e,repair:e,report:e,republican:e,rest:e,restaurant:e,review:e,reviews:e,rexroth:e,rich:e,richardli:e,ricoh:e,ril:e,rio:e,rip:e,rocks:e,rodeo:e,rogers:e,room:e,rsvp:e,rugby:e,ruhr:e,run:e,rwe:e,ryukyu:e,saarland:e,safe:e,safety:e,sakura:e,sale:e,salon:e,samsclub:e,samsung:e,sandvik:e,sandvikcoromant:e,sanofi:e,sap:e,sarl:e,sas:e,save:e,saxo:e,sbi:e,sbs:e,sca:e,scb:e,schaeffler:e,schmidt:e,scholarships:e,school:e,schule:e,schwarz:e,science:e,scot:e,search:e,seat:e,secure:e,security:e,seek:e,select:e,sener:e,services:e,seven:e,sew:e,sex:e,sexy:e,sfr:e,shangrila:e,sharp:e,shaw:e,shell:e,shia:e,shiksha:e,shoes:e,shop:e,shopping:e,shouji:e,show:e,silk:e,sina:e,singles:e,site:e,ski:e,skin:e,sky:e,skype:e,sling:e,smart:e,smile:e,sncf:e,soccer:e,social:e,softbank:e,software:e,sohu:e,solar:e,solutions:e,song:e,sony:e,soy:e,spa:e,space:e,sport:e,spot:e,srl:e,stada:e,staples:e,star:e,statebank:e,statefarm:e,stc:e,stcgroup:e,
stockholm:e,storage:e,store:e,stream:e,studio:e,study:e,style:e,sucks:e,supplies:e,supply:e,support:e,surf:e,surgery:e,suzuki:e,swatch:e,swiss:e,sydney:e,systems:e,tab:e,taipei:e,talk:e,taobao:e,target:e,tatamotors:e,tatar:e,tattoo:e,tax:e,taxi:e,tci:e,tdk:e,team:e,tech:e,technology:e,temasek:e,tennis:e,teva:e,thd:e,theater:e,theatre:e,tiaa:e,tickets:e,tienda:e,tips:e,tires:e,tirol:e,tjmaxx:e,tjx:e,tkmaxx:e,tmall:e,today:e,tokyo:e,tools:e,top:e,toray:e,toshiba:e,total:e,tours:e,town:e,toyota:e,toys:e,trade:e,trading:e,training:e,travel:e,travelers:e,travelersinsurance:e,trust:e,trv:e,tube:e,tui:e,tunes:e,tushu:e,tvs:e,ubank:e,ubs:e,unicom:e,university:e,uno:e,uol:e,ups:e,vacations:e,vana:e,vanguard:e,vegas:e,ventures:e,verisign:e,versicherung:e,vet:e,viajes:e,video:e,vig:e,viking:e,villas:e,vin:e,vip:e,virgin:e,visa:e,vision:e,viva:e,vivo:e,vlaanderen:e,vodka:e,volvo:e,vote:e,voting:e,voto:e,voyage:e,wales:e,walmart:e,walter:e,wang:e,wanggou:e,watch:e,watches:e,weather:e,weatherchannel:e,
webcam:e,weber:e,website:e,wed:e,wedding:e,weibo:e,weir:e,whoswho:e,wien:e,wiki:e,williamhill:e,win:e,windows:e,wine:e,winners:e,wme:e,wolterskluwer:e,woodside:e,work:e,works:e,world:e,wow:e,wtc:e,wtf:e,xbox:e,xerox:e,xfinity:e,xihuan:e,xin:e,"xn--11b4c3d":e,कॉम:e,"xn--1ck2e1b":e,セール:e,"xn--1qqw23a":e,佛山:e,"xn--30rr7y":e,慈善:e,"xn--3bst00m":e,集团:e,"xn--3ds443g":e,在线:e,"xn--3pxu8k":e,点看:e,"xn--42c2d9a":e,คอม:e,"xn--45q11c":e,八卦:e,"xn--4gbrim":e,موقع:e,"xn--55qw42g":e,公益:e,"xn--55qx5d":e,公司:e,"xn--5su34j936bgsg":e,香格里拉:e,"xn--5tzm5g":e,网站:e,"xn--6frz82g":e,移动:e,"xn--6qq986b3xl":e,我爱你:e,"xn--80adxhks":e,москва:e,"xn--80aqecdr1a":e,католик:e,"xn--80asehdb":e,онлайн:e,"xn--80aswg":e,сайт:e,"xn--8y0a063a":e,联通:e,"xn--9dbq2a":e,קום:e,"xn--9et52u":e,时尚:e,"xn--9krt00a":e,微博:e,"xn--b4w605ferd":e,淡马锡:e,"xn--bck1b9a5dre4c":e,ファッション:e,"xn--c1avg":e,орг:e,"xn--c2br7g":e,
नेट:e,"xn--cck2b3b":e,ストア:e,"xn--cckwcxetd":e,アマゾン:e,"xn--cg4bki":e,삼성:e,"xn--czr694b":e,商标:e,"xn--czrs0t":e,商店:e,"xn--czru2d":e,商城:e,"xn--d1acj3b":e,дети:e,"xn--eckvdtc9d":e,ポイント:e,"xn--efvy88h":e,新闻:e,"xn--fct429k":e,家電:e,"xn--fhbei":e,كوم:e,"xn--fiq228c5hs":e,中文网:e,"xn--fiq64b":e,中信:e,"xn--fjq720a":e,娱乐:e,"xn--flw351e":e,谷歌:e,"xn--fzys8d69uvgm":e,電訊盈科:e,"xn--g2xx48c":e,购物:e,"xn--gckr3f0f":e,クラウド:e,"xn--gk3at1e":e,通販:e,"xn--hxt814e":e,网店:e,"xn--i1b6b1a6a2e":e,संगठन:e,"xn--imr513n":e,餐厅:e,"xn--io0a7i":e,网络:e,"xn--j1aef":e,ком:e,"xn--jlq480n2rg":e,亚马逊:e,"xn--jvr189m":e,食品:e,"xn--kcrx77d1x4a":e,飞利浦:e,"xn--kput3i":e,手机:e,"xn--mgba3a3ejt":e,ارامكو:e,"xn--mgba7c0bbn0a":e,العليان:e,"xn--mgbab2bd":e,بازار:e,"xn--mgbca7dzdo":e,ابوظبي:e,"xn--mgbi4ecexp":e,كاثوليك:e,"xn--mgbt3dhd":e,همراه:e,"xn--mk1bu44c":e,닷컴:e,
"xn--mxtq1m":e,政府:e,"xn--ngbc5azd":e,شبكة:e,"xn--ngbe9e0a":e,بيتك:e,"xn--ngbrx":e,عرب:e,"xn--nqv7f":e,机构:e,"xn--nqv7fs00ema":e,组织机构:e,"xn--nyqy26a":e,健康:e,"xn--otu796d":e,招聘:e,"xn--p1acf":e,рус:e,"xn--pssy2u":e,大拿:e,"xn--q9jyb4c":e,みんな:e,"xn--qcka1pmc":e,グーグル:e,"xn--rhqv96g":e,世界:e,"xn--rovu88b":e,書籍:e,"xn--ses554g":e,网址:e,"xn--t60b56a":e,닷넷:e,"xn--tckwe":e,コム:e,"xn--tiq49xqyj":e,天主教:e,"xn--unup4y":e,游戏:e,"xn--vermgensberater-ctb":e,vermögensberater:e,"xn--vermgensberatung-pwb":e,vermögensberatung:e,"xn--vhquv":e,企业:e,"xn--vuq861b":e,信息:e,"xn--w4r85el8fhu5dnra":e,嘉里大酒店:e,"xn--w4rs40l":e,嘉里:e,"xn--xhq521b":e,广东:e,"xn--zfr164b":e,政务:e,xyz:e,yachts:e,yahoo:e,yamaxun:e,yandex:e,yodobashi:e,yoga:e,yokohama:e,you:e,youtube:e,yun:e,zappos:e,zara:e,zero:e,zip:e,zone:e,zuerich:e}]}()});function d3(e,t,n){let r=null,a=t;for(;a!==void 0&&(a[0]===1&&(r={index:n+1}),n!==-1);){let i=a[1];a=Object.prototype.hasOwnProperty.call(i,e[n])?i[e[n]]:i["*"],n-=1}return r}function eb(e,t,n){var r;if(Pf(e,t,n))return;let a=e.split("."),i=d3(a,c3,a.length-1);if(i!==null){n.publicSuffix=a.slice(i.index+1).join(".");return}let o=d3(a,u3,a.length-1);if(o!==null){n.publicSuffix=a.slice(o.index).join(".");return}n.publicSuffix=(r=a[a.length-1])!==null&&r!==void 0?r:null}var m3=v(()=>{d();Qv();l3();s(d3,"lookupInTrie");s(eb,"suffixLookup")});function f3(e,t={}){return Jv(p3),Zv(e,3,eb,t,p3).domain}var p3,h3=v(()=>{d();Qv();m3();p3=Xv();s(f3,"getDomain")});var tt,Dne,g3,y3,G,Ene,qt=v(()=>{"use strict";d();R();tt={didntCollectScreenshots:"Chrome didn't collect any screenshots during the page load. Please make sure there is content visible on the page, and then try re-running Lighthouse. ({errorCode})",badTraceRecording:"Something went wrong with recording the trace over your page load. Please run Lighthouse again. ({errorCode})",noFcp:"The page did not paint any content. Please ensure you keep the browser window in the foreground during the load and try again. ({errorCode})",noLcp:"The page did not display content that qualifies as a Largest Contentful Paint (LCP). Ensure the page has a valid LCP element and then try again. ({errorCode})",pageLoadTookTooLong:"Your page took too long to load. Please follow the opportunities in the report to reduce your page load time, and then try re-running Lighthouse. ({errorCode})",pageLoadFailed:"Lighthouse was unable to reliably load the page you requested. Make sure you are testing the correct URL an\
d that the server is properly responding to all requests.",pageLoadFailedWithStatusCode:"Lighthouse was unable to reliably load the page you requested. Make sure you are testing the correct URL and that the server is properly responding to all requests. (Status code: {statusCode})",pageLoadFailedWithDetails:"Lighthouse was unable to reliably load the page you requested. Make sure you are testing the correct URL and that the server is properly responding to all requests. (Details: {errorDetails})",pageLoadFailedInsecure:"The URL you have provided does not have a valid security certificate. {securityMessages}",pageLoadFailedInterstitial:"Chrome prevented page load with an interstitial. Make sure you are testing the correct URL and that the server is properly responding to all requests.",internalChromeError:"An internal Chrome error occurred. Please restart Chrome and try re-running Lighthouse.",requestContentTimeout:"Fetching resource content has exceeded the allotted time",notHtml:"The \
page provided is not HTML (served as MIME type {mimeType}).",urlInvalid:"The URL you have provided appears to be invalid.",protocolTimeout:"Waiting for DevTools protocol response has exceeded the allotted time. (Method: {protocolMethod})",dnsFailure:"DNS servers could not resolve the provided domain.",pageLoadFailedHung:"Lighthouse was unable to reliably load the URL you requested because the page stopped responding.",criTimeout:"Timeout waiting for initial Debugger Protocol connection.",missingRequiredArtifact:"Required {artifactName} gatherer did not run.",erroredRequiredArtifact:"Required {artifactName} gatherer encountered an error: {errorMessage}",oldChromeDoesNotSupportFeature:"This version of Chrome is too old to support '{featureName}'. Use a newer version to see full results."},Dne=D("core/lib/lh-error.js",tt),g3="__LighthouseErrorSentinel",y3="__ErrorSentinel",G=class e extends Error{static{s(this,"LighthouseError")}constructor(t,n,r){super(t.code,r),this.name="LighthouseErro\
r",this.code=t.code,this.friendlyMessage=Dne(t.message,{errorCode:this.code,...n}),this.lhrRuntimeError=!!t.lhrRuntimeError,n&&Object.assign(this,n),Error.captureStackTrace(this,e)}static fromProtocolMessage(t,n){let r=Object.values(e.errors).filter(o=>o.pattern).find(o=>o.pattern&&o.pattern.test(n.message));if(r)return new e(r);let a=`(${t}): ${n.message}`;n.data&&(a+=` (${n.data})`);let i=new Error(`Protocol error ${a}`);return Object.assign(i,{protocolMethod:t,protocolError:n.message})}static stringifyReplacer(t){if(t instanceof e){let{name:n,code:r,message:a,friendlyMessage:i,lhrRuntimeError:o,stack:c,cause:u,...l}=t;return{sentinel:g3,code:r,stack:c,cause:u,properties:l}}if(t instanceof Error){let{message:n,stack:r,cause:a}=t,i=t.code;return{sentinel:y3,message:n,code:i,stack:r,cause:a}}throw new Error("Invalid value for LighthouseError stringification")}static parseReviver(t,n){if(typeof n=="object"&&n!==null){if(n.sentinel===g3){let{code:r,stack:a,cause:i,properties:o}=n,c=e.errors[r],
u=new e(c,o,{cause:i});return u.stack=a,u}if(n.sentinel===y3){let{message:r,code:a,stack:i,cause:o}=n,c=o?{cause:o}:void 0,u=new Error(r,c);return Object.assign(u,{code:a,stack:i}),u}}return n}},Ene={NO_SPEEDLINE_FRAMES:{code:"NO_SPEEDLINE_FRAMES",message:tt.didntCollectScreenshots,lhrRuntimeError:!0},SPEEDINDEX_OF_ZERO:{code:"SPEEDINDEX_OF_ZERO",message:tt.didntCollectScreenshots,lhrRuntimeError:!0},NO_SCREENSHOTS:{code:"NO_SCREENSHOTS",message:tt.didntCollectScreenshots,lhrRuntimeError:!0},INVALID_SPEEDLINE:{code:"INVALID_SPEEDLINE",message:tt.didntCollectScreenshots,lhrRuntimeError:!0},NO_TRACING_STARTED:{code:"NO_TRACING_STARTED",message:tt.badTraceRecording,lhrRuntimeError:!0},NO_RESOURCE_REQUEST:{code:"NO_RESOURCE_REQUEST",message:tt.badTraceRecording,lhrRuntimeError:!0},NO_NAVSTART:{code:"NO_NAVSTART",message:tt.badTraceRecording,lhrRuntimeError:!0},NO_FCP:{code:"NO_FCP",message:tt.noFcp,lhrRuntimeError:!0},NO_DCL:{code:"NO_DCL",message:tt.badTraceRecording,lhrRuntimeError:!0},NO_FMP:{
code:"NO_FMP",message:tt.badTraceRecording},NO_LCP:{code:"NO_LCP",message:tt.noLcp},NO_LCP_ALL_FRAMES:{code:"NO_LCP_ALL_FRAMES",message:tt.noLcp},UNSUPPORTED_OLD_CHROME:{code:"UNSUPPORTED_OLD_CHROME",message:tt.oldChromeDoesNotSupportFeature},NO_TTI_CPU_IDLE_PERIOD:{code:"NO_TTI_CPU_IDLE_PERIOD",message:tt.pageLoadTookTooLong},NO_TTI_NETWORK_IDLE_PERIOD:{code:"NO_TTI_NETWORK_IDLE_PERIOD",message:tt.pageLoadTookTooLong},NO_DOCUMENT_REQUEST:{code:"NO_DOCUMENT_REQUEST",message:tt.pageLoadFailed,lhrRuntimeError:!0},FAILED_DOCUMENT_REQUEST:{code:"FAILED_DOCUMENT_REQUEST",message:tt.pageLoadFailedWithDetails,lhrRuntimeError:!0},ERRORED_DOCUMENT_REQUEST:{code:"ERRORED_DOCUMENT_REQUEST",message:tt.pageLoadFailedWithStatusCode,lhrRuntimeError:!0},INSECURE_DOCUMENT_REQUEST:{code:"INSECURE_DOCUMENT_REQUEST",message:tt.pageLoadFailedInsecure,lhrRuntimeError:!0},CHROME_INTERSTITIAL_ERROR:{code:"CHROME_INTERSTITIAL_ERROR",message:tt.pageLoadFailedInterstitial,lhrRuntimeError:!0},PAGE_HUNG:{code:"PAG\
E_HUNG",message:tt.pageLoadFailedHung,lhrRuntimeError:!0},NOT_HTML:{code:"NOT_HTML",message:tt.notHtml,lhrRuntimeError:!0},TRACING_ALREADY_STARTED:{code:"TRACING_ALREADY_STARTED",message:tt.internalChromeError,pattern:/Tracing.*started/,lhrRuntimeError:!0},PARSING_PROBLEM:{code:"PARSING_PROBLEM",message:tt.internalChromeError,pattern:/Parsing problem/,lhrRuntimeError:!0},READ_FAILED:{code:"READ_FAILED",message:tt.internalChromeError,pattern:/Read failed/,lhrRuntimeError:!0},INVALID_URL:{code:"INVALID_URL",message:tt.urlInvalid},PROTOCOL_TIMEOUT:{code:"PROTOCOL_TIMEOUT",message:tt.protocolTimeout,lhrRuntimeError:!0},DNS_FAILURE:{code:"DNS_FAILURE",message:tt.dnsFailure,lhrRuntimeError:!0},CRI_TIMEOUT:{code:"CRI_TIMEOUT",message:tt.criTimeout,lhrRuntimeError:!0},MISSING_REQUIRED_ARTIFACT:{code:"MISSING_REQUIRED_ARTIFACT",message:tt.missingRequiredArtifact},ERRORED_REQUIRED_ARTIFACT:{code:"ERRORED_REQUIRED_ARTIFACT",message:tt.erroredRequiredArtifact}};G.errors=Ene;G.NO_ERROR="NO_ERROR";G.
UNKNOWN_ERROR="UNKNOWN_ERROR"});function kne(e){return!e||!e.startsWith("chrome://")?e:(e.endsWith("/")&&(e=e.replace(/\/$/,"")),e.replace(/^chrome:\/\/chrome\//,"chrome://"))}var Tne,xne,Sne,Cne,Of,Q,at=v(()=>{"use strict";d();h3();Vn();qt();Tne=["https:","http:","chrome:","chrome-extension:"],xne=["data","https","wss","blob","chrome","chrome-extension","about","filesystem"],Sne=["localhost","127.0.0.1"],Cne=["blob","data","intent","file","filesystem","chrome-extension"];s(kne,"rewriteChromeInternalUrl");Of=class e{static{s(this,"UrlUtils")}static isValid(t){try{return new URL(t),!0}catch{return!1}}static hostsMatch(t,n){try{return new URL(t).host===new URL(n).host}catch{return!1}}static originsMatch(t,n){try{return new URL(t).origin===new URL(n).origin}catch{return!1}}static getOrigin(t){try{let n=new URL(t);return n.protocol==="chrome-extension:"?ze.getChromeExtensionOrigin(t):n.host&&n.origin||null}catch{return null}}static getRootDomain(t){let n=ze.createOrReturnURL(t);return f3(n.href)||n.hostname}static rootDomainsMatch(t,n){
let r,a;try{r=ze.createOrReturnURL(t),a=ze.createOrReturnURL(n)}catch{return!1}if(!r.hostname||!a.hostname)return!1;let i=e.getRootDomain(r),o=e.getRootDomain(a);return i===o}static getURLDisplayName(t,n){return ze.getURLDisplayName(new URL(t),n)}static elideDataURI(t){try{return new URL(t).protocol==="data:"?ze.truncate(t,100):t}catch{return t}}static equalWithExcludedFragments(t,n){[t,n]=[t,n].map(kne);try{let r=new URL(t);r.hash="";let a=new URL(n);return a.hash="",r.href===a.href}catch{return!1}}static isProtocolAllowed(t){try{let n=new URL(t);return Tne.includes(n.protocol)}catch{return!1}}static isLikeLocalhost(t){return Sne.includes(t)||t.endsWith(".localhost")}static isSecureScheme(t){return xne.includes(t)}static isNonNetworkProtocol(t){let n=t.includes(":")?t.slice(0,t.indexOf(":")):t;return Cne.includes(n)}static guessMimeType(t){let n;try{n=new URL(t)}catch{return}if(n.protocol==="data:"){let i=n.pathname.match(/^(image\/(png|jpeg|svg\+xml|webp|gif|avif))[;,]/);return i?i[1]:
void 0}let r=n.pathname.toLowerCase().match(/\.(png|jpeg|jpg|svg|webp|gif|avif)$/);if(!r)return;let a=r[1];return a==="svg"?"image/svg+xml":a==="jpg"?"image/jpeg":`image/${a}`}static normalizeUrl(t){if(t&&this.isValid(t)&&this.isProtocolAllowed(t))return new URL(t).href;throw new G(G.errors.INVALID_URL)}};Of.INVALID_URL_DEBUG_STRING="Lighthouse was unable to determine the URL of some script executions. It's possible a Chrome extension or other eval'd code is the source.";Q=Of});var v3,Ane,Rne,Qt,wo=v(()=>{"use strict";d();at();v3=14*1024,Ane=.4,Rne={Document:.9,XHR:.9,Fetch:.9},Qt=class e{static{s(this,"NetworkAnalyzer")}static get SUMMARY(){return"__SUMMARY__"}static groupByOrigin(t){let n=new Map;return t.forEach(r=>{let a=r.parsedURL.securityOrigin,i=n.get(a)||[];i.push(r),n.set(a,i)}),n}static getSummary(t){t.sort((r,a)=>r-a);let n;if(t.length===0)n=t[0];else if(t.length%2===0){let r=t[Math.floor((t.length-1)/2)],a=t[Math.floor((t.length-1)/2)+1];n=(r+a)/2}else n=t[Math.floor((t.length-1)/2)];return{min:t[0],max:t[t.length-1],avg:t.reduce((r,a)=>r+a,0)/t.length,median:n}}static summarize(t){let n=new Map,r=[];for(let[a,i]of t)n.set(a,e.getSummary(i)),r.push(...i);return n.set(e.SUMMARY,e.getSummary(r)),n}static _estimateValueByOrigin(t,n){let r=e.estimateIfConnectionWasReused(t),a=e.groupByOrigin(t),i=new Map;for(let[o,c]of a.entries()){let u=[];for(let l of c){let m=l.timing;if(!m)continue;let p=n({record:l,timing:m,connectionReused:r.get(l.requestId)});
typeof p<"u"&&(u=u.concat(p))}u.length&&i.set(o,u)}return i}static _estimateRTTViaConnectionTiming(t){let{timing:n,connectionReused:r,record:a}=t;if(r)return;if(globalThis.isLightrider&&a.lrStatistics)return a.protocol.startsWith("h3")?a.lrStatistics.TCPMs:[a.lrStatistics.TCPMs/2,a.lrStatistics.TCPMs/2];let{connectStart:i,sslStart:o,sslEnd:c,connectEnd:u}=n;if(u>=0&&i>=0&&a.protocol.startsWith("h3"))return u-i;if(o>=0&&c>=0&&o!==i)return[u-o,o-i];if(i>=0&&u>=0)return u-i}static _estimateRTTViaDownloadTiming(t){let{timing:n,connectionReused:r,record:a}=t;if(r||a.transferSize<=v3||!Number.isFinite(n.receiveHeadersEnd)||n.receiveHeadersEnd<0)return;let o=a.networkEndTime-a.networkRequestTime-n.receiveHeadersEnd,c=Math.log2(a.transferSize/v3);if(!(c>5))return o/c}static _estimateRTTViaSendStartTiming(t){let{timing:n,connectionReused:r,record:a}=t;if(r||!Number.isFinite(n.sendStart)||n.sendStart<0)return;let i=1;return a.protocol.startsWith("h3")||(i+=1),a.parsedURL.scheme==="https"&&(i+=1),
n.sendStart/i}static _estimateRTTViaHeadersEndTiming(t){let{timing:n,connectionReused:r,record:a}=t;if(!Number.isFinite(n.receiveHeadersEnd)||n.receiveHeadersEnd<0||!a.resourceType)return;let i=Rne[a.resourceType]||Ane,o=n.receiveHeadersEnd*i,c=1;return r||(c+=1,a.protocol.startsWith("h3")||(c+=1),a.parsedURL.scheme==="https"&&(c+=1)),Math.max((n.receiveHeadersEnd-o)/c,3)}static _estimateResponseTimeByOrigin(t,n){return e._estimateValueByOrigin(t,({record:r,timing:a})=>{if(globalThis.isLightrider&&r.lrStatistics)return r.lrStatistics.requestMs;if(!Number.isFinite(a.receiveHeadersEnd)||a.receiveHeadersEnd<0||!Number.isFinite(a.sendEnd)||a.sendEnd<0)return;let i=a.receiveHeadersEnd-a.sendEnd,o=r.parsedURL.securityOrigin,c=n.get(o)||n.get(e.SUMMARY)||0;return Math.max(i-c,0)})}static canTrustConnectionInformation(t){let n=new Map;for(let r of t){let a=n.get(r.connectionId)||!r.connectionReused;n.set(r.connectionId,a)}return n.size<=1?!1:Array.from(n.values()).every(r=>r)}static estimateIfConnectionWasReused(t,n){
let{forceCoarseEstimates:r=!1}=n||{};if(!r&&e.canTrustConnectionInformation(t))return new Map(t.map(o=>[o.requestId,!!o.connectionReused]));let a=new Map,i=e.groupByOrigin(t);for(let[o,c]of i.entries()){let u=c.map(m=>m.networkEndTime).reduce((m,p)=>Math.min(m,p),1/0);for(let m of c)a.set(m.requestId,m.networkRequestTime>=u||m.protocol==="h2");let l=c.reduce((m,p)=>m.networkRequestTime>p.networkRequestTime?p:m);a.set(l.requestId,!1)}return a}static estimateRTTByOrigin(t,n){let{forceCoarseEstimates:r=!1,coarseEstimateMultiplier:a=.3,useDownloadEstimates:i=!0,useSendStartEstimates:o=!0,useHeadersEndEstimates:c=!0}=n||{},u=e.estimateIfConnectionWasReused(t),l=e.groupByOrigin(t),m=new Map;for(let[h,f]of l.entries()){let b=function(w,E=1){for(let x of f){let S=x.timing;if(!S)continue;let k=w({record:x,timing:S,connectionReused:u.get(x.requestId)});k!==void 0&&(Array.isArray(k)?g.push(...k.map(A=>A*E)):g.push(k*E))}};var p=b;s(b,"collectEstimates");let g=[];r||b(this._estimateRTTViaConnectionTiming),
g.length||(i&&b(this._estimateRTTViaDownloadTiming,a),o&&b(this._estimateRTTViaSendStartTiming,a),c&&b(this._estimateRTTViaHeadersEndTiming,a)),g.length&&m.set(h,g)}if(!m.size)throw new Error("No timing information available");return e.summarize(m)}static estimateServerResponseTimeByOrigin(t,n){let r=(n||{}).rttByOrigin;if(!r){r=new Map;let i=e.estimateRTTByOrigin(t,n);for(let[o,c]of i.entries())r.set(o,c.min)}let a=e._estimateResponseTimeByOrigin(t,r);return e.summarize(a)}static estimateThroughput(t){let n=0,r=t.reduce((c,u)=>(u.parsedURL?.scheme==="data"||u.failed||!u.finished||u.statusCode>300||!u.transferSize||(n+=u.transferSize,c.push({time:u.responseHeadersEndTime/1e3,isStart:!0}),c.push({time:u.networkEndTime/1e3,isStart:!1})),c),[]).sort((c,u)=>c.time-u.time);if(!r.length)return 1/0;let a=0,i=0,o=0;return r.forEach(c=>{c.isStart?(a===0&&(i=c.time),a++):(a--,a===0&&(o+=c.time-i))}),n*8/o}static findResourceForUrl(t,n){return t.find(r=>n.startsWith(r.url)&&Q.equalWithExcludedFragments(
r.url,n))}static findLastDocumentForUrl(t,n){let r=t.filter(a=>a.resourceType==="Document"&&n.startsWith(a.url)&&Q.equalWithExcludedFragments(a.url,n));return r[r.length-1]}static resolveRedirects(t){for(;t.redirectDestination;)t=t.redirectDestination;return t}}});var _ne,Ine,Fne,Bf,b3=v(()=>{"use strict";d();Yt();wo();Hv();_ne=30,Ine=["https","wss"],Fne=6,Bf=class{static{s(this,"ConnectionPool")}constructor(t,n){this._options=n,this._records=t,this._connectionsByOrigin=new Map,this._connectionsByRecord=new Map,this._connectionsInUse=new Set,this._connectionReusedByRequestId=Qt.estimateIfConnectionWasReused(t,{forceCoarseEstimates:!0}),this._initializeConnections()}connectionsInUse(){return Array.from(this._connectionsInUse)}_initializeConnections(){let t=this._connectionReusedByRequestId,n=this._options.additionalRttByOrigin,r=this._options.serverResponseTimeByOrigin,a=Qt.groupByOrigin(this._records);for(let[i,o]of a.entries()){let c=[],u=n.get(i)||0,l=r.get(i)||_ne;for(let p of o){if(t.get(p.requestId))continue;let h=Ine.includes(p.parsedURL.scheme),f=p.protocol==="h2",g=new Bs(this._options.rtt+u,this._options.throughput,l,h,f);c.push(g)}if(!c.length)throw new Error(`Could not find a connection for origin: ${i}`);let m=c[0].isH2()?1:Fne;for(;c.
length<m;)c.push(c[0].clone());this._connectionsByOrigin.set(i,c)}}_findAvailableConnectionWithLargestCongestionWindow(t,n){let{ignoreConnectionReused:r,observedConnectionWasReused:a}=n,i=null;for(let o=0;o<t.length;o++){let c=t[o];if(!r&&c._warmed!==a||this._connectionsInUse.has(c))continue;let u=i?.congestionWindow||-1/0;c.congestionWindow>u&&(i=c)}return i}acquire(t,n={}){if(this._connectionsByRecord.has(t))throw new Error("Record already has a connection");let r=t.parsedURL.securityOrigin,a=!!this._connectionReusedByRequestId.get(t.requestId),i=this._connectionsByOrigin.get(r)||[],o=this._findAvailableConnectionWithLargestCongestionWindow(i,{ignoreConnectionReused:n.ignoreConnectionReused,observedConnectionWasReused:a});return o?(this._connectionsInUse.add(o),this._connectionsByRecord.set(t,o),o):null}acquireActiveConnectionFromRecord(t){let n=this._connectionsByRecord.get(t);if(!n)throw new Error("Could not find an active connection for record");return n}release(t){let n=this._connectionsByRecord.
get(t);this._connectionsByRecord.delete(t),this._connectionsInUse.delete(n)}}});var Nne,Us,w3=v(()=>{"use strict";d();Yt();Nne=2,Us=class e{static{s(this,"DNSCache")}constructor({rtt:t}){this._rtt=t,this._resolvedDomainNames=new Map}getTimeUntilResolution(t,n){let{requestedAt:r=0,shouldUpdateCache:a=!1}=n||{},i=t.parsedURL.host,o=this._resolvedDomainNames.get(i),c=this._rtt*e.RTT_MULTIPLIER;if(o){let l=Math.max(o.resolvedAt-r,0);c=Math.min(l,c)}let u=r+c;return a&&this._updateCacheResolvedAtIfNeeded(t,u),c}_updateCacheResolvedAtIfNeeded(t,n){let r=t.parsedURL.host,a=this._resolvedDomainNames.get(r)||{resolvedAt:n};a.resolvedAt=Math.min(a.resolvedAt,n),this._resolvedDomainNames.set(r,a)}setResolvedAt(t,n){this._resolvedDomainNames.set(t,{resolvedAt:n})}};Us.RTT_MULTIPLIER=Nne});var dl,D3=v(()=>{"use strict";d();An();dl=class{static{s(this,"SimulatorTimingMap")}constructor(){this._nodeTimings=new Map}getNodes(){return Array.from(this._nodeTimings.keys())}setReadyToStart(t,n){this._nodeTimings.set(t,n)}setInProgress(t,n){let r={...this.getQueued(t),startTime:n.startTime,timeElapsed:0};this._nodeTimings.set(t,t.type===De.TYPES.NETWORK?{...r,timeElapsedOvershoot:0,bytesDownloaded:0}:r)}setCompleted(t,n){let r={...this.getInProgress(t),endTime:n.endTime,connectionTiming:n.connectionTiming};this._nodeTimings.set(t,r)}setCpu(t,n){let r={...this.getCpuStarted(t),timeElapsed:n.timeElapsed};this._nodeTimings.set(t,r)}setCpuEstimated(t,n){let r={...this.getCpuStarted(t),estimatedTimeElapsed:n.estimatedTimeElapsed};this._nodeTimings.set(t,r)}setNetwork(t,n){let r={...this.getNetworkStarted(t),timeElapsed:n.timeElapsed,timeElapsedOvershoot:n.timeElapsedOvershoot,bytesDownloaded:n.bytesDownloaded};this._nodeTimings.set(t,r)}setNetworkEstimated(t,n){let r={...this.getNetworkStarted(
t),estimatedTimeElapsed:n.estimatedTimeElapsed};this._nodeTimings.set(t,r)}getQueued(t){let n=this._nodeTimings.get(t);if(!n)throw new Error(`Node ${t.id} not yet queued`);return n}getCpuStarted(t){let n=this._nodeTimings.get(t);if(!n)throw new Error(`Node ${t.id} not yet queued`);if(!("startTime"in n))throw new Error(`Node ${t.id} not yet started`);if("bytesDownloaded"in n)throw new Error(`Node ${t.id} timing not valid`);return n}getNetworkStarted(t){let n=this._nodeTimings.get(t);if(!n)throw new Error(`Node ${t.id} not yet queued`);if(!("startTime"in n))throw new Error(`Node ${t.id} not yet started`);if(!("bytesDownloaded"in n))throw new Error(`Node ${t.id} timing not valid`);return n}getInProgress(t){let n=this._nodeTimings.get(t);if(!n)throw new Error(`Node ${t.id} not yet queued`);if(!("startTime"in n))throw new Error(`Node ${t.id} not yet started`);if(!("estimatedTimeElapsed"in n))throw new Error(`Node ${t.id} not yet in progress`);return n}getCompleted(t){let n=this._nodeTimings.
get(t);if(!n)throw new Error(`Node ${t.id} not yet queued`);if(!("startTime"in n))throw new Error(`Node ${t.id} not yet started`);if(!("estimatedTimeElapsed"in n))throw new Error(`Node ${t.id} not yet in progress`);if(!("endTime"in n))throw new Error(`Node ${t.id} not yet completed`);return n}}});var Gr={};T(Gr,{defaultSettings:()=>rr,nonSimulatedSettingsOverrides:()=>js,screenEmulationMetrics:()=>Uf,throttling:()=>$n,userAgents:()=>si});var $n,Mne,Lne,Uf,Pne,One,si,rr,js,ar=v(()=>{"use strict";d();$n={DEVTOOLS_RTT_ADJUSTMENT_FACTOR:3.75,DEVTOOLS_THROUGHPUT_ADJUSTMENT_FACTOR:.9,mobileSlow4G:{rttMs:150,throughputKbps:1638.4,requestLatencyMs:562.5,downloadThroughputKbps:1474.5600000000002,uploadThroughputKbps:675,cpuSlowdownMultiplier:4},mobileRegular3G:{rttMs:300,throughputKbps:700,requestLatencyMs:1125,downloadThroughputKbps:630,uploadThroughputKbps:630,cpuSlowdownMultiplier:4},desktopDense4G:{rttMs:40,throughputKbps:10240,cpuSlowdownMultiplier:1,requestLatencyMs:0,downloadThroughputKbps:0,uploadThroughputKbps:0}},Mne={mobile:!0,width:412,height:823,deviceScaleFactor:1.75,disabled:!1},Lne={mobile:!1,width:1350,height:940,deviceScaleFactor:1,disabled:!1},Uf={mobile:Mne,desktop:Lne},Pne="Mozilla/5.0 (Linux; Android 11; moto g power (2022)) AppleWebKit/537.36 (KHTML, like Gecko) C\
hrome/119.0.0.0 Mobile Safari/537.36",One="Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/119.0.0.0 Safari/537.36",si={mobile:Pne,desktop:One},rr={output:"json",maxWaitForFcp:30*1e3,maxWaitForLoad:45*1e3,pauseAfterFcpMs:1e3,pauseAfterLoadMs:1e3,networkQuietThresholdMs:1e3,cpuQuietThresholdMs:1e3,formFactor:"mobile",throttling:$n.mobileSlow4G,throttlingMethod:"simulate",screenEmulation:Uf.mobile,emulatedUserAgent:si.mobile,auditMode:!1,gatherMode:!1,clearStorageTypes:["file_systems","shader_cache","service_workers","cache_storage"],disableStorageReset:!1,debugNavigation:!1,channel:"node",usePassiveGathering:!1,disableFullPageScreenshot:!1,skipAboutBlank:!1,blankPage:"about:blank",ignoreStatusCode:!1,budgets:null,locale:"en-US",blockedUrlPatterns:null,additionalTraceCategories:null,extraHeaders:null,precomputedLanternData:null,onlyAudits:null,onlyCategories:null,skipAudits:null},js={pauseAfterFcpMs:5250,pauseAfterLoadMs:5250,networkQuietThresholdMs:5250,
cpuQuietThresholdMs:5250}});var tb,Bne,Une,jne,ir,qne,E3,ml,nb=v(()=>{"use strict";d();Yt();An();Hv();b3();w3();D3();ar();tb=$n.mobileSlow4G,Bne=10,Une=.5,jne=1e4,ir={NotReadyToStart:0,ReadyToStart:1,InProgress:2,Complete:3},qne={VeryHigh:0,High:.25,Medium:.5,Low:1,VeryLow:2},E3=new Map,ml=class e{static{s(this,"Simulator")}constructor(t){if(this._options=Object.assign({rtt:tb.rttMs,throughput:tb.throughputKbps*1024,maximumConcurrentRequests:Bne,cpuSlowdownMultiplier:tb.cpuSlowdownMultiplier,layoutTaskMultiplier:Une,additionalRttByOrigin:new Map,serverResponseTimeByOrigin:new Map},t),this._rtt=this._options.rtt,this._throughput=this._options.throughput,this._maximumConcurrentRequests=Math.max(Math.min(Bs.maximumSaturatedConnections(this._rtt,this._throughput),this._options.maximumConcurrentRequests),1),this._cpuSlowdownMultiplier=this._options.cpuSlowdownMultiplier,this._layoutTaskMultiplier=this._cpuSlowdownMultiplier*this._options.layoutTaskMultiplier,this._cachedNodeListByStartPosition=[],this._flexibleOrdering=
!1,this._nodeTimings=new dl,this._numberInProgressByType=new Map,this._nodes={},this._dns=new Us({rtt:this._rtt}),this._connectionPool=null,!Number.isFinite(this._rtt))throw new Error(`Invalid rtt ${this._rtt}`);if(!Number.isFinite(this._throughput))throw new Error(`Invalid rtt ${this._throughput}`)}get rtt(){return this._rtt}_initializeConnectionPool(t){let n=[];t.getRootNode().traverse(r=>{r.type===De.TYPES.NETWORK&&n.push(r.record)}),this._connectionPool=new Bf(n,this._options)}_initializeAuxiliaryData(){this._nodeTimings=new dl,this._numberInProgressByType=new Map,this._nodes={},this._cachedNodeListByStartPosition=[];for(let t of Object.values(ir))this._nodes[t]=new Set}_numberInProgress(t){return this._numberInProgressByType.get(t)||0}_markNodeAsReadyToStart(t,n){let r=e._computeNodeStartPosition(t),a=this._cachedNodeListByStartPosition.findIndex(o=>e._computeNodeStartPosition(o)>r),i=a===-1?this._cachedNodeListByStartPosition.length:a;this._cachedNodeListByStartPosition.splice(i,
0,t),this._nodes[ir.ReadyToStart].add(t),this._nodes[ir.NotReadyToStart].delete(t),this._nodeTimings.setReadyToStart(t,{queuedTime:n})}_markNodeAsInProgress(t,n){let r=this._cachedNodeListByStartPosition.indexOf(t);this._cachedNodeListByStartPosition.splice(r,1),this._nodes[ir.InProgress].add(t),this._nodes[ir.ReadyToStart].delete(t),this._numberInProgressByType.set(t.type,this._numberInProgress(t.type)+1),this._nodeTimings.setInProgress(t,{startTime:n})}_markNodeAsComplete(t,n,r){this._nodes[ir.Complete].add(t),this._nodes[ir.InProgress].delete(t),this._numberInProgressByType.set(t.type,this._numberInProgress(t.type)-1),this._nodeTimings.setCompleted(t,{endTime:n,connectionTiming:r});for(let a of t.getDependents())a.getDependencies().some(o=>!this._nodes[ir.Complete].has(o))||this._markNodeAsReadyToStart(a,n)}_acquireConnection(t){return this._connectionPool.acquire(t,{ignoreConnectionReused:this._flexibleOrdering})}_getNodesSortedByStartPosition(){return Array.from(this._cachedNodeListByStartPosition)}_startNodeIfPossible(t,n){
if(t.type===De.TYPES.CPU){this._numberInProgress(t.type)===0&&this._markNodeAsInProgress(t,n);return}if(t.type!==De.TYPES.NETWORK)throw new Error("Unsupported");!t.isConnectionless&&(this._numberInProgress(t.type)>=this._maximumConcurrentRequests||!this._acquireConnection(t.record))||this._markNodeAsInProgress(t,n)}_updateNetworkCapacity(){let t=this._numberInProgress(De.TYPES.NETWORK);if(t!==0)for(let n of this._connectionPool.connectionsInUse())n.setThroughput(this._throughput/t)}_estimateTimeRemaining(t){if(t.type===De.TYPES.CPU)return this._estimateCPUTimeRemaining(t);if(t.type===De.TYPES.NETWORK)return this._estimateNetworkTimeRemaining(t);throw new Error("Unsupported")}_estimateCPUTimeRemaining(t){let n=this._nodeTimings.getCpuStarted(t),r=t.didPerformLayout()?this._layoutTaskMultiplier:this._cpuSlowdownMultiplier,i=Math.min(Math.round(t.event.dur/1e3*r),jne)-n.timeElapsed;return this._nodeTimings.setCpuEstimated(t,{estimatedTimeElapsed:i}),i}_estimateNetworkTimeRemaining(t){let n=t.
record,r=this._nodeTimings.getNetworkStarted(t),a=0;if(t.fromDiskCache)a=8+20*((n.resourceSize||0)/1024/1024)-r.timeElapsed;else if(t.isNonNetworkProtocol)a=2+10*((n.resourceSize||0)/1024/1024)-r.timeElapsed;else{let o=this._connectionPool.acquireActiveConnectionFromRecord(n),c=this._dns.getTimeUntilResolution(n,{requestedAt:r.startTime,shouldUpdateCache:!0}),u=r.timeElapsed;a=o.simulateDownloadUntil(n.transferSize-r.bytesDownloaded,{timeAlreadyElapsed:u,dnsResolutionTime:c,maximumTimeToElapse:1/0}).timeElapsed}let i=a+r.timeElapsedOvershoot;return this._nodeTimings.setNetworkEstimated(t,{estimatedTimeElapsed:i}),i}_findNextNodeCompletionTime(){let t=1/0;for(let n of this._nodes[ir.InProgress])t=Math.min(t,this._estimateTimeRemaining(n));return t}_updateProgressMadeInTimePeriod(t,n,r){let a=this._nodeTimings.getInProgress(t),i=a.estimatedTimeElapsed===n;if(t.type===De.TYPES.CPU||t.isConnectionless)return i?this._markNodeAsComplete(t,r):a.timeElapsed+=n;if(t.type!==De.TYPES.NETWORK)throw new Error(
"Unsupported");if(!("bytesDownloaded"in a))throw new Error("Invalid timing data");let o=t.record,c=this._connectionPool.acquireActiveConnectionFromRecord(o),u=this._dns.getTimeUntilResolution(o,{requestedAt:a.startTime,shouldUpdateCache:!0}),l=c.simulateDownloadUntil(o.transferSize-a.bytesDownloaded,{dnsResolutionTime:u,timeAlreadyElapsed:a.timeElapsed,maximumTimeToElapse:n-a.timeElapsedOvershoot});c.setCongestionWindow(l.congestionWindow),c.setH2OverflowBytesDownloaded(l.extraBytesDownloaded),i?(c.setWarmed(!0),this._connectionPool.release(o),this._markNodeAsComplete(t,r,l.connectionTiming)):(a.timeElapsed+=l.timeElapsed,a.timeElapsedOvershoot+=l.timeElapsed-n,a.bytesDownloaded+=l.bytesDownloaded)}_computeFinalNodeTimings(){let t=this._nodeTimings.getNodes().map(r=>[r,this._nodeTimings.getCompleted(r)]);t.sort((r,a)=>r[1].startTime-a[1].startTime);let n=t.map(([r,a])=>[r,{startTime:a.startTime,endTime:a.endTime,duration:a.endTime-a.startTime}]);return{nodeTimings:new Map(n),completeNodeTimings:new Map(
t)}}getOptions(){return this._options}simulate(t,n){if(De.hasCycle(t))throw new Error("Cannot simulate graph with cycle");n=Object.assign({label:void 0,flexibleOrdering:!1},n),this._flexibleOrdering=!!n.flexibleOrdering,this._dns=new Us({rtt:this._rtt}),this._initializeConnectionPool(t),this._initializeAuxiliaryData();let r=this._nodes[ir.NotReadyToStart],a=this._nodes[ir.ReadyToStart],i=this._nodes[ir.InProgress],o=t.getRootNode();o.traverse(p=>r.add(p));let c=0,u=0;for(this._markNodeAsReadyToStart(o,c);a.size||i.size;){for(let h of this._getNodesSortedByStartPosition())this._startNodeIfPossible(h,c);if(!i.size){if(this._flexibleOrdering)throw new Error("Failed to start a node");this._flexibleOrdering=!0;continue}this._updateNetworkCapacity();let p=this._findNextNodeCompletionTime();if(c+=p,!Number.isFinite(p)||u>1e5)throw new Error("Simulation failed, depth exceeded");u++;for(let h of i)this._updateProgressMadeInTimePeriod(h,p,c)}let{nodeTimings:l,completeNodeTimings:m}=this._computeFinalNodeTimings();
return E3.set(n.label||"unlabeled",m),{timeInMs:c,nodeTimings:l}}computeWastedMsFromWastedBytes(t){let{throughput:n,observedThroughput:r}=this._options,a=n===0?r:n;if(a===0)return 0;let o=t*8/a*1e3;return Math.round(o/10)*10}static get ALL_NODE_TIMINGS(){return E3}static _computeNodeStartPosition(t){return t.type==="cpu"?t.startTime:t.startTime+(qne[t.record.priority]*1e3*1e3||0)}}});var T3=v(()=>{"use strict";d();});var x3=v(()=>{"use strict";d();Pe();jr();});var S3,jf,C3=v(()=>{"use strict";d();S3=Ht(nl(),1);jf=class e{static{s(this,"ArbitraryEqualityMap")}constructor(){this._equalsFn=e.deepEquals,this._entries=[]}setEqualityFn(t){this._equalsFn=t}has(t){return this._findIndexOf(t)!==-1}get(t){return this._entries[this._findIndexOf(t)]?.value}set(t,n){let r=this._findIndexOf(t);r===-1&&(r=this._entries.length),this._entries[r]={key:t,value:n}}_findIndexOf(t){for(let n=0;n<this._entries.length;n++)if(this._equalsFn(t,this._entries[n].key))return n;return-1}static deepEquals(t,n){return(0,S3.default)(t,n)}}});function H(e,t){return Object.assign(e,{request:s((r,a)=>{let i=t?Object.fromEntries(t.map(h=>[h,r[h]])):r,o=a.computedCache,c=e.name,u=o.get(c)||new jf;o.set(c,u);let l=u.get(i);if(l)return l;let m={msg:`Computing artifact: ${c}`,id:`lh:computed:${c}`};F.time(m,"verbose");let p=e.compute_(i,a);return u.set(i,p),p.then(()=>F.timeEnd(m)).catch(()=>F.timeEnd(m)),p},"request")})}var de=v(()=>{"use strict";d();Pe();C3();s(H,"makeComputedArtifact")});var k3,A3,R3,_3,I3,F3,N3,qf,V,vt=v(()=>{"use strict";d();Yt();at();k3="X-TCPMs",A3="X-SSLMs",R3="X-RequestMs",_3="X-ResponseMs",I3="X-TotalMs",F3="X-TotalFetchedSize",N3="X-ProtocolIsH2",qf={XHR:"XHR",Fetch:"Fetch",EventSource:"EventSource",Script:"Script",Stylesheet:"Stylesheet",Image:"Image",Media:"Media",Font:"Font",Document:"Document",TextTrack:"TextTrack",WebSocket:"WebSocket",Other:"Other",Manifest:"Manifest",SignedExchange:"SignedExchange",Ping:"Ping",Preflight:"Preflight",CSPViolationReport:"CSPViolationReport",Prefetch:"Prefetch"},V=class e{static{s(this,"NetworkRequest")}constructor(){this.requestId="",this.connectionId="0",this.connectionReused=!1,this.url="",this.protocol="",this.isSecure=!1,this.isValid=!1,this.parsedURL={scheme:""},this.documentURL="",this.rendererStartTime=-1,this.networkRequestTime=-1,this.responseHeadersEndTime=-1,this.networkEndTime=-1,this.transferSize=0,this.responseHeadersTransferSize=0,this.resourceSize=0,this.fromDiskCache=!1,this.fromMemoryCache=
!1,this.fromPrefetchCache=!1,this.lrStatistics=void 0,this.finished=!1,this.requestMethod="",this.statusCode=-1,this.redirectSource=void 0,this.redirectDestination=void 0,this.redirects=void 0,this.failed=!1,this.localizedFailDescription="",this.initiator={type:"other"},this.timing=void 0,this.resourceType=void 0,this.mimeType="",this.priority="Low",this.initiatorRequest=void 0,this.responseHeaders=[],this.responseHeadersText="",this.fetchedViaServiceWorker=!1,this.frameId="",this.sessionId=void 0,this.sessionTargetType=void 0,this.isLinkPreload=!1}hasErrorStatusCode(){return this.statusCode>=400}setInitiatorRequest(t){this.initiatorRequest=t}onRequestWillBeSent(t){this.requestId=t.requestId;let n;try{n=new URL(t.request.url)}catch{return}this.url=t.request.url,this.documentURL=t.documentURL,this.parsedURL={scheme:n.protocol.split(":")[0],host:n.hostname,securityOrigin:n.origin},this.isSecure=Q.isSecureScheme(this.parsedURL.scheme),this.rendererStartTime=t.timestamp*1e3,this.networkRequestTime=
this.rendererStartTime,this.requestMethod=t.request.method,this.initiator=t.initiator,this.resourceType=t.type&&qf[t.type],this.priority=t.request.initialPriority,this.frameId=t.frameId,this.isLinkPreload=t.initiator.type==="preload"||!!t.request.isLinkPreload,this.isValid=!0}onRequestServedFromCache(){this.fromMemoryCache=!0}onResponseReceived(t){this._onResponse(t.response,t.timestamp,t.type),this._updateProtocolForLightrider(),this.frameId=t.frameId}onResponseReceivedExtraInfo(t){this.responseHeadersText=t.headersText||""}onDataReceived(t){this.resourceSize+=t.dataLength,t.encodedDataLength!==-1&&(this.transferSize+=t.encodedDataLength)}onLoadingFinished(t){this.finished||(this.finished=!0,this.networkEndTime=t.timestamp*1e3,t.encodedDataLength>=0&&(this.transferSize=t.encodedDataLength),this._updateResponseHeadersEndTimeIfNecessary(),this._backfillReceiveHeaderStartTiming(),this._updateTransferSizeForLightrider(),this._updateTimingsForLightrider())}onLoadingFailed(t){this.finished||
(this.finished=!0,this.networkEndTime=t.timestamp*1e3,this.failed=!0,this.resourceType=t.type&&qf[t.type],this.localizedFailDescription=t.errorText,this._updateResponseHeadersEndTimeIfNecessary(),this._backfillReceiveHeaderStartTiming(),this._updateTransferSizeForLightrider(),this._updateTimingsForLightrider())}onResourceChangedPriority(t){this.priority=t.newPriority}onRedirectResponse(t){if(!t.redirectResponse)throw new Error("Missing redirectResponse data");this._onResponse(t.redirectResponse,t.timestamp,t.type),this.resourceType=void 0,this.finished=!0,this.networkEndTime=t.timestamp*1e3,this._updateResponseHeadersEndTimeIfNecessary(),this._backfillReceiveHeaderStartTiming()}setSession(t){this.sessionId=t}get isOutOfProcessIframe(){return this.sessionTargetType==="iframe"}_onResponse(t,n,r){this.url=t.url,this.connectionId=String(t.connectionId),this.connectionReused=t.connectionReused,t.protocol&&(this.protocol=t.protocol),this.responseHeadersEndTime=n*1e3,this.transferSize=t.encodedDataLength,
this.responseHeadersTransferSize=t.encodedDataLength,typeof t.fromDiskCache=="boolean"&&(this.fromDiskCache=t.fromDiskCache),typeof t.fromPrefetchCache=="boolean"&&(this.fromPrefetchCache=t.fromPrefetchCache),this.statusCode=t.status,this.timing=t.timing,r&&(this.resourceType=qf[r]),this.mimeType=t.mimeType,this.responseHeaders=e._headersDictToHeadersArray(t.headers),this.fetchedViaServiceWorker=!!t.fromServiceWorker,this.fromMemoryCache&&(this.timing=void 0),this.timing&&this._recomputeTimesWithResourceTiming(this.timing)}_recomputeTimesWithResourceTiming(t){if(t.requestTime===0||t.receiveHeadersEnd===-1)return;this.networkRequestTime=t.requestTime*1e3;let n=this.networkRequestTime+t.receiveHeadersEnd,r=this.responseHeadersEndTime;this.responseHeadersEndTime=n,this.responseHeadersEndTime=Math.min(this.responseHeadersEndTime,r),this.responseHeadersEndTime=Math.max(this.responseHeadersEndTime,this.networkRequestTime),this.networkEndTime=Math.max(this.networkEndTime,this.responseHeadersEndTime)}_updateResponseHeadersEndTimeIfNecessary(){
this.responseHeadersEndTime=Math.min(this.networkEndTime,this.responseHeadersEndTime)}_updateTransferSizeForLightrider(){if(!globalThis.isLightrider)return;let t=this.responseHeaders.find(r=>r.name===F3);if(!t)return;let n=parseFloat(t.value);isNaN(n)||(this.transferSize=n)}_updateProtocolForLightrider(){globalThis.isLightrider&&this.responseHeaders.some(t=>t.name===N3)&&(this.protocol="h2")}_backfillReceiveHeaderStartTiming(){!this.timing||this.timing.receiveHeadersStart!==void 0||(this.timing.receiveHeadersStart=this.timing.receiveHeadersEnd)}_updateTimingsForLightrider(){if(!globalThis.isLightrider)return;let t=this.responseHeaders.find(p=>p.name===I3);if(!t)return;let n=parseInt(t.value),r=this.responseHeaders.find(p=>p.name===k3),a=this.responseHeaders.find(p=>p.name===A3),i=this.responseHeaders.find(p=>p.name===R3),o=this.responseHeaders.find(p=>p.name===_3),c=r?Math.max(0,parseInt(r.value)):0,u=a?Math.max(0,parseInt(a.value)):0,l=i?Math.max(0,parseInt(i.value)):0,m=o?Math.max(0,
parseInt(o.value)):0;if(!Number.isNaN(c+l+m+n)){if(c+l+m!==n){if(Math.abs(c+l+m-n)>=25)return;n=c+l+m}u>c||(this.lrStatistics={endTimeDeltaMs:this.networkEndTime-(this.networkRequestTime+n),TCPMs:c,requestMs:l,responseMs:m})}}static getRequestIdForBackend(t){return t.replace(/(:redirect)+$/,"")}static _headersDictToHeadersArray(t){let n=[];for(let r of Object.keys(t)){let a=t[r].split(`
`);for(let i=0;i<a.length;++i)n.push({name:r,value:a[i]})}return n}static get TYPES(){return qf}static isNonNetworkRequest(t){return Q.isNonNetworkProtocol(t.protocol)||Q.isNonNetworkProtocol(t.parsedURL.scheme)}static isSecureRequest(t){return Q.isSecureScheme(t.parsedURL.scheme)||Q.isSecureScheme(t.protocol)||Q.isLikeLocalhost(t.parsedURL.host)||e.isHstsRequest(t)}static isHstsRequest(t){let n=t.redirectDestination;return n?t.responseHeaders.find(i=>i.name==="Non-Authoritative-Reason")?.value==="HSTS"&&e.isSecureRequest(n):!1}static isContentEncoded(t){let n=globalThis.isLightrider?[/^x-original-content-encoding$/i]:[/^content-encoding$/i,/^x-content-encoding-over-network$/i],r=["gzip","br","deflate"];return t.responseHeaders.some(a=>n.some(i=>a.name.match(i))&&r.includes(a.value))}static getResourceSizeOnNetwork(t){return Math.min(t.resourceSize||0,t.transferSize||1/0)}};V.HEADER_TCP=k3;V.HEADER_SSL=A3;V.HEADER_REQ=R3;V.HEADER_RES=_3;V.HEADER_TOTAL=I3;V.HEADER_FETCHED_SIZE=F3;V.HEADER_PROTOCOL_IS_H2=
N3});var pl,fl=v(()=>{"use strict";d();Yt();An();vt();pl=class e extends De{static{s(this,"NetworkNode")}constructor(t){super(t.requestId),this._record=t}get type(){return De.TYPES.NETWORK}get startTime(){return this._record.networkRequestTime*1e3}get endTime(){return this._record.networkEndTime*1e3}get record(){return this._record}get initiatorType(){return this._record.initiator&&this._record.initiator.type}get fromDiskCache(){return!!this._record.fromDiskCache}get isNonNetworkProtocol(){return V.isNonNetworkRequest(this._record)}get isConnectionless(){return this.fromDiskCache||this.isNonNetworkProtocol}hasRenderBlockingPriority(){let t=this._record.priority,n=this._record.resourceType===V.TYPES.Script,r=this._record.resourceType===V.TYPES.Document;return t==="VeryHigh"||t==="High"&&n||t==="High"&&r}cloneWithoutRelationships(){let t=new e(this._record);return t.setIsMainDocument(this._isMainDocument),t}}});var zf,hl=v(()=>{"use strict";d();Yt();An();zf=class e extends De{static{s(this,"CPUNode")}constructor(t,n=[]){let r=`${t.tid}.${t.ts}`;super(r),this._event=t,this._childEvents=n}get type(){return De.TYPES.CPU}get startTime(){return this._event.ts}get endTime(){return this._event.ts+this._event.dur}get event(){return this._event}get childEvents(){return this._childEvents}didPerformLayout(){return this._childEvents.some(t=>t.name==="Layout")}getEvaluateScriptURLs(){let t=new Set;for(let n of this._childEvents)n.name==="EvaluateScript"&&(!n.args.data||!n.args.data.url||t.add(n.args.data.url));return t}cloneWithoutRelationships(){return new e(this._event,this._childEvents)}}});var rb,gl,ab=v(()=>{"use strict";d();qt();jr();rb=class extends Kt{static{s(this,"LHTraceProcessor")}static createNoNavstartError(){return new G(G.errors.NO_NAVSTART)}static createNoResourceSendRequestError(){return new G(G.errors.NO_RESOURCE_REQUEST)}static createNoTracingStartedError(){return new G(G.errors.NO_TRACING_STARTED)}static createNoFirstContentfulPaintError(){return new G(G.errors.NO_FCP)}},gl=rb});var ib,Ae,Ot=v(()=>{"use strict";d();de();ab();ib=class{static{s(this,"ProcessedTrace")}static async compute_(t){return gl.processTrace(t)}},Ae=H(ib,null)});var ob,M3,L3=v(()=>{"use strict";d();wo();de();fe();Ot();ob=class{static{s(this,"DocumentUrls")}static async compute_(t,n){let r=await Ae.request(t.trace,n),a=await W.request(t.devtoolsLog,n),i=r.mainFrameInfo.frameId,o,c;for(let l of t.devtoolsLog)if(l.method==="Page.frameNavigated"&&l.params.frame.id===i){let{url:m}=l.params.frame;o||(o=m),c=m}if(!o||!c)throw new Error("No main frame navigations found");let u=Qt.findResourceForUrl(a,o);return u?.redirects?.length&&(o=u.redirects[0].url),{requestedUrl:o,mainDocumentUrl:c}}},M3=H(ob,["devtoolsLog","trace"])});var zne,Hne,sb,It,Yn=v(()=>{"use strict";d();de();fl();hl();jr();vt();Ot();fe();wo();L3();zne=10,Hne=/^video/,sb=class e{static{s(this,"PageDependencyGraph")}static getNetworkInitiators(t){if(!t.initiator)return[];if(t.initiator.url)return[t.initiator.url];if(t.initiator.type==="script"){let n=new Set,r=t.initiator.stack;for(;r;){let a=r.callFrames||[];for(let i of a)i.url&&n.add(i.url);r=r.parent}return Array.from(n)}return[]}static getNetworkNodeOutput(t){let n=[],r=new Map,a=new Map,i=new Map;return t.forEach(o=>{if(Hne.test(o.mimeType)||o.sessionTargetType==="worker")return;for(;r.has(o.requestId);)o.requestId+=":duplicate";let c=new pl(o);n.push(c);let u=a.get(o.url)||[];if(u.push(c),r.set(o.requestId,c),a.set(o.url,u),o.frameId&&o.resourceType===V.TYPES.Document&&o.documentURL===o.url){let l=i.has(o.frameId)?null:c;i.set(o.frameId,l)}}),{nodes:n,idToNodeMap:r,urlToNodeMap:a,frameIdToNodeMap:i}}static getCPUNodes({mainThreadEvents:t}){let n=[],r=0;for(Kt.assertHasToplevelEvents(t);r<
t.length;){let a=t[r];if(r++,!Kt.isScheduleableTask(a)||!a.dur)continue;let i=[];for(let o=a.ts+a.dur;r<t.length&&t[r].ts<o;r++)i.push(t[r]);n.push(new zf(a,i))}return n}static linkNetworkNodes(t,n){n.nodes.forEach(r=>{let a=r.record.initiatorRequest||t.record,i=n.idToNodeMap.get(a.requestId)||t,o=!i.isDependentOn(r)&&r.canDependOn(i),c=e.getNetworkInitiators(r.record);if(c.length?c.forEach(l=>{let m=n.urlToNodeMap.get(l)||[];m.length===1&&m[0].startTime<=r.startTime&&!m[0].isDependentOn(r)?r.addDependency(m[0]):o&&i.addDependent(r)}):o&&i.addDependent(r),r!==t&&r.getDependencies().length===0&&r.canDependOn(t)&&r.addDependency(t),!r.record.redirects)return;let u=[...r.record.redirects,r.record];for(let l=1;l<u.length;l++){let m=n.idToNodeMap.get(u[l-1].requestId),p=n.idToNodeMap.get(u[l].requestId);p&&m&&p.addDependency(m)}})}static linkCPUNodes(t,n,r){let a=new Set([V.TYPES.XHR,V.TYPES.Fetch,V.TYPES.Script]);function i(f,g){let b=n.idToNodeMap.get(g);if(!b||b.startTime<=f.startTime)return;
let{record:w}=b,E=w.resourceType||w.redirectDestination?.resourceType;a.has(E)&&f.addDependent(b)}s(i,"addDependentNetworkRequest");function o(f,g){if(!g)return;let b=n.frameIdToNodeMap.get(g);b&&(b.startTime>=f.startTime||f.addDependency(b))}s(o,"addDependencyOnFrame");function c(f,g){if(!g)return;let b=-100*1e3,w=n.urlToNodeMap.get(g)||[],E=null,x=1/0;for(let S of w){if(f.startTime<=S.startTime)return;let k=f.startTime-S.endTime;k>=b&&k<x&&(E=S,x=k)}E&&f.addDependency(E)}s(c,"addDependencyOnUrl");let u=new Map;for(let f of r){for(let g of f.childEvents){if(!g.args.data)continue;let b=g.args.data.url,w=(g.args.data.stackTrace||[]).map(E=>E.url).filter(Boolean);switch(g.name){case"TimerInstall":u.set(g.args.data.timerId,f),w.forEach(E=>c(f,E));break;case"TimerFire":{let E=u.get(g.args.data.timerId);if(!E||E.endTime>f.startTime)break;E.addDependent(f);break}case"InvalidateLayout":case"ScheduleStyleRecalculation":o(f,g.args.data.frame),w.forEach(E=>c(f,E));break;case"EvaluateScript":o(f,
g.args.data.frame),c(f,b),w.forEach(E=>c(f,E));break;case"XHRReadyStateChange":if(g.args.data.readyState!==4)break;c(f,b),w.forEach(E=>c(f,E));break;case"FunctionCall":case"v8.compile":o(f,g.args.data.frame),c(f,b);break;case"ParseAuthorStyleSheet":o(f,g.args.data.frame),c(f,g.args.data.styleSheetUrl);break;case"ResourceSendRequest":o(f,g.args.data.frame),i(f,g.args.data.requestId),w.forEach(E=>c(f,E));break}}f.getNumberOfDependencies()===0&&f.canDependOn(t)&&f.addDependency(t)}let l=zne*1e3,m=!1,p=!1,h=!1;for(let f of r){let g=!1;!m&&f.childEvents.some(b=>b.name==="Layout")&&(g=m=!0),!p&&f.childEvents.some(b=>b.name==="Paint")&&(g=p=!0),!h&&f.childEvents.some(b=>b.name==="ParseHTML")&&(g=h=!0),!(g||f.event.dur>=l)&&(f.getNumberOfDependencies()===1||f.getNumberOfDependents()<=1)&&e._pruneNode(f)}}static _pruneNode(t){let n=t.getDependencies(),r=t.getDependents();for(let a of n){t.removeDependency(a);for(let i of r)a.addDependent(i)}for(let a of r)t.removeDependent(a)}static createGraph(t,n,r){
let a=e.getNetworkNodeOutput(n),i=e.getCPUNodes(t),{requestedUrl:o,mainDocumentUrl:c}=r;if(!o)throw new Error("requestedUrl is required to get the root request");if(!c)throw new Error("mainDocumentUrl is required to get the main resource");let u=Qt.findResourceForUrl(n,o);if(!u)throw new Error("rootRequest not found");let l=a.idToNodeMap.get(u.requestId);if(!l)throw new Error("rootNode not found");let m=Qt.findLastDocumentForUrl(n,c);if(!m)throw new Error("mainDocumentRequest not found");let p=a.idToNodeMap.get(m.requestId);if(!p)throw new Error("mainDocumentNode not found");if(e.linkNetworkNodes(l,a),e.linkCPUNodes(l,a,i),p.setIsMainDocument(!0),pl.hasCycle(l))throw new Error("Invalid dependency graph created, cycle detected");return l}static printGraph(t,n=100){function r(l,m,p=" "){return l+p.repeat(Math.max(m-l.length,0))}s(r,"padRight");let a=[];t.traverse(l=>a.push(l)),a.sort((l,m)=>l.startTime-m.startTime);let i=a[0].startTime,u=(a.reduce((l,m)=>Math.max(l,m.endTime),0)-i)/n;a.forEach(
l=>{let m=Math.round((l.startTime-i)/u),p=Math.ceil((l.endTime-l.startTime)/u),h=r("",m)+r("",p,"="),f=l.record?l.record.url:l.type;console.log(r(h,n),`| ${f.slice(0,30)}`)})}static async compute_(t,n){let{trace:r,devtoolsLog:a}=t,[i,o]=await Promise.all([Ae.request(r,n),W.request(a,n)]),c=t.URL||await M3.request(t,n);return e.createGraph(i,o,c)}},It=H(sb,["devtoolsLog","trace","URL"])});var Gne,qs,cb=v(()=>{"use strict";d();wa();Pe();Yt();vt();Yn();Gne=Ve,qs=class e extends Gne{static{s(this,"NetworkRecorder")}constructor(){super(),this._records=[],this._recordsById=new Map}getRawRecords(){return Array.from(this._records)}onRequestStarted(t){this._records.push(t),this._recordsById.set(t.requestId,t),this.emit("requeststarted",t)}onRequestFinished(t){this.emit("requestfinished",t)}onRequestWillBeSent(t){let n=t.params,r=this._findRealRequestAndSetSession(n.requestId,t.targetType,t.sessionId);if(!r){let o=new V;o.onRequestWillBeSent(n),o.sessionId=t.sessionId,o.sessionTargetType=t.targetType,this.onRequestStarted(o),F.verbose("network",`request will be sent to ${o.url}`);return}if(!n.redirectResponse)return;let a={...n,initiator:r.initiator,requestId:`${r.requestId}:redirect`},i=new V;i.onRequestWillBeSent(a),r.onRedirectResponse(n),F.verbose("network",`${r.url} redirected to ${i.url}`),r.redirectDestination=i,i.redirectSource=r,this.onRequestStarted(i),this.onRequestFinished(
r)}onRequestServedFromCache(t){let n=t.params,r=this._findRealRequestAndSetSession(n.requestId,t.targetType,t.sessionId);r&&(F.verbose("network",`${r.url} served from cache`),r.onRequestServedFromCache())}onResponseReceived(t){let n=t.params,r=this._findRealRequestAndSetSession(n.requestId,t.targetType,t.sessionId);r&&(F.verbose("network",`${r.url} response received`),r.onResponseReceived(n))}onResponseReceivedExtraInfo(t){let n=t.params,r=this._findRealRequestAndSetSession(n.requestId,t.targetType,t.sessionId);r&&(F.verbose("network",`${r.url} response received extra info`),r.onResponseReceivedExtraInfo(n))}onDataReceived(t){let n=t.params,r=this._findRealRequestAndSetSession(n.requestId,t.targetType,t.sessionId);r&&(F.verbose("network",`${r.url} data received`),r.onDataReceived(n))}onLoadingFinished(t){let n=t.params,r=this._findRealRequestAndSetSession(n.requestId,t.targetType,t.sessionId);r&&(F.verbose("network",`${r.url} loading finished`),r.onLoadingFinished(n),this.onRequestFinished(
r))}onLoadingFailed(t){let n=t.params,r=this._findRealRequestAndSetSession(n.requestId,t.targetType,t.sessionId);r&&(F.verbose("network",`${r.url} loading failed`),r.onLoadingFailed(n),this.onRequestFinished(r))}onResourceChangedPriority(t){let n=t.params,r=this._findRealRequestAndSetSession(n.requestId,t.targetType,t.sessionId);r&&r.onResourceChangedPriority(n)}dispatch(t){switch(t.method){case"Network.requestWillBeSent":return this.onRequestWillBeSent(t);case"Network.requestServedFromCache":return this.onRequestServedFromCache(t);case"Network.responseReceived":return this.onResponseReceived(t);case"Network.responseReceivedExtraInfo":return this.onResponseReceivedExtraInfo(t);case"Network.dataReceived":return this.onDataReceived(t);case"Network.loadingFinished":return this.onLoadingFinished(t);case"Network.loadingFailed":return this.onLoadingFailed(t);case"Network.resourceChangedPriority":return this.onResourceChangedPriority(t);default:return}}_findRealRequestAndSetSession(t,n,r){let a=this.
_recordsById.get(t);if(!(!a||!a.isValid)){for(;a.redirectDestination;)a=a.redirectDestination;return a.setSession(r),a.sessionTargetType=n,a}}static _chooseInitiatorRequest(t,n){if(t.redirectSource)return t.redirectSource;let r=It.getNetworkInitiators(t)[0],a=n.get(r)||[];if(a=a.filter(i=>i.responseHeadersEndTime<=t.networkRequestTime&&i.finished&&!i.failed),a.length>1){let i=a.filter(o=>o.resourceType!==V.TYPES.Other);i.length&&(a=i)}if(a.length>1){let i=a.filter(o=>o.frameId===t.frameId);i.length&&(a=i)}if(a.length>1&&t.initiator.type==="parser"){let i=a.filter(o=>o.resourceType===V.TYPES.Document);i.length&&(a=i)}if(a.length>1){let i=a.filter(o=>o.isLinkPreload);if(i.length){let o=a.filter(u=>!u.isLinkPreload),c=o.every(u=>u.fromDiskCache||u.fromMemoryCache);o.length&&c&&(a=i)}}return a.length===1?a[0]:null}static recordsFromLogs(t){let n=new e;t.forEach(i=>n.dispatch(i));let r=n.getRawRecords().filter(i=>i.isValid),a=new Map;for(let i of r){let o=a.get(i.url)||[];o.push(i),a.set(i.
url,o)}for(let i of r){let o=e._chooseInitiatorRequest(i,a);o&&i.setInitiatorRequest(o);let c=i;for(;c.redirectDestination;)c=c.redirectDestination;if(c===i||c.redirects)continue;let u=[];for(let l=c.redirectSource;l;l=l.redirectSource)u.unshift(l);c.redirects=u}return r}}});var ub,W,fe=v(()=>{"use strict";d();Yt();de();cb();ub=class{static{s(this,"NetworkRecords")}static async compute_(t){return qs.recordsFromLogs(t)}},W=H(ub,null)});var lb,Tr,Do=v(()=>{"use strict";d();de();wo();fe();lb=class e{static{s(this,"NetworkAnalysis")}static computeRTTAndServerResponseTime(t){let n=new Map;for(let[c,u]of Qt.estimateRTTByOrigin(t).entries())n.set(c,u.min);let r=Math.min(...Array.from(n.values())),a=Qt.estimateServerResponseTimeByOrigin(t,{rttByOrigin:n}),i=new Map,o=new Map;for(let[c,u]of a.entries()){let l=n.get(c)||r;i.set(c,l-r),o.set(c,u.median)}return{rtt:r,additionalRttByOrigin:i,serverResponseTimeByOrigin:o}}static async compute_(t,n){let r=await W.request(t,n),a=Qt.estimateThroughput(r),i=e.computeRTTAndServerResponseTime(r);return{throughput:a,...i}}},Tr=H(lb,null)});var db,Gt,or=v(()=>{"use strict";d();de();ar();nb();Do();db=class{static{s(this,"LoadSimulator")}static async compute_(t,n){let{throttlingMethod:r,throttling:a,precomputedLanternData:i}=t.settings,o=await Tr.request(t.devtoolsLog,n),c={additionalRttByOrigin:o.additionalRttByOrigin,serverResponseTimeByOrigin:o.serverResponseTimeByOrigin,observedThroughput:o.throughput};switch(i&&(c.additionalRttByOrigin=new Map(Object.entries(i.additionalRttByOrigin)),c.serverResponseTimeByOrigin=new Map(Object.entries(i.serverResponseTimeByOrigin))),r){case"provided":c.rtt=o.rtt,c.throughput=o.throughput,c.cpuSlowdownMultiplier=1,c.layoutTaskMultiplier=1;break;case"devtools":a&&(c.rtt=a.requestLatencyMs/$n.DEVTOOLS_RTT_ADJUSTMENT_FACTOR,c.throughput=a.downloadThroughputKbps*1024/$n.DEVTOOLS_THROUGHPUT_ADJUSTMENT_FACTOR),c.cpuSlowdownMultiplier=1,c.layoutTaskMultiplier=1;break;case"simulate":a&&(c.rtt=a.rttMs,c.throughput=a.throughputKbps*1024,c.cpuSlowdownMultiplier=a.cpuSlowdownMultiplier);break;default:
break}return new ml(c)}static convertAnalysisToSaveableLanternData(t){let n={additionalRttByOrigin:{},serverResponseTimeByOrigin:{}};for(let[r,a]of t.additionalRttByOrigin.entries())r.startsWith("http")&&(n.additionalRttByOrigin[r]=a);for(let[r,a]of t.serverResponseTimeByOrigin.entries())r.startsWith("http")&&(n.serverResponseTimeByOrigin[r]=a);return n}},Gt=H(db,["devtoolsLog","settings"])});function B3(e){if(F.log("Reading artifacts from disk:",e),!Un.existsSync(e))throw new Error("No saved artifacts found at "+e);let t=Un.readFileSync(Rt.join(e,mb),"utf8"),n=JSON.parse(t,G.parseReviver),r=Un.readdirSync(e);return r.filter(a=>a.endsWith(vl)).forEach(a=>{n.devtoolsLogs||(n.devtoolsLogs={});let i=a.replace(vl,""),o=JSON.parse(Un.readFileSync(Rt.join(e,a),"utf8"));n.devtoolsLogs[i]=o,i===Hf&&(n.DevtoolsLog=o),i===Gf&&(n.DevtoolsLogError=o)}),r.filter(a=>a.endsWith(yl)).forEach(a=>{n.traces||(n.traces={});let i=Un.readFileSync(Rt.join(e,a),{encoding:"utf-8"}),o=JSON.parse(i),c=a.replace(yl,"");n.traces[c]=Array.isArray(o)?{traceEvents:o}:o,c===Hf&&(n.Trace=n.traces[c]),c===Gf&&(n.TraceError=n.traces[c])}),Array.isArray(n.Timing)&&n.Timing.forEach(a=>a.gather=!0),n}function Wne(e,t){return t instanceof Error?G.stringifyReplacer(t):t}async function U3(e,t){let n={msg:"Saving artifacts",id:"lh:assetSaver:saveArtifacts"};F.time(n),Un.mkdirSync(t,{recursive:!0});let r=Un.readdirSync(
t);for(let h of r)(h.endsWith(yl)||h.endsWith(vl)||h===mb)&&Un.unlinkSync(`${t}/${h}`);let{traces:a,devtoolsLogs:i,DevtoolsLog:o,Trace:c,DevtoolsLogError:u,TraceError:l,...m}=e;c&&await P3(c,`${t}/${Hf}${yl}`),l&&await P3(l,`${t}/${Gf}${yl}`),o&&await O3(o,`${t}/${Hf}${vl}`),u&&await O3(u,`${t}/${Gf}${vl}`);let p=JSON.stringify(m,Wne,2)+`
`;Un.writeFileSync(`${t}/${mb}`,p,"utf8"),F.log("Artifacts saved to disk in folder:",t),F.timeEnd(n)}function j3(e,t){Un.writeFileSync(`${t}/lhr.report.json`,JSON.stringify(e,null,2))}function*q3(e){if(yield`[
`,e.length>0){let n=e[Symbol.iterator](),r=n.next().value;yield`  ${JSON.stringify(r)}`;let a=500,i="";for(let o of n)i+=`,
  ${JSON.stringify(o)}`,a--,a===0&&(yield i,a=500,i="");yield i}yield`
]`}function*Vne(e){let{traceEvents:t,...n}=e;yield`{
`,yield'"traceEvents": ',yield*q3(t);for(let[r,a]of Object.entries(n))yield`,
"${r}": ${JSON.stringify(a,null,2)}`;yield`}
`}async function P3(e,t){let n=Vne(e),r=Un.createWriteStream(t);return qv.promises.pipeline(n,r)}function O3(e,t){let n=Un.createWriteStream(t);return qv.promises.pipeline(function*(){yield*q3(e),yield`
`},n)}var mb,yl,vl,Hf,Gf,z3=v(()=>{"use strict";d();Da();ri();zv();cl();Pe();nb();T3();x3();Do();or();qt();Ls();mb="artifacts.json",yl=".trace.json",vl=".devtoolslog.json",Hf="defaultPass",Gf="pageLoadError-defaultPass";s(B3,"loadArtifacts");s(Wne,"stringifyReplacer");s(U3,"saveArtifacts");s(j3,"saveLhr");s(q3,"arrayOfObjectsJsonGenerator");s(Vne,"traceJsonGenerator");s(P3,"saveTrace");s(O3,"saveDevtoolsLog")});var H3,Yne,Kne,Xne,Jne,zs,G3=v(()=>{"use strict";d();H3=["server-response-time","render-blocking-resources","redirects","critical-request-chains","uses-text-compression","uses-rel-preconnect","uses-rel-preload","font-display","unminified-javascript","unminified-css","unused-css-rules"],Yne=[...H3,"largest-contentful-paint-element","prioritize-lcp-image","unused-javascript","efficient-animated-content","total-byte-weight","lcp-lazy-loaded"],Kne=["long-tasks","third-party-summary","third-party-facades","bootup-time","mainthread-work-breakdown","dom-size","duplicated-javascript","legacy-javascript","viewport"],Xne=["layout-shift-elements","layout-shifts","non-composited-animations","unsized-images"],Jne=["work-during-interaction"],zs={fcpRelevantAudits:H3,lcpRelevantAudits:Yne,tbtRelevantAudits:Kne,clsRelevantAudits:Xne,inpRelevantAudits:Jne}});var ye,Ee,W3,Wf,pb=v(()=>{"use strict";d();Yt();ar();R();G3();ye={performanceCategoryTitle:"Performance",budgetsGroupTitle:"Budgets",budgetsGroupDescription:"Performance budgets set standards for the performance of your site.",metricGroupTitle:"Metrics",loadOpportunitiesGroupTitle:"Opportunities",loadOpportunitiesGroupDescription:"These suggestions can help your page load faster. They don't [directly affect](https://developer.chrome.com/docs/lighthouse/performance/performance-scoring/) the Performance score.",firstPaintImprovementsGroupTitle:"First Paint Improvements",firstPaintImprovementsGroupDescription:"The most critical aspect of performance is how quickly pixels are rendered onscreen. Key metrics: First Contentful Paint, First Meaningful Paint",overallImprovementsGroupTitle:"Overall Improvements",overallImprovementsGroupDescription:"Enhance the overall loading experience, so the page is responsive and ready to use as soon as possible. Key metrics: Time to Interactive, Speed Index",
diagnosticsGroupTitle:"Diagnostics",diagnosticsGroupDescription:"More information about the performance of your application. These numbers don't [directly affect](https://developer.chrome.com/docs/lighthouse/performance/performance-scoring/) the Performance score.",a11yCategoryTitle:"Accessibility",a11yCategoryDescription:"These checks highlight opportunities to [improve the accessibility of your web app](https://developer.chrome.com/docs/lighthouse/accessibility/). Automatic detection can only detect a subset of issues and does not guarantee the accessibility of your web app, so [manual testing](https://web.dev/articles/how-to-review) is also encouraged.",a11yCategoryManualDescription:"These items address areas which an automated testing tool cannot cover. Learn more in our guide on [conducting an accessibility review](https://web.dev/articles/how-to-review).",a11yBestPracticesGroupTitle:"Best practices",a11yBestPracticesGroupDescription:"These items highlight common accessibility bes\
t practices.",a11yColorContrastGroupTitle:"Contrast",a11yColorContrastGroupDescription:"These are opportunities to improve the legibility of your content.",a11yNamesLabelsGroupTitle:"Names and labels",a11yNamesLabelsGroupDescription:"These are opportunities to improve the semantics of the controls in your application. This may enhance the experience for users of assistive technology, like a screen reader.",a11yNavigationGroupTitle:"Navigation",a11yNavigationGroupDescription:"These are opportunities to improve keyboard navigation in your application.",a11yAriaGroupTitle:"ARIA",a11yAriaGroupDescription:"These are opportunities to improve the usage of ARIA in your application which may enhance the experience for users of assistive technology, like a screen reader.",a11yLanguageGroupTitle:"Internationalization and localization",a11yLanguageGroupDescription:"These are opportunities to improve the interpretation of your content by users in different locales.",a11yAudioVideoGroupTitle:"Audio \
and video",a11yAudioVideoGroupDescription:"These are opportunities to provide alternative content for audio and video. This may improve the experience for users with hearing or vision impairments.",a11yTablesListsVideoGroupTitle:"Tables and lists",a11yTablesListsVideoGroupDescription:"These are opportunities to improve the experience of reading tabular or list data using assistive technology, like a screen reader.",seoCategoryTitle:"SEO",seoCategoryDescription:"These checks ensure that your page is following basic search engine optimization advice. There are many additional factors Lighthouse does not score here that may affect your search ranking, including performance on [Core Web Vitals](https://web.dev/explore/vitals). [Learn more about Google Search Essentials](https://support.google.com/webmasters/answer/35769).",seoCategoryManualDescription:"Run these additional validators on your site to check additional SEO best practices.",seoMobileGroupTitle:"Mobile Friendly",seoMobileGroupDescription:"\
Make sure your pages are mobile friendly so users don’t have to pinch or zoom in order to read the content pages. [Learn how to make pages mobile-friendly](https://developers.google.com/search/mobile-sites/).",seoContentGroupTitle:"Content Best Practices",seoContentGroupDescription:"Format your HTML in a way that enables crawlers to better understand your app’s content.",seoCrawlingGroupTitle:"Crawling and Indexing",seoCrawlingGroupDescription:"To appear in search results, crawlers need access to your app.",pwaCategoryTitle:"PWA",pwaCategoryDescription:"These checks validate the aspects of a Progressive Web App. [Learn what makes a good Progressive Web App](https://web.dev/articles/pwa-checklist).",pwaCategoryManualDescription:"These checks are required by the baseline [PWA Checklist](https://web.dev/articles/pwa-checklist) but are not automatically checked by Lighthouse. They do not affect your score but it's important that you verify them manually.",bestPracticesCategoryTitle:"Be\
st Practices",bestPracticesTrustSafetyGroupTitle:"Trust and Safety",bestPracticesUXGroupTitle:"User Experience",bestPracticesBrowserCompatGroupTitle:"Browser Compatibility",bestPracticesGeneralGroupTitle:"General",pwaInstallableGroupTitle:"Installable",pwaOptimizedGroupTitle:"PWA Optimized"},Ee=D("core/config/default-config.js",ye),W3={settings:rr,artifacts:[{id:"DevtoolsLog",gatherer:"devtools-log"},{id:"Trace",gatherer:"trace"},{id:"RootCauses",gatherer:"root-causes"},{id:"Accessibility",gatherer:"accessibility"},{id:"AnchorElements",gatherer:"anchor-elements"},{id:"CacheContents",gatherer:"cache-contents"},{id:"ConsoleMessages",gatherer:"console-messages"},{id:"CSSUsage",gatherer:"css-usage"},{id:"Doctype",gatherer:"dobetterweb/doctype"},{id:"DOMStats",gatherer:"dobetterweb/domstats"},{id:"EmbeddedContent",gatherer:"seo/embedded-content"},{id:"FontSize",gatherer:"seo/font-size"},{id:"Inputs",gatherer:"inputs"},{id:"GlobalListeners",gatherer:"global-listeners"},{id:"IFrameElements",gatherer:"\
iframe-elements"},{id:"ImageElements",gatherer:"image-elements"},{id:"InstallabilityErrors",gatherer:"installability-errors"},{id:"InspectorIssues",gatherer:"inspector-issues"},{id:"JsUsage",gatherer:"js-usage"},{id:"LinkElements",gatherer:"link-elements"},{id:"MainDocumentContent",gatherer:"main-document-content"},{id:"MetaElements",gatherer:"meta-elements"},{id:"NetworkUserAgent",gatherer:"network-user-agent"},{id:"OptimizedImages",gatherer:"dobetterweb/optimized-images"},{id:"ResponseCompression",gatherer:"dobetterweb/response-compression"},{id:"RobotsTxt",gatherer:"seo/robots-txt"},{id:"ServiceWorker",gatherer:"service-worker"},{id:"ScriptElements",gatherer:"script-elements"},{id:"Scripts",gatherer:"scripts"},{id:"SourceMaps",gatherer:"source-maps"},{id:"Stacks",gatherer:"stacks"},{id:"TagsBlockingFirstPaint",gatherer:"dobetterweb/tags-blocking-first-paint"},{id:"TapTargets",gatherer:"seo/tap-targets"},{id:"TraceElements",gatherer:"trace-elements"},{id:"ViewportDimensions",gatherer:"\
viewport-dimensions"},{id:"WebAppManifest",gatherer:"web-app-manifest"},{id:"devtoolsLogs",gatherer:"devtools-log-compat"},{id:"traces",gatherer:"trace-compat"},{id:"FullPageScreenshot",gatherer:"full-page-screenshot"},{id:"BFCacheFailures",gatherer:"bf-cache-failures"}],audits:["is-on-https","viewport","metrics/first-contentful-paint","metrics/largest-contentful-paint","metrics/first-meaningful-paint","metrics/speed-index","screenshot-thumbnails","final-screenshot","metrics/total-blocking-time","metrics/max-potential-fid","metrics/cumulative-layout-shift","metrics/interaction-to-next-paint","errors-in-console","server-response-time","metrics/interactive","user-timings","critical-request-chains","redirects","installable-manifest","splash-screen","themed-omnibox","maskable-icon","content-width","image-aspect-ratio","image-size-responsive","preload-fonts","deprecations","third-party-cookies","mainthread-work-breakdown","bootup-time","uses-rel-preload","uses-rel-preconnect","font-display",
"diagnostics","network-requests","network-rtt","network-server-latency","main-thread-tasks","metrics","performance-budget","timing-budget","resource-summary","third-party-summary","third-party-facades","largest-contentful-paint-element","lcp-lazy-loaded","layout-shift-elements","layout-shifts","long-tasks","no-unload-listeners","non-composited-animations","unsized-images","valid-source-maps","prioritize-lcp-image","csp-xss","script-treemap-data","manual/pwa-cross-browser","manual/pwa-page-transitions","manual/pwa-each-page-has-url","accessibility/accesskeys","accessibility/aria-allowed-attr","accessibility/aria-allowed-role","accessibility/aria-command-name","accessibility/aria-dialog-name","accessibility/aria-hidden-body","accessibility/aria-hidden-focus","accessibility/aria-input-field-name","accessibility/aria-meter-name","accessibility/aria-progressbar-name","accessibility/aria-required-attr","accessibility/aria-required-children","accessibility/aria-required-parent","accessibility\
/aria-roles","accessibility/aria-text","accessibility/aria-toggle-field-name","accessibility/aria-tooltip-name","accessibility/aria-treeitem-name","accessibility/aria-valid-attr-value","accessibility/aria-valid-attr","accessibility/button-name","accessibility/bypass","accessibility/color-contrast","accessibility/definition-list","accessibility/dlitem","accessibility/document-title","accessibility/duplicate-id-active","accessibility/duplicate-id-aria","accessibility/empty-heading","accessibility/form-field-multiple-labels","accessibility/frame-title","accessibility/heading-order","accessibility/html-has-lang","accessibility/html-lang-valid","accessibility/html-xml-lang-mismatch","accessibility/identical-links-same-purpose","accessibility/image-alt","accessibility/image-redundant-alt","accessibility/input-button-name","accessibility/input-image-alt","accessibility/label-content-name-mismatch","accessibility/label","accessibility/landmark-one-main","accessibility/link-name","accessibility\
/link-in-text-block","accessibility/list","accessibility/listitem","accessibility/meta-refresh","accessibility/meta-viewport","accessibility/object-alt","accessibility/select-name","accessibility/skip-link","accessibility/tabindex","accessibility/table-duplicate-name","accessibility/table-fake-caption","accessibility/target-size","accessibility/td-has-header","accessibility/td-headers-attr","accessibility/th-has-data-cells","accessibility/valid-lang","accessibility/video-caption","accessibility/manual/custom-controls-labels","accessibility/manual/custom-controls-roles","accessibility/manual/focus-traps","accessibility/manual/focusable-controls","accessibility/manual/interactive-element-affordance","accessibility/manual/logical-tab-order","accessibility/manual/managed-focus","accessibility/manual/offscreen-content-hidden","accessibility/manual/use-landmarks","accessibility/manual/visual-order-follows-dom","byte-efficiency/uses-long-cache-ttl","byte-efficiency/total-byte-weight","byte-ef\
ficiency/offscreen-images","byte-efficiency/render-blocking-resources","byte-efficiency/unminified-css","byte-efficiency/unminified-javascript","byte-efficiency/unused-css-rules","byte-efficiency/unused-javascript","byte-efficiency/modern-image-formats","byte-efficiency/uses-optimized-images","byte-efficiency/uses-text-compression","byte-efficiency/uses-responsive-images","byte-efficiency/efficient-animated-content","byte-efficiency/duplicated-javascript","byte-efficiency/legacy-javascript","byte-efficiency/uses-responsive-images-snapshot","dobetterweb/doctype","dobetterweb/charset","dobetterweb/dom-size","dobetterweb/geolocation-on-start","dobetterweb/inspector-issues","dobetterweb/no-document-write","dobetterweb/js-libraries","dobetterweb/notification-on-start","dobetterweb/paste-preventing-inputs","dobetterweb/uses-http2","dobetterweb/uses-passive-event-listeners","seo/meta-description","seo/http-status-code","seo/font-size","seo/link-text","seo/crawlable-anchors","seo/is-crawlable",
"seo/robots-txt","seo/tap-targets","seo/hreflang","seo/plugins","seo/canonical","seo/manual/structured-data","work-during-interaction","bf-cache"],groups:{metrics:{title:Ee(ye.metricGroupTitle)},"load-opportunities":{title:Ee(ye.loadOpportunitiesGroupTitle),description:Ee(ye.loadOpportunitiesGroupDescription)},budgets:{title:Ee(ye.budgetsGroupTitle),description:Ee(ye.budgetsGroupDescription)},diagnostics:{title:Ee(ye.diagnosticsGroupTitle),description:Ee(ye.diagnosticsGroupDescription)},"pwa-installable":{title:Ee(ye.pwaInstallableGroupTitle)},"pwa-optimized":{title:Ee(ye.pwaOptimizedGroupTitle)},"a11y-best-practices":{title:Ee(ye.a11yBestPracticesGroupTitle),description:Ee(ye.a11yBestPracticesGroupDescription)},"a11y-color-contrast":{title:Ee(ye.a11yColorContrastGroupTitle),description:Ee(ye.a11yColorContrastGroupDescription)},"a11y-names-labels":{title:Ee(ye.a11yNamesLabelsGroupTitle),description:Ee(ye.a11yNamesLabelsGroupDescription)},"a11y-navigation":{title:Ee(ye.a11yNavigationGroupTitle),
description:Ee(ye.a11yNavigationGroupDescription)},"a11y-aria":{title:Ee(ye.a11yAriaGroupTitle),description:Ee(ye.a11yAriaGroupDescription)},"a11y-language":{title:Ee(ye.a11yLanguageGroupTitle),description:Ee(ye.a11yLanguageGroupDescription)},"a11y-audio-video":{title:Ee(ye.a11yAudioVideoGroupTitle),description:Ee(ye.a11yAudioVideoGroupDescription)},"a11y-tables-lists":{title:Ee(ye.a11yTablesListsVideoGroupTitle),description:Ee(ye.a11yTablesListsVideoGroupDescription)},"seo-mobile":{title:Ee(ye.seoMobileGroupTitle),description:Ee(ye.seoMobileGroupDescription)},"seo-content":{title:Ee(ye.seoContentGroupTitle),description:Ee(ye.seoContentGroupDescription)},"seo-crawl":{title:Ee(ye.seoCrawlingGroupTitle),description:Ee(ye.seoCrawlingGroupDescription)},"best-practices-trust-safety":{title:Ee(ye.bestPracticesTrustSafetyGroupTitle)},"best-practices-ux":{title:Ee(ye.bestPracticesUXGroupTitle)},"best-practices-browser-compat":{title:Ee(ye.bestPracticesBrowserCompatGroupTitle)},"best-practices-\
general":{title:Ee(ye.bestPracticesGeneralGroupTitle)},hidden:{title:""}},categories:{performance:{title:Ee(ye.performanceCategoryTitle),supportedModes:["navigation","timespan","snapshot"],auditRefs:[{id:"first-contentful-paint",weight:10,group:"metrics",acronym:"FCP",relevantAudits:zs.fcpRelevantAudits},{id:"largest-contentful-paint",weight:25,group:"metrics",acronym:"LCP",relevantAudits:zs.lcpRelevantAudits},{id:"total-blocking-time",weight:30,group:"metrics",acronym:"TBT",relevantAudits:zs.tbtRelevantAudits},{id:"cumulative-layout-shift",weight:25,group:"metrics",acronym:"CLS",relevantAudits:zs.clsRelevantAudits},{id:"speed-index",weight:10,group:"metrics",acronym:"SI"},{id:"interaction-to-next-paint",weight:0,group:"metrics",acronym:"INP",relevantAudits:zs.inpRelevantAudits},{id:"interactive",weight:0,group:"hidden",acronym:"TTI"},{id:"max-potential-fid",weight:0,group:"hidden"},{id:"first-meaningful-paint",weight:0,acronym:"FMP",group:"hidden"},{id:"render-blocking-resources",weight:0},
{id:"uses-responsive-images",weight:0},{id:"offscreen-images",weight:0},{id:"unminified-css",weight:0},{id:"unminified-javascript",weight:0},{id:"unused-css-rules",weight:0},{id:"unused-javascript",weight:0},{id:"uses-optimized-images",weight:0},{id:"modern-image-formats",weight:0},{id:"uses-text-compression",weight:0},{id:"uses-rel-preconnect",weight:0},{id:"server-response-time",weight:0},{id:"redirects",weight:0},{id:"uses-rel-preload",weight:0},{id:"uses-http2",weight:0},{id:"efficient-animated-content",weight:0},{id:"duplicated-javascript",weight:0},{id:"legacy-javascript",weight:0},{id:"prioritize-lcp-image",weight:0},{id:"total-byte-weight",weight:0},{id:"uses-long-cache-ttl",weight:0},{id:"dom-size",weight:0},{id:"critical-request-chains",weight:0},{id:"user-timings",weight:0},{id:"bootup-time",weight:0},{id:"mainthread-work-breakdown",weight:0},{id:"font-display",weight:0},{id:"third-party-summary",weight:0},{id:"third-party-facades",weight:0},{id:"largest-contentful-paint-ele\
ment",weight:0},{id:"lcp-lazy-loaded",weight:0},{id:"layout-shifts",weight:0},{id:"uses-passive-event-listeners",weight:0},{id:"no-document-write",weight:0},{id:"long-tasks",weight:0},{id:"non-composited-animations",weight:0},{id:"unsized-images",weight:0},{id:"viewport",weight:0},{id:"uses-responsive-images-snapshot",weight:0},{id:"work-during-interaction",weight:0},{id:"bf-cache",weight:0},{id:"performance-budget",weight:0,group:"budgets"},{id:"timing-budget",weight:0,group:"budgets"},{id:"network-requests",weight:0,group:"hidden"},{id:"network-rtt",weight:0,group:"hidden"},{id:"network-server-latency",weight:0,group:"hidden"},{id:"main-thread-tasks",weight:0,group:"hidden"},{id:"diagnostics",weight:0,group:"hidden"},{id:"metrics",weight:0,group:"hidden"},{id:"screenshot-thumbnails",weight:0,group:"hidden"},{id:"final-screenshot",weight:0,group:"hidden"},{id:"script-treemap-data",weight:0,group:"hidden"},{id:"resource-summary",weight:0,group:"hidden"},{id:"layout-shift-elements",weight:0,
group:"hidden"}]},accessibility:{title:Ee(ye.a11yCategoryTitle),description:Ee(ye.a11yCategoryDescription),manualDescription:Ee(ye.a11yCategoryManualDescription),supportedModes:["navigation","snapshot"],auditRefs:[{id:"accesskeys",weight:7,group:"a11y-navigation"},{id:"aria-allowed-attr",weight:10,group:"a11y-aria"},{id:"aria-allowed-role",weight:1,group:"a11y-aria"},{id:"aria-command-name",weight:7,group:"a11y-aria"},{id:"aria-dialog-name",weight:7,group:"a11y-aria"},{id:"aria-hidden-body",weight:10,group:"a11y-aria"},{id:"aria-hidden-focus",weight:7,group:"a11y-aria"},{id:"aria-input-field-name",weight:7,group:"a11y-aria"},{id:"aria-meter-name",weight:7,group:"a11y-aria"},{id:"aria-progressbar-name",weight:7,group:"a11y-aria"},{id:"aria-required-attr",weight:10,group:"a11y-aria"},{id:"aria-required-children",weight:10,group:"a11y-aria"},{id:"aria-required-parent",weight:10,group:"a11y-aria"},{id:"aria-roles",weight:7,group:"a11y-aria"},{id:"aria-text",weight:7,group:"a11y-aria"},{id:"\
aria-toggle-field-name",weight:7,group:"a11y-aria"},{id:"aria-tooltip-name",weight:7,group:"a11y-aria"},{id:"aria-treeitem-name",weight:7,group:"a11y-aria"},{id:"aria-valid-attr-value",weight:10,group:"a11y-aria"},{id:"aria-valid-attr",weight:10,group:"a11y-aria"},{id:"button-name",weight:10,group:"a11y-names-labels"},{id:"bypass",weight:7,group:"a11y-navigation"},{id:"color-contrast",weight:7,group:"a11y-color-contrast"},{id:"definition-list",weight:7,group:"a11y-tables-lists"},{id:"dlitem",weight:7,group:"a11y-tables-lists"},{id:"document-title",weight:7,group:"a11y-names-labels"},{id:"duplicate-id-active",weight:7,group:"a11y-navigation"},{id:"duplicate-id-aria",weight:10,group:"a11y-aria"},{id:"form-field-multiple-labels",weight:3,group:"a11y-names-labels"},{id:"frame-title",weight:7,group:"a11y-names-labels"},{id:"heading-order",weight:3,group:"a11y-navigation"},{id:"html-has-lang",weight:7,group:"a11y-language"},{id:"html-lang-valid",weight:7,group:"a11y-language"},{id:"html-xml-\
lang-mismatch",weight:3,group:"a11y-language"},{id:"image-alt",weight:10,group:"a11y-names-labels"},{id:"image-redundant-alt",weight:1,group:"a11y-names-labels"},{id:"input-button-name",weight:10,group:"a11y-names-labels"},{id:"input-image-alt",weight:10,group:"a11y-names-labels"},{id:"label",weight:7,group:"a11y-names-labels"},{id:"link-in-text-block",weight:7,group:"a11y-color-contrast"},{id:"link-name",weight:7,group:"a11y-names-labels"},{id:"list",weight:7,group:"a11y-tables-lists"},{id:"listitem",weight:7,group:"a11y-tables-lists"},{id:"meta-refresh",weight:10,group:"a11y-best-practices"},{id:"meta-viewport",weight:10,group:"a11y-best-practices"},{id:"object-alt",weight:7,group:"a11y-names-labels"},{id:"select-name",weight:7,group:"a11y-names-labels"},{id:"skip-link",weight:3,group:"a11y-names-labels"},{id:"tabindex",weight:7,group:"a11y-navigation"},{id:"table-duplicate-name",weight:1,group:"a11y-tables-lists"},{id:"td-headers-attr",weight:7,group:"a11y-tables-lists"},{id:"th-has\
-data-cells",weight:7,group:"a11y-tables-lists"},{id:"valid-lang",weight:7,group:"a11y-language"},{id:"video-caption",weight:10,group:"a11y-audio-video"},{id:"focusable-controls",weight:0},{id:"interactive-element-affordance",weight:0},{id:"logical-tab-order",weight:0},{id:"visual-order-follows-dom",weight:0},{id:"focus-traps",weight:0},{id:"managed-focus",weight:0},{id:"use-landmarks",weight:0},{id:"offscreen-content-hidden",weight:0},{id:"custom-controls-labels",weight:0},{id:"custom-controls-roles",weight:0},{id:"empty-heading",weight:0,group:"hidden"},{id:"identical-links-same-purpose",weight:0,group:"hidden"},{id:"landmark-one-main",weight:0,group:"hidden"},{id:"target-size",weight:0,group:"hidden"},{id:"label-content-name-mismatch",weight:0,group:"hidden"},{id:"table-fake-caption",weight:0,group:"hidden"},{id:"td-has-header",weight:0,group:"hidden"}]},"best-practices":{title:Ee(ye.bestPracticesCategoryTitle),supportedModes:["navigation","timespan","snapshot"],auditRefs:[{id:"is-o\
n-https",weight:5,group:"best-practices-trust-safety"},{id:"geolocation-on-start",weight:1,group:"best-practices-trust-safety"},{id:"notification-on-start",weight:1,group:"best-practices-trust-safety"},{id:"csp-xss",weight:0,group:"best-practices-trust-safety"},{id:"paste-preventing-inputs",weight:3,group:"best-practices-ux"},{id:"image-aspect-ratio",weight:1,group:"best-practices-ux"},{id:"image-size-responsive",weight:1,group:"best-practices-ux"},{id:"preload-fonts",weight:1,group:"best-practices-ux"},{id:"doctype",weight:1,group:"best-practices-browser-compat"},{id:"charset",weight:1,group:"best-practices-browser-compat"},{id:"no-unload-listeners",weight:1,group:"best-practices-general"},{id:"js-libraries",weight:0,group:"best-practices-general"},{id:"deprecations",weight:5,group:"best-practices-general"},{id:"third-party-cookies",weight:5,group:"best-practices-general"},{id:"errors-in-console",weight:1,group:"best-practices-general"},{id:"valid-source-maps",weight:0,group:"best-pra\
ctices-general"},{id:"inspector-issues",weight:1,group:"best-practices-general"}]},seo:{title:Ee(ye.seoCategoryTitle),description:Ee(ye.seoCategoryDescription),manualDescription:Ee(ye.seoCategoryManualDescription),supportedModes:["navigation","snapshot"],auditRefs:[{id:"viewport",weight:1,group:"seo-mobile"},{id:"document-title",weight:1,group:"seo-content"},{id:"meta-description",weight:1,group:"seo-content"},{id:"http-status-code",weight:1,group:"seo-crawl"},{id:"link-text",weight:1,group:"seo-content"},{id:"crawlable-anchors",weight:1,group:"seo-crawl"},{id:"is-crawlable",weight:1,group:"seo-crawl"},{id:"robots-txt",weight:1,group:"seo-crawl"},{id:"image-alt",weight:1,group:"seo-content"},{id:"hreflang",weight:1,group:"seo-content"},{id:"canonical",weight:1,group:"seo-content"},{id:"font-size",weight:1,group:"seo-mobile"},{id:"plugins",weight:1,group:"seo-content"},{id:"tap-targets",weight:1,group:"seo-mobile"},{id:"structured-data",weight:0}]},pwa:{title:Ee(ye.pwaCategoryTitle),description:Ee(
ye.pwaCategoryDescription),manualDescription:Ee(ye.pwaCategoryManualDescription),supportedModes:["navigation"],auditRefs:[{id:"installable-manifest",weight:2,group:"pwa-installable"},{id:"splash-screen",weight:1,group:"pwa-optimized"},{id:"themed-omnibox",weight:1,group:"pwa-optimized"},{id:"content-width",weight:1,group:"pwa-optimized"},{id:"viewport",weight:2,group:"pwa-optimized"},{id:"maskable-icon",weight:1,group:"pwa-optimized"},{id:"pwa-cross-browser",weight:0},{id:"pwa-page-transitions",weight:0},{id:"pwa-each-page-has-url",weight:0}]}}};Object.defineProperty(W3,"UIStrings",{enumerable:!1,get:()=>ye});Wf=W3});function V3(e,t){let n={timespan:0,snapshot:1,navigation:2},r=Math.min(...e.instance.meta.supportedModes.map(i=>n[i])),a=Math.min(...t.instance.meta.supportedModes.map(i=>n[i]));return r===n.timespan?a===n.timespan:r===n.snapshot?a===n.snapshot:!0}function $3(e,t){if(!t.startsWith("lighthouse-plugin-"))throw new Error(`plugin name '${t}' does not start with 'lighthouse-plugin-'`);if(e.categories?.[t])throw new Error(`plugin name '${t}' not allowed because it is the id of a category already found in config`)}function Zne(e){let t=e.gatherer.instance;if(typeof t.meta!="object")throw new Error(`Gatherer for ${e.id} did not provide a meta object.`);if(t.meta.supportedModes.length===0)throw new Error(`Gatherer for ${e.id} did not support any gather modes.`);if(typeof t.getArtifact!="function"||t.getArtifact===X.prototype.getArtifact)throw new Error(`Gatherer for ${e.id} did not define a "getArtifact" method.`)}function fb(e){let{implementation:t,path:n}=e,r=n||t?.meta?.id||"Unknown audit";if(typeof t.
audit!="function"||t.audit===y.audit)throw new Error(`${r} has no audit() method.`);if(typeof t.meta.id!="string")throw new Error(`${r} has no meta.id property, or the property is not a string.`);if(!zr(t.meta.title))throw new Error(`${r} has no meta.title property, or the property is not a string.`);let a=t.meta.scoreDisplayMode||y.SCORING_MODES.BINARY;if(!zr(t.meta.failureTitle)&&a===y.SCORING_MODES.BINARY)throw new Error(`${r} has no meta.failureTitle and should.`);if(zr(t.meta.description)){if(t.meta.description==="")throw new Error(`${r} has an empty meta.description string. Please add a description for the UI.`)}else throw new Error(`${r} has no meta.description property, or the property is not a string.`);if(!Array.isArray(t.meta.requiredArtifacts))throw new Error(`${r} has no meta.requiredArtifacts property, or the property is not an array.`)}function Qne(e,t,n){if(!e)return;let r=new Map((t||[]).map(a=>[a.implementation.meta.id,a]));Object.keys(e).forEach(a=>{e[a].auditRefs.forEach(
(i,o)=>{if(!i.id)throw new Error(`missing an audit id at ${a}[${o}]`);let c=r.get(i.id);if(!c)throw new Error(`could not find ${i.id} audit for category ${a}`);let l=c.implementation.meta.scoreDisplayMode==="manual";if(a==="accessibility"&&!i.group&&!l)throw new Error(`${i.id} accessibility audit does not have a group`);if(i.weight>0&&l)throw new Error(`${i.id} is manual but has a positive weight`);if(i.group&&(!n||!n[i.group]))throw new Error(`${i.id} references unknown group ${i.group}`)})})}function hb(e){if(!e.formFactor)throw new Error("`settings.formFactor` must be defined as 'mobile' or 'desktop'. See https://github.com/GoogleChrome/lighthouse/blob/main/docs/emulation.md");if(!e.screenEmulation.disabled&&e.screenEmulation.mobile!==(e.formFactor==="mobile"))throw new Error(`Screen emulation mobile setting (${e.screenEmulation.mobile}) does not match formFactor setting (${e.formFactor}). See https://github.com/GoogleChrome/lighthouse/blob/main/docs/emulation.md`);let t=e.skipAudits?.
find(n=>e.onlyAudits?.includes(n));if(t)throw new Error(`${t} appears in both skipAudits and onlyAudits`)}function ere(e){let t=new Set;for(let n of e){if(Zne(n),t.has(n.id))throw new Error(`Config defined multiple artifacts with id '${n.id}'`);if(t.add(n.id),!!n.dependencies)for(let[r,{id:a}]of Object.entries(n.dependencies))t.has(a)||gb(n.id,r)}}function Y3(e){ere(e.artifacts||[]);for(let t of e.audits||[])fb(t);Qne(e.categories,e.audits,e.groups),hb(e.settings)}function gb(e,t){throw new Error([`Failed to find dependency "${t}" for "${e}" artifact`,"Check that...",`  1. A gatherer exposes a matching Symbol that satisfies "${t}".`,`  2. "${t}" is configured to run before "${e}"`].join(`
`))}function K3(e,t){throw new Error([`Dependency "${t}" for "${e}" artifact is invalid.`,"The dependency must be collected before the dependent."].join(`
`))}var yb=v(()=>{"use strict";d();Y();Ie();R();s(V3,"isValidArtifactDependency");s($3,"assertValidPluginName");s(Zne,"assertValidArtifact");s(fb,"assertValidAudit");s(Qne,"assertValidCategories");s(hb,"assertValidSettings");s(ere,"assertValidArtifacts");s(Y3,"assertValidConfig");s(gb,"throwInvalidDependencyOrder");s(K3,"throwInvalidArtifactDependency")});function X3(e,t){if(!e)return new Set;t=t||Object.keys(e);let r=t.map(a=>e[a]).flatMap(a=>a?.auditRefs||[]);return new Set(r.map(a=>a.id))}function ore(e,t){if(!e)return null;if(!t)return e;let n=new Map(e.map(i=>[i.id,i])),r=new Set([...ire,...t.flatMap(i=>i.implementation.meta.requiredArtifacts)]),a=0;for(;a!==r.size;){a=r.size;for(let i of r){let o=n.get(i);if(o&&o.dependencies)for(let c of Object.values(o.dependencies))r.add(c.id)}}return e.filter(i=>r.has(i.id))}function sre(e,t){return e?e.filter(n=>n.gatherer.instance.meta.supportedModes.includes(t)):null}function cre(e,t){if(!e)return null;let n=new Set(t.map(r=>r.id).concat(rre));return e.filter(r=>r.implementation.meta.requiredArtifacts.every(i=>n.has(i)))}function ure(e,t){return e?e.filter(n=>{let r=n.implementation.meta;return!r.supportedModes||r.supportedModes.includes(t)}):null}function lre(e,t){if(!e)return null;let n=Object.entries(e).filter(([r,a])=>!a.supportedModes||a.supportedModes.includes(t));return Object.fromEntries(
n)}function dre(e,t){if(!e||!t)return e;let n=Object.entries(e).filter(([r])=>t.includes(r));return Object.fromEntries(n)}function mre(e,t){if(t)for(let n of t)e?.[n]||F.warn("config",`unrecognized category in 'onlyCategories': ${n}`)}function J3(e,t){if(!e)return e;let n=new Map(t.map(a=>[a.implementation.meta.id,a.implementation.meta])),r=Object.entries(e).map(([a,i])=>{let o={...i,auditRefs:i.auditRefs.filter(l=>n.has(l.id))},c=o.auditRefs.length<i.auditRefs.length,u=o.auditRefs.every(l=>{let m=n.get(l.id);return m?m.scoreDisplayMode===y.SCORING_MODES.MANUAL:!1});return c&&u&&(o.auditRefs=[]),[a,o]}).filter(a=>typeof a[1]=="object"&&a[1].auditRefs.length);return Object.fromEntries(r)}function Z3(e,t){let n=sre(e.artifacts,t),r=ure(e.audits,t),a=cre(r,n||[]),i=lre(e.categories,t),o=J3(i,a||[]);return{...e,artifacts:n,audits:a,categories:o}}function Q3(e,t){let{onlyAudits:n,onlyCategories:r,skipAudits:a}=t;mre(e.categories,r);let i=X3(e.categories,void 0);r?i=X3(e.categories,r):n?i=new Set:
(!e.categories||!Object.keys(e.categories).length)&&(i=new Set(e.audits?.map(p=>p.implementation.meta.id)));let o=new Set([...i,...n||[],...are].filter(p=>!a||!a.includes(p))),c=o.size&&e.audits?e.audits.filter(p=>o.has(p.implementation.meta.id)):e.audits,u=J3(e.categories,c||[]),l=dre(u,r),m=ore(e.artifacts,c);return m&&e.settings.disableFullPageScreenshot&&(m=m.filter(({id:p})=>p!=="FullPageScreenshot")),{...e,artifacts:m,audits:c,categories:l}}var nre,rre,are,ire,eP=v(()=>{"use strict";d();Pe();Y();nre={fetchTime:"",LighthouseRunWarnings:"",BenchmarkIndex:"",BenchmarkIndexes:"",settings:"",Timing:"",URL:"",PageLoadError:"",HostFormFactor:"",HostUserAgent:"",HostProduct:"",GatherContext:""},rre=Object.keys(nre),are=[],ire=["Stacks","NetworkUserAgent","FullPageScreenshot"];s(X3,"getAuditIdsInCategories");s(ore,"filterArtifactsByAvailableAudits");s(sre,"filterArtifactsByGatherMode");s(cre,"filterAuditsByAvailableArtifacts");s(ure,"filterAuditsByGatherMode");s(lre,"filterCategoriesByGat\
herMode");s(dre,"filterCategoriesByExplicitFilters");s(mre,"warnOnUnknownOnlyCategories");s(J3,"filterCategoriesByAvailableAudits");s(Z3,"filterConfigByGatherMode");s(Q3,"filterConfigByExplicitFilters")});function Vf(e){return Array.isArray(e)&&e.every(nP)}function nP(e){return typeof e=="object"&&e!==null&&!Array.isArray(e)}function tP(e){return typeof e=="number"&&!isNaN(e)}var Wr,bl=v(()=>{"use strict";d();s(Vf,"isArrayOfUnknownObjects");s(nP,"isObjectOfUnknownProperties");s(tP,"isNumber");Wr=class e{static{s(this,"Budget")}static assertNoExcessProperties(t,n){let r=Object.keys(t);if(r.length>0){let a=r.join(", ");throw new Error(`${n} has unrecognized properties: [${a}]`)}}static assertNoDuplicateStrings(t,n){let r=new Set;for(let a of t){if(r.has(a))throw new Error(`${n} has duplicate entry of type '${a}'`);r.add(a)}}static validateResourceBudget(t){let{resourceType:n,budget:r,...a}=t;e.assertNoExcessProperties(a,"Resource Budget");let i=["total","document","script","stylesheet","image","media","font","other","third-party"];if(!i.includes(n))throw new Error(`Invalid resource type: ${n}. 
Valid resource types are: ${i.join(", ")}`);if(!tP(r))throw new Error(`Invalid budget: ${r}`);return{resourceType:n,budget:r}}static throwInvalidPathError(t,n){throw new Error(`Invalid path ${t}. ${n}
'Path' should be specified using the 'robots.txt' format.
Learn more about the 'robots.txt' format here:
https://developers.google.com/search/reference/robots_txt#url-matching-based-on-path-values`)}static validatePath(t){if(t!==void 0){if(typeof t!="string"){this.throwInvalidPathError(t,"Path should be a string.");return}else t.startsWith("/")?(t.match(/\*/g)||[]).length>1?this.throwInvalidPathError(t,"Path should only contain one '*'."):(t.match(/\$/g)||[]).length>1?this.throwInvalidPathError(t,"Path should only contain one '$' character."):t.includes("$")&&!t.endsWith("$")&&this.throwInvalidPathError(t,"'$' character should only occur at end of path."):this.throwInvalidPathError(t,"Path should start with '/'.");return t}}static getMatchingBudget(t,n){if(!(t===null||n===void 0))for(let r=t.length-1;r>=0;r--){let a=t[r];if(this.urlMatchesPattern(n,a.path))return a}}static urlMatchesPattern(t,n="/"){let r=new URL(t),a=r.pathname+r.search,i=n.includes("*"),o=n.includes("$");if(!i&&!o)return a.startsWith(n);if(!i&&o)return a===n.slice(0,-1);if(i&&!o){let[c,u]=n.split("*"),l=a.slice(c.length);
return a.startsWith(c)&&l.includes(u)}else if(i&&o){let[c,u]=n.split("*"),l=a.slice(c.length);return a.startsWith(c)&&l.endsWith(u.slice(0,-1))}return!1}static validateTimingBudget(t){let{metric:n,budget:r,...a}=t;e.assertNoExcessProperties(a,"Timing Budget");let i=["first-contentful-paint","interactive","first-meaningful-paint","max-potential-fid","total-blocking-time","speed-index","largest-contentful-paint","cumulative-layout-shift"];if(!i.includes(n))throw new Error(`Invalid timing metric: ${n}. 
Valid timing metrics are: ${i.join(", ")}`);if(!tP(r))throw new Error(`Invalid budget: ${r}`);return{metric:n,budget:r}}static validateHostname(t){let n=`${t} is not a valid hostname.`;if(t.length===0)throw new Error(n);if(t.includes("/"))throw new Error(n);if(t.includes(":"))throw new Error(n);if(t.includes("*")&&(!t.startsWith("*.")||t.lastIndexOf("*")>0))throw new Error(n);return t}static validateHostnames(t){if(Array.isArray(t)&&t.every(n=>typeof n=="string"))return t.map(e.validateHostname);if(t!==void 0)throw new Error("firstPartyHostnames should be defined as an array of strings.")}static initializeBudget(t){if(t=JSON.parse(JSON.stringify(t)),!Vf(t))throw new Error("Budget file is not defined as an array of budgets.");return t.map((r,a)=>{let i={},{path:o,options:c,resourceSizes:u,resourceCounts:l,timings:m,...p}=r;if(e.assertNoExcessProperties(p,"Budget"),i.path=e.validatePath(o),nP(c)){let{firstPartyHostnames:h,...f}=c;e.assertNoExcessProperties(f,"Options property"),i.options=
{},i.options.firstPartyHostnames=e.validateHostnames(h)}else if(c!==void 0)throw new Error(`Invalid options property in budget at index ${a}`);if(Vf(u))i.resourceSizes=u.map(e.validateResourceBudget),e.assertNoDuplicateStrings(i.resourceSizes.map(h=>h.resourceType),`budgets[${a}].resourceSizes`);else if(u!==void 0)throw new Error(`Invalid resourceSizes entry in budget at index ${a}`);if(Vf(l))i.resourceCounts=l.map(e.validateResourceBudget),e.assertNoDuplicateStrings(i.resourceCounts.map(h=>h.resourceType),`budgets[${a}].resourceCounts`);else if(l!==void 0)throw new Error(`Invalid resourceCounts entry in budget at index ${a}`);if(Vf(m))i.timings=m.map(e.validateTimingBudget),e.assertNoDuplicateStrings(i.timings.map(h=>h.metric),`budgets[${a}].timings`);else if(m!==void 0)throw new Error(`Invalid timings entry in budget at index ${a}`);return i})}}});function rP(e){return Array.isArray(e)&&e.every(Dl)}function Dl(e){return typeof e=="object"&&e!==null&&!Array.isArray(e)}function pre(e){return typeof e!="string"?!1:e==="navigation"||e==="timespan"||e==="snapshot"}function fre(e){return Array.isArray(e)?e.every(pre):!1}function wl(e,t,n=""){n&&(n+=" ");let r=Object.keys(e);if(r.length>0){let a=r.join(", ");throw new Error(`${t} has unrecognized ${n}properties: [${a}]`)}}var vb,aP,iP=v(()=>{"use strict";d();R();s(rP,"isArrayOfUnknownObjects");s(Dl,"isObjectOfUnknownProperties");s(pre,"objectIsGatherMode");s(fre,"isArrayOfGatherModes");s(wl,"assertNoExcessProperties");vb=class e{static{s(this,"ConfigPlugin")}static _parseAuditsList(t,n){if(t!==void 0){if(!rP(t))throw new Error(`${n} has an invalid audits array.`);return t.map(r=>{let{path:a,...i}=r;if(wl(i,n,"audit"),typeof a!="string")throw new Error(`${n} has a missing audit path.`);return{path:a}})}}static _parseAuditRefsList(t,n){if(!rP(t))throw new Error(`${n} has no valid auditsR\
efs.`);return t.map(r=>{let{id:a,weight:i,group:o,...c}=r;if(wl(c,n,"auditRef"),typeof a!="string")throw new Error(`${n} has an invalid auditRef id.`);if(typeof i!="number")throw new Error(`${n} has an invalid auditRef weight.`);if(typeof o!="string"&&typeof o<"u")throw new Error(`${n} has an invalid auditRef group.`);let u=o&&`${n}-${o}`;return{id:a,weight:i,group:u}})}static _parseCategory(t,n){if(!Dl(t))throw new Error(`${n} has no valid category.`);let{title:r,description:a,manualDescription:i,auditRefs:o,supportedModes:c,...u}=t;if(wl(u,n,"category"),!zr(r))throw new Error(`${n} has an invalid category tile.`);if(!zr(a)&&a!==void 0)throw new Error(`${n} has an invalid category description.`);if(!zr(i)&&i!==void 0)throw new Error(`${n} has an invalid category manualDescription.`);if(!fre(c)&&c!==void 0)throw new Error(`${n} supportedModes must be an array, valid array values are "navigation", "timespan", and "snapshot".`);let l=e._parseAuditRefsList(o,n);return{title:r,auditRefs:l,
description:a,manualDescription:i,supportedModes:c}}static _parseGroups(t,n){if(t===void 0)return;if(!Dl(t))throw new Error(`${n} groups json is not defined as an object.`);let r=Object.entries(t),a={};return r.forEach(([i,o])=>{if(!Dl(o))throw new Error(`${n} has a group not defined as an object.`);let{title:c,description:u,...l}=o;if(wl(l,n,"group"),!zr(c))throw new Error(`${n} has an invalid group title.`);if(!zr(u)&&u!==void 0)throw new Error(`${n} has an invalid group description.`);a[`${n}-${i}`]={title:c,description:u}}),a}static parsePlugin(t,n){if(t=JSON.parse(JSON.stringify(t)),!Dl(t))throw new Error(`${n} is not defined as an object.`);let{audits:r,category:a,groups:i,...o}=t;return wl(o,n),{audits:e._parseAuditsList(r,n),categories:{[n]:e._parseCategory(a,n)},groups:e._parseGroups(i,n)}}},aP=vb});var oP,sP=v(()=>{"use strict";d();Da();Fs();oP=`/*! axe v4.8.4
 * Copyright (c) 2015 - 2024 Deque Systems, Inc.
 *
 * Your use of this Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 * This entire copyright notice must appear in every copy of this file you
 * distribute or in any file that contains substantial portions of this source
 * code.
 */
!function e(t){var n=t,r=t.document;function a(e){return(a="function"==typeof Symbol&&"symbol"==typeof Symbol.iterator?function(e){return typeof e}:function(e){return e&&"function"==typeof Symbol&&e.constructor===Symbol&&e!==Symbol.prototype?"symbol":typeof e})(e)}var o=o||{};function i(e){this.name="SupportError",this.cause=e.cause,this.message="\`".concat(e.cause,"\` - feature unsupported in your environment."),e.ruleId&&(this.ruleId=e.ruleId,this.message+=" Skipping ".concat(this.ruleId," rule.")),this.stack=(new Error).stack}o.version="4.8.4","function"==typeof define&&define.amd&&define("axe-core",[],(function(){return o})),"object"===("undefined"==typeof module?"undefined":a(module))&&module.exports&&"function"==typeof e.toString&&(o.source="("+e.toString()+')(typeof window === "object" ? window : this);',module.exports=o),"function"==typeof t.getComputedStyle&&(t.axe=o),(i.prototype=Object.create(Error.prototype)).constructor=i;var u=["node"],l=["relatedNodes"],s=["node"],c=["vari\
ant"],d=["matches"],p=["chromium"],f=["noImplicit"],m=["noPresentational"],D=["precision","format","inGamut"],h=["space"],g=["algorithm"],b=["method"],v=["maxDeltaE","deltaEMethod","steps","maxSteps"],y=["node"],F=["environmentData"],w=["environmentData"],E=["environmentData"],C=["environmentData"],x=["environmentData"];function A(e,t,n){return(A=R()?Reflect.construct.bind():function(e,t,n){var r=[null];return r.push.apply(r,t),t=new(Function.bind.apply(e,r)),n&&N(t,n.prototype),t}).apply(null,arguments)}function k(e,t){if("function"!=typeof t&&null!==t)throw new TypeError("Super expression must either be null or a function");e.prototype=Object.create(t&&t.prototype,{constructor:{value:e,writable:!0,configurable:!0}}),Object.defineProperty(e,"prototype",{writable:!1}),t&&N(e,t)}function N(e,t){return(N=Object.setPrototypeOf?Object.setPrototypeOf.bind():function(e,t){return e.__proto__=t,e})(e,t)}function B(e){var t=R();return function(){var n,r=_(e);n=t?(n=_(this).constructor,Reflect.c\
onstruct(r,arguments,n)):r.apply(this,arguments),r=this;if(n&&("object"===a(n)||"function"==typeof n))return n;if(void 0!==n)throw new TypeError("Derived constructors may only return object or undefined");return T(r)}}function T(e){if(void 0===e)throw new ReferenceError("this hasn't been initialised - super() hasn't been called");return e}function R(){if("undefined"==typeof Reflect||!Reflect.construct)return!1;if(Reflect.construct.sham)return!1;if("function"==typeof Proxy)return!0;try{return Boolean.prototype.valueOf.call(Reflect.construct(Boolean,[],(function(){}))),!0}catch(e){return!1}}function _(e){return(_=Object.setPrototypeOf?Object.getPrototypeOf.bind():function(e){return e.__proto__||Object.getPrototypeOf(e)})(e)}function O(e,t,n){M(e,t),t.set(e,n)}function S(e,t){M(e,t),t.add(e)}function M(e,t){if(t.has(e))throw new TypeError("Cannot initialize the same private elements twice on an object")}function P(e,t){return(t=L(e,t,"get")).get?t.get.call(e):t.value}function I(e,t,n){if(\
t.has(e))return n;throw new TypeError("attempted to get private field on non-instance")}function j(e,t,n){if((t=L(e,t,"set")).set)t.set.call(e,n);else{if(!t.writable)throw new TypeError("attempted to set read only private field");t.value=n}}function L(e,t,n){if(t.has(e))return t.get(e);throw new TypeError("attempted to "+n+" private field on non-instance")}function q(e,t){if(null==e)return{};var n,r=function(e,t){if(null==e)return{};var n,r,a={},o=Object.keys(e);for(r=0;r<o.length;r++)n=o[r],0<=t.indexOf(n)||(a[n]=e[n]);return a}(e,t);if(Object.getOwnPropertySymbols)for(var a=Object.getOwnPropertySymbols(e),o=0;o<a.length;o++)n=a[o],0<=t.indexOf(n)||Object.prototype.propertyIsEnumerable.call(e,n)&&(r[n]=e[n]);return r}function z(e){return function(e){if(Array.isArray(e))return Q(e)}(e)||V(e)||J(e)||function(){throw new TypeError("Invalid attempt to spread non-iterable instance.\\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method.")}()}function V(e){if("un\
defined"!=typeof Symbol&&null!=e[Symbol.iterator]||null!=e["@@iterator"])return Array.from(e)}function $(){return($=Object.assign?Object.assign.bind():function(e){for(var t=1;t<arguments.length;t++){var n,r=arguments[t];for(n in r)Object.prototype.hasOwnProperty.call(r,n)&&(e[n]=r[n])}return e}).apply(this,arguments)}function H(e,t){return G(e)||function(e,t){var n=null==e?null:"undefined"!=typeof Symbol&&e[Symbol.iterator]||e["@@iterator"];if(null!=n){var r,a,o,i,u=[],l=!0,s=!1;try{if(o=(n=n.call(e)).next,0===t){if(Object(n)!==n)return;l=!1}else for(;!(l=(r=o.call(n)).done)&&(u.push(r.value),u.length!==t);l=!0);}catch(e){s=!0,a=e}finally{try{if(!l&&null!=n.return&&(i=n.return(),Object(i)!==i))return}finally{if(s)throw a}}return u}}(e,t)||J(e,t)||U()}function U(){throw new TypeError("Invalid attempt to destructure non-iterable instance.\\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method.")}function G(e){if(Array.isArray(e))return e}function W(e,t){if(!(e\
 instanceof t))throw new TypeError("Cannot call a class as a function")}function Y(e,t){for(var n=0;n<t.length;n++){var r=t[n];r.enumerable=r.enumerable||!1,r.configurable=!0,"value"in r&&(r.writable=!0),Object.defineProperty(e,X(r.key),r)}}function K(e,t,n){return t&&Y(e.prototype,t),n&&Y(e,n),Object.defineProperty(e,"prototype",{writable:!1}),e}function X(e){return e=function(e,t){if("object"!==a(e)||null===e)return e;var n=e[Symbol.toPrimitive];if(void 0===n)return String(e);if(n=n.call(e,"string"),"object"===a(n))throw new TypeError("@@toPrimitive must return a primitive value.");return n}(e),"symbol"===a(e)?e:String(e)}function Z(e,t){var n,r,a,o,i="undefined"!=typeof Symbol&&e[Symbol.iterator]||e["@@iterator"];if(i)return r=!(n=!0),{s:function(){i=i.call(e)},n:function(){var e=i.next();return n=e.done,e},e:function(e){r=!0,a=e},f:function(){try{n||null==i.return||i.return()}finally{if(r)throw a}}};if(Array.isArray(e)||(i=J(e))||t&&e&&"number"==typeof e.length)return i&&(e=i),o=0,\
{s:t=function(){},n:function(){return o>=e.length?{done:!0}:{done:!1,value:e[o++]}},e:function(e){throw e},f:t};throw new TypeError("Invalid attempt to iterate non-iterable instance.\\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method.")}function J(e,t){var n;if(e)return"string"==typeof e?Q(e,t):"Map"===(n="Object"===(n=Object.prototype.toString.call(e).slice(8,-1))&&e.constructor?e.constructor.name:n)||"Set"===n?Array.from(e):"Arguments"===n||/^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)?Q(e,t):void 0}function Q(e,t){(null==t||t>e.length)&&(t=e.length);for(var n=0,r=new Array(t);n<t;n++)r[n]=e[n];return r}function a(e){return(a="function"==typeof Symbol&&"symbol"==typeof Symbol.iterator?function(e){return typeof e}:function(e){return e&&"function"==typeof Symbol&&e.constructor===Symbol&&e!==Symbol.prototype?"symbol":typeof e})(e)}function ee(e,t){return function(){return t||e((t={exports:{}}).exports,t),t.exports}}function te(e,t){for(var n in t)se(\
e,n,{get:t[n],enumerable:!0})}function ne(e){return function(e,t,n){if(t&&"object"===a(t)||"function"==typeof t){var r,o=Z(pe(t));try{for(o.s();!(r=o.n()).done;)!function(){var a=r.value;de.call(e,a)||"default"===a||se(e,a,{get:function(){return t[a]},enumerable:!(n=fe(t,a))||n.enumerable})}()}catch(e){o.e(e)}finally{o.f()}}return e}((t=se(null!=e?le(ce(e)):{},"default",e&&e.__esModule&&"default"in e?{get:function(){return e.default},enumerable:!0}:{value:e,enumerable:!0}),se(t,"__esModule",{value:!0})),e);var t}function re(e,t,n){(t="symbol"!==a(t)?t+"":t)in e?se(e,t,{enumerable:!0,configurable:!0,writable:!0,value:n}):e[t]=n}var ae,oe,ie,ue,le=Object.create,se=Object.defineProperty,ce=Object.getPrototypeOf,de=Object.prototype.hasOwnProperty,pe=Object.getOwnPropertyNames,fe=Object.getOwnPropertyDescriptor,me=ee((function(e,t){"use strict";t.exports=function(){}})),De=ee((function(e,t){"use strict";var n=me()();t.exports=function(e){return e!==n&&null!==e}})),he=ee((function(e,t){"use \
strict";var n=De(),r=Array.prototype.forEach,a=Object.create;t.exports=function(e){var t=a(null);return r.call(arguments,(function(e){if(n(e)){var r,a=Object(e),o=t;for(r in a)o[r]=a[r]}})),t}})),ge=ee((function(e,t){"use strict";t.exports=function(){var e=Math.sign;return"function"==typeof e&&1===e(10)&&-1===e(-20)}})),be=ee((function(e,t){"use strict";t.exports=function(e){return e=Number(e),isNaN(e)||0===e?e:0<e?1:-1}})),ve=ee((function(e,t){"use strict";t.exports=ge()()?Math.sign:be()})),ye=ee((function(e,t){"use strict";var n=ve(),r=Math.abs,a=Math.floor;t.exports=function(e){return isNaN(e)?0:0!==(e=Number(e))&&isFinite(e)?n(e)*a(r(e)):e}})),Fe=ee((function(e,t){"use strict";var n=ye(),r=Math.max;t.exports=function(e){return r(0,n(e))}})),we=ee((function(e,t){"use strict";var n=Fe();t.exports=function(e,t,r){return isNaN(e)?0<=t?r&&t?t-1:t:1:!1!==e&&n(e)}})),Ee=ee((function(e,t){"use strict";t.exports=function(e){if("function"!=typeof e)throw new TypeError(e+" is not a function")\
;return e}})),Ce=ee((function(e,t){"use strict";var n=De();t.exports=function(e){if(n(e))return e;throw new TypeError("Cannot use null or undefined")}})),xe=ee((function(e,t){"use strict";var n=Ee(),r=Ce(),a=Function.prototype.bind,o=Function.prototype.call,i=Object.keys,u=Object.prototype.propertyIsEnumerable;t.exports=function(e,t){return function(l,s){var c,d=arguments[2],p=arguments[3];return l=Object(r(l)),n(s),c=i(l),p&&c.sort("function"==typeof p?a.call(p,l):void 0),"function"!=typeof e&&(e=c[e]),o.call(e,c,(function(e,n){return u.call(l,e)?o.call(s,d,l[e],e,l,n):t}))}}})),Ae=ee((function(e,t){"use strict";t.exports=xe()("forEach")})),ke=ee((function(){})),Ne=ee((function(e,t){"use strict";t.exports=function(){var e=Object.assign;return"function"==typeof e&&(e(e={foo:"raz"},{bar:"dwa"},{trzy:"trzy"}),e.foo+e.bar+e.trzy==="razdwatrzy")}})),Be=ee((function(e,t){"use strict";t.exports=function(){try{return Object.keys("primitive"),!0}catch(e){return!1}}})),Te=ee((function(e,t){"use\
 strict";var n=De(),r=Object.keys;t.exports=function(e){return r(n(e)?Object(e):e)}})),Re=ee((function(e,t){"use strict";t.exports=Be()()?Object.keys:Te()})),_e=ee((function(e,t){"use strict";var n=Re(),r=Ce(),a=Math.max;t.exports=function(e,t){var o,i,u,l=a(arguments.length,2);for(e=Object(r(e)),u=function(n){try{e[n]=t[n]}catch(n){o=o||n}},i=1;i<l;++i)n(t=arguments[i]).forEach(u);if(void 0!==o)throw o;return e}})),Oe=ee((function(e,t){"use strict";t.exports=Ne()()?Object.assign:_e()})),Se=ee((function(e,t){"use strict";var n=De(),r={function:!0,object:!0};t.exports=function(e){return n(e)&&r[a(e)]||!1}})),Me=ee((function(e,t){"use strict";var n=Oe(),r=Se(),a=De(),o=Error.captureStackTrace;t.exports=function(e){e=new Error(e);var i=arguments[1],u=arguments[2];return a(u)||r(i)&&(u=i,i=null),a(u)&&n(e,u),a(i)&&(e.code=i),o&&o(e,t.exports),e}})),Pe=ee((function(e,t){"use strict";var n=Ce(),r=Object.defineProperty,a=Object.getOwnPropertyDescriptor,o=Object.getOwnPropertyNames,i=Object.ge\
tOwnPropertySymbols;t.exports=function(e,t){var u,l=Object(n(t));if(e=Object(n(e)),o(l).forEach((function(n){try{r(e,n,a(t,n))}catch(n){u=n}})),"function"==typeof i&&i(l).forEach((function(n){try{r(e,n,a(t,n))}catch(n){u=n}})),void 0!==u)throw u;return e}})),Ie=ee((function(e,t){"use strict";function n(e,t){return t}var r,a,o,i,u,l=Fe();try{Object.defineProperty(n,"length",{configurable:!0,writable:!1,enumerable:!1,value:1})}catch(e){}1===n.length?(r={configurable:!0,writable:!1,enumerable:!1},a=Object.defineProperty,t.exports=function(e,t){return t=l(t),e.length===t?e:(r.value=t,a(e,"length",r))}):(i=Pe(),u=[],o=function(e){var t,n=0;if(u[e])return u[e];for(t=[];e--;)t.push("a"+(++n).toString(36));return new Function("fn","return function ("+t.join(", ")+") { return fn.apply(this, arguments); };")},t.exports=function(e,t){if(t=l(t),e.length===t)return e;t=o(t)(e);try{i(t,e)}catch(e){}return t})})),je=ee((function(e,t){"use strict";t.exports=function(e){return null!=e}})),Le=ee((functi\
on(e,t){"use strict";var n=je(),r={object:!0,function:!0,undefined:!0};t.exports=function(e){return!!n(e)&&hasOwnProperty.call(r,a(e))}})),qe=ee((function(e,t){"use strict";var n=Le();t.exports=function(e){if(!n(e))return!1;try{return!!e.constructor&&e.constructor.prototype===e}catch(e){return!1}}})),ze=ee((function(e,t){"use strict";var n=qe();t.exports=function(e){if("function"!=typeof e)return!1;if(!hasOwnProperty.call(e,"length"))return!1;try{if("number"!=typeof e.length)return!1;if("function"!=typeof e.call)return!1;if("function"!=typeof e.apply)return!1}catch(e){return!1}return!n(e)}})),Ve=ee((function(e,t){"use strict";var n=ze(),r=/^\\s*class[\\s{/}]/,a=Function.prototype.toString;t.exports=function(e){return!!n(e)&&!r.test(a.call(e))}})),$e=ee((function(e,t){"use strict";var n="razdwatrzy";t.exports=function(){return"function"==typeof n.contains&&!0===n.contains("dwa")&&!1===n.contains("foo")}})),He=ee((function(e,t){"use strict";var n=String.prototype.indexOf;t.exports=function\
(e){return-1<n.call(this,e,arguments[1])}})),Ue=ee((function(e,t){"use strict";t.exports=$e()()?String.prototype.contains:He()})),Ge=ee((function(e,t){"use strict";var n=je(),r=Ve(),a=Oe(),o=he(),i=Ue();(t.exports=function(e,t){var r,u,l,s;return arguments.length<2||"string"!=typeof e?(s=t,t=e,e=null):s=arguments[2],n(e)?(r=i.call(e,"c"),u=i.call(e,"e"),l=i.call(e,"w")):u=!(r=l=!0),e={value:t,configurable:r,enumerable:u,writable:l},s?a(o(s),e):e}).gs=function(e,t,u){var l,s;return"string"!=typeof e?(s=u,u=t,t=e,e=null):s=arguments[3],n(t)?r(t)?n(u)?r(u)||(s=u,u=void 0):u=void 0:(s=t,t=u=void 0):t=void 0,e=n(e)?(l=i.call(e,"c"),i.call(e,"e")):!(l=!0),t={get:t,set:u,configurable:l,enumerable:e},s?a(o(s),t):t}})),We=ee((function(e,t){"use strict";var n=Ge(),r=Ee(),o=Function.prototype.apply,i=Function.prototype.call,u=Object.create,l=Object.defineProperty,s=Object.defineProperties,c=Object.prototype.hasOwnProperty,d={configurable:!0,enumerable:!1,writable:!0},p=function(e,t){var n;return \
r(t),c.call(this,"__ee__")?n=this.__ee__:(n=d.value=u(null),l(this,"__ee__",d),d.value=null),n[e]?"object"===a(n[e])?n[e].push(t):n[e]=[n[e],t]:n[e]=t,this},f=function(e,t){var n,a;return r(t),a=this,p.call(this,e,n=function(){m.call(a,e,n),o.call(t,this,arguments)}),n.__eeOnceListener__=t,this},m=function(e,t){var n,o,i,u;if(r(t),c.call(this,"__ee__")&&(n=this.__ee__)[e])if(o=n[e],"object"===a(o))for(u=0;i=o[u];++u)i!==t&&i.__eeOnceListener__!==t||(2===o.length?n[e]=o[u?0:1]:o.splice(u,1));else o!==t&&o.__eeOnceListener__!==t||delete n[e];return this},D=function(e){var t,n,r,u,l;if(c.call(this,"__ee__")&&(u=this.__ee__[e]))if("object"===a(u)){for(n=arguments.length,l=new Array(n-1),t=1;t<n;++t)l[t-1]=arguments[t];for(u=u.slice(),t=0;r=u[t];++t)o.call(r,this,l)}else switch(arguments.length){case 1:i.call(u,this);break;case 2:i.call(u,this,arguments[1]);break;case 3:i.call(u,this,arguments[1],arguments[2]);break;default:for(n=arguments.length,l=new Array(n-1),t=1;t<n;++t)l[t-1]=argument\
s[t];o.call(u,this,l)}},h={on:p,once:f,off:m,emit:D},g={on:n(p),once:n(f),off:n(m),emit:n(D)},b=s({},g);t.exports=e=function(e){return null==e?u(b):s(Object(e),g)},e.methods=h})),Ye=ee((function(e,t){"use strict";t.exports=function(){var e,t=Array.from;return"function"==typeof t&&(e=t(t=["raz","dwa"]),Boolean(e&&e!==t&&"dwa"===e[1]))}})),Ke=ee((function(e,t){"use strict";t.exports=function(){return"object"===("undefined"==typeof globalThis?"undefined":a(globalThis))&&!!globalThis&&globalThis.Array===Array}})),Xe=ee((function(e,n){function r(){if("object"===("undefined"==typeof self?"undefined":a(self))&&self)return self;if("object"===(void 0===t?"undefined":a(t))&&t)return t;throw new Error("Unable to resolve global \`this\`")}n.exports=function(){if(this)return this;try{Object.defineProperty(Object.prototype,"__global__",{get:function(){return this},configurable:!0})}catch(e){return r()}try{return __global__||r()}finally{delete Object.prototype.__global__}}()})),Ze=ee((function(e,t){"us\
e strict";t.exports=Ke()()?globalThis:Xe()})),Je=ee((function(e,t){"use strict";var n=Ze(),r={object:!0,symbol:!0};t.exports=function(){var e,t=n.Symbol;if("function"!=typeof t)return!1;e=t("test symbol");try{String(e)}catch(e){return!1}return!!r[a(t.iterator)]&&!!r[a(t.toPrimitive)]&&!!r[a(t.toStringTag)]}})),Qe=ee((function(e,t){"use strict";t.exports=function(e){return!!e&&("symbol"===a(e)||!!e.constructor&&"Symbol"===e.constructor.name&&"Symbol"===e[e.constructor.toStringTag])}})),et=ee((function(e,t){"use strict";var n=Qe();t.exports=function(e){if(n(e))return e;throw new TypeError(e+" is not a symbol")}})),tt=ee((function(e,t){"use strict";var n=Ge(),r=Object.create,a=Object.defineProperty,o=Object.prototype,i=r(null);t.exports=function(e){for(var t,r,u=0;i[e+(u||"")];)++u;return i[e+=u||""]=!0,a(o,t="@@"+e,n.gs(null,(function(e){r||(r=!0,a(this,t,n(e)),r=!1)}))),t}})),nt=ee((function(e,t){"use strict";var n=Ge(),r=Ze().Symbol;t.exports=function(e){return Object.defineProperties(\
e,{hasInstance:n("",r&&r.hasInstance||e("hasInstance")),isConcatSpreadable:n("",r&&r.isConcatSpreadable||e("isConcatSpreadable")),iterator:n("",r&&r.iterator||e("iterator")),match:n("",r&&r.match||e("match")),replace:n("",r&&r.replace||e("replace")),search:n("",r&&r.search||e("search")),species:n("",r&&r.species||e("species")),split:n("",r&&r.split||e("split")),toPrimitive:n("",r&&r.toPrimitive||e("toPrimitive")),toStringTag:n("",r&&r.toStringTag||e("toStringTag")),unscopables:n("",r&&r.unscopables||e("unscopables"))})}})),rt=ee((function(e,t){"use strict";var n=Ge(),r=et(),a=Object.create(null);t.exports=function(e){return Object.defineProperties(e,{for:n((function(t){return a[t]||(a[t]=e(String(t)))})),keyFor:n((function(e){for(var t in r(e),a)if(a[t]===e)return t}))})}})),at=ee((function(e,t){"use strict";var n,r,o,i=Ge(),u=et(),l=Ze().Symbol,s=tt(),c=nt(),d=rt(),p=Object.create,f=Object.defineProperties,m=Object.defineProperty;if("function"==typeof l)try{String(l()),o=!0}catch(e){}\
else l=null;r=function(e){if(this instanceof r)throw new TypeError("Symbol is not a constructor");return n(e)},t.exports=n=function e(t){var n;if(this instanceof e)throw new TypeError("Symbol is not a constructor");return o?l(t):(n=p(r.prototype),t=void 0===t?"":String(t),f(n,{__description__:i("",t),__name__:i("",s(t))}))},c(n),d(n),f(r.prototype,{constructor:i(n),toString:i("",(function(){return this.__name__}))}),f(n.prototype,{toString:i((function(){return"Symbol ("+u(this).__description__+")"})),valueOf:i((function(){return u(this)}))}),m(n.prototype,n.toPrimitive,i("",(function(){var e=u(this);return"symbol"===a(e)?e:e.toString()}))),m(n.prototype,n.toStringTag,i("c","Symbol")),m(r.prototype,n.toStringTag,i("c",n.prototype[n.toStringTag])),m(r.prototype,n.toPrimitive,i("c",n.prototype[n.toPrimitive]))})),ot=ee((function(e,t){"use strict";t.exports=Je()()?Ze().Symbol:at()})),it=ee((function(e,t){"use strict";var n=Object.prototype.toString,r=n.call(function(){return arguments}());\
t.exports=function(e){return n.call(e)===r}})),ut=ee((function(e,t){"use strict";var n=Object.prototype.toString,r=RegExp.prototype.test.bind(/^[object [A-Za-z0-9]*Function]$/);t.exports=function(e){return"function"==typeof e&&r(n.call(e))}})),lt=ee((function(e,t){"use strict";var n=Object.prototype.toString,r=n.call("");t.exports=function(e){return"string"==typeof e||e&&"object"===a(e)&&(e instanceof String||n.call(e)===r)||!1}})),st=ee((function(e,t){"use strict";var n=ot().iterator,r=it(),a=ut(),o=Fe(),i=Ee(),u=Ce(),l=De(),s=lt(),c=Array.isArray,d=Function.prototype.call,p={configurable:!0,enumerable:!0,writable:!0,value:null},f=Object.defineProperty;t.exports=function(e){var t,m,D,h,g,b,v,y,F,w,E=arguments[1],C=arguments[2];if(e=Object(u(e)),l(E)&&i(E),this&&this!==Array&&a(this))t=this;else{if(!E){if(r(e))return 1!==(g=e.length)?Array.apply(null,e):((h=new Array(1))[0]=e[0],h);if(c(e)){for(h=new Array(g=e.length),m=0;m<g;++m)h[m]=e[m];return h}}h=[]}if(!c(e))if(void 0!==(F=e[n])){\
for(v=i(F).call(e),t&&(h=new t),y=v.next(),m=0;!y.done;)w=E?d.call(E,C,y.value,m):y.value,t?(p.value=w,f(h,m,p)):h[m]=w,y=v.next(),++m;g=m}else if(s(e)){for(g=e.length,t&&(h=new t),D=m=0;m<g;++m)w=e[m],m+1<g&&55296<=(b=w.charCodeAt(0))&&b<=56319&&(w+=e[++m]),w=E?d.call(E,C,w,D):w,t?(p.value=w,f(h,D,p)):h[D]=w,++D;g=D}if(void 0===g)for(g=o(e.length),t&&(h=new t(g)),m=0;m<g;++m)w=E?d.call(E,C,e[m],m):e[m],t?(p.value=w,f(h,m,p)):h[m]=w;return t&&(p.value=null,h.length=g),h}})),ct=ee((function(e,t){"use strict";t.exports=Ye()()?Array.from:st()})),dt=ee((function(e,t){"use strict";var n=ct(),r=Array.isArray;t.exports=function(e){return r(e)?e:n(e)}})),pt=ee((function(e,t){"use strict";var n=dt(),r=De(),a=Ee(),o=Array.prototype.slice,i=function(e){return this.map((function(t,n){return t?t(e[n]):e[n]})).concat(o.call(e,this.length))};t.exports=function(e){return(e=n(e)).forEach((function(e){r(e)&&a(e)})),i.bind(e)}})),ft=ee((function(e,t){"use strict";var n=Ee();t.exports=function(e){var t;re\
turn"function"==typeof e?{set:e,get:e}:(t={get:n(e.get)},void 0!==e.set?(t.set=n(e.set),e.delete&&(t.delete=n(e.delete)),e.clear&&(t.clear=n(e.clear))):t.set=t.get,t)}})),mt=ee((function(e,t){"use strict";var n=Me(),r=Ie(),a=Ge(),o=We().methods,i=pt(),u=ft(),l=Function.prototype.apply,s=Function.prototype.call,c=Object.create,d=Object.defineProperties,p=o.on,f=o.emit;t.exports=function(e,t,o){var m,D,h,g,b,v,y,F,w,E,C,x=c(null),A=!1!==t?t:isNaN(e.length)?1:e.length;return o.normalizer&&(E=u(o.normalizer),D=E.get,h=E.set,g=E.delete,b=E.clear),null!=o.resolvers&&(C=i(o.resolvers)),E=D?r((function(t){var r,a,o=arguments;if(C&&(o=C(o)),null!==(r=D(o))&&hasOwnProperty.call(x,r))return y&&m.emit("get",r,o,this),x[r];if(a=1===o.length?s.call(e,this,o[0]):l.call(e,this,o),null===r){if(null!==(r=D(o)))throw n("Circular invocation","CIRCULAR_INVOCATION");r=h(o)}else if(hasOwnProperty.call(x,r))throw n("Circular invocation","CIRCULAR_INVOCATION");return x[r]=a,F&&m.emit("set",r,null,a),a}),A):0==\
=t?function(){var t;if(hasOwnProperty.call(x,"data"))return y&&m.emit("get","data",arguments,this),x.data;if(t=arguments.length?l.call(e,this,arguments):s.call(e,this),hasOwnProperty.call(x,"data"))throw n("Circular invocation","CIRCULAR_INVOCATION");return x.data=t,F&&m.emit("set","data",null,t),t}:function(t){var r,a=arguments;if(C&&(a=C(arguments)),r=String(a[0]),hasOwnProperty.call(x,r))return y&&m.emit("get",r,a,this),x[r];if(a=1===a.length?s.call(e,this,a[0]):l.call(e,this,a),hasOwnProperty.call(x,r))throw n("Circular invocation","CIRCULAR_INVOCATION");return x[r]=a,F&&m.emit("set",r,null,a),a},m={original:e,memoized:E,profileName:o.profileName,get:function(e){return C&&(e=C(e)),D?D(e):String(e[0])},has:function(e){return hasOwnProperty.call(x,e)},delete:function(e){var t;hasOwnProperty.call(x,e)&&(g&&g(e),t=x[e],delete x[e],w)&&m.emit("delete",e,t)},clear:function(){var e=x;b&&b(),x=c(null),m.emit("clear",e)},on:function(e,t){return"get"===e?y=!0:"set"===e?F=!0:"delete"===e&&(w=\
!0),p.call(this,e,t)},emit:f,updateEnv:function(){e=m.original}},o=D?r((function(e){var t=arguments;C&&(t=C(t)),null!==(t=D(t))&&m.delete(t)}),A):0===t?function(){return m.delete("data")}:function(e){return C&&(e=C(arguments)[0]),m.delete(e)},A=r((function(){var e=arguments;return 0===t?x.data:(C&&(e=C(e)),e=D?D(e):String(e[0]),x[e])})),v=r((function(){var e=arguments;return 0===t?m.has("data"):(C&&(e=C(e)),null!==(e=D?D(e):String(e[0]))&&m.has(e))})),d(E,{__memoized__:a(!0),delete:a(o),clear:a(m.clear),_get:a(A),_has:a(v)}),m}})),Dt=ee((function(e,t){"use strict";var n=Ee(),r=Ae(),a=ke(),o=mt(),i=we();t.exports=function e(t){var u,l,s;if(n(t),(u=Object(arguments[1])).async&&u.promise)throw new Error("Options 'async' and 'promise' cannot be used together");return hasOwnProperty.call(t,"__memoized__")&&!u.force?t:(l=i(u.length,t.length,u.async&&a.async),s=o(t,l,u),r(a,(function(e,t){u[t]&&e(u[t],s,u)})),e.__profiler__&&e.__profiler__(s),s.updateEnv(),s.memoized)}})),ht=ee((function(e,t)\
{"use strict";t.exports=function(e){var t,n,r=e.length;if(!r)return"";for(t=String(e[n=0]);--r;)t+=""+e[++n];return t}})),gt=ee((function(e,t){"use strict";t.exports=function(e){return e?function(t){for(var n=String(t[0]),r=0,a=e;--a;)n+=""+t[++r];return n}:function(){return""}}})),bt=ee((function(e,t){"use strict";t.exports=function(){var e=Number.isNaN;return"function"==typeof e&&!e({})&&e(NaN)&&!e(34)}})),vt=ee((function(e,t){"use strict";t.exports=function(e){return e!=e}})),yt=ee((function(e,t){"use strict";t.exports=bt()()?Number.isNaN:vt()})),Ft=ee((function(e,t){"use strict";var n=yt(),r=Fe(),a=Ce(),o=Array.prototype.indexOf,i=Object.prototype.hasOwnProperty,u=Math.abs,l=Math.floor;t.exports=function(e){var t,s,c;if(!n(e))return o.apply(this,arguments);for(s=r(a(this).length),e=arguments[1],t=e=isNaN(e)?0:0<=e?l(e):r(this.length)-l(u(e));t<s;++t)if(i.call(this,t)&&(c=this[t],n(c)))return t;return-1}})),wt=ee((function(e,t){"use strict";var n=Ft(),r=Object.create;t.exports=fu\
nction(){var e=0,t=[],a=r(null);return{get:function(e){var r,a=0,o=t,i=e.length;if(0===i)return o[i]||null;if(o=o[i]){for(;a<i-1;){if(-1===(r=n.call(o[0],e[a])))return null;o=o[1][r],++a}return-1===(r=n.call(o[0],e[a]))?null:o[1][r]||null}return null},set:function(r){var o,i=0,u=t,l=r.length;if(0===l)u[l]=++e;else{for(u[l]||(u[l]=[[],[]]),u=u[l];i<l-1;)-1===(o=n.call(u[0],r[i]))&&(o=u[0].push(r[i])-1,u[1].push([[],[]])),u=u[1][o],++i;-1===(o=n.call(u[0],r[i]))&&(o=u[0].push(r[i])-1),u[1][o]=++e}return a[e]=r,e},delete:function(e){var r,o=0,i=t,u=a[e],l=u.length,s=[];if(0===l)delete i[l];else if(i=i[l]){for(;o<l-1;){if(-1===(r=n.call(i[0],u[o])))return;s.push(i,r),i=i[1][r],++o}if(-1===(r=n.call(i[0],u[o])))return;for(e=i[1][r],i[0].splice(r,1),i[1].splice(r,1);!i[0].length&&s.length;)r=s.pop(),(i=s.pop())[0].splice(r,1),i[1].splice(r,1)}delete a[e]},clear:function(){t=[],a=r(null)}}}})),Et=ee((function(e,t){"use strict";var n=Ft();t.exports=function(){var e=0,t=[],r=[];return{get:funct\
ion(e){return-1===(e=n.call(t,e[0]))?null:r[e]},set:function(n){return t.push(n[0]),r.push(++e),e},delete:function(e){-1!==(e=n.call(r,e))&&(t.splice(e,1),r.splice(e,1))},clear:function(){t=[],r=[]}}}})),Ct=ee((function(e,t){"use strict";var n=Ft(),r=Object.create;t.exports=function(e){var t=0,a=[[],[]],o=r(null);return{get:function(t){for(var r,o=0,i=a;o<e-1;){if(-1===(r=n.call(i[0],t[o])))return null;i=i[1][r],++o}return-1!==(r=n.call(i[0],t[o]))&&i[1][r]||null},set:function(r){for(var i,u=0,l=a;u<e-1;)-1===(i=n.call(l[0],r[u]))&&(i=l[0].push(r[u])-1,l[1].push([[],[]])),l=l[1][i],++u;return-1===(i=n.call(l[0],r[u]))&&(i=l[0].push(r[u])-1),l[1][i]=++t,o[t]=r,t},delete:function(t){for(var r,i=0,u=a,l=[],s=o[t];i<e-1;){if(-1===(r=n.call(u[0],s[i])))return;l.push(u,r),u=u[1][r],++i}if(-1!==(r=n.call(u[0],s[i]))){for(t=u[1][r],u[0].splice(r,1),u[1].splice(r,1);!u[0].length&&l.length;)r=l.pop(),(u=l.pop())[0].splice(r,1),u[1].splice(r,1);delete o[t]}},clear:function(){a=[[],[]],o=r(null)}}\
}})),xt=ee((function(e,t){"use strict";var n=Ee(),r=Ae(),a=Function.prototype.call;t.exports=function(e,t){var o={},i=arguments[2];return n(t),r(e,(function(e,n,r,u){o[n]=a.call(t,i,e,n,r,u)})),o}})),At=ee((function(e,t){"use strict";function n(e){if("function"!=typeof e)throw new TypeError(e+" is not a function");return e}function o(e){var t,a,o=r.createTextNode(""),i=0;return new e((function(){var e;if(t)a&&(t=a.concat(t));else{if(!a)return;t=a}if(a=t,t=null,"function"==typeof a)e=a,a=null,e();else for(o.data=i=++i%2;a;)e=a.shift(),a.length||(a=null),e()})).observe(o,{characterData:!0}),function(e){n(e),t?"function"==typeof t?t=[t,e]:t.push(e):(t=e,o.data=i=++i%2)}}t.exports=function(){if("object"===("undefined"==typeof process?"undefined":a(process))&&process&&"function"==typeof process.nextTick)return process.nextTick;if("function"==typeof queueMicrotask)return function(e){queueMicrotask(n(e))};if("object"===(void 0===r?"undefined":a(r))&&r){if("function"==typeof MutationObserver)r\
eturn o(MutationObserver);if("function"==typeof WebKitMutationObserver)return o(WebKitMutationObserver)}return"function"==typeof setImmediate?function(e){setImmediate(n(e))}:"function"==typeof setTimeout||"object"===("undefined"==typeof setTimeout?"undefined":a(setTimeout))?function(e){setTimeout(n(e),0)}:null}()})),kt=ee((function(){"use strict";var e=ct(),t=xt(),n=Pe(),r=Ie(),a=At(),o=Array.prototype.slice,i=Function.prototype.apply,u=Object.create;ke().async=function(l,s){var c,d,p,f=u(null),m=u(null),D=s.memoized,h=s.original;s.memoized=r((function(e){var t=arguments,n=t[t.length-1];return"function"==typeof n&&(c=n,t=o.call(t,0,-1)),D.apply(d=this,p=t)}),D);try{n(s.memoized,D)}catch(l){}s.on("get",(function(e){var t,n,r;c&&(f[e]?("function"==typeof f[e]?f[e]=[f[e],c]:f[e].push(c),c=null):(t=c,n=d,r=p,c=d=p=null,a((function(){var a;hasOwnProperty.call(m,e)?(a=m[e],s.emit("getasync",e,r,n),i.call(t,a.context,a.args)):(c=t,d=n,p=r,D.apply(n,r))}))))})),s.original=function(){var t,n,r,\
o;return c?(t=e(arguments),r=c,c=d=p=null,t.push(n=function t(n){var r,u,l=t.id;if(null==l)a(i.bind(t,this,arguments));else if(delete t.id,r=f[l],delete f[l],r)return u=e(arguments),s.has(l)&&(n?s.delete(l):(m[l]={context:this,args:u},s.emit("setasync",l,"function"==typeof r?1:r.length))),"function"==typeof r?o=i.call(r,this,u):r.forEach((function(e){o=i.call(e,this,u)}),this),o}),o=i.call(h,this,t),n.cb=r,c=n,o):i.call(h,this,arguments)},s.on("set",(function(e){c?(f[e]?"function"==typeof f[e]?f[e]=[f[e],c.cb]:f[e].push(c.cb):f[e]=c.cb,delete c.cb,c.id=e,c=null):s.delete(e)})),s.on("delete",(function(e){var t;hasOwnProperty.call(f,e)||m[e]&&(t=m[e],delete m[e],s.emit("deleteasync",e,o.call(t.args,1)))})),s.on("clear",(function(){var e=m;m=u(null),s.emit("clearasync",t(e,(function(e){return o.call(e.args,1)})))}))}})),Nt=ee((function(e,t){"use strict";var n=Array.prototype.forEach,r=Object.create;t.exports=function(e){var t=r(null);return n.call(arguments,(function(e){t[e]=!0})),t}})),B\
t=ee((function(e,t){"use strict";t.exports=function(e){return"function"==typeof e}})),Tt=ee((function(e,t){"use strict";var n=Bt();t.exports=function(e){try{return e&&n(e.toString)?e.toString():String(e)}catch(e){throw new TypeError("Passed argument cannot be stringifed")}}})),Rt=ee((function(e,t){"use strict";var n=Ce(),r=Tt();t.exports=function(e){return r(n(e))}})),_t=ee((function(e,t){"use strict";var n=Bt();t.exports=function(e){try{return e&&n(e.toString)?e.toString():String(e)}catch(e){return"<Non-coercible to string value>"}}})),Ot=ee((function(e,t){"use strict";var n=_t(),r=/[\\n\\r\\u2028\\u2029]/g;t.exports=function(e){return(e=100<(e=n(e)).length?e.slice(0,99)+"…":e).replace(r,(function(e){return JSON.stringify(e).slice(1,-1)}))}})),St=ee((function(e,t){function n(e){return!!e&&("object"===a(e)||"function"==typeof e)&&"function"==typeof e.then}t.exports=n,t.exports.default=n})),Mt=ee((function(){"use strict";var e=xt(),t=Nt(),n=Rt(),r=Ot(),a=St(),o=At(),i=Object.create,u=t("the\
n","then:finally","done","done:finally");ke().promise=function(t,l){var s=i(null),c=i(null),d=i(null);if(!0===t)t=null;else if(t=n(t),!u[t])throw new TypeError("'"+r(t)+"' is not valid promise mode");l.on("set",(function(e,n,r){var i=!1;if(a(r)){s[e]=1,d[e]=r;var u=function(t){var n=s[e];if(i)throw new Error("Memoizee error: Detected unordered then|done & finally resolution, which in turn makes proper detection of success/failure impossible (when in 'done:finally' mode)\\nConsider to rely on 'then' or 'done' mode instead.");n&&(delete s[e],c[e]=t,l.emit("setasync",e,n))},p=function(){i=!0,s[e]&&(delete s[e],delete d[e],l.delete(e))},f=t;if("then"===(f=f||"then")){var m=function(){o(p)};"function"==typeof(r=r.then((function(e){o(u.bind(this,e))}),m)).finally&&r.finally(m)}else if("done"===f){if("function"!=typeof r.done)throw new Error("Memoizee error: Retrieved promise does not implement 'done' in 'done' mode");r.done(u,p)}else if("done:finally"===f){if("function"!=typeof r.done)throw n\
ew Error("Memoizee error: Retrieved promise does not implement 'done' in 'done:finally' mode");if("function"!=typeof r.finally)throw new Error("Memoizee error: Retrieved promise does not implement 'finally' in 'done:finally' mode");r.done(u),r.finally(p)}}else c[e]=r,l.emit("setasync",e,1)})),l.on("get",(function(e,t,n){var r,i;s[e]?++s[e]:(r=d[e],i=function(){l.emit("getasync",e,t,n)},a(r)?"function"==typeof r.done?r.done(i):r.then((function(){o(i)})):i())})),l.on("delete",(function(e){var t;delete d[e],s[e]?delete s[e]:hasOwnProperty.call(c,e)&&(t=c[e],delete c[e],l.emit("deleteasync",e,[t]))})),l.on("clear",(function(){var t=c;c=i(null),s=i(null),d=i(null),l.emit("clearasync",e(t,(function(e){return[e]})))}))}})),Pt=ee((function(){"use strict";var e=Ee(),t=Ae(),n=ke(),r=Function.prototype.apply;n.dispose=function(a,o,i){var u;e(a),i.async&&n.async||i.promise&&n.promise?(o.on("deleteasync",u=function(e,t){r.call(a,null,t)}),o.on("clearasync",(function(e){t(e,(function(e,t){u(t,e)}))}\
))):(o.on("delete",u=function(e,t){a(t)}),o.on("clear",(function(e){t(e,(function(e,t){u(t,e)}))})))}})),It=ee((function(e,t){"use strict";t.exports=2147483647})),jt=ee((function(e,t){"use strict";var n=Fe(),r=It();t.exports=function(e){if(e=n(e),r<e)throw new TypeError(e+" exceeds maximum possible timeout");return e}})),Lt=ee((function(){"use strict";var e=ct(),t=Ae(),n=At(),r=St(),a=jt(),o=ke(),i=Function.prototype,u=Math.max,l=Math.min,s=Object.create;o.maxAge=function(c,d,p){var f,m,D,h;(c=a(c))&&(f=s(null),m=p.async&&o.async||p.promise&&o.promise?"async":"",d.on("set"+m,(function(e){f[e]=setTimeout((function(){d.delete(e)}),c),"function"==typeof f[e].unref&&f[e].unref(),h&&(h[e]&&"nextTick"!==h[e]&&clearTimeout(h[e]),h[e]=setTimeout((function(){delete h[e]}),D),"function"==typeof h[e].unref)&&h[e].unref()})),d.on("delete"+m,(function(e){clearTimeout(f[e]),delete f[e],h&&("nextTick"!==h[e]&&clearTimeout(h[e]),delete h[e])})),p.preFetch&&(D=!0===p.preFetch||isNaN(p.preFetch)?.333:u(\
l(Number(p.preFetch),1),0))&&(h={},D=(1-D)*c,d.on("get"+m,(function(t,a,o){h[t]||(h[t]="nextTick",n((function(){var n;"nextTick"===h[t]&&(delete h[t],d.delete(t),p.async&&(a=e(a)).push(i),n=d.memoized.apply(o,a),p.promise)&&r(n)&&("function"==typeof n.done?n.done(i,i):n.then(i,i))})))}))),d.on("clear"+m,(function(){t(f,(function(e){clearTimeout(e)})),f={},h&&(t(h,(function(e){"nextTick"!==e&&clearTimeout(e)})),h={})})))}})),qt=ee((function(e,t){"use strict";var n=Fe(),r=Object.create,a=Object.prototype.hasOwnProperty;t.exports=function(e){var t,o=0,i=1,u=r(null),l=r(null),s=0;return e=n(e),{hit:function(n){var r=l[n],c=++s;if(u[c]=n,l[n]=c,!r)return++o<=e?void 0:(n=u[i],t(n),n);if(delete u[r],i===r)for(;!a.call(u,++i););},delete:t=function(e){var t=l[e];if(t&&(delete u[t],delete l[e],--o,i===t))if(o)for(;!a.call(u,++i););else s=0,i=1},clear:function(){o=0,i=1,u=r(null),l=r(null),s=0}}}})),zt=ee((function(){"use strict";var e=Fe(),t=qt(),n=ke();n.max=function(r,a,o){var i;(r=e(r))&&(i=t\
(r),r=o.async&&n.async||o.promise&&n.promise?"async":"",a.on("set"+r,o=function(e){void 0!==(e=i.hit(e))&&a.delete(e)}),a.on("get"+r,o),a.on("delete"+r,i.delete),a.on("clear"+r,i.clear))}})),Vt=ee((function(){"use strict";var e=Ge(),t=ke(),n=Object.create,r=Object.defineProperties;t.refCounter=function(a,o,i){var u=n(null);i=i.async&&t.async||i.promise&&t.promise?"async":"";o.on("set"+i,(function(e,t){u[e]=t||1})),o.on("get"+i,(function(e){++u[e]})),o.on("delete"+i,(function(e){delete u[e]})),o.on("clear"+i,(function(){u={}})),r(o.memoized,{deleteRef:e((function(){var e=o.get(arguments);return null!==e&&u[e]?!--u[e]&&(o.delete(e),!0):null})),getRefCount:e((function(){var e=o.get(arguments);return null!==e&&u[e]||0}))})}})),$t=ee((function(e,t){"use strict";var n=he(),r=we(),a=Dt();t.exports=function(e){var t,o=n(arguments[1]);return o.normalizer||0!==(t=o.length=r(o.length,e.length,o.async))&&(o.primitive?!1===t?o.normalizer=ht():1<t&&(o.normalizer=gt()(t)):o.normalizer=!1===t?wt()():1\
===t?Et()():Ct()(t)),o.async&&kt(),o.promise&&Mt(),o.dispose&&Pt(),o.maxAge&&Lt(),o.max&&zt(),o.refCounter&&Vt(),a(e,o)}})),Ht=ee((function(e){"use strict";Object.defineProperty(e,"__esModule",{value:!0}),e.isIdentStart=function(e){return"a"<=e&&e<="z"||"A"<=e&&e<="Z"||"-"===e||"_"===e},e.isIdent=function(e){return"a"<=e&&e<="z"||"A"<=e&&e<="Z"||"0"<=e&&e<="9"||"-"===e||"_"===e},e.isHex=function(e){return"a"<=e&&e<="f"||"A"<=e&&e<="F"||"0"<=e&&e<="9"},e.escapeIdentifier=function(t){for(var n=t.length,r="",a=0;a<n;){var o=t.charAt(a);if(e.identSpecialChars[o])r+="\\\\"+o;else if("_"===o||"-"===o||"A"<=o&&o<="Z"||"a"<=o&&o<="z"||0!==a&&"0"<=o&&o<="9")r+=o;else{if(55296==(63488&(o=o.charCodeAt(0)))){var i=t.charCodeAt(a++);if(55296!=(64512&o)||56320!=(64512&i))throw Error("UCS-2(decode): illegal sequence");o=((1023&o)<<10)+(1023&i)+65536}r+="\\\\"+o.toString(16)+" "}a++}return r},e.escapeStr=function(t){for(var n,r=t.length,a="",o=0;o<r;){var i=t.charAt(o);'"'===i?i='\\\\"':"\\\\"===i?i="\\\\\\\\":vo\
id 0!==(n=e.strReplacementsRev[i])&&(i=n),a+=i,o++}return'"'+a+'"'},e.identSpecialChars={"!":!0,'"':!0,"#":!0,$:!0,"%":!0,"&":!0,"'":!0,"(":!0,")":!0,"*":!0,"+":!0,",":!0,".":!0,"/":!0,";":!0,"<":!0,"=":!0,">":!0,"?":!0,"@":!0,"[":!0,"\\\\":!0,"]":!0,"^":!0,"\`":!0,"{":!0,"|":!0,"}":!0,"~":!0},e.strReplacementsRev={"\\n":"\\\\n","\\r":"\\\\r","\\t":"\\\\t","\\f":"\\\\f","\\v":"\\\\v"},e.singleQuoteEscapeChars={n:"\\n",r:"\\r",t:"\\t",f:"\\f","\\\\":"\\\\","'":"'"},e.doubleQuotesEscapeChars={n:"\\n",r:"\\r",t:"\\t",f:"\\f","\\\\":"\\\\",'"':'"'}})),Ut=ee((function(e){"use strict";Object.defineProperty(e,"__esModule",{value:!0});var t=Ht();e.parseCssSelector=function(e,n,r,a,o,i){var u=e.length,l="";function s(r,a){var o="";for(n++,l=e.charAt(n);n<u;){if(l===r)return n++,o;var i;if("\\\\"===l)if(n++,(l=e.charAt(n))===r)o+=r;else if(void 0!==(i=a[l]))o+=i;else{if(t.isHex(l)){var s=l;for(n++,l=e.charAt(n);t.isHex(l);)s+=l,n++,l=e.charAt(n);" "===l&&(n++,l=e.charAt(n)),o+=String.fromCharCode(parseInt(s,16));continue}o+=l}else\
 o+=l;n++,l=e.charAt(n)}return o}function c(){var r="";for(l=e.charAt(n);n<u;){if(!t.isIdent(l)){if("\\\\"!==l)return r;if(u<=++n)throw Error("Expected symbol but end of file reached.");if(l=e.charAt(n),!t.identSpecialChars[l]&&t.isHex(l)){var a=l;for(n++,l=e.charAt(n);t.isHex(l);)a+=l,n++,l=e.charAt(n);" "===l&&(n++,l=e.charAt(n)),r+=String.fromCharCode(parseInt(a,16));continue}}r+=l,n++,l=e.charAt(n)}return r}function d(){for(l=e.charAt(n);" "===l||"\\t"===l||"\\n"===l||"\\r"===l||"\\f"===l;)n++,l=e.charAt(n)}function p(){var t=f();if(!t)return null;var r=t;for(l=e.charAt(n);","===l;){if(n++,d(),"selectors"!==r.type&&(r={type:"selectors",selectors:[t]}),!(t=f()))throw Error('Rule expected after ",".');r.selectors.push(t)}return r}function f(){d();var t={type:"ruleSet"},r=m();if(!r)return null;for(var a=t;r&&(r.type="rule",a.rule=r,a=r,d(),l=e.charAt(n),!(u<=n||","===l||")"===l));)if(o[l]){var i=l;if(n++,d(),!(r=m()))throw Error('Rule expected after "'+i+'".');r.nestingOperator=i}else(r=m()\
)&&(r.nestingOperator=null);return t}function m(){for(var o=null;n<u;)if("*"===(l=e.charAt(n)))n++,(o=o||{}).tagName="*";else if(t.isIdentStart(l)||"\\\\"===l)(o=o||{}).tagName=c();else if("."===l)n++,((o=o||{}).classNames=o.classNames||[]).push(c());else if("#"===l)n++,(o=o||{}).id=c();else if("["===l){n++,d();var f={name:c()};if(d(),"]"===l)n++;else{var m="";if(a[l]&&(m=l,n++,l=e.charAt(n)),u<=n)throw Error('Expected "=" but end of file reached.');if("="!==l)throw Error('Expected "=" but "'+l+'" found.');f.operator=m+"=",n++,d();var D="";if(f.valueType="string",'"'===l)D=s('"',t.doubleQuotesEscapeChars);else if("'"===l)D=s("'",t.singleQuoteEscapeChars);else if(i&&"$"===l)n++,D=c(),f.valueType="substitute";else{for(;n<u&&"]"!==l;)D+=l,n++,l=e.charAt(n);D=D.trim()}if(d(),u<=n)throw Error('Expected "]" but end of file reached.');if("]"!==l)throw Error('Expected "]" but "'+l+'" found.');n++,f.value=D}((o=o||{}).attrs=o.attrs||[]).push(f)}else{if(":"!==l)break;if(n++,f={name:m=c()},"("===l)\
{n++;var h="";if(d(),"selector"===r[m])f.valueType="selector",h=p();else{if(f.valueType=r[m]||"string",'"'===l)h=s('"',t.doubleQuotesEscapeChars);else if("'"===l)h=s("'",t.singleQuoteEscapeChars);else if(i&&"$"===l)n++,h=c(),f.valueType="substitute";else{for(;n<u&&")"!==l;)h+=l,n++,l=e.charAt(n);h=h.trim()}d()}if(u<=n)throw Error('Expected ")" but end of file reached.');if(")"!==l)throw Error('Expected ")" but "'+l+'" found.');n++,f.value=h}((o=o||{}).pseudos=o.pseudos||[]).push(f)}return o}var D=p();if(n<u)throw Error('Rule expected but "'+e.charAt(n)+'" found.');return D}})),Gt=ee((function(e){"use strict";Object.defineProperty(e,"__esModule",{value:!0});var t=Ht();e.renderEntity=function e(n){var r="";switch(n.type){case"ruleSet":for(var a=n.rule,o=[];a;)a.nestingOperator&&o.push(a.nestingOperator),o.push(e(a)),a=a.rule;r=o.join(" ");break;case"selectors":r=n.selectors.map(e).join(", ");break;case"rule":n.tagName&&(r="*"===n.tagName?"*":t.escapeIdentifier(n.tagName)),n.id&&(r+="#"+t\
.escapeIdentifier(n.id)),n.classNames&&(r+=n.classNames.map((function(e){return"."+t.escapeIdentifier(e)})).join("")),n.attrs&&(r+=n.attrs.map((function(e){return"operator"in e?"substitute"===e.valueType?"["+t.escapeIdentifier(e.name)+e.operator+"$"+e.value+"]":"["+t.escapeIdentifier(e.name)+e.operator+t.escapeStr(e.value)+"]":"["+t.escapeIdentifier(e.name)+"]"})).join("")),n.pseudos&&(r+=n.pseudos.map((function(n){return n.valueType?"selector"===n.valueType?":"+t.escapeIdentifier(n.name)+"("+e(n.value)+")":"substitute"===n.valueType?":"+t.escapeIdentifier(n.name)+"($"+n.value+")":"numeric"===n.valueType?":"+t.escapeIdentifier(n.name)+"("+n.value+")":":"+t.escapeIdentifier(n.name)+"("+t.escapeIdentifier(n.value)+")":":"+t.escapeIdentifier(n.name)})).join(""));break;default:throw Error('Unknown entity type: "'+n.type+'".')}return r}})),Wt=ee((function(e){"use strict";Object.defineProperty(e,"__esModule",{value:!0});var t=Ut(),n=Gt();function r(){this.pseudos={},this.attrEqualityMods={},\
this.ruleNestingOperators={},this.substitutesEnabled=!1}r.prototype.registerSelectorPseudos=function(){for(var e=[],t=0;t<arguments.length;t++)e[t]=arguments[t];for(var n=0,r=e;n<r.length;n++)this.pseudos[r[n]]="selector";return this},r.prototype.unregisterSelectorPseudos=function(){for(var e=[],t=0;t<arguments.length;t++)e[t]=arguments[t];for(var n=0,r=e;n<r.length;n++)delete this.pseudos[r[n]];return this},r.prototype.registerNumericPseudos=function(){for(var e=[],t=0;t<arguments.length;t++)e[t]=arguments[t];for(var n=0,r=e;n<r.length;n++)this.pseudos[r[n]]="numeric";return this},r.prototype.unregisterNumericPseudos=function(){for(var e=[],t=0;t<arguments.length;t++)e[t]=arguments[t];for(var n=0,r=e;n<r.length;n++)delete this.pseudos[r[n]];return this},r.prototype.registerNestingOperators=function(){for(var e=[],t=0;t<arguments.length;t++)e[t]=arguments[t];for(var n=0,r=e;n<r.length;n++)this.ruleNestingOperators[r[n]]=!0;return this},r.prototype.unregisterNestingOperators=function(){\
for(var e=[],t=0;t<arguments.length;t++)e[t]=arguments[t];for(var n=0,r=e;n<r.length;n++)delete this.ruleNestingOperators[r[n]];return this},r.prototype.registerAttrEqualityMods=function(){for(var e=[],t=0;t<arguments.length;t++)e[t]=arguments[t];for(var n=0,r=e;n<r.length;n++)this.attrEqualityMods[r[n]]=!0;return this},r.prototype.unregisterAttrEqualityMods=function(){for(var e=[],t=0;t<arguments.length;t++)e[t]=arguments[t];for(var n=0,r=e;n<r.length;n++)delete this.attrEqualityMods[r[n]];return this},r.prototype.enableSubstitutes=function(){return this.substitutesEnabled=!0,this},r.prototype.disableSubstitutes=function(){return this.substitutesEnabled=!1,this},r.prototype.parse=function(e){return t.parseCssSelector(e,0,this.pseudos,this.attrEqualityMods,this.ruleNestingOperators,this.substitutesEnabled)},r.prototype.render=function(e){return n.renderEntity(e).trim()},e.CssSelectorParser=r})),Yt=ee((function(e,o){var i;i=function(){"use strict";function e(e){return"function"==typeof \
e}var o=Array.isArray||function(e){return"[object Array]"===Object.prototype.toString.call(e)},i=0,u=void 0,l=void 0,s=function(e,t){D[i]=e,D[i+1]=t,2===(i+=2)&&(l?l(h):y())},c=void 0!==t?t:void 0,d=(d=c||{}).MutationObserver||d.WebKitMutationObserver,p="undefined"==typeof self&&"undefined"!=typeof process&&"[object process]"==={}.toString.call(process),f="undefined"!=typeof Uint8ClampedArray&&"undefined"!=typeof importScripts&&"undefined"!=typeof MessageChannel;function m(){var e=setTimeout;return function(){return e(h,1)}}var D=new Array(1e3);function h(){for(var e=0;e<i;e+=2)(0,D[e])(D[e+1]),D[e]=void 0,D[e+1]=void 0;i=0}var g,b,v,y=void 0;function F(e,t){var n,r=this,a=new this.constructor(C),o=(void 0===a[E]&&I(a),r._state);return o?(n=arguments[o-1],s((function(){return M(o,a,n,r._result)}))):O(r,a,e,t),a}function w(e){var t;return e&&"object"===a(e)&&e.constructor===this?e:(B(t=new this(C),e),t)}y=p?function(){return process.nextTick(h)}:d?(b=0,p=new d(h),v=r.createTextNode(""),\
p.observe(v,{characterData:!0}),function(){v.data=b=++b%2}):f?((g=new MessageChannel).port1.onmessage=h,function(){return g.port2.postMessage(0)}):(void 0===c?function(){try{var e=Function("return this")().require("vertx");return void 0!==(u=e.runOnLoop||e.runOnContext)?function(){u(h)}:m()}catch(e){return m()}}:m)();var E=Math.random().toString(36).substring(2);function C(){}var x=void 0,A=1,k=2;function N(t,n,r){var a,o;n.constructor===t.constructor&&r===F&&n.constructor.resolve===w?(a=t,(o=n)._state===A?R(a,o._result):o._state===k?_(a,o._result):O(o,void 0,(function(e){return B(a,e)}),(function(e){return _(a,e)}))):void 0!==r&&e(r)?function(e,t,n){s((function(e){var r=!1,a=function(e,t,n,r){try{e.call(t,n,r)}catch(e){return e}}(n,t,(function(n){r||(r=!0,(t!==n?B:R)(e,n))}),(function(t){r||(r=!0,_(e,t))}),e._label);!r&&a&&(r=!0,_(e,a))}),e)}(t,n,r):R(t,n)}function B(e,t){if(e===t)_(e,new TypeError("You cannot resolve a promise with itself"));else if(r=a(n=t),null===n||"object"!==r&&"\
function"!==r)R(e,t);else{n=void 0;try{n=t.then}catch(t){return void _(e,t)}N(e,t,n)}var n,r}function T(e){e._onerror&&e._onerror(e._result),S(e)}function R(e,t){e._state===x&&(e._result=t,e._state=A,0!==e._subscribers.length)&&s(S,e)}function _(e,t){e._state===x&&(e._state=k,e._result=t,s(T,e))}function O(e,t,n,r){var a=e._subscribers,o=a.length;e._onerror=null,a[o]=t,a[o+A]=n,a[o+k]=r,0===o&&e._state&&s(S,e)}function S(e){var t=e._subscribers,n=e._state;if(0!==t.length){for(var r,a=void 0,o=e._result,i=0;i<t.length;i+=3)r=t[i],a=t[i+n],r?M(n,r,a,o):a(o);e._subscribers.length=0}}function M(t,n,r,a){var o=e(r),i=void 0,u=void 0,l=!0;if(o){try{i=r(a)}catch(t){l=!1,u=t}if(n===i)return void _(n,new TypeError("A promises callback cannot return that same promise."))}else i=a;n._state===x&&(o&&l?B(n,i):!1===l?_(n,u):t===A?R(n,i):t===k&&_(n,i))}var P=0;function I(e){e[E]=P++,e._state=void 0,e._result=void 0,e._subscribers=[]}L.prototype._enumerate=function(e){for(var t=0;this._state===x&&t<e.\
length;t++)this._eachEntry(e[t],t)},L.prototype._eachEntry=function(e,t){var n=this._instanceConstructor,r=n.resolve;if(r===w){var a,o=void 0,i=void 0,u=!1;try{o=e.then}catch(t){u=!0,i=t}o===F&&e._state!==x?this._settledAt(e._state,t,e._result):"function"!=typeof o?(this._remaining--,this._result[t]=e):n===q?(a=new n(C),u?_(a,i):N(a,e,o),this._willSettleAt(a,t)):this._willSettleAt(new n((function(t){return t(e)})),t)}else this._willSettleAt(r(e),t)},L.prototype._settledAt=function(e,t,n){var r=this.promise;r._state===x&&(this._remaining--,e===k?_(r,n):this._result[t]=n),0===this._remaining&&R(r,this._result)},L.prototype._willSettleAt=function(e,t){var n=this;O(e,void 0,(function(e){return n._settledAt(A,t,e)}),(function(e){return n._settledAt(k,t,e)}))};var j=L;function L(e,t){this._instanceConstructor=e,this.promise=new e(C),this.promise[E]||I(this.promise),o(t)?(this.length=t.length,this._remaining=t.length,this._result=new Array(this.length),0!==this.length&&(this.length=this.lengt\
h||0,this._enumerate(t),0!==this._remaining)||R(this.promise,this._result)):_(this.promise,new Error("Array Methods must be provided an Array"))}z.prototype.catch=function(e){return this.then(null,e)},z.prototype.finally=function(t){var n=this.constructor;return e(t)?this.then((function(e){return n.resolve(t()).then((function(){return e}))}),(function(e){return n.resolve(t()).then((function(){throw e}))})):this.then(t,t)};var q=z;function z(e){if(this[E]=P++,this._result=this._state=void 0,this._subscribers=[],C!==e){if("function"!=typeof e)throw new TypeError("You must pass a resolver function as the first argument to the promise constructor");if(!(this instanceof z))throw new TypeError("Failed to construct 'Promise': Please use the 'new' operator, this object constructor cannot be called as a function.");var t=this;try{e((function(e){B(t,e)}),(function(e){_(t,e)}))}catch(e){_(t,e)}}}return q.prototype.then=F,q.all=function(e){return new j(this,e).promise},q.race=function(e){var t=thi\
s;return o(e)?new t((function(n,r){for(var a=e.length,o=0;o<a;o++)t.resolve(e[o]).then(n,r)})):new t((function(e,t){return t(new TypeError("You must pass an array to race."))}))},q.resolve=w,q.reject=function(e){var t=new this(C);return _(t,e),t},q._setScheduler=function(e){l=e},q._setAsap=function(e){s=e},q._asap=s,q.polyfill=function(){var e=void 0;if(void 0!==n)e=n;else if("undefined"!=typeof self)e=self;else try{e=Function("return this")()}catch(e){throw new Error("polyfill failed because global object is unavailable in this environment")}var t=e.Promise;if(t){var r=null;try{r=Object.prototype.toString.call(t.resolve())}catch(e){}if("[object Promise]"===r&&!t.cast)return}e.Promise=q},q.Promise=q},"object"===a(e)&&void 0!==o?o.exports=i():"function"==typeof define&&define.amd?define(i):e.ES6Promise=i()})),Kt=ee((function(e){var t,n,r=1e5,o=(t=Object.prototype.toString,n=Object.prototype.hasOwnProperty,{Class:function(e){return t.call(e).replace(/^\\[object *|\\]$/g,"")},HasProperty:fu\
nction(e,t){return t in e},HasOwnProperty:function(e,t){return n.call(e,t)},IsCallable:function(e){return"function"==typeof e},ToInt32:function(e){return e>>0},ToUint32:function(e){return e>>>0}}),i=Math.LN2,u=Math.abs,l=Math.floor,s=Math.log,c=Math.min,d=Math.pow,p=Math.round;function f(e,t,n){return e<t?t:n<e?n:e}var m,D,h,g,b,v,y,F,w,E,C,x=Object.getOwnPropertyNames||function(e){if(e!==Object(e))throw new TypeError("Object.getOwnPropertyNames called on non-object");var t,n=[];for(t in e)o.HasOwnProperty(e,t)&&n.push(t);return n};function A(e){if(x&&m)for(var t=x(e),n=0;n<t.length;n+=1)m(e,t[n],{value:e[t[n]],writable:!1,enumerable:!1,configurable:!1})}function k(e){if(m){if(e.length>r)throw new RangeError("Array too large for polyfill");for(var t=0;t<e.length;t+=1)!function(t){m(e,t,{get:function(){return e._getter(t)},set:function(n){e._setter(t,n)},enumerable:!0,configurable:!1})}(t)}}function N(e,t){return e<<(t=32-t)>>t}function B(e,t){return e<<(t=32-t)>>>t}function T(e){return\
 B(e[0],8)}function R(e,t,n){var r,a,o,p,f,m,D,h=(1<<t-1)-1;function g(e){var t=l(e);return(e=e-t)<.5||!(.5<e||t%2)?t:t+1}for(e!=e?(a=(1<<t)-1,o=d(2,n-1),r=0):e===1/0||e===-1/0?(a=(1<<t)-1,r=e<(o=0)?1:0):0===e?r=1/e==-1/(o=a=0)?1:0:(r=e<0,(e=u(e))>=d(2,1-h)?(a=c(l(s(e)/i),1023),2<=(o=g(e/d(2,a)*d(2,n)))/d(2,n)&&(a+=1,o=1),h<a?(a=(1<<t)-1,o=0):(a+=h,o-=d(2,n))):(a=0,o=g(e/d(2,1-h-n)))),f=[],p=n;p;--p)f.push(o%2?1:0),o=l(o/2);for(p=t;p;--p)f.push(a%2?1:0),a=l(a/2);for(f.push(r?1:0),f.reverse(),m=f.join(""),D=[];m.length;)D.push(parseInt(m.substring(0,8),2)),m=m.substring(8);return D}function _(e,t,n){for(var r,a,o,i,u,l,s=[],c=e.length;c;--c)for(a=e[c-1],r=8;r;--r)s.push(a%2?1:0),a>>=1;return s.reverse(),l=s.join(""),o=(1<<t-1)-1,i=parseInt(l.substring(0,1),2)?-1:1,u=parseInt(l.substring(1,1+t),2),l=parseInt(l.substring(1+t),2),u===(1<<t)-1?0===l?1/0*i:NaN:0<u?i*d(2,u-o)*(1+l/d(2,n)):0!==l?i*d(2,-(o-1))*(l/d(2,n)):i<0?-0:0}function O(e){if((e=o.ToInt32(e))<0)throw new RangeError("ArrayBu\
ffer size is not a small enough positive integer");var t;for(this.byteLength=e,this._bytes=[],this._bytes.length=e,t=0;t<this.byteLength;t+=1)this._bytes[t]=0;A(this)}function S(){}function M(e,t,n){var r=function(e,t,n){var i,u,l,s;if(arguments.length&&"number"!=typeof e)if("object"===a(e)&&e.constructor===r)for(this.length=(i=e).length,this.byteLength=this.length*this.BYTES_PER_ELEMENT,this.buffer=new O(this.byteLength),l=this.byteOffset=0;l<this.length;l+=1)this._setter(l,i._getter(l));else if("object"!==a(e)||e instanceof O||"ArrayBuffer"===o.Class(e)){if("object"!==a(e)||!(e instanceof O||"ArrayBuffer"===o.Class(e)))throw new TypeError("Unexpected argument type(s)");if(this.buffer=e,this.byteOffset=o.ToUint32(t),this.byteOffset>this.buffer.byteLength)throw new RangeError("byteOffset out of range");if(this.byteOffset%this.BYTES_PER_ELEMENT)throw new RangeError("ArrayBuffer length minus the byteOffset is not a multiple of the element size.");if(arguments.length<3){if(this.byteLength\
=this.buffer.byteLength-this.byteOffset,this.byteLength%this.BYTES_PER_ELEMENT)throw new RangeError("length of buffer minus byteOffset not a multiple of the element size");this.length=this.byteLength/this.BYTES_PER_ELEMENT}else this.length=o.ToUint32(n),this.byteLength=this.length*this.BYTES_PER_ELEMENT;if(this.byteOffset+this.byteLength>this.buffer.byteLength)throw new RangeError("byteOffset and length reference an area beyond the end of the buffer")}else for(this.length=o.ToUint32((u=e).length),this.byteLength=this.length*this.BYTES_PER_ELEMENT,this.buffer=new O(this.byteLength),l=this.byteOffset=0;l<this.length;l+=1)s=u[l],this._setter(l,Number(s));else{if(this.length=o.ToInt32(e),n<0)throw new RangeError("ArrayBufferView size is not a small enough positive integer");this.byteLength=this.length*this.BYTES_PER_ELEMENT,this.buffer=new O(this.byteLength),this.byteOffset=0}this.constructor=r,A(this),k(this)};return(r.prototype=new S).BYTES_PER_ELEMENT=e,r.prototype._pack=t,r.prototype._\
unpack=n,r.BYTES_PER_ELEMENT=e,r.prototype.get=r.prototype._getter=function(e){if(arguments.length<1)throw new SyntaxError("Not enough arguments");if(!((e=o.ToUint32(e))>=this.length)){for(var t=[],n=0,r=this.byteOffset+e*this.BYTES_PER_ELEMENT;n<this.BYTES_PER_ELEMENT;n+=1,r+=1)t.push(this.buffer._bytes[r]);return this._unpack(t)}},r.prototype._setter=function(e,t){if(arguments.length<2)throw new SyntaxError("Not enough arguments");if((e=o.ToUint32(e))<this.length)for(var n=this._pack(t),r=0,a=this.byteOffset+e*this.BYTES_PER_ELEMENT;r<this.BYTES_PER_ELEMENT;r+=1,a+=1)this.buffer._bytes[a]=n[r]},r.prototype.set=function(e,t){if(arguments.length<1)throw new SyntaxError("Not enough arguments");var n,r,i,u,l,s,c,d,p,f;if("object"===a(e)&&e.constructor===this.constructor){if(n=e,(i=o.ToUint32(t))+n.length>this.length)throw new RangeError("Offset plus length of array is out of range");if(d=this.byteOffset+i*this.BYTES_PER_ELEMENT,p=n.length*this.BYTES_PER_ELEMENT,n.buffer===this.buffer){fo\
r(f=[],l=0,s=n.byteOffset;l<p;l+=1,s+=1)f[l]=n.buffer._bytes[s];for(l=0,c=d;l<p;l+=1,c+=1)this.buffer._bytes[c]=f[l]}else for(l=0,s=n.byteOffset,c=d;l<p;l+=1,s+=1,c+=1)this.buffer._bytes[c]=n.buffer._bytes[s]}else{if("object"!==a(e)||void 0===e.length)throw new TypeError("Unexpected argument type(s)");if(u=o.ToUint32((r=e).length),(i=o.ToUint32(t))+u>this.length)throw new RangeError("Offset plus length of array is out of range");for(l=0;l<u;l+=1)s=r[l],this._setter(i+l,Number(s))}},r.prototype.subarray=function(e,t){e=o.ToInt32(e),t=o.ToInt32(t),arguments.length<1&&(e=0),arguments.length<2&&(t=this.length),e<0&&(e=this.length+e),t<0&&(t=this.length+t),e=f(e,0,this.length);var n=(t=f(t,0,this.length))-e;return new this.constructor(this.buffer,this.byteOffset+e*this.BYTES_PER_ELEMENT,n=n<0?0:n)},r}function P(e,t){return o.IsCallable(e.get)?e.get(t):e[t]}function I(t,n,r){if(0===arguments.length)t=new e.ArrayBuffer(0);else if(!(t instanceof e.ArrayBuffer||"ArrayBuffer"===o.Class(t)))throw\
 new TypeError("TypeError");if(this.buffer=t||new e.ArrayBuffer(0),this.byteOffset=o.ToUint32(n),this.byteOffset>this.buffer.byteLength)throw new RangeError("byteOffset out of range");if(this.byteLength=arguments.length<3?this.buffer.byteLength-this.byteOffset:o.ToUint32(r),this.byteOffset+this.byteLength>this.buffer.byteLength)throw new RangeError("byteOffset and length reference an area beyond the end of the buffer");A(this)}function j(t){return function(n,r){if((n=o.ToUint32(n))+t.BYTES_PER_ELEMENT>this.byteLength)throw new RangeError("Array index out of range");n+=this.byteOffset;for(var a=new e.Uint8Array(this.buffer,n,t.BYTES_PER_ELEMENT),i=[],u=0;u<t.BYTES_PER_ELEMENT;u+=1)i.push(P(a,u));return Boolean(r)===Boolean(C)&&i.reverse(),P(new t(new e.Uint8Array(i).buffer),0)}}function L(t){return function(n,r,a){if((n=o.ToUint32(n))+t.BYTES_PER_ELEMENT>this.byteLength)throw new RangeError("Array index out of range");r=new t([r]);for(var i=new e.Uint8Array(r.buffer),u=[],l=0;l<t.BYTES_\
PER_ELEMENT;l+=1)u.push(P(i,l));Boolean(a)===Boolean(C)&&u.reverse(),new e.Uint8Array(this.buffer,n,t.BYTES_PER_ELEMENT).set(u)}}m=Object.defineProperty&&function(){try{return Object.defineProperty({},"x",{}),1}catch(e){}}()?Object.defineProperty:function(e,t,n){if(!e===Object(e))throw new TypeError("Object.defineProperty called on non-object");return o.HasProperty(n,"get")&&Object.prototype.__defineGetter__&&Object.prototype.__defineGetter__.call(e,t,n.get),o.HasProperty(n,"set")&&Object.prototype.__defineSetter__&&Object.prototype.__defineSetter__.call(e,t,n.set),o.HasProperty(n,"value")&&(e[t]=n.value),e},e.ArrayBuffer=e.ArrayBuffer||O,E=M(1,(function(e){return[255&e]}),(function(e){return N(e[0],8)})),D=M(1,(function(e){return[255&e]}),T),h=M(1,(function(e){return[(e=p(Number(e)))<0?0:255<e?255:255&e]}),T),g=M(2,(function(e){return[e>>8&255,255&e]}),(function(e){return N(e[0]<<8|e[1],16)})),b=M(2,(function(e){return[e>>8&255,255&e]}),(function(e){return B(e[0]<<8|e[1],16)})),v=M(4,\
(function(e){return[e>>24&255,e>>16&255,e>>8&255,255&e]}),(function(e){return N(e[0]<<24|e[1]<<16|e[2]<<8|e[3],32)})),y=M(4,(function(e){return[e>>24&255,e>>16&255,e>>8&255,255&e]}),(function(e){return B(e[0]<<24|e[1]<<16|e[2]<<8|e[3],32)})),F=M(4,(function(e){return R(e,8,23)}),(function(e){return _(e,8,23)})),w=M(8,(function(e){return R(e,11,52)}),(function(e){return _(e,11,52)})),e.Int8Array=e.Int8Array||E,e.Uint8Array=e.Uint8Array||D,e.Uint8ClampedArray=e.Uint8ClampedArray||h,e.Int16Array=e.Int16Array||g,e.Uint16Array=e.Uint16Array||b,e.Int32Array=e.Int32Array||v,e.Uint32Array=e.Uint32Array||y,e.Float32Array=e.Float32Array||F,e.Float64Array=e.Float64Array||w,E=new e.Uint16Array([4660]),C=18===P(new e.Uint8Array(E.buffer),0),I.prototype.getUint8=j(e.Uint8Array),I.prototype.getInt8=j(e.Int8Array),I.prototype.getUint16=j(e.Uint16Array),I.prototype.getInt16=j(e.Int16Array),I.prototype.getUint32=j(e.Uint32Array),I.prototype.getInt32=j(e.Int32Array),I.prototype.getFloat32=j(e.Float32Arra\
y),I.prototype.getFloat64=j(e.Float64Array),I.prototype.setUint8=L(e.Uint8Array),I.prototype.setInt8=L(e.Int8Array),I.prototype.setUint16=L(e.Uint16Array),I.prototype.setInt16=L(e.Int16Array),I.prototype.setUint32=L(e.Uint32Array),I.prototype.setInt32=L(e.Int32Array),I.prototype.setFloat32=L(e.Float32Array),I.prototype.setFloat64=L(e.Float64Array),e.DataView=e.DataView||I})),Xt=ee((function(e){!function(e){"use strict";var t,n,r;function o(){if(void 0===this)throw new TypeError("Constructor WeakMap requires 'new'");if(r(this,"_id","_WeakMap_"+u()+"."+u()),0<arguments.length)throw new TypeError("WeakMap iterable is not supported")}function i(e,n){if(!l(e)||!t.call(e,"_id"))throw new TypeError(n+" method called on incompatible receiver "+a(e))}function u(){return Math.random().toString().substring(2)}function l(e){return Object(e)===e}e.WeakMap||(t=Object.prototype.hasOwnProperty,n=Object.defineProperty&&function(){try{return 1===Object.defineProperty({},"x",{value:1}).x}catch(e){}}(),e.\
WeakMap=((r=function(e,t,r){n?Object.defineProperty(e,t,{configurable:!0,writable:!0,value:r}):e[t]=r})(o.prototype,"delete",(function(e){var t;return i(this,"delete"),!!l(e)&&!(!(t=e[this._id])||t[0]!==e||(delete e[this._id],0))})),r(o.prototype,"get",(function(e){var t;return i(this,"get"),l(e)&&(t=e[this._id])&&t[0]===e?t[1]:void 0})),r(o.prototype,"has",(function(e){var t;return i(this,"has"),!!l(e)&&!(!(t=e[this._id])||t[0]!==e)})),r(o.prototype,"set",(function(e,t){var n;if(i(this,"set"),l(e))return(n=e[this._id])&&n[0]===e?n[1]=t:r(e,this._id,[e,t]),this;throw new TypeError("Invalid value used as weak map key")})),r(o,"_polyfill",!0),o))}("undefined"!=typeof globalThis?globalThis:"undefined"!=typeof self?self:void 0!==t?t:void 0!==n?n:e)})),Zt=ee((function(e,r){function o(e){return e&&e.Math==Math&&e}r.exports=o("object"==("undefined"==typeof globalThis?"undefined":a(globalThis))&&globalThis)||o("object"==(void 0===t?"undefined":a(t))&&t)||o("object"==("undefined"==typeof self?"\
undefined":a(self))&&self)||o("object"==(void 0===n?"undefined":a(n))&&n)||function(){return this}()||Function("return this")()})),Jt=ee((function(e,t){t.exports=function(e){try{return!!e()}catch(e){return!0}}})),Qt=ee((function(e,t){var n=Jt();t.exports=!n((function(){var e=function(){}.bind();return"function"!=typeof e||e.hasOwnProperty("prototype")}))})),en=ee((function(e,t){var n=Qt(),r=Function.prototype,o=r.apply,i=r.call;t.exports="object"==("undefined"==typeof Reflect?"undefined":a(Reflect))&&Reflect.apply||(n?i.bind(o):function(){return i.apply(o,arguments)})})),tn=ee((function(e,t){var n=Qt(),r=(a=Function.prototype).call,a=n&&a.bind.bind(r,r);t.exports=n?a:function(e){return function(){return r.apply(e,arguments)}}})),nn=ee((function(e,t){var n=tn(),r=n({}.toString),a=n("".slice);t.exports=function(e){return a(r(e),8,-1)}})),rn=ee((function(e,t){var n=nn(),r=tn();t.exports=function(e){if("Function"===n(e))return r(e)}})),an=ee((function(e,t){var n="object"==(void 0===r?"unde\
fined":a(r))&&r.all;t.exports={all:n,IS_HTMLDDA:void 0===n&&void 0!==n}})),on=ee((function(e,t){var n=an(),r=n.all;t.exports=n.IS_HTMLDDA?function(e){return"function"==typeof e||e===r}:function(e){return"function"==typeof e}})),un=ee((function(e,t){var n=Jt();t.exports=!n((function(){return 7!=Object.defineProperty({},1,{get:function(){return 7}})[1]}))})),ln=ee((function(e,t){var n=Qt(),r=Function.prototype.call;t.exports=n?r.bind(r):function(){return r.apply(r,arguments)}})),sn=ee((function(e){"use strict";var t={}.propertyIsEnumerable,n=Object.getOwnPropertyDescriptor,r=n&&!t.call({1:2},1);e.f=r?function(e){return!!(e=n(this,e))&&e.enumerable}:t})),cn=ee((function(e,t){t.exports=function(e,t){return{enumerable:!(1&e),configurable:!(2&e),writable:!(4&e),value:t}}})),dn=ee((function(e,t){var n=tn(),r=Jt(),a=nn(),o=Object,i=n("".split);t.exports=r((function(){return!o("z").propertyIsEnumerable(0)}))?function(e){return"String"==a(e)?i(e,""):o(e)}:o})),pn=ee((function(e,t){t.exports=func\
tion(e){return null==e}})),fn=ee((function(e,t){var n=pn(),r=TypeError;t.exports=function(e){if(n(e))throw r("Can't call method on "+e);return e}})),mn=ee((function(e,t){var n=dn(),r=fn();t.exports=function(e){return n(r(e))}})),Dn=ee((function(e,t){var n=on(),r=an(),o=r.all;t.exports=r.IS_HTMLDDA?function(e){return"object"==a(e)?null!==e:n(e)||e===o}:function(e){return"object"==a(e)?null!==e:n(e)}})),hn=ee((function(e,t){t.exports={}})),gn=ee((function(e,t){function n(e){return o(e)?e:void 0}var r=hn(),a=Zt(),o=on();t.exports=function(e,t){return arguments.length<2?n(r[e])||n(a[e]):r[e]&&r[e][t]||a[e]&&a[e][t]}})),bn=ee((function(e,t){var n=tn();t.exports=n({}.isPrototypeOf)})),vn=ee((function(e,t){var n=gn();t.exports=n("navigator","userAgent")||""})),yn=ee((function(e,t){var n,r,a=Zt(),o=vn(),i=a.process;a=a.Deno;!(r=(a=(i=i&&i.versions||a&&a.version)&&i.v8)?0<(n=a.split("."))[0]&&n[0]<4?1:+(n[0]+n[1]):r)&&o&&(!(n=o.match(/Edge\\/(\\d+)/))||74<=n[1])&&(n=o.match(/Chrome\\/(\\d+)/))&&(r=\
+n[1]),t.exports=r})),Fn=ee((function(e,t){var n=yn(),r=Jt();t.exports=!!Object.getOwnPropertySymbols&&!r((function(){var e=Symbol();return!String(e)||!(Object(e)instanceof Symbol)||!Symbol.sham&&n&&n<41}))})),wn=ee((function(e,t){var n=Fn();t.exports=n&&!Symbol.sham&&"symbol"==a(Symbol.iterator)})),En=ee((function(e,t){var n=gn(),r=on(),o=bn(),i=wn(),u=Object;t.exports=i?function(e){return"symbol"==a(e)}:function(e){var t=n("Symbol");return r(t)&&o(t.prototype,u(e))}})),Cn=ee((function(e,t){var n=String;t.exports=function(e){try{return n(e)}catch(e){return"Object"}}})),xn=ee((function(e,t){var n=on(),r=Cn(),a=TypeError;t.exports=function(e){if(n(e))return e;throw a(r(e)+" is not a function")}})),An=ee((function(e,t){var n=xn(),r=pn();t.exports=function(e,t){return e=e[t],r(e)?void 0:n(e)}})),kn=ee((function(e,t){var n=ln(),r=on(),a=Dn(),o=TypeError;t.exports=function(e,t){var i,u;if("string"===t&&r(i=e.toString)&&!a(u=n(i,e)))return u;if(r(i=e.valueOf)&&!a(u=n(i,e)))return u;if("strin\
g"!==t&&r(i=e.toString)&&!a(u=n(i,e)))return u;throw o("Can't convert object to primitive value")}})),Nn=ee((function(e,t){t.exports=!0})),Bn=ee((function(e,t){var n=Zt(),r=Object.defineProperty;t.exports=function(e,t){try{r(n,e,{value:t,configurable:!0,writable:!0})}catch(r){n[e]=t}return t}})),Tn=ee((function(e,t){var n=Zt(),r=Bn(),a="__core-js_shared__";n=n[a]||r(a,{});t.exports=n})),Rn=ee((function(e,t){var n=Nn(),r=Tn();(t.exports=function(e,t){return r[e]||(r[e]=void 0!==t?t:{})})("versions",[]).push({version:"3.26.1",mode:n?"pure":"global",copyright:"© 2014-2022 Denis Pushkarev (zloirock.ru)",license:"https://github.com/zloirock/core-js/blob/v3.26.1/LICENSE",source:"https://github.com/zloirock/core-js"})})),_n=ee((function(e,t){var n=fn(),r=Object;t.exports=function(e){return r(n(e))}})),On=ee((function(e,t){var n=tn(),r=_n(),a=n({}.hasOwnProperty);t.exports=Object.hasOwn||function(e,t){return a(r(e),t)}})),Sn=ee((function(e,t){var n=tn(),r=0,a=Math.random(),o=n(1..toString);t.e\
xports=function(e){return"Symbol("+(void 0===e?"":e)+")_"+o(++r+a,36)}})),Mn=ee((function(e,t){var n=Zt(),r=Rn(),a=On(),o=Sn(),i=Fn(),u=wn(),l=r("wks"),s=n.Symbol,c=s&&s.for,d=u?s:s&&s.withoutSetter||o;t.exports=function(e){var t;return a(l,e)&&(i||"string"==typeof l[e])||(t="Symbol."+e,i&&a(s,e)?l[e]=s[e]:l[e]=(u&&c?c:d)(t)),l[e]}})),Pn=ee((function(e,t){var n=ln(),r=Dn(),a=En(),o=An(),i=kn(),u=Mn(),l=TypeError,s=u("toPrimitive");t.exports=function(e,t){if(!r(e)||a(e))return e;var u=o(e,s);if(u){if(u=n(u,e,t=void 0===t?"default":t),!r(u)||a(u))return u;throw l("Can't convert object to primitive value")}return i(e,t=void 0===t?"number":t)}})),In=ee((function(e,t){var n=Pn(),r=En();t.exports=function(e){return e=n(e,"string"),r(e)?e:e+""}})),jn=ee((function(e,t){var n=Zt(),r=Dn(),a=n.document,o=r(a)&&r(a.createElement);t.exports=function(e){return o?a.createElement(e):{}}})),Ln=ee((function(e,t){var n=un(),r=Jt(),a=jn();t.exports=!n&&!r((function(){return 7!=Object.defineProperty(a("div\
"),"a",{get:function(){return 7}}).a}))})),qn=ee((function(e){var t=un(),n=ln(),r=sn(),a=cn(),o=mn(),i=In(),u=On(),l=Ln(),s=Object.getOwnPropertyDescriptor;e.f=t?s:function(e,t){if(e=o(e),t=i(t),l)try{return s(e,t)}catch(e){}if(u(e,t))return a(!n(r.f,e,t),e[t])}})),zn=ee((function(e,t){function n(e,t){return(e=u[i(e)])==s||e!=l&&(a(t)?r(t):!!t)}var r=Jt(),a=on(),o=/#|\\.prototype\\./,i=n.normalize=function(e){return String(e).replace(o,".").toLowerCase()},u=n.data={},l=n.NATIVE="N",s=n.POLYFILL="P";t.exports=n})),Vn=ee((function(e,t){var n=rn(),r=xn(),a=Qt(),o=n(n.bind);t.exports=function(e,t){return r(e),void 0===t?e:a?o(e,t):function(){return e.apply(t,arguments)}}})),$n=ee((function(e,t){var n=un(),r=Jt();t.exports=n&&r((function(){return 42!=Object.defineProperty((function(){}),"prototype",{value:42,writable:!1}).prototype}))})),Hn=ee((function(e,t){var n=Dn(),r=String,a=TypeError;t.exports=function(e){if(n(e))return e;throw a(r(e)+" is not an object")}})),Un=ee((function(e){var t=un\
(),n=Ln(),r=$n(),a=Hn(),o=In(),i=TypeError,u=Object.defineProperty,l=Object.getOwnPropertyDescriptor,s="enumerable",c="configurable",d="writable";e.f=t?r?function(e,t,n){var r;return a(e),t=o(t),a(n),"function"==typeof e&&"prototype"===t&&"value"in n&&d in n&&!n[d]&&(r=l(e,t))&&r[d]&&(e[t]=n.value,n={configurable:(c in n?n:r)[c],enumerable:(s in n?n:r)[s],writable:!1}),u(e,t,n)}:u:function(e,t,r){if(a(e),t=o(t),a(r),n)try{return u(e,t,r)}catch(e){}if("get"in r||"set"in r)throw i("Accessors not supported");return"value"in r&&(e[t]=r.value),e}})),Gn=ee((function(e,t){var n=un(),r=Un(),a=cn();t.exports=n?function(e,t,n){return r.f(e,t,a(1,n))}:function(e,t,n){return e[t]=n,e}})),Wn=ee((function(e,t){"use strict";function n(e){function t(n,r,a){if(this instanceof t){switch(arguments.length){case 0:return new e;case 1:return new e(n);case 2:return new e(n,r)}return new e(n,r,a)}return o(e,this,arguments)}return t.prototype=e.prototype,t}var r=Zt(),o=en(),i=rn(),u=on(),l=qn().f,s=zn(),c=hn()\
,d=Vn(),p=Gn(),f=On();t.exports=function(e,t){var o,m,D,h,g,b=e.target,v=e.global,y=e.stat,F=e.proto,w=v?r:y?r[b]:(r[b]||{}).prototype,E=v?c:c[b]||p(c,b,{})[b],C=E.prototype;for(o in t)h=!s(v?o:b+(y?".":"#")+o,e.forced)&&w&&f(w,o),D=E[o],h&&(g=e.dontCallGetSet?(g=l(w,o))&&g.value:w[o]),m=h&&g?g:t[o],h&&a(D)==a(m)||(h=e.bind&&h?d(m,r):e.wrap&&h?n(m):F&&u(m)?i(m):m,(e.sham||m&&m.sham||D&&D.sham)&&p(h,"sham",!0),p(E,o,h),F&&(f(c,D=b+"Prototype")||p(c,D,{}),p(c[D],o,m),e.real)&&C&&!C[o]&&p(C,o,m))}})),Yn=ee((function(){Wn()({target:"Object",stat:!0},{hasOwn:On()})})),Kn=ee((function(e,t){Yn();var n=hn();t.exports=n.Object.hasOwn})),Xn=ee((function(e,t){var n=Kn();t.exports=n})),Zn=ee((function(e,t){var n=Xn();t.exports=n})),Jn=ee((function(e,t){var n=Math.ceil,r=Math.floor;t.exports=Math.trunc||function(e){return(0<(e=+e)?r:n)(e)}})),Qn=ee((function(e,t){var n=Jn();t.exports=function(e){return(e=+e)!=e||0==e?0:n(e)}})),er=ee((function(e,t){var n=Qn(),r=Math.max,a=Math.min;t.exports=functio\
n(e,t){return(e=n(e))<0?r(e+t,0):a(e,t)}})),tr=ee((function(e,t){var n=Qn(),r=Math.min;t.exports=function(e){return 0<e?r(n(e),9007199254740991):0}})),nr=ee((function(e,t){var n=tr();t.exports=function(e){return n(e.length)}})),rr=ee((function(e,t){function n(e){return function(t,n,i){var u,l=r(t),s=o(l),c=a(i,s);if(e&&n!=n){for(;c<s;)if((u=l[c++])!=u)return!0}else for(;c<s;c++)if((e||c in l)&&l[c]===n)return e||c||0;return!e&&-1}}var r=mn(),a=er(),o=nr();t.exports={includes:n(!0),indexOf:n(!1)}})),ar=ee((function(e,t){t.exports={}})),or=ee((function(e,t){var n=tn(),r=On(),a=mn(),o=rr().indexOf,i=ar(),u=n([].push);t.exports=function(e,t){var n,l=a(e),s=0,c=[];for(n in l)!r(i,n)&&r(l,n)&&u(c,n);for(;t.length>s;)!r(l,n=t[s++])||~o(c,n)||u(c,n);return c}})),ir=ee((function(e,t){t.exports=["constructor","hasOwnProperty","isPrototypeOf","propertyIsEnumerable","toLocaleString","toString","valueOf"]})),ur=ee((function(e,t){var n=or(),r=ir();t.exports=Object.keys||function(e){return n(e,r)}}))\
,lr=ee((function(e,t){function n(e){return function(t){for(var n,a=i(t),s=o(a),c=s.length,d=0,p=[];d<c;)n=s[d++],r&&!u(a,n)||l(p,e?[n,a[n]]:a[n]);return p}}var r=un(),a=tn(),o=ur(),i=mn(),u=a(sn().f),l=a([].push);t.exports={entries:n(!0),values:n(!1)}})),sr=ee((function(){var e=Wn(),t=lr().values;e({target:"Object",stat:!0},{values:function(e){return t(e)}})})),cr=ee((function(e,t){sr();var n=hn();t.exports=n.Object.values})),dr=ee((function(e,t){var n=cr();t.exports=n})),pr=ee((function(e,t){var n=dr();t.exports=n})),fr=ee((function(e,r){!function(){"use strict";var e={name:"doT",version:"1.1.1",templateSettings:{evaluate:/\\{\\{([\\s\\S]+?(\\}?)+)\\}\\}/g,interpolate:/\\{\\{=([\\s\\S]+?)\\}\\}/g,encode:/\\{\\{!([\\s\\S]+?)\\}\\}/g,use:/\\{\\{#([\\s\\S]+?)\\}\\}/g,useParams:/(^|[^\\w$])def(?:\\.|\\[[\\'\\"])([\\w$\\.]+)(?:[\\'\\"]\\])?\\s*\\:\\s*([\\w$\\.]+|\\"[^\\"]+\\"|\\'[^\\']+\\'|\\{[^\\}]+\\})/g,define:/\\{\\{##\\s*([\\w\\.$]+)\\s*(\\:|=)([\\s\\S]+?)#\\}\\}/g,defineParams:/^\\s*([\\w$]+):([\\s\\S]+)/,conditional:/\\{\\{\\?(\\?)?\\s*([\\s\\S]*?)\\s*\\\
}\\}/g,iterate:/\\{\\{~\\s*(?:\\}\\}|([\\s\\S]+?)\\s*\\:\\s*([\\w$]+)\\s*(?:\\:\\s*([\\w$]+))?\\s*\\}\\})/g,varname:"it",strip:!0,append:!0,selfcontained:!1,doNotSkipEncoded:!1},template:void 0,compile:void 0,log:!0};if("object"!==("undefined"==typeof globalThis?"undefined":a(globalThis)))try{Object.defineProperty(Object.prototype,"__magic__",{get:function(){return this},configurable:!0}),__magic__.globalThis=__magic__,delete Object.prototype.__magic__}catch(e){t.globalThis=function(){if("undefined"!=typeof self)return self;if(void 0!==t)return t;if(void 0!==n)return n;if(void 0!==this)return this;throw new Error("Unable to locate global \`this\`")}()}e.encodeHTMLSource=function(e){var t={"&":"&#38;","<":"&#60;",">":"&#62;",'"':"&#34;","'":"&#39;","/":"&#47;"},n=e?/[&<>"'\\/]/g:/&(?!#?\\w+;)|<|>|"|'|\\//g;return function(e){return e?e.toString().replace(n,(function(e){return t[e]||e})):""}},void 0!==r&&r.exports?r.exports=e:"function"==typeof define&&define.amd?define((function(){return e})):globalThis.doT=e;\
var o={append:{start:"'+(",end:")+'",startencode:"'+encodeHTML("},split:{start:"';out+=(",end:");out+='",startencode:"';out+=encodeHTML("}},i=/$^/;function u(e){return e.replace(/\\\\('|\\\\)/g,"$1").replace(/[\\r\\t\\n]/g," ")}e.template=function(t,n,r){var a,l,s=(n=n||e.templateSettings).append?o.append:o.split,c=0;r=n.use||n.define?function e(t,n,r){return("string"==typeof n?n:n.toString()).replace(t.define||i,(function(e,n,a,o){return(n=0===n.indexOf("def.")?n.substring(4):n)in r||(":"===a?(t.defineParams&&o.replace(t.defineParams,(function(e,t,a){r[n]={arg:t,text:a}})),n in r||(r[n]=o)):new Function("def","def['"+n+"']="+o)(r)),""})).replace(t.use||i,(function(n,a){return t.useParams&&(a=a.replace(t.useParams,(function(e,t,n,a){var o;if(r[n]&&r[n].arg&&a)return o=(n+":"+a).replace(/'|\\\\/g,"_"),r.__exp=r.__exp||{},r.__exp[o]=r[n].text.replace(new RegExp("(^|[^\\\\w$])"+r[n].arg+"([^\\\\w$])","g"),"$1"+a+"$2"),t+"def.__exp['"+o+"']"}))),(a=new Function("def","return "+a)(r))&&e(t,a,r)}))}(n,t,\
r||{}):t,r=("var out='"+(n.strip?r.replace(/(^|\\r|\\n)\\t* +| +\\t*(\\r|\\n|$)/g," ").replace(/\\r|\\n|\\t|\\/\\*[\\s\\S]*?\\*\\//g,""):r).replace(/'|\\\\/g,"\\\\$&").replace(n.interpolate||i,(function(e,t){return s.start+u(t)+s.end})).replace(n.encode||i,(function(e,t){return a=!0,s.startencode+u(t)+s.end})).replace(n.conditional||i,(function(e,t,n){return t?n?"';}else if("+u(n)+"){out+='":"';}else{out+='":n?"';if("+u(n)+"){out+='":"';}out+='"})).replace(n.iterate||i,(function(e,t,n,r){return t?(c+=1,l=r||"i"+c,t=u(t),"';var arr"+c+"="+t+";if(arr"+c+"){var "+n+","+l+"=-1,l"+c+"=arr"+c+".length-1;while("+l+"<l"+c+"){"+n+"=arr"+c+"["+l+"+=1];out+='"):"';} } out+='"})).replace(n.evaluate||i,(function(e,t){return"';"+u(t)+"out+='"}))+"';return out;").replace(/\\n/g,"\\\\n").replace(/\\t/g,"\\\\t").replace(/\\r/g,"\\\\r").replace(/(\\s|;|\\}|^|\\{)out\\+='';/g,"$1").replace(/\\+''/g,"");a&&(n.selfcontained||!globalThis||globalThis._encodeHTML||(globalThis._encodeHTML=e.encodeHTMLSource(n.doNotSkipEncoded)),r="var encodeH\
TML = typeof _encodeHTML !== 'undefined' ? _encodeHTML : ("+e.encodeHTMLSource.toString()+"("+(n.doNotSkipEncoded||"")+"));"+r);try{return new Function(n.varname,r)}catch(t){throw"undefined"!=typeof console&&console.log("Could not create a template function: "+r),t}},e.compile=function(t,n){return e.template(t,null,n)}}()})),mr={helpUrlBase:"https://dequeuniversity.com/rules/",gridSize:200,results:[],resultGroups:[],resultGroupMap:{},impact:Object.freeze(["minor","moderate","serious","critical"]),preload:Object.freeze({assets:["cssom","media"],timeout:1e4}),allOrigins:"<unsafe_all_origins>",sameOrigin:"<same_origin>"},Dr=([{name:"NA",value:"inapplicable",priority:0,group:"inapplicable"},{name:"PASS",value:"passed",priority:1,group:"passes"},{name:"CANTTELL",value:"cantTell",priority:2,group:"incomplete"},{name:"FAIL",value:"failed",priority:3,group:"violations"}].forEach((function(e){var t=e.name,n=e.value,r=e.priority;e=e.group;mr[t]=n,mr[t+"_PRIO"]=r,mr[t+"_GROUP"]=e,mr.results[r]=n,\
mr.resultGroups[r]=e,mr.resultGroupMap[n]=e})),Object.freeze(mr.results),Object.freeze(mr.resultGroups),Object.freeze(mr.resultGroupMap),Object.freeze(mr),mr),hr=function(){"object"===("undefined"==typeof console?"undefined":a(console))&&console.log&&Function.prototype.apply.call(console.log,console,arguments)},gr=/[\\t\\r\\n\\f]/g;function br(){W(this,br),this.parent=void 0}K(br,[{key:"props",get:function(){throw new Error('VirtualNode class must have a "props" object consisting of "nodeType" and "nodeName" properties')}},{key:"attrNames",get:function(){throw new Error('VirtualNode class must have an "attrNames" property')}},{key:"attr",value:function(){throw new Error('VirtualNode class must have an "attr" function')}},{key:"hasAttr",value:function(){throw new Error('VirtualNode class must have a "hasAttr" function')}},{key:"hasClass",value:function(e){var t=this.attr("class");return!!t&&(e=" "+e+" ",0<=(" "+t+" ").replace(gr," ").indexOf(e))}}]);var vr=br,yr={},Fr=(te(yr,{DqElement:func\
tion(){return fa},aggregate:function(){return Fr},aggregateChecks:function(){return kr},aggregateNodeResults:function(){return Br},aggregateResult:function(){return Rr},areStylesSet:function(){return _r},assert:function(){return Or},checkHelper:function(){return ma},clone:function(){return Da},closest:function(){return xa},collectResultsFromFrames:function(){return yo},contains:function(){return Fo},convertSelector:function(){return Ea},cssParser:function(){return ha},deepMerge:function(){return wo},escapeSelector:function(){return Mr},extendMetaData:function(){return Eo},filterHtmlAttrs:function(){return kf},finalizeRuleResult:function(){return Nr},findBy:function(){return go},getAllChecks:function(){return ho},getAncestry:function(){return ia},getBaseLang:function(){return bp},getCheckMessage:function(){return kp},getCheckOption:function(){return Np},getEnvironmentData:function(){return Bp},getFlattenedTree:function(){return hp},getFrameContexts:function(){return zp},getFriendlyUriEn\
d:function(){return Lr},getNodeAttributes:function(){return qr},getNodeFromTree:function(){return ca},getPreloadConfig:function(){return Ff},getRootNode:function(){return ko},getRule:function(){return Vp},getScroll:function(){return Hp},getScrollState:function(){return Up},getSelector:function(){return aa},getSelectorData:function(){return ea},getShadowSelector:function(){return Ur},getStandards:function(){return Gp},getStyleSheetFactory:function(){return Yp},getXpath:function(){return ua},injectStyle:function(){return Kp},isHidden:function(){return Xp},isHtmlElement:function(){return Zp},isNodeInContext:function(){return Jp},isShadowRoot:function(){return xo},isValidLang:function(){return If},isXHTML:function(){return Hr},matchAncestry:function(){return ef},matches:function(){return ga},matchesExpression:function(){return Ca},matchesSelector:function(){return zr},memoize:function(){return $r},mergeResults:function(){return vo},nodeLookup:function(){return nf},nodeSerializer:function()\
{return Do},nodeSorter:function(){return tf},parseCrossOriginStylesheet:function(){return lf},parseSameOriginStylesheet:function(){return of},parseStylesheet:function(){return uf},performanceTimer:function(){return cf},pollyfillElementsFromPoint:function(){return df},preload:function(){return vf},preloadCssom:function(){return Df},preloadMedia:function(){return bf},processMessage:function(){return Ap},publishMetaData:function(){return wf},querySelectorAll:function(){return Cf},querySelectorAllFilter:function(){return mf},queue:function(){return Ra},respondable:function(){return uo},ruleShouldRun:function(){return Af},select:function(){return Bf},sendCommandToFrame:function(){return so},setScrollState:function(){return Tf},shadowSelect:function(){return Rf},shadowSelectAll:function(){return _f},shouldPreload:function(){return yf},toArray:function(){return Sr},tokenList:function(){return sp},uniqueArray:function(){return pf},uuid:function(){return Ha},validInputTypes:function(){return Of\
},validLangs:function(){return Mf}}),function(e,t,n){return t=t.slice(),n&&t.push(n),n=t.map((function(t){return e.indexOf(t)})).sort(),e[n.pop()]}),wr=Dr.CANTTELL_PRIO,Er=Dr.FAIL_PRIO,Cr=[],xr=(Cr[Dr.PASS_PRIO]=!0,Cr[Dr.CANTTELL_PRIO]=null,Cr[Dr.FAIL_PRIO]=!1,["any","all","none"]);function Ar(e,t){xr.reduce((function(n,r){return n[r]=(e[r]||[]).map((function(e){return t(e,r)})),n}),{})}var kr=function(e){var t=Object.assign({},e),n=(Ar(t,(function(e,t){var n=void 0===e.result?-1:Cr.indexOf(e.result);e.priority=-1!==n?n:Dr.CANTTELL_PRIO,"none"===t&&(e.priority===Dr.PASS_PRIO?e.priority=Dr.FAIL_PRIO:e.priority===Dr.FAIL_PRIO&&(e.priority=Dr.PASS_PRIO))})),{all:t.all.reduce((function(e,t){return Math.max(e,t.priority)}),0),none:t.none.reduce((function(e,t){return Math.max(e,t.priority)}),0),any:t.any.reduce((function(e,t){return Math.min(e,t.priority)}),4)%4}),r=(t.priority=Math.max(n.all,n.none,n.any),[]);return xr.forEach((function(e){t[e]=t[e].filter((function(r){return r.priority===t\
.priority&&r.priority===n[e]})),t[e].forEach((function(e){return r.push(e.impact)}))})),[wr,Er].includes(t.priority)?t.impact=Fr(Dr.impact,r):t.impact=null,Ar(t,(function(e){delete e.result,delete e.priority})),t.result=Dr.results[t.priority],delete t.priority,t};function Nr(e){var t=o._audit.rules.find((function(t){return t.id===e.id}));return t&&t.impact&&e.nodes.forEach((function(e){["any","all","none"].forEach((function(n){(e[n]||[]).forEach((function(e){e.impact=t.impact}))}))})),Object.assign(e,Br(e.nodes)),delete e.nodes,e}var Br=function(e){var t={},n=((e=e.map((function(e){if(e.any&&e.all&&e.none)return kr(e);if(Array.isArray(e.node))return Nr(e);throw new TypeError("Invalid Result type")})))&&e.length?(n=e.map((function(e){return e.result})),t.result=Fr(Dr.results,n,t.result)):t.result="inapplicable",Dr.resultGroups.forEach((function(e){return t[e]=[]})),e.forEach((function(e){var n=Dr.resultGroupMap[e.result];t[n].push(e)})),Dr.FAIL_GROUP);return 0===t[n].length&&(n=Dr.CANTT\
ELL_GROUP),0<t[n].length?(e=t[n].map((function(e){return e.impact})),t.impact=Fr(Dr.impact,e)||null):t.impact=null,t};function Tr(e,t,n){var r=Object.assign({},t);r.nodes=(r[n]||[]).concat(),Dr.resultGroups.forEach((function(e){delete r[e]})),e[n].push(r)}var Rr=function(e){var t={};return Dr.resultGroups.forEach((function(e){return t[e]=[]})),e.forEach((function(e){e.error?Tr(t,e,Dr.CANTTELL_GROUP):e.result===Dr.NA?Tr(t,e,Dr.NA_GROUP):Dr.resultGroups.forEach((function(n){Array.isArray(e[n])&&0<e[n].length&&Tr(t,e,n)}))})),t},_r=function e(n,r,a){var o=t.getComputedStyle(n,null);if(!o)return!1;for(var i=0;i<r.length;++i){var u=r[i];if(o.getPropertyValue(u.property)===u.value)return!0}return!(!n.parentNode||n.nodeName.toUpperCase()===a.toUpperCase())&&e(n.parentNode,r,a)},Or=function(e,t){if(!e)throw new Error(t)},Sr=function(e){return Array.prototype.slice.call(e)},Mr=function(e){for(var t,n=String(e),r=n.length,a=-1,o="",i=n.charCodeAt(0);++a<r;)0==(t=n.charCodeAt(a))?o+="�":o+=1<=t&&\
t<=31||127==t||0==a&&48<=t&&t<=57||1==a&&48<=t&&t<=57&&45==i?"\\\\"+t.toString(16)+" ":0==a&&1==r&&45==t||!(128<=t||45==t||95==t||48<=t&&t<=57||65<=t&&t<=90||97<=t&&t<=122)?"\\\\"+n.charAt(a):n.charAt(a);return o};function Pr(e,t){return[e.substring(0,t),e.substring(t)]}function Ir(e){return e.replace(/\\s+$/,"")}var jr,Lr=function(){var e,t,n,r,a,o,i,u,l=0<arguments.length&&void 0!==arguments[0]?arguments[0]:"",s=1<arguments.length&&void 0!==arguments[1]?arguments[1]:{};if(!(l.length<=1||"data:"===l.substr(0,5)||"javascript:"===l.substr(0,11)||l.includes("?")))return e=s.currentDomain,s=void 0===(s=s.maxLength)?25:s,i=o=u=a=r="",(n=l).includes("#")&&(l=(t=H(Pr(l,l.indexOf("#")),2))[0],i=t[1]),l.includes("?")&&(l=(t=H(Pr(l,l.indexOf("?")),2))[0],o=t[1]),l.includes("://")?(r=(t=H(l.split("://"),2))[0],a=(t=H(Pr(l=t[1],l.indexOf("/")),2))[0],l=t[1]):"//"===l.substr(0,2)&&(a=(t=H(Pr(l=l.substr(2),l.indexOf("/")),2))[0],l=t[1]),(a="www."===a.substr(0,4)?a.substr(4):a)&&a.includes(":")&&(a=(t=H(\
Pr(a,a.indexOf(":")),2))[0],u=t[1]),n=(t={original:n,protocol:r,domain:a,port:u,path:l,query:o,hash:i}).domain,r=t.hash,u=(a=t.path).substr(a.substr(0,a.length-2).lastIndexOf("/")+1),r?u&&(u+r).length<=s?Ir(u+r):u.length<2&&2<r.length&&r.length<=s?Ir(r):void 0:n&&n.length<s&&a.length<=1||a==="/"+u&&n&&e&&n!==e&&(n+a).length<=s?Ir(n+a):(-1===(l=u.lastIndexOf("."))||1<l)&&(-1!==l||2<u.length)&&u.length<=s&&!u.match(/index(\\.[a-zA-Z]{2-4})?/)&&!function(e){var t=0<arguments.length&&void 0!==e?e:"";return 0!==t.length&&(t.match(/[0-9]/g)||"").length>=t.length/2}(u)?Ir(u):void 0},qr=function(e){return(e.attributes instanceof t.NamedNodeMap?e:e.cloneNode(!1)).attributes},zr=function(e,t){return!!e[jr=jr&&e[jr]?jr:function(e){for(var t,n=["matches","matchesSelector","mozMatchesSelector","webkitMatchesSelector","msMatchesSelector"],r=n.length,a=0;a<r;a++)if(e[t=n[a]])return t}(e)]&&e[jr](t)},Vr=ne($t()),$r=(o._memoizedFns=[],function(e){return e=(0,Vr.default)(e),o._memoizedFns.push(e),e}),Hr=\
$r((function(e){return!(null==e||!e.createElement)&&"A"===e.createElement("A").localName}));function Ur(e,t){var n=2<arguments.length&&void 0!==arguments[2]?arguments[2]:{};if(!t)return"";var a=t.getRootNode&&t.getRootNode()||r;if(11!==a.nodeType)return e(t,n,a);for(var o=[];11===a.nodeType;){if(!a.host)return"";o.unshift({elm:t,doc:a}),a=(t=a.host).getRootNode()}return o.unshift({elm:t,doc:a}),o.map((function(t){return e(t.elm,n,t.doc)}))}var Gr=["class","style","id","selected","checked","disabled","tabindex","aria-checked","aria-selected","aria-invalid","aria-activedescendant","aria-busy","aria-disabled","aria-expanded","aria-grabbed","aria-pressed","aria-valuenow","xmlns"],Wr=31,Yr=/([\\\\"])/g,Kr=/(\\r\\n|\\r|\\n)/g;function Xr(e){return e.replace(Yr,"\\\\$1").replace(Kr,"\\\\a ")}function Zr(e,t){var n,r=t.name;return-1!==r.indexOf("href")||-1!==r.indexOf("src")?(n=Lr(e.getAttribute(r)))?Mr(t.name)+'$="'+Xr(n)+'"':Mr(t.name)+'="'+Xr(e.getAttribute(r))+'"':Mr(r)+'="'+Xr(t.value)+'"'}function\
 Jr(e,t){return e.count<t.count?-1:e.count===t.count?0:1}function Qr(e){return!Gr.includes(e.name)&&-1===e.name.indexOf(":")&&(!e.value||e.value.length<Wr)}function ea(e){for(var t={classes:{},tags:{},attributes:{}},n=(e=Array.isArray(e)?e:[e]).slice(),r=[];n.length;)!function(){var e,a=n.pop(),o=a.actualNode;for(o.querySelectorAll&&(e=o.nodeName,t.tags[e]?t.tags[e]++:t.tags[e]=1,o.classList&&Array.from(o.classList).forEach((function(e){e=Mr(e),t.classes[e]?t.classes[e]++:t.classes[e]=1})),o.hasAttributes())&&Array.from(qr(o)).filter(Qr).forEach((function(e){(e=Zr(o,e))&&(t.attributes[e]?t.attributes[e]++:t.attributes[e]=1)})),a.children.length&&(r.push(n),n=a.children.slice());!n.length&&r.length;)n=r.pop()}();return t}function ta(e){var t=Hr(r);return Mr(t?e.localName:e.nodeName.toLowerCase())}function na(e,t){var n,r,a,o,i,u,l,s,c,d="",p=(r=e,a=[],o=t.classes,i=t.tags,r.classList&&Array.from(r.classList).forEach((function(e){e=Mr(e),o[e]<i[r.nodeName]&&a.push({name:e,count:o[e],spec\
ies:"class"})})),a.sort(Jr));u=e,l=[],s=t.attributes,c=t.tags,u.hasAttributes()&&Array.from(qr(u)).filter(Qr).forEach((function(e){(e=Zr(u,e))&&s[e]<c[u.nodeName]&&l.push({name:e,count:s[e],species:"attribute"})})),t=l.sort(Jr);return p.length&&1===p[0].count?n=[p[0]]:t.length&&1===t[0].count?(n=[t[0]],d=ta(e)):((n=p.concat(t)).sort(Jr),(n=n.slice(0,3)).some((function(e){return"class"===e.species}))?n.sort((function(e,t){return e.species!==t.species&&"class"===e.species?-1:e.species===t.species?0:1})):d=ta(e)),d+n.reduce((function(e,t){switch(t.species){case"class":return e+"."+t.name;case"attribute":return e+"["+t.name+"]"}return e}),"")}function ra(e,t,n){if(!o._selectorData)throw new Error("Expect axe._selectorData to be set up");var a,i,u=void 0!==(t=t.toRoot)&&t;do{var l=function(e){var t;if(e.getAttribute("id"))return t=e.getRootNode&&e.getRootNode()||r,(e="#"+Mr(e.getAttribute("id")||"")).match(/player_uid_/)||1!==t.querySelectorAll(e).length?void 0:e}(e);l||(l=na(e,o._selectorD\
ata),l+=function(e,t){var n=e.parentNode&&Array.from(e.parentNode.children||"")||[];return n.find((function(n){return n!==e&&zr(n,t)}))?":nth-child("+(1+n.indexOf(e))+")":""}(e,l)),a=a?l+" > "+a:l,i=i?i.filter((function(e){return zr(e,a)})):Array.from(n.querySelectorAll(a)),e=e.parentElement}while((1<i.length||u)&&e&&11!==e.nodeType);return 1===i.length?a:-1!==a.indexOf(" > ")?":root"+a.substring(a.indexOf(" > ")):":root"}function aa(e,t){return Ur(ra,e,t)}function oa(e){var t,n=e.nodeName.toLowerCase(),r=e.parentElement;return r?(t="","head"!==n&&"body"!==n&&1<r.children.length&&(e=Array.prototype.indexOf.call(r.children,e)+1,t=":nth-child(".concat(e,")")),oa(r)+" > "+n+t):n}function ia(e,t){return Ur(oa,e,t)}var ua=function(e){return function e(t,n){var r,a,o,i;if(!t)return[];if(!n&&9===t.nodeType)return[{str:"html"}];if(n=n||[],t.parentNode&&t.parentNode!==t&&(n=e(t.parentNode,n)),t.previousSibling){for(a=1,r=t.previousSibling;1===r.nodeType&&r.nodeName===t.nodeName&&a++,r=r.previou\
sSibling;);1===a&&(a=null)}else if(t.nextSibling)for(r=t.nextSibling;r=1===r.nodeType&&r.nodeName===t.nodeName?(a=1,null):(a=null,r.previousSibling););return 1===t.nodeType&&((o={}).str=t.nodeName.toLowerCase(),(i=t.getAttribute&&Mr(t.getAttribute("id")))&&1===t.ownerDocument.querySelectorAll("#"+i).length&&(o.id=t.getAttribute("id")),1<a&&(o.count=a),n.push(o)),n}(e).reduce((function(e,t){return t.id?"/".concat(t.str,"[@id='").concat(t.id,"']"):e+"/".concat(t.str)+(0<t.count?"[".concat(t.count,"]"):"")}),"")},la={},sa={set:function(e,t){var n;Or("string"==typeof(n=e),"key must be a string, "+a(n)+" given"),Or(""!==n,"key must not be empty"),la[e]=t},get:function(e,t){var n;return Or("function"==typeof(n=t)||void 0===n,"creator must be a function or undefined, "+a(n)+" given"),e in la?la[e]:"function"==typeof t?(n=t(),Or(void 0!==n,"Cache creator function should not return undefined"),this.set(e,n),la[e]):void 0},clear:function(){la={}}},ca=function(e,t){return t=t||e,sa.get("nodeMap")\
?sa.get("nodeMap").get(t):null},da="DqElm.RunOptions";function pa(e){var n,r,a=1<arguments.length&&void 0!==arguments[1]?arguments[1]:null,i=2<arguments.length&&void 0!==arguments[2]?arguments[2]:{};a=a||(null!=(n=sa.get(da))?n:{}),this.spec=i,e instanceof vr?(this._virtualNode=e,this._element=e.actualNode):(this._element=e,this._virtualNode=ca(e)),this.fromFrame=1<(null==(n=this.spec.selector)?void 0:n.length),this._includeElementInJson=a.elementRef,a.absolutePaths&&(this._options={toRoot:!0}),this.nodeIndexes=[],Array.isArray(this.spec.nodeIndexes)?this.nodeIndexes=this.spec.nodeIndexes:"number"==typeof(null==(i=this._virtualNode)?void 0:i.nodeIndex)&&(this.nodeIndexes=[this._virtualNode.nodeIndex]),this.source=null,o._audit.noHtml||(this.source=null!=(n=this.spec.source)?n:null!=(a=this._element)&&a.outerHTML?((i=a.outerHTML)||"function"!=typeof t.XMLSerializer||(i=(new t.XMLSerializer).serializeToString(a)),(a=i||"").length>(r=r||300)&&(r=a.indexOf(">"),a=a.substring(0,r+1)),a):"")\
}pa.prototype={get selector(){return this.spec.selector||[aa(this.element,this._options)]},get ancestry(){return this.spec.ancestry||[ia(this.element)]},get xpath(){return this.spec.xpath||[ua(this.element)]},get element(){return this._element},toJSON:function(){var e={selector:this.selector,source:this.source,xpath:this.xpath,ancestry:this.ancestry,nodeIndexes:this.nodeIndexes,fromFrame:this.fromFrame};return this._includeElementInJson&&(e.element=this._element),e}},pa.fromFrame=function(e,t,n){return e=pa.mergeSpecs(e,n),new pa(n.element,t,e)},pa.mergeSpecs=function(e,t){return $({},e,{selector:[].concat(z(t.selector),z(e.selector)),ancestry:[].concat(z(t.ancestry),z(e.ancestry)),xpath:[].concat(z(t.xpath),z(e.xpath)),nodeIndexes:[].concat(z(t.nodeIndexes),z(e.nodeIndexes)),fromFrame:!0})},pa.setRunOptions=function(e){var t=e.elementRef;e=e.absolutePaths;sa.set(da,{elementRef:t,absolutePaths:e})};var fa=pa,ma=function(e,n,r,a){return{isAsync:!1,async:function(){return this.isAsync=!0\
,function(t){t instanceof Error==0?(e.result=t,r(e)):a(t)}},data:function(t){e.data=t},relatedNodes:function(n){t.Node&&(n=n instanceof t.Node||n instanceof vr?[n]:Sr(n),e.relatedNodes=[],n.forEach((function(n){(n=n instanceof vr?n.actualNode:n)instanceof t.Node&&(n=new fa(n),e.relatedNodes.push(n))})))}}};function Da(e){return function e(n,r){var o,i;if(null===n||"object"!==a(n))return n;if(null!=(o=t)&&o.Node&&n instanceof t.Node||null!=(o=t)&&o.HTMLCollection&&n instanceof t.HTMLCollection||"nodeName"in n&&"nodeType"in n&&"ownerDocument"in n)return n;if(r.has(n))return r.get(n);if(Array.isArray(n))return i=[],r.set(n,i),n.forEach((function(t){i.push(e(t,r))})),i;var u={};for(var l in r.set(n,u),n)u[l]=e(n[l],r);return u}(e,new Map)}(uu=new(ne(Wt()).CssSelectorParser)).registerSelectorPseudos("not"),uu.registerSelectorPseudos("is"),uu.registerNestingOperators(">"),uu.registerAttrEqualityMods("^","$","*","~");var ha=uu;function ga(e,t){return Ea(t).some((function(t){return Ca(e,t)}))}\
function ba(e,t){return i=t,1===(o=e).props.nodeType&&("*"===i.tag||o.props.nodeName===i.tag)&&(a=e,!(o=t).classes||o.classes.every((function(e){return a.hasClass(e.value)})))&&(r=e,!(i=t).attributes||i.attributes.every((function(e){var t=r.attr(e.key);return null!==t&&e.test(t)})))&&(o=e,!(i=t).id||o.props.id===i.id)&&(n=e,!((o=t).pseudos&&!o.pseudos.every((function(e){if("not"===e.name)return!e.expressions.some((function(e){return Ca(n,e)}));if("is"===e.name)return e.expressions.some((function(e){return Ca(n,e)}));throw new Error("the pseudo selector "+e.name+" has not yet been implemented")}))));var n,r,a,o,i}va=/(?=[\\-\\[\\]{}()*+?.\\\\\\^$|,#\\s])/g;var va,ya=function(e){return e.replace(va,"\\\\")},Fa=/\\\\/g;function wa(e){return e.map((function(e){for(var t=[],n=e.rule;n;)t.push({tag:n.tagName?n.tagName.toLowerCase():"*",combinator:n.nestingOperator||" ",id:n.id,attributes:function(e){if(e)return e.map((function(e){var t,n,r=e.name.replace(Fa,""),a=(e.value||"").replace(Fa,"");switch(e.o\
perator){case"^=":n=new RegExp("^"+ya(a));break;case"$=":n=new RegExp(ya(a)+"$");break;case"~=":n=new RegExp("(^|\\\\s)"+ya(a)+"(\\\\s|$)");break;case"|=":n=new RegExp("^"+ya(a)+"(-|$)");break;case"=":t=function(e){return a===e};break;case"*=":t=function(e){return e&&e.includes(a)};break;case"!=":t=function(e){return a!==e};break;default:t=function(e){return null!==e}}return""===a&&/^[*$^]=$/.test(e.operator)&&(t=function(){return!1}),{key:r,value:a,type:void 0===e.value?"attrExist":"attrValue",test:t=t||function(e){return e&&n.test(e)}}}))}(n.attrs),classes:function(e){if(e)return e.map((function(e){return{value:e=e.replace(Fa,""),regexp:new RegExp("(^|\\\\s)"+ya(e)+"(\\\\s|$)")}}))}(n.classNames),pseudos:function(e){if(e)return e.map((function(e){var t;return["is","not"].includes(e.name)&&(t=wa(t=(t=e.value).selectors||[t])),{name:e.name,expressions:t,value:e.value}}))}(n.pseudos)}),n=n.rule;return t}))}function Ea(e){return wa((e=ha.parse(e)).selectors||[e])}function Ca(e,t,n){return functi\
on e(t,n,r,a){if(!t)return!1;for(var o=Array.isArray(n)?n[r]:n,i=ba(t,o);!i&&a&&t.parent;)i=ba(t=t.parent,o);if(0<r){if(!1===[" ",">"].includes(o.combinator))throw new Error("axe.utils.matchesExpression does not support the combinator: "+o.combinator);i=i&&e(t.parent,n,r-1," "===o.combinator)}return i}(e,t,t.length-1,n)}var xa=function(e,t){for(;e;){if(ga(e,t))return e;if(void 0===e.parent)throw new TypeError("Cannot resolve parent for non-DOM nodes");e=e.parent}return null};function Aa(){}function ka(e){if("function"!=typeof e)throw new TypeError("Queue methods require functions as arguments")}for(var Na,Ba,Ta,Ra=function(){function e(e){t=e,setTimeout((function(){null!=t&&hr("Uncaught error (of queue)",t)}),1)}var t,n=[],r=0,o=0,i=Aa,u=!1,l=e;function s(e){return i=Aa,l(e),n}function c(){for(var e=n.length;r<e;r++){var t=n[r];try{t.call(null,function(e){return function(t){n[e]=t,--o||i===Aa||(u=!0,i(n))}}(r),s)}catch(e){s(e)}}}var d={defer:function(e){var r;if("object"===a(e)&&e.then\
&&e.catch&&(r=e,e=function(e,t){r.then(e).catch(t)}),ka(e),void 0===t){if(u)throw new Error("Queue already completed");return n.push(e),++o,c(),d}},then:function(e){if(ka(e),i!==Aa)throw new Error("queue \`then\` already set");return t||(i=e,o)||(u=!0,i(n)),d},catch:function(n){if(ka(n),l!==e)throw new Error("queue \`catch\` already set");return t?(n(t),t=null):l=n,d},abort:s};return d},_a=t.crypto||t.msCrypto,Oa=(!Na&&_a&&_a.getRandomValues&&(Ba=new Uint8Array(16),Na=function(){return _a.getRandomValues(Ba),Ba}),Na||(Ta=new Array(16),Na=function(){for(var e,t=0;t<16;t++)0==(3&t)&&(e=4294967296*Math.random()),Ta[t]=e>>>((3&t)<<3)&255;return Ta}),"function"==typeof t.Buffer?t.Buffer:Array),Sa=[],Ma={},Pa=0;Pa<256;Pa++)Sa[Pa]=(Pa+256).toString(16).substr(1),Ma[Sa[Pa]]=Pa;function Ia(e,t){return t=t||0,Sa[e[t++]]+Sa[e[t++]]+Sa[e[t++]]+Sa[e[t++]]+"-"+Sa[e[t++]]+Sa[e[t++]]+"-"+Sa[e[t++]]+Sa[e[t++]]+"-"+Sa[e[t++]]+Sa[e[t++]]+"-"+Sa[e[t++]]+Sa[e[t++]]+Sa[e[t++]]+Sa[e[t++]]+Sa[e[t++]]+Sa[e[+t]]}va\
r ja=[1|(uu=Na())[0],uu[1],uu[2],uu[3],uu[4],uu[5]],La=16383&(uu[6]<<8|uu[7]),qa=0,za=0;function Va(e,t,n){var r=t&&n||0,a=t||[],o=(n=null!=(e=e||{}).clockseq?e.clockseq:La,null!=e.msecs?e.msecs:(new Date).getTime()),i=null!=e.nsecs?e.nsecs:za+1;if((u=o-qa+(i-za)/1e4)<0&&null==e.clockseq&&(n=n+1&16383),1e4<=(i=(u<0||qa<o)&&null==e.nsecs?0:i))throw new Error("uuid.v1(): Can't create more than 10M uuids/sec");qa=o,La=n;for(var u=(1e4*(268435455&(o+=122192928e5))+(za=i))%4294967296,l=(i=(a[r++]=u>>>24&255,a[r++]=u>>>16&255,a[r++]=u>>>8&255,a[r++]=255&u,o/4294967296*1e4&268435455),a[r++]=i>>>8&255,a[r++]=255&i,a[r++]=i>>>24&15|16,a[r++]=i>>>16&255,a[r++]=n>>>8|128,a[r++]=255&n,e.node||ja),s=0;s<6;s++)a[r+s]=l[s];return t||Ia(a)}function $a(e,t,n){var r=t&&n||0,a=("string"==typeof e&&(t="binary"==e?new Oa(16):null,e=null),(e=e||{}).random||(e.rng||Na)());if(a[6]=15&a[6]|64,a[8]=63&a[8]|128,t)for(var o=0;o<16;o++)t[r+o]=a[o];return t||Ia(a)}(uu=$a).v1=Va,uu.v4=$a,uu.parse=function(e,t,n){var\
 r=t&&n||0,a=0;for(t=t||[],e.toLowerCase().replace(/[0-9a-f]{2}/g,(function(e){a<16&&(t[r+a++]=Ma[e])}));a<16;)t[r+a++]=0;return t},uu.unparse=Ia,uu.BufferClass=Oa,o._uuid=Va();var Ha=$a,Ua=Object.freeze(["EvalError","RangeError","ReferenceError","SyntaxError","TypeError","URIError"]);function Ga(){var e="axeAPI",t="";return(e=void 0!==o&&o._audit&&o._audit.application?o._audit.application:e)+"."+(void 0!==o?o.version:t)}function Wa(e){Ka(e),Or(t.parent===e,"Source of the response must be the parent window.")}function Ya(e){Ka(e),Or(e.parent===t,"Respondable target must be a frame in the current window")}function Ka(e){Or(t!==e,"Messages can not be sent to the same window.")}var Xa={},Za=[];function Ja(){var e="".concat($a(),":").concat($a());return Za.includes(e)?Ja():(Za.push(e),e)}function Qa(e,t,n,r){var a,i,u,l,s;return(n?Wa:Ya)(e),t.message instanceof Error&&!n?(o.log(t.message),!1):(s=(i=$({messageId:Ja()},t)).topic,u=i.channelId,l=i.message,u={channelId:u,topic:s,messageId:i.me\
ssageId,keepalive:!!i.keepalive,source:Ga()},l instanceof Error?u.error={name:l.name,message:l.message,stack:l.stack}:u.payload=l,a=JSON.stringify(u),!(!(s=o._audit.allowedOrigins)||!s.length||("function"==typeof r&&function(e,t,n){var r=!(2<arguments.length&&void 0!==n)||n;Or(!Xa[e],"A replyHandler already exists for this message channel."),Xa[e]={replyHandler:t,sendToParent:r}}(t.channelId,r,n),s.forEach((function(t){try{e.postMessage(a,t)}catch(n){if(n instanceof e.DOMException)throw new Error('allowedOrigins value "'.concat(t,'" is not a valid origin'));throw n}})),0)))}function eo(e,t,n){var r=!(2<arguments.length&&void 0!==n)||n;return function(n,a,o){Qa(e,{channelId:t,message:n,keepalive:a},r,o)}}function to(e,n){var r,i,u,l=e.origin,s=e.data;e=e.source;try{var c=function(e){var n,r,o,i;try{n=JSON.parse(e)}catch(e){return}if(null!==(e=n)&&"object"===a(e)&&"string"==typeof e.channelId&&e.source===Ga())return r=(e=n).topic,o=e.channelId,i=e.messageId,e=e.keepalive,{topic:r,message\
:"object"===a(n.error)?function(e){var n=e.message||"Unknown error occurred",r=Ua.includes(e.name)?e.name:"Error";return r=t[r]||Error,e.stack&&(n+="\\n"+e.stack.replace(e.message,"")),new r(n)}(n.error):n.payload,messageId:i,channelId:o,keepalive:!!e}}(s)||{},d=c.channelId,p=c.message,f=c.messageId;if(i=l,((u=o._audit.allowedOrigins)&&u.includes("*")||u.includes(i))&&(r=f,!Za.includes(r))&&(Za.push(r),1))if(p instanceof Error&&e.parent!==t)o.log(p);else try{if(c.topic){var m=eo(e,d);Wa(e),n(c,m)}else{var D=e,h=(b=c).channelId,g=b.message,b=b.keepalive,v=(y=function(e){return Xa[e]}(h)||{}).replyHandler,y=y.sendToParent;if(v){(y?Wa:Ya)(D),D=eo(D,h,y),!b&&h&&function(e){delete Xa[e]}(h);try{v(g,b,D)}catch(n){o.log(n),D(n,b)}}}}catch(n){var F=e,w=n,E=d;if(!F.parent!==t)o.log(w);else try{Qa(F,{topic:null,channelId:E,message:w,messageId:Ja(),keepalive:!0},!0)}catch(n){return void o.log(n)}}}catch(n){o.log(n)}}var no,ro,ao={open:function(e){var n;if("function"==typeof t.addEventListener)retu\
rn t.addEventListener("message",n=function(t){to(t,e)},!1),function(){t.removeEventListener("message",n,!1)}},post:function(e,n,r){return"function"==typeof t.addEventListener&&Qa(e,n,!1,r)}};function oo(e){e.updateMessenger(ao)}var io={};function uo(e,t,n,r,a){return t={topic:t,message:n,channelId:"".concat($a(),":").concat($a()),keepalive:r},ro(e,t,a)}function lo(e,t){var n=e.topic,r=e.message;e=e.keepalive;if(n=io[n])try{n(r,e,t)}catch(n){o.log(n),t(n,e)}}function so(e,t,n,r){var a,o=e.contentWindow,i=null!=(i=null==(i=t.options)?void 0:i.pingWaitTime)?i:500;o?0===i?co(e,t,n,r):(a=setTimeout((function(){a=setTimeout((function(){t.debug?r(po("No response from frame",e)):n(null)}),0)}),i),uo(o,"axe.ping",null,void 0,(function(){clearTimeout(a),co(e,t,n,r)}))):(hr("Frame does not have a content window",e),n(null))}function co(e,t,n,r){var a=null!=(a=null==(a=t.options)?void 0:a.frameWaitTime)?a:6e4,o=e.contentWindow,i=setTimeout((function(){r(po("Axe in frame timed out",e))}),a);uo(o,"a\
xe.start",t,void 0,(function(e){clearTimeout(i),(e instanceof Error==0?n:r)(e)}))}function po(e,t){var n;return o._tree&&(n=aa(t)),new Error(e+": "+(n||t))}uo.updateMessenger=function(e){var t=e.open;e=e.post,Or("function"==typeof t,"open callback must be a function"),Or("function"==typeof e,"post callback must be a function"),no&&no(),t=t(lo);no=t?(Or("function"==typeof t,"open callback must return a cleanup function"),t):null,ro=e},uo.subscribe=function(e,t){Or("function"==typeof t,"Subscriber callback must be a function"),Or(!io[e],"Topic ".concat(e," is already registered to.")),io[e]=t},uo.isInFrame=function(){return!!(0<arguments.length&&void 0!==arguments[0]?arguments[0]:t).frameElement},oo(uo);var fo=null,mo={update:function(e){Or("object"===a(e),"serializer must be an object"),fo=e},toSpec:function(e){return mo.dqElmToSpec(new fa(e))},dqElmToSpec:function(e,t){var n,r,a,o,i;return e instanceof fa==0?e:(t&&(r=(n=e).fromFrame,a=t.ancestry,o=t.xpath,i=!1!==t.selectors||r,(n=new f\
a(n.element,t,{source:n.source,nodeIndexes:n.nodeIndexes,selector:i?n.selector:[":root"],ancestry:a?n.ancestry:[":root"],xpath:o?n.xpath:"/"})).fromFrame=r,e=n),"function"==typeof(null==(t=fo)?void 0:t.toSpec)?fo.toSpec(e):e.toJSON())},mergeSpecs:function(e,t){var n;return("function"==typeof(null==(n=fo)?void 0:n.mergeSpecs)?fo:fa).mergeSpecs(e,t)},mapRawResults:function(e){return e.map((function(e){return $({},e,{nodes:mo.mapRawNodeResults(e.nodes)})}))},mapRawNodeResults:function(e){return null==e?void 0:e.map((function(e){var t=e.node,n=q(e,u);n.node=mo.dqElmToSpec(t);for(var r=0,a=["any","all","none"];r<a.length;r++){var o=a[r];n[o]=n[o].map((function(e){var t=e.relatedNodes;return(e=q(e,l)).relatedNodes=t.map(mo.dqElmToSpec),e}))}return n}))}},Do=mo,ho=function(e){return[].concat(e.any||[]).concat(e.all||[]).concat(e.none||[])},go=function(e,t,n){if(Array.isArray(e))return e.find((function(e){return null!==e&&"object"===a(e)&&Object.hasOwn(e,t)&&e[t]===n}))};function bo(e,t){for(v\
ar n=0<arguments.length&&void 0!==e?e:[],r=1<arguments.length&&void 0!==t?t:[],a=Math.max(null==n?void 0:n.length,null==r?void 0:r.length),o=0;o<a;o++){var i=null==n?void 0:n[o],u=null==r?void 0:r[o];if("number"!=typeof i||isNaN(i))return 0===o?1:-1;if("number"!=typeof u||isNaN(u))return 0===o?-1:1;if(i!==u)return i-u}return 0}var vo=function(e,t){var n=[];return e.forEach((function(e){var t,r=(r=e)&&r.results?Array.isArray(r.results)?r.results.length?r.results:null:[r.results]:null;r&&r.length&&(t=function(e){return e.frameElement?Do.toSpec(e.frameElement):e.frameSpec?e.frameSpec:null}(e),r.forEach((function(e){e.nodes&&t&&(a=e.nodes,r=t,a.forEach((function(e){e.node=Do.mergeSpecs(e.node,r),ho(e).forEach((function(e){e.relatedNodes=e.relatedNodes.map((function(e){return Do.mergeSpecs(e,r)}))}))})));var r,a=go(n,"id",e.id);if(a){if(e.nodes.length){for(var o=a.nodes,i=e.nodes,u=i[0].node,l=0;l<o.length;l++){var s=o[l].node,c=bo(s.nodeIndexes,u.nodeIndexes);if(0<c||0===c&&u.selector.leng\
th<s.selector.length)return void o.splice.apply(o,[l,0].concat(z(i)))}o.push.apply(o,z(i))}}else n.push(e)})))})),n.forEach((function(e){e.nodes&&e.nodes.sort((function(e,t){return bo(e.node.nodeIndexes,t.node.nodeIndexes)}))})),n};function yo(e,t,n,r,a,o){t=$({},t,{elementRef:!1});var i=Ra();e.frames.forEach((function(e){var a=e.node,o=q(e,s);i.defer((function(e,i){so(a,{options:t,command:n,parameter:r,context:o},(function(t){return e(t?{results:t,frameElement:a}:null)}),i)}))})),i.then((function(e){a(vo(e,t))})).catch(o)}function Fo(e,t){if(!e.shadowId&&!t.shadowId&&e.actualNode&&"function"==typeof e.actualNode.contains)return e.actualNode.contains(t.actualNode);do{if(e===t)return!0;if(t.nodeIndex<e.nodeIndex)return!1}while(t=t.parent);return!1}var wo=function e(){for(var t={},n=arguments.length,r=new Array(n),o=0;o<n;o++)r[o]=arguments[o];return r.forEach((function(n){if(n&&"object"===a(n)&&!Array.isArray(n))for(var r=0,o=Object.keys(n);r<o.length;r++){var i=o[r];!t.hasOwnProperty(i\
)||"object"!==a(n[i])||Array.isArray(t[i])?t[i]=n[i]:t[i]=e(t[i],n[i])}})),t},Eo=function(e,t){Object.assign(e,t),Object.keys(t).filter((function(e){return"function"==typeof t[e]})).forEach((function(n){e[n]=null;try{e[n]=t[n](e)}catch(n){}}))},Co=["article","aside","blockquote","body","div","footer","h1","h2","h3","h4","h5","h6","header","main","nav","p","section","span"],xo=function(e){return!!(e.shadowRoot&&(e=e.nodeName.toLowerCase(),Co.includes(e)||/^[a-z][a-z0-9_.-]*-[a-z0-9_.-]*$/.test(e)))},Ao={},ko=(te(Ao,{createGrid:function(){return Ci},findElmsInContext:function(){return Bo},findNearbyElms:function(){return _i},findUp:function(){return Ro},findUpVirtual:function(){return To},focusDisabled:function(){return Li},getComposedParent:function(){return Jo},getElementByReference:function(){return $i},getElementCoordinates:function(){return ei},getElementStack:function(){return Wi},getModalDialog:function(){return Si},getOverflowHiddenAncestors:function(){return So},getRootNode:func\
tion(){return No},getScrollOffset:function(){return Qo},getTabbableElements:function(){return Yi},getTargetRects:function(){return Ji},getTargetSize:function(){return Qi},getTextElementStack:function(){return Ml},getViewportSize:function(){return ti},getVisibleChildTextRects:function(){return Sl},hasContent:function(){return zl},hasContentVirtual:function(){return ql},hasLangText:function(){return Vl},idrefs:function(){return tu},insertedIntoFocusOrder:function(){return $l},isCurrentPageLink:function(){return Vi},isFocusable:function(){return Xi},isHTML5:function(){return Wl},isHiddenForEveryone:function(){return Ko},isHiddenWithCSS:function(){return Gl},isInTabOrder:function(){return Zi},isInTextBlock:function(){return Zl},isInert:function(){return Mi},isModalOpen:function(){return Jl},isMultiline:function(){return Ql},isNativelyFocusable:function(){return Ki},isNode:function(){return ns},isOffscreen:function(){return ni},isOpaque:function(){return Gd},isSkipLink:function(){return Wd}\
,isVisible:function(){return Zd},isVisibleOnScreen:function(){return ai},isVisibleToScreenReaders:function(){return Xu},isVisualContent:function(){return Il},reduceToElementsBelowFloating:function(){return Jd},shadowElementsFromPoint:function(){return np},urlPropsFromAttribute:function(){return rp},visuallyContains:function(){return Qd},visuallyOverlaps:function(){return ap},visuallySort:function(){return Hi}}),function(e){var t=e.getRootNode&&e.getRootNode()||r;return t===e?r:t}),No=ko,Bo=function(e){var t=e.context,n=e.value,r=e.attr;e=void 0===(e=e.elm)?"":e,n=Mr(n),t=9===t.nodeType||11===t.nodeType?t:No(t);return Array.from(t.querySelectorAll(e+"["+r+"="+n+"]"))},To=function(e,t){var n=e.actualNode;if(!e.shadowId&&"function"==typeof e.actualNode.closest)return e.actualNode.closest(t)||null;for(;(n=(n=n.assignedSlot||n.parentNode)&&11===n.nodeType?n.host:n)&&!zr(n,t)&&n!==r.documentElement;);return n&&zr(n,t)?n:null},Ro=function(e,t){return To(ca(e),t)};function _o(e,t){return(0|e.l\
eft)<(0|t.right)&&(0|e.right)>(0|t.left)&&(0|e.top)<(0|t.bottom)&&(0|e.bottom)>(0|t.top)}var Oo=$r((function(e){var t=[];return e?("hidden"===e.getComputedStylePropertyValue("overflow")&&t.push(e),t.concat(Oo(e.parent))):t})),So=Oo,Mo=/rect\\s*\\(([0-9]+)px,?\\s*([0-9]+)px,?\\s*([0-9]+)px,?\\s*([0-9]+)px\\s*\\)/,Po=/(\\w+)\\((\\d+)/;function Io(e){return["style","script","noscript","template"].includes(e.props.nodeName)}function jo(e){return"area"!==e.props.nodeName&&"none"===e.getComputedStylePropertyValue("display")}function Lo(e){return!(1<arguments.length&&void 0!==arguments[1]?arguments[1]:{}).isAncestor&&["hidden","collapse"].includes(e.getComputedStylePropertyValue("visibility"))}function qo(e){return!!(1<arguments.length&&void 0!==arguments[1]?arguments[1]:{}).isAncestor&&"hidden"===e.getComputedStylePropertyValue("content-visibility")}function zo(e){return"true"===e.attr("aria-hidden")}function Vo(e){return"0"===e.getComputedStylePropertyValue("opacity")}function $o(e){var t=Hp(e.actual\
Node),n=parseInt(e.getComputedStylePropertyValue("height"));e=parseInt(e.getComputedStylePropertyValue("width"));return!!t&&(0===n||0===e)}function Ho(e){var t,n;return!(1<arguments.length&&void 0!==arguments[1]?arguments[1]:{}).isAncestor&&(t=e.boundingClientRect,!!(n=So(e)).length)&&n.some((function(e){return(e=e.boundingClientRect).width<2||e.height<2||!_o(t,e)}))}function Uo(e){var t=e.getComputedStylePropertyValue("clip").match(Mo),n=e.getComputedStylePropertyValue("clip-path").match(Po);if(t&&5===t.length&&(e=e.getComputedStylePropertyValue("position"),["fixed","absolute"].includes(e)))return t[3]-t[1]<=0&&t[2]-t[4]<=0;if(n){e=n[1];var r=parseInt(n[2],10);switch(e){case"inset":return 50<=r;case"circle":return 0===r}}return!1}function Go(e,t){var n,r=xa(e,"map");return!r||!((r=r.attr("name"))&&(e=ko(e.actualNode))&&9===e.nodeType&&(n=Cf(o._tree,'img[usemap="#'.concat(Mr(r),'"]')))&&n.length)||n.some((function(e){return!t(e)}))}function Wo(e){var t;return"details"===(null==(t=e.par\
ent)?void 0:t.props.nodeName)&&(("summary"!==e.props.nodeName||e.parent.children.find((function(e){return"summary"===e.props.nodeName}))!==e)&&!e.parent.hasAttr("open"))}var Yo=[jo,Lo,qo,Wo];function Ko(e){var t=(n=1<arguments.length&&void 0!==arguments[1]?arguments[1]:{}).skipAncestors,n=void 0!==(n=n.isAncestor)&&n;return e=nf(e).vNode,(t?Xo:Zo)(e,n)}var Xo=$r((function(e,t){return!!Io(e)||!(!e.actualNode||!Yo.some((function(n){return n(e,{isAncestor:t})}))&&e.actualNode.isConnected)})),Zo=$r((function(e,t){return!!Xo(e,t)||!!e.parent&&Zo(e.parent,!0)})),Jo=function e(t){if(t.assignedSlot)return e(t.assignedSlot);if(t.parentNode){if(1===(t=t.parentNode).nodeType)return t;if(t.host)return t.host}return null},Qo=function(e){var t,n;return 9===(e=!e.nodeType&&e.document?e.document:e).nodeType?(t=e.documentElement,n=e.body,{left:t&&t.scrollLeft||n&&n.scrollLeft||0,top:t&&t.scrollTop||n&&n.scrollTop||0}):{left:e.scrollLeft,top:e.scrollTop}},ei=function(e){var t=(n=Qo(r)).left,n=n.top;retu\
rn{top:(e=e.getBoundingClientRect()).top+n,right:e.right+t,bottom:e.bottom+n,left:e.left+t,width:e.right-e.left,height:e.bottom-e.top}},ti=function(e){var t=e.document,n=t.documentElement;return e.innerWidth?{width:e.innerWidth,height:e.innerHeight}:n?{width:n.clientWidth,height:n.clientHeight}:{width:(e=t.body).clientWidth,height:e.clientHeight}},ni=function(e){if((1<arguments.length&&void 0!==arguments[1]?arguments[1]:{}).isAncestor)return!1;var n=nf(e).domNode;if(n){var a=r.documentElement,o=t.getComputedStyle(n),i=t.getComputedStyle(r.body||a).getPropertyValue("direction"),u=ei(n);if(u.bottom<0&&(function(e,t){for(e=Jo(e);e&&"html"!==e.nodeName.toLowerCase();){if(e.scrollTop&&0<=(t+=e.scrollTop))return;e=Jo(e)}return 1}(n,u.bottom)||"absolute"===o.position))return!0;if(0!==u.left||0!==u.right)if("ltr"===i){if(u.right<=0)return!0}else if(n=Math.max(a.scrollWidth,ti(t).width),u.left>=n)return!0;return!1}},ri=[Vo,$o,Ho,Uo,ni];function ai(e){return e=nf(e).vNode,oi(e)}var oi=$r((functi\
on(e,t){return e.actualNode&&"area"===e.props.nodeName?!Go(e,oi):!(Ko(e,{skipAncestors:!0,isAncestor:t})||e.actualNode&&ri.some((function(n){return n(e,{isAncestor:t})})))&&(!e.parent||oi(e.parent,!0))}));function ii(e,n){var r=Math.min(e.top,n.top),a=Math.max(e.right,n.right),o=Math.max(e.bottom,n.bottom);e=Math.min(e.left,n.left);return new t.DOMRect(e,r,a-e,o-r)}function ui(e,t){var n=e.x,r=(e=e.y,t.top),a=t.right,o=t.bottom;t=t.left;return r<=e&&n<=a&&e<=o&&t<=n}var li={};function si(e,n){var r=Math.max(e.left,n.left),a=Math.min(e.right,n.right),o=Math.max(e.top,n.top);e=Math.min(e.bottom,n.bottom);return a<=r||e<=o?null:new t.DOMRect(r,o,a-r,e-o)}function ci(e){var n=e.left,r=e.top,a=e.width;e=e.height;return new t.DOMPoint(n+a/2,r+e/2)}te(li,{getBoundingRect:function(){return ii},getIntersectionRect:function(){return si},getOffset:function(){return fi},getRectCenter:function(){return ci},hasVisualOverlap:function(){return Di},isPointInRect:function(){return ui},rectHasMinimumSize\
:function(){return pi},rectsOverlap:function(){return _o},splitRects:function(){return hi}});var di=.05;function pi(e,t){var n=t.width;t=t.height;return e<=n+di&&e<=t+di}function fi(e,t){var n=2<arguments.length&&void 0!==arguments[2]?arguments[2]:12,r=Ji(e),a=Ji(t);if(!r.length||!a.length)return 0;var o,i=ci(r.reduce(ii)),u=1/0,l=Z(a);try{for(l.s();!(o=l.n()).done;){var s=o.value;if(ui(i,s))return 0;var c=mi(i,function(e,t){return{x:e.x<t.left?t.left:e.x>t.right?t.right:e.x,y:t=e.y<t.top?t.top:e.y>t.bottom?t.bottom:e.y}}(i,s));u=Math.min(u,c)}}catch(e){l.e(e)}finally{l.f()}return pi(2*n,Qi(t))?u:(r=mi(i,ci(a.reduce(ii)))-n,Math.max(0,Math.min(u,r)))}function mi(e,t){return Math.hypot(e.x-t.x,e.y-t.y)}function Di(e,t){var n=e.boundingClientRect,r=t.boundingClientRect;return!(n.left>=r.right||n.right<=r.left||n.top>=r.bottom||n.bottom<=r.top)&&0<Hi(e,t)}function hi(e,t){var n,r=[e],a=Z(t);try{function o(){var e=n.value;r=r.reduce((function(t,n){return t.concat(function(e,t){var n=e.top,\
r=e.left,a=e.bottom,o=e.right,i=n<t.bottom&&a>t.top,u=r<t.right&&o>t.left,l=[];if(gi(t.top,n,a)&&u&&l.push({top:n,left:r,bottom:t.top,right:o}),gi(t.right,r,o)&&i&&l.push({top:n,left:t.right,bottom:a,right:o}),gi(t.bottom,n,a)&&u&&l.push({top:t.bottom,right:o,bottom:a,left:r}),gi(t.left,r,o)&&i&&l.push({top:n,left:r,bottom:a,right:t.left}),0===l.length){if(function(e,t){return e.top>=t.top&&e.left>=t.left&&e.bottom<=t.bottom&&e.right<=t.right}(e,t))return[];l.push(e)}return l.map(bi)}(n,e))}),[])}for(a.s();!(n=a.n()).done;)o()}catch(e){a.e(e)}finally{a.f()}return r}var gi=function(e,t,n){return t<e&&e<n};function bi(e){return new t.DOMRect(e.left,e.top,e.right-e.left,e.bottom-e.top)}var vi=0,yi=.1,Fi=.2,wi=.3,Ei=0;function Ci(){var e=0<arguments.length&&void 0!==arguments[0]?arguments[0]:r.body,n=1<arguments.length?arguments[1]:void 0,a=2<arguments.length&&void 0!==arguments[2]?arguments[2]:null;if(!sa.get("gridCreated")||a){sa.set("gridCreated",!0),a||(u=(u=ca(r.documentElement))||new\
 lp(r.documentElement),Ei=0,u._stackingOrder=[ki(vi,Ei++,null)],Ni(n=null!=n?n:new Bi,u),Hp(u.actualNode)&&(i=new Bi(u),u._subGrid=i));for(var i,u,l=r.createTreeWalker(e,t.NodeFilter.SHOW_ELEMENT,null,!1),s=a?l.nextNode():l.currentNode;s;){var c=ca(s),d=(c&&c.parent?a=c.parent:s.assignedSlot?a=ca(s.assignedSlot):s.parentElement?a=ca(s.parentElement):s.parentNode&&ca(s.parentNode)&&(a=ca(s.parentNode)),(c=c||new o.VirtualNode(s,a))._stackingOrder=function(e,t,n){var r=t._stackingOrder.slice();xi(e,t)&&-1!==(a=r.findIndex((function(e){return e=e.stackLevel,[vi,Fi,wi].includes(e)})))&&r.splice(a,r.length-a);var a=function(e,t){var n=function(e,t){return"static"!==e.getComputedStylePropertyValue("position")||Ai(t)?e.getComputedStylePropertyValue("z-index"):"auto"}(e,t);return["auto","0"].includes(n)?"static"!==e.getComputedStylePropertyValue("position")?wi:"none"!==e.getComputedStylePropertyValue("float")?Fi:xi(e,t)?yi:null:parseInt(n)}(e,t);return null!==a&&r.push(ki(a,n,e)),r}(c,a,Ei++),\
function(e,t){for(var n=null,r=[e];t;){if(Hp(t.actualNode)){n=t;break}if(t._scrollRegionParent){n=t._scrollRegionParent;break}r.push(t),t=ca(t.actualNode.parentElement||t.actualNode.parentNode)}return r.forEach((function(e){return e._scrollRegionParent=n})),n}(c,a)),p=(d=d?d._subGrid:n,Hp(c.actualNode)&&(p=new Bi(c),c._subGrid=p),c.boundingClientRect);0!==p.width&&0!==p.height&&ai(s)&&Ni(d,c),xo(s)&&Ci(s.shadowRoot,d,c),s=l.nextNode()}}return Dr.gridSize}function xi(e,t){var n=e.getComputedStylePropertyValue("position"),r=e.getComputedStylePropertyValue("z-index");return"fixed"===n||"sticky"===n||"auto"!==r&&"static"!==n||"1"!==e.getComputedStylePropertyValue("opacity")||"none"!==(e.getComputedStylePropertyValue("-webkit-transform")||e.getComputedStylePropertyValue("-ms-transform")||e.getComputedStylePropertyValue("transform")||"none")||(n=e.getComputedStylePropertyValue("mix-blend-mode"))&&"normal"!==n||(n=e.getComputedStylePropertyValue("filter"))&&"none"!==n||(n=e.getComputedStylePr\
opertyValue("perspective"))&&"none"!==n||(n=e.getComputedStylePropertyValue("clip-path"))&&"none"!==n||"none"!==(e.getComputedStylePropertyValue("-webkit-mask")||e.getComputedStylePropertyValue("mask")||"none")||"none"!==(e.getComputedStylePropertyValue("-webkit-mask-image")||e.getComputedStylePropertyValue("mask-image")||"none")||"none"!==(e.getComputedStylePropertyValue("-webkit-mask-border")||e.getComputedStylePropertyValue("mask-border")||"none")||"isolate"===e.getComputedStylePropertyValue("isolation")||"transform"===(n=e.getComputedStylePropertyValue("will-change"))||"opacity"===n||"touch"===e.getComputedStylePropertyValue("-webkit-overflow-scrolling")||(n=e.getComputedStylePropertyValue("contain"),["layout","paint","strict","content"].includes(n))||!("auto"===r||!Ai(t))}function Ai(e){if(e)return e=e.getComputedStylePropertyValue("display"),["flex","inline-flex","grid","inline-grid"].includes(e)}function ki(e,t,n){return{stackLevel:e,treeOrder:t,vNode:n}}function Ni(e,t){var n=S\
o(t);t.clientRects.forEach((function(r){r=n.reduce((function(e,t){return e&&si(e,t.boundingClientRect)}),r);r&&(null==t._grid&&(t._grid=e),r=e.getGridPositionOfRect(r),e.loopGridPosition(r,(function(e){e.includes(t)||e.push(t)})))}))}K(Ti,[{key:"toGridIndex",value:function(e){return Math.floor(e/Dr.gridSize)}},{key:"getCellFromPoint",value:function(e){var t=e.x;e=e.y,Or(this.boundaries,"Grid does not have cells added"),e=this.toGridIndex(e),t=this.toGridIndex(t);return null!=(t=(e=(Or(ui({y:e,x:t},this.boundaries),"Element midpoint exceeds the grid bounds"),null!=(e=this.cells[e-this.cells._negativeIndex])?e:[]))[t-e._negativeIndex])?t:[]}},{key:"loopGridPosition",value:function(e,t){var n=(o=e).left,r=o.right,a=o.top,o=o.bottom;this.boundaries&&(e=ii(this.boundaries,e)),this.boundaries=e,Ri(this.cells,a,o,(function(e,a){Ri(e,n,r,(function(e,n){t(e,{row:a,col:n})}))}))}},{key:"getGridPositionOfRect",value:function(e){var n=e.top,r=e.right,a=e.bottom,o=e.left,i=1<arguments.length&&void \
0!==arguments[1]?arguments[1]:0;n=this.toGridIndex(n-i),r=this.toGridIndex(r+i-1),a=this.toGridIndex(a+i-1),o=this.toGridIndex(o-i);return new t.DOMRect(o,n,r-o,a-n)}}]);var Bi=Ti;function Ti(){var e=0<arguments.length&&void 0!==arguments[0]?arguments[0]:null;W(this,Ti),this.container=e,this.cells=[]}function Ri(e,t,n,r){if(null!=e._negativeIndex||(e._negativeIndex=0),t<e._negativeIndex){for(var a=0;a<e._negativeIndex-t;a++)e.splice(0,0,[]);e._negativeIndex=t}for(var o,i=t-e._negativeIndex,u=n-e._negativeIndex,l=i;l<=u;l++)null==e[o=l]&&(e[o]=[]),r(e[l],l+e._negativeIndex)}function _i(e){var t,n,r,a,o=1<arguments.length&&void 0!==arguments[1]?arguments[1]:0;return Ci(),null!=(r=e._grid)&&null!=(r=r.cells)&&r.length?(r=e.boundingClientRect,t=e._grid,n=Oi(e),r=t.getGridPositionOfRect(r,o),a=[],t.loopGridPosition(r,(function(t){var r,o=Z(t);try{for(o.s();!(r=o.n()).done;){var i=r.value;i&&i!==e&&!a.includes(i)&&n===Oi(i)&&a.push(i)}}catch(t){o.e(t)}finally{o.f()}})),a):[]}var Oi=$r((funct\
ion(e){return!!e&&("fixed"===e.getComputedStylePropertyValue("position")||Oi(e.parent))})),Si=$r((function(){var e;return o._tree&&(e=mf(o._tree[0],"dialog[open]",(function(e){var t=e.boundingClientRect;return r.elementsFromPoint(t.left+1,t.top+1).includes(e.actualNode)&&ai(e)}))).length?e.find((function(e){var t=e.boundingClientRect;return r.elementsFromPoint(t.left-10,t.top-10).includes(e.actualNode)}))||(null!=(e=e.find((function(e){e=null!=(e=function(e){Ci();var n=o._tree[0]._grid,r=new t.DOMRect(0,0,t.innerWidth,t.innerHeight);if(n)for(var a=0;a<n.cells.length;a++){var i=n.cells[a];if(i)for(var u=0;u<i.length;u++){var l=i[u];if(l)for(var s=0;s<l.length;s++){var c=l[s],d=si(c.boundingClientRect,r);if("html"!==c.props.nodeName&&c!==e&&"none"!==c.getComputedStylePropertyValue("pointer-events")&&d)return{vNode:c,rect:d}}}}}(e))?e:{};var n=e.vNode;e=e.rect;return!!n&&!r.elementsFromPoint(e.left+1,e.top+1).includes(n.actualNode)})))?e:null):null}));function Mi(e){var t=(n=1<arguments.l\
ength&&void 0!==arguments[1]?arguments[1]:{}).skipAncestors,n=n.isAncestor;return(t?Pi:Ii)(e,n)}var Pi=$r((function(e,t){return!!e.hasAttr("inert")||!(t||!e.actualNode||!(t=Si())||Fo(t,e))})),Ii=$r((function(e,t){return!!Pi(e,t)||!!e.parent&&Ii(e.parent,!0)})),ji=["button","command","fieldset","keygen","optgroup","option","select","textarea","input"],Li=function(e){var t=nf(e).vNode;if(e=t.props.nodeName,ji.includes(e)&&t.hasAttr("disabled")||Mi(t))return!0;for(var n=t.parent,r=[],a=!1;n&&n.shadowId===t.shadowId&&!a&&(r.push(n),"legend"!==n.props.nodeName);){if(void 0!==n._inDisabledFieldset){a=n._inDisabledFieldset;break}"fieldset"===n.props.nodeName&&n.hasAttr("disabled")&&(a=!0),n=n.parent}return r.forEach((function(e){return e._inDisabledFieldset=a})),!!a||"area"!==t.props.nodeName&&!!t.actualNode&&Ko(t)},qi=/^\\/\\#/,zi=/^#[!/]/;function Vi(e){var n,r,a,o,i=e.getAttribute("href");return!(!i||"#"===i)&&(!!qi.test(i)||(o=e.hash,n=e.protocol,r=e.hostname,a=e.port,e=e.pathname,!zi.test(\
o)&&("#"===i.charAt(0)||("string"!=typeof(null==(o=t.location)?void 0:o.origin)||-1===t.location.origin.indexOf("://")?null:(i=t.location.origin+t.location.pathname,o=r?"".concat(n,"//").concat(r).concat(a?":".concat(a):""):t.location.origin,(o+=e?("/"!==e[0]?"/":"")+e:t.location.pathname)===i)))))}var $i=function(e,t){var n=e.getAttribute(t);return n&&("href"!==t||Vi(e))?(-1!==n.indexOf("#")&&(n=decodeURIComponent(n.substr(n.indexOf("#")+1))),(t=r.getElementById(n))||((t=r.getElementsByName(n)).length?t[0]:null)):null};function Hi(e,n){Ci();for(var r=Math.max(e._stackingOrder.length,n._stackingOrder.length),a=0;a<r;a++){if(void 0===n._stackingOrder[a])return-1;if(void 0===e._stackingOrder[a])return 1;if(n._stackingOrder[a].stackLevel>e._stackingOrder[a].stackLevel)return 1;if(n._stackingOrder[a].stackLevel<e._stackingOrder[a].stackLevel)return-1;if(n._stackingOrder[a].treeOrder!==e._stackingOrder[a].treeOrder)return n._stackingOrder[a].treeOrder-e._stackingOrder[a].treeOrder}var o=e.a\
ctualNode,i=n.actualNode;if(o.getRootNode&&o.getRootNode()!==i.getRootNode()){for(var u=[];o;)u.push({root:o.getRootNode(),node:o}),o=o.getRootNode().host;for(;i&&!u.find((function(e){return e.root===i.getRootNode()}));)i=i.getRootNode().host;if((o=u.find((function(e){return e.root===i.getRootNode()})).node)===i)return e.actualNode.getRootNode()!==o.getRootNode()?-1:1}var l,s=(d=t.Node).DOCUMENT_POSITION_FOLLOWING,c=d.DOCUMENT_POSITION_CONTAINS,d=d.DOCUMENT_POSITION_CONTAINED_BY;s=(l=o.compareDocumentPosition(i))&s?1:-1,c=l&c||l&d;return(l=Ui(e))===(d=Ui(n))||c?s:d-l}function Ui(e){return-1!==e.getComputedStylePropertyValue("display").indexOf("inline")?2:function e(t){if(!t)return!1;if(void 0!==t._isFloated)return t._isFloated;var n=t.getComputedStylePropertyValue("float");return"none"!==n?t._isFloated=!0:(n=e(t.parent),t._isFloated=n,n)}(e)?1:0}function Gi(e,t,n){var a=2<arguments.length&&void 0!==n&&n,o=ci(t),i=e.getCellFromPoint(o)||[],u=Math.floor(o.x),l=Math.floor(o.y);o=i.filter(\
(function(e){return e.clientRects.some((function(e){var t=e.left,n=e.top;return u<Math.floor(t+e.width)&&u>=Math.floor(t)&&l<Math.floor(n+e.height)&&l>=Math.floor(n)}))}));return(i=e.container)&&(o=Gi(i._grid,i.boundingClientRect,!0).concat(o)),a?o:o.sort(Hi).map((function(e){return e.actualNode})).concat(r.documentElement).filter((function(e,t,n){return n.indexOf(e)===t}))}var Wi=function(e){Ci();var t=(e=ca(e))._grid;return t?Gi(t,e.boundingClientRect):[]},Yi=function(e){return Cf(e,"*").filter((function(e){var t=e.isFocusable;return(e=(e=e.actualNode.getAttribute("tabindex"))&&!isNaN(parseInt(e,10))?parseInt(e):null)?t&&0<=e:t}))},Ki=function(e){var t=nf(e).vNode;if(t&&!Li(t))switch(t.props.nodeName){case"a":case"area":if(t.hasAttr("href"))return!0;break;case"input":return"hidden"!==t.props.type;case"textarea":case"select":case"summary":case"button":return!0;case"details":return!Cf(t,"summary").length}return!1};function Xi(e){return 1===(e=nf(e).vNode).props.nodeType&&!(Li(e)||!Ki(e\
)&&(!(e=e.attr("tabindex"))||isNaN(parseInt(e,10))))}function Zi(e){return 1===(e=nf(e).vNode).props.nodeType&&!(parseInt(e.attr("tabindex",10))<=-1)&&Xi(e)}var Ji=$r((function(e){var t=e.boundingClientRect,n=_i(e).filter((function(t){return Di(e,t)&&"none"!==t.getComputedStylePropertyValue("pointer-events")&&!(e.actualNode.contains(t.actualNode)&&!Zi(t))}));return n.length?(n=n.map((function(e){return e.boundingClientRect})),hi(t,n)):[t]})),Qi=$r((function(e,t){return function(e,t){return e.reduce((function(e,n){var r=pi(t,e);return r!==pi(t,n)?r?e:n:(r=e.width*e.height,n.width*n.height<r?e:n)}))}(Ji(e),t)})),eu={},tu=(te(eu,{accessibleText:function(){return nu},accessibleTextVirtual:function(){return wl},autocomplete:function(){return Al},formControlValue:function(){return cl},formControlValueMethods:function(){return ll},hasUnicode:function(){return yl},isHumanInterpretable:function(){return xl},isIconLigature:function(){return Fl},isValidAutocomplete:function(){return kl},label:fun\
ction(){return Rl},labelText:function(){return fl},labelVirtual:function(){return Tl},nativeElementType:function(){return _l},nativeTextAlternative:function(){return bl},nativeTextMethods:function(){return gl},removeUnicode:function(){return Cl},sanitize:function(){return Eu},subtreeText:function(){return pl},titleText:function(){return Gu},unsupported:function(){return Ku},visible:function(){return Bl},visibleTextNodes:function(){return Ol},visibleVirtual:function(){return Ju}}),function(e,t){e=e.actualNode||e;try{var n=No(e),r=[];if(a=e.getAttribute(t))for(var a=sp(a),o=0;o<a.length;o++)r.push(n.getElementById(a[o]));return r}catch(e){throw new TypeError("Cannot resolve id references for non-DOM nodes")}}),nu=function(e,t){return wl(ca(e),t)},ru=function(e){var t=1<arguments.length&&void 0!==arguments[1]?arguments[1]:{},n=nf(e).vNode;return 1!==(null==n?void 0:n.props.nodeType)||1!==n.props.nodeType||t.inLabelledByContext||t.inControlContext||!n.attr("aria-labelledby")?"":tu(n,"aria-\
labelledby").filter((function(e){return e})).reduce((function(e,r){return r=nu(r,$({inLabelledByContext:!0,startNode:t.startNode||n},t)),e?"".concat(e," ").concat(r):r}),"")};function au(e){return 1===(null==(e=nf(e).vNode)?void 0:e.props.nodeType)&&e.attr("aria-label")||""}var ou={"aria-activedescendant":{type:"idref",allowEmpty:!0},"aria-atomic":{type:"boolean",global:!0},"aria-autocomplete":{type:"nmtoken",values:["inline","list","both","none"]},"aria-braillelabel":{type:"string",allowEmpty:!0,global:!0},"aria-brailleroledescription":{type:"string",allowEmpty:!0,global:!0},"aria-busy":{type:"boolean",global:!0},"aria-checked":{type:"nmtoken",values:["false","mixed","true","undefined"]},"aria-colcount":{type:"int",minValue:-1},"aria-colindex":{type:"int",minValue:1},"aria-colspan":{type:"int",minValue:1},"aria-controls":{type:"idrefs",allowEmpty:!0,global:!0},"aria-current":{type:"nmtoken",allowEmpty:!0,values:["page","step","location","date","time","true","false"],global:!0},"aria-d\
escribedby":{type:"idrefs",allowEmpty:!0,global:!0},"aria-description":{type:"string",allowEmpty:!0,global:!0},"aria-details":{type:"idref",allowEmpty:!0,global:!0},"aria-disabled":{type:"boolean",global:!0},"aria-dropeffect":{type:"nmtokens",values:["copy","execute","link","move","none","popup"],global:!0},"aria-errormessage":{type:"idref",allowEmpty:!0,global:!0},"aria-expanded":{type:"nmtoken",values:["true","false","undefined"]},"aria-flowto":{type:"idrefs",allowEmpty:!0,global:!0},"aria-grabbed":{type:"nmtoken",values:["true","false","undefined"],global:!0},"aria-haspopup":{type:"nmtoken",allowEmpty:!0,values:["true","false","menu","listbox","tree","grid","dialog"],global:!0},"aria-hidden":{type:"nmtoken",values:["true","false","undefined"],global:!0},"aria-invalid":{type:"nmtoken",values:["grammar","false","spelling","true"],global:!0},"aria-keyshortcuts":{type:"string",allowEmpty:!0,global:!0},"aria-label":{type:"string",allowEmpty:!0,global:!0},"aria-labelledby":{type:"idrefs",\
allowEmpty:!0,global:!0},"aria-level":{type:"int",minValue:1},"aria-live":{type:"nmtoken",values:["assertive","off","polite"],global:!0},"aria-modal":{type:"boolean"},"aria-multiline":{type:"boolean"},"aria-multiselectable":{type:"boolean"},"aria-orientation":{type:"nmtoken",values:["horizontal","undefined","vertical"]},"aria-owns":{type:"idrefs",allowEmpty:!0,global:!0},"aria-placeholder":{type:"string",allowEmpty:!0},"aria-posinset":{type:"int",minValue:1},"aria-pressed":{type:"nmtoken",values:["false","mixed","true","undefined"]},"aria-readonly":{type:"boolean"},"aria-relevant":{type:"nmtokens",values:["additions","all","removals","text"],global:!0},"aria-required":{type:"boolean"},"aria-roledescription":{type:"string",allowEmpty:!0,global:!0},"aria-rowcount":{type:"int",minValue:-1},"aria-rowindex":{type:"int",minValue:1},"aria-rowspan":{type:"int",minValue:0},"aria-selected":{type:"nmtoken",values:["false","true","undefined"]},"aria-setsize":{type:"int",minValue:-1},"aria-sort":{t\
ype:"nmtoken",values:["ascending","descending","none","other"]},"aria-valuemax":{type:"decimal"},"aria-valuemin":{type:"decimal"},"aria-valuenow":{type:"decimal"},"aria-valuetext":{type:"string",allowEmpty:!0}},iu={alert:{type:"widget",allowedAttrs:["aria-expanded"],superclassRole:["section"]},alertdialog:{type:"widget",allowedAttrs:["aria-expanded","aria-modal"],superclassRole:["alert","dialog"],accessibleNameRequired:!0},application:{type:"landmark",allowedAttrs:["aria-activedescendant","aria-expanded"],superclassRole:["structure"],accessibleNameRequired:!0},article:{type:"structure",allowedAttrs:["aria-posinset","aria-setsize","aria-expanded"],superclassRole:["document"]},banner:{type:"landmark",allowedAttrs:["aria-expanded"],superclassRole:["landmark"]},blockquote:{type:"structure",superclassRole:["section"]},button:{type:"widget",allowedAttrs:["aria-expanded","aria-pressed"],superclassRole:["command"],accessibleNameRequired:!0,nameFromContent:!0,childrenPresentational:!0},caption:\
{type:"structure",requiredContext:["figure","table","grid","treegrid"],superclassRole:["section"],prohibitedAttrs:["aria-label","aria-labelledby"]},cell:{type:"structure",requiredContext:["row"],allowedAttrs:["aria-colindex","aria-colspan","aria-rowindex","aria-rowspan","aria-expanded"],superclassRole:["section"],nameFromContent:!0},checkbox:{type:"widget",requiredAttrs:["aria-checked"],allowedAttrs:["aria-readonly","aria-expanded","aria-required"],superclassRole:["input"],accessibleNameRequired:!0,nameFromContent:!0,childrenPresentational:!0},code:{type:"structure",superclassRole:["section"],prohibitedAttrs:["aria-label","aria-labelledby"]},columnheader:{type:"structure",requiredContext:["row"],allowedAttrs:["aria-sort","aria-colindex","aria-colspan","aria-expanded","aria-readonly","aria-required","aria-rowindex","aria-rowspan","aria-selected"],superclassRole:["cell","gridcell","sectionhead"],accessibleNameRequired:!1,nameFromContent:!0},combobox:{type:"widget",requiredAttrs:["aria-ex\
panded","aria-controls"],allowedAttrs:["aria-owns","aria-autocomplete","aria-readonly","aria-required","aria-activedescendant","aria-orientation"],superclassRole:["select"],accessibleNameRequired:!0},command:{type:"abstract",superclassRole:["widget"]},complementary:{type:"landmark",allowedAttrs:["aria-expanded"],superclassRole:["landmark"]},composite:{type:"abstract",superclassRole:["widget"]},contentinfo:{type:"landmark",allowedAttrs:["aria-expanded"],superclassRole:["landmark"]},comment:{type:"structure",allowedAttrs:["aria-level","aria-posinset","aria-setsize"],superclassRole:["article"]},definition:{type:"structure",allowedAttrs:["aria-expanded"],superclassRole:["section"]},deletion:{type:"structure",superclassRole:["section"],prohibitedAttrs:["aria-label","aria-labelledby"]},dialog:{type:"widget",allowedAttrs:["aria-expanded","aria-modal"],superclassRole:["window"],accessibleNameRequired:!0},directory:{type:"structure",deprecated:!0,allowedAttrs:["aria-expanded"],superclassRole:["\
list"],nameFromContent:!0},document:{type:"structure",allowedAttrs:["aria-expanded"],superclassRole:["structure"]},emphasis:{type:"structure",superclassRole:["section"],prohibitedAttrs:["aria-label","aria-labelledby"]},feed:{type:"structure",requiredOwned:["article"],allowedAttrs:["aria-expanded"],superclassRole:["list"]},figure:{type:"structure",allowedAttrs:["aria-expanded"],superclassRole:["section"],nameFromContent:!0},form:{type:"landmark",allowedAttrs:["aria-expanded"],superclassRole:["landmark"]},grid:{type:"composite",requiredOwned:["rowgroup","row"],allowedAttrs:["aria-level","aria-multiselectable","aria-readonly","aria-activedescendant","aria-colcount","aria-expanded","aria-rowcount"],superclassRole:["composite","table"],accessibleNameRequired:!1},gridcell:{type:"widget",requiredContext:["row"],allowedAttrs:["aria-readonly","aria-required","aria-selected","aria-colindex","aria-colspan","aria-expanded","aria-rowindex","aria-rowspan"],superclassRole:["cell","widget"],nameFromCo\
ntent:!0},group:{type:"structure",allowedAttrs:["aria-activedescendant","aria-expanded"],superclassRole:["section"]},heading:{type:"structure",requiredAttrs:["aria-level"],allowedAttrs:["aria-expanded"],superclassRole:["sectionhead"],accessibleNameRequired:!1,nameFromContent:!0},img:{type:"structure",allowedAttrs:["aria-expanded"],superclassRole:["section"],accessibleNameRequired:!0,childrenPresentational:!0},input:{type:"abstract",superclassRole:["widget"]},insertion:{type:"structure",superclassRole:["section"],prohibitedAttrs:["aria-label","aria-labelledby"]},landmark:{type:"abstract",superclassRole:["section"]},link:{type:"widget",allowedAttrs:["aria-expanded"],superclassRole:["command"],accessibleNameRequired:!0,nameFromContent:!0},list:{type:"structure",requiredOwned:["listitem"],allowedAttrs:["aria-expanded"],superclassRole:["section"]},listbox:{type:"widget",requiredOwned:["group","option"],allowedAttrs:["aria-multiselectable","aria-readonly","aria-required","aria-activedescenda\
nt","aria-expanded","aria-orientation"],superclassRole:["select"],accessibleNameRequired:!0},listitem:{type:"structure",requiredContext:["list"],allowedAttrs:["aria-level","aria-posinset","aria-setsize","aria-expanded"],superclassRole:["section"],nameFromContent:!0},log:{type:"widget",allowedAttrs:["aria-expanded"],superclassRole:["section"]},main:{type:"landmark",allowedAttrs:["aria-expanded"],superclassRole:["landmark"]},marquee:{type:"widget",allowedAttrs:["aria-expanded"],superclassRole:["section"]},math:{type:"structure",allowedAttrs:["aria-expanded"],superclassRole:["section"],childrenPresentational:!0},menu:{type:"composite",requiredOwned:["group","menuitemradio","menuitem","menuitemcheckbox","menu","separator"],allowedAttrs:["aria-activedescendant","aria-expanded","aria-orientation"],superclassRole:["select"]},menubar:{type:"composite",requiredOwned:["group","menuitemradio","menuitem","menuitemcheckbox","menu","separator"],allowedAttrs:["aria-activedescendant","aria-expanded","\
aria-orientation"],superclassRole:["menu"]},menuitem:{type:"widget",requiredContext:["menu","menubar","group"],allowedAttrs:["aria-posinset","aria-setsize","aria-expanded"],superclassRole:["command"],accessibleNameRequired:!0,nameFromContent:!0},menuitemcheckbox:{type:"widget",requiredContext:["menu","menubar","group"],requiredAttrs:["aria-checked"],allowedAttrs:["aria-expanded","aria-posinset","aria-readonly","aria-setsize"],superclassRole:["checkbox","menuitem"],accessibleNameRequired:!0,nameFromContent:!0,childrenPresentational:!0},menuitemradio:{type:"widget",requiredContext:["menu","menubar","group"],requiredAttrs:["aria-checked"],allowedAttrs:["aria-expanded","aria-posinset","aria-readonly","aria-setsize"],superclassRole:["menuitemcheckbox","radio"],accessibleNameRequired:!0,nameFromContent:!0,childrenPresentational:!0},meter:{type:"structure",requiredAttrs:["aria-valuenow"],allowedAttrs:["aria-valuemax","aria-valuemin","aria-valuetext"],superclassRole:["range"],accessibleNameReq\
uired:!0,childrenPresentational:!0},mark:{type:"structure",superclassRole:["section"],prohibitedAttrs:["aria-label","aria-labelledby"]},navigation:{type:"landmark",allowedAttrs:["aria-expanded"],superclassRole:["landmark"]},none:{type:"structure",superclassRole:["structure"],prohibitedAttrs:["aria-label","aria-labelledby"]},note:{type:"structure",allowedAttrs:["aria-expanded"],superclassRole:["section"]},option:{type:"widget",requiredContext:["group","listbox"],allowedAttrs:["aria-selected","aria-checked","aria-posinset","aria-setsize"],superclassRole:["input"],accessibleNameRequired:!0,nameFromContent:!0,childrenPresentational:!0},paragraph:{type:"structure",superclassRole:["section"],prohibitedAttrs:["aria-label","aria-labelledby"]},presentation:{type:"structure",superclassRole:["structure"],prohibitedAttrs:["aria-label","aria-labelledby"]},progressbar:{type:"widget",allowedAttrs:["aria-expanded","aria-valuemax","aria-valuemin","aria-valuenow","aria-valuetext"],superclassRole:["range\
"],accessibleNameRequired:!0,childrenPresentational:!0},radio:{type:"widget",requiredAttrs:["aria-checked"],allowedAttrs:["aria-posinset","aria-setsize","aria-required"],superclassRole:["input"],accessibleNameRequired:!0,nameFromContent:!0,childrenPresentational:!0},radiogroup:{type:"composite",allowedAttrs:["aria-readonly","aria-required","aria-activedescendant","aria-expanded","aria-orientation"],superclassRole:["select"],accessibleNameRequired:!1},range:{type:"abstract",superclassRole:["widget"]},region:{type:"landmark",allowedAttrs:["aria-expanded"],superclassRole:["landmark"],accessibleNameRequired:!1},roletype:{type:"abstract",superclassRole:[]},row:{type:"structure",requiredContext:["grid","rowgroup","table","treegrid"],requiredOwned:["cell","columnheader","gridcell","rowheader"],allowedAttrs:["aria-colindex","aria-level","aria-rowindex","aria-selected","aria-activedescendant","aria-expanded","aria-posinset","aria-setsize"],superclassRole:["group","widget"],nameFromContent:!0},r\
owgroup:{type:"structure",requiredContext:["grid","table","treegrid"],requiredOwned:["row"],superclassRole:["structure"],nameFromContent:!0},rowheader:{type:"structure",requiredContext:["row"],allowedAttrs:["aria-sort","aria-colindex","aria-colspan","aria-expanded","aria-readonly","aria-required","aria-rowindex","aria-rowspan","aria-selected"],superclassRole:["cell","gridcell","sectionhead"],accessibleNameRequired:!1,nameFromContent:!0},scrollbar:{type:"widget",requiredAttrs:["aria-valuenow"],allowedAttrs:["aria-controls","aria-orientation","aria-valuemax","aria-valuemin","aria-valuetext"],superclassRole:["range"],childrenPresentational:!0},search:{type:"landmark",allowedAttrs:["aria-expanded"],superclassRole:["landmark"]},searchbox:{type:"widget",allowedAttrs:["aria-activedescendant","aria-autocomplete","aria-multiline","aria-placeholder","aria-readonly","aria-required"],superclassRole:["textbox"],accessibleNameRequired:!0},section:{type:"abstract",superclassRole:["structure"],nameFro\
mContent:!0},sectionhead:{type:"abstract",superclassRole:["structure"],nameFromContent:!0},select:{type:"abstract",superclassRole:["composite","group"]},separator:{type:"structure",requiredAttrs:["aria-valuenow"],allowedAttrs:["aria-valuemax","aria-valuemin","aria-orientation","aria-valuetext"],superclassRole:["structure","widget"],childrenPresentational:!0},slider:{type:"widget",requiredAttrs:["aria-valuenow"],allowedAttrs:["aria-valuemax","aria-valuemin","aria-orientation","aria-readonly","aria-required","aria-valuetext"],superclassRole:["input","range"],accessibleNameRequired:!0,childrenPresentational:!0},spinbutton:{type:"widget",allowedAttrs:["aria-valuemax","aria-valuemin","aria-readonly","aria-required","aria-activedescendant","aria-valuetext","aria-valuenow"],superclassRole:["composite","input","range"],accessibleNameRequired:!0},status:{type:"widget",allowedAttrs:["aria-expanded"],superclassRole:["section"]},strong:{type:"structure",superclassRole:["section"],prohibitedAttrs:[\
"aria-label","aria-labelledby"]},structure:{type:"abstract",superclassRole:["roletype"]},subscript:{type:"structure",superclassRole:["section"],prohibitedAttrs:["aria-label","aria-labelledby"]},superscript:{type:"structure",superclassRole:["section"],prohibitedAttrs:["aria-label","aria-labelledby"]},switch:{type:"widget",requiredAttrs:["aria-checked"],allowedAttrs:["aria-expanded","aria-readonly","aria-required"],superclassRole:["checkbox"],accessibleNameRequired:!0,nameFromContent:!0,childrenPresentational:!0},suggestion:{type:"structure",requiredOwned:["insertion","deletion"],superclassRole:["section"],prohibitedAttrs:["aria-label","aria-labelledby"]},tab:{type:"widget",requiredContext:["tablist"],allowedAttrs:["aria-posinset","aria-selected","aria-setsize","aria-expanded"],superclassRole:["sectionhead","widget"],nameFromContent:!0,childrenPresentational:!0},table:{type:"structure",requiredOwned:["rowgroup","row"],allowedAttrs:["aria-colcount","aria-rowcount","aria-expanded"],supercl\
assRole:["section"],accessibleNameRequired:!1,nameFromContent:!0},tablist:{type:"composite",requiredOwned:["tab"],allowedAttrs:["aria-level","aria-multiselectable","aria-orientation","aria-activedescendant","aria-expanded"],superclassRole:["composite"]},tabpanel:{type:"widget",allowedAttrs:["aria-expanded"],superclassRole:["section"],accessibleNameRequired:!1},term:{type:"structure",allowedAttrs:["aria-expanded"],superclassRole:["section"],nameFromContent:!0},text:{type:"structure",superclassRole:["section"],nameFromContent:!0},textbox:{type:"widget",allowedAttrs:["aria-activedescendant","aria-autocomplete","aria-multiline","aria-placeholder","aria-readonly","aria-required"],superclassRole:["input"],accessibleNameRequired:!0},time:{type:"structure",superclassRole:["section"]},timer:{type:"widget",allowedAttrs:["aria-expanded"],superclassRole:["status"]},toolbar:{type:"structure",allowedAttrs:["aria-orientation","aria-activedescendant","aria-expanded"],superclassRole:["group"],accessibl\
eNameRequired:!0},tooltip:{type:"structure",allowedAttrs:["aria-expanded"],superclassRole:["section"],nameFromContent:!0},tree:{type:"composite",requiredOwned:["group","treeitem"],allowedAttrs:["aria-multiselectable","aria-required","aria-activedescendant","aria-expanded","aria-orientation"],superclassRole:["select"],accessibleNameRequired:!1},treegrid:{type:"composite",requiredOwned:["rowgroup","row"],allowedAttrs:["aria-activedescendant","aria-colcount","aria-expanded","aria-level","aria-multiselectable","aria-orientation","aria-readonly","aria-required","aria-rowcount"],superclassRole:["grid","tree"],accessibleNameRequired:!1},treeitem:{type:"widget",requiredContext:["group","tree"],allowedAttrs:["aria-checked","aria-expanded","aria-level","aria-posinset","aria-selected","aria-setsize"],superclassRole:["listitem","option"],accessibleNameRequired:!0,nameFromContent:!0},widget:{type:"abstract",superclassRole:["roletype"]},window:{type:"abstract",superclassRole:["roletype"]}},uu={a:{va\
riant:{href:{matches:"[href]",contentTypes:["interactive","phrasing","flow"],allowedRoles:["button","checkbox","menuitem","menuitemcheckbox","menuitemradio","option","radio","switch","tab","treeitem","doc-backlink","doc-biblioref","doc-glossref","doc-noteref"],namingMethods:["subtreeText"]},default:{contentTypes:["phrasing","flow"],allowedRoles:!0}}},abbr:{contentTypes:["phrasing","flow"],allowedRoles:!0},address:{contentTypes:["flow"],allowedRoles:!0},area:{variant:{href:{matches:"[href]",allowedRoles:!1},default:{allowedRoles:["button","link"]}},contentTypes:["phrasing","flow"],namingMethods:["altText"]},article:{contentTypes:["sectioning","flow"],allowedRoles:["feed","presentation","none","document","application","main","region"],shadowRoot:!0},aside:{contentTypes:["sectioning","flow"],allowedRoles:["feed","note","presentation","none","region","search","doc-dedication","doc-example","doc-footnote","doc-glossary","doc-pullquote","doc-tip"]},audio:{variant:{controls:{matches:"[control\
s]",contentTypes:["interactive","embedded","phrasing","flow"]},default:{contentTypes:["embedded","phrasing","flow"]}},allowedRoles:["application"],chromiumRole:"Audio"},b:{contentTypes:["phrasing","flow"],allowedRoles:!0},base:{allowedRoles:!1,noAriaAttrs:!0},bdi:{contentTypes:["phrasing","flow"],allowedRoles:!0},bdo:{contentTypes:["phrasing","flow"],allowedRoles:!0},blockquote:{contentTypes:["flow"],allowedRoles:!0,shadowRoot:!0},body:{allowedRoles:!1,shadowRoot:!0},br:{contentTypes:["phrasing","flow"],allowedRoles:["presentation","none"],namingMethods:["titleText","singleSpace"]},button:{contentTypes:["interactive","phrasing","flow"],allowedRoles:["checkbox","combobox","link","menuitem","menuitemcheckbox","menuitemradio","option","radio","switch","tab"],namingMethods:["subtreeText"]},canvas:{allowedRoles:!0,contentTypes:["embedded","phrasing","flow"],chromiumRole:"Canvas"},caption:{allowedRoles:!1},cite:{contentTypes:["phrasing","flow"],allowedRoles:!0},code:{contentTypes:["phrasing"\
,"flow"],allowedRoles:!0},col:{allowedRoles:!1,noAriaAttrs:!0},colgroup:{allowedRoles:!1,noAriaAttrs:!0},data:{contentTypes:["phrasing","flow"],allowedRoles:!0},datalist:{contentTypes:["phrasing","flow"],allowedRoles:!1,noAriaAttrs:!0,implicitAttrs:{"aria-multiselectable":"false"}},dd:{allowedRoles:!1},del:{contentTypes:["phrasing","flow"],allowedRoles:!0},dfn:{contentTypes:["phrasing","flow"],allowedRoles:!0},details:{contentTypes:["interactive","flow"],allowedRoles:!1},dialog:{contentTypes:["flow"],allowedRoles:["alertdialog"]},div:{contentTypes:["flow"],allowedRoles:!0,shadowRoot:!0},dl:{contentTypes:["flow"],allowedRoles:["group","list","presentation","none"],chromiumRole:"DescriptionList"},dt:{allowedRoles:["listitem"]},em:{contentTypes:["phrasing","flow"],allowedRoles:!0},embed:{contentTypes:["interactive","embedded","phrasing","flow"],allowedRoles:["application","document","img","presentation","none"],chromiumRole:"EmbeddedObject"},fieldset:{contentTypes:["flow"],allowedRoles:["\
none","presentation","radiogroup"],namingMethods:["fieldsetLegendText"]},figcaption:{allowedRoles:["group","none","presentation"]},figure:{contentTypes:["flow"],allowedRoles:!0,namingMethods:["figureText","titleText"]},footer:{contentTypes:["flow"],allowedRoles:["group","none","presentation","doc-footnote"],shadowRoot:!0},form:{contentTypes:["flow"],allowedRoles:["search","none","presentation"]},h1:{contentTypes:["heading","flow"],allowedRoles:["none","presentation","tab","doc-subtitle"],shadowRoot:!0,implicitAttrs:{"aria-level":"1"}},h2:{contentTypes:["heading","flow"],allowedRoles:["none","presentation","tab","doc-subtitle"],shadowRoot:!0,implicitAttrs:{"aria-level":"2"}},h3:{contentTypes:["heading","flow"],allowedRoles:["none","presentation","tab","doc-subtitle"],shadowRoot:!0,implicitAttrs:{"aria-level":"3"}},h4:{contentTypes:["heading","flow"],allowedRoles:["none","presentation","tab","doc-subtitle"],shadowRoot:!0,implicitAttrs:{"aria-level":"4"}},h5:{contentTypes:["heading","flow\
"],allowedRoles:["none","presentation","tab","doc-subtitle"],shadowRoot:!0,implicitAttrs:{"aria-level":"5"}},h6:{contentTypes:["heading","flow"],allowedRoles:["none","presentation","tab","doc-subtitle"],shadowRoot:!0,implicitAttrs:{"aria-level":"6"}},head:{allowedRoles:!1,noAriaAttrs:!0},header:{contentTypes:["flow"],allowedRoles:["group","none","presentation","doc-footnote"],shadowRoot:!0},hgroup:{contentTypes:["heading","flow"],allowedRoles:!0},hr:{contentTypes:["flow"],allowedRoles:["none","presentation","doc-pagebreak"],namingMethods:["titleText","singleSpace"]},html:{allowedRoles:!1,noAriaAttrs:!0},i:{contentTypes:["phrasing","flow"],allowedRoles:!0},iframe:{contentTypes:["interactive","embedded","phrasing","flow"],allowedRoles:["application","document","img","none","presentation"],chromiumRole:"Iframe"},img:{variant:{nonEmptyAlt:{matches:[{attributes:{alt:"/.+/"}},{hasAccessibleName:!0}],allowedRoles:["button","checkbox","link","menuitem","menuitemcheckbox","menuitemradio","meter\
","option","progressbar","radio","scrollbar","separator","slider","switch","tab","treeitem","doc-cover"]},usemap:{matches:"[usemap]",contentTypes:["interactive","embedded","flow"]},default:{allowedRoles:["presentation","none"],contentTypes:["embedded","flow"]}},namingMethods:["altText"]},input:{variant:{button:{matches:{properties:{type:"button"}},allowedRoles:["checkbox","combobox","link","menuitem","menuitemcheckbox","menuitemradio","option","radio","switch","tab"]},buttonType:{matches:{properties:{type:["button","submit","reset"]}},namingMethods:["valueText","titleText","buttonDefaultText"]},checkboxPressed:{matches:{properties:{type:"checkbox"},attributes:{"aria-pressed":"/.*/"}},allowedRoles:["button","menuitemcheckbox","option","switch"],implicitAttrs:{"aria-checked":"false"}},checkbox:{matches:{properties:{type:"checkbox"},attributes:{"aria-pressed":null}},allowedRoles:["menuitemcheckbox","option","switch"],implicitAttrs:{"aria-checked":"false"}},noRoles:{matches:{properties:{ty\
pe:["color","date","datetime-local","file","month","number","password","range","reset","submit","time","week"]}},allowedRoles:!1},hidden:{matches:{properties:{type:"hidden"}},contentTypes:["flow"],allowedRoles:!1,noAriaAttrs:!0},image:{matches:{properties:{type:"image"}},allowedRoles:["link","menuitem","menuitemcheckbox","menuitemradio","radio","switch"],namingMethods:["altText","valueText","labelText","titleText","buttonDefaultText"]},radio:{matches:{properties:{type:"radio"}},allowedRoles:["menuitemradio"],implicitAttrs:{"aria-checked":"false"}},textWithList:{matches:{properties:{type:"text"},attributes:{list:"/.*/"}},allowedRoles:!1},default:{contentTypes:["interactive","flow"],allowedRoles:["combobox","searchbox","spinbutton"],implicitAttrs:{"aria-valuenow":""},namingMethods:["labelText","placeholderText"]}}},ins:{contentTypes:["phrasing","flow"],allowedRoles:!0},kbd:{contentTypes:["phrasing","flow"],allowedRoles:!0},label:{contentTypes:["interactive","phrasing","flow"],allowedRole\
s:!1,chromiumRole:"Label"},legend:{allowedRoles:!1},li:{allowedRoles:["menuitem","menuitemcheckbox","menuitemradio","option","none","presentation","radio","separator","tab","treeitem","doc-biblioentry","doc-endnote"],implicitAttrs:{"aria-setsize":"1","aria-posinset":"1"}},link:{contentTypes:["phrasing","flow"],allowedRoles:!1,noAriaAttrs:!0},main:{contentTypes:["flow"],allowedRoles:!1,shadowRoot:!0},map:{contentTypes:["phrasing","flow"],allowedRoles:!1,noAriaAttrs:!0},math:{contentTypes:["embedded","phrasing","flow"],allowedRoles:!1},mark:{contentTypes:["phrasing","flow"],allowedRoles:!0},menu:{contentTypes:["flow"],allowedRoles:["directory","group","listbox","menu","menubar","none","presentation","radiogroup","tablist","toolbar","tree"]},meta:{variant:{itemprop:{matches:"[itemprop]",contentTypes:["phrasing","flow"]}},allowedRoles:!1,noAriaAttrs:!0},meter:{contentTypes:["phrasing","flow"],allowedRoles:!1,chromiumRole:"progressbar"},nav:{contentTypes:["sectioning","flow"],allowedRoles:[\
"doc-index","doc-pagelist","doc-toc","menu","menubar","none","presentation","tablist"],shadowRoot:!0},noscript:{contentTypes:["phrasing","flow"],allowedRoles:!1,noAriaAttrs:!0},object:{variant:{usemap:{matches:"[usemap]",contentTypes:["interactive","embedded","phrasing","flow"]},default:{contentTypes:["embedded","phrasing","flow"]}},allowedRoles:["application","document","img"],chromiumRole:"PluginObject"},ol:{contentTypes:["flow"],allowedRoles:["directory","group","listbox","menu","menubar","none","presentation","radiogroup","tablist","toolbar","tree"]},optgroup:{allowedRoles:!1},option:{allowedRoles:!1,implicitAttrs:{"aria-selected":"false"}},output:{contentTypes:["phrasing","flow"],allowedRoles:!0,namingMethods:["subtreeText"]},p:{contentTypes:["flow"],allowedRoles:!0,shadowRoot:!0},param:{allowedRoles:!1,noAriaAttrs:!0},picture:{contentTypes:["phrasing","flow"],allowedRoles:!1,noAriaAttrs:!0},pre:{contentTypes:["flow"],allowedRoles:!0},progress:{contentTypes:["phrasing","flow"],all\
owedRoles:!1,implicitAttrs:{"aria-valuemax":"100","aria-valuemin":"0","aria-valuenow":"0"}},q:{contentTypes:["phrasing","flow"],allowedRoles:!0},rp:{allowedRoles:!0},rt:{allowedRoles:!0},ruby:{contentTypes:["phrasing","flow"],allowedRoles:!0},s:{contentTypes:["phrasing","flow"],allowedRoles:!0},samp:{contentTypes:["phrasing","flow"],allowedRoles:!0},script:{contentTypes:["phrasing","flow"],allowedRoles:!1,noAriaAttrs:!0},search:{contentTypes:["flow"],allowedRoles:["form","group","none","presentation","region","search"]},section:{contentTypes:["sectioning","flow"],allowedRoles:["alert","alertdialog","application","banner","complementary","contentinfo","dialog","document","feed","group","log","main","marquee","navigation","none","note","presentation","search","status","tabpanel","doc-abstract","doc-acknowledgments","doc-afterword","doc-appendix","doc-bibliography","doc-chapter","doc-colophon","doc-conclusion","doc-credit","doc-credits","doc-dedication","doc-endnotes","doc-epigraph","doc-\
epilogue","doc-errata","doc-example","doc-foreword","doc-glossary","doc-index","doc-introduction","doc-notice","doc-pagelist","doc-part","doc-preface","doc-prologue","doc-pullquote","doc-qna","doc-toc"],shadowRoot:!0},select:{variant:{combobox:{matches:{attributes:{multiple:null,size:[null,"1"]}},allowedRoles:["menu"]},default:{allowedRoles:!1}},contentTypes:["interactive","phrasing","flow"],implicitAttrs:{"aria-valuenow":""},namingMethods:["labelText"]},slot:{contentTypes:["phrasing","flow"],allowedRoles:!1,noAriaAttrs:!0},small:{contentTypes:["phrasing","flow"],allowedRoles:!0},source:{allowedRoles:!1,noAriaAttrs:!0},span:{contentTypes:["phrasing","flow"],allowedRoles:!0,shadowRoot:!0},strong:{contentTypes:["phrasing","flow"],allowedRoles:!0},style:{allowedRoles:!1,noAriaAttrs:!0},svg:{contentTypes:["embedded","phrasing","flow"],allowedRoles:!0,chromiumRole:"SVGRoot",namingMethods:["svgTitleText"]},sub:{contentTypes:["phrasing","flow"],allowedRoles:!0},summary:{allowedRoles:!1,naming\
Methods:["subtreeText"]},sup:{contentTypes:["phrasing","flow"],allowedRoles:!0},table:{contentTypes:["flow"],allowedRoles:!0,namingMethods:["tableCaptionText","tableSummaryText"]},tbody:{allowedRoles:!0},template:{contentTypes:["phrasing","flow"],allowedRoles:!1,noAriaAttrs:!0},textarea:{contentTypes:["interactive","phrasing","flow"],allowedRoles:!1,implicitAttrs:{"aria-valuenow":"","aria-multiline":"true"},namingMethods:["labelText","placeholderText"]},tfoot:{allowedRoles:!0},thead:{allowedRoles:!0},time:{contentTypes:["phrasing","flow"],allowedRoles:!0},title:{allowedRoles:!1,noAriaAttrs:!0},td:{allowedRoles:!0},th:{allowedRoles:!0},tr:{allowedRoles:!0},track:{allowedRoles:!1,noAriaAttrs:!0},u:{contentTypes:["phrasing","flow"],allowedRoles:!0},ul:{contentTypes:["flow"],allowedRoles:["directory","group","listbox","menu","menubar","none","presentation","radiogroup","tablist","toolbar","tree"]},var:{contentTypes:["phrasing","flow"],allowedRoles:!0},video:{variant:{controls:{matches:"[co\
ntrols]",contentTypes:["interactive","embedded","phrasing","flow"]},default:{contentTypes:["embedded","phrasing","flow"]}},allowedRoles:["application"],chromiumRole:"video"},wbr:{contentTypes:["phrasing","flow"],allowedRoles:["presentation","none"]}},lu={aliceblue:[240,248,255],antiquewhite:[250,235,215],aqua:[0,255,255],aquamarine:[127,255,212],azure:[240,255,255],beige:[245,245,220],bisque:[255,228,196],black:[0,0,0],blanchedalmond:[255,235,205],blue:[0,0,255],blueviolet:[138,43,226],brown:[165,42,42],burlywood:[222,184,135],cadetblue:[95,158,160],chartreuse:[127,255,0],chocolate:[210,105,30],coral:[255,127,80],cornflowerblue:[100,149,237],cornsilk:[255,248,220],crimson:[220,20,60],cyan:[0,255,255],darkblue:[0,0,139],darkcyan:[0,139,139],darkgoldenrod:[184,134,11],darkgray:[169,169,169],darkgreen:[0,100,0],darkgrey:[169,169,169],darkkhaki:[189,183,107],darkmagenta:[139,0,139],darkolivegreen:[85,107,47],darkorange:[255,140,0],darkorchid:[153,50,204],darkred:[139,0,0],darksalmon:[233,1\
50,122],darkseagreen:[143,188,143],darkslateblue:[72,61,139],darkslategray:[47,79,79],darkslategrey:[47,79,79],darkturquoise:[0,206,209],darkviolet:[148,0,211],deeppink:[255,20,147],deepskyblue:[0,191,255],dimgray:[105,105,105],dimgrey:[105,105,105],dodgerblue:[30,144,255],firebrick:[178,34,34],floralwhite:[255,250,240],forestgreen:[34,139,34],fuchsia:[255,0,255],gainsboro:[220,220,220],ghostwhite:[248,248,255],gold:[255,215,0],goldenrod:[218,165,32],gray:[128,128,128],green:[0,128,0],greenyellow:[173,255,47],grey:[128,128,128],honeydew:[240,255,240],hotpink:[255,105,180],indianred:[205,92,92],indigo:[75,0,130],ivory:[255,255,240],khaki:[240,230,140],lavender:[230,230,250],lavenderblush:[255,240,245],lawngreen:[124,252,0],lemonchiffon:[255,250,205],lightblue:[173,216,230],lightcoral:[240,128,128],lightcyan:[224,255,255],lightgoldenrodyellow:[250,250,210],lightgray:[211,211,211],lightgreen:[144,238,144],lightgrey:[211,211,211],lightpink:[255,182,193],lightsalmon:[255,160,122],lightseagr\
een:[32,178,170],lightskyblue:[135,206,250],lightslategray:[119,136,153],lightslategrey:[119,136,153],lightsteelblue:[176,196,222],lightyellow:[255,255,224],lime:[0,255,0],limegreen:[50,205,50],linen:[250,240,230],magenta:[255,0,255],maroon:[128,0,0],mediumaquamarine:[102,205,170],mediumblue:[0,0,205],mediumorchid:[186,85,211],mediumpurple:[147,112,219],mediumseagreen:[60,179,113],mediumslateblue:[123,104,238],mediumspringgreen:[0,250,154],mediumturquoise:[72,209,204],mediumvioletred:[199,21,133],midnightblue:[25,25,112],mintcream:[245,255,250],mistyrose:[255,228,225],moccasin:[255,228,181],navajowhite:[255,222,173],navy:[0,0,128],oldlace:[253,245,230],olive:[128,128,0],olivedrab:[107,142,35],orange:[255,165,0],orangered:[255,69,0],orchid:[218,112,214],palegoldenrod:[238,232,170],palegreen:[152,251,152],paleturquoise:[175,238,238],palevioletred:[219,112,147],papayawhip:[255,239,213],peachpuff:[255,218,185],peru:[205,133,63],pink:[255,192,203],plum:[221,160,221],powderblue:[176,224,230]\
,purple:[128,0,128],rebeccapurple:[102,51,153],red:[255,0,0],rosybrown:[188,143,143],royalblue:[65,105,225],saddlebrown:[139,69,19],salmon:[250,128,114],sandybrown:[244,164,96],seagreen:[46,139,87],seashell:[255,245,238],sienna:[160,82,45],silver:[192,192,192],skyblue:[135,206,235],slateblue:[106,90,205],slategray:[112,128,144],slategrey:[112,128,144],snow:[255,250,250],springgreen:[0,255,127],steelblue:[70,130,180],tan:[210,180,140],teal:[0,128,128],thistle:[216,191,216],tomato:[255,99,71],turquoise:[64,224,208],violet:[238,130,238],wheat:[245,222,179],white:[255,255,255],whitesmoke:[245,245,245],yellow:[255,255,0],yellowgreen:[154,205,50]},su={ariaAttrs:ou,ariaRoles:$({},iu,{"doc-abstract":{type:"section",allowedAttrs:["aria-expanded"],superclassRole:["section"]},"doc-acknowledgments":{type:"landmark",allowedAttrs:["aria-expanded"],superclassRole:["landmark"]},"doc-afterword":{type:"landmark",allowedAttrs:["aria-expanded"],superclassRole:["landmark"]},"doc-appendix":{type:"landmark",\
allowedAttrs:["aria-expanded"],superclassRole:["landmark"]},"doc-backlink":{type:"link",allowedAttrs:["aria-expanded"],nameFromContent:!0,superclassRole:["link"]},"doc-biblioentry":{type:"listitem",allowedAttrs:["aria-expanded","aria-level","aria-posinset","aria-setsize"],superclassRole:["listitem"],deprecated:!0},"doc-bibliography":{type:"landmark",allowedAttrs:["aria-expanded"],superclassRole:["landmark"]},"doc-biblioref":{type:"link",allowedAttrs:["aria-expanded"],nameFromContent:!0,superclassRole:["link"]},"doc-chapter":{type:"landmark",allowedAttrs:["aria-expanded"],superclassRole:["landmark"]},"doc-colophon":{type:"section",allowedAttrs:["aria-expanded"],superclassRole:["section"]},"doc-conclusion":{type:"landmark",allowedAttrs:["aria-expanded"],superclassRole:["landmark"]},"doc-cover":{type:"img",allowedAttrs:["aria-expanded"],superclassRole:["img"]},"doc-credit":{type:"section",allowedAttrs:["aria-expanded"],superclassRole:["section"]},"doc-credits":{type:"landmark",allowedAttr\
s:["aria-expanded"],superclassRole:["landmark"]},"doc-dedication":{type:"section",allowedAttrs:["aria-expanded"],superclassRole:["section"]},"doc-endnote":{type:"listitem",allowedAttrs:["aria-expanded","aria-level","aria-posinset","aria-setsize"],superclassRole:["listitem"],deprecated:!0},"doc-endnotes":{type:"landmark",allowedAttrs:["aria-expanded"],superclassRole:["landmark"]},"doc-epigraph":{type:"section",allowedAttrs:["aria-expanded"],superclassRole:["section"]},"doc-epilogue":{type:"landmark",allowedAttrs:["aria-expanded"],superclassRole:["landmark"]},"doc-errata":{type:"landmark",allowedAttrs:["aria-expanded"],superclassRole:["landmark"]},"doc-example":{type:"section",allowedAttrs:["aria-expanded"],superclassRole:["section"]},"doc-footnote":{type:"section",allowedAttrs:["aria-expanded"],superclassRole:["section"]},"doc-foreword":{type:"landmark",allowedAttrs:["aria-expanded"],superclassRole:["landmark"]},"doc-glossary":{type:"landmark",allowedAttrs:["aria-expanded"],superclassRo\
le:["landmark"]},"doc-glossref":{type:"link",allowedAttrs:["aria-expanded"],nameFromContent:!0,superclassRole:["link"]},"doc-index":{type:"navigation",allowedAttrs:["aria-expanded"],superclassRole:["navigation"]},"doc-introduction":{type:"landmark",allowedAttrs:["aria-expanded"],superclassRole:["landmark"]},"doc-noteref":{type:"link",allowedAttrs:["aria-expanded"],nameFromContent:!0,superclassRole:["link"]},"doc-notice":{type:"note",allowedAttrs:["aria-expanded"],superclassRole:["note"]},"doc-pagebreak":{type:"separator",allowedAttrs:["aria-expanded","aria-orientation"],superclassRole:["separator"],childrenPresentational:!0},"doc-pagelist":{type:"navigation",allowedAttrs:["aria-expanded"],superclassRole:["navigation"]},"doc-part":{type:"landmark",allowedAttrs:["aria-expanded"],superclassRole:["landmark"]},"doc-preface":{type:"landmark",allowedAttrs:["aria-expanded"],superclassRole:["landmark"]},"doc-prologue":{type:"landmark",allowedAttrs:["aria-expanded"],superclassRole:["landmark"]},\
"doc-pullquote":{type:"none",superclassRole:["none"]},"doc-qna":{type:"section",allowedAttrs:["aria-expanded"],superclassRole:["section"]},"doc-subtitle":{type:"sectionhead",allowedAttrs:["aria-expanded"],superclassRole:["sectionhead"]},"doc-tip":{type:"note",allowedAttrs:["aria-expanded"],superclassRole:["note"]},"doc-toc":{type:"navigation",allowedAttrs:["aria-expanded"],superclassRole:["navigation"]}},{"graphics-document":{type:"structure",superclassRole:["document"],accessibleNameRequired:!0},"graphics-object":{type:"structure",superclassRole:["group"],nameFromContent:!0},"graphics-symbol":{type:"structure",superclassRole:["img"],accessibleNameRequired:!0,childrenPresentational:!0}}),htmlElms:uu,cssColors:lu},cu=$({},su),du=cu,pu=function(e){return!!(e=du.ariaRoles[e])&&!!e.unsupported},fu=function(e){var t=(n=1<arguments.length&&void 0!==arguments[1]?arguments[1]:{}).allowAbstract,n=void 0!==(n=n.flagUnsupported)&&n,r=du.ariaRoles[e],a=pu(e);return!(!r||n&&a||!t&&"abstract"===r.ty\
pe)},mu=function(e){var t=1<arguments.length&&void 0!==arguments[1]?arguments[1]:{},n=t.fallback,r=t.abstracts,a=t.dpub;return 1===(e=e instanceof vr?e:ca(e)).props.nodeType&&(t=(e.attr("role")||"").trim().toLowerCase(),(n?sp(t):[t]).find((function(e){return!(!a&&"doc-"===e.substr(0,4))&&fu(e,{allowAbstract:r})})))||null},Du=function(e){return Object.keys(du.htmlElms).filter((function(t){return(t=du.htmlElms[t]).contentTypes?t.contentTypes.includes(e):!!t.variant&&!(!t.variant.default||!t.variant.default.contentTypes)&&t.variant.default.contentTypes.includes(e)}))},hu=function(){return sa.get("globalAriaAttrs",(function(){return Object.keys(du.ariaAttrs).filter((function(e){return du.ariaAttrs[e].global}))}))},gu=$r((function(e){for(var t=[],n=e.rows,r=0,a=n.length;r<a;r++)for(var o=n[r].cells,i=(t[r]=t[r]||[],0),u=0,l=o.length;u<l;u++)for(var s=0;s<o[u].colSpan;s++){for(var c=o[u].getAttribute("rowspan"),d=0===parseInt(c)||0===o[u].rowspan?n.length:o[u].rowSpan,p=0;p<d;p++){for(t[r+p]\
=t[r+p]||[];t[r+p][i];)i++;t[r+p][i]=o[u]}i++}return t})),bu=$r((function(e,t){var n,r;for(t=t||gu(Ro(e,"table")),n=0;n<t.length;n++)if(t[n]&&-1!==(r=t[n].indexOf(e)))return{x:r,y:n}}));function vu(e){var t,n=(e=nf(e)).vNode,r=(e=e.domNode,n.attr("scope")),a=n.attr("role");if(["td","th"].includes(n.props.nodeName))return"columnheader"===a?"col":"rowheader"===a?"row":"col"===r||"row"===r?r:"th"===n.props.nodeName&&(n.actualNode?(a=gu(Ro(e,"table")))[(t=bu(e,a)).y].every((function(e){return"TH"===e.nodeName.toUpperCase()}))?"col":a.map((function(e){return e[t.x]})).every((function(e){return e&&"TH"===e.nodeName.toUpperCase()}))?"row":"auto":"auto");throw new TypeError("Expected TD or TH element")}var yu=function(e){return-1!==["col","auto"].indexOf(vu(e))},Fu=function(e){return["row","auto"].includes(vu(e))};function wu(){return sa.get("sectioningElementSelector",(function(){return Du("sectioning").map((function(e){return"".concat(e,":not([role])")})).join(", ")+" , main:not([role]), [ro\
le=article], [role=complementary], [role=main], [role=navigation], [role=region]"}))}var Eu=function(e){return e?e.replace(/\\r\\n/g,"\\n").replace(/\\u00A0/g," ").replace(/[\\s]{2,}/g," ").trim():""};function Cu(e){var t=Eu(ru(e));e=Eu(au(e));return t||e}var xu={a:function(e){return e.hasAttr("href")?"link":null},area:function(e){return e.hasAttr("href")?"link":null},article:"article",aside:"complementary",body:"document",button:"button",datalist:"listbox",dd:"definition",dfn:"term",details:"group",dialog:"dialog",dt:"term",fieldset:"group",figure:"figure",footer:function(e){return xa(e,wu())?null:"contentinfo"},form:function(e){return Cu(e)?"form":null},h1:"heading",h2:"heading",h3:"heading",h4:"heading",h5:"heading",h6:"heading",header:function(e){return xa(e,wu())?null:"banner"},hr:"separator",img:function(e){var t=e.hasAttr("alt")&&!e.attr("alt"),n=hu().find((function(t){return e.hasAttr(t)}));return!t||n||Xi(e)?"img":"presentation"},input:function(e){var t,n;switch(e.hasAttr("list")&&\
(n=(t=tu(e.actualNode,"list").filter((function(e){return!!e}))[0])&&"datalist"===t.nodeName.toLowerCase()),e.props.type){case"checkbox":return"checkbox";case"number":return"spinbutton";case"radio":return"radio";case"range":return"slider";case"search":return n?"combobox":"searchbox";case"button":case"image":case"reset":case"submit":return"button";case"text":case"tel":case"url":case"email":case"":return n?"combobox":"textbox";default:return"textbox"}},li:"listitem",main:"main",math:"math",menu:"list",nav:"navigation",ol:"list",optgroup:"group",option:"option",output:"status",progress:"progressbar",search:"search",section:function(e){return Cu(e)?"region":null},select:function(e){return e.hasAttr("multiple")||1<parseInt(e.attr("size"))?"listbox":"combobox"},summary:"button",table:"table",tbody:"rowgroup",td:function(e){return e=xa(e,"table"),e=mu(e),["grid","treegrid"].includes(e)?"gridcell":"cell"},textarea:"textbox",tfoot:"rowgroup",th:function(e){return yu(e)?"columnheader":Fu(e)?"rowh\
eader":void 0},thead:"rowgroup",tr:"row",ul:"list"},Au=function(e,t){var n=a(t);if(Array.isArray(t)&&void 0!==e)return t.includes(e);if("function"===n)return!!t(e);if(null!=e){if(t instanceof RegExp)return t.test(e);if(/^\\/.*\\/$/.test(t))return n=t.substring(1,t.length-1),new RegExp(n).test(e)}return t===e};function ku(e,t){return Au(!!wl(e),t)}var Nu=function(e,t){if("object"!==a(t)||Array.isArray(t)||t instanceof RegExp)throw new Error("Expect matcher to be an object");return Object.keys(t).every((function(n){return Au(e(n),t[n])}))};function Bu(e,t){return e=nf(e).vNode,Nu((function(t){return e.attr(t)}),t)}function Tu(e,t){return!!t(e)}function Ru(e,t){return Au(mu(e),t)}function _u(e,t){return Au(zu(e),t)}function Ou(e,t){return e=nf(e).vNode,Au(e.props.nodeName,t)}function Su(e,t){return e=nf(e).vNode,Nu((function(t){return e.props[t]}),t)}function Mu(e,t){return Au(Hu(e),t)}var Pu={hasAccessibleName:ku,attributes:Bu,condition:Tu,explicitRole:Ru,implicitRole:_u,nodeName:Ou,proper\
ties:Su,semanticRole:Mu},Iu=function e(t,n){return t=nf(t).vNode,Array.isArray(n)?n.some((function(n){return e(t,n)})):"string"==typeof n?ga(t,n):Object.keys(n).every((function(e){var r;if(Pu[e])return r=n[e],(0,Pu[e])(t,r);throw new Error('Unknown matcher type "'.concat(e,'"'))}))},ju=function(e,t){return Iu(e,t)},Lu=(ju.hasAccessibleName=ku,ju.attributes=Bu,ju.condition=Tu,ju.explicitRole=Ru,ju.fromDefinition=Iu,ju.fromFunction=Nu,ju.fromPrimative=Au,ju.implicitRole=_u,ju.nodeName=Ou,ju.properties=Su,ju.semanticRole=Mu,ju),qu=function(e){var t=(1<arguments.length&&void 0!==arguments[1]?arguments[1]:{}).noMatchAccessibleName,n=void 0!==t&&t,r=du.htmlElms[e.props.nodeName];if(!r)return{};if(!r.variant)return r;var a,o,i=r.variant,u=q(r,c);for(a in i)if(i.hasOwnProperty(a)&&"default"!==a){for(var l=i[a],s=l.matches,p=q(l,d),f=Array.isArray(s)?s:[s],m=0;m<f.length&&n;m++)if(f[m].hasOwnProperty("hasAccessibleName"))return r;if(Lu(e,s))for(var D in p)p.hasOwnProperty(D)&&(u[D]=p[D])}for(o \
in i.default)i.default.hasOwnProperty(o)&&void 0===u[o]&&(u[o]=i.default[o]);return u},zu=function(e){var t,n=(1<arguments.length&&void 0!==arguments[1]?arguments[1]:{}).chromium,r=e instanceof vr?e:ca(e);if(e=r.actualNode,r)return t=r.props.nodeName,!(t=xu[t])&&n?qu(r).chromiumRole||null:"function"==typeof t?t(r):t||null;throw new ReferenceError("Cannot get implicit role of a node outside the current scope.")},Vu={td:["tr"],th:["tr"],tr:["thead","tbody","tfoot","table"],thead:["table"],tbody:["table"],tfoot:["table"],li:["ol","ul"],dt:["dl","div"],dd:["dl","div"],div:["dl"]};function $u(e){return hu().some((function(t){return e.hasAttr(t)}))||Xi(e)}var Hu=function(e){var t=(n=1<arguments.length&&void 0!==arguments[1]?arguments[1]:{}).noPresentational,n=function(e,t){var n,r=(a=1<arguments.length&&void 0!==t?t:{}).noImplicit,a=q(a,f),o=nf(e).vNode;return 1!==o.props.nodeType?null:!(n=mu(o,a))||["presentation","none"].includes(n)&&$u(o)?r?null:function(e,t){var n=t.chromium;return t=q(t\
,p),(n=zu(e,{chromium:n}))?function e(t,n){var r=Vu[t.props.nodeName];if(r){if(t.parent)return r.includes(t.parent.props.nodeName)?(r=mu(t.parent,n),["none","presentation"].includes(r)&&!$u(t.parent)?r:r?null:e(t.parent,n)):null;if(t.actualNode)throw new ReferenceError("Cannot determine role presentational inheritance of a required parent outside the current scope.")}return null}(e,t)||n:null}(o,a):n}(e,q(n,m));return t&&["presentation","none"].includes(n)?null:n},Uu=["iframe"],Gu=function(e){var t=nf(e).vNode;return 1!==t.props.nodeType||!e.hasAttr("title")||!ju(t,Uu)&&["none","presentation"].includes(Hu(t))?"":t.attr("title")},Wu=function(e){var t,n,r=(1<arguments.length&&void 0!==arguments[1]?arguments[1]:{}).strict;return 1===(e=e instanceof vr?e:ca(e)).props.nodeType&&(t=Hu(e),!(!(n=du.ariaRoles[t])||!n.nameFromContent)||!r&&(!n||["presentation","none"].includes(t)))},Yu=function(e){var t=e.actualNode,n=e.children;if(n)return e.hasAttr("aria-owns")?(e=tu(t,"aria-owns").filter((fun\
ction(e){return!!e})).map((function(e){return o.utils.getNodeFromTree(e)})),[].concat(z(n),z(e))):z(n);throw new Error("getOwnedVirtual requires a virtual node")},Ku={accessibleNameFromFieldValue:["progressbar"]};function Xu(e){return e=nf(e).vNode,Zu(e)}var Zu=$r((function(e,t){return!zo(e)&&!Mi(e,{skipAncestors:!0,isAncestor:t})&&(e.actualNode&&"area"===e.props.nodeName?!Go(e,Zu):!Ko(e,{skipAncestors:!0,isAncestor:t})&&(!e.parent||Zu(e.parent,!0)))})),Ju=function e(t,n,r){var a=nf(t).vNode,o=n?Xu:ai,i=!t.actualNode||t.actualNode&&o(t);o=a.children.map((function(t){var a=(o=t.props).nodeType,o=o.nodeValue;if(3===a){if(o&&i)return o}else if(!r)return e(t,n)})).join("");return Eu(o)},Qu=["button","checkbox","color","file","hidden","image","password","radio","reset","submit"],el=function(e){var t=(e=e instanceof vr?e:ca(e)).props.nodeName;return"textarea"===t||"input"===t&&!Qu.includes((e.attr("type")||"").toLowerCase())},tl=function(e){return"select"===(e=e instanceof vr?e:ca(e)).props.\
nodeName},nl=function(e){return"textbox"===mu(e)},rl=function(e){return"listbox"===mu(e)},al=function(e){return"combobox"===mu(e)},ol=["progressbar","scrollbar","slider","spinbutton"],il=function(e){return e=mu(e),ol.includes(e)},ul=["textbox","progressbar","scrollbar","slider","spinbutton","combobox","listbox"],ll={nativeTextboxValue:function(e){return e=nf(e).vNode,el(e)&&e.props.value||""},nativeSelectValue:function(e){if(e=nf(e).vNode,!tl(e))return"";var t=(e=Cf(e,"option")).filter((function(e){return e.props.selected}));return t.length||t.push(e[0]),t.map((function(e){return Ju(e)})).join(" ")||""},ariaTextboxValue:function(e){var t=(e=nf(e)).vNode;e=e.domNode;return nl(t)?e&&Ko(e)?e.textContent:Ju(t,!0):""},ariaListboxValue:sl,ariaComboboxValue:function(e,t){e=nf(e).vNode;return al(e)&&(e=Yu(e).filter((function(e){return"listbox"===Hu(e)}))[0])?sl(e,t):""},ariaRangeValue:function(e){e=nf(e).vNode;return il(e)&&e.hasAttr("aria-valuenow")?(e=+e.attr("aria-valuenow"),isNaN(e)?"0":St\
ring(e)):""}};function sl(e,t){e=nf(e).vNode;return rl(e)&&0!==(e=Yu(e).filter((function(e){return"option"===Hu(e)&&"true"===e.attr("aria-selected")}))).length?wl(e[0],t):""}var cl=function(e){var t=1<arguments.length&&void 0!==arguments[1]?arguments[1]:{},n=e.actualNode,r=Ku.accessibleNameFromFieldValue||[],a=Hu(e);return t.startNode===e||!ul.includes(a)||r.includes(a)?"":(r=Object.keys(ll).map((function(e){return ll[e]})).reduce((function(n,r){return n||r(e,t)}),""),t.debug&&hr(r||"{empty-value}",n,t),r)},dl=Du("phrasing").concat(["#text"]),pl=function(e){var t=1<arguments.length&&void 0!==arguments[1]?arguments[1]:{},n=wl.alreadyProcessed;t.startNode=t.startNode||e;var r=(o=t).strict,a=o.inControlContext,o=o.inLabelledByContext,i=Hu(e),u=qu(e,{noMatchAccessibleName:!0}).contentTypes;return n(e,t)||1!==e.props.nodeType||null!=u&&u.includes("embedded")||ul.includes(i)||!(t.subtreeDescendant||t.inLabelledByContext||Wu(e,{strict:r}))?"":(r||(t=$({subtreeDescendant:!a&&!o},t)),Yu(e).redu\
ce((function(e,n){var r=t,a=n.props.nodeName;return(n=wl(n,r))?(dl.includes(a)||(" "!==n[0]&&(n+=" "),e&&" "!==e[e.length-1]&&(n=" "+n)),e+n):e}),""))},fl=function(e){var t=1<arguments.length&&void 0!==arguments[1]?arguments[1]:{},n=wl.alreadyProcessed;if(t.inControlContext||t.inLabelledByContext||n(e,t))return"";t.startNode||(t.startNode=e);var r,a=$({inControlContext:!0},t);n=function(e){if(!e.attr("id"))return[];if(e.actualNode)return Bo({elm:"label",attr:"for",value:e.attr("id"),context:e.actualNode});throw new TypeError("Cannot resolve explicit label reference for non-DOM nodes")}(e);return(t=xa(e,"label"))?(r=[].concat(z(n),[t.actualNode])).sort(tf):r=n,r.map((function(e){return nu(e,a)})).filter((function(e){return""!==e})).join(" ")},ml={submit:"Submit",image:"Submit",reset:"Reset",button:""};function Dl(e,t){return t.attr(e)||""}function hl(e,t,n){t=t.actualNode;var r=[e=e.toLowerCase(),t.nodeName.toLowerCase()].join(",");return(t=t.querySelector(r))&&t.nodeName.toLowerCase()=\
==e?nu(t,n):""}var gl={valueText:function(e){return e.actualNode.value||""},buttonDefaultText:function(e){return e=e.actualNode,ml[e.type]||""},tableCaptionText:hl.bind(null,"caption"),figureText:hl.bind(null,"figcaption"),svgTitleText:hl.bind(null,"title"),fieldsetLegendText:hl.bind(null,"legend"),altText:Dl.bind(null,"alt"),tableSummaryText:Dl.bind(null,"summary"),titleText:Gu,subtreeText:pl,labelText:fl,singleSpace:function(){return" "},placeholderText:Dl.bind(null,"placeholder")};function bl(e){var t,n=1<arguments.length&&void 0!==arguments[1]?arguments[1]:{},r=e.actualNode;return 1!==e.props.nodeType||["presentation","none"].includes(Hu(e))?"":(t=(qu(e,{noMatchAccessibleName:!0}).namingMethods||[]).map((function(e){return gl[e]})).reduce((function(t,r){return t||r(e,n)}),""),n.debug&&o.log(t||"{empty-value}",r,n),t)}function vl(){return/[#*0-9]\\uFE0F?\\u20E3|[\\xA9\\xAE\\u203C\\u2049\\u2122\\u2139\\u2194-\\u2199\\u21A9\\u21AA\\u231A\\u231B\\u2328\\u23CF\\u23ED-\\u23EF\\u23F1\\u23F2\\u23F8-\\u23FA\\u24C\
2\\u25AA\\u25AB\\u25B6\\u25C0\\u25FB\\u25FC\\u25FE\\u2600-\\u2604\\u260E\\u2611\\u2614\\u2615\\u2618\\u2620\\u2622\\u2623\\u2626\\u262A\\u262E\\u262F\\u2638-\\u263A\\u2640\\u2642\\u2648-\\u2653\\u265F\\u2660\\u2663\\u2665\\u2666\\u2668\\u267B\\u267E\\u267F\\u2692\\u2694-\\u2697\\u2699\\u269B\\u269C\\u26A0\\u26A7\\u26AA\\u26B0\\u26B1\\u26BD\\u26BE\\u26C4\\u26C8\\u26CF\\u26D1\\u26D3\\u26E9\\u26F0-\\u26F5\\u26F7\\u26F8\\u26FA\\u2702\\u2708\\u2709\\u270F\\u2712\\u2714\\u2716\\u271D\\u2721\\u2733\\u2734\\u2744\\u2747\\u2757\\u2763\\u27A1\\u2934\\u2935\\u2B05-\\u2B07\\u2B1B\\u2B1C\\u2B55\\u3030\\u303D\\u3297\\u3299]\\uFE0F?|[\\u261D\\u270C\\u270D](?:\\uFE0F|\\uD83C[\\uDFFB-\\uDFFF])?|[\\u270A\\u270B](?:\\uD83C[\\uDFFB-\\uDFFF])?|[\\u23E9-\\u23EC\\u23F0\\u23F3\\u25FD\\u2693\\u26A1\\u26AB\\u26C5\\u26CE\\u26D4\\u26EA\\u26FD\\u2705\\u2728\\u274C\\u274E\\u2753-\\u2755\\u2795-\\u2797\\u27B0\\u27BF\\u2B50]|\\u26F9(?:\\uFE0F|\\uD83C[\\uDFFB-\\uDFFF])?(?:\\u200D[\\u2640\\u2642]\\uFE0F?)?|\\u2764\\uFE0F?(?:\\u200D(?:\\uD83D\\uDD25|\\uD83E\\uDE79))?|\\uD83C(?:[\\uDC04\\uDD70\\uDD71\\uDD7E\\uDD7F\\uDE02\\uDE37\\uDF21\\uDF24-\\uDF2C\\uDF36\\uDF7D\\uDF96\\u\
DF97\\uDF99-\\uDF9B\\uDF9E\\uDF9F\\uDFCD\\uDFCE\\uDFD4-\\uDFDF\\uDFF5\\uDFF7]\\uFE0F?|[\\uDF85\\uDFC2\\uDFC7](?:\\uD83C[\\uDFFB-\\uDFFF])?|[\\uDFC3\\uDFC4\\uDFCA](?:\\uD83C[\\uDFFB-\\uDFFF])?(?:\\u200D[\\u2640\\u2642]\\uFE0F?)?|[\\uDFCB\\uDFCC](?:\\uFE0F|\\uD83C[\\uDFFB-\\uDFFF])?(?:\\u200D[\\u2640\\u2642]\\uFE0F?)?|[\\uDCCF\\uDD8E\\uDD91-\\uDD9A\\uDE01\\uDE1A\\uDE2F\\uDE32-\\uDE36\\uDE38-\\uDE3A\\uDE50\\uDE51\\uDF00-\\uDF20\\uDF2D-\\uDF35\\uDF37-\\uDF7C\\uDF7E-\\uDF84\\uDF86-\\uDF93\\uDFA0-\\uDFC1\\uDFC5\\uDFC6\\uDFC8\\uDFC9\\uDFCF-\\uDFD3\\uDFE0-\\uDFF0\\uDFF8-\\uDFFF]|\\uDDE6\\uD83C[\\uDDE8-\\uDDEC\\uDDEE\\uDDF1\\uDDF2\\uDDF4\\uDDF6-\\uDDFA\\uDDFC\\uDDFD\\uDDFF]|\\uDDE7\\uD83C[\\uDDE6\\uDDE7\\uDDE9-\\uDDEF\\uDDF1-\\uDDF4\\uDDF6-\\uDDF9\\uDDFB\\uDDFC\\uDDFE\\uDDFF]|\\uDDE8\\uD83C[\\uDDE6\\uDDE8\\uDDE9\\uDDEB-\\uDDEE\\uDDF0-\\uDDF5\\uDDF7\\uDDFA-\\uDDFF]|\\uDDE9\\uD83C[\\uDDEA\\uDDEC\\uDDEF\\uDDF0\\uDDF2\\uDDF4\\uDDFF]|\\uDDEA\\uD83C[\\uDDE6\\uDDE8\\uDDEA\\uDDEC\\uDDED\\uDDF7-\\uDDFA]|\\uDDEB\\uD83C[\\uDDEE-\\uDDF0\\uDDF2\\uDDF4\\uDDF7]|\\uDDEC\\uD83C[\\uDDE6\\uDDE7\\uDDE9-\\uDDEE\\uDDF1-\\uDDF3\\uDDF5-\\uDDFA\\uDDFC\\uDDFE]|\\uDD\
ED\\uD83C[\\uDDF0\\uDDF2\\uDDF3\\uDDF7\\uDDF9\\uDDFA]|\\uDDEE\\uD83C[\\uDDE8-\\uDDEA\\uDDF1-\\uDDF4\\uDDF6-\\uDDF9]|\\uDDEF\\uD83C[\\uDDEA\\uDDF2\\uDDF4\\uDDF5]|\\uDDF0\\uD83C[\\uDDEA\\uDDEC-\\uDDEE\\uDDF2\\uDDF3\\uDDF5\\uDDF7\\uDDFC\\uDDFE\\uDDFF]|\\uDDF1\\uD83C[\\uDDE6-\\uDDE8\\uDDEE\\uDDF0\\uDDF7-\\uDDFB\\uDDFE]|\\uDDF2\\uD83C[\\uDDE6\\uDDE8-\\uDDED\\uDDF0-\\uDDFF]|\\uDDF3\\uD83C[\\uDDE6\\uDDE8\\uDDEA-\\uDDEC\\uDDEE\\uDDF1\\uDDF4\\uDDF5\\uDDF7\\uDDFA\\uDDFF]|\\uDDF4\\uD83C\\uDDF2|\\uDDF5\\uD83C[\\uDDE6\\uDDEA-\\uDDED\\uDDF0-\\uDDF3\\uDDF7-\\uDDF9\\uDDFC\\uDDFE]|\\uDDF6\\uD83C\\uDDE6|\\uDDF7\\uD83C[\\uDDEA\\uDDF4\\uDDF8\\uDDFA\\uDDFC]|\\uDDF8\\uD83C[\\uDDE6-\\uDDEA\\uDDEC-\\uDDF4\\uDDF7-\\uDDF9\\uDDFB\\uDDFD-\\uDDFF]|\\uDDF9\\uD83C[\\uDDE6\\uDDE8\\uDDE9\\uDDEB-\\uDDED\\uDDEF-\\uDDF4\\uDDF7\\uDDF9\\uDDFB\\uDDFC\\uDDFF]|\\uDDFA\\uD83C[\\uDDE6\\uDDEC\\uDDF2\\uDDF3\\uDDF8\\uDDFE\\uDDFF]|\\uDDFB\\uD83C[\\uDDE6\\uDDE8\\uDDEA\\uDDEC\\uDDEE\\uDDF3\\uDDFA]|\\uDDFC\\uD83C[\\uDDEB\\uDDF8]|\\uDDFD\\uD83C\\uDDF0|\\uDDFE\\uD83C[\\uDDEA\\uDDF9]|\\uDDFF\\uD83C[\\uDDE6\\uDDF2\\uDDFC]|\\uDFF3\\uFE0F?(?:\\u200D(?:\\u26A7\\uFE0F?|\\uD83C\\uDF08))?|\\uDF\
F4(?:\\u200D\\u2620\\uFE0F?|\\uDB40\\uDC67\\uDB40\\uDC62\\uDB40(?:\\uDC65\\uDB40\\uDC6E\\uDB40\\uDC67|\\uDC73\\uDB40\\uDC63\\uDB40\\uDC74|\\uDC77\\uDB40\\uDC6C\\uDB40\\uDC73)\\uDB40\\uDC7F)?)|\\uD83D(?:[\\uDC08\\uDC26](?:\\u200D\\u2B1B)?|[\\uDC3F\\uDCFD\\uDD49\\uDD4A\\uDD6F\\uDD70\\uDD73\\uDD76-\\uDD79\\uDD87\\uDD8A-\\uDD8D\\uDDA5\\uDDA8\\uDDB1\\uDDB2\\uDDBC\\uDDC2-\\uDDC4\\uDDD1-\\uDDD3\\uDDDC-\\uDDDE\\uDDE1\\uDDE3\\uDDE8\\uDDEF\\uDDF3\\uDDFA\\uDECB\\uDECD-\\uDECF\\uDEE0-\\uDEE5\\uDEE9\\uDEF0\\uDEF3]\\uFE0F?|[\\uDC42\\uDC43\\uDC46-\\uDC50\\uDC66\\uDC67\\uDC6B-\\uDC6D\\uDC72\\uDC74-\\uDC76\\uDC78\\uDC7C\\uDC83\\uDC85\\uDC8F\\uDC91\\uDCAA\\uDD7A\\uDD95\\uDD96\\uDE4C\\uDE4F\\uDEC0\\uDECC](?:\\uD83C[\\uDFFB-\\uDFFF])?|[\\uDC6E\\uDC70\\uDC71\\uDC73\\uDC77\\uDC81\\uDC82\\uDC86\\uDC87\\uDE45-\\uDE47\\uDE4B\\uDE4D\\uDE4E\\uDEA3\\uDEB4-\\uDEB6](?:\\uD83C[\\uDFFB-\\uDFFF])?(?:\\u200D[\\u2640\\u2642]\\uFE0F?)?|[\\uDD74\\uDD90](?:\\uFE0F|\\uD83C[\\uDFFB-\\uDFFF])?|[\\uDC00-\\uDC07\\uDC09-\\uDC14\\uDC16-\\uDC25\\uDC27-\\uDC3A\\uDC3C-\\uDC3E\\uDC40\\uDC44\\uDC45\\uDC51-\\uDC65\\uDC6A\\uDC79-\\uDC7B\\uDC7D-\\uDC80\\uDC84\\uDC88-\\uDC8E\\uDC90\\uDC\
92-\\uDCA9\\uDCAB-\\uDCFC\\uDCFF-\\uDD3D\\uDD4B-\\uDD4E\\uDD50-\\uDD67\\uDDA4\\uDDFB-\\uDE2D\\uDE2F-\\uDE34\\uDE37-\\uDE44\\uDE48-\\uDE4A\\uDE80-\\uDEA2\\uDEA4-\\uDEB3\\uDEB7-\\uDEBF\\uDEC1-\\uDEC5\\uDED0-\\uDED2\\uDED5-\\uDED7\\uDEDC-\\uDEDF\\uDEEB\\uDEEC\\uDEF4-\\uDEFC\\uDFE0-\\uDFEB\\uDFF0]|\\uDC15(?:\\u200D\\uD83E\\uDDBA)?|\\uDC3B(?:\\u200D\\u2744\\uFE0F?)?|\\uDC41\\uFE0F?(?:\\u200D\\uD83D\\uDDE8\\uFE0F?)?|\\uDC68(?:\\u200D(?:[\\u2695\\u2696\\u2708]\\uFE0F?|\\u2764\\uFE0F?\\u200D\\uD83D(?:\\uDC8B\\u200D\\uD83D)?\\uDC68|\\uD83C[\\uDF3E\\uDF73\\uDF7C\\uDF93\\uDFA4\\uDFA8\\uDFEB\\uDFED]|\\uD83D(?:[\\uDC68\\uDC69]\\u200D\\uD83D(?:\\uDC66(?:\\u200D\\uD83D\\uDC66)?|\\uDC67(?:\\u200D\\uD83D[\\uDC66\\uDC67])?)|[\\uDCBB\\uDCBC\\uDD27\\uDD2C\\uDE80\\uDE92]|\\uDC66(?:\\u200D\\uD83D\\uDC66)?|\\uDC67(?:\\u200D\\uD83D[\\uDC66\\uDC67])?)|\\uD83E[\\uDDAF-\\uDDB3\\uDDBC\\uDDBD])|\\uD83C(?:\\uDFFB(?:\\u200D(?:[\\u2695\\u2696\\u2708]\\uFE0F?|\\u2764\\uFE0F?\\u200D\\uD83D(?:\\uDC8B\\u200D\\uD83D)?\\uDC68\\uD83C[\\uDFFB-\\uDFFF]|\\uD83C[\\uDF3E\\uDF73\\uDF7C\\uDF93\\uDFA4\\uDFA8\\uDFEB\\uDFED]|\\uD83D[\\uDCBB\\uDCBC\\uDD27\\uDD2C\\uDE80\\uDE92\
]|\\uD83E(?:[\\uDDAF-\\uDDB3\\uDDBC\\uDDBD]|\\uDD1D\\u200D\\uD83D\\uDC68\\uD83C[\\uDFFC-\\uDFFF])))?|\\uDFFC(?:\\u200D(?:[\\u2695\\u2696\\u2708]\\uFE0F?|\\u2764\\uFE0F?\\u200D\\uD83D(?:\\uDC8B\\u200D\\uD83D)?\\uDC68\\uD83C[\\uDFFB-\\uDFFF]|\\uD83C[\\uDF3E\\uDF73\\uDF7C\\uDF93\\uDFA4\\uDFA8\\uDFEB\\uDFED]|\\uD83D[\\uDCBB\\uDCBC\\uDD27\\uDD2C\\uDE80\\uDE92]|\\uD83E(?:[\\uDDAF-\\uDDB3\\uDDBC\\uDDBD]|\\uDD1D\\u200D\\uD83D\\uDC68\\uD83C[\\uDFFB\\uDFFD-\\uDFFF])))?|\\uDFFD(?:\\u200D(?:[\\u2695\\u2696\\u2708]\\uFE0F?|\\u2764\\uFE0F?\\u200D\\uD83D(?:\\uDC8B\\u200D\\uD83D)?\\uDC68\\uD83C[\\uDFFB-\\uDFFF]|\\uD83C[\\uDF3E\\uDF73\\uDF7C\\uDF93\\uDFA4\\uDFA8\\uDFEB\\uDFED]|\\uD83D[\\uDCBB\\uDCBC\\uDD27\\uDD2C\\uDE80\\uDE92]|\\uD83E(?:[\\uDDAF-\\uDDB3\\uDDBC\\uDDBD]|\\uDD1D\\u200D\\uD83D\\uDC68\\uD83C[\\uDFFB\\uDFFC\\uDFFE\\uDFFF])))?|\\uDFFE(?:\\u200D(?:[\\u2695\\u2696\\u2708]\\uFE0F?|\\u2764\\uFE0F?\\u200D\\uD83D(?:\\uDC8B\\u200D\\uD83D)?\\uDC68\\uD83C[\\uDFFB-\\uDFFF]|\\uD83C[\\uDF3E\\uDF73\\uDF7C\\uDF93\\uDFA4\\uDFA8\\uDFEB\\uDFED]|\\uD83D[\\uDCBB\\uDCBC\\uDD27\\uDD2C\\uDE80\\uDE92]|\\uD83E(?:[\\uDDAF-\\uDDB3\\uDDBC\\uDDBD]|\\uDD1D\\u200\
D\\uD83D\\uDC68\\uD83C[\\uDFFB-\\uDFFD\\uDFFF])))?|\\uDFFF(?:\\u200D(?:[\\u2695\\u2696\\u2708]\\uFE0F?|\\u2764\\uFE0F?\\u200D\\uD83D(?:\\uDC8B\\u200D\\uD83D)?\\uDC68\\uD83C[\\uDFFB-\\uDFFF]|\\uD83C[\\uDF3E\\uDF73\\uDF7C\\uDF93\\uDFA4\\uDFA8\\uDFEB\\uDFED]|\\uD83D[\\uDCBB\\uDCBC\\uDD27\\uDD2C\\uDE80\\uDE92]|\\uD83E(?:[\\uDDAF-\\uDDB3\\uDDBC\\uDDBD]|\\uDD1D\\u200D\\uD83D\\uDC68\\uD83C[\\uDFFB-\\uDFFE])))?))?|\\uDC69(?:\\u200D(?:[\\u2695\\u2696\\u2708]\\uFE0F?|\\u2764\\uFE0F?\\u200D\\uD83D(?:\\uDC8B\\u200D\\uD83D)?[\\uDC68\\uDC69]|\\uD83C[\\uDF3E\\uDF73\\uDF7C\\uDF93\\uDFA4\\uDFA8\\uDFEB\\uDFED]|\\uD83D(?:[\\uDCBB\\uDCBC\\uDD27\\uDD2C\\uDE80\\uDE92]|\\uDC66(?:\\u200D\\uD83D\\uDC66)?|\\uDC67(?:\\u200D\\uD83D[\\uDC66\\uDC67])?|\\uDC69\\u200D\\uD83D(?:\\uDC66(?:\\u200D\\uD83D\\uDC66)?|\\uDC67(?:\\u200D\\uD83D[\\uDC66\\uDC67])?))|\\uD83E[\\uDDAF-\\uDDB3\\uDDBC\\uDDBD])|\\uD83C(?:\\uDFFB(?:\\u200D(?:[\\u2695\\u2696\\u2708]\\uFE0F?|\\u2764\\uFE0F?\\u200D\\uD83D(?:[\\uDC68\\uDC69]|\\uDC8B\\u200D\\uD83D[\\uDC68\\uDC69])\\uD83C[\\uDFFB-\\uDFFF]|\\uD83C[\\uDF3E\\uDF73\\uDF7C\\uDF93\\uDFA4\\uDFA8\\uDFEB\\uDFED]|\\uD83D[\\uDCBB\\uDCBC\\uDD\
27\\uDD2C\\uDE80\\uDE92]|\\uD83E(?:[\\uDDAF-\\uDDB3\\uDDBC\\uDDBD]|\\uDD1D\\u200D\\uD83D[\\uDC68\\uDC69]\\uD83C[\\uDFFC-\\uDFFF])))?|\\uDFFC(?:\\u200D(?:[\\u2695\\u2696\\u2708]\\uFE0F?|\\u2764\\uFE0F?\\u200D\\uD83D(?:[\\uDC68\\uDC69]|\\uDC8B\\u200D\\uD83D[\\uDC68\\uDC69])\\uD83C[\\uDFFB-\\uDFFF]|\\uD83C[\\uDF3E\\uDF73\\uDF7C\\uDF93\\uDFA4\\uDFA8\\uDFEB\\uDFED]|\\uD83D[\\uDCBB\\uDCBC\\uDD27\\uDD2C\\uDE80\\uDE92]|\\uD83E(?:[\\uDDAF-\\uDDB3\\uDDBC\\uDDBD]|\\uDD1D\\u200D\\uD83D[\\uDC68\\uDC69]\\uD83C[\\uDFFB\\uDFFD-\\uDFFF])))?|\\uDFFD(?:\\u200D(?:[\\u2695\\u2696\\u2708]\\uFE0F?|\\u2764\\uFE0F?\\u200D\\uD83D(?:[\\uDC68\\uDC69]|\\uDC8B\\u200D\\uD83D[\\uDC68\\uDC69])\\uD83C[\\uDFFB-\\uDFFF]|\\uD83C[\\uDF3E\\uDF73\\uDF7C\\uDF93\\uDFA4\\uDFA8\\uDFEB\\uDFED]|\\uD83D[\\uDCBB\\uDCBC\\uDD27\\uDD2C\\uDE80\\uDE92]|\\uD83E(?:[\\uDDAF-\\uDDB3\\uDDBC\\uDDBD]|\\uDD1D\\u200D\\uD83D[\\uDC68\\uDC69]\\uD83C[\\uDFFB\\uDFFC\\uDFFE\\uDFFF])))?|\\uDFFE(?:\\u200D(?:[\\u2695\\u2696\\u2708]\\uFE0F?|\\u2764\\uFE0F?\\u200D\\uD83D(?:[\\uDC68\\uDC69]|\\uDC8B\\u200D\\uD83D[\\uDC68\\uDC69])\\uD83C[\\uDFFB-\\uDFFF]|\\uD83C[\\uDF3E\\uDF73\\uDF7C\\uDF93\\uDFA4\\uD\
FA8\\uDFEB\\uDFED]|\\uD83D[\\uDCBB\\uDCBC\\uDD27\\uDD2C\\uDE80\\uDE92]|\\uD83E(?:[\\uDDAF-\\uDDB3\\uDDBC\\uDDBD]|\\uDD1D\\u200D\\uD83D[\\uDC68\\uDC69]\\uD83C[\\uDFFB-\\uDFFD\\uDFFF])))?|\\uDFFF(?:\\u200D(?:[\\u2695\\u2696\\u2708]\\uFE0F?|\\u2764\\uFE0F?\\u200D\\uD83D(?:[\\uDC68\\uDC69]|\\uDC8B\\u200D\\uD83D[\\uDC68\\uDC69])\\uD83C[\\uDFFB-\\uDFFF]|\\uD83C[\\uDF3E\\uDF73\\uDF7C\\uDF93\\uDFA4\\uDFA8\\uDFEB\\uDFED]|\\uD83D[\\uDCBB\\uDCBC\\uDD27\\uDD2C\\uDE80\\uDE92]|\\uD83E(?:[\\uDDAF-\\uDDB3\\uDDBC\\uDDBD]|\\uDD1D\\u200D\\uD83D[\\uDC68\\uDC69]\\uD83C[\\uDFFB-\\uDFFE])))?))?|\\uDC6F(?:\\u200D[\\u2640\\u2642]\\uFE0F?)?|\\uDD75(?:\\uFE0F|\\uD83C[\\uDFFB-\\uDFFF])?(?:\\u200D[\\u2640\\u2642]\\uFE0F?)?|\\uDE2E(?:\\u200D\\uD83D\\uDCA8)?|\\uDE35(?:\\u200D\\uD83D\\uDCAB)?|\\uDE36(?:\\u200D\\uD83C\\uDF2B\\uFE0F?)?)|\\uD83E(?:[\\uDD0C\\uDD0F\\uDD18-\\uDD1F\\uDD30-\\uDD34\\uDD36\\uDD77\\uDDB5\\uDDB6\\uDDBB\\uDDD2\\uDDD3\\uDDD5\\uDEC3-\\uDEC5\\uDEF0\\uDEF2-\\uDEF8](?:\\uD83C[\\uDFFB-\\uDFFF])?|[\\uDD26\\uDD35\\uDD37-\\uDD39\\uDD3D\\uDD3E\\uDDB8\\uDDB9\\uDDCD-\\uDDCF\\uDDD4\\uDDD6-\\uDDDD](?:\\uD83C[\\uDFFB-\\uDFFF])?(?:\\u200D[\\u2640\\u2\
642]\\uFE0F?)?|[\\uDDDE\\uDDDF](?:\\u200D[\\u2640\\u2642]\\uFE0F?)?|[\\uDD0D\\uDD0E\\uDD10-\\uDD17\\uDD20-\\uDD25\\uDD27-\\uDD2F\\uDD3A\\uDD3F-\\uDD45\\uDD47-\\uDD76\\uDD78-\\uDDB4\\uDDB7\\uDDBA\\uDDBC-\\uDDCC\\uDDD0\\uDDE0-\\uDDFF\\uDE70-\\uDE7C\\uDE80-\\uDE88\\uDE90-\\uDEBD\\uDEBF-\\uDEC2\\uDECE-\\uDEDB\\uDEE0-\\uDEE8]|\\uDD3C(?:\\u200D[\\u2640\\u2642]\\uFE0F?|\\uD83C[\\uDFFB-\\uDFFF])?|\\uDDD1(?:\\u200D(?:[\\u2695\\u2696\\u2708]\\uFE0F?|\\uD83C[\\uDF3E\\uDF73\\uDF7C\\uDF84\\uDF93\\uDFA4\\uDFA8\\uDFEB\\uDFED]|\\uD83D[\\uDCBB\\uDCBC\\uDD27\\uDD2C\\uDE80\\uDE92]|\\uD83E(?:[\\uDDAF-\\uDDB3\\uDDBC\\uDDBD]|\\uDD1D\\u200D\\uD83E\\uDDD1))|\\uD83C(?:\\uDFFB(?:\\u200D(?:[\\u2695\\u2696\\u2708]\\uFE0F?|\\u2764\\uFE0F?\\u200D(?:\\uD83D\\uDC8B\\u200D)?\\uD83E\\uDDD1\\uD83C[\\uDFFC-\\uDFFF]|\\uD83C[\\uDF3E\\uDF73\\uDF7C\\uDF84\\uDF93\\uDFA4\\uDFA8\\uDFEB\\uDFED]|\\uD83D[\\uDCBB\\uDCBC\\uDD27\\uDD2C\\uDE80\\uDE92]|\\uD83E(?:[\\uDDAF-\\uDDB3\\uDDBC\\uDDBD]|\\uDD1D\\u200D\\uD83E\\uDDD1\\uD83C[\\uDFFB-\\uDFFF])))?|\\uDFFC(?:\\u200D(?:[\\u2695\\u2696\\u2708]\\uFE0F?|\\u2764\\uFE0F?\\u200D(?:\\uD83D\\uDC8B\\u200D)?\\uD83E\\uDDD1\\uD83C[\\uDFFB\
\\uDFFD-\\uDFFF]|\\uD83C[\\uDF3E\\uDF73\\uDF7C\\uDF84\\uDF93\\uDFA4\\uDFA8\\uDFEB\\uDFED]|\\uD83D[\\uDCBB\\uDCBC\\uDD27\\uDD2C\\uDE80\\uDE92]|\\uD83E(?:[\\uDDAF-\\uDDB3\\uDDBC\\uDDBD]|\\uDD1D\\u200D\\uD83E\\uDDD1\\uD83C[\\uDFFB-\\uDFFF])))?|\\uDFFD(?:\\u200D(?:[\\u2695\\u2696\\u2708]\\uFE0F?|\\u2764\\uFE0F?\\u200D(?:\\uD83D\\uDC8B\\u200D)?\\uD83E\\uDDD1\\uD83C[\\uDFFB\\uDFFC\\uDFFE\\uDFFF]|\\uD83C[\\uDF3E\\uDF73\\uDF7C\\uDF84\\uDF93\\uDFA4\\uDFA8\\uDFEB\\uDFED]|\\uD83D[\\uDCBB\\uDCBC\\uDD27\\uDD2C\\uDE80\\uDE92]|\\uD83E(?:[\\uDDAF-\\uDDB3\\uDDBC\\uDDBD]|\\uDD1D\\u200D\\uD83E\\uDDD1\\uD83C[\\uDFFB-\\uDFFF])))?|\\uDFFE(?:\\u200D(?:[\\u2695\\u2696\\u2708]\\uFE0F?|\\u2764\\uFE0F?\\u200D(?:\\uD83D\\uDC8B\\u200D)?\\uD83E\\uDDD1\\uD83C[\\uDFFB-\\uDFFD\\uDFFF]|\\uD83C[\\uDF3E\\uDF73\\uDF7C\\uDF84\\uDF93\\uDFA4\\uDFA8\\uDFEB\\uDFED]|\\uD83D[\\uDCBB\\uDCBC\\uDD27\\uDD2C\\uDE80\\uDE92]|\\uD83E(?:[\\uDDAF-\\uDDB3\\uDDBC\\uDDBD]|\\uDD1D\\u200D\\uD83E\\uDDD1\\uD83C[\\uDFFB-\\uDFFF])))?|\\uDFFF(?:\\u200D(?:[\\u2695\\u2696\\u2708]\\uFE0F?|\\u2764\\uFE0F?\\u200D(?:\\uD83D\\uDC8B\\u200D)?\\uD83E\\uDDD1\\uD83C[\\uDFFB-\\uDFFE]|\\uD83C[\\uDF3E\\uDF\
73\\uDF7C\\uDF84\\uDF93\\uDFA4\\uDFA8\\uDFEB\\uDFED]|\\uD83D[\\uDCBB\\uDCBC\\uDD27\\uDD2C\\uDE80\\uDE92]|\\uD83E(?:[\\uDDAF-\\uDDB3\\uDDBC\\uDDBD]|\\uDD1D\\u200D\\uD83E\\uDDD1\\uD83C[\\uDFFB-\\uDFFF])))?))?|\\uDEF1(?:\\uD83C(?:\\uDFFB(?:\\u200D\\uD83E\\uDEF2\\uD83C[\\uDFFC-\\uDFFF])?|\\uDFFC(?:\\u200D\\uD83E\\uDEF2\\uD83C[\\uDFFB\\uDFFD-\\uDFFF])?|\\uDFFD(?:\\u200D\\uD83E\\uDEF2\\uD83C[\\uDFFB\\uDFFC\\uDFFE\\uDFFF])?|\\uDFFE(?:\\u200D\\uD83E\\uDEF2\\uD83C[\\uDFFB-\\uDFFD\\uDFFF])?|\\uDFFF(?:\\u200D\\uD83E\\uDEF2\\uD83C[\\uDFFB-\\uDFFE])?))?)/g}var yl=function(e,t){var n=t.emoji,r=t.nonBmp,a=(t=t.punctuations,!1);return n&&(a=a||/[#*0-9]\\uFE0F?\\u20E3|[\\xA9\\xAE\\u203C\\u2049\\u2122\\u2139\\u2194-\\u2199\\u21A9\\u21AA\\u231A\\u231B\\u2328\\u23CF\\u23ED-\\u23EF\\u23F1\\u23F2\\u23F8-\\u23FA\\u24C2\\u25AA\\u25AB\\u25B6\\u25C0\\u25FB\\u25FC\\u25FE\\u2600-\\u2604\\u260E\\u2611\\u2614\\u2615\\u2618\\u2620\\u2622\\u2623\\u2626\\u262A\\u262E\\u262F\\u2638-\\u263A\\u2640\\u2642\\u2648-\\u2653\\u265F\\u2660\\u2663\\u2665\\u2666\\u2668\\u267B\\u267E\\u267F\\u2692\\u2694-\\u2697\\u2699\\u269B\\u269C\\u26A0\\u26A7\\u26AA\\u26B0\\u2\
6B1\\u26BD\\u26BE\\u26C4\\u26C8\\u26CF\\u26D1\\u26D3\\u26E9\\u26F0-\\u26F5\\u26F7\\u26F8\\u26FA\\u2702\\u2708\\u2709\\u270F\\u2712\\u2714\\u2716\\u271D\\u2721\\u2733\\u2734\\u2744\\u2747\\u2757\\u2763\\u27A1\\u2934\\u2935\\u2B05-\\u2B07\\u2B1B\\u2B1C\\u2B55\\u3030\\u303D\\u3297\\u3299]\\uFE0F?|[\\u261D\\u270C\\u270D](?:\\uFE0F|\\uD83C[\\uDFFB-\\uDFFF])?|[\\u270A\\u270B](?:\\uD83C[\\uDFFB-\\uDFFF])?|[\\u23E9-\\u23EC\\u23F0\\u23F3\\u25FD\\u2693\\u26A1\\u26AB\\u26C5\\u26CE\\u26D4\\u26EA\\u26FD\\u2705\\u2728\\u274C\\u274E\\u2753-\\u2755\\u2795-\\u2797\\u27B0\\u27BF\\u2B50]|\\u26F9(?:\\uFE0F|\\uD83C[\\uDFFB-\\uDFFF])?(?:\\u200D[\\u2640\\u2642]\\uFE0F?)?|\\u2764\\uFE0F?(?:\\u200D(?:\\uD83D\\uDD25|\\uD83E\\uDE79))?|\\uD83C(?:[\\uDC04\\uDD70\\uDD71\\uDD7E\\uDD7F\\uDE02\\uDE37\\uDF21\\uDF24-\\uDF2C\\uDF36\\uDF7D\\uDF96\\uDF97\\uDF99-\\uDF9B\\uDF9E\\uDF9F\\uDFCD\\uDFCE\\uDFD4-\\uDFDF\\uDFF5\\uDFF7]\\uFE0F?|[\\uDF85\\uDFC2\\uDFC7](?:\\uD83C[\\uDFFB-\\uDFFF])?|[\\uDFC3\\uDFC4\\uDFCA](?:\\uD83C[\\uDFFB-\\uDFFF])?(?:\\u200D[\\u2640\\u2642]\\uFE0F?)?|[\\uDFCB\\uDFCC](?:\\uFE0F|\\uD83C[\\uDFFB-\\uDFFF])?(?:\\u200D[\\u2640\\u2642]\\uFE0F?)?|[\\u\
DCCF\\uDD8E\\uDD91-\\uDD9A\\uDE01\\uDE1A\\uDE2F\\uDE32-\\uDE36\\uDE38-\\uDE3A\\uDE50\\uDE51\\uDF00-\\uDF20\\uDF2D-\\uDF35\\uDF37-\\uDF7C\\uDF7E-\\uDF84\\uDF86-\\uDF93\\uDFA0-\\uDFC1\\uDFC5\\uDFC6\\uDFC8\\uDFC9\\uDFCF-\\uDFD3\\uDFE0-\\uDFF0\\uDFF8-\\uDFFF]|\\uDDE6\\uD83C[\\uDDE8-\\uDDEC\\uDDEE\\uDDF1\\uDDF2\\uDDF4\\uDDF6-\\uDDFA\\uDDFC\\uDDFD\\uDDFF]|\\uDDE7\\uD83C[\\uDDE6\\uDDE7\\uDDE9-\\uDDEF\\uDDF1-\\uDDF4\\uDDF6-\\uDDF9\\uDDFB\\uDDFC\\uDDFE\\uDDFF]|\\uDDE8\\uD83C[\\uDDE6\\uDDE8\\uDDE9\\uDDEB-\\uDDEE\\uDDF0-\\uDDF5\\uDDF7\\uDDFA-\\uDDFF]|\\uDDE9\\uD83C[\\uDDEA\\uDDEC\\uDDEF\\uDDF0\\uDDF2\\uDDF4\\uDDFF]|\\uDDEA\\uD83C[\\uDDE6\\uDDE8\\uDDEA\\uDDEC\\uDDED\\uDDF7-\\uDDFA]|\\uDDEB\\uD83C[\\uDDEE-\\uDDF0\\uDDF2\\uDDF4\\uDDF7]|\\uDDEC\\uD83C[\\uDDE6\\uDDE7\\uDDE9-\\uDDEE\\uDDF1-\\uDDF3\\uDDF5-\\uDDFA\\uDDFC\\uDDFE]|\\uDDED\\uD83C[\\uDDF0\\uDDF2\\uDDF3\\uDDF7\\uDDF9\\uDDFA]|\\uDDEE\\uD83C[\\uDDE8-\\uDDEA\\uDDF1-\\uDDF4\\uDDF6-\\uDDF9]|\\uDDEF\\uD83C[\\uDDEA\\uDDF2\\uDDF4\\uDDF5]|\\uDDF0\\uD83C[\\uDDEA\\uDDEC-\\uDDEE\\uDDF2\\uDDF3\\uDDF5\\uDDF7\\uDDFC\\uDDFE\\uDDFF]|\\uDDF1\\uD83C[\\uDDE6-\\uDDE8\\uDDEE\\uDDF0\\uDDF7-\\uDDFB\\uDDFE]|\\uDDF2\\uD\
83C[\\uDDE6\\uDDE8-\\uDDED\\uDDF0-\\uDDFF]|\\uDDF3\\uD83C[\\uDDE6\\uDDE8\\uDDEA-\\uDDEC\\uDDEE\\uDDF1\\uDDF4\\uDDF5\\uDDF7\\uDDFA\\uDDFF]|\\uDDF4\\uD83C\\uDDF2|\\uDDF5\\uD83C[\\uDDE6\\uDDEA-\\uDDED\\uDDF0-\\uDDF3\\uDDF7-\\uDDF9\\uDDFC\\uDDFE]|\\uDDF6\\uD83C\\uDDE6|\\uDDF7\\uD83C[\\uDDEA\\uDDF4\\uDDF8\\uDDFA\\uDDFC]|\\uDDF8\\uD83C[\\uDDE6-\\uDDEA\\uDDEC-\\uDDF4\\uDDF7-\\uDDF9\\uDDFB\\uDDFD-\\uDDFF]|\\uDDF9\\uD83C[\\uDDE6\\uDDE8\\uDDE9\\uDDEB-\\uDDED\\uDDEF-\\uDDF4\\uDDF7\\uDDF9\\uDDFB\\uDDFC\\uDDFF]|\\uDDFA\\uD83C[\\uDDE6\\uDDEC\\uDDF2\\uDDF3\\uDDF8\\uDDFE\\uDDFF]|\\uDDFB\\uD83C[\\uDDE6\\uDDE8\\uDDEA\\uDDEC\\uDDEE\\uDDF3\\uDDFA]|\\uDDFC\\uD83C[\\uDDEB\\uDDF8]|\\uDDFD\\uD83C\\uDDF0|\\uDDFE\\uD83C[\\uDDEA\\uDDF9]|\\uDDFF\\uD83C[\\uDDE6\\uDDF2\\uDDFC]|\\uDFF3\\uFE0F?(?:\\u200D(?:\\u26A7\\uFE0F?|\\uD83C\\uDF08))?|\\uDFF4(?:\\u200D\\u2620\\uFE0F?|\\uDB40\\uDC67\\uDB40\\uDC62\\uDB40(?:\\uDC65\\uDB40\\uDC6E\\uDB40\\uDC67|\\uDC73\\uDB40\\uDC63\\uDB40\\uDC74|\\uDC77\\uDB40\\uDC6C\\uDB40\\uDC73)\\uDB40\\uDC7F)?)|\\uD83D(?:[\\uDC08\\uDC26](?:\\u200D\\u2B1B)?|[\\uDC3F\\uDCFD\\uDD49\\uDD4A\\uDD6F\\uDD70\\uDD73\\uDD76-\\uDD79\\uDD87\\uDD8A-\\uDD8D\\\
uDDA5\\uDDA8\\uDDB1\\uDDB2\\uDDBC\\uDDC2-\\uDDC4\\uDDD1-\\uDDD3\\uDDDC-\\uDDDE\\uDDE1\\uDDE3\\uDDE8\\uDDEF\\uDDF3\\uDDFA\\uDECB\\uDECD-\\uDECF\\uDEE0-\\uDEE5\\uDEE9\\uDEF0\\uDEF3]\\uFE0F?|[\\uDC42\\uDC43\\uDC46-\\uDC50\\uDC66\\uDC67\\uDC6B-\\uDC6D\\uDC72\\uDC74-\\uDC76\\uDC78\\uDC7C\\uDC83\\uDC85\\uDC8F\\uDC91\\uDCAA\\uDD7A\\uDD95\\uDD96\\uDE4C\\uDE4F\\uDEC0\\uDECC](?:\\uD83C[\\uDFFB-\\uDFFF])?|[\\uDC6E\\uDC70\\uDC71\\uDC73\\uDC77\\uDC81\\uDC82\\uDC86\\uDC87\\uDE45-\\uDE47\\uDE4B\\uDE4D\\uDE4E\\uDEA3\\uDEB4-\\uDEB6](?:\\uD83C[\\uDFFB-\\uDFFF])?(?:\\u200D[\\u2640\\u2642]\\uFE0F?)?|[\\uDD74\\uDD90](?:\\uFE0F|\\uD83C[\\uDFFB-\\uDFFF])?|[\\uDC00-\\uDC07\\uDC09-\\uDC14\\uDC16-\\uDC25\\uDC27-\\uDC3A\\uDC3C-\\uDC3E\\uDC40\\uDC44\\uDC45\\uDC51-\\uDC65\\uDC6A\\uDC79-\\uDC7B\\uDC7D-\\uDC80\\uDC84\\uDC88-\\uDC8E\\uDC90\\uDC92-\\uDCA9\\uDCAB-\\uDCFC\\uDCFF-\\uDD3D\\uDD4B-\\uDD4E\\uDD50-\\uDD67\\uDDA4\\uDDFB-\\uDE2D\\uDE2F-\\uDE34\\uDE37-\\uDE44\\uDE48-\\uDE4A\\uDE80-\\uDEA2\\uDEA4-\\uDEB3\\uDEB7-\\uDEBF\\uDEC1-\\uDEC5\\uDED0-\\uDED2\\uDED5-\\uDED7\\uDEDC-\\uDEDF\\uDEEB\\uDEEC\\uDEF4-\\uDEFC\\uDFE0-\\uDFEB\\uDFF0]|\\uDC15(?:\\u200D\\uD83E\\uDDBA)\
?|\\uDC3B(?:\\u200D\\u2744\\uFE0F?)?|\\uDC41\\uFE0F?(?:\\u200D\\uD83D\\uDDE8\\uFE0F?)?|\\uDC68(?:\\u200D(?:[\\u2695\\u2696\\u2708]\\uFE0F?|\\u2764\\uFE0F?\\u200D\\uD83D(?:\\uDC8B\\u200D\\uD83D)?\\uDC68|\\uD83C[\\uDF3E\\uDF73\\uDF7C\\uDF93\\uDFA4\\uDFA8\\uDFEB\\uDFED]|\\uD83D(?:[\\uDC68\\uDC69]\\u200D\\uD83D(?:\\uDC66(?:\\u200D\\uD83D\\uDC66)?|\\uDC67(?:\\u200D\\uD83D[\\uDC66\\uDC67])?)|[\\uDCBB\\uDCBC\\uDD27\\uDD2C\\uDE80\\uDE92]|\\uDC66(?:\\u200D\\uD83D\\uDC66)?|\\uDC67(?:\\u200D\\uD83D[\\uDC66\\uDC67])?)|\\uD83E[\\uDDAF-\\uDDB3\\uDDBC\\uDDBD])|\\uD83C(?:\\uDFFB(?:\\u200D(?:[\\u2695\\u2696\\u2708]\\uFE0F?|\\u2764\\uFE0F?\\u200D\\uD83D(?:\\uDC8B\\u200D\\uD83D)?\\uDC68\\uD83C[\\uDFFB-\\uDFFF]|\\uD83C[\\uDF3E\\uDF73\\uDF7C\\uDF93\\uDFA4\\uDFA8\\uDFEB\\uDFED]|\\uD83D[\\uDCBB\\uDCBC\\uDD27\\uDD2C\\uDE80\\uDE92]|\\uD83E(?:[\\uDDAF-\\uDDB3\\uDDBC\\uDDBD]|\\uDD1D\\u200D\\uD83D\\uDC68\\uD83C[\\uDFFC-\\uDFFF])))?|\\uDFFC(?:\\u200D(?:[\\u2695\\u2696\\u2708]\\uFE0F?|\\u2764\\uFE0F?\\u200D\\uD83D(?:\\uDC8B\\u200D\\uD83D)?\\uDC68\\uD83C[\\uDFFB-\\uDFFF]|\\uD83C[\\uDF3E\\uDF73\\uDF7C\\uDF93\\uDFA4\\uDFA8\\uDFEB\\uDFED]|\\uD83D[\\uDCBB\\uD\
CBC\\uDD27\\uDD2C\\uDE80\\uDE92]|\\uD83E(?:[\\uDDAF-\\uDDB3\\uDDBC\\uDDBD]|\\uDD1D\\u200D\\uD83D\\uDC68\\uD83C[\\uDFFB\\uDFFD-\\uDFFF])))?|\\uDFFD(?:\\u200D(?:[\\u2695\\u2696\\u2708]\\uFE0F?|\\u2764\\uFE0F?\\u200D\\uD83D(?:\\uDC8B\\u200D\\uD83D)?\\uDC68\\uD83C[\\uDFFB-\\uDFFF]|\\uD83C[\\uDF3E\\uDF73\\uDF7C\\uDF93\\uDFA4\\uDFA8\\uDFEB\\uDFED]|\\uD83D[\\uDCBB\\uDCBC\\uDD27\\uDD2C\\uDE80\\uDE92]|\\uD83E(?:[\\uDDAF-\\uDDB3\\uDDBC\\uDDBD]|\\uDD1D\\u200D\\uD83D\\uDC68\\uD83C[\\uDFFB\\uDFFC\\uDFFE\\uDFFF])))?|\\uDFFE(?:\\u200D(?:[\\u2695\\u2696\\u2708]\\uFE0F?|\\u2764\\uFE0F?\\u200D\\uD83D(?:\\uDC8B\\u200D\\uD83D)?\\uDC68\\uD83C[\\uDFFB-\\uDFFF]|\\uD83C[\\uDF3E\\uDF73\\uDF7C\\uDF93\\uDFA4\\uDFA8\\uDFEB\\uDFED]|\\uD83D[\\uDCBB\\uDCBC\\uDD27\\uDD2C\\uDE80\\uDE92]|\\uD83E(?:[\\uDDAF-\\uDDB3\\uDDBC\\uDDBD]|\\uDD1D\\u200D\\uD83D\\uDC68\\uD83C[\\uDFFB-\\uDFFD\\uDFFF])))?|\\uDFFF(?:\\u200D(?:[\\u2695\\u2696\\u2708]\\uFE0F?|\\u2764\\uFE0F?\\u200D\\uD83D(?:\\uDC8B\\u200D\\uD83D)?\\uDC68\\uD83C[\\uDFFB-\\uDFFF]|\\uD83C[\\uDF3E\\uDF73\\uDF7C\\uDF93\\uDFA4\\uDFA8\\uDFEB\\uDFED]|\\uD83D[\\uDCBB\\uDCBC\\uDD27\\uDD2C\\uDE80\\uDE92]|\\uD83E(?:[\\uDDA\
F-\\uDDB3\\uDDBC\\uDDBD]|\\uDD1D\\u200D\\uD83D\\uDC68\\uD83C[\\uDFFB-\\uDFFE])))?))?|\\uDC69(?:\\u200D(?:[\\u2695\\u2696\\u2708]\\uFE0F?|\\u2764\\uFE0F?\\u200D\\uD83D(?:\\uDC8B\\u200D\\uD83D)?[\\uDC68\\uDC69]|\\uD83C[\\uDF3E\\uDF73\\uDF7C\\uDF93\\uDFA4\\uDFA8\\uDFEB\\uDFED]|\\uD83D(?:[\\uDCBB\\uDCBC\\uDD27\\uDD2C\\uDE80\\uDE92]|\\uDC66(?:\\u200D\\uD83D\\uDC66)?|\\uDC67(?:\\u200D\\uD83D[\\uDC66\\uDC67])?|\\uDC69\\u200D\\uD83D(?:\\uDC66(?:\\u200D\\uD83D\\uDC66)?|\\uDC67(?:\\u200D\\uD83D[\\uDC66\\uDC67])?))|\\uD83E[\\uDDAF-\\uDDB3\\uDDBC\\uDDBD])|\\uD83C(?:\\uDFFB(?:\\u200D(?:[\\u2695\\u2696\\u2708]\\uFE0F?|\\u2764\\uFE0F?\\u200D\\uD83D(?:[\\uDC68\\uDC69]|\\uDC8B\\u200D\\uD83D[\\uDC68\\uDC69])\\uD83C[\\uDFFB-\\uDFFF]|\\uD83C[\\uDF3E\\uDF73\\uDF7C\\uDF93\\uDFA4\\uDFA8\\uDFEB\\uDFED]|\\uD83D[\\uDCBB\\uDCBC\\uDD27\\uDD2C\\uDE80\\uDE92]|\\uD83E(?:[\\uDDAF-\\uDDB3\\uDDBC\\uDDBD]|\\uDD1D\\u200D\\uD83D[\\uDC68\\uDC69]\\uD83C[\\uDFFC-\\uDFFF])))?|\\uDFFC(?:\\u200D(?:[\\u2695\\u2696\\u2708]\\uFE0F?|\\u2764\\uFE0F?\\u200D\\uD83D(?:[\\uDC68\\uDC69]|\\uDC8B\\u200D\\uD83D[\\uDC68\\uDC69])\\uD83C[\\uDFFB-\\uDFFF]|\\uD83C[\\uDF3E\\uDF73\\uDF\
7C\\uDF93\\uDFA4\\uDFA8\\uDFEB\\uDFED]|\\uD83D[\\uDCBB\\uDCBC\\uDD27\\uDD2C\\uDE80\\uDE92]|\\uD83E(?:[\\uDDAF-\\uDDB3\\uDDBC\\uDDBD]|\\uDD1D\\u200D\\uD83D[\\uDC68\\uDC69]\\uD83C[\\uDFFB\\uDFFD-\\uDFFF])))?|\\uDFFD(?:\\u200D(?:[\\u2695\\u2696\\u2708]\\uFE0F?|\\u2764\\uFE0F?\\u200D\\uD83D(?:[\\uDC68\\uDC69]|\\uDC8B\\u200D\\uD83D[\\uDC68\\uDC69])\\uD83C[\\uDFFB-\\uDFFF]|\\uD83C[\\uDF3E\\uDF73\\uDF7C\\uDF93\\uDFA4\\uDFA8\\uDFEB\\uDFED]|\\uD83D[\\uDCBB\\uDCBC\\uDD27\\uDD2C\\uDE80\\uDE92]|\\uD83E(?:[\\uDDAF-\\uDDB3\\uDDBC\\uDDBD]|\\uDD1D\\u200D\\uD83D[\\uDC68\\uDC69]\\uD83C[\\uDFFB\\uDFFC\\uDFFE\\uDFFF])))?|\\uDFFE(?:\\u200D(?:[\\u2695\\u2696\\u2708]\\uFE0F?|\\u2764\\uFE0F?\\u200D\\uD83D(?:[\\uDC68\\uDC69]|\\uDC8B\\u200D\\uD83D[\\uDC68\\uDC69])\\uD83C[\\uDFFB-\\uDFFF]|\\uD83C[\\uDF3E\\uDF73\\uDF7C\\uDF93\\uDFA4\\uDFA8\\uDFEB\\uDFED]|\\uD83D[\\uDCBB\\uDCBC\\uDD27\\uDD2C\\uDE80\\uDE92]|\\uD83E(?:[\\uDDAF-\\uDDB3\\uDDBC\\uDDBD]|\\uDD1D\\u200D\\uD83D[\\uDC68\\uDC69]\\uD83C[\\uDFFB-\\uDFFD\\uDFFF])))?|\\uDFFF(?:\\u200D(?:[\\u2695\\u2696\\u2708]\\uFE0F?|\\u2764\\uFE0F?\\u200D\\uD83D(?:[\\uDC68\\uDC69]|\\uDC8B\\u200D\\uD83D[\\uDC68\\uDC69]\
)\\uD83C[\\uDFFB-\\uDFFF]|\\uD83C[\\uDF3E\\uDF73\\uDF7C\\uDF93\\uDFA4\\uDFA8\\uDFEB\\uDFED]|\\uD83D[\\uDCBB\\uDCBC\\uDD27\\uDD2C\\uDE80\\uDE92]|\\uD83E(?:[\\uDDAF-\\uDDB3\\uDDBC\\uDDBD]|\\uDD1D\\u200D\\uD83D[\\uDC68\\uDC69]\\uD83C[\\uDFFB-\\uDFFE])))?))?|\\uDC6F(?:\\u200D[\\u2640\\u2642]\\uFE0F?)?|\\uDD75(?:\\uFE0F|\\uD83C[\\uDFFB-\\uDFFF])?(?:\\u200D[\\u2640\\u2642]\\uFE0F?)?|\\uDE2E(?:\\u200D\\uD83D\\uDCA8)?|\\uDE35(?:\\u200D\\uD83D\\uDCAB)?|\\uDE36(?:\\u200D\\uD83C\\uDF2B\\uFE0F?)?)|\\uD83E(?:[\\uDD0C\\uDD0F\\uDD18-\\uDD1F\\uDD30-\\uDD34\\uDD36\\uDD77\\uDDB5\\uDDB6\\uDDBB\\uDDD2\\uDDD3\\uDDD5\\uDEC3-\\uDEC5\\uDEF0\\uDEF2-\\uDEF8](?:\\uD83C[\\uDFFB-\\uDFFF])?|[\\uDD26\\uDD35\\uDD37-\\uDD39\\uDD3D\\uDD3E\\uDDB8\\uDDB9\\uDDCD-\\uDDCF\\uDDD4\\uDDD6-\\uDDDD](?:\\uD83C[\\uDFFB-\\uDFFF])?(?:\\u200D[\\u2640\\u2642]\\uFE0F?)?|[\\uDDDE\\uDDDF](?:\\u200D[\\u2640\\u2642]\\uFE0F?)?|[\\uDD0D\\uDD0E\\uDD10-\\uDD17\\uDD20-\\uDD25\\uDD27-\\uDD2F\\uDD3A\\uDD3F-\\uDD45\\uDD47-\\uDD76\\uDD78-\\uDDB4\\uDDB7\\uDDBA\\uDDBC-\\uDDCC\\uDDD0\\uDDE0-\\uDDFF\\uDE70-\\uDE7C\\uDE80-\\uDE88\\uDE90-\\uDEBD\\uDEBF-\\uDEC2\\uDECE-\\uDEDB\\uDEE0-\\uDEE8]|\\u\
DD3C(?:\\u200D[\\u2640\\u2642]\\uFE0F?|\\uD83C[\\uDFFB-\\uDFFF])?|\\uDDD1(?:\\u200D(?:[\\u2695\\u2696\\u2708]\\uFE0F?|\\uD83C[\\uDF3E\\uDF73\\uDF7C\\uDF84\\uDF93\\uDFA4\\uDFA8\\uDFEB\\uDFED]|\\uD83D[\\uDCBB\\uDCBC\\uDD27\\uDD2C\\uDE80\\uDE92]|\\uD83E(?:[\\uDDAF-\\uDDB3\\uDDBC\\uDDBD]|\\uDD1D\\u200D\\uD83E\\uDDD1))|\\uD83C(?:\\uDFFB(?:\\u200D(?:[\\u2695\\u2696\\u2708]\\uFE0F?|\\u2764\\uFE0F?\\u200D(?:\\uD83D\\uDC8B\\u200D)?\\uD83E\\uDDD1\\uD83C[\\uDFFC-\\uDFFF]|\\uD83C[\\uDF3E\\uDF73\\uDF7C\\uDF84\\uDF93\\uDFA4\\uDFA8\\uDFEB\\uDFED]|\\uD83D[\\uDCBB\\uDCBC\\uDD27\\uDD2C\\uDE80\\uDE92]|\\uD83E(?:[\\uDDAF-\\uDDB3\\uDDBC\\uDDBD]|\\uDD1D\\u200D\\uD83E\\uDDD1\\uD83C[\\uDFFB-\\uDFFF])))?|\\uDFFC(?:\\u200D(?:[\\u2695\\u2696\\u2708]\\uFE0F?|\\u2764\\uFE0F?\\u200D(?:\\uD83D\\uDC8B\\u200D)?\\uD83E\\uDDD1\\uD83C[\\uDFFB\\uDFFD-\\uDFFF]|\\uD83C[\\uDF3E\\uDF73\\uDF7C\\uDF84\\uDF93\\uDFA4\\uDFA8\\uDFEB\\uDFED]|\\uD83D[\\uDCBB\\uDCBC\\uDD27\\uDD2C\\uDE80\\uDE92]|\\uD83E(?:[\\uDDAF-\\uDDB3\\uDDBC\\uDDBD]|\\uDD1D\\u200D\\uD83E\\uDDD1\\uD83C[\\uDFFB-\\uDFFF])))?|\\uDFFD(?:\\u200D(?:[\\u2695\\u2696\\u2708]\\uFE0F?|\\u2764\\uFE0F?\\u200D(?:\\uD83D\
\\uDC8B\\u200D)?\\uD83E\\uDDD1\\uD83C[\\uDFFB\\uDFFC\\uDFFE\\uDFFF]|\\uD83C[\\uDF3E\\uDF73\\uDF7C\\uDF84\\uDF93\\uDFA4\\uDFA8\\uDFEB\\uDFED]|\\uD83D[\\uDCBB\\uDCBC\\uDD27\\uDD2C\\uDE80\\uDE92]|\\uD83E(?:[\\uDDAF-\\uDDB3\\uDDBC\\uDDBD]|\\uDD1D\\u200D\\uD83E\\uDDD1\\uD83C[\\uDFFB-\\uDFFF])))?|\\uDFFE(?:\\u200D(?:[\\u2695\\u2696\\u2708]\\uFE0F?|\\u2764\\uFE0F?\\u200D(?:\\uD83D\\uDC8B\\u200D)?\\uD83E\\uDDD1\\uD83C[\\uDFFB-\\uDFFD\\uDFFF]|\\uD83C[\\uDF3E\\uDF73\\uDF7C\\uDF84\\uDF93\\uDFA4\\uDFA8\\uDFEB\\uDFED]|\\uD83D[\\uDCBB\\uDCBC\\uDD27\\uDD2C\\uDE80\\uDE92]|\\uD83E(?:[\\uDDAF-\\uDDB3\\uDDBC\\uDDBD]|\\uDD1D\\u200D\\uD83E\\uDDD1\\uD83C[\\uDFFB-\\uDFFF])))?|\\uDFFF(?:\\u200D(?:[\\u2695\\u2696\\u2708]\\uFE0F?|\\u2764\\uFE0F?\\u200D(?:\\uD83D\\uDC8B\\u200D)?\\uD83E\\uDDD1\\uD83C[\\uDFFB-\\uDFFE]|\\uD83C[\\uDF3E\\uDF73\\uDF7C\\uDF84\\uDF93\\uDFA4\\uDFA8\\uDFEB\\uDFED]|\\uD83D[\\uDCBB\\uDCBC\\uDD27\\uDD2C\\uDE80\\uDE92]|\\uD83E(?:[\\uDDAF-\\uDDB3\\uDDBC\\uDDBD]|\\uDD1D\\u200D\\uD83E\\uDDD1\\uD83C[\\uDFFB-\\uDFFF])))?))?|\\uDEF1(?:\\uD83C(?:\\uDFFB(?:\\u200D\\uD83E\\uDEF2\\uD83C[\\uDFFC-\\uDFFF])?|\\uDFFC(?:\\u200D\\uD83E\\uDEF2\\uD83C[\
\\uDFFB\\uDFFD-\\uDFFF])?|\\uDFFD(?:\\u200D\\uD83E\\uDEF2\\uD83C[\\uDFFB\\uDFFC\\uDFFE\\uDFFF])?|\\uDFFE(?:\\u200D\\uD83E\\uDEF2\\uD83C[\\uDFFB-\\uDFFD\\uDFFF])?|\\uDFFF(?:\\u200D\\uD83E\\uDEF2\\uD83C[\\uDFFB-\\uDFFE])?))?)/g.test(e)),r&&(a=a||/[\\u1D00-\\u1D7F\\u1D80-\\u1DBF\\u1DC0-\\u1DFF\\u20A0-\\u20CF\\u20D0-\\u20FF\\u2100-\\u214F\\u2150-\\u218F\\u2190-\\u21FF\\u2200-\\u22FF\\u2300-\\u23FF\\u2400-\\u243F\\u2440-\\u245F\\u2460-\\u24FF\\u2500-\\u257F\\u2580-\\u259F\\u25A0-\\u25FF\\u2600-\\u26FF\\u2700-\\u27BF\\uE000-\\uF8FF]/g.test(e)||/[\\uDB80-\\uDBBF][\\uDC00-\\uDFFF]/g.test(e)||/[\\xAD\\u0600-\\u0605\\u061C\\u06DD\\u070F\\u08E2\\u180E\\u200B-\\u200F\\u202A-\\u202E\\u2060-\\u2064\\u2066-\\u206F\\uFEFF\\uFFF9-\\uFFFB]|\\uD804[\\uDCBD\\uDCCD]|\\uD80D[\\uDC30-\\uDC38]|\\uD82F[\\uDCA0-\\uDCA3]|\\uD834[\\uDD73-\\uDD7A]|\\uDB40[\\uDC01\\uDC20-\\uDC7F]/g.test(e)),t?a||/[\\u2000-\\u206F\\u2E00-\\u2E7F\\\\'!"#$%&\\xa3\\xa2\\xa5\\xa7\\u20ac()*+,\\-.\\/:;<=>?@\\[\\]^_\`{|}~\\xb1]/g.test(e):a};function Fl(e){var n=1<arguments.length&&void 0!==arguments[1]?arguments[1]:.15,a=2<arguments.length&&void 0!==argument\
s[2]?arguments[2]:3,o=e.actualNode.nodeValue.trim();if(!Eu(o)||yl(o,{emoji:!0,nonBmp:!0}))return!1;var i,u=sa.get("canvasContext",(function(){return r.createElement("canvas").getContext("2d",{willReadFrequently:!0})})),l=u.canvas;if((i=((i=sa.get("fonts",(function(){return{}})))[m=t.getComputedStyle(e.parent.actualNode).getPropertyValue("font-family")]||(i[m]={occurrences:0,numLigatures:0}),i[m])).occurrences>=a){if(i.numLigatures/i.occurrences==1)return!0;if(0===i.numLigatures)return!1}i.occurrences++;var s="".concat(a=30,"px ").concat(m),c=(u.font=s,o.charAt(0)),d=u.measureText(c).width;if(0===d)return i.numLigatures++,!0;d<30&&(d*=p=30/d,s="".concat(a*=p,"px ").concat(m)),l.width=d,l.height=a,u.font=s,u.textAlign="left",u.textBaseline="top",u.fillText(c,0,0);var p=new Uint32Array(u.getImageData(0,0,d,a).data.buffer);if(!p.some((function(e){return e})))return i.numLigatures++,!0;u.clearRect(0,0,d,a),u.fillText(o,0,0);var f=new Uint32Array(u.getImageData(0,0,d,a).data.buffer),m=p.redu\
ce((function(e,t,n){return 0===t&&0===f[n]||0!==t&&0!==f[n]?e:++e}),0);l=o.split("").reduce((function(e,t){return e+u.measureText(t).width}),0),s=u.measureText(o).width;return n<=m/p.length&&n<=1-s/l&&(i.numLigatures++,!0)}function wl(e){var t,n,r,a,i,u=function(e,t){return t.startNode||(t=$({startNode:e},t)),1===e.props.nodeType&&t.inLabelledByContext&&void 0===t.includeHidden&&(t=$({includeHidden:!Xu(e)},t)),t}(e,1<arguments.length&&void 0!==arguments[1]?arguments[1]:{});return function(e,t){if(e&&1===e.props.nodeType&&!t.includeHidden)return!Xu(e)}(e,u)||(t=e,n=(i=u).ignoreIconLigature,r=i.pixelThreshold,a=null!=(a=i.occurrenceThreshold)?a:i.occuranceThreshold,3===t.props.nodeType&&n&&Fl(t,r,a))?"":(i=[ru,au,bl,cl,pl,El,Gu].reduce((function(t,n){return""!==(t=u.startNode===e?Eu(t):t)?t:n(e,u)}),""),u.debug&&o.log(i||"{empty-value}",e.actualNode,u),i)}function El(e){return 3!==e.props.nodeType?"":e.props.nodeValue}wl.alreadyProcessed=function(e,t){return t.processed=t.processed||[],!\
!t.processed.includes(e)||(t.processed.push(e),!1)};var Cl=function(e,t){var n=t.emoji,r=t.nonBmp;t=t.punctuations;return n&&(e=e.replace(/[#*0-9]\\uFE0F?\\u20E3|[\\xA9\\xAE\\u203C\\u2049\\u2122\\u2139\\u2194-\\u2199\\u21A9\\u21AA\\u231A\\u231B\\u2328\\u23CF\\u23ED-\\u23EF\\u23F1\\u23F2\\u23F8-\\u23FA\\u24C2\\u25AA\\u25AB\\u25B6\\u25C0\\u25FB\\u25FC\\u25FE\\u2600-\\u2604\\u260E\\u2611\\u2614\\u2615\\u2618\\u2620\\u2622\\u2623\\u2626\\u262A\\u262E\\u262F\\u2638-\\u263A\\u2640\\u2642\\u2648-\\u2653\\u265F\\u2660\\u2663\\u2665\\u2666\\u2668\\u267B\\u267E\\u267F\\u2692\\u2694-\\u2697\\u2699\\u269B\\u269C\\u26A0\\u26A7\\u26AA\\u26B0\\u26B1\\u26BD\\u26BE\\u26C4\\u26C8\\u26CF\\u26D1\\u26D3\\u26E9\\u26F0-\\u26F5\\u26F7\\u26F8\\u26FA\\u2702\\u2708\\u2709\\u270F\\u2712\\u2714\\u2716\\u271D\\u2721\\u2733\\u2734\\u2744\\u2747\\u2757\\u2763\\u27A1\\u2934\\u2935\\u2B05-\\u2B07\\u2B1B\\u2B1C\\u2B55\\u3030\\u303D\\u3297\\u3299]\\uFE0F?|[\\u261D\\u270C\\u270D](?:\\uFE0F|\\uD83C[\\uDFFB-\\uDFFF])?|[\\u270A\\u270B](?:\\uD83C[\\uDFFB-\\uDFFF])?|[\\u23E9-\\u23EC\\u23F0\\u23F3\\u25FD\\u2693\\u26A1\\u26AB\\u26C5\\u26CE\\u26D4\\u26EA\\u26FD\\u\
2705\\u2728\\u274C\\u274E\\u2753-\\u2755\\u2795-\\u2797\\u27B0\\u27BF\\u2B50]|\\u26F9(?:\\uFE0F|\\uD83C[\\uDFFB-\\uDFFF])?(?:\\u200D[\\u2640\\u2642]\\uFE0F?)?|\\u2764\\uFE0F?(?:\\u200D(?:\\uD83D\\uDD25|\\uD83E\\uDE79))?|\\uD83C(?:[\\uDC04\\uDD70\\uDD71\\uDD7E\\uDD7F\\uDE02\\uDE37\\uDF21\\uDF24-\\uDF2C\\uDF36\\uDF7D\\uDF96\\uDF97\\uDF99-\\uDF9B\\uDF9E\\uDF9F\\uDFCD\\uDFCE\\uDFD4-\\uDFDF\\uDFF5\\uDFF7]\\uFE0F?|[\\uDF85\\uDFC2\\uDFC7](?:\\uD83C[\\uDFFB-\\uDFFF])?|[\\uDFC3\\uDFC4\\uDFCA](?:\\uD83C[\\uDFFB-\\uDFFF])?(?:\\u200D[\\u2640\\u2642]\\uFE0F?)?|[\\uDFCB\\uDFCC](?:\\uFE0F|\\uD83C[\\uDFFB-\\uDFFF])?(?:\\u200D[\\u2640\\u2642]\\uFE0F?)?|[\\uDCCF\\uDD8E\\uDD91-\\uDD9A\\uDE01\\uDE1A\\uDE2F\\uDE32-\\uDE36\\uDE38-\\uDE3A\\uDE50\\uDE51\\uDF00-\\uDF20\\uDF2D-\\uDF35\\uDF37-\\uDF7C\\uDF7E-\\uDF84\\uDF86-\\uDF93\\uDFA0-\\uDFC1\\uDFC5\\uDFC6\\uDFC8\\uDFC9\\uDFCF-\\uDFD3\\uDFE0-\\uDFF0\\uDFF8-\\uDFFF]|\\uDDE6\\uD83C[\\uDDE8-\\uDDEC\\uDDEE\\uDDF1\\uDDF2\\uDDF4\\uDDF6-\\uDDFA\\uDDFC\\uDDFD\\uDDFF]|\\uDDE7\\uD83C[\\uDDE6\\uDDE7\\uDDE9-\\uDDEF\\uDDF1-\\uDDF4\\uDDF6-\\uDDF9\\uDDFB\\uDDFC\\uDDFE\\uDDFF]|\\uDDE8\\uD83C[\\uDDE6\\uDDE8\\uDDE9\\uDDE\
B-\\uDDEE\\uDDF0-\\uDDF5\\uDDF7\\uDDFA-\\uDDFF]|\\uDDE9\\uD83C[\\uDDEA\\uDDEC\\uDDEF\\uDDF0\\uDDF2\\uDDF4\\uDDFF]|\\uDDEA\\uD83C[\\uDDE6\\uDDE8\\uDDEA\\uDDEC\\uDDED\\uDDF7-\\uDDFA]|\\uDDEB\\uD83C[\\uDDEE-\\uDDF0\\uDDF2\\uDDF4\\uDDF7]|\\uDDEC\\uD83C[\\uDDE6\\uDDE7\\uDDE9-\\uDDEE\\uDDF1-\\uDDF3\\uDDF5-\\uDDFA\\uDDFC\\uDDFE]|\\uDDED\\uD83C[\\uDDF0\\uDDF2\\uDDF3\\uDDF7\\uDDF9\\uDDFA]|\\uDDEE\\uD83C[\\uDDE8-\\uDDEA\\uDDF1-\\uDDF4\\uDDF6-\\uDDF9]|\\uDDEF\\uD83C[\\uDDEA\\uDDF2\\uDDF4\\uDDF5]|\\uDDF0\\uD83C[\\uDDEA\\uDDEC-\\uDDEE\\uDDF2\\uDDF3\\uDDF5\\uDDF7\\uDDFC\\uDDFE\\uDDFF]|\\uDDF1\\uD83C[\\uDDE6-\\uDDE8\\uDDEE\\uDDF0\\uDDF7-\\uDDFB\\uDDFE]|\\uDDF2\\uD83C[\\uDDE6\\uDDE8-\\uDDED\\uDDF0-\\uDDFF]|\\uDDF3\\uD83C[\\uDDE6\\uDDE8\\uDDEA-\\uDDEC\\uDDEE\\uDDF1\\uDDF4\\uDDF5\\uDDF7\\uDDFA\\uDDFF]|\\uDDF4\\uD83C\\uDDF2|\\uDDF5\\uD83C[\\uDDE6\\uDDEA-\\uDDED\\uDDF0-\\uDDF3\\uDDF7-\\uDDF9\\uDDFC\\uDDFE]|\\uDDF6\\uD83C\\uDDE6|\\uDDF7\\uD83C[\\uDDEA\\uDDF4\\uDDF8\\uDDFA\\uDDFC]|\\uDDF8\\uD83C[\\uDDE6-\\uDDEA\\uDDEC-\\uDDF4\\uDDF7-\\uDDF9\\uDDFB\\uDDFD-\\uDDFF]|\\uDDF9\\uD83C[\\uDDE6\\uDDE8\\uDDE9\\uDDEB-\\uDDED\\uDDEF-\\uDDF4\\uDDF7\\uDDF9\\uDDFB\\uDDFC\\u\
DDFF]|\\uDDFA\\uD83C[\\uDDE6\\uDDEC\\uDDF2\\uDDF3\\uDDF8\\uDDFE\\uDDFF]|\\uDDFB\\uD83C[\\uDDE6\\uDDE8\\uDDEA\\uDDEC\\uDDEE\\uDDF3\\uDDFA]|\\uDDFC\\uD83C[\\uDDEB\\uDDF8]|\\uDDFD\\uD83C\\uDDF0|\\uDDFE\\uD83C[\\uDDEA\\uDDF9]|\\uDDFF\\uD83C[\\uDDE6\\uDDF2\\uDDFC]|\\uDFF3\\uFE0F?(?:\\u200D(?:\\u26A7\\uFE0F?|\\uD83C\\uDF08))?|\\uDFF4(?:\\u200D\\u2620\\uFE0F?|\\uDB40\\uDC67\\uDB40\\uDC62\\uDB40(?:\\uDC65\\uDB40\\uDC6E\\uDB40\\uDC67|\\uDC73\\uDB40\\uDC63\\uDB40\\uDC74|\\uDC77\\uDB40\\uDC6C\\uDB40\\uDC73)\\uDB40\\uDC7F)?)|\\uD83D(?:[\\uDC08\\uDC26](?:\\u200D\\u2B1B)?|[\\uDC3F\\uDCFD\\uDD49\\uDD4A\\uDD6F\\uDD70\\uDD73\\uDD76-\\uDD79\\uDD87\\uDD8A-\\uDD8D\\uDDA5\\uDDA8\\uDDB1\\uDDB2\\uDDBC\\uDDC2-\\uDDC4\\uDDD1-\\uDDD3\\uDDDC-\\uDDDE\\uDDE1\\uDDE3\\uDDE8\\uDDEF\\uDDF3\\uDDFA\\uDECB\\uDECD-\\uDECF\\uDEE0-\\uDEE5\\uDEE9\\uDEF0\\uDEF3]\\uFE0F?|[\\uDC42\\uDC43\\uDC46-\\uDC50\\uDC66\\uDC67\\uDC6B-\\uDC6D\\uDC72\\uDC74-\\uDC76\\uDC78\\uDC7C\\uDC83\\uDC85\\uDC8F\\uDC91\\uDCAA\\uDD7A\\uDD95\\uDD96\\uDE4C\\uDE4F\\uDEC0\\uDECC](?:\\uD83C[\\uDFFB-\\uDFFF])?|[\\uDC6E\\uDC70\\uDC71\\uDC73\\uDC77\\uDC81\\uDC82\\uDC86\\uDC87\\uDE45-\\uDE47\\uDE4B\\uDE4D\\uDE4E\
\\uDEA3\\uDEB4-\\uDEB6](?:\\uD83C[\\uDFFB-\\uDFFF])?(?:\\u200D[\\u2640\\u2642]\\uFE0F?)?|[\\uDD74\\uDD90](?:\\uFE0F|\\uD83C[\\uDFFB-\\uDFFF])?|[\\uDC00-\\uDC07\\uDC09-\\uDC14\\uDC16-\\uDC25\\uDC27-\\uDC3A\\uDC3C-\\uDC3E\\uDC40\\uDC44\\uDC45\\uDC51-\\uDC65\\uDC6A\\uDC79-\\uDC7B\\uDC7D-\\uDC80\\uDC84\\uDC88-\\uDC8E\\uDC90\\uDC92-\\uDCA9\\uDCAB-\\uDCFC\\uDCFF-\\uDD3D\\uDD4B-\\uDD4E\\uDD50-\\uDD67\\uDDA4\\uDDFB-\\uDE2D\\uDE2F-\\uDE34\\uDE37-\\uDE44\\uDE48-\\uDE4A\\uDE80-\\uDEA2\\uDEA4-\\uDEB3\\uDEB7-\\uDEBF\\uDEC1-\\uDEC5\\uDED0-\\uDED2\\uDED5-\\uDED7\\uDEDC-\\uDEDF\\uDEEB\\uDEEC\\uDEF4-\\uDEFC\\uDFE0-\\uDFEB\\uDFF0]|\\uDC15(?:\\u200D\\uD83E\\uDDBA)?|\\uDC3B(?:\\u200D\\u2744\\uFE0F?)?|\\uDC41\\uFE0F?(?:\\u200D\\uD83D\\uDDE8\\uFE0F?)?|\\uDC68(?:\\u200D(?:[\\u2695\\u2696\\u2708]\\uFE0F?|\\u2764\\uFE0F?\\u200D\\uD83D(?:\\uDC8B\\u200D\\uD83D)?\\uDC68|\\uD83C[\\uDF3E\\uDF73\\uDF7C\\uDF93\\uDFA4\\uDFA8\\uDFEB\\uDFED]|\\uD83D(?:[\\uDC68\\uDC69]\\u200D\\uD83D(?:\\uDC66(?:\\u200D\\uD83D\\uDC66)?|\\uDC67(?:\\u200D\\uD83D[\\uDC66\\uDC67])?)|[\\uDCBB\\uDCBC\\uDD27\\uDD2C\\uDE80\\uDE92]|\\uDC66(?:\\u200D\\uD83D\\uDC66)?|\\uDC67(?:\\u200D\\uD83\
D[\\uDC66\\uDC67])?)|\\uD83E[\\uDDAF-\\uDDB3\\uDDBC\\uDDBD])|\\uD83C(?:\\uDFFB(?:\\u200D(?:[\\u2695\\u2696\\u2708]\\uFE0F?|\\u2764\\uFE0F?\\u200D\\uD83D(?:\\uDC8B\\u200D\\uD83D)?\\uDC68\\uD83C[\\uDFFB-\\uDFFF]|\\uD83C[\\uDF3E\\uDF73\\uDF7C\\uDF93\\uDFA4\\uDFA8\\uDFEB\\uDFED]|\\uD83D[\\uDCBB\\uDCBC\\uDD27\\uDD2C\\uDE80\\uDE92]|\\uD83E(?:[\\uDDAF-\\uDDB3\\uDDBC\\uDDBD]|\\uDD1D\\u200D\\uD83D\\uDC68\\uD83C[\\uDFFC-\\uDFFF])))?|\\uDFFC(?:\\u200D(?:[\\u2695\\u2696\\u2708]\\uFE0F?|\\u2764\\uFE0F?\\u200D\\uD83D(?:\\uDC8B\\u200D\\uD83D)?\\uDC68\\uD83C[\\uDFFB-\\uDFFF]|\\uD83C[\\uDF3E\\uDF73\\uDF7C\\uDF93\\uDFA4\\uDFA8\\uDFEB\\uDFED]|\\uD83D[\\uDCBB\\uDCBC\\uDD27\\uDD2C\\uDE80\\uDE92]|\\uD83E(?:[\\uDDAF-\\uDDB3\\uDDBC\\uDDBD]|\\uDD1D\\u200D\\uD83D\\uDC68\\uD83C[\\uDFFB\\uDFFD-\\uDFFF])))?|\\uDFFD(?:\\u200D(?:[\\u2695\\u2696\\u2708]\\uFE0F?|\\u2764\\uFE0F?\\u200D\\uD83D(?:\\uDC8B\\u200D\\uD83D)?\\uDC68\\uD83C[\\uDFFB-\\uDFFF]|\\uD83C[\\uDF3E\\uDF73\\uDF7C\\uDF93\\uDFA4\\uDFA8\\uDFEB\\uDFED]|\\uD83D[\\uDCBB\\uDCBC\\uDD27\\uDD2C\\uDE80\\uDE92]|\\uD83E(?:[\\uDDAF-\\uDDB3\\uDDBC\\uDDBD]|\\uDD1D\\u200D\\uD83D\\uDC68\\uD83C[\\uDFFB\\uDFFC\\uDFF\
E\\uDFFF])))?|\\uDFFE(?:\\u200D(?:[\\u2695\\u2696\\u2708]\\uFE0F?|\\u2764\\uFE0F?\\u200D\\uD83D(?:\\uDC8B\\u200D\\uD83D)?\\uDC68\\uD83C[\\uDFFB-\\uDFFF]|\\uD83C[\\uDF3E\\uDF73\\uDF7C\\uDF93\\uDFA4\\uDFA8\\uDFEB\\uDFED]|\\uD83D[\\uDCBB\\uDCBC\\uDD27\\uDD2C\\uDE80\\uDE92]|\\uD83E(?:[\\uDDAF-\\uDDB3\\uDDBC\\uDDBD]|\\uDD1D\\u200D\\uD83D\\uDC68\\uD83C[\\uDFFB-\\uDFFD\\uDFFF])))?|\\uDFFF(?:\\u200D(?:[\\u2695\\u2696\\u2708]\\uFE0F?|\\u2764\\uFE0F?\\u200D\\uD83D(?:\\uDC8B\\u200D\\uD83D)?\\uDC68\\uD83C[\\uDFFB-\\uDFFF]|\\uD83C[\\uDF3E\\uDF73\\uDF7C\\uDF93\\uDFA4\\uDFA8\\uDFEB\\uDFED]|\\uD83D[\\uDCBB\\uDCBC\\uDD27\\uDD2C\\uDE80\\uDE92]|\\uD83E(?:[\\uDDAF-\\uDDB3\\uDDBC\\uDDBD]|\\uDD1D\\u200D\\uD83D\\uDC68\\uD83C[\\uDFFB-\\uDFFE])))?))?|\\uDC69(?:\\u200D(?:[\\u2695\\u2696\\u2708]\\uFE0F?|\\u2764\\uFE0F?\\u200D\\uD83D(?:\\uDC8B\\u200D\\uD83D)?[\\uDC68\\uDC69]|\\uD83C[\\uDF3E\\uDF73\\uDF7C\\uDF93\\uDFA4\\uDFA8\\uDFEB\\uDFED]|\\uD83D(?:[\\uDCBB\\uDCBC\\uDD27\\uDD2C\\uDE80\\uDE92]|\\uDC66(?:\\u200D\\uD83D\\uDC66)?|\\uDC67(?:\\u200D\\uD83D[\\uDC66\\uDC67])?|\\uDC69\\u200D\\uD83D(?:\\uDC66(?:\\u200D\\uD83D\\uDC66)?|\\uDC67(?:\\u200D\\uD83D[\\\
uDC66\\uDC67])?))|\\uD83E[\\uDDAF-\\uDDB3\\uDDBC\\uDDBD])|\\uD83C(?:\\uDFFB(?:\\u200D(?:[\\u2695\\u2696\\u2708]\\uFE0F?|\\u2764\\uFE0F?\\u200D\\uD83D(?:[\\uDC68\\uDC69]|\\uDC8B\\u200D\\uD83D[\\uDC68\\uDC69])\\uD83C[\\uDFFB-\\uDFFF]|\\uD83C[\\uDF3E\\uDF73\\uDF7C\\uDF93\\uDFA4\\uDFA8\\uDFEB\\uDFED]|\\uD83D[\\uDCBB\\uDCBC\\uDD27\\uDD2C\\uDE80\\uDE92]|\\uD83E(?:[\\uDDAF-\\uDDB3\\uDDBC\\uDDBD]|\\uDD1D\\u200D\\uD83D[\\uDC68\\uDC69]\\uD83C[\\uDFFC-\\uDFFF])))?|\\uDFFC(?:\\u200D(?:[\\u2695\\u2696\\u2708]\\uFE0F?|\\u2764\\uFE0F?\\u200D\\uD83D(?:[\\uDC68\\uDC69]|\\uDC8B\\u200D\\uD83D[\\uDC68\\uDC69])\\uD83C[\\uDFFB-\\uDFFF]|\\uD83C[\\uDF3E\\uDF73\\uDF7C\\uDF93\\uDFA4\\uDFA8\\uDFEB\\uDFED]|\\uD83D[\\uDCBB\\uDCBC\\uDD27\\uDD2C\\uDE80\\uDE92]|\\uD83E(?:[\\uDDAF-\\uDDB3\\uDDBC\\uDDBD]|\\uDD1D\\u200D\\uD83D[\\uDC68\\uDC69]\\uD83C[\\uDFFB\\uDFFD-\\uDFFF])))?|\\uDFFD(?:\\u200D(?:[\\u2695\\u2696\\u2708]\\uFE0F?|\\u2764\\uFE0F?\\u200D\\uD83D(?:[\\uDC68\\uDC69]|\\uDC8B\\u200D\\uD83D[\\uDC68\\uDC69])\\uD83C[\\uDFFB-\\uDFFF]|\\uD83C[\\uDF3E\\uDF73\\uDF7C\\uDF93\\uDFA4\\uDFA8\\uDFEB\\uDFED]|\\uD83D[\\uDCBB\\uDCBC\\uDD27\\uDD2C\\uDE80\\uDE92]|\\uD83\
E(?:[\\uDDAF-\\uDDB3\\uDDBC\\uDDBD]|\\uDD1D\\u200D\\uD83D[\\uDC68\\uDC69]\\uD83C[\\uDFFB\\uDFFC\\uDFFE\\uDFFF])))?|\\uDFFE(?:\\u200D(?:[\\u2695\\u2696\\u2708]\\uFE0F?|\\u2764\\uFE0F?\\u200D\\uD83D(?:[\\uDC68\\uDC69]|\\uDC8B\\u200D\\uD83D[\\uDC68\\uDC69])\\uD83C[\\uDFFB-\\uDFFF]|\\uD83C[\\uDF3E\\uDF73\\uDF7C\\uDF93\\uDFA4\\uDFA8\\uDFEB\\uDFED]|\\uD83D[\\uDCBB\\uDCBC\\uDD27\\uDD2C\\uDE80\\uDE92]|\\uD83E(?:[\\uDDAF-\\uDDB3\\uDDBC\\uDDBD]|\\uDD1D\\u200D\\uD83D[\\uDC68\\uDC69]\\uD83C[\\uDFFB-\\uDFFD\\uDFFF])))?|\\uDFFF(?:\\u200D(?:[\\u2695\\u2696\\u2708]\\uFE0F?|\\u2764\\uFE0F?\\u200D\\uD83D(?:[\\uDC68\\uDC69]|\\uDC8B\\u200D\\uD83D[\\uDC68\\uDC69])\\uD83C[\\uDFFB-\\uDFFF]|\\uD83C[\\uDF3E\\uDF73\\uDF7C\\uDF93\\uDFA4\\uDFA8\\uDFEB\\uDFED]|\\uD83D[\\uDCBB\\uDCBC\\uDD27\\uDD2C\\uDE80\\uDE92]|\\uD83E(?:[\\uDDAF-\\uDDB3\\uDDBC\\uDDBD]|\\uDD1D\\u200D\\uD83D[\\uDC68\\uDC69]\\uD83C[\\uDFFB-\\uDFFE])))?))?|\\uDC6F(?:\\u200D[\\u2640\\u2642]\\uFE0F?)?|\\uDD75(?:\\uFE0F|\\uD83C[\\uDFFB-\\uDFFF])?(?:\\u200D[\\u2640\\u2642]\\uFE0F?)?|\\uDE2E(?:\\u200D\\uD83D\\uDCA8)?|\\uDE35(?:\\u200D\\uD83D\\uDCAB)?|\\uDE36(?:\\u200D\\uD83C\\uDF2B\\uFE0F?)?)\
|\\uD83E(?:[\\uDD0C\\uDD0F\\uDD18-\\uDD1F\\uDD30-\\uDD34\\uDD36\\uDD77\\uDDB5\\uDDB6\\uDDBB\\uDDD2\\uDDD3\\uDDD5\\uDEC3-\\uDEC5\\uDEF0\\uDEF2-\\uDEF8](?:\\uD83C[\\uDFFB-\\uDFFF])?|[\\uDD26\\uDD35\\uDD37-\\uDD39\\uDD3D\\uDD3E\\uDDB8\\uDDB9\\uDDCD-\\uDDCF\\uDDD4\\uDDD6-\\uDDDD](?:\\uD83C[\\uDFFB-\\uDFFF])?(?:\\u200D[\\u2640\\u2642]\\uFE0F?)?|[\\uDDDE\\uDDDF](?:\\u200D[\\u2640\\u2642]\\uFE0F?)?|[\\uDD0D\\uDD0E\\uDD10-\\uDD17\\uDD20-\\uDD25\\uDD27-\\uDD2F\\uDD3A\\uDD3F-\\uDD45\\uDD47-\\uDD76\\uDD78-\\uDDB4\\uDDB7\\uDDBA\\uDDBC-\\uDDCC\\uDDD0\\uDDE0-\\uDDFF\\uDE70-\\uDE7C\\uDE80-\\uDE88\\uDE90-\\uDEBD\\uDEBF-\\uDEC2\\uDECE-\\uDEDB\\uDEE0-\\uDEE8]|\\uDD3C(?:\\u200D[\\u2640\\u2642]\\uFE0F?|\\uD83C[\\uDFFB-\\uDFFF])?|\\uDDD1(?:\\u200D(?:[\\u2695\\u2696\\u2708]\\uFE0F?|\\uD83C[\\uDF3E\\uDF73\\uDF7C\\uDF84\\uDF93\\uDFA4\\uDFA8\\uDFEB\\uDFED]|\\uD83D[\\uDCBB\\uDCBC\\uDD27\\uDD2C\\uDE80\\uDE92]|\\uD83E(?:[\\uDDAF-\\uDDB3\\uDDBC\\uDDBD]|\\uDD1D\\u200D\\uD83E\\uDDD1))|\\uD83C(?:\\uDFFB(?:\\u200D(?:[\\u2695\\u2696\\u2708]\\uFE0F?|\\u2764\\uFE0F?\\u200D(?:\\uD83D\\uDC8B\\u200D)?\\uD83E\\uDDD1\\uD83C[\\uDFFC-\\uDFFF]|\\uD83C[\\uDF3E\\uDF73\\uDF\
7C\\uDF84\\uDF93\\uDFA4\\uDFA8\\uDFEB\\uDFED]|\\uD83D[\\uDCBB\\uDCBC\\uDD27\\uDD2C\\uDE80\\uDE92]|\\uD83E(?:[\\uDDAF-\\uDDB3\\uDDBC\\uDDBD]|\\uDD1D\\u200D\\uD83E\\uDDD1\\uD83C[\\uDFFB-\\uDFFF])))?|\\uDFFC(?:\\u200D(?:[\\u2695\\u2696\\u2708]\\uFE0F?|\\u2764\\uFE0F?\\u200D(?:\\uD83D\\uDC8B\\u200D)?\\uD83E\\uDDD1\\uD83C[\\uDFFB\\uDFFD-\\uDFFF]|\\uD83C[\\uDF3E\\uDF73\\uDF7C\\uDF84\\uDF93\\uDFA4\\uDFA8\\uDFEB\\uDFED]|\\uD83D[\\uDCBB\\uDCBC\\uDD27\\uDD2C\\uDE80\\uDE92]|\\uD83E(?:[\\uDDAF-\\uDDB3\\uDDBC\\uDDBD]|\\uDD1D\\u200D\\uD83E\\uDDD1\\uD83C[\\uDFFB-\\uDFFF])))?|\\uDFFD(?:\\u200D(?:[\\u2695\\u2696\\u2708]\\uFE0F?|\\u2764\\uFE0F?\\u200D(?:\\uD83D\\uDC8B\\u200D)?\\uD83E\\uDDD1\\uD83C[\\uDFFB\\uDFFC\\uDFFE\\uDFFF]|\\uD83C[\\uDF3E\\uDF73\\uDF7C\\uDF84\\uDF93\\uDFA4\\uDFA8\\uDFEB\\uDFED]|\\uD83D[\\uDCBB\\uDCBC\\uDD27\\uDD2C\\uDE80\\uDE92]|\\uD83E(?:[\\uDDAF-\\uDDB3\\uDDBC\\uDDBD]|\\uDD1D\\u200D\\uD83E\\uDDD1\\uD83C[\\uDFFB-\\uDFFF])))?|\\uDFFE(?:\\u200D(?:[\\u2695\\u2696\\u2708]\\uFE0F?|\\u2764\\uFE0F?\\u200D(?:\\uD83D\\uDC8B\\u200D)?\\uD83E\\uDDD1\\uD83C[\\uDFFB-\\uDFFD\\uDFFF]|\\uD83C[\\uDF3E\\uDF73\\uDF7C\\uDF84\\uDF93\\uDFA4\\uDFA8\
\\uDFEB\\uDFED]|\\uD83D[\\uDCBB\\uDCBC\\uDD27\\uDD2C\\uDE80\\uDE92]|\\uD83E(?:[\\uDDAF-\\uDDB3\\uDDBC\\uDDBD]|\\uDD1D\\u200D\\uD83E\\uDDD1\\uD83C[\\uDFFB-\\uDFFF])))?|\\uDFFF(?:\\u200D(?:[\\u2695\\u2696\\u2708]\\uFE0F?|\\u2764\\uFE0F?\\u200D(?:\\uD83D\\uDC8B\\u200D)?\\uD83E\\uDDD1\\uD83C[\\uDFFB-\\uDFFE]|\\uD83C[\\uDF3E\\uDF73\\uDF7C\\uDF84\\uDF93\\uDFA4\\uDFA8\\uDFEB\\uDFED]|\\uD83D[\\uDCBB\\uDCBC\\uDD27\\uDD2C\\uDE80\\uDE92]|\\uD83E(?:[\\uDDAF-\\uDDB3\\uDDBC\\uDDBD]|\\uDD1D\\u200D\\uD83E\\uDDD1\\uD83C[\\uDFFB-\\uDFFF])))?))?|\\uDEF1(?:\\uD83C(?:\\uDFFB(?:\\u200D\\uD83E\\uDEF2\\uD83C[\\uDFFC-\\uDFFF])?|\\uDFFC(?:\\u200D\\uD83E\\uDEF2\\uD83C[\\uDFFB\\uDFFD-\\uDFFF])?|\\uDFFD(?:\\u200D\\uD83E\\uDEF2\\uD83C[\\uDFFB\\uDFFC\\uDFFE\\uDFFF])?|\\uDFFE(?:\\u200D\\uD83E\\uDEF2\\uD83C[\\uDFFB-\\uDFFD\\uDFFF])?|\\uDFFF(?:\\u200D\\uD83E\\uDEF2\\uD83C[\\uDFFB-\\uDFFE])?))?)/g,"")),r&&(e=e.replace(/[\\u1D00-\\u1D7F\\u1D80-\\u1DBF\\u1DC0-\\u1DFF\\u20A0-\\u20CF\\u20D0-\\u20FF\\u2100-\\u214F\\u2150-\\u218F\\u2190-\\u21FF\\u2200-\\u22FF\\u2300-\\u23FF\\u2400-\\u243F\\u2440-\\u245F\\u2460-\\u24FF\\u2500-\\u257F\\u2580-\\u259F\\u25A0-\\u25FF\\\
u2600-\\u26FF\\u2700-\\u27BF\\uE000-\\uF8FF]/g,"").replace(/[\\uDB80-\\uDBBF][\\uDC00-\\uDFFF]/g,"").replace(/[\\xAD\\u0600-\\u0605\\u061C\\u06DD\\u070F\\u08E2\\u180E\\u200B-\\u200F\\u202A-\\u202E\\u2060-\\u2064\\u2066-\\u206F\\uFEFF\\uFFF9-\\uFFFB]|\\uD804[\\uDCBD\\uDCCD]|\\uD80D[\\uDC30-\\uDC38]|\\uD82F[\\uDCA0-\\uDCA3]|\\uD834[\\uDD73-\\uDD7A]|\\uDB40[\\uDC01\\uDC20-\\uDC7F]/g,"")),t?e.replace(/[\\u2000-\\u206F\\u2E00-\\u2E7F\\\\'!"#$%&\\xa3\\xa2\\xa5\\xa7\\u20ac()*+,\\-.\\/:;<=>?@\\[\\]^_\`{|}~\\xb1]/g,""):e},xl=function(e){return e.length&&!["x","i"].includes(e)&&(e=Cl(e,{emoji:!0,nonBmp:!0,punctuations:!0}),Eu(e))?1:0},Al={stateTerms:["on","off"],standaloneTerms:["name","honorific-prefix","given-name","additional-name","family-name","honorific-suffix","nickname","username","new-password","current-password","organization-title","organization","street-address","address-line1","address-line2","address-line3","address-level4","address-level3","address-level2","address-level1","country","country-name","postal-code","cc-name","cc-given-name","cc\
-additional-name","cc-family-name","cc-number","cc-exp","cc-exp-month","cc-exp-year","cc-csc","cc-type","transaction-currency","transaction-amount","language","bday","bday-day","bday-month","bday-year","sex","url","photo","one-time-code"],qualifiers:["home","work","mobile","fax","pager"],qualifiedTerms:["tel","tel-country-code","tel-national","tel-area-code","tel-local","tel-local-prefix","tel-local-suffix","tel-extension","email","impp"],locations:["billing","shipping"]},kl=function(e){var t=void 0!==(t=(i=1<arguments.length&&void 0!==arguments[1]?arguments[1]:{}).looseTyped)&&t,n=void 0===(n=i.stateTerms)?[]:n,r=void 0===(r=i.locations)?[]:r,a=void 0===(a=i.qualifiers)?[]:a,o=void 0===(o=i.standaloneTerms)?[]:o,i=void 0===(i=i.qualifiedTerms)?[]:i;return e=e.toLowerCase().trim(),!(!(n=n.concat(Al.stateTerms)).includes(e)&&""!==e)||(a=a.concat(Al.qualifiers),r=r.concat(Al.locations),o=o.concat(Al.standaloneTerms),i=i.concat(Al.qualifiedTerms),!("webauthn"===(n=e.split(/\\s+/g))[n.lengt\
h-1]&&(n.pop(),0===n.length)||!t&&(8<n[0].length&&"section-"===n[0].substr(0,8)&&n.shift(),r.includes(n[0])&&n.shift(),a.includes(n[0])&&(n.shift(),o=[]),1!==n.length))&&(t=n[n.length-1],o.includes(t)||i.includes(t)))},Nl=function(e){var t;return e.attr("aria-labelledby")&&(t=tu(e.actualNode,"aria-labelledby").map((function(e){return(e=ca(e))?Ju(e):""})).join(" ").trim())?t:(t=(t=e.attr("aria-label"))&&Eu(t))||null},Bl=function(e,t,n){return e=ca(e),Ju(e,t,n)},Tl=function(e){if(t=Nl(e))return t;if(e.attr("id")){if(!e.actualNode)throw new TypeError("Cannot resolve explicit label reference for non-DOM nodes");var t,n=Mr(e.attr("id"));if(t=(n=No(e.actualNode).querySelector('label[for="'+n+'"]'))&&Bl(n,!0))return t}return(t=(n=xa(e,"label"))&&Ju(n,!0))||null},Rl=function(e){return e=ca(e),Tl(e)},_l=[{matches:[{nodeName:"textarea"},{nodeName:"input",properties:{type:["text","password","search","tel","email","url"]}}],namingMethods:"labelText"},{matches:{nodeName:"input",properties:{type:["b\
utton","submit","reset"]}},namingMethods:["valueText","titleText","buttonDefaultText"]},{matches:{nodeName:"input",properties:{type:"image"}},namingMethods:["altText","valueText","labelText","titleText","buttonDefaultText"]},{matches:"button",namingMethods:"subtreeText"},{matches:"fieldset",namingMethods:"fieldsetLegendText"},{matches:"OUTPUT",namingMethods:"subtreeText"},{matches:[{nodeName:"select"},{nodeName:"input",properties:{type:/^(?!text|password|search|tel|email|url|button|submit|reset)/}}],namingMethods:"labelText"},{matches:"summary",namingMethods:"subtreeText"},{matches:"figure",namingMethods:["figureText","titleText"]},{matches:"img",namingMethods:"altText"},{matches:"table",namingMethods:["tableCaptionText","tableSummaryText"]},{matches:["hr","br"],namingMethods:["titleText","singleSpace"]}],Ol=function e(t){var n=ai(t),r=[];return t.children.forEach((function(t){3===t.actualNode.nodeType?n&&r.push(t):r=r.concat(e(t))})),r},Sl=$r((function(e){var t=ca(e),n=t.boundingClien\
tRect,a=[],o=So(t);return e.childNodes.forEach((function(e){var t,i,u,l;3!==e.nodeType||""===Eu(e.nodeValue)||((t=r.createRange()).selectNodeContents(e),e=Array.from(t.getClientRects()),i=n,e.some((function(e){return!ui(ci(e),i)})))||a.push.apply(a,z((u=o,l=[],e.forEach((function(e){e.width<1||e.height<1||(e=u.reduce((function(e,t){return e&&si(e,t.boundingClientRect)}),e))&&l.push(e)})),l)))})),a.length?a:[n]})),Ml=function(e){Ci();var t=ca(e)._grid;return t?Sl(e).map((function(e){return Gi(t,e)})):[]},Pl=["checkbox","img","meter","progressbar","scrollbar","radio","slider","spinbutton","textbox"],Il=function(e){var t=nf(e).vNode;if(e=o.commons.aria.getExplicitRole(t))return-1!==Pl.indexOf(e);switch(t.props.nodeName){case"img":case"iframe":case"object":case"video":case"audio":case"canvas":case"svg":case"math":case"button":case"select":case"textarea":case"keygen":case"progress":case"meter":return!0;case"input":return"hidden"!==t.props.type;default:return!1}},jl=["head","title","template\
","script","style","iframe","object","video","audio","noscript"];function Ll(e){return!jl.includes(e.props.nodeName)&&e.children.some((function(e){return 3===(e=e.props).nodeType&&e.nodeValue.trim()}))}var ql=function e(t,n,r){return Ll(t)||Il(t.actualNode)||!r&&!!Nl(t)||!n&&t.children.some((function(t){return 1===t.actualNode.nodeType&&e(t)}))},zl=function(e,t,n){return e=ca(e),ql(e,t,n)};function Vl(e){return!(void 0!==e.children&&!Ll(e))||(1===e.props.nodeType&&Il(e)?!!o.commons.text.accessibleTextVirtual(e):e.children.some((function(e){return!e.attr("lang")&&Vl(e)&&!Ko(e)})))}var $l=function(e){return-1<parseInt(e.getAttribute("tabindex"),10)&&Xi(e)&&!Ki(e)};function Hl(e,t){var n=(e=nf(e)).vNode;e=e.domNode;return n?(void 0===n._isHiddenWithCSS&&(n._isHiddenWithCSS=Ul(e,t)),n._isHiddenWithCSS):Ul(e,t)}function Ul(e,n){if(9===e.nodeType)return!1;if(11===e.nodeType&&(e=e.host),["STYLE","SCRIPT"].includes(e.nodeName.toUpperCase()))return!1;var r,a=t.getComputedStyle(e,null);if(a)retu\
rn"none"===a.getPropertyValue("display")||(r=["hidden","collapse"],a=a.getPropertyValue("visibility"),!(!r.includes(a)||n))||!!(r.includes(a)&&n&&r.includes(n))||!(!(n=Jo(e))||r.includes(a))&&Hl(n,a);throw new Error("Style does not exist for the given element.")}var Gl=Hl,Wl=function(e){return null!==(e=e.doctype)&&"html"===e.name&&!e.publicId&&!e.systemId},Yl=function(e){(e instanceof vr||null!=(n=t)&&n.Node&&e instanceof t.Node)&&(e=o.commons.aria.getRole(e));var n=du.ariaRoles[e];return(null==n?void 0:n.type)||null},Kl=["block","list-item","table","flex","grid","inline-block"];function Xl(e){return e=t.getComputedStyle(e).getPropertyValue("display"),Kl.includes(e)||"table-"===e.substr(0,6)}var Zl=function(e,t){var n,r,a,o;return!Xl(e)&&(n=function(e){for(var t=Jo(e);t&&!Xl(t);)t=Jo(t);return ca(t)}(e),a=r="",o=0,function e(t,n){!1!==n(t.actualNode)&&t.children.forEach((function(t){return e(t,n)}))}(n,(function(t){if(2===o)return!1;if(3===t.nodeType&&(r+=t.nodeValue),1===t.nodeType){\
var n=(t.nodeName||"").toUpperCase();if(t===e&&(o=1),!["BR","HR"].includes(n))return!("none"===t.style.display||"hidden"===t.style.overflow||!["",null,"none"].includes(t.style.float)||!["",null,"relative"].includes(t.style.position))&&("widget"===Yl(t)?(a+=t.textContent,!1):void 0);0===o?a=r="":o=2}})),r=Eu(r),null!=t&&t.noLengthCompare?0!==r.length:(a=Eu(a),r.length>a.length))},Jl=function(e){if(e=(e=e||{}).modalPercent||.75,sa.get("isModalOpen"))return sa.get("isModalOpen");if(mf(o._tree[0],"dialog, [role=dialog], [aria-modal=true]",ai).length)return sa.set("isModalOpen",!0),!0;for(var n=ti(t),i=n.width*e,u=n.height*e,l=(e=(n.width-i)/2,(n.height-u)/2),s=[{x:e,y:l},{x:n.width-e,y:l},{x:n.width/2,y:n.height/2},{x:e,y:n.height-l},{x:n.width-e,y:n.height-l}].map((function(e){return Array.from(r.elementsFromPoint(e.x,e.y))})),c=0;c<s.length;c++){var d=function(e){var n=s[e].find((function(e){return e=t.getComputedStyle(e),parseInt(e.width,10)>=i&&parseInt(e.height,10)>=u&&"none"!==e.getP\
ropertyValue("pointer-events")&&("absolute"===e.position||"fixed"===e.position)}));if(n&&s.every((function(e){return e.includes(n)})))return sa.set("isModalOpen",!0),{v:!0}}(c);if("object"===a(d))return d.v}sa.set("isModalOpen",void 0)};function Ql(e){var t,n=1<arguments.length&&void 0!==arguments[1]?arguments[1]:2,r=e.ownerDocument.createRange(),a=(r.setStart(e,0),r.setEnd(e,e.childNodes.length),0),o=0,i=Z(r.getClientRects());try{for(i.s();!(t=i.n()).done;){var u=t.value;if(!(u.height<=n))if(a>u.top+n)a=Math.max(a,u.bottom);else{if(0!==o)return!0;a=u.bottom,o++}}}catch(e){i.e(e)}finally{i.f()}return!1}var es,ts,ns=function(e){return e instanceof t.Node},rs="color.incompleteData",as={set:function(e,t){if("string"!=typeof e)throw new Error("Incomplete data: key must be a string");var n=sa.get(rs,(function(){return{}}));return t&&(n[e]=t),n[e]},get:function(e){var t=sa.get(rs);return null==t?void 0:t[e]},clear:function(){sa.set(rs,{})}},os=function(e,n){var r=e.nodeName.toUpperCase();ret\
urn["IMG","CANVAS","OBJECT","IFRAME","VIDEO","SVG"].includes(r)?(as.set("bgColor","imgNode"),!0):((e="none"!==(r=(n=n||t.getComputedStyle(e)).getPropertyValue("background-image")))&&(n=/gradient/.test(r),as.set("bgColor",n?"bgGradient":"bgImage")),e)};te(uu={},{Colorjs:function(){return Od},CssSelectorParser:function(){return us.CssSelectorParser},doT:function(){return ls.default},emojiRegexText:function(){return vl},memoize:function(){return ss.default}}),lu=ne(Yt()),Yt=ne(Kt()),ne(Xt()),Kt=ne(Zn()),Xt=ne(pr());function is(e){return"function"==typeof e||"[object Function]"===es.call(e)}"hasOwn"in Object||(Object.hasOwn=Kt.default),"values"in Object||(Object.values=Xt.default),"Promise"in t||lu.default.polyfill(),"Uint32Array"in t||(t.Uint32Array=Yt.Uint32Array),t.Uint32Array&&("some"in t.Uint32Array.prototype||Object.defineProperty(t.Uint32Array.prototype,"some",{value:Array.prototype.some}),"reduce"in t.Uint32Array.prototype||Object.defineProperty(t.Uint32Array.prototype,"reduce",{va\
lue:Array.prototype.reduce})),"function"!=typeof Object.assign&&(Object.assign=function(e){if(null==e)throw new TypeError("Cannot convert undefined or null to object");for(var t=Object(e),n=1;n<arguments.length;n++){var r=arguments[n];if(null!=r)for(var a in r)r.hasOwnProperty(a)&&(t[a]=r[a])}return t}),Array.prototype.find||Object.defineProperty(Array.prototype,"find",{value:function(e){if(null===this)throw new TypeError("Array.prototype.find called on null or undefined");if("function"!=typeof e)throw new TypeError("predicate must be a function");for(var t,n=Object(this),r=n.length>>>0,a=arguments[1],o=0;o<r;o++)if(t=n[o],e.call(a,t,o,n))return t}}),Array.prototype.findIndex||Object.defineProperty(Array.prototype,"findIndex",{value:function(e,t){if(null===this)throw new TypeError("Array.prototype.find called on null or undefined");if("function"!=typeof e)throw new TypeError("predicate must be a function");for(var n,r=Object(this),a=r.length>>>0,o=0;o<a;o++)if(n=r[o],e.call(t,n,o,r))re\
turn o;return-1}}),Array.prototype.includes||Object.defineProperty(Array.prototype,"includes",{value:function(e){var t=Object(this),n=parseInt(t.length,10)||0;if(0!==n){var r,a,o=parseInt(arguments[1],10)||0;for(0<=o?r=o:(r=n+o)<0&&(r=0);r<n;){if(e===(a=t[r])||e!=e&&a!=a)return!0;r++}}return!1}}),Array.prototype.some||Object.defineProperty(Array.prototype,"some",{value:function(e){if(null==this)throw new TypeError("Array.prototype.some called on null or undefined");if("function"!=typeof e)throw new TypeError;for(var t=Object(this),n=t.length>>>0,r=2<=arguments.length?arguments[1]:void 0,a=0;a<n;a++)if(a in t&&e.call(r,t[a],a,t))return!0;return!1}}),Array.from||Object.defineProperty(Array,"from",{value:(es=Object.prototype.toString,ts=Math.pow(2,53)-1,function(e){var t=Object(e);if(null==e)throw new TypeError("Array.from requires an array-like object - not null or undefined");var n,r=1<arguments.length?arguments[1]:void 0;if(void 0!==r){if(!is(r))throw new TypeError("Array.from: when pr\
ovided, the second argument must be a function");2<arguments.length&&(n=arguments[2])}for(var a,o=function(e){return e=function(e){return e=Number(e),isNaN(e)?0:0!==e&&isFinite(e)?(0<e?1:-1)*Math.floor(Math.abs(e)):e}(e),Math.min(Math.max(e,0),ts)}(t.length),i=is(this)?Object(new this(o)):new Array(o),u=0;u<o;)a=t[u],i[u]=r?void 0===n?r(a,u):r.call(n,a,u):a,u+=1;return i.length=o,i})}),String.prototype.includes||(String.prototype.includes=function(e,t){return!((t="number"!=typeof t?0:t)+e.length>this.length)&&-1!==this.indexOf(e,t)}),Array.prototype.flat||Object.defineProperty(Array.prototype,"flat",{configurable:!0,value:function e(){var t=isNaN(arguments[0])?1:Number(arguments[0]);return t?Array.prototype.reduce.call(this,(function(n,r){return Array.isArray(r)?n.push.apply(n,e.call(r,t-1)):n.push(r),n}),[]):Array.prototype.slice.call(this)},writable:!0}),!t.Node||"isConnected"in t.Node.prototype||Object.defineProperty(t.Node.prototype,"isConnected",{get:function(){return!(this.ownerD\
ocument&&this.ownerDocument.compareDocumentPosition(this)&this.DOCUMENT_POSITION_DISCONNECTED)}});var us=ne(Wt()),ls=ne(fr()),ss=ne($t());function cs(e,t){var n=e.length,r=(Array.isArray(e[0])||(e=[e]),(t=Array.isArray(t[0])?t:t.map((function(e){return[e]})))[0].length),a=t[0].map((function(e,n){return t.map((function(e){return e[n]}))}));e=e.map((function(e){return a.map((function(t){var n=0;if(Array.isArray(e))for(var r=0;r<e.length;r++)n+=e[r]*(t[r]||0);else{var a,o=Z(t);try{for(o.s();!(a=o.n()).done;){var i=a.value;n+=e*i}}catch(t){o.e(t)}finally{o.f()}}return n}))}));return 1===n&&(e=e[0]),1===r?e.map((function(e){return e[0]})):e}function ds(e){return"string"===ps(e)}function ps(e){return(Object.prototype.toString.call(e).match(/^\\[object\\s+(.*?)\\]$/)[1]||"").toLowerCase()}function fs(e,t){e=+e,t=+t;var n=(Math.floor(e)+"").length;return n<t?+e.toFixed(t-n):(n=Math.pow(10,n-t),Math.round(e/n)*n)}function ms(e){var t,n;if(e)return e=e.trim(),t=/^-?[\\d.]+$/,(e=e.match(/^([a-z]+)\\((\
.+?)\\)$/i))?(n=[],e[2].replace(/\\/?\\s*([-\\w.]+(?:%|deg)?)/g,(function(e,r){/%$/.test(r)?(r=new Number(r.slice(0,-1)/100)).type="<percentage>":/deg$/.test(r)?((r=new Number(+r.slice(0,-3))).type="<angle>",r.unit="deg"):t.test(r)&&((r=new Number(r)).type="<number>"),e.startsWith("/")&&((r=r instanceof Number?r:new Number(r)).alpha=!0),n.push(r)})),{name:e[1].toLowerCase(),rawName:e[1],rawArgs:e[2],args:n}):void 0}function Ds(e){return e[e.length-1]}function hs(e,t,n){return isNaN(e)?t:isNaN(t)?e:e+(t-e)*n}function gs(e,t,n){return(n-e)/(t-e)}function bs(e,t,n){return hs(t[0],t[1],gs(e[0],e[1],n))}function vs(e){return e.map((function(e){return e.split("|").map((function(e){var t,n=(e=e.trim()).match(/^(<[a-z]+>)\\[(-?[.\\d]+),\\s*(-?[.\\d]+)\\]?$/);return n?((t=new String(n[1])).range=[+n[2],+n[3]],t):e}))}))}function ys(){W(this,ys)}Zn=Object.freeze({__proto__:null,isString:ds,type:ps,toPrecision:fs,parseFunction:ms,last:Ds,interpolate:hs,interpolateInv:gs,mapRange:bs,parseCoordGrammar:vs,mu\
ltiplyMatrices:cs}),K(ys,[{key:"add",value:function(e,t,n){if("string"!=typeof arguments[0])for(var e in arguments[0])this.add(e,arguments[0][e],t);else(Array.isArray(e)?e:[e]).forEach((function(e){this[e]=this[e]||[],t&&this[e][n?"unshift":"push"](t)}),this)}},{key:"run",value:function(e,t){this[e]=this[e]||[],this[e].forEach((function(e){e.call(t&&t.context?t.context:t,t)}))}}]);var Fs=new ys,ws={gamut_mapping:"lch.c",precision:5,deltaE:"76"},Es={D50:[.3457/.3585,1,.2958/.3585],D65:[.3127/.329,1,.3583/.329]};function Cs(e){return Array.isArray(e)?e:Es[e]}function xs(e,t,n,r){var a=3<arguments.length&&void 0!==r?r:{};if(e=Cs(e),t=Cs(t),!e||!t)throw new TypeError("Missing white point to convert ".concat(e?"":"from").concat(e||t?"":"/").concat(t?"":"to"));if(e===t)return n;if(a={W1:e,W2:t,XYZ:n,options:a},Fs.run("chromatic-adaptation-start",a),a.M||(a.W1===Es.D65&&a.W2===Es.D50?a.M=[[1.0479298208405488,.022946793341019088,-.05019222954313557],[.029627815688159344,.990434484573249,-.0170\
7382502938514],[-.009243058152591178,.015055144896577895,.7518742899580008]]:a.W1===Es.D50&&a.W2===Es.D65&&(a.M=[[.9554734527042182,-.023098536874261423,.0632593086610217],[-.028369706963208136,1.0099954580058226,.021041398966943008],[.012314001688319899,-.020507696433477912,1.3303659366080753]])),Fs.run("chromatic-adaptation-end",a),a.M)return cs(a.M,a.XYZ);throw new TypeError("Only Bradford CAT with white points D50 and D65 supported for now.")}function As(e){W(this,As),S(this,ie),S(this,ae),O(this,oe,{writable:!0,value:void 0}),this.id=e.id,this.name=e.name,this.base=e.base?As.get(e.base):null,this.aliases=e.aliases,this.base&&(this.fromBase=e.fromBase,this.toBase=e.toBase);var t,n=null!=(n=e.coords)?n:this.base.coords;this.coords=n,n=null!=(n=null!=(n=e.white)?n:this.base.white)?n:"D65";for(t in this.white=Cs(n),this.formats=null!=(n=e.formats)?n:{},this.formats){var r=this.formats[t];r.type||(r.type="function"),r.name||(r.name=t)}!e.cssId||null!=(n=this.formats.functions)&&n.color\
?null==(n=this.formats)||!n.color||null!=(n=this.formats)&&n.color.id||(this.formats.color.id=this.id):(this.formats.color={id:e.cssId},Object.defineProperty(this,"cssId",{value:e.cssId})),this.referred=e.referred,j(this,oe,I(this,ie,Ns).call(this).reverse()),Fs.run("colorspace-init-end",this)}function ks(e){var t;return e.coords&&!e.coordGrammar&&(e.type||(e.type="function"),e.name||(e.name="color"),e.coordGrammar=vs(e.coords),t=Object.entries(this.coords).map((function(t,n){(t=H(t,2))[0],t=t[1],n=e.coordGrammar[n][0],t=t.range||t.refRange;var r=n.range,a="";return"<percentage>"==n?(r=[0,100],a="%"):"<angle>"==n&&(a="deg"),{fromRange:t,toRange:r,suffix:a}})),e.serializeCoords=function(e,n){return e.map((function(e,r){var a=(r=t[r]).fromRange,o=r.toRange;r=r.suffix;return e=fs(e=a&&o?bs(a,o,e):e,n),r&&(e+=r),e}))}),e}function Ns(){for(var e=[this],t=this;t=t.base;)e.push(t);return e}ae=new WeakSet,oe=new WeakMap,ie=new WeakSet,K(As,[{key:"inGamut",value:function(e){var t,n=(1<arguments\
.length&&void 0!==arguments[1]?arguments[1]:{}).epsilon,r=void 0===n?75e-6:n;return this.isPolar?(e=this.toBase(e),this.base.inGamut(e,{epsilon:r})):(t=Object.values(this.coords),e.every((function(e,n){var a;return"angle"===(n=t[n]).type||!n.range||!!Number.isNaN(e)||(a=(n=H(n.range,2))[0],n=n[1],(void 0===a||a-r<=e)&&(void 0===n||e<=n+r))})))}},{key:"cssId",get:function(){var e;return(null==(e=this.formats.functions)||null==(e=e.color)?void 0:e.id)||this.id}},{key:"isPolar",get:function(){for(var e in this.coords)if("angle"===this.coords[e].type)return!0;return!1}},{key:"getFormat",value:function(e){return"object"===a(e)||(e="default"===e?Object.values(this.formats)[0]:this.formats[e])?I(this,ae,ks).call(this,e):null}},{key:"to",value:function(e,t){var n;if(1===arguments.length&&(e=(n=[e.space,e.coords])[0],t=n[1]),this!==(e=As.get(e))){t=t.map((function(e){return Number.isNaN(e)?0:e}));for(var r,a,o=P(this,oe),i=P(e,oe),u=0;u<o.length&&o[u]===i[u];u++)r=o[u],a=u;if(!r)throw new Error\
("Cannot convert between color spaces ".concat(this," and ").concat(e,": no connection space was found"));for(var l=o.length-1;a<l;l--)t=o[l].toBase(t);for(var s=a+1;s<i.length;s++)t=i[s].fromBase(t)}return t}},{key:"from",value:function(e,t){var n;return 1===arguments.length&&(e=(n=[e.space,e.coords])[0],t=n[1]),(e=As.get(e)).to(this,t)}},{key:"toString",value:function(){return"".concat(this.name," (").concat(this.id,")")}},{key:"getMinCoords",value:function(){var e,t=[];for(e in this.coords){var n=(n=this.coords[e]).range||n.refRange;t.push(null!=(n=null==n?void 0:n.min)?n:0)}return t}}],[{key:"all",get:function(){return z(new Set(Object.values(As.registry)))}},{key:"register",value:function(e,t){if(1===arguments.length&&(e=(t=arguments[0]).id),t=this.get(t),this.registry[e]&&this.registry[e]!==t)throw new Error("Duplicate color space registration: '".concat(e,"'"));if(this.registry[e]=t,1===arguments.length&&t.aliases){var n,r=Z(t.aliases);try{for(r.s();!(n=r.n()).done;){var a=n.val\
ue;this.register(a,t)}}catch(e){r.e(e)}finally{r.f()}}return t}},{key:"get",value:function(e){if(!e||e instanceof As)return e;if("string"===ps(e)){var t=As.registry[e.toLowerCase()];if(t)return t;throw new TypeError('No color space found with id = "'.concat(e,'"'))}for(var n=arguments.length,r=new Array(1<n?n-1:0),a=1;a<n;a++)r[a-1]=arguments[a];if(r.length)return As.get.apply(As,r);throw new TypeError("".concat(e," is not a valid color space"))}},{key:"resolveCoord",value:function(e,t){var n,r;if(r="string"===ps(e)?e.includes(".")?(n=(r=H(e.split("."),2))[0],r[1]):(n=void 0,e):Array.isArray(e)?(n=(r=H(e,2))[0],r[1]):(n=e.space,e.coordId),!(n=(n=As.get(n))||t))throw new TypeError("Cannot resolve coordinate reference ".concat(e,": No color space specified and relative references are not allowed here"));if(("number"===(t=ps(r))||"string"===t&&0<=r)&&(e=Object.entries(n.coords)[r]))return $({space:n,id:e[0],index:r},e[1]);n=As.get(n);var a,o=r.toLowerCase(),i=0;for(a in n.coords){var u,l=\
n.coords[a];if(a.toLowerCase()===o||(null==(u=l.name)?void 0:u.toLowerCase())===o)return $({space:n,id:a,index:i},l);i++}throw new TypeError('No "'.concat(r,'" coordinate found in ').concat(n.name,". Its coordinates are: ").concat(Object.keys(n.coords).join(", ")))}}]);var Bs,Ts=As,Rs=(re(Ts,"registry",{}),re(Ts,"DEFAULT_FORMAT",{type:"functions",name:"color"}),new Ts({id:"xyz-d65",name:"XYZ D65",coords:{x:{name:"X"},y:{name:"Y"},z:{name:"Z"}},white:"D65",formats:{color:{ids:["xyz-d65","xyz"]}},aliases:["xyz"]}));k(_s,Ts),Bs=B(_s),pr=K(_s);function _s(e){var t;return W(this,_s),e.coords||(e.coords={r:{range:[0,1],name:"Red"},g:{range:[0,1],name:"Green"},b:{range:[0,1],name:"Blue"}}),e.base||(e.base=Rs),e.toXYZ_M&&e.fromXYZ_M&&(null==e.toBase&&(e.toBase=function(n){return n=cs(e.toXYZ_M,n),t.white!==t.base.white?xs(t.white,t.base.white,n):n}),null==e.fromBase)&&(e.fromBase=function(n){return n=xs(t.base.white,t.white,n),cs(e.fromXYZ_M,n)}),null==e.referred&&(e.referred="display"),t=Bs.c\
all(this,e)}function Os(e){var t={str:null==(n=String(e))?void 0:n.trim()};if(Fs.run("parse-start",t),t.color)return t.color;if(t.parsed=ms(t.str),t.parsed){var n=function(){var e=t.parsed.name;if("color"===e){var n,r=t.parsed.args.shift(),o=0<t.parsed.rawArgs.indexOf("/")?t.parsed.args.pop():1,i=Z(Ts.all);try{for(i.s();!(n=i.n()).done;){var u,l=n.value,s=l.getFormat("color");if(s&&(r===s.id||null!=(u=s.ids)&&u.includes(r))){var c=function(){var e=Object.keys(l.coords).length,n=Array(e).fill(0);return n.forEach((function(e,r){return n[r]=t.parsed.args[r]||0})),{v:{v:{spaceId:l.id,coords:n,alpha:o}}}}();if("object"===a(c))return c.v}}}catch(n){i.e(n)}finally{i.f()}var d,p="";throw r in Ts.registry&&(d=null==(d=Ts.registry[r].formats)||null==(d=d.functions)||null==(d=d.color)?void 0:d.id)&&(p="Did you mean color(".concat(d,")?")),new TypeError("Cannot parse color(".concat(r,"). ")+(p||"Missing a plugin?"))}var f,m=Z(Ts.all);try{for(m.s();!(f=m.n()).done;){var D=function(){var n,r,a=f.val\
ue,o=a.getFormat(e);if(o&&"function"===o.type)return n=1,(o.lastAlpha||Ds(t.parsed.args).alpha)&&(n=t.parsed.args.pop()),r=t.parsed.args,o.coordGrammar&&Object.entries(a.coords).forEach((function(t,n){var a=(t=H(t,2))[0],i=(t=t[1],o.coordGrammar[n]),u=null==(l=r[n])?void 0:l.type;if(!(i=i.find((function(e){return e==u}))))throw l=t.name||a,new TypeError("".concat(u," not allowed for ").concat(l," in ").concat(e,"()"));a=i.range;var l=t.range||t.refRange;(a="<percentage>"===u?a||[0,1]:a)&&l&&(r[n]=bs(a,l,r[n]))})),{v:{v:{spaceId:a.id,coords:r,alpha:n}}}}();if("object"===a(D))return D.v}}catch(n){m.e(n)}finally{m.f()}}();if("object"===a(n))return n.v}else{var r,o=Z(Ts.all);try{for(o.s();!(r=o.n()).done;){var i,u=r.value;for(i in u.formats){var l=u.formats[i];if("custom"===l.type&&(!l.test||l.test(t.str))){var s=l.parse(t.str);if(s)return null==s.alpha&&(s.alpha=1),s}}}}catch(e){o.e(e)}finally{o.f()}}throw new TypeError("Could not parse ".concat(e," as a color. Missing a plugin?"))}functi\
on Ss(e){var t;if(e)return(t=(e=ds(e)?Os(e):e).space||e.spaceId)instanceof Ts||(e.space=Ts.get(t)),void 0===e.alpha&&(e.alpha=1),e;throw new TypeError("Empty color reference")}function Ms(e,t){return(t=Ts.get(t)).from(e)}function Ps(e,t){var n=(t=Ts.resolveCoord(t,e.space)).space;t=t.index;return Ms(e,n)[t]}function Is(e,t,n){return t=Ts.get(t),e.coords=t.to(e.space,n),e}function js(e,t,n){if(e=Ss(e),2===arguments.length&&"object"===ps(t)){var r,a=t;for(r in a)js(e,r,a[r])}else{"function"==typeof n&&(n=n(Ps(e,t)));var o=(i=Ts.resolveCoord(t,e.space)).space,i=i.index,u=Ms(e,o);u[i]=n,Is(e,o,u)}return e}Kt=new Ts({id:"xyz-d50",name:"XYZ D50",white:"D50",base:Rs,fromBase:function(e){return xs(Rs.white,"D50",e)},toBase:function(e){return xs("D50",Rs.white,e)},formats:{color:{}}});var Ls=24389/27,qs=Es.D50,zs=new Ts({id:"lab",name:"Lab",coords:{l:{refRange:[0,100],name:"L"},a:{refRange:[-125,125]},b:{refRange:[-125,125]}},white:qs,base:Kt,fromBase:function(e){return e=e.map((function(e,t){r\
eturn e/qs[t]})).map((function(e){return 216/24389<e?Math.cbrt(e):(Ls*e+16)/116})),[116*e[1]-16,500*(e[0]-e[1]),200*(e[1]-e[2])]},toBase:function(e){var t=[];return t[1]=(e[0]+16)/116,t[0]=e[1]/500+t[1],t[2]=t[1]-e[2]/200,[24/116<t[0]?Math.pow(t[0],3):(116*t[0]-16)/Ls,8<e[0]?Math.pow((e[0]+16)/116,3):e[0]/Ls,24/116<t[2]?Math.pow(t[2],3):(116*t[2]-16)/Ls].map((function(e,t){return e*qs[t]}))},formats:{lab:{coords:["<number> | <percentage>","<number>","<number>"]}}});function Vs(e){return(e%360+360)%360}var $s=new Ts({id:"lch",name:"LCH",coords:{l:{refRange:[0,100],name:"Lightness"},c:{refRange:[0,150],name:"Chroma"},h:{refRange:[0,360],type:"angle",name:"Hue"}},base:zs,fromBase:function(e){var t=(e=H(e,3))[0],n=e[1],r=(e=e[2],Math.abs(n)<.02&&Math.abs(e)<.02?NaN:180*Math.atan2(e,n)/Math.PI);return[t,Math.sqrt(Math.pow(n,2)+Math.pow(e,2)),Vs(r)]},toBase:function(e){var t=(e=H(e,3))[0],n=e[1];e=e[2];return n<0&&(n=0),isNaN(e)&&(e=0),[t,n*Math.cos(e*Math.PI/180),n*Math.sin(e*Math.PI/180)]}\
,formats:{lch:{coords:["<number> | <percentage>","<number>","<number> | <angle>"]}}}),Hs=Math.pow(25,7),Us=Math.PI,Gs=180/Us,Ws=Us/180;function Ys(e,t){var n=void 0===(n=(a=2<arguments.length&&void 0!==arguments[2]?arguments[2]:{}).kL)?1:n,r=void 0===(r=a.kC)?1:r,a=void 0===(a=a.kH)?1:a,o=(u=H(zs.from(e),3))[0],i=u[1],u=u[2],l=$s.from(zs,[o,i,u])[1],s=(d=H(zs.from(t),3))[0],c=d[1],d=d[2],p=(l=((l=l<0?0:l)+(p=(p=$s.from(zs,[s,c,d])[1])<0?0:p))/2,Math.pow(l,7)),f=(p=(1+(l=.5*(1-Math.sqrt(p/(p+Hs)))))*i,i=(1+l)*c,l=Math.sqrt(Math.pow(p,2)+Math.pow(u,2)),c=Math.sqrt(Math.pow(i,2)+Math.pow(d,2)),u=0==p&&0===u?0:Math.atan2(u,p),p=0==i&&0===d?0:Math.atan2(d,i),d=(u<0&&(u+=2*Us),p<0&&(p+=2*Us),s-o),i=c-l,(p*=Gs)-(u*=Gs)),m=(u=u+p,p=Math.abs(f),f=(l*c==0?m=0:p<=180?m=f:180<f?m=f-360:f<-180?m=360+f:console.log("the unthinkable has happened"),2*Math.sqrt(c*l)*Math.sin(m*Ws/2)),(o+s)/2);o=(l+c)/2,s=Math.pow(o,7),l=l*c==0?u:p<=180?u/2:u<360?(u+360)/2:(u-360)/2,p=1+.015*(c=Math.pow(m-50,2))/Math.sqr\
t(20+c),u=1+.045*o,m=1,c=1+.015*o*((m-=.17*Math.cos((l-30)*Ws))+.24*Math.cos(2*l*Ws)+.32*Math.cos((3*l+6)*Ws)-.2*Math.cos((4*l-63)*Ws)),o=30*Math.exp(-1*Math.pow((l-275)/25,2)),m=2*Math.sqrt(s/(s+Hs)),l=-1*Math.sin(2*o*Ws)*m,s=Math.pow(d/(n*p),2),s=(s+=Math.pow(i/(r*u),2))+Math.pow(f/(a*c),2)+i/(r*u)*l*(f/(a*c));return Math.sqrt(s)}var Ks=75e-6;function Xs(e){var t=1<arguments.length&&void 0!==arguments[1]?arguments[1]:e.space,n=void 0===(n=(2<arguments.length&&void 0!==arguments[2]?arguments[2]:{}).epsilon)?Ks:n,r=(e=Ss(e),t=Ts.get(t),e.coords);return t!==e.space&&(r=t.from(e)),t.inGamut(r,{epsilon:n})}function Zs(e){return{space:e.space,coords:e.coords.slice(),alpha:e.alpha}}function Js(e){var t=void 0===(t=(a=1<arguments.length&&void 0!==arguments[1]?arguments[1]:{}).method)?ws.gamut_mapping:t,n=void 0===(a=a.space)?e.space:a;if(ds(arguments[1])&&(n=arguments[1]),!Xs(e,n=Ts.get(n),{epsilon:0})){var r,a=Qs(e,n);if("clip"!==t&&!Xs(e,n)){var o=Js(Zs(a),{method:"clip",space:n});if(2<Ys(\
e,o)){for(var i=Ts.resolveCoord(t),u=i.space,l=i.id,s=Qs(a,u),c=(i.range||i.refRange)[0],d=Ps(s,l);.01<d-c;)Ys(s,Js(Zs(s),{space:n,method:"clip"}))-2<.01?c=Ps(s,l):d=Ps(s,l),js(s,l,(c+d)/2);a=Qs(s,n)}else a=o}"clip"!==t&&Xs(a,n,{epsilon:0})||(r=Object.values(n.coords).map((function(e){return e.range||[]})),a.coords=a.coords.map((function(e,t){var n=(t=H(r[t],2))[0];t=t[1];return void 0!==n&&(e=Math.max(n,e)),void 0!==t?Math.min(e,t):e}))),n!==e.space&&(a=Qs(a,e.space)),e.coords=a.coords}return e}function Qs(e,t){var n=(2<arguments.length&&void 0!==arguments[2]?arguments[2]:{}).inGamut,r=(e=Ss(e),(t=Ts.get(t)).from(e));r={space:t,coords:r,alpha:e.alpha};return n?Js(r):r}function ec(e){var t=void 0===(n=(a=1<arguments.length&&void 0!==arguments[1]?arguments[1]:{}).precision)?ws.precision:n,n=void 0===(n=a.format)?"default":n,r=void 0===(r=a.inGamut)||r,a=q(a,D),o=n,i=(n=null!=(i=null!=(i=(e=Ss(e)).space.getFormat(n))?i:e.space.getFormat("default"))?i:Ts.DEFAULT_FORMAT,r=r||n.toGamut,(i=e\
.coords).map((function(e){return e||0})));if(r&&!Xs(e)&&(i=Js(Zs(e),!0===r?void 0:r).coords),"custom"===n.type){if(a.precision=t,!n.serialize)throw new TypeError("format ".concat(o," can only be used to parse colors, not for serialization"));u=n.serialize(i,e.alpha,a)}else{r=n.name||"color",o=(n.serializeCoords?i=n.serializeCoords(i,t):null!==t&&(i=i.map((function(e){return fs(e,t)}))),z(i)),a=("color"===r&&(i=n.id||(null==(a=n.ids)?void 0:a[0])||e.space.id,o.unshift(i)),e.alpha),i=(null!==t&&(a=fs(a,t)),e.alpha<1&&!n.noAlpha?"".concat(n.commas?",":" /"," ").concat(a):"");var u="".concat(r,"(").concat(o.join(n.commas?", ":" ")).concat(i,")")}return u}Qs.returns=Js.returns="color";Xt=new pr({id:"rec2020-linear",name:"Linear REC.2020",white:"D65",toXYZ_M:[[.6369580483012914,.14461690358620832,.1688809751641721],[.2627002120112671,.6779980715188708,.05930171646986196],[0,.028072693049087428,1.060985057710791]],fromXYZ_M:[[1.716651187971268,-.355670783776392,-.25336628137366],[-.6666843518\
32489,1.616481236634939,.0157685458139111],[.017639857445311,-.042770613257809,.942103121235474]],formats:{color:{}}});var tc=1.09929682680944,nc=.018053968510807,rc=(lu=new pr({id:"rec2020",name:"REC.2020",base:Xt,toBase:function(e){return e.map((function(e){return e<4.5*nc?e/4.5:Math.pow((e+tc-1)/tc,1/.45)}))},fromBase:function(e){return e.map((function(e){return nc<=e?tc*Math.pow(e,.45)-(tc-1):4.5*e}))},formats:{color:{}}}),Yt=new pr({id:"p3-linear",name:"Linear P3",white:"D65",toXYZ_M:[[.4865709486482162,.26566769316909306,.1982172852343625],[.2289745640697488,.6917385218365064,.079286914093745],[0,.04511338185890264,1.043944368900976]],fromXYZ_M:[[2.493496911941425,-.9313836179191239,-.40271078445071684],[-.8294889695615747,1.7626640603183463,.023624685841943577],[.03584583024378447,-.07617238926804182,.9568845240076872]]}),Wt=new pr({id:"srgb-linear",name:"Linear sRGB",white:"D65",toXYZ_M:[[.41239079926595934,.357584339383878,.1804807884018343],[.21263900587151027,.71516867876775\
6,.07219231536073371],[.01933081871559182,.11919477979462598,.9505321522496607]],fromXYZ_M:[[3.2409699419045226,-1.537383177570094,-.4986107602930034],[-.9692436362808796,1.8759675015077202,.04155505740717559],[.05563007969699366,-.20397695888897652,1.0569715142428786]],formats:{color:{}}}),{aliceblue:[240/255,248/255,1],antiquewhite:[250/255,235/255,215/255],aqua:[0,1,1],aquamarine:[127/255,1,212/255],azure:[240/255,1,1],beige:[245/255,245/255,220/255],bisque:[1,228/255,196/255],black:[0,0,0],blanchedalmond:[1,235/255,205/255],blue:[0,0,1],blueviolet:[138/255,43/255,226/255],brown:[165/255,42/255,42/255],burlywood:[222/255,184/255,135/255],cadetblue:[95/255,158/255,160/255],chartreuse:[127/255,1,0],chocolate:[210/255,105/255,30/255],coral:[1,127/255,80/255],cornflowerblue:[100/255,149/255,237/255],cornsilk:[1,248/255,220/255],crimson:[220/255,20/255,60/255],cyan:[0,1,1],darkblue:[0,0,139/255],darkcyan:[0,139/255,139/255],darkgoldenrod:[184/255,134/255,11/255],darkgray:[169/255,169/255\
,169/255],darkgreen:[0,100/255,0],darkgrey:[169/255,169/255,169/255],darkkhaki:[189/255,183/255,107/255],darkmagenta:[139/255,0,139/255],darkolivegreen:[85/255,107/255,47/255],darkorange:[1,140/255,0],darkorchid:[.6,50/255,.8],darkred:[139/255,0,0],darksalmon:[233/255,150/255,122/255],darkseagreen:[143/255,188/255,143/255],darkslateblue:[72/255,61/255,139/255],darkslategray:[47/255,79/255,79/255],darkslategrey:[47/255,79/255,79/255],darkturquoise:[0,206/255,209/255],darkviolet:[148/255,0,211/255],deeppink:[1,20/255,147/255],deepskyblue:[0,191/255,1],dimgray:[105/255,105/255,105/255],dimgrey:[105/255,105/255,105/255],dodgerblue:[30/255,144/255,1],firebrick:[178/255,34/255,34/255],floralwhite:[1,250/255,240/255],forestgreen:[34/255,139/255,34/255],fuchsia:[1,0,1],gainsboro:[220/255,220/255,220/255],ghostwhite:[248/255,248/255,1],gold:[1,215/255,0],goldenrod:[218/255,165/255,32/255],gray:[128/255,128/255,128/255],green:[0,128/255,0],greenyellow:[173/255,1,47/255],grey:[128/255,128/255,128\
/255],honeydew:[240/255,1,240/255],hotpink:[1,105/255,180/255],indianred:[205/255,92/255,92/255],indigo:[75/255,0,130/255],ivory:[1,1,240/255],khaki:[240/255,230/255,140/255],lavender:[230/255,230/255,250/255],lavenderblush:[1,240/255,245/255],lawngreen:[124/255,252/255,0],lemonchiffon:[1,250/255,205/255],lightblue:[173/255,216/255,230/255],lightcoral:[240/255,128/255,128/255],lightcyan:[224/255,1,1],lightgoldenrodyellow:[250/255,250/255,210/255],lightgray:[211/255,211/255,211/255],lightgreen:[144/255,238/255,144/255],lightgrey:[211/255,211/255,211/255],lightpink:[1,182/255,193/255],lightsalmon:[1,160/255,122/255],lightseagreen:[32/255,178/255,170/255],lightskyblue:[135/255,206/255,250/255],lightslategray:[119/255,136/255,.6],lightslategrey:[119/255,136/255,.6],lightsteelblue:[176/255,196/255,222/255],lightyellow:[1,1,224/255],lime:[0,1,0],limegreen:[50/255,205/255,50/255],linen:[250/255,240/255,230/255],magenta:[1,0,1],maroon:[128/255,0,0],mediumaquamarine:[.4,205/255,170/255],mediumb\
lue:[0,0,205/255],mediumorchid:[186/255,85/255,211/255],mediumpurple:[147/255,112/255,219/255],mediumseagreen:[60/255,179/255,113/255],mediumslateblue:[123/255,104/255,238/255],mediumspringgreen:[0,250/255,154/255],mediumturquoise:[72/255,209/255,.8],mediumvioletred:[199/255,21/255,133/255],midnightblue:[25/255,25/255,112/255],mintcream:[245/255,1,250/255],mistyrose:[1,228/255,225/255],moccasin:[1,228/255,181/255],navajowhite:[1,222/255,173/255],navy:[0,0,128/255],oldlace:[253/255,245/255,230/255],olive:[128/255,128/255,0],olivedrab:[107/255,142/255,35/255],orange:[1,165/255,0],orangered:[1,69/255,0],orchid:[218/255,112/255,214/255],palegoldenrod:[238/255,232/255,170/255],palegreen:[152/255,251/255,152/255],paleturquoise:[175/255,238/255,238/255],palevioletred:[219/255,112/255,147/255],papayawhip:[1,239/255,213/255],peachpuff:[1,218/255,185/255],peru:[205/255,133/255,63/255],pink:[1,192/255,203/255],plum:[221/255,160/255,221/255],powderblue:[176/255,224/255,230/255],purple:[128/255,0,1\
28/255],rebeccapurple:[.4,.2,.6],red:[1,0,0],rosybrown:[188/255,143/255,143/255],royalblue:[65/255,105/255,225/255],saddlebrown:[139/255,69/255,19/255],salmon:[250/255,128/255,114/255],sandybrown:[244/255,164/255,96/255],seagreen:[46/255,139/255,87/255],seashell:[1,245/255,238/255],sienna:[160/255,82/255,45/255],silver:[192/255,192/255,192/255],skyblue:[135/255,206/255,235/255],slateblue:[106/255,90/255,205/255],slategray:[112/255,128/255,144/255],slategrey:[112/255,128/255,144/255],snow:[1,250/255,250/255],springgreen:[0,1,127/255],steelblue:[70/255,130/255,180/255],tan:[210/255,180/255,140/255],teal:[0,128/255,128/255],thistle:[216/255,191/255,216/255],tomato:[1,99/255,71/255],turquoise:[64/255,224/255,208/255],violet:[238/255,130/255,238/255],wheat:[245/255,222/255,179/255],white:[1,1,1],whitesmoke:[245/255,245/255,245/255],yellow:[1,1,0],yellowgreen:[154/255,205/255,50/255]}),ac=($t=new pr({id:"srgb",name:"sRGB",base:Wt,fromBase:function(e){return e.map((function(e){var t=e<0?-1:1,\
n=e*t;return.0031308<n?t*(1.055*Math.pow(n,1/2.4)-.055):12.92*e}))},toBase:function(e){return e.map((function(e){var t=e<0?-1:1,n=e*t;return n<.04045?e/12.92:t*Math.pow((.055+n)/1.055,2.4)}))},formats:{rgb:{coords:$t=Array(3).fill("<percentage> | <number>[0, 255]")},rgb_number:{name:"rgb",commas:!0,coords:ac=Array(3).fill("<number>[0, 255]"),noAlpha:!0},color:{},rgba:{coords:$t,commas:!0,lastAlpha:!0},rgba_number:{name:"rgba",commas:!0,coords:ac},hex:{type:"custom",toGamut:!0,test:function(e){return/^#([a-f0-9]{3,4}){1,2}$/i.test(e)},parse:function(e){e.length<=5&&(e=e.replace(/[a-f0-9]/gi,"$&$&"));var t=[];return e.replace(/[a-f0-9]{2}/gi,(function(e){t.push(parseInt(e,16)/255)})),{spaceId:"srgb",coords:t.slice(0,3),alpha:t.slice(3)[0]}},serialize:function(e,t){var n=void 0===(n=(2<arguments.length&&void 0!==arguments[2]?arguments[2]:{}).collapse)||n,r=(t<1&&e.push(t),e=e.map((function(e){return Math.round(255*e)})),n&&e.every((function(e){return e%17==0})));return"#"+e.map((function(\
e){return r?(e/17).toString(16):e.toString(16).padStart(2,"0")})).join("")}},keyword:{type:"custom",test:function(e){return/^[a-z]+$/i.test(e)},parse:function(e){var t={spaceId:"srgb",coords:null,alpha:1};if("transparent"===(e=e.toLowerCase())?(t.coords=rc.black,t.alpha=0):t.coords=rc[e],t.coords)return t}}}}),new pr({id:"p3",name:"P3",base:Yt,fromBase:$t.fromBase,toBase:$t.toBase,formats:{color:{id:"display-p3"}}}));if(ws.display_space=$t,"undefined"!=typeof CSS&&CSS.supports)for(var oc=0,ic=[zs,lu,ac];oc<ic.length;oc++){var uc=ic[oc],lc=uc.getMinCoords();lc=ec({space:uc,coords:lc,alpha:1});if(CSS.supports("color",lc)){ws.display_space=uc;break}}function sc(e,t){var n=2<arguments.length&&void 0!==arguments[2]?arguments[2]:"lab",r=(n=Ts.get(n)).from(e),a=n.from(t);return Math.sqrt(r.reduce((function(e,t,n){return n=a[n],isNaN(t)||isNaN(n)?e:e+Math.pow(n-t,2)}),0))}function cc(e){return Ps(e,[Rs,"y"])}function dc(e,t){js(e,[Rs,"y"],t)}var pc=Object.freeze({__proto__:null,getLuminance:cc\
,setLuminance:dc,register:function(e){Object.defineProperty(e.prototype,"luminance",{get:function(){return cc(this)},set:function(e){dc(this,e)}})}});function fc(e){return.022<=e?e:e+Math.pow(.022-e,1.414)}function mc(e){var t=e<0?-1:1;e=Math.abs(e);return t*Math.pow(e,2.4)}var Dc=24389/27,hc=Es.D65,gc=new Ts({id:"lab-d65",name:"Lab D65",coords:{l:{refRange:[0,100],name:"L"},a:{refRange:[-125,125]},b:{refRange:[-125,125]}},white:hc,base:Rs,fromBase:function(e){return e=e.map((function(e,t){return e/hc[t]})).map((function(e){return 216/24389<e?Math.cbrt(e):(Dc*e+16)/116})),[116*e[1]-16,500*(e[0]-e[1]),200*(e[1]-e[2])]},toBase:function(e){var t=[];return t[1]=(e[0]+16)/116,t[0]=e[1]/500+t[1],t[2]=t[1]-e[2]/200,[24/116<t[0]?Math.pow(t[0],3):(116*t[0]-16)/Dc,8<e[0]?Math.pow((e[0]+16)/116,3):e[0]/Dc,24/116<t[2]?Math.pow(t[2],3):(116*t[2]-16)/Dc].map((function(e,t){return e*hc[t]}))},formats:{"lab-d65":{coords:["<number> | <percentage>","<number>","<number>"]}}}),bc=.5*Math.pow(5,.5)+.5,vc=O\
bject.freeze({__proto__:null,contrastWCAG21:function(e,t){var n;return e=Ss(e),t=Ss(t),(e=Math.max(cc(e),0))<(t=Math.max(cc(t),0))&&(e=(n=[t,e])[0],t=n[1]),(e+.05)/(t+.05)},contrastAPCA:function(e,t){t=Ss(t),e=Ss(e);var n=(t=H((t=Qs(t,"srgb")).coords,3))[0],r=t[1],a=(t=t[2],.2126729*mc(n)+.7151522*mc(r)+.072175*mc(t));n=(e=H((e=Qs(e,"srgb")).coords,3))[0],r=e[1],t=e[2],e=.2126729*mc(n)+.7151522*mc(r)+.072175*mc(t),t=(n=fc(a))<(r=fc(e)),a=Math.abs(r-n)<5e-4?0:t?1.14*(Math.pow(r,.56)-Math.pow(n,.57)):1.14*(Math.pow(r,.65)-Math.pow(n,.62));return 100*(Math.abs(a)<.1?0:0<a?a-.027:a+.027)},contrastMichelson:function(e,t){e=Ss(e),t=Ss(t);var n=((e=Math.max(cc(e),0))<(t=Math.max(cc(t),0))&&(e=(n=[t,e])[0],t=n[1]),e+t);return 0===n?0:(e-t)/n},contrastWeber:function(e,t){var n;return e=Ss(e),t=Ss(t),(e=Math.max(cc(e),0))<(t=Math.max(cc(t),0))&&(e=(n=[t,e])[0],t=n[1]),0===t?5e4:(e-t)/t},contrastLstar:function(e,t){return e=Ss(e),t=Ss(t),e=Ps(e,[zs,"l"]),t=Ps(t,[zs,"l"]),Math.abs(e-t)},contrastDe\
ltaPhi:function(e,t){return e=Ss(e),t=Ss(t),e=Ps(e,[gc,"l"]),t=Ps(t,[gc,"l"]),e=Math.abs(Math.pow(e,bc)-Math.pow(t,bc)),(t=Math.pow(e,1/bc)*Math.SQRT2-40)<7.5?0:t}});function yc(e){var t=(e=H(Ms(e,Rs),3))[0],n=e[1];return[4*t/(e=t+15*n+3*e[2]),9*n/e]}function Fc(e){var t=(e=H(Ms(e,Rs),3))[0],n=e[1];return[t/(e=t+n+e[2]),n/e]}var wc=Object.freeze({__proto__:null,uv:yc,xy:Fc,register:function(e){Object.defineProperty(e.prototype,"uv",{get:function(){return yc(this)}}),Object.defineProperty(e.prototype,"xy",{get:function(){return Fc(this)}})}}),Ec=Math.PI/180,Cc=new Ts({id:"xyz-abs-d65",name:"Absolute XYZ D65",coords:{x:{refRange:[0,9504.7],name:"Xa"},y:{refRange:[0,1e4],name:"Ya"},z:{refRange:[0,10888.3],name:"Za"}},base:Rs,fromBase:function(e){return e.map((function(e){return Math.max(203*e,0)}))},toBase:function(e){return e.map((function(e){return Math.max(e/203,0)}))}}),xc=2610/Math.pow(2,14),Ac=Math.pow(2,14)/2610,kc=3424/Math.pow(2,12),Nc=2413/Math.pow(2,7),Bc=2392/Math.pow(2,7),Tc=\
1.7*2523/Math.pow(2,5),Rc=Math.pow(2,5)/(1.7*2523),_c=16295499532821565e-27,Oc=[[.41478972,.579999,.014648],[-.20151,1.120649,.0531008],[-.0166008,.2648,.6684799]],Sc=[[1.9242264357876067,-1.0047923125953657,.037651404030618],[.35031676209499907,.7264811939316552,-.06538442294808501],[-.09098281098284752,-.3127282905230739,1.5227665613052603]],Mc=[[.5,.5,0],[3.524,-4.066708,.542708],[.199076,1.096799,-1.295875]],Pc=[[1,.1386050432715393,.05804731615611886],[.9999999999999999,-.1386050432715393,-.05804731615611886],[.9999999999999998,-.09601924202631895,-.8118918960560388]],Ic=new Ts({id:"jzazbz",name:"Jzazbz",coords:{jz:{refRange:[0,1],name:"Jz"},az:{refRange:[-.5,.5]},bz:{refRange:[-.5,.5]}},base:Cc,fromBase:function(e){var t=(e=H(e,3))[0],n=e[1];e=e[2],n=cs(Oc,[1.15*t-(1.15-1)*e,.66*n-(.66-1)*t,e]).map((function(e){var t=kc+Nc*Math.pow(e/1e4,xc);e=1+Bc*Math.pow(e/1e4,xc);return Math.pow(t/e,Tc)})),e=(t=H(cs(Mc,n),3))[0],n=t[1],t=t[2];return[(1-.56)*e/(1+-.56*e)-_c,n,t]},toBase:functi\
on(e){var t=(e=H(e,3))[0],n=e[1];e=e[2],t=cs(Pc,[(t+_c)/(1-.56- -.56*(t+_c)),n,e]).map((function(e){var t=kc-Math.pow(e,Rc);e=Bc*Math.pow(e,Rc)-Nc;return 1e4*Math.pow(t/e,Ac)})),e=(n=H(cs(Sc,t),3))[0],t=n[1];return[e=(e+(1.15-1)*(n=n[2]))/1.15,(t+(.66-1)*e)/.66,n]},formats:{color:{}}}),jc=new Ts({id:"jzczhz",name:"JzCzHz",coords:{jz:{refRange:[0,1],name:"Jz"},cz:{refRange:[0,1],name:"Chroma"},hz:{refRange:[0,360],type:"angle",name:"Hue"}},base:Ic,fromBase:function(e){var t=(e=H(e,3))[0],n=e[1],r=(e=e[2],Math.abs(n)<2e-4&&Math.abs(e)<2e-4?NaN:180*Math.atan2(e,n)/Math.PI);return[t,Math.sqrt(Math.pow(n,2)+Math.pow(e,2)),Vs(r)]},toBase:function(e){return[e[0],e[1]*Math.cos(e[2]*Math.PI/180),e[1]*Math.sin(e[2]*Math.PI/180)]},formats:{color:{}}}),Lc=2610/16384,qc=[[.3592,.6976,-.0358],[-.1922,1.1004,.0755],[.007,.0749,.8434]],zc=[[.5,.5,0],[6610/4096,-13613/4096,7003/4096],[17933/4096,-17390/4096,-543/4096]],Vc=[[.9999888965628402,.008605050147287059,.11103437159861648],[1.00001110343716,-.0\
08605050147287059,-.11103437159861648],[1.0000320633910054,.56004913547279,-.3206339100541203]],$c=[[2.0701800566956137,-1.326456876103021,.20661600684785517],[.3649882500326575,.6804673628522352,-.04542175307585323],[-.04959554223893211,-.04942116118675749,1.1879959417328034]],Hc=new Ts({id:"ictcp",name:"ICTCP",coords:{i:{refRange:[0,1],name:"I"},ct:{refRange:[-.5,.5],name:"CT"},cp:{refRange:[-.5,.5],name:"CP"}},base:Cc,fromBase:function(e){var t=e=cs(qc,e);return t=e.map((function(e){var t=.8359375+2413/128*Math.pow(e/1e4,Lc);e=1+18.6875*Math.pow(e/1e4,Lc);return Math.pow(t/e,2523/32)})),cs(zc,t)},toBase:function(e){return e=cs(Vc,e).map((function(e){var t=Math.max(Math.pow(e,32/2523)-.8359375,0);e=2413/128-18.6875*Math.pow(e,32/2523);return 1e4*Math.pow(t/e,16384/2610)})),cs($c,e)},formats:{color:{}}}),Uc=[[.8190224432164319,.3619062562801221,-.12887378261216414],[.0329836671980271,.9292868468965546,.03614466816999844],[.048177199566046255,.26423952494422764,.6335478258136937]],Gc=[\
[1.2268798733741557,-.5578149965554813,.28139105017721583],[-.04057576262431372,1.1122868293970594,-.07171106666151701],[-.07637294974672142,-.4214933239627914,1.5869240244272418]],Wc=[[.2104542553,.793617785,-.0040720468],[1.9779984951,-2.428592205,.4505937099],[.0259040371,.7827717662,-.808675766]],Yc=[[.9999999984505198,.39633779217376786,.2158037580607588],[1.0000000088817609,-.10556134232365635,-.06385417477170591],[1.0000000546724108,-.08948418209496575,-1.2914855378640917]],Kc=new Ts({id:"oklab",name:"OKLab",coords:{l:{refRange:[0,1],name:"L"},a:{refRange:[-.4,.4]},b:{refRange:[-.4,.4]}},white:"D65",base:Rs,fromBase:function(e){return e=cs(Uc,e).map((function(e){return Math.cbrt(e)})),cs(Wc,e)},toBase:function(e){return e=cs(Yc,e).map((function(e){return Math.pow(e,3)})),cs(Gc,e)},formats:{oklab:{coords:["<number> | <percentage>","<number>","<number>"]}}}),Xc=Object.freeze({__proto__:null,deltaE76:function(e,t){return sc(e,t,"lab")},deltaECMC:function(e,t){var n=void 0===(n=(r=2\
<arguments.length&&void 0!==arguments[2]?arguments[2]:{}).l)?2:n,r=void 0===(r=r.c)?1:r,a=(i=H(zs.from(e),3))[0],o=i[1],i=i[2],u=(l=H($s.from(zs,[a,o,i]),3))[1],l=l[2],s=(d=H(zs.from(t),3))[0],c=d[1],d=d[2],p=$s.from(zs,[s,c,d])[1];s=a-s,p=(u=u<0?0:u)-(p=p<0?0:p),i-=d,d=Math.pow(o-c,2)+Math.pow(i,2)-Math.pow(p,2),o=.511,16<=a&&(o=.040975*a/(1+.01765*a)),c=.0638*u/(1+.0131*u)+.638,i=164<=(l=Number.isNaN(l)?0:l)&&l<=345?.56+Math.abs(.2*Math.cos((l+168)*Ec)):.36+Math.abs(.4*Math.cos((l+35)*Ec)),a=Math.pow(u,4),u=c*((l=Math.sqrt(a/(a+1900)))*i+1-l),a=Math.pow(s/(n*o),2),a=(a+=Math.pow(p/(r*c),2))+d/Math.pow(u,2);return Math.sqrt(a)},deltaE2000:Ys,deltaEJz:function(e,t){var n=(e=H(jc.from(e),3))[0],r=e[1],a=(e=e[2],(t=H(jc.from(t),3))[0]),o=t[1];t=t[2],n-=a,a=r-o,Number.isNaN(e)&&Number.isNaN(t)?t=e=0:Number.isNaN(e)?e=t:Number.isNaN(t)&&(t=e),e-=t,t=2*Math.sqrt(r*o)*Math.sin(e/2*(Math.PI/180));return Math.sqrt(Math.pow(n,2)+Math.pow(a,2)+Math.pow(t,2))},deltaEITP:function(e,t){var n=(e=H(H\
c.from(e),3))[0],r=e[1],a=(e=e[2],(t=H(Hc.from(t),3))[0]),o=t[1];t=t[2];return 720*Math.sqrt(Math.pow(n-a,2)+.25*Math.pow(r-o,2)+Math.pow(e-t,2))},deltaEOK:function(e,t){var n=(e=H(Kc.from(e),3))[0],r=e[1],a=(e=e[2],(t=H(Kc.from(t),3))[0]);r-=t[1],e-=t[2];return Math.sqrt(Math.pow(n-a,2)+Math.pow(r,2)+Math.pow(e,2))}});function Zc(e,t){var n,r,a=(r=r=ds(r=2<arguments.length&&void 0!==arguments[2]?arguments[2]:{})?{method:r}:r).method,o=void 0===a?ws.deltaE:a,i=q(r,b);for(n in e=Ss(e),t=Ss(t),Xc)if("deltae"+o.toLowerCase()===n.toLowerCase())return Xc[n](e,t,i);throw new TypeError("Unknown deltaE method: ".concat(o))}var Jc=Object.freeze({__proto__:null,lighten:function(e){var t=1<arguments.length&&void 0!==arguments[1]?arguments[1]:.25;return js(e,[Ts.get("oklch","lch"),"l"],(function(e){return e*(1+t)}))},darken:function(e){var t=1<arguments.length&&void 0!==arguments[1]?arguments[1]:.25;return js(e,[Ts.get("oklch","lch"),"l"],(function(e){return e*(1-t)}))}});function Qc(e,t){var n=2<\
arguments.length&&void 0!==arguments[2]?arguments[2]:.5,r=3<arguments.length&&void 0!==arguments[3]?arguments[3]:{},a=(e=(a=[Ss(e),Ss(t)])[0],t=a[1],"object"===ps(n)&&(n=(a=[.5,n])[0],r=a[1]),r);return td(e,t,{space:a.space,outputSpace:a.outputSpace,premultiplied:a.premultiplied})(n)}function ed(e,t){var n,r,a=2<arguments.length&&void 0!==arguments[2]?arguments[2]:{},o=(s=(nd(e)&&(a=t,e=(s=H((n=e).rangeArgs.colors,2))[0],t=s[1]),a)).maxDeltaE,i=s.deltaEMethod,u=(a=void 0===(a=s.steps)?2:a,void 0===(l=s.maxSteps)?1e3:l),l=q(s,v),s=(n||(e=(s=[Ss(e),Ss(t)])[0],t=s[1],n=td(e,t,l)),Zc(e,t)),c=(l=0<o?Math.max(a,Math.ceil(s/o)+1):a,[]);if(void 0!==u&&(l=Math.min(l,u)),c=1===l?[{p:.5,color:n(.5)}]:(r=1/(l-1),Array.from({length:l},(function(e,t){return{p:t*=r,color:n(t)}}))),0<o)for(var d=c.reduce((function(e,t,n){return 0===n?0:(t=Zc(t.color,c[n-1].color,i),Math.max(e,t))}),0);o<d;){d=0;for(var p=1;p<c.length&&c.length<u;p++){var f=c[p-1],m=c[p],D=(m.p+f.p)/2,h=n(D);d=Math.max(d,Zc(h,f.color),\
Zc(h,m.color));c.splice(p,0,{p:D,color:n(D)}),p++}}return c=c.map((function(e){return e.color}))}function td(e,t){var n,r,a,o,i,u,l,s,c,d,p,f,m=2<arguments.length&&void 0!==arguments[2]?arguments[2]:{};return nd(e)?(a=e,o=t,td.apply(void 0,z(a.rangeArgs.colors).concat([$({},a.rangeArgs.options,o)]))):(p=m.space,f=m.outputSpace,n=m.progression,r=m.premultiplied,e=Ss(e),t=Ss(t),e=Zs(e),t=Zs(t),a={colors:[e,t],options:m},p=p?Ts.get(p):Ts.registry[ws.interpolationSpace]||e.space,f=f?Ts.get(f):p,e=Qs(e,p),t=Qs(t,p),e=Js(e),t=Js(t),p.coords.h&&"angle"===p.coords.h.type&&(o=m.hue=m.hue||"shorter",s=[(u=[Ps(e,m=[p,"h"]),Ps(t,m)])[0],u=u[1]],l="raw"===(l=o)?s:(c=(s=H(s.map(Vs),2))[0],d=(s=s[1])-c,"increasing"===l?d<0&&(s+=360):"decreasing"===l?0<d&&(c+=360):"longer"===l?-180<d&&d<180&&(0<d?s+=360:c+=360):"shorter"===l&&(180<d?c+=360:d<-180&&(s+=360)),[c,s]),i=(d=H(l,2))[0],u=d[1],js(e,m,i),js(t,m,u)),r&&(e.coords=e.coords.map((function(t){return t*e.alpha})),t.coords=t.coords.map((function(e){r\
eturn e*t.alpha}))),Object.assign((function(a){a=n?n(a):a;var o=e.coords.map((function(e,n){return hs(e,t.coords[n],a)})),i=hs(e.alpha,t.alpha,a);o={space:p,coords:o,alpha:i};return r&&(o.coords=o.coords.map((function(e){return e/i}))),f!==p?Qs(o,f):o}),{rangeArgs:a}))}function nd(e){return"function"===ps(e)&&!!e.rangeArgs}ws.interpolationSpace="lab";var rd=Object.freeze({__proto__:null,mix:Qc,steps:ed,range:td,isRange:nd,register:function(e){e.defineFunction("mix",Qc,{returns:"color"}),e.defineFunction("range",td,{returns:"function<color>"}),e.defineFunction("steps",ed,{returns:"array<color>"})}}),ad=new Ts({id:"hsl",name:"HSL",coords:{h:{refRange:[0,360],type:"angle",name:"Hue"},s:{range:[0,100],name:"Saturation"},l:{range:[0,100],name:"Lightness"}},base:$t,fromBase:function(e){var t=Math.max.apply(Math,z(e)),n=Math.min.apply(Math,z(e)),r=(e=H(e,3))[0],a=e[1],o=e[2],i=NaN,u=(e=0,(n+t)/2),l=t-n;if(0!=l){switch(e=0==u||1==u?0:(t-u)/Math.min(u,1-u),t){case r:i=(a-o)/l+(a<o?6:0);break;ca\
se a:i=(o-r)/l+2;break;case o:i=(r-a)/l+4}i*=60}return[i,100*e,100*u]},toBase:function(e){var t=(e=H(e,3))[0],n=e[1],r=e[2];function a(e){e=(e+t/30)%12;var a=n*Math.min(r,1-r);return r-a*Math.max(-1,Math.min(e-3,9-e,1))}return(t%=360)<0&&(t+=360),n/=100,r/=100,[a(0),a(8),a(4)]},formats:{hsl:{toGamut:!0,coords:["<number> | <angle>","<percentage>","<percentage>"]},hsla:{coords:["<number> | <angle>","<percentage>","<percentage>"],commas:!0,lastAlpha:!0}}}),od=new Ts({id:"hsv",name:"HSV",coords:{h:{refRange:[0,360],type:"angle",name:"Hue"},s:{range:[0,100],name:"Saturation"},v:{range:[0,100],name:"Value"}},base:ad,fromBase:function(e){var t=(e=H(e,3))[0],n=e[1];e=e[2];return[t,0==(n=(e/=100)+(n/=100)*Math.min(e,1-e))?0:200*(1-e/n),100*n]},toBase:function(e){var t=(e=H(e,3))[0],n=e[1];e=e[2];return[t,0==(n=(e/=100)*(1-(n/=100)/2))||1==n?0:(e-n)/Math.min(n,1-n)*100,100*n]},formats:{color:{toGamut:!0}}}),id=new Ts({id:"hwb",name:"HWB",coords:{h:{refRange:[0,360],type:"angle",name:"Hue"},w:{ra\
nge:[0,100],name:"Whiteness"},b:{range:[0,100],name:"Blackness"}},base:od,fromBase:function(e){var t=(e=H(e,3))[0],n=e[1];return[t,(e=e[2])*(100-n)/100,100-e]},toBase:function(e){var t=(e=H(e,3))[0],n=e[1],r=(e=e[2],(n/=100)+(e/=100));return 1<=r?[t,0,n/r*100]:[t,100*(0==(r=1-e)?0:1-n/r),100*r]},formats:{hwb:{toGamut:!0,coords:["<number> | <angle>","<percentage>","<percentage>"]}}}),ud=new pr({id:"a98rgb-linear",name:"Linear Adobe® 98 RGB compatible",white:"D65",toXYZ_M:[[.5766690429101305,.1855582379065463,.1882286462349947],[.29734497525053605,.6273635662554661,.07529145849399788],[.02703136138641234,.07068885253582723,.9913375368376388]],fromXYZ_M:[[2.0415879038107465,-.5650069742788596,-.34473135077832956],[-.9692436362808795,1.8759675015077202,.04155505740717557],[.013444280632031142,-.11836239223101838,1.0151749943912054]]}),ld=new pr({id:"a98rgb",name:"Adobe® 98 RGB compatible",base:ud,toBase:function(e){return e.map((function(e){return Math.pow(Math.abs(e),563/256)*Math.sign(e)\
}))},fromBase:function(e){return e.map((function(e){return Math.pow(Math.abs(e),256/563)*Math.sign(e)}))},formats:{color:{id:"a98-rgb"}}}),sd=new pr({id:"prophoto-linear",name:"Linear ProPhoto",white:"D50",base:Kt,toXYZ_M:[[.7977604896723027,.13518583717574031,.0313493495815248],[.2880711282292934,.7118432178101014,8565396060525902e-20],[0,0,.8251046025104601]],fromXYZ_M:[[1.3457989731028281,-.25558010007997534,-.05110628506753401],[-.5446224939028347,1.5082327413132781,.02053603239147973],[0,0,1.2119675456389454]]}),cd=new pr({id:"prophoto",name:"ProPhoto",base:sd,toBase:function(e){return e.map((function(e){return e<.03125?e/16:Math.pow(e,1.8)}))},fromBase:function(e){return e.map((function(e){return 1/512<=e?Math.pow(e,1/1.8):16*e}))},formats:{color:{id:"prophoto-rgb"}}}),dd=new Ts({id:"oklch",name:"OKLCh",coords:{l:{refRange:[0,1],name:"Lightness"},c:{refRange:[0,.4],name:"Chroma"},h:{refRange:[0,360],type:"angle",name:"Hue"}},white:"D65",base:Kc,fromBase:function(e){var t=(e=H(e,3\
))[0],n=e[1],r=(e=e[2],Math.abs(n)<2e-4&&Math.abs(e)<2e-4?NaN:180*Math.atan2(e,n)/Math.PI);return[t,Math.sqrt(Math.pow(n,2)+Math.pow(e,2)),Vs(r)]},toBase:function(e){var t,n=(e=H(e,3))[0],r=e[1];e=e[2],r=isNaN(e)?t=0:(t=r*Math.cos(e*Math.PI/180),r*Math.sin(e*Math.PI/180));return[n,t,r]},formats:{oklch:{coords:["<number> | <percentage>","<number>","<number> | <angle>"]}}}),pd=2610/Math.pow(2,14),fd=Math.pow(2,14)/2610,md=2523/Math.pow(2,5),Dd=Math.pow(2,5)/2523,hd=3424/Math.pow(2,12),gd=2413/Math.pow(2,7),bd=2392/Math.pow(2,7),vd=new pr({id:"rec2100pq",name:"REC.2100-PQ",base:Xt,toBase:function(e){return e.map((function(e){return 1e4*Math.pow(Math.max(Math.pow(e,Dd)-hd,0)/(gd-bd*Math.pow(e,Dd)),fd)/203}))},fromBase:function(e){return e.map((function(e){e=Math.max(203*e/1e4,0);var t=hd+gd*Math.pow(e,pd);e=1+bd*Math.pow(e,pd);return Math.pow(t/e,md)}))},formats:{color:{id:"rec2100-pq"}}}),yd=.17883277,Fd=.28466892,wd=.55991073,Ed=3.7743,Cd=new pr({id:"rec2100hlg",cssid:"rec2100-hlg",name:\
"REC.2100-HLG",referred:"scene",base:Xt,toBase:function(e){return e.map((function(e){return e<=.5?Math.pow(e,2)/3*Ed:Math.exp((e-wd)/yd+Fd)/12*Ed}))},fromBase:function(e){return e.map((function(e){return(e/=Ed)<=1/12?Math.sqrt(3*e):yd*Math.log(12*e-Fd)+wd}))},formats:{color:{id:"rec2100-hlg"}}}),xd={};function Ad(e){var t=e.id;e.toCone_M,e.fromCone_M,xd[t]=e}function kd(e,t,n){var r=xd[2<arguments.length&&void 0!==n?n:"Bradford"],a=(i=H(cs(r.toCone_M,e),3))[0],o=i[1],i=i[2],u=H(cs(r.toCone_M,t),3);a=cs([[u[0]/a,0,0],[0,u[1]/o,0],[0,0,u[2]/i]],r.toCone_M);return cs(r.fromCone_M,a)}Fs.add("chromatic-adaptation-start",(function(e){e.options.method&&(e.M=kd(e.W1,e.W2,e.options.method))})),Fs.add("chromatic-adaptation-end",(function(e){e.M||(e.M=kd(e.W1,e.W2,e.options.method))})),Ad({id:"von Kries",toCone_M:[[.40024,.7076,-.08081],[-.2263,1.16532,.0457],[0,0,.91822]],fromCone_M:[[1.8599364,-1.1293816,.2198974],[.3611914,.6388125,-64e-7],[0,0,1.0890636]]}),Ad({id:"Bradford",toCone_M:[[.8951,\
.2664,-.1614],[-.7502,1.7135,.0367],[.0389,-.0685,1.0296]],fromCone_M:[[.9869929,-.1470543,.1599627],[.4323053,.5183603,.0492912],[-.0085287,.0400428,.9684867]]}),Ad({id:"CAT02",toCone_M:[[.7328,.4296,-.1624],[-.7036,1.6975,.0061],[.003,.0136,.9834]],fromCone_M:[[1.0961238,-.278869,.1827452],[.454369,.4735332,.0720978],[-.0096276,-.005698,1.0153256]]}),Ad({id:"CAT16",toCone_M:[[.401288,.650173,-.051461],[-.250268,1.204414,.045854],[-.002079,.048952,.953127]],fromCone_M:[[1.862067855087233,-1.011254630531685,.1491867754444518],[.3875265432361372,.6214474419314753,-.008973985167612518],[-.01584149884933386,-.03412293802851557,1.04996443687785]]}),Object.assign(Es,{A:[1.0985,1,.35585],C:[.98074,1,1.18232],D55:[.95682,1,.92149],D75:[.94972,1,1.22638],E:[1,1,1],F2:[.99186,1,.67393],F7:[.95041,1,1.08747],F11:[1.00962,1,.6435]}),Es.ACES=[.32168/.33767,1,.34065/.33767];var Nd=new pr({id:"acescg",name:"ACEScg",coords:{r:{range:[0,65504],name:"Red"},g:{range:[0,65504],name:"Green"},b:{range:[0,6\
5504],name:"Blue"}},referred:"scene",white:Es.ACES,toXYZ_M:[[.6624541811085053,.13400420645643313,.1561876870049078],[.27222871678091454,.6740817658111484,.05368951740793705],[-.005574649490394108,.004060733528982826,1.0103391003129971]],fromXYZ_M:[[1.6410233796943257,-.32480329418479,-.23642469523761225],[-.6636628587229829,1.6153315916573379,.016756347685530137],[.011721894328375376,-.008284441996237409,.9883948585390215]],formats:{color:{}}}),Bd=Math.pow(2,-16),Td=-.35828683,Rd=(Math.log2(65504)+9.72)/17.52,_d=(pr=new pr({id:"acescc",name:"ACEScc",coords:{r:{range:[Td,Rd],name:"Red"},g:{range:[Td,Rd],name:"Green"},b:{range:[Td,Rd],name:"Blue"}},referred:"scene",base:Nd,toBase:function(e){return e.map((function(e){return e<=(9.72-15)/17.52?2*(Math.pow(2,17.52*e-9.72)-Bd):e<Rd?Math.pow(2,17.52*e-9.72):65504}))},fromBase:function(e){return e.map((function(e){return e<=0?(Math.log2(Bd)+9.72)/17.52:e<Bd?(Math.log2(Bd+.5*e)+9.72)/17.52:(Math.log2(e)+9.72)/17.52}))},formats:{color:{}}}),Ob\
ject.freeze({__proto__:null,XYZ_D65:Rs,XYZ_D50:Kt,XYZ_ABS_D65:Cc,Lab_D65:gc,Lab:zs,LCH:$s,sRGB_Linear:Wt,sRGB:$t,HSL:ad,HWB:id,HSV:od,P3_Linear:Yt,P3:ac,A98RGB_Linear:ud,A98RGB:ld,ProPhoto_Linear:sd,ProPhoto:cd,REC_2020_Linear:Xt,REC_2020:lu,OKLab:Kc,OKLCH:dd,Jzazbz:Ic,JzCzHz:jc,ICTCP:Hc,REC_2100_PQ:vd,REC_2100_HLG:Cd,ACEScg:Nd,ACEScc:pr})),Od=(ue=new WeakMap,K(Sd,[{key:"space",get:function(){return P(this,ue)}},{key:"spaceId",get:function(){return P(this,ue).id}},{key:"clone",value:function(){return new Sd(this.space,this.coords,this.alpha)}},{key:"toJSON",value:function(){return{spaceId:this.spaceId,coords:this.coords,alpha:this.alpha}}},{key:"display",value:function(){for(var e=arguments.length,t=new Array(e),n=0;n<e;n++)t[n]=arguments[n];var r=function(e){var t=void 0===(t=(n=1<arguments.length&&void 0!==arguments[1]?arguments[1]:{}).space)?ws.display_space:t,n=q(n,h),r=ec(e,n);return"undefined"==typeof CSS||CSS.supports("color",r)||!ws.display_space?(r=new String(r)).color=e:(t=Qs\
(e,t),(r=new String(ec(t,n))).color=t),r}.apply(void 0,[this].concat(t));return r.color=new Sd(r.color),r}}],[{key:"get",value:function(e){if(e instanceof Sd)return e;for(var t=arguments.length,n=new Array(1<t?t-1:0),r=1;r<t;r++)n[r-1]=arguments[r];return A(Sd,[e].concat(n))}},{key:"defineFunction",value:function(e,t){function n(){var e,n=t.apply(void 0,arguments);return"color"===o?n=Sd.get(n):"function<color>"===o?(e=n,n=function(){var t=e.apply(void 0,arguments);return Sd.get(t)},Object.assign(n,e)):"array<color>"===o&&(n=n.map((function(e){return Sd.get(e)}))),n}var r=2<arguments.length&&void 0!==arguments[2]?arguments[2]:t,a=void 0===(a=r.instance)||a,o=r.returns;e in Sd||(Sd[e]=n),a&&(Sd.prototype[e]=function(){for(var e=arguments.length,t=new Array(e),r=0;r<e;r++)t[r]=arguments[r];return n.apply(void 0,[this].concat(t))})}},{key:"defineFunctions",value:function(e){for(var t in e)Sd.defineFunction(t,e[t],e[t])}},{key:"extend",value:function(e){if(e.register)e.register(Sd);else for\
(var t in e)Sd.defineFunction(t,e[t])}}]),Sd);function Sd(){var e=this;W(this,Sd),O(this,ue,{writable:!0,value:void 0});for(var t,n,r,a=arguments.length,o=new Array(a),i=0;i<a;i++)o[i]=arguments[i];r=(r=1===o.length?Ss(o[0]):r)?(t=r.space||r.spaceId,n=r.coords,r.alpha):(t=o[0],n=o[1],o[2]),j(this,ue,Ts.get(t)),this.coords=n?n.slice():[0,0,0],this.alpha=r<1?r:1;for(var u=0;u<this.coords.length;u++)"NaN"===this.coords[u]&&(this.coords[u]=NaN);for(var l in P(this,ue).coords)!function(t){Object.defineProperty(e,t,{get:function(){return e.get(t)},set:function(n){return e.set(t,n)}})}(l)}Od.defineFunctions({get:Ps,getAll:Ms,set:js,setAll:Is,to:Qs,equals:function(e,t){return e=Ss(e),t=Ss(t),e.space===t.space&&e.alpha===t.alpha&&e.coords.every((function(e,n){return e===t.coords[n]}))},inGamut:Xs,toGamut:Js,distance:sc,toString:ec}),Object.assign(Od,{util:Zn,hooks:Fs,WHITES:Es,Space:Ts,spaces:Ts.registry,parse:Os,defaults:ws});for(var Md,Pd=0,Id=Object.keys(_d);Pd<Id.length;Pd++){var jd=Id[Pd];\
Ts.register(_d[jd])}for(Md in Ts.registry)Ld(Md,Ts.registry[Md]);function Ld(e,t){Object.keys(t.coords),Object.values(t.coords).map((function(e){return e.name}));var n=e.replace(/-/g,"_");Object.defineProperty(Od.prototype,n,{get:function(){var n=this,r=this.getAll(e);return"undefined"==typeof Proxy?r:new Proxy(r,{has:function(e,n){try{return Ts.resolveCoord([t,n]),!0}catch(e){}return Reflect.has(e,n)},get:function(e,n,r){if(n&&"symbol"!==a(n)&&!(n in e)){var o=Ts.resolveCoord([t,n]).index;if(0<=o)return e[o]}return Reflect.get(e,n,r)},set:function(r,o,i,u){if(o&&"symbol"!==a(o)&&!(o in r)||0<=o){var l=Ts.resolveCoord([t,o]).index;if(0<=l)return r[l]=i,n.setAll(e,r),!0}return Reflect.set(r,o,i,u)}})},set:function(t){this.setAll(e,t)},configurable:!0,enumerable:!0})}Fs.add("colorspace-init-end",(function(e){var t;Ld(e.id,e),null!=(t=e.aliases)&&t.forEach((function(t){Ld(t,e)}))})),Od.extend(Xc),Od.extend({deltaE:Zc}),Od.extend(Jc),Od.extend({contrast:function(e,t){var n,r=2<arguments.le\
ngth&&void 0!==arguments[2]?arguments[2]:{},a=(r=r=ds(r)?{algorithm:r}:r).algorithm,o=q(r,g);if(!a)throw r=Object.keys(vc).map((function(e){return e.replace(/^contrast/,"")})).join(", "),new TypeError("contrast() function needs a contrast algorithm. Please specify one of: ".concat(r));for(n in e=Ss(e),t=Ss(t),vc)if("contrast"+a.toLowerCase()===n.toLowerCase())return vc[n](e,t,o);throw new TypeError("Unknown contrast algorithm: ".concat(a))}}),Od.extend(wc),Od.extend(pc),Od.extend(rd),Od.extend(vc),ls.default.templateSettings.strip=!1;var qd=/^#[0-9a-f]{3,8}$/i,zd=/hsl\\(\\s*([\\d.]+)(rad|turn)/;function Vd(e,t,n){var r=3<arguments.length&&void 0!==arguments[3]?arguments[3]:1;W(this,Vd),this.red=e,this.green=t,this.blue=n,this.alpha=r}K(Vd,[{key:"toHexString",value:function(){var e=Math.round(this.red).toString(16),t=Math.round(this.green).toString(16),n=Math.round(this.blue).toString(16);return"#"+(15.5<this.red?e:"0"+e)+(15.5<this.green?t:"0"+t)+(15.5<this.blue?n:"0"+n)}},{key:"toJSON",v\
alue:function(){return{red:this.red,green:this.green,blue:this.blue,alpha:this.alpha}}},{key:"parseString",value:function(e){e=e.replace(zd,(function(e,t,n){var r=t+n;switch(n){case"rad":return e.replace(r,180*t/Math.PI);case"turn":return e.replace(r,360*t)}}));try{var t=new Od(e).to("srgb");this.red=Math.round(255*Hd(t.r,0,1)),this.green=Math.round(255*Hd(t.g,0,1)),this.blue=Math.round(255*Hd(t.b,0,1)),this.alpha=+t.alpha}catch(t){throw new Error('Unable to parse color "'.concat(e,'"'))}return this}},{key:"parseRgbString",value:function(e){this.parseString(e)}},{key:"parseHexString",value:function(e){e.match(qd)&&![6,8].includes(e.length)&&this.parseString(e)}},{key:"parseColorFnString",value:function(e){this.parseString(e)}},{key:"getRelativeLuminance",value:function(){var e=this.red/255,t=this.green/255,n=this.blue/255;return.2126*(e<=.03928?e/12.92:Math.pow((.055+e)/1.055,2.4))+.7152*(t<=.03928?t/12.92:Math.pow((.055+t)/1.055,2.4))+.0722*(n<=.03928?n/12.92:Math.pow((.055+n)/1.055,2\
.4))}}]);var $d=Vd;function Hd(e,t,n){return Math.min(Math.max(t,e),n)}var Ud=function(e){var t=new $d;return t.parseString(e.getPropertyValue("background-color")),0!==t.alpha&&(e=e.getPropertyValue("opacity"),t.alpha=t.alpha*e),t},Gd=function(e){var n=t.getComputedStyle(e);return os(e,n)||1===Ud(n).alpha};function Wd(e){var t;return!(!e.href||(t=sa.get("firstPageLink",Yd))&&e.compareDocumentPosition(t.actualNode)!==e.DOCUMENT_POSITION_FOLLOWING)}function Yd(){return(t.location.origin?Cf(o._tree,'a[href]:not([href^="javascript:"])').find((function(e){return!Vi(e.actualNode)})):Cf(o._tree,'a:not([href^="#"]):not([href^="/#"]):not([href^="javascript:"])')[0])||null}var Kd=/rect\\s*\\(([0-9]+)px,?\\s*([0-9]+)px,?\\s*([0-9]+)px,?\\s*([0-9]+)px\\s*\\)/,Xd=/(\\w+)\\((\\d+)/;var Zd=function e(n,r,a){if(!n)throw new TypeError("Cannot determine if element is visible for non-DOM nodes");var i,u,l,s=n instanceof vr?n:ca(n),c=(n=s?s.actualNode:n,"_isVisible"+(r?"ScreenReader":"")),d=(p=null!=(p=t.Node)?p:{}\
).DOCUMENT_NODE,p=p.DOCUMENT_FRAGMENT_NODE,f=(s?s.props:n).nodeType,m=s?s.props.nodeName:n.nodeName.toLowerCase();return s&&void 0!==s[c]?s[c]:f===d||!["style","script","noscript","template"].includes(m)&&(n&&f===p&&(n=n.host),(!r||"true"!==(s?s.attr("aria-hidden"):n.getAttribute("aria-hidden")))&&(n?null!==(d=t.getComputedStyle(n,null))&&("area"===m?(i=r,u=a,!!(p=Ro(f=n,"map"))&&!!(p=p.getAttribute("name"))&&!(!(f=No(f))||9!==f.nodeType||!(l=Cf(o._tree,'img[usemap="#'.concat(Mr(p),'"]')))||!l.length)&&l.some((function(t){return e(t.actualNode,i,u)}))):"none"!==d.getPropertyValue("display")&&(m=parseInt(d.getPropertyValue("height")),f=parseInt(d.getPropertyValue("width")),l=(p=Hp(n))&&0===m,p=p&&0===f,m="absolute"===d.getPropertyValue("position")&&(m<2||f<2)&&"hidden"===d.getPropertyValue("overflow"),!(!r&&(function(e){var t=e.getPropertyValue("clip").match(Kd),n=e.getPropertyValue("clip-path").match(Xd);if(t&&5===t.length&&(e=e.getPropertyValue("position"),["fixed","absolute"].include\
s(e)))return t[3]-t[1]<=0&&t[2]-t[4]<=0;if(n){e=n[1];var r=parseInt(n[2],10);switch(e){case"inset":return 50<=r;case"circle":return 0===r}}}(d)||"0"===d.getPropertyValue("opacity")||l||p||m)||!a&&("hidden"===d.getPropertyValue("visibility")||!r&&ni(n))))&&(f=!1,(p=n.assignedSlot||n.parentNode)&&(f=e(p,r,!0)),s&&(s[c]=f),f)):(m=!0,(a=s.parent)&&(m=e(a,r,!0)),s&&(s[c]=m),m)))},Jd=function(e,n){for(var r=["fixed","sticky"],a=[],o=!1,i=0;i<e.length;++i){var u=e[i],l=(u===n&&(o=!0),t.getComputedStyle(u));o||-1===r.indexOf(l.position)?a.push(u):a=[]}return a};function Qd(e,n){var r=ep(n);do{var a,o,i,u,l,s,c=ep(e);if(c===r||c===n)return u=e,a=n,i=(o=t.getComputedStyle(a)).getPropertyValue("overflow"),"inline"===o.getPropertyValue("display")||(u=Array.from(u.getClientRects()),l=a.getBoundingClientRect(),s={left:l.left,top:l.top,width:l.width,height:l.height},(["scroll","auto"].includes(i)||a instanceof t.HTMLHtmlElement)&&(s.width=a.scrollWidth,s.height=a.scrollHeight),1===u.length&&"hidden"=\
==i&&"nowrap"===o.getPropertyValue("white-space")&&(u[0]=s),u.some((function(e){return!(Math.ceil(e.left)<Math.floor(s.left)||Math.ceil(e.top)<Math.floor(s.top)||Math.floor(e.left+e.width)>Math.ceil(s.left+s.width)||Math.floor(e.top+e.height)>Math.ceil(s.top+s.height))})))}while(e=c);return!1}function ep(e){for(var t=ca(e).parent;t;){if(Hp(t.actualNode))return t.actualNode;t=t.parent}}var tp,np=function e(t,n){var a=2<arguments.length&&void 0!==arguments[2]?arguments[2]:r,o=3<arguments.length&&void 0!==arguments[3]?arguments[3]:0;if(999<o)throw new Error("Infinite loop detected");return Array.from(a.elementsFromPoint(t,n)||[]).filter((function(e){return No(e)===a})).reduce((function(r,a){var i;return xo(a)&&(i=e(t,n,a.shadowRoot,o+1),!(r=r.concat(i)).length||!Qd(r[0],a))||r.push(a),r}),[])},rp=function(e,t){var n,a;if(e.hasAttribute(t))return a=e.nodeName.toUpperCase(),n=e,["A","AREA"].includes(a)&&!e.ownerSVGElement||((n=r.createElement("a")).href=e.getAttribute(t)),a=["https:","ftps:\
"].includes(n.protocol)?n.protocol.replace(/s:$/,":"):n.protocol,t=(e=(e=(t=e=/^\\//.test(n.pathname)?n.pathname:"/".concat(n.pathname)).split("/").pop())&&-1!==e.indexOf(".")?{pathname:t.replace(e,""),filename:/index./.test(e)?"":e}:{pathname:t,filename:""}).pathname,e=e.filename,{protocol:a,hostname:n.hostname,port:(a=n.port,["443","80"].includes(a)?"":a),pathname:/\\/$/.test(t)?t:"".concat(t,"/"),search:function(e){var t={};if(e&&e.length){var n=e.substring(1).split("&");if(n&&n.length)for(var r=0;r<n.length;r++){var a=(o=H(n[r].split("="),2))[0],o=void 0===(o=o[1])?"":o;t[decodeURIComponent(a)]=decodeURIComponent(o)}}return t}(n.search),hash:(a=n.hash)&&(t=a.match(/#!?\\/?/g))&&"#"!==H(t,1)[0]?a:"",filename:e}},ap=function(e,n){var r=n.getBoundingClientRect(),a=r.top,o=r.left,i=a-n.scrollTop,u=(a=a-n.scrollTop+n.scrollHeight,o-n.scrollLeft);o=o-n.scrollLeft+n.scrollWidth;return!(e.left>o&&e.left>r.right||e.top>a&&e.top>r.bottom||e.right<u&&e.right<r.left||e.bottom<i&&e.bottom<r.top)&&\
(o=t.getComputedStyle(n),!(e.left>r.right||e.top>r.bottom)||"scroll"===o.overflow||"auto"===o.overflow||n instanceof t.HTMLBodyElement||n instanceof t.HTMLHtmlElement)},op=0;function ip(e,t,n){var r;return W(this,ip),(r=tp.call(this)).shadowId=n,r.children=[],r.actualNode=e,(r.parent=t)||(op=0),r.nodeIndex=op++,r._isHidden=null,r._cache={},r._isXHTML=Hr(e.ownerDocument),"input"===e.nodeName.toLowerCase()&&(n=e.getAttribute("type"),n=r._isXHTML?n:(n||"").toLowerCase(),Of().includes(n)||(n="text"),r._type=n),sa.get("nodeMap")&&sa.get("nodeMap").set(e,T(r)),r}k(ip,vr),tp=B(ip),K(ip,[{key:"props",get:function(){var e,t,n,r;return this._cache.hasOwnProperty("props")||(e=(r=this.actualNode).nodeType,t=r.nodeName,n=r.id,r=r.nodeValue,this._cache.props={nodeType:e,nodeName:this._isXHTML?t:t.toLowerCase(),id:n,type:this._type,nodeValue:r},1===e&&(this._cache.props.multiple=this.actualNode.multiple,this._cache.props.value=this.actualNode.value,this._cache.props.selected=this.actualNode.selected,\
this._cache.props.checked=this.actualNode.checked,this._cache.props.indeterminate=this.actualNode.indeterminate)),this._cache.props}},{key:"attr",value:function(e){return"function"!=typeof this.actualNode.getAttribute?null:this.actualNode.getAttribute(e)}},{key:"hasAttr",value:function(e){return"function"==typeof this.actualNode.hasAttribute&&this.actualNode.hasAttribute(e)}},{key:"attrNames",get:function(){var e;return this._cache.hasOwnProperty("attrNames")||(e=(this.actualNode.attributes instanceof t.NamedNodeMap?this.actualNode:this.actualNode.cloneNode(!1)).attributes,this._cache.attrNames=Array.from(e).map((function(e){return e.name}))),this._cache.attrNames}},{key:"getComputedStylePropertyValue",value:function(e){var n="computedStyle_"+e;return this._cache.hasOwnProperty(n)||(this._cache.hasOwnProperty("computedStyle")||(this._cache.computedStyle=t.getComputedStyle(this.actualNode)),this._cache[n]=this._cache.computedStyle.getPropertyValue(e)),this._cache[n]}},{key:"isFocusable"\
,get:function(){return this._cache.hasOwnProperty("isFocusable")||(this._cache.isFocusable=Xi(this.actualNode)),this._cache.isFocusable}},{key:"tabbableElements",get:function(){return this._cache.hasOwnProperty("tabbableElements")||(this._cache.tabbableElements=Yi(this)),this._cache.tabbableElements}},{key:"clientRects",get:function(){return this._cache.hasOwnProperty("clientRects")||(this._cache.clientRects=Array.from(this.actualNode.getClientRects()).filter((function(e){return 0<e.width}))),this._cache.clientRects}},{key:"boundingClientRect",get:function(){return this._cache.hasOwnProperty("boundingClientRect")||(this._cache.boundingClientRect=this.actualNode.getBoundingClientRect()),this._cache.boundingClientRect}}]);var up,lp=ip,sp=function(e){return(e||"").trim().replace(/\\s{2,}/g," ").split(" ")},cp=" [idsMap]";function dp(e,t,n){var r=e[0]._selectorMap;if(r){for(var a=e[0].shadowId,o=0;o<t.length;o++)if(1<t[o].length&&t[o].some(pp))return;var i=new Set,u=(t.forEach((function(e){\
var t,n=function(e,t,n){var r=e[e.length-1],a=null,o=1<e.length||!!r.pseudos||!!r.classes;if(pp(r))a=t["*"];else{if(r.id){if(!t[cp]||!Object.hasOwn(t[cp],r.id)||null==(e=t[cp][r.id])||!e.length)return;a=t[cp][r.id].filter((function(e){return e.shadowId===n}))}if(r.tag&&"*"!==r.tag){if(null==(e=t[r.tag])||!e.length)return;e=t[r.tag];a=a?fp(e,a):e}if(r.classes){if(null==(e=t["[class]"])||!e.length)return;e=t["[class]"],a=a?fp(e,a):e}if(r.attributes)for(var i=0;i<r.attributes.length;i++){var u=r.attributes[i];if("attrValue"===u.type&&(o=!0),null==(l=t["[".concat(u.key,"]")])||!l.length)return;var l=t["[".concat(u.key,"]")];a=a?fp(l,a):l}}return{nodes:a,isComplexSelector:o}}(e,r,a);null!=n&&null!=(t=n.nodes)&&t.forEach((function(t){n.isComplexSelector&&!Ca(t,e)||i.add(t)}))})),[]);return i.forEach((function(e){return u.push(e)})),(u=n?u.filter(n):u).sort((function(e,t){return e.nodeIndex-t.nodeIndex}))}}function pp(e){return"*"===e.tag&&!e.attributes&&!e.id&&!e.classes}function fp(e,t){ret\
urn e.filter((function(e){return t.includes(e)}))}function mp(e,t,n){Object.hasOwn(n,e)||(n[e]=[]),n[e].push(t)}function Dp(e,t){1===e.props.nodeType&&(mp(e.props.nodeName,e,t),mp("*",e,t),e.attrNames.forEach((function(n){"id"===n&&(t[cp]=t[cp]||{},sp(e.attr(n)).forEach((function(n){mp(n,e,t[cp])}))),mp("[".concat(n,"]"),e,t)})))}function hp(){var e=0<arguments.length&&void 0!==arguments[0]?arguments[0]:r.documentElement,n=1<arguments.length?arguments[1]:void 0,a=(up=!1,{});sa.set("nodeMap",new WeakMap),sa.set("selectorMap",a),e=function e(n,r,a){var o,i,u;function l(t,n,a){return(n=e(n,r,a))?t.concat(n):t}return n.documentElement&&(n=n.documentElement),u=n.nodeName.toLowerCase(),xo(n)?(up=!0,o=gp(n,a,r),r="a"+Math.random().toString().substring(2),i=Array.from(n.shadowRoot.childNodes),o.children=i.reduce((function(e,t){return l(e,t,o)}),[]),[o]):"content"===u&&"function"==typeof n.getDistributedNodes?(i=Array.from(n.getDistributedNodes())).reduce((function(e,t){return l(e,t,a)}),[]):"s\
lot"===u&&"function"==typeof n.assignedNodes?((i=Array.from(n.assignedNodes())).length||(i=function(e){var t=[];for(e=e.firstChild;e;)t.push(e),e=e.nextSibling;return t}(n)),t.getComputedStyle(n),i.reduce((function(e,t){return l(e,t,a)}),[])):1===n.nodeType?(o=gp(n,a,r),i=Array.from(n.childNodes),o.children=i.reduce((function(e,t){return l(e,t,o)}),[]),[o]):3===n.nodeType?[gp(n,a)]:void 0}(e,n,null);return e[0]._selectorMap=a,e[0]._hasShadowRoot=up,e}function gp(e,t,n){return Dp(e=new lp(e,t,n),sa.get("selectorMap")),e}var bp=function(e){return e?e.trim().split("-")[0].toLowerCase():""},vp=function(e){var t={};return t.none=e.none.concat(e.all),t.any=e.any,Object.keys(t).map((function(e){var n;return t[e].length&&(n=o._audit.data.failureSummaries[e])&&"function"==typeof n.failureMessage?n.failureMessage(t[e].map((function(e){return e.message||""}))):void 0})).filter((function(e){return void 0!==e})).join("\\n\\n")};function yp(){var e=o._audit.data.incompleteFallbackMessage;return"string\
"!=typeof(e="function"==typeof e?e():e)?"":e}var Fp=Dr.resultGroups;function wp(e,t){var n=o.utils.aggregateResult(e);return Fp.forEach((function(e){t.resultTypes&&!t.resultTypes.includes(e)&&(n[e]||[]).forEach((function(e){Array.isArray(e.nodes)&&0<e.nodes.length&&(e.nodes=[e.nodes[0]])})),n[e]=(n[e]||[]).map((function(e){return e=Object.assign({},e),Array.isArray(e.nodes)&&0<e.nodes.length&&(e.nodes=e.nodes.map((function(e){var n,r,o;return"object"===a(e.node)&&(n=Ep(e.node,t),Object.assign(e,n)),delete e.result,delete e.node,r=e,o=t,["any","all","none"].forEach((function(e){Array.isArray(r[e])&&r[e].filter((function(e){return Array.isArray(e.relatedNodes)})).forEach((function(e){e.relatedNodes=e.relatedNodes.map((function(e){return Ep(e,o)}))}))})),e}))),Fp.forEach((function(t){return delete e[t]})),delete e.pageLevel,delete e.result,e}))})),n}function Ep(e,t){var n,r=0<arguments.length&&void 0!==e?e:{},a=1<arguments.length?t:void 0,i=(r=Do.dqElmToSpec(r,a),{});return o._audit.noHtm\
l?i.html=null:i.html=null!=(n=r.source)?n:"Undefined",a.elementRef&&!r.fromFrame&&(i.element=null!=(n=r.element)?n:null),!1===a.selectors&&!r.fromFrame||(i.target=null!=(n=r.selector)?n:[":root"]),a.ancestry&&(i.ancestry=null!=(n=r.ancestry)?n:[":root"]),a.xpath&&(i.xpath=null!=(n=r.xpath)?n:["/"]),i}var Cp=/\\$\\{\\s?data\\s?\\}/g;function xp(e,t){if("string"==typeof t)return e.replace(Cp,t);for(var n in t){var r;t.hasOwnProperty(n)&&(r=new RegExp("\\\\\${\\\\s?data\\\\."+n+"\\\\s?}","g"),n=void 0===t[n]?"":String(t[n]),e=e.replace(r,n))}return e}var Ap=function e(t,n){var r;if(t)return Array.isArray(n)?(n.values=n.join(", "),"string"==typeof t.singular&&"string"==typeof t.plural?xp(1===n.length?t.singular:t.plural,n):xp(t,n)):"string"==typeof t?xp(t,n):"string"==typeof n?xp(t[n],n):(r=t.default||yp(),e(r=n&&n.messageKey&&t[n.messageKey]?t[n.messageKey]:r,n))},kp=function(e,t,n){var r=o._audit.data.checks[e];if(!r)throw new Error("Cannot get message for unknown check: ".concat(e,"."));if(r.messages\
[t])return Ap(r.messages[t],n);throw new Error('Check "'.concat(e,'"" does not have a "').concat(t,'" message.'))},Np=function(e,t,n){t=((n.rules&&n.rules[t]||{}).checks||{})[e.id];var r=(n.checks||{})[e.id],a=e.enabled;e=e.options;return r&&(r.hasOwnProperty("enabled")&&(a=r.enabled),r.hasOwnProperty("options"))&&(e=r.options),t&&(t.hasOwnProperty("enabled")&&(a=t.enabled),t.hasOwnProperty("options"))&&(e=t.options),{enabled:a,options:e,absolutePaths:n.absolutePaths}};function Bp(){var e,n,r,i,u=0<arguments.length&&void 0!==arguments[0]?arguments[0]:null,l=1<arguments.length&&void 0!==arguments[1]?arguments[1]:t;return u&&"object"===a(u)?u:"object"!==a(l)?{}:{testEngine:{name:"axe-core",version:o.version},testRunner:{name:o._audit.brand},testEnvironment:(u=l).navigator&&"object"===a(u.navigator)?(e=u.navigator,n=u.innerHeight,r=u.innerWidth,u=function(e){return(e=e.screen).orientation||e.msOrientation||e.mozOrientation}(u)||{},i=u.angle,u=u.type,{userAgent:e.userAgent,windowWidth:r,wi\
ndowHeight:n,orientationAngle:i,orientationType:u}):{},timestamp:(new Date).toISOString(),url:null==(e=l.location)?void 0:e.href}}function Tp(e,t){var n=t.focusable;t=t.page;return{node:e,include:[],exclude:[],initiator:!1,focusable:n&&(!(n=(n=e).getAttribute("tabindex"))||(n=parseInt(n,10),isNaN(n))||0<=n),size:function(e){var t=parseInt(e.getAttribute("width"),10),n=parseInt(e.getAttribute("height"),10);return(isNaN(t)||isNaN(n))&&(e=e.getBoundingClientRect(),t=isNaN(t)?e.width:t,n=isNaN(n)?e.height:n),{width:t,height:n}}(e),page:t}}function Rp(e){var n=0<arguments.length&&void 0!==e?e:[],r=[];Pp(n)||(n=[n]);for(var a=0;a<n.length;a++){var o=function(e){return e instanceof t.Node?e:"string"==typeof e?[e]:(Sp(e)?(function(e){Ip(Array.isArray(e.fromFrames),"fromFrames property must be an array"),Ip(e.fromFrames.every((function(e){return!jp(e,"fromFrames")})),"Invalid context; fromFrames selector must be appended, rather than nested"),Ip(!jp(e,"fromShadowDom"),"fromFrames and fromShadow\
Dom cannot be used on the same object")}(e),e=e.fromFrames):Mp(e)&&(e=[e]),function(e){if(Array.isArray(e)){var t,n=[],r=Z(e);try{for(r.s();!(t=r.n()).done;){var a=t.value;if(Mp(a)&&(function(e){Ip(Array.isArray(e.fromShadowDom),"fromShadowDom property must be an array"),Ip(e.fromShadowDom.every((function(e){return!jp(e,"fromFrames")})),"shadow selector must be inside fromFrame instead"),Ip(e.fromShadowDom.every((function(e){return!jp(e,"fromShadowDom")})),"fromShadowDom selector must be appended, rather than nested")}(a),a=a.fromShadowDom),"string"!=typeof a&&!function(e){return Array.isArray(e)&&e.every((function(e){return"string"==typeof e}))}(a))return;n.push(a)}}catch(e){r.e(e)}finally{r.f()}return n}}(e))}(n[a]);o&&r.push(o)}return r}function _p(e){return["include","exclude"].some((function(t){return jp(e,t)&&Op(e[t])}))}function Op(e){return"string"==typeof e||e instanceof t.Node||Sp(e)||Mp(e)||Pp(e)}function Sp(e){return jp(e,"fromFrames")}function Mp(e){return jp(e,"fromShadow\
Dom")}function Pp(e){return e&&"object"===a(e)&&"number"==typeof e.length&&e instanceof t.Node==0}function Ip(e,t){Or(e,"Invalid context; ".concat(t,"\\nSee: https://github.com/dequelabs/axe-core/blob/master/doc/context.md"))}function jp(e,t){return!(!e||"object"!==a(e))&&Object.prototype.hasOwnProperty.call(e,t)}function Lp(e,n){for(var r=[],a=0,o=e[n].length;a<o;a++){var i=e[n][a];i instanceof t.Node?i.documentElement instanceof t.Node?r.push(e.flatTree[0]):r.push(ca(i)):i&&i.length&&(1<i.length?function(e,t,n){e.frames=e.frames||[],_f(n.shift()).forEach((function(r){var a=e.frames.find((function(e){return e.node===r}));a||(a=Tp(r,e),e.frames.push(a)),a[t].push(n)}))}(e,n,i):(i=_f(i[0]),r.push.apply(r,z(i.map((function(e){return ca(e)}))))))}return r.filter((function(e){return e}))}function qp(e,n){var o=this,i=(e=Da(e),this.frames=[],this.page="boolean"==typeof(null==(i=e)?void 0:i.page)?e.page:void 0,this.initiator="boolean"!=typeof(null==(i=e)?void 0:i.initiator)||e.initiator,this.\
focusable="boolean"!=typeof(null==(i=e)?void 0:i.focusable)||e.focusable,this.size="object"===a(null==(i=e)?void 0:i.size)?e.size:{},e=function(e){if(_p(e)){var t=" must be used inside include or exclude. It should not be on the same object.";Ip(!jp(e,"fromFrames"),"fromFrames"+t),Ip(!jp(e,"fromShadowDom"),"fromShadowDom"+t)}else{if(!Op(e))return{include:[r],exclude:[]};e={include:e,exclude:[]}}return 0===(t=Rp(e.include)).length&&t.push(r),{include:t,exclude:e=Rp(e.exclude)}}(e),this.flatTree=null!=n?n:hp(function(e){for(var n=e.include,a=(e=e.exclude,Array.from(n).concat(Array.from(e))),o=0;o<a.length;o++){var i=a[o];if(i instanceof t.Element)return i.ownerDocument.documentElement;if(i instanceof t.Document)return i.documentElement}return r.documentElement}(e)),this.exclude=e.exclude,this.include=e.include,this.include=Lp(this,"include"),this.exclude=Lp(this,"exclude"),Bf("frame, iframe",this).forEach((function(e){var t;Jp(e,o)&&(t=o,Xu(e=e.actualNode))&&!go(t.frames,"node",e)&&t.fra\
mes.push(Tp(e,t))})),void 0===this.page&&(this.page=function(e){return 1===(e=e.include).length&&e[0].actualNode===r.documentElement}(this),this.frames.forEach((function(e){e.page=o.page}))),this);if(0===i.include.length&&0===i.frames.length)throw i=uo.isInFrame()?"frame":"page",new Error("No elements found for include in "+i+" Context");Array.isArray(this.include)||(this.include=Array.from(this.include)),this.include.sort(tf)}function zp(e){return!1===(1<arguments.length&&void 0!==arguments[1]?arguments[1]:{}).iframes?[]:new qp(e).frames.map((function(e){var t=e.node;return(e=q(e,y)).initiator=!1,{frameSelector:ia(t),frameContext:e}}))}function Vp(e){var t=o._audit.rules.find((function(t){return t.id===e}));if(t)return t;throw new Error("Cannot find rule by id: ".concat(e))}function $p(e,t){return e=e.getPropertyValue(t),["scroll","auto"].includes(e)}var Hp=$r((function(e){var n,r,a=1<arguments.length&&void 0!==arguments[1]?arguments[1]:0,o=e.scrollWidth>e.clientWidth+a;a=e.scrollHeig\
ht>e.clientHeight+a;if(o||a)return n=$p(r=t.getComputedStyle(e),"overflow-x"),r=$p(r,"overflow-y"),o&&n||a&&r?{elm:e,top:e.scrollTop,left:e.scrollLeft}:void 0})),Up=function(){var e=0<arguments.length&&void 0!==arguments[0]?arguments[0]:t,n=e.document.documentElement;return[void 0!==e.pageXOffset?{elm:e,top:e.pageYOffset,left:e.pageXOffset}:{elm:n,top:n.scrollTop,left:n.scrollLeft}].concat(function e(t){return Array.from(t.children||t.childNodes||[]).reduce((function(t,n){var r=Hp(n);return r&&t.push(r),t.concat(e(n))}),[])}(r.body))};function Gp(){return Da(du)}var Wp,Yp=function(e){if(e)return function(t){var n=t.data,r=void 0!==(r=t.isCrossOrigin)&&r,a=t.shadowId,o=t.root,i=t.priority,u=(t=void 0!==(t=t.isLink)&&t,e.createElement("style"));return t?(t=e.createTextNode('@import "'.concat(n.href,'"')),u.appendChild(t)):u.appendChild(e.createTextNode(n)),e.head.appendChild(u),{sheet:u.sheet,isCrossOrigin:r,shadowId:a,root:o,priority:i}};throw new Error("axe.utils.getStyleSheetFactory s\
hould be invoked with an argument")},Kp=function(e){var t;return Wp&&Wp.parentNode?(void 0===Wp.styleSheet?Wp.appendChild(r.createTextNode(e)):Wp.styleSheet.cssText+=e,Wp):e?(t=r.head||r.getElementsByTagName("head")[0],(Wp=r.createElement("style")).type="text/css",void 0===Wp.styleSheet?Wp.appendChild(r.createTextNode(e)):Wp.styleSheet.cssText=e,t.appendChild(Wp),Wp):void 0},Xp=function e(n,r){var a,o=ca(n);return 9!==n.nodeType&&(11===n.nodeType&&(n=n.host),o&&null!==o._isHidden?o._isHidden:!(a=t.getComputedStyle(n,null))||!n.parentNode||"none"===a.getPropertyValue("display")||!r&&"hidden"===a.getPropertyValue("visibility")||"true"===n.getAttribute("aria-hidden")||(r=e(n.assignedSlot||n.parentNode,!0),o&&(o._isHidden=r),r))},Zp=function(e){var t=null!=(t=null==(t=e.props)?void 0:t.nodeName)?t:e.nodeName.toLowerCase();return"http://www.w3.org/2000/svg"!==e.namespaceURI&&!!du.htmlElms[t]};function Jp(e,t){var n=void 0===(n=t.include)?[]:n;t=void 0===(t=t.exclude)?[]:t,n=n.filter((functi\
on(t){return Fo(t,e)}));return 0!==n.length&&(0===(t=t.filter((function(t){return Fo(t,e)}))).length||(n=Qp(n),Fo(Qp(t),n)))}function Qp(e){var t,n,r=Z(e);try{for(r.s();!(n=r.n()).done;){var a=n.value;t&&Fo(a,t)||(t=a)}}catch(e){r.e(e)}finally{r.f()}return t}function ef(e,t){return e.length===t.length&&e.every((function(e,n){var r=t[n];return Array.isArray(e)?e.length===r.length&&e.every((function(e,t){return r[t]===e})):e===r}))}var tf=function(e,t){return(e=e.actualNode||e)===(t=t.actualNode||t)?0:4&e.compareDocumentPosition(t)?-1:1};function nf(e){return e instanceof vr?{vNode:e,domNode:e.actualNode}:{vNode:ca(e),domNode:e}}var rf,af,of=function(e,t,n,r){var a,o=4<arguments.length&&void 0!==arguments[4]&&arguments[4],i=Array.from(e.cssRules);return i?(a=i.filter((function(e){return 3===e.type}))).length?(a=a.filter((function(e){return e.href})).map((function(e){return e.href})).filter((function(e){return!r.includes(e)})).map((function(e,a){a=[].concat(z(n),[a]);var o=/^https?:\\/\\/|^\
\\/\\//i.test(e);return lf(e,t,a,r,o)})),(i=i.filter((function(e){return 3!==e.type}))).length&&a.push(Promise.resolve(t.convertDataToStylesheet({data:i.map((function(e){return e.cssText})).join(),isCrossOrigin:o,priority:n,root:t.rootNode,shadowId:t.shadowId}))),Promise.all(a)):Promise.resolve({isCrossOrigin:o,priority:n,root:t.rootNode,shadowId:t.shadowId,sheet:e}):Promise.resolve()},uf=function(e,t,n,r){var a=4<arguments.length&&void 0!==arguments[4]&&arguments[4];return function(e){try{return!(!e.cssRules&&e.href)}catch(e){return!1}}(e)?of(e,t,n,r,a):lf(e.href,t,n,r,!0)},lf=function(e,n,r,a,o){return a.push(e),new Promise((function(n,r){var a=new t.XMLHttpRequest;a.open("GET",e),a.timeout=Dr.preload.timeout,a.addEventListener("error",r),a.addEventListener("timeout",r),a.addEventListener("loadend",(function(e){if(e.loaded&&a.responseText)return n(a.responseText);r(a.responseText)})),a.send()})).then((function(e){return e=n.convertDataToStylesheet({data:e,isCrossOrigin:o,priority:r,roo\
t:n.rootNode,shadowId:n.shadowId}),uf(e.sheet,n,r,a,e.isCrossOrigin)}))};function sf(){if(t.performance&&t.performance)return t.performance.now()}rf=null,af=sf();var cf={start:function(){this.mark("mark_axe_start")},end:function(){this.mark("mark_axe_end"),this.measure("axe","mark_axe_start","mark_axe_end"),this.logMeasures("axe")},auditStart:function(){this.mark("mark_audit_start")},auditEnd:function(){this.mark("mark_audit_end"),this.measure("audit_start_to_end","mark_audit_start","mark_audit_end"),this.logMeasures()},mark:function(e){t.performance&&void 0!==t.performance.mark&&t.performance.mark(e)},measure:function(e,n,r){t.performance&&void 0!==t.performance.measure&&t.performance.measure(e,n,r)},logMeasures:function(e){function n(e){hr("Measure "+e.name+" took "+e.duration+"ms")}if(t.performance&&void 0!==t.performance.getEntriesByType)for(var r=t.performance.getEntriesByName("mark_axe_start")[0],a=t.performance.getEntriesByType("measure").filter((function(e){return e.startTime>=\
r.startTime})),o=0;o<a.length;++o){var i=a[o];if(i.name===e)return void n(i);n(i)}},timeElapsed:function(){return sf()-af},reset:function(){rf=rf||sf(),af=sf()}};function df(){var e,t,n,a;return r.elementsFromPoint||r.msElementsFromPoint||((e=r.createElement("x")).style.cssText="pointer-events:auto",e="auto"===e.style.pointerEvents,t=e?"pointer-events":"visibility",n=e?"none":"hidden",(a=r.createElement("style")).innerHTML=e?"* { pointer-events: all }":"* { visibility: visible }",function(e,o){var i,u,l,s=[],c=[];for(r.head.appendChild(a);(i=r.elementFromPoint(e,o))&&-1===s.indexOf(i);)s.push(i),c.push({value:i.style.getPropertyValue(t),priority:i.style.getPropertyPriority(t)}),i.style.setProperty(t,n,"important");for(s.indexOf(r.documentElement)<s.length-1&&(s.splice(s.indexOf(r.documentElement),1),s.push(r.documentElement)),u=c.length;l=c[--u];)s[u].style.setProperty(t,l.value||"",l.priority);return r.head.removeChild(a),s})}"function"==typeof t.addEventListener&&(r.elementsFromPoint\
=df());var pf=function(e,t){return e.concat(t).filter((function(e,t,n){return n.indexOf(e)===t}))};function ff(e,t,n,r,a){return(a=a||{}).vNodes=e,a.vNodesIndex=0,a.anyLevel=t,a.thisLevel=n,a.parentShadowId=r,a}var mf=function(e,t,n){if(r=dp(e=Array.isArray(e)?e:[e],t=Ea(t),n))return r;for(var r=e,a=(e=t,n),o=sa.get("qsa.recycledLocalVariables",(function(){return[]})),i=[],u=ff(Array.isArray(r)?r:[r],e,null,r[0].shadowId,o.pop()),l=[];u.vNodesIndex<u.vNodes.length;){for(var s,c=u.vNodes[u.vNodesIndex++],d=null,p=null,f=((null==(s=u.anyLevel)?void 0:s.length)||0)+((null==(s=u.thisLevel)?void 0:s.length)||0),m=!1,D=0;D<f;D++){var h=D<((null==(h=u.anyLevel)?void 0:h.length)||0)?u.anyLevel[D]:u.thisLevel[D-((null==(h=u.anyLevel)?void 0:h.length)||0)];if((!h[0].id||c.shadowId===u.parentShadowId)&&Ca(c,h[0]))if(1===h.length)m||a&&!a(c)||(l.push(c),m=!0);else{var g=h.slice(1);if(!1===[" ",">"].includes(g[0].combinator))throw new Error("axe.utils.querySelectorAll does not support the combinato\
r: "+h[1].combinator);(">"===g[0].combinator?d=d||[]:p=p||[]).push(g)}h[0].id&&c.shadowId!==u.parentShadowId||null==(g=u.anyLevel)||!g.includes(h)||(p=p||[]).push(h)}for(c.children&&c.children.length&&(i.push(u),u=ff(c.children,p,d,c.shadowId,o.pop()));u.vNodesIndex===u.vNodes.length&&i.length;)o.push(u),u=i.pop()}return l},Df=function(e){var t,n,a,i;e=void 0===(e=e.treeRoot)?o._tree[0]:e;return t=[],e=mf(e,"*",(function(e){return!t.includes(e.shadowId)&&(t.push(e.shadowId),!0)})).map((function(e){return{shadowId:e.shadowId,rootNode:ko(e.actualNode)}})),(e=pf(e,[])).length?(n=r.implementation.createHTMLDocument("Dynamic document for loading cssom"),n=Yp(n),a=n,i=[],e.forEach((function(e,t){var n=e.rootNode,r=function(e,t,n){return t=11===e.nodeType&&t?function(e,t){return Array.from(e.children).filter(hf).reduce((function(n,r){var a=r.nodeName.toUpperCase();r="STYLE"===a?r.textContent:r;return(r=t({data:r,isLink:"LINK"===a,root:e})).sheet&&n.push(r.sheet),n}),[])}(e,n):function(e){retu\
rn Array.from(e.styleSheets).filter((function(e){return!!e.media&&gf(e.media.mediaText)}))}(e),function(e){var t=[];return e.filter((function(e){if(e.href){if(t.includes(e.href))return!1;t.push(e.href)}return!0}))}(t)}(n,e=e.shadowId,a);if(!r)return Promise.all(i);var o=t+1,u={rootNode:n,shadowId:e,convertDataToStylesheet:a,rootIndex:o},l=[];t=Promise.all(r.map((function(e,t){return uf(e,u,[o,t],l)})));i.push(t)})),Promise.all(i).then((function e(t){return t.reduce((function(t,n){return Array.isArray(n)?t.concat(e(n)):t.concat(n)}),[])}))):Promise.resolve()};function hf(e){var t=e.nodeName.toUpperCase(),n=e.getAttribute("href"),r=e.getAttribute("rel");n="LINK"===t&&n&&r&&e.rel.toUpperCase().includes("STYLESHEET");return"STYLE"===t||n&&gf(e.media)}function gf(e){return!e||!e.toUpperCase().includes("PRINT")}var bf=function(e){return e=void 0===(e=e.treeRoot)?o._tree[0]:e,e=mf(e,"video, audio",(function(e){return(e=e.actualNode).hasAttribute("src")?!!e.getAttribute("src"):!(Array.from(e.g\
etElementsByTagName("source")).filter((function(e){return!!e.getAttribute("src")})).length<=0)})),Promise.all(e.map((function(e){var t;e=e.actualNode;return t=e,new Promise((function(e){0<t.readyState&&e(t),t.addEventListener("loadedmetadata",(function n(){t.removeEventListener("loadedmetadata",n),e(t)}))}))})))};function vf(e){var t={cssom:Df,media:bf};return yf(e)?new Promise((function(n,r){var a=(o=Ff(e)).assets,o=o.timeout,i=setTimeout((function(){return r(new Error("Preload assets timed out."))}),o);Promise.all(a.map((function(n){return t[n](e).then((function(e){return t={},(r=X(r=n))in t?Object.defineProperty(t,r,{value:e,enumerable:!0,configurable:!0,writable:!0}):t[r]=e,t;var t,r}))}))).then((function(e){e=e.reduce((function(e,t){return $({},e,t)}),{}),clearTimeout(i),n(e)})).catch((function(e){clearTimeout(i),r(e)}))})):Promise.resolve()}function yf(e){return!e||void 0===e.preload||null===e.preload||("boolean"==typeof e.preload?e.preload:(e=e.preload,"object"===a(e)&&Array.isA\
rray(e.assets)))}function Ff(e){var t=(n=Dr.preload).assets,n=n.timeout;n={assets:t,timeout:n};if(e.preload&&"boolean"!=typeof e.preload){if(!e.preload.assets.every((function(e){return t.includes(e.toLowerCase())})))throw new Error("Requested assets, not supported. Supported assets are: ".concat(t.join(", "),"."));n.assets=pf(e.preload.assets.map((function(e){return e.toLowerCase()})),[]),e.preload.timeout&&"number"==typeof e.preload.timeout&&!isNaN(e.preload.timeout)&&(n.timeout=e.preload.timeout)}return n}function wf(e){var t=o._audit.data.checks||{},n=o._audit.data.rules||{},r=go(o._audit.rules,"id",e.id)||{},a=(e.tags=Da(r.tags||[]),Ef(t,!0,r)),i=Ef(t,!1,r);e.nodes.forEach((function(e){e.any.forEach(a),e.all.forEach(a),e.none.forEach(i)})),Eo(e,Da(n[e.id]||{}))}function Ef(e,t,n){return function(r){var o,i=(o=e[r.id]||{}).messages||{};delete(o=Object.assign({},o)).messages,n.reviewOnFail||void 0!==r.result?o.message=r.result===t?i.pass:i.fail:("object"!==a(i.incomplete)||Array.isAr\
ray(r.data)||(o.message=function(e,t){function n(e){return e.incomplete&&e.incomplete.default?e.incomplete.default:yp()}if(!e||!e.missingData)return e&&e.messageKey?t.incomplete[e.messageKey]:n(t);try{var r=t.incomplete[e.missingData[0].reason];if(r)return r;throw new Error}catch(r){return"string"==typeof e.missingData?t.incomplete[e.missingData]:n(t)}}(r.data,i)),o.message||(o.message=i.incomplete)),"function"!=typeof o.message&&(o.message=Ap(o.message,r.data)),Eo(r,o)}}var Cf=function(e,t){return mf(e,t)};function xf(e,t){var n,r=o._audit&&o._audit.tagExclude?o._audit.tagExclude:[],a=t.hasOwnProperty("include")||t.hasOwnProperty("exclude")?(n=t.include||[],n=Array.isArray(n)?n:[n],a=t.exclude||[],(a=Array.isArray(a)?a:[a]).concat(r.filter((function(e){return-1===n.indexOf(e)})))):(n=Array.isArray(t)?t:[t],r.filter((function(e){return-1===n.indexOf(e)})));return!!(n.some((function(t){return-1!==e.tags.indexOf(t)}))||0===n.length&&!1!==e.enabled)&&a.every((function(t){return-1===e.tags\
.indexOf(t)}))}var Af=function(e,t,n){var r=n.runOnly||{};n=(n.rules||{})[e.id];return!(e.pageLevel&&!t.page)&&("rule"===r.type?-1!==r.values.indexOf(e.id):n&&"boolean"==typeof n.enabled?n.enabled:"tag"===r.type&&r.values?xf(e,r.values):xf(e,[]))};function kf(e,t){var n,r,a;return t?(a=e.cloneNode(!1),n=qr(a),a=1===a.nodeType?(r=a.outerHTML,sa.get(r,(function(){return Nf(a,n,e,t)}))):Nf(a,n,e,t),Array.from(e.childNodes).forEach((function(e){a.appendChild(kf(e,t))})),a):e}function Nf(e,t,n,a){return t&&(e=r.createElement(e.nodeName),Array.from(t).forEach((function(t){var r,o,i;r=n,o=t.name,void 0!==(i=a)[o]&&(!0===i[o]||zr(r,i[o]))||e.setAttribute(t.name,t.value)}))),e}function Bf(e,t){var n=[];if(o._selectCache)for(var r=0,a=o._selectCache.length;r<a;r++){var i=o._selectCache[r];if(i.selector===e)return i.result}for(var u,l=t.include.reduce((function(e,t){return e.length&&Fo(e[e.length-1],t)||e.push(t),e}),[]),s=(u=t).exclude&&0!==u.exclude.length?function(e){return Jp(e,u)}:null,c=0;c\
<l.length;c++){var d=l[c];n=function(e,t){if(0===e.length)return t;var n;e.length<t.length&&(n=e,e=t,t=n);for(var r=0,a=t.length;r<a;r++)e.includes(t[r])||e.push(t[r]);return e}(n,mf(d,e,s))}return o._selectCache&&o._selectCache.push({selector:e,result:n}),n}var Tf=function(e){e.forEach((function(e){var n=e.elm,r=e.top;e=e.left;if(n===t)return n.scroll(e,r);n.scrollTop=r,n.scrollLeft=e}))};function Rf(e){return function e(t,n){var r=t.shift();return n=r?n.querySelector(r):null,0===t.length?n:null!=n&&n.shadowRoot?e(t,n.shadowRoot):null}(Array.isArray(e)?z(e):[e],r)}function _f(e){var t=1<arguments.length&&void 0!==arguments[1]?arguments[1]:r,n=Array.isArray(e)?z(e):[e];return 0===e.length?[]:function e(t,n){t=function(e){return G(e)||V(e)||J(e)||U()}(t);var r=t[0],a=t.slice(1);if(t=n.querySelectorAll(r),0===a.length)return Array.from(t);var o,i=[],u=Z(t);try{for(u.s();!(o=u.n()).done;){var l=o.value;null!=l&&l.shadowRoot&&i.push.apply(i,z(e(a,l.shadowRoot)))}}catch(e){u.e(e)}finally{u.\
f()}return i}(n,t)}var Of=function(){return["hidden","text","search","tel","url","email","password","date","month","week","time","datetime-local","number","range","color","checkbox","radio","file","submit","image","reset","button"]},Sf=[,[,[1,1,1,1,1,1,1,1,1,1,,1,1,1,1,1,1,1,,1,1,1,1,1,1,,1],[1,1,1,1,1,1,1,1,1,1,1,,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1],[,1,1,,1,1,1,,1,1,,1,1,1,1,,1,1,1,1,1,1,1,1,1,1,1],[,1,1,,1,1,1,1,1,1,1,,1,,1,1,1,1,1,1,1,1,,1,1,1,1],[1,1,1,1,1,1,,,,,,1,1,1,1,,,1,1,1,,1,,1,,1,1],[1,1,1,,1,1,,1,1,1,,1,,,1,1,1,,,1,1,1,,,,,1],[,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1],[,1,1,,,,,1,1,1,,1,1,1,1,1,1,,1,1,1],[,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,,,1,1,1],[,1,,,,,,1,,1,,,,,1,,1,,,,1,1,,1,,,1],[1,,1,1,1,1,1,1,1,1,1,1,1,1,,1,1,1,1,1,1,1,1,1,1,1,1],[,1,,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1],[1,1,1,1,,1,1,1,,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1],[1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1],[,1,1,1,1,1,1,1,1,1,1,1,1,1,1,,,,1,1,1,1,,,1,,1],[,1,1,1,1,1\
,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1],[,1,,1,1,,,1,,,,,1,1,1,,1,,1,,1,,,,,,1],[1,,1,1,1,1,,,1,1,1,1,1,,1,1,1,1,1,1,1,1,1,1,1,1,1],[1,1,1,1,1,1,1,1,1,1,1,1,1,,1,1,1,1,1,1,1,1,1,1,1,1,1],[,1,1,1,1,1,,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1],[,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,,1,1,1,1],[1,,1,,1,,,,,1,,1,1,1,1,1,,,,1,1,1,1],[,1,1,1,1,1,,1,1,1,,1,,1,1,1,,,1,1,1,1,1,1,1,1],[,,1,,,1,,1,,,,1,1,1,,,,,,,,,,,1],[1,1,1,1,1,1,,1,1,1,,1,1,,1,1,1,1,1,1,1,1,,,1,1,1],[1,1,1,1,1,,,1,,,1,,,1,1,1,,,,,1,,,,,,1]],[,[1,1,1,1,1,1,1,1,1,1,1,,1,,1,1,1,,1,1,1,1,1,1,1,1,1],[,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1],[,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,,1,1],[,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1],[1,1,1,1,1,1,1,1,1,1,1,1,,1,,1,1,1,1,1,1,1,1,1,1,1,1],[,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,,1,1,1,1],[1,1,1,1,1,1,1,1,,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1],[1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1],[1,1,1,1,1,1,1,1,,,1,1,1,1,1,1,1,1,1,,1,1,1,1,1,1,\
1],[,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1],[,1,1,1,1,,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1],[,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,,1,1,1,1,1],[1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1],[1,1,1,1,1,1,1,1,,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1],[1,1,1,,,1,1,1,1,1,1,1,1,1,1,1,1,1,1,,1,1,1,1,1,1,1],[,1,1,,1,,,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1],[,1,1,1,1,,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1],[1,1,1,1,1,,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1],[1,1,1,1,,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1],[,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1],[,1,1,1,1,1,1,1,1,1,1,1,,1,1,1,1,1,,1,1,1,1,1,1,1,1],[,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,,1,1,1,1,1,1,1],[,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,,1,1,1,1],[,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,,1,1,1,1,,1],[,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,,1,1,1,1,1],[,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1]],[,[1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,,1,1,1,1,1,1],[,1,1,1,1,1,,1,1,1,1\
,1,1,,1,1,,1,1,1,1,1,1,1,,1],[,1,,1,1,1,,1,1,,1,,1,1,1,1,1,1,1,1],[,1,,1,1,1,1,1,1,1,1,,,1,1,1,,,1,1,,,,,,1,1],[1,1,1,,,,,1,,,,1,1,,1,,,,,,1,,,,,1],[,1,,,1,,,1,,,,,,1],[,1,,1,,,,1,,,,1],[1,,1,1,1,,1,1,1,,1,1,1,1,1,1,1,1,1,,1,,,1,1,1,1],[,1,1,1,1,1,,,1,,,1,,1,1,,1,,1,,,,,1,,1],[,1,,,,1,,,1,1,,1,,1,1,1,1,,1,1,,,1,,,1],[,1,1,,,,,,1,,,,1,1,1,1,,1,1,1,1,1,1,,1,1,1],[,1,,1,1,1,,,1,1,1,1,1,1,,1,,,,,1,1,,1,,1],[,1,,1,,1,,1,,1,,1,1,1,1,1,,,1,1,1],[,1,1,1,,,,1,1,1,,1,1,,,1,1,,1,1,1,1,,1,1],[1,1,1,1,1,1,1,1,1,,1,1,1,1,1,1,1,1,,,1,1,1,1,1,1,1],[,1,1,1,,1,1,1,,1,,,,,1,1,1,,,1,,1,,,1,1],[,,,,1,,,,,,,,,,,,,,,,,1],[1,1,1,1,1,,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,,1,1,1,1,1],[1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,,1,1],[,1,,1,1,1,,1,1,,,,1,1,1,1,1,,,1,1,1,,,,,1],[1,1,1,1,,,,1,1,1,1,1,1,1,,1,1,1,1,1,1,1,1,1,1,1],[1,,,,,,,1,,,,,,,1],[,1,1,,1,1,,1,,,,,,,,,,,,,1],,[1,1,1,,,,,,,,,,,,,1],[,,,,,,,,1,,,1,,,1,1,,,,,1]],[,[1,1,,1,1,1,1,1,1,1,1,1,1,1,,1,1,1,1,1,,1,1,1,1,1,1],[,1,1,,1,1,1,1,,1,1,,1,1,1,1,1,1,1,\
,1,1,1,1,,1],[,,,1,,,,,,,,,,,,,,,1],[,1,,,1,1,,1,,1,1,,,,1,1,,,1,1,,,,1],[1,,,1,1,1,1,1,1,1,,1,1,1,1,,1,1,1,1,,,1,,,,1],,[,1,1,1,1,1,,1,1,1,,1,1,,1,1,,,1,1,1,1,,1,1,,1],[,1,,,1,,,1,,1,,,1,1,1,1,,,1,1,,1,1,1,1],[,1,1,1,1,,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,,1,1,1,1],[,1,1,1,1,1,1,,,1,1,1,1,1,1,1,,,1,,,1,,1],[,1,,,,,,,,,,1,1,,,,,,1,1,,,,,1],[,,,,,,,1,,,,1,,1,1],[,1,1,1,1,1,1,1,,,,1,1,1,1,1,,,1,1,,1,1,1,1,1],[,1,,,1,1,,1,,1,1,1,,,1,1,,,1,,1,1,1,1,,1],[,1,1,1,,1,1,,1,1,,1,1,,1,1,1,1,1,1,1,,1,1,1,1,1],[,,,,,,,,,,,,,,,,1],,[,1,1,1,1,1,,1,1,1,,,1,,1,1,,1,1,1,1,1,,1,,1],[,,1,,,1,,,1,1,,,1,,1,1,,1],[,1,1,,1,,,,1,1,,1,,1,1,1,1,,1,1,1,1,,,,1],[,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,,1,1,1,1,1,1],[1,1],[,1,,,,,,,,,,1,1,,,,,,1,1,,1,,1,,1,1],,[,1,1,,1,,,1,,1,,,,1,1,1,,,,,,1,,,,1],[1,1,,,1,1,,1,,,,,1,,1]],[,[,1],[,,,1,,,,1,,,,1,,,,1,,,1,,,1],[,,,,,,,,,,,,,,,,,,1,1,,,,,,1],,[1,,,,,1],[,1,,,,1,,,,1],[,1,,,,,,,,,,,1,,,1,,,,,,,,,1,1],[,,,,,,,,,,,,,,,,,,,,,1],[,,,,,,,,,,,,,,,,1,,,,1,,1],[,1],[,1,,1,,1,,1,,1,\
,1,1,1,,1,1,,1,,,,,,,1],[1,,,,,1,,,1,1,,1,,1,,1,1,,,,,1,,,1],[,1,1,,,1,,1,,1,,1,,1,1,1,1,,,1,,1,,1,1,1],[1,1,1,1,1,,1,,1,,,,1,1,1,1,,1,1,,,1,1,1,1],[1,,,,,,,,,,,,,,,,,,,,1],[,,,,,,,,,1],,[,1,,,,,,1,1,1,,1,,,,1,,,1,1,1,,,1],[1,,,,,1,,1,1,1,,1,1,1,1,1,,1,,1,,1,,,1,1],[1,,1,1,,,,,1,,,,,,1,1,,,1,1,1,1,,,1,,1],[1,,,,,,,,,,,,,,,,,1],[,,,,,1,,,1,,,,,,1],[,,,,,,,,,,,,,,,1],[,,,,,,,,,,,,,,,,,,,,1],[,1,,,,,,,,,,,,,,1],[,1,,,,1]],[,[1,1,1,,1,,1,1,1,1,1,1,1,1,1,,1,,1,,1,1,,,1,1,1],[,,,,,,,,,,,,1],[,,,,,,,,,,,,,,,,,,,1],,[,,,,,,,,,,,,,,,,,,1],[1,,,,,,,,,1,,,,1],[,,,,,,,,,,,,,,,,,,1],,[1,1,,,,1,1,,,,,,1,,,,1,,1,,1,1,,1],[1],[,,,,,,,,,,,1,,,,,,,,,,,1],[,1,,,,,,,1,1,,,1,,1,,,,1,,,,,,,1],[,,,,,,,,,,,,,,,,1,,,,,1],[,,1,,,,,1,,1],[1,,,,1,,,,,1,,,,1,1,,,,1,1,,,,,1],[,,,,,1],[,,,,,,,,,,,,,,,,,,,1],[1,,,1,1,,,,,,,1,,1,,1,1,1,1,1,1],[,,,,,1,,,,,,,1,,,,,,,1],,[,,1,1,1,1,1,,1,1,1,,,1,1,,,1,1,,1,1,1,,,1],[,,,,,,,,,,,,,,,,,,1],[,1,,,,1],,[1]],[,[1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1],[,1,1,1,1,1,\
1,1,1,1,1,1,1,1,1,1,1,1,1,1,,1,1,1,1,1,1],[,,,1,1,1,1,,,,,,1,,1,,,,1,,1],[1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,,1,1,1,1,1,,,1],[,1,1,1,1,,1,1,1,1,1,1,1,1,,,,1,,1,,,1,1,1,1,1],[,,,,,,,,,,,1,,,,,,,,,1,,,,1],[,1,1,,1,1,,1,,,,1,1,,1,1,,,1,,1,1,,1],[,1,,1,,1,,,1,,,1,1,,1,1,,,1,1,1],[,1,1,1,1,1,,1,1,,,,1,1,1,1,1,1,1,1,1,1,,1,1,1,1],[,,,,,,,,,1,,1,,1,1,,,,1,,,1],[,1,,,1,1,,,,,,,,,1,1,1,,,,,1],[1,,,1,1,,,,1,1,1,1,1,,,1,,,1,,,1,,1,,1],[,1,1,,1,1,,1,1,,,,1,1,1,,,1,1,,,1,1,1,1,1,1],[1,1,1,1,1,1,,1,1,1,1,1,1,1,1,1,,1,1,,1,1,,1,,,1],[,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,,1,1,1,1],[,1,,,,1,,,,,,,,,1],[,1,,,,,,,,1,,,,,1,,,,1,,,1],[,1,1,1,1,,,1,1,1,1,1,,1,,1,,1,1,1,1,1,1,1,1,1,1],[,,,,,1,,1,,,,,1,1,1,1,1,,,1,,,,1],[,1,,,,,,,,1,,,,,,,,,,,,1],[1,1,1,1,1,1,1,1,1,1,,1,1,1,1,1,1,1,1,1,1,1,1,1,1,,1],[1,1,,1,,1,1,,,,1,,1,1,1,1,1,,1,1,,,,,,1],[,1,1,1,1,1,1,1,,1,1,,,1,1,,,,1,,1,1,,1,1],[,,,,,,,,,,,,,,,,,,,,,,,,1],[,1,1,,1,1,1,1,,1,,,1,1,1,1,,,1,,,,,,,1],[,1,,,,,,,,1,,,,,1]],[,[1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,\
1,1,1,1,,,1,1,1,1,1],[,1,1,,,,,,,,,,,,1,1,,,,,,1],[,1,,,,,,,1],[,,,,,,,,,,,,,,1,,,,,1,,,,,,1],[1,1,,,1,,,1,1,1,,,,1],,[,,,,,,,,,,,,,1,,,,,,,,,,1],[,,,,,,,,,1,,,,,,,,,1,,,,,,,1],[1,1,1,,1,,1,1,1,1,1,1,1,1,,1,,,1,,1,,,1,1],[,,,,,,,,,1],[,1,,,,1,,,,,,1,,,1,,,,,1],[,1,1,,1,1,,,,,,,,,,,,,,,1,1],[,1,1,1,1,1,1,1,1,1,1,1,1,1,1,,1,1,1,1,1,1,1,1,1,1,1],[,1,,,1,1,,1,1,1,1,,,,1,1,,,,1,,1],[1,1,1,1,1,1,,,1,1,1,1,1,1,,1,1,,1,1,1,,1,1,,1,1],[,,,,,,,,,,,,,,,1,,,,1],,[1,1,,1,,1,,,,,,1,,1,,1,1,,1,,1,1,,1,1,,1],[,,1,,,,,,1,,,,1,,1,,,,,1],[1,,,,,,,,,1,,,,,,1,,,,1,,1,,,1],[1,,1,1,1,1,1,1,1,1,1,1,1,1,,1,1,1,1,1,1,1,1,1,1,1,1],[,,,1,,1,,,,,,1,,,1,,,,,,,,1],[,1,,1,,,,,,,,,,,,1],,[1,1,,,,,,,,,,,,,,,,,,,,,,1,1],[1]],[,[1,,,,,,,,,1,,,,,1,,1,,1],[,1,1,,1,1,,1,1,1,,,1,1,1,,,,1,,,1,,,,1],[,1,,,,,,,1,,,,1,,,,,,1],[1,1,1,1,1,1,,,,1,,,,,,,,,1,1,1,1],[1],[,1,1,,,1,1,,,,,1,,1,,,,,,,,1,,,,1],[1,,1,,,1,,1,,,,,1,1,1,1,,,,1,,,,1],[,,1,,,,,,,1,,,,,,,1,,,,,,,1],[1,,,,,,,,,,,,,,1,,,,1],[,,,1,,1,,,,,1,,,,1,1,,,,1],[1,,,,,1,,,,1\
,,1,1,,,1,1,,1,1,1,,1,1,1,,1],[,1,1,,,,,1,,1,,1,1,1,,1,1,,,1,,1,1,1],[,1,,,,1,,,,1,,,1,,1,1,,,1,1,,,,,,1],[1,,1,1,,1,,1,1,,1,,1,1,1,1,1,,,1,1,,,,,,1],[1,,,,,,,,,,,,,,,,,,1,,,1,,1],[,,,,,,,,,1,,,,,,1],[,,,,,,,,,,,,,,,,,,,,,1,,1],[,1,,,,1,,,1,1,,1,,,1,1,,,1,,,1,,,1,1],[1,1,,1,1,1,,1,1,1,,1,,1,1,1,,,1,,1,1],[1,,1,1,1,1,,,,1,,1,1,1,,1,,,1,1,1,,1,1,1,1,1],[1,,,,,,,,,,,,,1],[,,1,,,,,,,,,,,,,,,,,,,,1],[1,,,,,,,,,,,1,,1,,1,,,,1],[,,,1,,,,,,,,,1],[,1,,,,,,,,,,,,,,1,,,,,,,,,1],[,,,,,,,,1,1,,,,,,,,,1,,,,,,,,1]],[,[1,1,1,1,1,1,1,,1,,1,1,1,1,1,1,,1,1,1,1,1,,,1,1,1],[,,,,,1,,,,1,1,1,,,1,1,,,1,,1,1,,1],[,,,,,,,,,,,,,,,,,,,1,1],[,1,,,,,,1,,,,,,,,,,,,,1],[,,1,,,1,,1,1,1,,1,1,,1,,,,1,,1,1],,[,,1,,,1,,,,,,1,,,,1],[,,,,,,,,,1,,,,,,,,,,1],[1,1,1,1,1,1,,1,1,1,,,1,1,,1,,1,,,1,1,1,,,1],[,,,,,1,,,,,,,,,,,,,1],[,1,,,,,,,,,,,,1,,1,1,,1,,,1],[,,,,,1,,,,,,,,,,,,,,1],[,1,1,1,1,,,,,1,,,1,,1,,,,1,1,,,,1,1],[,1,,,1,,,1,,1,1,,1,,,,,,,1],[,,1,,1,,,1,,,,,,,,,,,1,1,,,,1],[,1,,,,,,,,,,,,,,,,,1,,,,,,1],[,,,,,,,,,,,,,,,,,,1]\
,[,1,1,,,,,,,,,,,,,,,,1,,1,1],[,,,,,,,,,,,,1],,[,1,1,1,1,,,,1,1,,1,1,1,1,1,1,,1,1,1,1,,1,,1],[1,,,,1,,,,,,,,,,1],[1,,,,,,,,,1],,[,1,,,,1,,,,,,,,,,,,,,,,,,,,1]],[,[1,1,1,1,1,1,1,1,1,1,1,1,,1,,1,1,1,1,,,,1,1,1,1],[,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1],[,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1],[,1,,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,,1,1,1,1,1,1,1],[,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1],[,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1],[1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1],[,1,1,1,1,1,1,1,1,1,1,1,1,,1,1,1,1,1,1,1,1,1,1,1,1,1],[1,1,1,1,1,1,1,1,1,1,1,,1,1,,1,1,1,,1,1,1,1,1,1,1,1],[1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,,1,1,1],[1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1],[1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1],[1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1],[1,1,1,1,1,1,1,1,,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1],[1,1,,1,1,1,1,1,1,1,1,1,1,,,1,1,1,,1,1,1,1,1,1,1,1],[,1,1,1,1,1,1,1,1,1,1,1,1\
,1,1,1,1,1,1,1,1,1,1,1,1,1,1],[,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1],[1,1,1,1,1,1,1,,1,1,1,1,1,1,1,1,1,,1,1,1,1,1,1,1,1,1],[1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1],[,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1],[1,,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,,1,1,1,1,1,1,1,1],[1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1],[1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1],[,1,1,1,1,1,1,,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1],[1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1],[,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1]],[,[1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,,1,1,1,1,,1,,1,1,1,1],[1,1,1,1,,1,1,1,,1,1,1,1,1,1,1,,1,1,1,1,1,1,1,1,1,1],[,,,1,1,1,1,,1,,,,1,1,,,1,1,,1],[,1,1,,1,,,1,1,1,1,1,1,1,1,1,1,1],[,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1],[,1,,,,,,,,,,,,,1],[1,1,1,,,,,1,1,1,,1,1,1,1,,,1,1,,1,1,,,,,1],[,1,,,,,,,1,1,,,1,1,1,,1,,,1,1,1],[1,1,1,1,1,1,1,1,1,1,1,1,1,,,1,1,1,1,1,,1,1,1,1,1,1],[,1,,,,1,,,,1,,,1,,,,1,,,,,,,1,1],[,1,1\
,1,1,1,,,1,1,1,,1,1,1,1,,,1,1,1,1,,,,1],[,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,,1,,1,,,1],[,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,,,1,1,1,1,1,1],[1,1,1,,1,,,1,1,1,1,,1,1,1,1,,,,1,,1,,1,,,1],[1,1,1,1,,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1],[,1,,,,1,,,,,,,,,1,1,,,,,,,,,1],,[,1,,1,,1,,1,,1,,1,1,1,1,1,,,1,,1,,1,,,,1],[,1,,,1,1,,1,1,1,,,1,1,1,1,1,,1,1,1,,1,,,1],[1,,,1,,,,1,1,1,,,,,1,1,,,,1,,1],[1,1,,1,1,1,1,,,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,,1,1],[1,1,,,,,,,,1,,1,,,,,,,,1,,1],[,1,,,,1,,1,1,,,,1,1,,1,,,,1,1,1,,1],,[,1,,,,,,1,,,,,,,1],[,,,,,,,,1,,,,1,,1,,,,,,,,,,,,1]],[,[,1,1,,1,1,1,1,,1,1,1,,1,1,,1,1,,1,1,1,1,1,1,,1],[,1,1,1,1,1,1,,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1],[,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1],[,1,1,1,1,1,1,1,1,1,1,1,1,1,1,,1,1,1,1,1,1,1,1,1,1,1],[,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,,1,1],[,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1],[1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1],[1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,,1,1,1,1]\
,[1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,,1,1,1,1],[,1,1,1,1,1,,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1],[1,1,1,1,,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1],[1,1,1,1,1,1,1,,1,1,1,1,1,1,1,1,1,1,1,1,,1,1,1,1,,1],[,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,,1,1,1,1,1,1,1],[1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1],[1,1,,1,1,1,1,1,1,1,1,1,,1,,1,1,1,1,1,1,1,1,1,1,1,1],[,1,1,1,1,1,,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1],[,1,1,1,,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1],[1,1,1,1,1,1,1,1,1,,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1],[1,,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1],[1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1],[,1,1,1,1,1,,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,,1,1,1],[,1,1,,1,1,1,1,1,1,,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1],[,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1],[,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1],[1,,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1],[,1,1,1,1,1,,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1]],[,[1,1,1,1,1,1,1,1,1,\
1,1,1,1,1,1,1,1,1,1,1,1,,,1,1,1,1],[1,1,1,1,1,1,1,1,1,1,1,1,,1,1,1,1,1,1,1,1,1,1,1,1,1],[,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,,,1,,1],[1,1,1,1,1,,1,1,1,1,1,1,1,1,1,,1,1,1,1,1,1,1,1,1,1,1],[1,1,1,1,1,1,1,1,1,1,1,1,,1,1,1,,1,1,1,1,1,1,1,1,1,1],[,1,,,1,,,,,,,,1,,,,,,1,,,1],[1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1],[,1,1,1,1,1,1,1,1,1,,1,,1,1,1,1,1,1,,1,1,1,1,1,1,1],[,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,,1,1,1,1,1,1,1,1,1,1],[,1,1,,1,,,,1,1,1,,1,1,1,1,,,1,1,1,1,,,1,1,1],[,1,1,1,1,1,1,1,1,1,1,1,,1,1,1,1,1,1,1,1,1,1,1,1,,1],[1,1,,1,,1,,1,,1,1,1,1,1,1,1,,1,1,,,1,1,1,1,1,1],[,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1],[1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,,1,1,1,1,1,1,1,1,1,1,1],[1,1,,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,,1,1,1,1,1,,1,1],[,1,1,,,,,1,1,1,,,1,,1,1,,,,1,,1,,,1,1],[,,,,,,,1,,,,1,1,1,1,1,,1,,,,,,,,1],[1,1,1,1,,1,1,1,,1,,1,1,1,1,,1,,1,,1,1,,,1,,1],[,1,1,1,1,1,1,1,1,1,,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1],[,,,,1,1,,1,,1,1,1,,1,,1,1,,1,1,,1,,1,1,1,1],[,1,1,1,1,1,1,1,1,1,1,1,1,1,\
1,1,1,1,1,1,1,1,1,1,1,1,1],[1,,,,,,,,1,,,,,1,,1],[,1,1,1,,1,,1,,1,,,,1,,1,,,1,,,,,,1,1],[,1,,,1,1,,1,,1,,1,1,1,1,1,,1,1,,,1,,,1],[1,,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1],[,1,1,,1,,,,,1,,1,,1,,,,,,1,,1,,,,1,1]],[,[,1,,1,,,,,,,,,,,,,,,1,,,,1],[,,,,,,,,,1,,1,1,1,,1,,,1,,1,1],[1,1,,,,,,,1,,,,,,,1,,,,,,1],[,1,,,,,,,,,,1,,,,,,,,,1,1],,[,,,,,,,,,,,,,,,1,,,,1,,1],[,,1,1,,1,,1,,,,,,,,1,,,,,,1],[,,,,,,,,,,,,,,,,,,,,1,1],[,1,,,,,,,,,,,,,1],[1,,1,1,,,,1,,,,,,,,,1,,,1,,,1,1],[,1,1,,1,1,,1,1,1,1,1,1,1,1,1,,,1,1,,1,1,,1],[,1,,,1,1,,,,,,1,,1,,1,,,1,,1,1],[1,1,1,1,,1,,1,,1,,1,1,,1,1,1,1,1,,1,1,1,1,1],[,1,1,,,1,,1,,1,1,1,,,1,1,1,,1,1,1,1,,1,1],[,,,,1,,,1,,,,,,,1,,,,1,1],[,1,,,,,,,,,,1,,1,,1,,,,,1,,,,,1],,[1,1,,1,,1,,1,1,,,,,,1,1,,,1,1,1,1,1,1,1,1,1],[1,1,,1,,,,,,1,,,,,,1,1,,,,1,1,,,1],[,1,1,,1,1,,,,1,,1,1,1,1,1,,1,1,1,1,1,,1,1,1,1],[,1,1,,,1,,,,1,,,,1,1],[,,,,1],[,,,,,,,,,1,,,1],,[,,1,,1,,,,,,,,,1,,,,,,,,,,,,1],[,,,,,,,,,,,,,1]],[,[1,1,1,1,1,1,1,1,1,1,,1,1,1,,1,1,1,1,1,1,1,1,1,1,1,1],[,,1,1,\
,1,1,1,1,1,,,1,1,1,1,1,,1,1,1,1,1,,,1,1],[,1,1,1,1,1,1,1,1,1,1,1,1,1,1,,1,,1,,,,,1],[,1,,1,,,,,,1,,,,,1,1,,,,,1,1],[,1,1,,1,1,1,1,1,1,1,1,1,1,,1,1,1,,1,,,1,,1,1,1],[,1,,,,1,,,,,,,1],[,1,,,1,,,1,,1,,1,1,,1,,,,,1,,1,,,,1,1],[,1,,,1,,,1,1,1,,1,1,1,1,1,,1,1,,1,1,1,1],[1,1,1,1,1,1,1,1,1,1,1,,1,1,1,1,1,,1,1,1,1,1,1,1,1,1],[,,,,,,,,,,,,,,,,,,,,1],[,1,1,1,,,,1,1,,,,,,1,1,1,,1,1,1,1],[1,1,1,1,1,1,1,1,1,,1,1,1,,1,1,1,1,1,1,1,1,1,1,,1,1],[,1,1,1,1,1,1,,1,1,1,1,1,1,1,1,,1,1,1,1,1,,1,1,1,1],[,1,1,1,1,1,,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1],[,,,1,1,1,1,1,1,1,,1,,1,1,1,1,1,,1,1,,1,1,1,1,1],[,1,,,,1,,,,1,,1,1,1,1,1,1,1,1,1,1,1],[,1,,,,1,,,,,,,,1,,,,,,,,,,1],[,1,1,1,1,1,1,1,1,1,,1,1,1,1,1,1,1,1,1,1,1,,1,1,1,1],[1,1,,1,1,1,,1,1,1,,,1,1,1,1,1,1,1,1,1,1,,1,,1],[1,1,,,,,,,1,1,,,,,1,1,1,1,1,,1,1,1,1,,1],[,1,1,1,1,1,1,1,,1,1,1,,1,,1,1,1,1,,1,1,,1,1,1,1],,[,1,1,,,,,1,,1,,,,1,1,1,,,1,,,,,1],[,,,,,,,,,,,,,1],[,,,,,1,,,,,,,,1,1,,,,,1,,1,,,1,1],[,,,,,,,,,,,,,,1]],[,[,1],,,,,,,,,,,,,,,,,,,,[1,1,1,1,1,,1,1,1,1,\
,1,1,1,1,,1,1,1,1,,,1,1,1,1,1],[,1,,1,,1,,,1,1,1,,1,1,1,1,1,,,1,,,,1,,1,1],[,1,,1,,1,,,1,,,,,1,,,,,,1,1],[,1,,1,,,,,1,,,,1,,1,1,1,1,1,1,1,1,,1],[,1,,,,,,,,,,,,,,,1]],[,[,1,1,1,1,,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1],[,,1,,,,,,,,,1,1,,,,1],[,,,,,,1],[,,1],[,1,1,,,1,,1,,1,1,,1,1,1,,,,1,1,1,,,,,1],,[,1,,,,1,,,,,,1,,,1,,,,1,1,,1],[,,,,,,,1,,,,,,,,,1],[,1,,,,1,1,,,,,,1,1,1,,,,1,,1,1],[,,,,,,,1,,1,,,,,,,,,,1],[,1,1,,,,,,1,1,,,,1,,,,,,,1,,,1],,[1,1,1,1,1,1,1,1,1,1,,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1],[1,1,,,1,,,1,,,,,1,,1,,1,,1,,,,,1],[1,1,1,1,1,1,1,1,,,,,1,1,,1,1,,1,,,1,,1],[,,,,,,,,,,,,,,1,,,,,,1],,[,,,,,,,,,1,,,,,,1,,,,,1],[,,1,,,,,,,1,,,1,1],[,,,1,,,,,1,,,,,1,,,,,,1,,,,1],[1,,1,1,,1,1,1,1,1,,1,,,,1,1,1,,,1,1,,,,1,1],,[1,1,,,,,,,,,,1,,1,,1,,,1],[,,,,1,,,,,,,,,,,,,,,,,,,1],[,,,,,,,,,,,,,,1,,,,,1,,1],[,,,,,,,,1]],[,[1,1,1,1,1,1,1,,1,1,1,1,1,1,,1,1,1,1,1,1,1,1,1,1,1,1],[,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1],[1,1,1,,,1,1,1,1,1,,1,1,,1,1,1,1,,1,1,1,1,1,1],[1,1,1,1,,1,1,1,1,,1\
,1,1,1,1,1,1,1,1,1,1,1,1,,1,,1],[1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,,1,1],[,,1,,,1,,,,,,,,1,,,,,,1,,,,1],[1,1,1,1,1,1,,1,1,1,1,1,1,1,1,1,1,,1,1,1,1,,1,1,1,1],[1,1,1,1,1,1,,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1],[1,1,1,,1,1,1,1,1,1,1,1,1,1,,1,1,1,1,1,1,1,1,1,1,1,1],[,1,1,,1,1,,1,,,,1,1,1,1,1,1,,1,1,1,1,,1],[1,1,1,1,1,1,1,1,1,1,1,1,,1,1,1,1,1,1,1,1,1,1,1,1,1,1],[1,1,,1,1,1,1,1,1,1,1,,1,1,1,,1,1,1,1,1,1,,1,1,1,1],[1,1,1,1,1,,1,1,1,1,1,1,1,1,1,,1,1,1,1,1,1,1,1,1,1,1],[1,,1,1,,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,,1,1,1,1,1,1],[1,1,1,1,1,1,,1,1,1,1,1,1,,1,1,1,1,1,1,,1,1,1,1,1,1],[,,1,1,1,1,,1,,1,,1,1,1,1,1,1,1,1,1,1,1,1,,1,1],[1,1,,,,,,,1,,1,1,,1,1,1,,1,1,1,1,1],[1,1,1,1,,1,1,1,1,1,,1,1,1,1,1,,1,1,1,1,1,1,1,1,1,1],[1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,,1,1,1],[1,1,1,,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,,1],[1,1,1,1,,1,,1,,1,1,1,1,1,,,,1,1,1,1,,1,1,1,1,1],[1,1,1,1,,1,,,,,,1,,1,,,,,1,1,,,,,1],[1,,1,1,,,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1],[,,1,1,,1,,1,,,,1,1,1,1,1,,,1\
,1,,1,,1],[,1,1,1,1,,,,,1,,1,1,1,1,1,,,1,1,,,,1,1,1],[,1,1,1,1,1,,1,,,,,1,,1,,1,,,1,,,1,1,,1]],[,[1,1,1,1,1,1,1,1,,1,1,1,1,,1,1,1,1,1,1,,1,1,1,1,1,1],[,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1],[,1,1,1,1,1,1,1,1,1,,1,1,1,1,1,1,1,,1,1,1,,1,1,1,1],[,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,,1,1,1,1,1,1,,1,1],[1,1,1,1,1,1,1,1,1,1,,1,,1,1,1,1,1,1,1,1,1,1,1,1,1,1],[,,,,,,,,,1,,,,,1,1,,,1,,1],[1,1,1,1,1,1,1,1,1,1,1,,,,1,1,1,1,1,1,1,1,1,1,1,1,1],[1,,,1,1,1,1,,1,1,,1,1,1,1,,1,1,1,1,1,1,1,1,1,1,1],[1,1,,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,,1,1,1,1,1,1,1,1],[,1,,,,,,1,,1,1,,1,1,1,1,1,,,1,,1,,1],[1,1,1,,1,1,1,1,,,,1,1,1,1,,1,1,1,1,1,1,1,1,1,,1],[1,1,1,1,1,,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1],[,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,,1,1],[1,1,1,1,1,1,1,1,1,1,,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1],[1,,1,1,1,1,1,1,1,1,1,,1,1,,1,1,1,1,1,,1,1,1,1,1,1],[,1,,1,,1,1,1,,1,1,1,1,1,1,1,1,1,1,,1,1,1,1,1,1,1],[,,1,,,,,,,,,,1,1,1,1,1,1,1,,1,1,,1],[1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1],[1,1,1\
,1,1,1,1,1,1,1,1,1,1,1,,,1,1,1,1,1,1,1,1,1,1,1],[1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,,1,1],[,1,1,1,1,1,1,1,1,1,1,,1,1,1,1,1,1,,1,1,1,1,1,1,1,1],[,1,,,1,1,,,,,,1,1,1,1,1,,,,1,1,1,,1,1,1],[1,1,1,1,1,1,1,1,1,,,,1,1,1,1,1,1,1,,1,1,,1,1,1],[,1,1,1,,1,,1,1,1,1,,,1,1,1,,1,1,1,1,1,,,1,1],[1,1,,,,1,,,1,1,1,,1,,1,,1,,1,1,1,1,1,,1,,1],[,1,,,,,,,1,,1,,1,1,1,1,,,,,,,,,1]],[,[,,,,,,,,,,,,,1,1,,,,1],[,1,,,,,,,,1,,,1,,,,,,1,,,1,,,,1],,[,1,,,,1,,1,,1,1,,1,1,,,,,,,,1],[,,,,,,,,,,,,,,,,,,,1],[,,,,,,,,,1],[1,1,1,,,1,,,,,,,,,1,1,,,,,,,,,,1],[,1,,,,,,,,,,,,,1],[,,,,,,,,,,,,,,,,,,,1,,,1],[,,,,,,,,,1],[1,1,,,,,,1,1,1,,1,1,,,,1,1,,1,,1,1,1,,1],[,1,1,1,,1,1,,,1,,1,1,1,1,,,,,,,1,,1],[,1,1,1,1,,,1,,1,,,,1,1,1,1,,1,1,,1],[,1,,,1,1,,1,,,,1,,1,1,,1,,1,,,1,,,1,,1],[,,,,,,,,,,,1],[,,,,,,,,,1,,,,,,,,,,,,,1],,[1,1,1,1,,1,1,1,1,1,1,1,1,1,1,1,1,,1,,1,1,1,1,1,1,1],[,1,,,,,,,1,1,,1,,,,,1,,,1,,1],[,1,,,,1,,,1,,,,,,,,1,,1,,,1],[,,,,,,,,,,,,,1,1,,,,1,,,1],[,,,,,1,,,1,,,,1],[,1],,[,1],[1,,,,,,,,,,,,,,1,,,,,1]],[,[,1\
,,,,1,1,1,1,1,1,,1,1,1,1,1,,1,1,,1,1,,,1],[,,1,,,,,,,,,1],,,[1,,,1,1,,,,,,,,1,1,,1,1,,1],,[,,,,,,,,,,,,,,,,,,1,,1],,[1,,,1,1,,1,1,,,,,1,,1,,,,,1,1,,1],,[,1,,,,,,,,1,1,1,1,1,,1,1,,,,1,1],[,,,,,,,,,,,,,,,,1,,,1],[,1,1,1,1,1,1,1,1,1,1,1,1,1,,,1,1,1,1,,1,1,1,1,1,1],[,,,,,,,,,,,1,,1,,,1],[1,,,,,,,,,,,,,,,,,,1,,1],,,[,1,,,,,,,,,,,,,,1,,,,1,1],[,,,,,,,,,1,,,1,,,,,,,,,,1],[,,,,,,,,,,,,,,,1],[,,,,,,,,,,,,,1,1,,,,,,1],,[,1]],[,[1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1],[,1,1,,,1,1,,1,1,1,1,1,1,,,1,1,1,1,1,,1,1],[,1,,,,,,,,1],[,,,,1,,,1,,,1,1,,,,,,,,,,1,,,,1],[,1,,1,1,,,1,1,1,,,,1,1,1,1,,1,1,1,1,,1],[,,,,,,,1],[,1,1,,,,,1,,1,,,,,,1,,,,,,1,,1,,1],[,1,,,,,,1,,,,1,,,,,,,,,,1],[,,1,1,,1,1,1,1,1,1,1,1,1,1,,,,1,,1,1,1,1,,1],[,1,,,,,,,,1],[,1,1,,1,,,,,,,,1,,,,,,1,,,1,,1,,1],[,1,,1,,1,,1,1,1,,1,1,1,,1,,,1,1,,1,1,1,1,1],[,1,1,1,1,1,,,1,1,,,,1,1,1,,,,1,1,,,1,1],[,,1,1,1,1,,1,,1,,1,,1,1,1,1,,,,,1,,1,,1],[1,1,1,1,1,1,1,1,,1,,1,,1,1,1,,,1,1,,,,1,,1],[,,,1],,[,1,1,,1,,,1,1,1,,1,1,1,1,1,1,,1,1,,1,1\
,1,1,1,1],[,1,,,,,,1,,1,,1,,,,,,,1,1,,1,1],[,,,,,,1,,1,1,,1,,1,,,,,,,,,,1],[,1,1,,1,,,,1,,,,1,1,1,,,,1,,1,1,1,,1,1],,[,1,1,,,,,,,,,,,,,1,,,1,,,,,1],[,1,,,,,,,,,,,,,,,,,,,,,,1],[,1,1,,,,,,,1,,,,1,,,,,1,,,,,,,1]],[,[,1,1,1,1,1,,1,,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,,1],[,1,1,1,1,1,,1,,1,1,,,1,1,1,1,,1,,,,,1,1,1],[,,1,1,,1,,1,1,,,,1,1,1,1,,,1,,1,1,1,1,,1],[,1,,1,,,,,,,,1,,1,,1,,,,,,,,,,1],[,,1,,1,,,1,,,,,1,1,,,1,,1,1,1,1],[,1],[,1,1,,1,,1,1,,1,,,1,1,1,,,,1,,,1,,1],[1,1,,1,1,1,,,,,,,,,,,,,1,,1,1,1],[,1,1,,,,,,,1,,,1,,1,,1,,1,1,,,1,,,1],[,,1,,,,,,,,,,,,,,,,,,1],[,1,1,1,1,1,1,1,1,1,1,1,1,,1,1,1,1,1,1,1,1,1,1,1,1,1],[,1,1,1,1,1,,1,,1,,,,,1,1,1,,,1,,1,,,,1],[,1,1,1,1,1,1,1,1,,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1],[,1,1,,1,,,1,1,1,,1,,1,1,1,,,1,1,1,1,,,,1,1],[,,,1,1,,,1,,1,,1,,1,1,1,1,,1,,,,,1],[,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1],[,1,,,,,,,,,,,,,,,,,,,1],[,1,1,,1,1,,1,,1,,,,1,1,,,1,1,,1,1,,1],[,1,1,1,1,1,,,1,1,1,,1,1,1,1,1,1,1,1,,1,1,,,1],[,1,1,1,1,1,,1,1,1,1,,1,1,1,1,1,1,1,1,1,1,1,1\
,,1,1],[,1,1,,1,,,1,,,1,,1,1,1,1,1,,1,,1,1],[,,,,,1,,,,1,,,,,1,1,,,,1],[,1,,1,1,1,,1,,,1,1,1,,,1,,,1,,1,,,1],[,,1,,,,,,,,,1,,1,,,,,1,,1],[,1,1,,,,,,,,1,1,1,,,,,,,,1,,,,,1],[,,,,,,,,1,,,,,1,,,1]],[,[,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1],[,1,1,,1,1,,,1,1,1,1,1,1,1,1,,,,,,,,,1,1],[,,,,,,,,1,,,,1,,1,,1],[,1,,,1,1,,1,,,,1,,,,,,,,1],[,1,,1,,1,,,,1,1,,1,,1,,,,1,1,1,1,1,,,1],,[,1,,,,,,,,1,,,1,1,,,1,,1,1,,1,,1],[,1,,,1,,,,,,,,1,,,,,,,1],[1,1,,,,,1,1,1,1,1,1,1,1,1,,1,1,1,1,1,1,1,,1,1,1],,[,1,,,,,,1,,1,,1,1,1,1,1,,,1,,1,1,,,,1],[,1,1,,,1,,1,,1,,,1,1,1,1,,,1,,,1,,,,1],[,1,1,1,1,1,,1,1,1,,1,1,1,1,1,1,1,1,1,1,,,,1,,1],[,1,,,1,1,,1,1,,,1,1,,1,1,,1,,1,,1],[1,,1,,,,,1,,1,,1,1,1,1,,,,,1,1,,,,1,1],[,1,1,,,,,1,1,,,1,,1,1,1,1,,,,,,,,,,1],,[,1,1,,,1,,,,1,,1,1,1,1,1,,,,1,,,,1,,1],[,,,1,1,,,1,,,,,1,,1,1,1,,1,1,,,,,,1],[,1,,,,,,,,,,,1,,,,1,,,,,,,1,,1],[,1,1,1,1,1,1,1,,1,1,1,1,1,1,,1,1,1,,1,1,,1,1,1,1],[,1,,,,,,,,,,,,,,,,,,,1],[,1,,,,,,1,,,,,1,,1,,,1,1,,1,1,,1],[,1,,,,,,1,,,,,1,1,,,,,,,,1,,,,1],\
[,,,,,,,,,,,,,,,,,,1,,,1,,,,,1],[,,,,,,,1,,,,1]],[,[1,1,1,1,1,1,1,1,1,1,1,1,1,1,,1,1,1,1,1,1,1,1,1,1,1,1],[,1,,1,,1,,,,,,,1,,,,,,,,1,,,1],[,1,,,,,,,1],[,,,,,,,,,,1],[,1,,,,,,1,1,,,,,,1],,[,1,1,,,,,,1,,,,,1,1,,,,1],[1,,1,,1,,,,,1,,,,,1,,,,,,,,,1,1],[,1,1,,,,,,,,,1,1,1,1,,,,1,,,,,1,,,1],,[,1,1,,1,,,1,1,,,1,,,1,1,1,,1,,1,1,1,,,,1],[,,,,,1,,,,,1,,,1,1,,,1,,1,,,,1],[,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1],[,1,,,1,1,,1,,,,1,,,,,,,,1],[,,,1,,,,,1,,,,,1,,1,,1,1,1],[,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1],[,,,,,1],[,1,,,,,,1,,,,,,,1,1,1,,,1],[,1,,,,,,,,,,1,1,1,,,,,1,,,1],[,,,,,1,,1,,,,,1,1,1,,1,1,,1,1,1,,,1,1],[1,1,,,,,,,1,,,,,1,1,,,,,,,,,,,1],,[,1],[,,,,,,,,,,,,,,,,,,,,,,,,1],[,,1,,,,,1,,,1,,,,1,,1],[,1,,,,,,,,,1]]];function Mf(e){e=Array.isArray(e)?e:Sf;var t=[];return e.forEach((function(e,n){var r=String.fromCharCode(n+96).replace("\`","");Array.isArray(e)?t=t.concat(Mf(e).map((function(e){return r+e}))):t.push(r)})),t}var Pf,If=function(e){for(var t=Sf;e.length<3\
;)e+="\`";for(var n=0;n<=e.length-1;n++)if(!(t=t[e.charCodeAt(n)-96]))return!1;return!0};k(jf,vr),Pf=B(jf),K(jf,[{key:"props",get:function(){return this._props}},{key:"attr",value:function(e){return null!=(e=this._attrs[e])?e:null}},{key:"hasAttr",value:function(e){return void 0!==this._attrs[e]}},{key:"attrNames",get:function(){return Object.keys(this._attrs)}}]),Td=jf;function jf(e){var t,n,r;return W(this,jf),(t=Pf.call(this))._props=function(e){var t=null!=(t=e.nodeName)?t:zf[e.nodeType],n=null!=(n=null!=(n=e.nodeType)?n:qf[e.nodeName])?n:1,r=(Or("number"==typeof n,"nodeType has to be a number, got '".concat(n,"'")),Or("string"==typeof t,"nodeName has to be a string, got '".concat(t,"'")),t=t.toLowerCase(),null);return"input"===t&&(r=(e.type||e.attributes&&e.attributes.type||"").toLowerCase(),Of().includes(r)||(r="text")),e=$({},e,{nodeType:n,nodeName:t}),r&&(e.type=r),delete e.attributes,Object.freeze(e)}(e),t._attrs=(e=e.attributes,n=void 0===e?{}:e,r={htmlFor:"for",className:"cla\
ss"},Object.keys(n).reduce((function(e,t){var o=n[t];return Or("object"!==a(o)||null===o,"expects attributes not to be an object, '".concat(t,"' was")),void 0!==o&&(e[r[t]||t]=null!==o?String(o):null),e}),{})),t}var Lf,qf={"#cdata-section":2,"#text":3,"#comment":8,"#document":9,"#document-fragment":11},zf={},Vf=(Object.keys(qf).forEach((function(e){zf[qf[e]]=e})),Td),$f=function(e,t){if(e=e||function(){},t=t||o.log,!o._audit)throw new Error("No audit configured");var n=o.utils.queue(),a=[],i=(Object.keys(o.plugins).forEach((function(e){n.defer((function(t){function n(e){a.push(e),t()}try{o.plugins[e].cleanup(t,n)}catch(e){n(e)}}))})),o.utils.getFlattenedTree(r.body));o.utils.querySelectorAll(i,"iframe, frame").forEach((function(e){n.defer((function(t,n){return o.utils.sendCommandToFrame(e.actualNode,{command:"cleanup-plugin"},t,n)}))})),n.then((function(n){0===a.length?e(n):t(a)})).catch(t)},Hf={};function Uf(e){return Hf.hasOwnProperty(e)}function Gf(e){return"string"==typeof e&&Hf[e]\
?Hf[e]:"function"==typeof e?e:Lf}var Wf={},Yf=(te(Wf,{allowedAttr:function(){return Yf},arialabelText:function(){return au},arialabelledbyText:function(){return ru},getAccessibleRefs:function(){return Xf},getElementUnallowedRoles:function(){return em},getExplicitRole:function(){return mu},getImplicitRole:function(){return zu},getOwnedVirtual:function(){return Yu},getRole:function(){return Hu},getRoleType:function(){return Yl},getRolesByType:function(){return nm},getRolesWithNameFromContents:function(){return im},implicitNodes:function(){return lm},implicitRole:function(){return zu},isAccessibleRef:function(){return sm},isAriaRoleAllowedOnElement:function(){return Zf},isComboboxPopup:function(){return cm},isUnsupportedRole:function(){return pu},isValidRole:function(){return fu},label:function(){return pm},labelVirtual:function(){return Nl},lookupTable:function(){return um},namedFromContents:function(){return Wu},requiredAttr:function(){return fm},requiredContext:function(){return mm},re\
quiredOwned:function(){return Dm},validateAttr:function(){return gm},validateAttrValue:function(){return hm}}),function(e){e=du.ariaRoles[e];var t=z(hu());return e&&(e.allowedAttrs&&t.push.apply(t,z(e.allowedAttrs)),e.requiredAttrs)&&t.push.apply(t,z(e.requiredAttrs)),t}),Kf=/^idrefs?$/,Xf=function(e){e=e.actualNode||e;var t=(t=No(e)).documentElement||t,n=sa.get("idRefsByRoot",(function(){return new Map})),r=n.get(t);return r||(r=new Map,n.set(t,r),function e(t,n,r){if(t.hasAttribute){var a;"LABEL"===t.nodeName.toUpperCase()&&t.hasAttribute("for")&&(a=t.getAttribute("for"),n.has(a)?n.get(a).push(t):n.set(a,[t]));for(var o=0;o<r.length;++o){var i=r[o];if(i=Eu(t.getAttribute(i)||"")){var u,l=Z(sp(i));try{for(l.s();!(u=l.n()).done;){var s=u.value;n.has(s)?n.get(s).push(t):n.set(s,[t])}}catch(e){l.e(e)}finally{l.f()}}}}for(var c=0;c<t.childNodes.length;c++)1===t.childNodes[c].nodeType&&e(t.childNodes[c],n,r)}(t,r,Object.keys(du.ariaAttrs).filter((function(e){return e=du.ariaAttrs[e].type,K\
f.test(e)})))),null!=(n=r.get(e.id))?n:[]},Zf=function(e,t){e=e instanceof vr?e:ca(e);var n=zu(e);e=qu(e);return Array.isArray(e.allowedRoles)?e.allowedRoles.includes(t):t!==n&&!!e.allowedRoles},Jf=["doc-backlink","doc-biblioentry","doc-biblioref","doc-cover","doc-endnote","doc-glossref","doc-noteref"],Qf={header:"banner",footer:"contentinfo"},em=function(e){var t,n,r,a=!(1<arguments.length&&void 0!==arguments[1])||arguments[1],o=nf(e).vNode;return Zp(o)?(r=o.props.nodeName,t=zu(o)||Qf[r],r=[],((n=o)?(n.hasAttr("role")&&(n=sp(n.attr("role").toLowerCase()),r=r.concat(n)),r.filter((function(e){return fu(e)}))):r).filter((function(e){var n=o,r=t;return!(a&&e===r||(!Jf.includes(e)||Yl(e)===r)&&Zf(n,e))}))):[]},tm=function(e){return Object.keys(du.ariaRoles).filter((function(t){return du.ariaRoles[t].type===e}))},nm=function(e){return tm(e)},rm=function(){return sa.get("ariaRolesNameFromContent",(function(){return Object.keys(du.ariaRoles).filter((function(e){return du.ariaRoles[e].nameFrom\
Content}))}))};function am(e){return null===e}function om(e){return null!==e}var im=function(){return rm()},um=((Kt={attributes:{"aria-activedescendant":{type:"idref",allowEmpty:!0,unsupported:!1},"aria-atomic":{type:"boolean",values:["true","false"],unsupported:!1},"aria-autocomplete":{type:"nmtoken",values:["inline","list","both","none"],unsupported:!1},"aria-busy":{type:"boolean",values:["true","false"],unsupported:!1},"aria-checked":{type:"nmtoken",values:["true","false","mixed","undefined"],unsupported:!1},"aria-colcount":{type:"int",unsupported:!1},"aria-colindex":{type:"int",unsupported:!1},"aria-colspan":{type:"int",unsupported:!1},"aria-controls":{type:"idrefs",allowEmpty:!0,unsupported:!1},"aria-current":{type:"nmtoken",allowEmpty:!0,values:["page","step","location","date","time","true","false"],unsupported:!1},"aria-describedby":{type:"idrefs",allowEmpty:!0,unsupported:!1},"aria-describedat":{unsupported:!0,unstandardized:!0},"aria-details":{type:"idref",allowEmpty:!0,unsupp\
orted:!1},"aria-disabled":{type:"boolean",values:["true","false"],unsupported:!1},"aria-dropeffect":{type:"nmtokens",values:["copy","move","reference","execute","popup","none"],unsupported:!1},"aria-errormessage":{type:"idref",allowEmpty:!0,unsupported:!1},"aria-expanded":{type:"nmtoken",values:["true","false","undefined"],unsupported:!1},"aria-flowto":{type:"idrefs",allowEmpty:!0,unsupported:!1},"aria-grabbed":{type:"nmtoken",values:["true","false","undefined"],unsupported:!1},"aria-haspopup":{type:"nmtoken",allowEmpty:!0,values:["true","false","menu","listbox","tree","grid","dialog"],unsupported:!1},"aria-hidden":{type:"boolean",values:["true","false"],unsupported:!1},"aria-invalid":{type:"nmtoken",allowEmpty:!0,values:["true","false","spelling","grammar"],unsupported:!1},"aria-keyshortcuts":{type:"string",allowEmpty:!0,unsupported:!1},"aria-label":{type:"string",allowEmpty:!0,unsupported:!1},"aria-labelledby":{type:"idrefs",allowEmpty:!0,unsupported:!1},"aria-level":{type:"int",unsu\
pported:!1},"aria-live":{type:"nmtoken",values:["off","polite","assertive"],unsupported:!1},"aria-modal":{type:"boolean",values:["true","false"],unsupported:!1},"aria-multiline":{type:"boolean",values:["true","false"],unsupported:!1},"aria-multiselectable":{type:"boolean",values:["true","false"],unsupported:!1},"aria-orientation":{type:"nmtoken",values:["horizontal","vertical"],unsupported:!1},"aria-owns":{type:"idrefs",allowEmpty:!0,unsupported:!1},"aria-placeholder":{type:"string",allowEmpty:!0,unsupported:!1},"aria-posinset":{type:"int",unsupported:!1},"aria-pressed":{type:"nmtoken",values:["true","false","mixed","undefined"],unsupported:!1},"aria-readonly":{type:"boolean",values:["true","false"],unsupported:!1},"aria-relevant":{type:"nmtokens",values:["additions","removals","text","all"],unsupported:!1},"aria-required":{type:"boolean",values:["true","false"],unsupported:!1},"aria-roledescription":{type:"string",allowEmpty:!0,unsupported:!1},"aria-rowcount":{type:"int",unsupported:!\
1},"aria-rowindex":{type:"int",unsupported:!1},"aria-rowspan":{type:"int",unsupported:!1},"aria-selected":{type:"nmtoken",values:["true","false","undefined"],unsupported:!1},"aria-setsize":{type:"int",unsupported:!1},"aria-sort":{type:"nmtoken",values:["ascending","descending","other","none"],unsupported:!1},"aria-valuemax":{type:"decimal",unsupported:!1},"aria-valuemin":{type:"decimal",unsupported:!1},"aria-valuenow":{type:"decimal",unsupported:!1},"aria-valuetext":{type:"string",unsupported:!1}},globalAttributes:["aria-atomic","aria-busy","aria-controls","aria-current","aria-describedby","aria-details","aria-disabled","aria-dropeffect","aria-flowto","aria-grabbed","aria-haspopup","aria-hidden","aria-invalid","aria-keyshortcuts","aria-label","aria-labelledby","aria-live","aria-owns","aria-relevant","aria-roledescription"]}).role={alert:{type:"widget",attributes:{allowed:["aria-expanded","aria-errormessage"]},owned:null,nameFrom:["author"],context:null,unsupported:!1,allowedElements:["\
section"]},alertdialog:{type:"widget",attributes:{allowed:["aria-expanded","aria-modal","aria-errormessage"]},owned:null,nameFrom:["author"],context:null,unsupported:!1,allowedElements:["dialog","section"]},application:{type:"landmark",attributes:{allowed:["aria-expanded","aria-errormessage","aria-activedescendant"]},owned:null,nameFrom:["author"],context:null,unsupported:!1,allowedElements:["article","audio","embed","iframe","object","section","svg","video"]},article:{type:"structure",attributes:{allowed:["aria-expanded","aria-posinset","aria-setsize","aria-errormessage"]},owned:null,nameFrom:["author"],context:null,implicit:["article"],unsupported:!1},banner:{type:"landmark",attributes:{allowed:["aria-expanded","aria-errormessage"]},owned:null,nameFrom:["author"],context:null,implicit:["header"],unsupported:!1,allowedElements:["section"]},button:{type:"widget",attributes:{allowed:["aria-expanded","aria-pressed","aria-errormessage"]},owned:null,nameFrom:["author","contents"],context:n\
ull,implicit:["button",'input[type="button"]','input[type="image"]','input[type="reset"]','input[type="submit"]',"summary"],unsupported:!1,allowedElements:[{nodeName:"a",attributes:{href:om}}]},cell:{type:"structure",attributes:{allowed:["aria-colindex","aria-colspan","aria-rowindex","aria-rowspan","aria-errormessage"]},owned:null,nameFrom:["author","contents"],context:["row"],implicit:["td","th"],unsupported:!1},checkbox:{type:"widget",attributes:{allowed:["aria-checked","aria-required","aria-readonly","aria-errormessage"]},owned:null,nameFrom:["author","contents"],context:null,implicit:['input[type="checkbox"]'],unsupported:!1,allowedElements:["button"]},columnheader:{type:"structure",attributes:{allowed:["aria-colindex","aria-colspan","aria-expanded","aria-rowindex","aria-rowspan","aria-required","aria-readonly","aria-selected","aria-sort","aria-errormessage"]},owned:null,nameFrom:["author","contents"],context:["row"],implicit:["th"],unsupported:!1},combobox:{type:"composite",attrib\
utes:{allowed:["aria-autocomplete","aria-required","aria-activedescendant","aria-orientation","aria-errormessage"],required:["aria-expanded"]},owned:{all:["listbox","tree","grid","dialog","textbox"]},nameFrom:["author"],context:null,unsupported:!1,allowedElements:[{nodeName:"input",properties:{type:["text","search","tel","url","email"]}}]},command:{nameFrom:["author"],type:"abstract",unsupported:!1},complementary:{type:"landmark",attributes:{allowed:["aria-expanded","aria-errormessage"]},owned:null,nameFrom:["author"],context:null,implicit:["aside"],unsupported:!1,allowedElements:["section"]},composite:{nameFrom:["author"],type:"abstract",unsupported:!1},contentinfo:{type:"landmark",attributes:{allowed:["aria-expanded","aria-errormessage"]},owned:null,nameFrom:["author"],context:null,implicit:["footer"],unsupported:!1,allowedElements:["section"]},definition:{type:"structure",attributes:{allowed:["aria-expanded","aria-errormessage"]},owned:null,nameFrom:["author"],context:null,implicit:\
["dd","dfn"],unsupported:!1},dialog:{type:"widget",attributes:{allowed:["aria-expanded","aria-modal","aria-errormessage"]},owned:null,nameFrom:["author"],context:null,implicit:["dialog"],unsupported:!1,allowedElements:["section"]},directory:{type:"structure",attributes:{allowed:["aria-expanded","aria-errormessage"]},owned:null,nameFrom:["author","contents"],context:null,unsupported:!1,allowedElements:["ol","ul"]},document:{type:"structure",attributes:{allowed:["aria-expanded","aria-errormessage"]},owned:null,nameFrom:["author"],context:null,implicit:["body"],unsupported:!1,allowedElements:["article","embed","iframe","object","section","svg"]},"doc-abstract":{type:"section",attributes:{allowed:["aria-expanded","aria-errormessage"]},owned:null,nameFrom:["author"],context:null,unsupported:!1,allowedElements:["section"]},"doc-acknowledgments":{type:"landmark",attributes:{allowed:["aria-expanded","aria-errormessage"]},owned:null,nameFrom:["author"],context:null,unsupported:!1,allowedElement\
s:["section"]},"doc-afterword":{type:"landmark",attributes:{allowed:["aria-expanded","aria-errormessage"]},owned:null,nameFrom:["author"],context:null,unsupported:!1,allowedElements:["section"]},"doc-appendix":{type:"landmark",attributes:{allowed:["aria-expanded","aria-errormessage"]},owned:null,nameFrom:["author"],context:null,unsupported:!1,allowedElements:["section"]},"doc-backlink":{type:"link",attributes:{allowed:["aria-expanded","aria-errormessage"]},owned:null,nameFrom:["author","contents"],context:null,unsupported:!1,allowedElements:[{nodeName:"a",attributes:{href:om}}]},"doc-biblioentry":{type:"listitem",attributes:{allowed:["aria-expanded","aria-level","aria-posinset","aria-setsize","aria-errormessage"]},owned:null,nameFrom:["author"],context:["doc-bibliography"],unsupported:!1,allowedElements:["li"]},"doc-bibliography":{type:"landmark",attributes:{allowed:["aria-expanded","aria-errormessage"]},owned:{one:["doc-biblioentry"]},nameFrom:["author"],context:null,unsupported:!1,al\
lowedElements:["section"]},"doc-biblioref":{type:"link",attributes:{allowed:["aria-expanded","aria-errormessage"]},owned:null,nameFrom:["author","contents"],context:null,unsupported:!1,allowedElements:[{nodeName:"a",attributes:{href:om}}]},"doc-chapter":{type:"landmark",attributes:{allowed:["aria-expanded","aria-errormessage"]},owned:null,namefrom:["author"],context:null,unsupported:!1,allowedElements:["section"]},"doc-colophon":{type:"section",attributes:{allowed:["aria-expanded","aria-errormessage"]},owned:null,namefrom:["author"],context:null,unsupported:!1,allowedElements:["section"]},"doc-conclusion":{type:"landmark",attributes:{allowed:["aria-expanded","aria-errormessage"]},owned:null,namefrom:["author"],context:null,unsupported:!1,allowedElements:["section"]},"doc-cover":{type:"img",attributes:{allowed:["aria-expanded","aria-errormessage"]},owned:null,namefrom:["author"],context:null,unsupported:!1},"doc-credit":{type:"section",attributes:{allowed:["aria-expanded","aria-errormes\
sage"]},owned:null,namefrom:["author"],context:null,unsupported:!1,allowedElements:["section"]},"doc-credits":{type:"landmark",attributes:{allowed:["aria-expanded","aria-errormessage"]},owned:null,namefrom:["author"],context:null,unsupported:!1,allowedElements:["section"]},"doc-dedication":{type:"section",attributes:{allowed:["aria-expanded","aria-errormessage"]},owned:null,namefrom:["author"],context:null,unsupported:!1,allowedElements:["section"]},"doc-endnote":{type:"listitem",attributes:{allowed:["aria-expanded","aria-level","aria-posinset","aria-setsize","aria-errormessage"]},owned:null,namefrom:["author"],context:["doc-endnotes"],unsupported:!1,allowedElements:["li"]},"doc-endnotes":{type:"landmark",attributes:{allowed:["aria-expanded","aria-errormessage"]},owned:{one:["doc-endnote"]},namefrom:["author"],context:null,unsupported:!1,allowedElements:["section"]},"doc-epigraph":{type:"section",attributes:{allowed:["aria-expanded","aria-errormessage"]},owned:null,namefrom:["author"],\
context:null,unsupported:!1},"doc-epilogue":{type:"landmark",attributes:{allowed:["aria-expanded","aria-errormessage"]},owned:null,namefrom:["author"],context:null,unsupported:!1,allowedElements:["section"]},"doc-errata":{type:"landmark",attributes:{allowed:["aria-expanded","aria-errormessage"]},owned:null,namefrom:["author"],context:null,unsupported:!1,allowedElements:["section"]},"doc-example":{type:"section",attributes:{allowed:["aria-expanded","aria-errormessage"]},owned:null,namefrom:["author"],context:null,unsupported:!1,allowedElements:["aside","section"]},"doc-footnote":{type:"section",attributes:{allowed:["aria-expanded","aria-errormessage"]},owned:null,namefrom:["author"],context:null,unsupported:!1,allowedElements:["aside","footer","header"]},"doc-foreword":{type:"landmark",attributes:{allowed:["aria-expanded","aria-errormessage"]},owned:null,namefrom:["author"],context:null,unsupported:!1,allowedElements:["section"]},"doc-glossary":{type:"landmark",attributes:{allowed:["ari\
a-expanded","aria-errormessage"]},owned:["term","definition"],namefrom:["author"],context:null,unsupported:!1,allowedElements:["dl"]},"doc-glossref":{type:"link",attributes:{allowed:["aria-expanded","aria-errormessage"]},owned:null,namefrom:["author","contents"],context:null,unsupported:!1,allowedElements:[{nodeName:"a",attributes:{href:om}}]},"doc-index":{type:"navigation",attributes:{allowed:["aria-expanded","aria-errormessage"]},owned:null,namefrom:["author"],context:null,unsupported:!1,allowedElements:["nav","section"]},"doc-introduction":{type:"landmark",attributes:{allowed:["aria-expanded","aria-errormessage"]},owned:null,namefrom:["author"],context:null,unsupported:!1,allowedElements:["section"]},"doc-noteref":{type:"link",attributes:{allowed:["aria-expanded"]},owned:null,namefrom:["author","contents"],context:null,unsupported:!1,allowedElements:[{nodeName:"a",attributes:{href:om}}]},"doc-notice":{type:"note",attributes:{allowed:["aria-expanded"]},owned:null,namefrom:["author"],\
context:null,unsupported:!1,allowedElements:["section"]},"doc-pagebreak":{type:"separator",attributes:{allowed:["aria-expanded"]},owned:null,namefrom:["author"],context:null,unsupported:!1,allowedElements:["hr"]},"doc-pagelist":{type:"navigation",attributes:{allowed:["aria-expanded"]},owned:null,namefrom:["author"],context:null,unsupported:!1,allowedElements:["nav","section"]},"doc-part":{type:"landmark",attributes:{allowed:["aria-expanded"]},owned:null,namefrom:["author"],context:null,unsupported:!1,allowedElements:["section"]},"doc-preface":{type:"landmark",attributes:{allowed:["aria-expanded"]},owned:null,namefrom:["author"],context:null,unsupported:!1,allowedElements:["section"]},"doc-prologue":{type:"landmark",attributes:{allowed:["aria-expanded","aria-errormessage"]},owned:null,namefrom:["author"],context:null,unsupported:!1,allowedElements:["section"]},"doc-pullquote":{type:"none",attributes:{allowed:["aria-expanded"]},owned:null,namefrom:["author"],context:null,unsupported:!1,a\
llowedElements:["aside","section"]},"doc-qna":{type:"section",attributes:{allowed:["aria-expanded"]},owned:null,namefrom:["author"],context:null,unsupported:!1,allowedElements:["section"]},"doc-subtitle":{type:"sectionhead",attributes:{allowed:["aria-expanded"]},owned:null,namefrom:["author"],context:null,unsupported:!1,allowedElements:{nodeName:["h1","h2","h3","h4","h5","h6"]}},"doc-tip":{type:"note",attributes:{allowed:["aria-expanded"]},owned:null,namefrom:["author"],context:null,unsupported:!1,allowedElements:["aside"]},"doc-toc":{type:"navigation",attributes:{allowed:["aria-expanded","aria-errormessage"]},owned:null,namefrom:["author"],context:null,unsupported:!1,allowedElements:["nav","section"]},feed:{type:"structure",attributes:{allowed:["aria-expanded","aria-errormessage"]},owned:{one:["article"]},nameFrom:["author"],context:null,unsupported:!1,allowedElements:["article","aside","section"]},figure:{type:"structure",attributes:{allowed:["aria-expanded","aria-errormessage"]},own\
ed:null,nameFrom:["author","contents"],context:null,implicit:["figure"],unsupported:!1},form:{type:"landmark",attributes:{allowed:["aria-expanded","aria-errormessage"]},owned:null,nameFrom:["author"],context:null,implicit:["form"],unsupported:!1},grid:{type:"composite",attributes:{allowed:["aria-activedescendant","aria-expanded","aria-colcount","aria-level","aria-multiselectable","aria-readonly","aria-rowcount","aria-errormessage"]},owned:{one:["rowgroup","row"]},nameFrom:["author"],context:null,implicit:["table"],unsupported:!1},gridcell:{type:"widget",attributes:{allowed:["aria-colindex","aria-colspan","aria-expanded","aria-rowindex","aria-rowspan","aria-selected","aria-readonly","aria-required","aria-errormessage"]},owned:null,nameFrom:["author","contents"],context:["row"],implicit:["td","th"],unsupported:!1},group:{type:"structure",attributes:{allowed:["aria-activedescendant","aria-expanded","aria-errormessage"]},owned:null,nameFrom:["author"],context:null,implicit:["details","optg\
roup"],unsupported:!1,allowedElements:["dl","figcaption","fieldset","figure","footer","header","ol","ul"]},heading:{type:"structure",attributes:{required:["aria-level"],allowed:["aria-expanded","aria-errormessage"]},owned:null,nameFrom:["author","contents"],context:null,implicit:["h1","h2","h3","h4","h5","h6"],unsupported:!1},img:{type:"structure",attributes:{allowed:["aria-expanded","aria-errormessage"]},owned:null,nameFrom:["author"],context:null,implicit:["img"],unsupported:!1,allowedElements:["embed","iframe","object","svg"]},input:{nameFrom:["author"],type:"abstract",unsupported:!1},landmark:{nameFrom:["author"],type:"abstract",unsupported:!1},link:{type:"widget",attributes:{allowed:["aria-expanded","aria-errormessage"]},owned:null,nameFrom:["author","contents"],context:null,implicit:["a[href]","area[href]"],unsupported:!1,allowedElements:["button",{nodeName:"input",properties:{type:["image","button"]}}]},list:{type:"structure",attributes:{allowed:["aria-expanded","aria-errormessa\
ge"]},owned:{all:["listitem"]},nameFrom:["author"],context:null,implicit:["ol","ul","dl"],unsupported:!1},listbox:{type:"composite",attributes:{allowed:["aria-activedescendant","aria-multiselectable","aria-readonly","aria-required","aria-expanded","aria-orientation","aria-errormessage"]},owned:{all:["option"]},nameFrom:["author"],context:null,implicit:["select"],unsupported:!1,allowedElements:["ol","ul"]},listitem:{type:"structure",attributes:{allowed:["aria-level","aria-posinset","aria-setsize","aria-expanded","aria-errormessage"]},owned:null,nameFrom:["author","contents"],context:["list"],implicit:["li","dt"],unsupported:!1},log:{type:"widget",attributes:{allowed:["aria-expanded","aria-errormessage"]},owned:null,nameFrom:["author"],context:null,unsupported:!1,allowedElements:["section"]},main:{type:"landmark",attributes:{allowed:["aria-expanded","aria-errormessage"]},owned:null,nameFrom:["author"],context:null,implicit:["main"],unsupported:!1,allowedElements:["article","section"]},ma\
rquee:{type:"widget",attributes:{allowed:["aria-expanded","aria-errormessage"]},owned:null,nameFrom:["author"],context:null,unsupported:!1,allowedElements:["section"]},math:{type:"structure",attributes:{allowed:["aria-expanded","aria-errormessage"]},owned:null,nameFrom:["author"],context:null,implicit:["math"],unsupported:!1},menu:{type:"composite",attributes:{allowed:["aria-activedescendant","aria-expanded","aria-orientation","aria-errormessage"]},owned:{one:["menuitem","menuitemradio","menuitemcheckbox"]},nameFrom:["author"],context:null,implicit:['menu[type="context"]'],unsupported:!1,allowedElements:["ol","ul"]},menubar:{type:"composite",attributes:{allowed:["aria-activedescendant","aria-expanded","aria-orientation","aria-errormessage"]},owned:{one:["menuitem","menuitemradio","menuitemcheckbox"]},nameFrom:["author"],context:null,unsupported:!1,allowedElements:["ol","ul"]},menuitem:{type:"widget",attributes:{allowed:["aria-posinset","aria-setsize","aria-expanded","aria-errormessage"\
]},owned:null,nameFrom:["author","contents"],context:["menu","menubar"],implicit:['menuitem[type="command"]'],unsupported:!1,allowedElements:["button","li",{nodeName:"iput",properties:{type:["image","button"]}},{nodeName:"a",attributes:{href:om}}]},menuitemcheckbox:{type:"widget",attributes:{allowed:["aria-checked","aria-posinset","aria-setsize","aria-errormessage"]},owned:null,nameFrom:["author","contents"],context:["menu","menubar"],implicit:['menuitem[type="checkbox"]'],unsupported:!1,allowedElements:[{nodeName:["button","li"]},{nodeName:"input",properties:{type:["checkbox","image","button"]}},{nodeName:"a",attributes:{href:om}}]},menuitemradio:{type:"widget",attributes:{allowed:["aria-checked","aria-selected","aria-posinset","aria-setsize","aria-errormessage"]},owned:null,nameFrom:["author","contents"],context:["menu","menubar"],implicit:['menuitem[type="radio"]'],unsupported:!1,allowedElements:[{nodeName:["button","li"]},{nodeName:"input",properties:{type:["image","button","radio"\
]}},{nodeName:"a",attributes:{href:om}}]},navigation:{type:"landmark",attributes:{allowed:["aria-expanded","aria-errormessage"]},owned:null,nameFrom:["author"],context:null,implicit:["nav"],unsupported:!1,allowedElements:["section"]},none:{type:"structure",attributes:null,owned:null,nameFrom:["author"],context:null,unsupported:!1,allowedElements:[{nodeName:["article","aside","dl","embed","figcaption","fieldset","figure","footer","form","h1","h2","h3","h4","h5","h6","header","hr","iframe","li","ol","section","ul"]},{nodeName:"img",attributes:{alt:om}}]},note:{type:"structure",attributes:{allowed:["aria-expanded","aria-errormessage"]},owned:null,nameFrom:["author"],context:null,unsupported:!1,allowedElements:["aside"]},option:{type:"widget",attributes:{allowed:["aria-selected","aria-posinset","aria-setsize","aria-checked","aria-errormessage"]},owned:null,nameFrom:["author","contents"],context:["listbox"],implicit:["option"],unsupported:!1,allowedElements:[{nodeName:["button","li"]},{node\
Name:"input",properties:{type:["checkbox","button"]}},{nodeName:"a",attributes:{href:om}}]},presentation:{type:"structure",attributes:null,owned:null,nameFrom:["author"],context:null,unsupported:!1,allowedElements:[{nodeName:["article","aside","dl","embed","figcaption","fieldset","figure","footer","form","h1","h2","h3","h4","h5","h6","header","hr","iframe","li","ol","section","ul"]},{nodeName:"img",attributes:{alt:om}}]},progressbar:{type:"widget",attributes:{allowed:["aria-valuetext","aria-valuenow","aria-valuemax","aria-valuemin","aria-expanded","aria-errormessage"]},owned:null,nameFrom:["author"],context:null,implicit:["progress"],unsupported:!1},radio:{type:"widget",attributes:{allowed:["aria-selected","aria-posinset","aria-setsize","aria-required","aria-errormessage","aria-checked"]},owned:null,nameFrom:["author","contents"],context:null,implicit:['input[type="radio"]'],unsupported:!1,allowedElements:[{nodeName:["button","li"]},{nodeName:"input",properties:{type:["image","button"]\
}}]},radiogroup:{type:"composite",attributes:{allowed:["aria-activedescendant","aria-required","aria-expanded","aria-readonly","aria-errormessage","aria-orientation"]},owned:{all:["radio"]},nameFrom:["author"],context:null,unsupported:!1,allowedElements:{nodeName:["ol","ul","fieldset"]}},range:{nameFrom:["author"],type:"abstract",unsupported:!1},region:{type:"landmark",attributes:{allowed:["aria-expanded","aria-errormessage"]},owned:null,nameFrom:["author"],context:null,implicit:["section[aria-label]","section[aria-labelledby]","section[title]"],unsupported:!1,allowedElements:{nodeName:["article","aside"]}},roletype:{type:"abstract",unsupported:!1},row:{type:"structure",attributes:{allowed:["aria-activedescendant","aria-colindex","aria-expanded","aria-level","aria-selected","aria-rowindex","aria-errormessage"]},owned:{one:["cell","columnheader","rowheader","gridcell"]},nameFrom:["author","contents"],context:["rowgroup","grid","treegrid","table"],implicit:["tr"],unsupported:!1},rowgroup\
:{type:"structure",attributes:{allowed:["aria-activedescendant","aria-expanded","aria-errormessage"]},owned:{all:["row"]},nameFrom:["author","contents"],context:["grid","table","treegrid"],implicit:["tbody","thead","tfoot"],unsupported:!1},rowheader:{type:"structure",attributes:{allowed:["aria-colindex","aria-colspan","aria-expanded","aria-rowindex","aria-rowspan","aria-required","aria-readonly","aria-selected","aria-sort","aria-errormessage"]},owned:null,nameFrom:["author","contents"],context:["row"],implicit:["th"],unsupported:!1},scrollbar:{type:"widget",attributes:{required:["aria-controls","aria-valuenow"],allowed:["aria-valuetext","aria-orientation","aria-errormessage","aria-valuemax","aria-valuemin"]},owned:null,nameFrom:["author"],context:null,unsupported:!1},search:{type:"landmark",attributes:{allowed:["aria-expanded","aria-errormessage"]},owned:null,nameFrom:["author"],context:null,unsupported:!1,allowedElements:{nodeName:["aside","form","section"]}},searchbox:{type:"widget",\
attributes:{allowed:["aria-activedescendant","aria-autocomplete","aria-multiline","aria-readonly","aria-required","aria-placeholder","aria-errormessage"]},owned:null,nameFrom:["author"],context:null,implicit:['input[type="search"]'],unsupported:!1,allowedElements:{nodeName:"input",properties:{type:"text"}}},section:{nameFrom:["author","contents"],type:"abstract",unsupported:!1},sectionhead:{nameFrom:["author","contents"],type:"abstract",unsupported:!1},select:{nameFrom:["author"],type:"abstract",unsupported:!1},separator:{type:"structure",attributes:{allowed:["aria-expanded","aria-orientation","aria-valuenow","aria-valuemax","aria-valuemin","aria-valuetext","aria-errormessage"]},owned:null,nameFrom:["author"],context:null,implicit:["hr"],unsupported:!1,allowedElements:["li"]},slider:{type:"widget",attributes:{allowed:["aria-valuetext","aria-orientation","aria-readonly","aria-errormessage","aria-valuemax","aria-valuemin"],required:["aria-valuenow"]},owned:null,nameFrom:["author"],contex\
t:null,implicit:['input[type="range"]'],unsupported:!1},spinbutton:{type:"widget",attributes:{allowed:["aria-valuetext","aria-required","aria-readonly","aria-errormessage","aria-valuemax","aria-valuemin"],required:["aria-valuenow"]},owned:null,nameFrom:["author"],context:null,implicit:['input[type="number"]'],unsupported:!1,allowedElements:{nodeName:"input",properties:{type:["text","tel"]}}},status:{type:"widget",attributes:{allowed:["aria-expanded","aria-errormessage"]},owned:null,nameFrom:["author"],context:null,implicit:["output"],unsupported:!1,allowedElements:["section"]},structure:{type:"abstract",unsupported:!1},switch:{type:"widget",attributes:{allowed:["aria-errormessage"],required:["aria-checked"]},owned:null,nameFrom:["author","contents"],context:null,unsupported:!1,allowedElements:["button",{nodeName:"input",properties:{type:["checkbox","image","button"]}},{nodeName:"a",attributes:{href:om}}]},tab:{type:"widget",attributes:{allowed:["aria-selected","aria-expanded","aria-set\
size","aria-posinset","aria-errormessage"]},owned:null,nameFrom:["author","contents"],context:["tablist"],unsupported:!1,allowedElements:[{nodeName:["button","h1","h2","h3","h4","h5","h6","li"]},{nodeName:"input",properties:{type:"button"}},{nodeName:"a",attributes:{href:om}}]},table:{type:"structure",attributes:{allowed:["aria-colcount","aria-rowcount","aria-errormessage"]},owned:{one:["rowgroup","row"]},nameFrom:["author","contents"],context:null,implicit:["table"],unsupported:!1},tablist:{type:"composite",attributes:{allowed:["aria-activedescendant","aria-expanded","aria-level","aria-multiselectable","aria-orientation","aria-errormessage"]},owned:{all:["tab"]},nameFrom:["author"],context:null,unsupported:!1,allowedElements:["ol","ul"]},tabpanel:{type:"widget",attributes:{allowed:["aria-expanded","aria-errormessage"]},owned:null,nameFrom:["author"],context:null,unsupported:!1,allowedElements:["section"]},term:{type:"structure",attributes:{allowed:["aria-expanded","aria-errormessage"]\
},owned:null,nameFrom:["author","contents"],context:null,implicit:["dt"],unsupported:!1},textbox:{type:"widget",attributes:{allowed:["aria-activedescendant","aria-autocomplete","aria-multiline","aria-readonly","aria-required","aria-placeholder","aria-errormessage"]},owned:null,nameFrom:["author"],context:null,implicit:['input[type="text"]','input[type="email"]','input[type="password"]','input[type="tel"]','input[type="url"]',"input:not([type])","textarea"],unsupported:!1},timer:{type:"widget",attributes:{allowed:["aria-expanded","aria-errormessage"]},owned:null,nameFrom:["author"],context:null,unsupported:!1},toolbar:{type:"structure",attributes:{allowed:["aria-activedescendant","aria-expanded","aria-orientation","aria-errormessage"]},owned:null,nameFrom:["author"],context:null,implicit:['menu[type="toolbar"]'],unsupported:!1,allowedElements:["ol","ul"]},tooltip:{type:"structure",attributes:{allowed:["aria-expanded","aria-errormessage"]},owned:null,nameFrom:["author","contents"],contex\
t:null,unsupported:!1},tree:{type:"composite",attributes:{allowed:["aria-activedescendant","aria-multiselectable","aria-required","aria-expanded","aria-orientation","aria-errormessage"]},owned:{all:["treeitem"]},nameFrom:["author"],context:null,unsupported:!1,allowedElements:["ol","ul"]},treegrid:{type:"composite",attributes:{allowed:["aria-activedescendant","aria-colcount","aria-expanded","aria-level","aria-multiselectable","aria-readonly","aria-required","aria-rowcount","aria-orientation","aria-errormessage"]},owned:{one:["rowgroup","row"]},nameFrom:["author"],context:null,unsupported:!1},treeitem:{type:"widget",attributes:{allowed:["aria-checked","aria-selected","aria-expanded","aria-level","aria-posinset","aria-setsize","aria-errormessage"]},owned:null,nameFrom:["author","contents"],context:["group","tree"],unsupported:!1,allowedElements:["li",{nodeName:"a",attributes:{href:om}}]},widget:{type:"abstract",unsupported:!1},window:{nameFrom:["author"],type:"abstract",unsupported:!1}},K\
t.implicitHtmlRole=xu,Kt.elementsAllowedNoRole=[{nodeName:["base","body","caption","col","colgroup","datalist","dd","details","dt","head","html","keygen","label","legend","main","map","math","meta","meter","noscript","optgroup","param","picture","progress","script","source","style","template","textarea","title","track"]},{nodeName:"area",attributes:{href:om}},{nodeName:"input",properties:{type:["color","data","datatime","file","hidden","month","number","password","range","reset","submit","time","week"]}},{nodeName:"link",attributes:{href:om}},{nodeName:"menu",attributes:{type:"context"}},{nodeName:"menuitem",attributes:{type:["command","checkbox","radio"]}},{nodeName:"select",condition:function(e){return e instanceof o.AbstractVirtualNode||(e=o.utils.getNodeFromTree(e)),1<Number(e.attr("size"))},properties:{multiple:!0}},{nodeName:["clippath","cursor","defs","desc","feblend","fecolormatrix","fecomponenttransfer","fecomposite","feconvolvematrix","fediffuselighting","fedisplacementmap","\
fedistantlight","fedropshadow","feflood","fefunca","fefuncb","fefuncg","fefuncr","fegaussianblur","feimage","femerge","femergenode","femorphology","feoffset","fepointlight","fespecularlighting","fespotlight","fetile","feturbulence","filter","hatch","hatchpath","lineargradient","marker","mask","meshgradient","meshpatch","meshrow","metadata","mpath","pattern","radialgradient","solidcolor","stop","switch","view"]}],Kt.elementsAllowedAnyRole=[{nodeName:"a",attributes:{href:am}},{nodeName:"img",attributes:{alt:am}},{nodeName:["abbr","address","canvas","div","p","pre","blockquote","ins","del","output","span","table","tbody","thead","tfoot","td","em","strong","small","s","cite","q","dfn","abbr","time","code","var","samp","kbd","sub","sup","i","b","u","mark","ruby","rt","rp","bdi","bdo","br","wbr","th","tr"]}],Kt.evaluateRoleForElement={A:function(e){var t=e.node;e=e.out;return"http://www.w3.org/2000/svg"===t.namespaceURI||!t.href.length||e},AREA:function(e){return!e.node.href},BUTTON:function\
(e){var t=e.node,n=e.role;e=e.out;return"menu"===t.getAttribute("type")?"menuitem"===n:e},IMG:function(e){var t=e.node,n=e.role,r=e.out;switch(t.alt){case null:return r;case"":return"presentation"===n||"none"===n;default:return"presentation"!==n&&"none"!==n}},INPUT:function(e){var t=e.node,n=e.role,r=e.out;switch(t.type){case"button":case"image":return r;case"checkbox":return!("button"!==n||!t.hasAttribute("aria-pressed"))||r;case"radio":return"menuitemradio"===n;case"text":return"combobox"===n||"searchbox"===n||"spinbutton"===n;case"tel":return"combobox"===n||"spinbutton"===n;case"url":case"search":case"email":return"combobox"===n;default:return!1}},LI:function(e){var t=e.node;e=e.out;return!o.utils.matchesSelector(t,"ol li, ul li")||e},MENU:function(e){return"context"!==e.node.getAttribute("type")},OPTION:function(e){return e=e.node,!o.utils.matchesSelector(e,"select > option, datalist > option, optgroup > option")},SELECT:function(e){var t=e.node;e=e.role;return!t.multiple&&t.size<=\
1&&"menu"===e},SVG:function(e){var t=e.node;e=e.out;return!(!t.parentNode||"http://www.w3.org/2000/svg"!==t.parentNode.namespaceURI)||e}},Kt.rolesOfType={widget:["button","checkbox","dialog","gridcell","link","log","marquee","menuitem","menuitemcheckbox","menuitemradio","option","progressbar","radio","scrollbar","searchbox","slider","spinbutton","status","switch","tab","tabpanel","textbox","timer","tooltip","tree","treeitem"]},Kt),lm=function(e){var t=null;return(e=um.role[e])&&e.implicit?Da(e.implicit):t},sm=function(e){return!!Xf(e).length};function cm(e){var t=(1<arguments.length&&void 0!==arguments[1]?arguments[1]:{}).popupRoles,n=Hu(e);if(!(t=null!=t?t:ou["aria-haspopup"].values).includes(n))return!1;if(t=function(e){for(;e=e.parent;)if(null!==Hu(e,{noPresentational:!0}))return e;return null}(e),dm(t))return!0;if(!(n=e.props.id))return!1;if(e.actualNode)return t=ko(e.actualNode).querySelectorAll('[aria-owns~="'.concat(n,'"][role~="combobox"]:not(select),\\n     [aria-controls~="').\
concat(n,'"][role~="combobox"]:not(select)')),Array.from(t).some(dm);throw new Error("Unable to determine combobox popup without an actualNode")}var dm=function(e){return e&&"combobox"===Hu(e)},pm=function(e){return e=ca(e),Nl(e)},fm=function(e){return(e=du.ariaRoles[e])&&Array.isArray(e.requiredAttrs)?z(e.requiredAttrs):[]},mm=function(e){return(e=du.ariaRoles[e])&&Array.isArray(e.requiredContext)?z(e.requiredContext):null},Dm=function(e){return(e=du.ariaRoles[e])&&Array.isArray(e.requiredOwned)?z(e.requiredOwned):null},hm=function(e,t){var n,r=(e=e instanceof vr?e:ca(e)).attr(t),a=du.ariaAttrs[t];if(!a)return!0;if(a.allowEmpty&&(!r||""===r.trim()))return!0;switch(a.type){case"boolean":return["true","false"].includes(r.toLowerCase());case"nmtoken":return"string"==typeof r&&a.values.includes(r.toLowerCase());case"nmtokens":return(n=sp(r)).reduce((function(e,t){return e&&a.values.includes(t)}),0!==n.length);case"idref":try{var o=No(e.actualNode);return!(!r||!o.getElementById(r))}catch(e\
){throw new TypeError("Cannot resolve id references for partial DOM")}case"idrefs":return tu(e,t).some((function(e){return!!e}));case"string":return""!==r.trim();case"decimal":return!(!(n=r.match(/^[-+]?([0-9]*)\\.?([0-9]*)$/))||!n[1]&&!n[2]);case"int":return o=void 0!==a.minValue?a.minValue:-1/0,/^[-+]?[0-9]+$/.test(r)&&parseInt(r)>=o}},gm=function(e){return!!du.ariaAttrs[e]};function bm(e,t,n){var r=(a=n.props).nodeName,a=a.type,o=function(e){return e?(e=e.toLowerCase(),["mixed","true"].includes(e)?e:"false"):""}(n.attr("aria-checked"));return"input"!==r||"checkbox"!==a||!o||o===(r=function(e){return e.props.indeterminate?"mixed":e.props.checked?"true":"false"}(n))||(this.data({messageKey:"checkbox",checkState:r}),!1)}function vm(e){var t,n,r=(1<arguments.length&&void 0!==arguments[1]?arguments[1]:{}).invalidTableRowAttrs,a=2<arguments.length?arguments[2]:void 0;r=null!=(t=null==r||null==(t=r.filter)?void 0:t.call(r,(function(e){return a.hasAttr(e)})))?t:[];return 0===r.length||!(t=(t\
=function(e){if(e.parent)return xa(e,'table:not([role]), [role~="treegrid"], [role~="table"], [role~="grid"]')}(a))&&Hu(t))||"treegrid"===t||(n="row".concat(1<r.length?"Plural":"Singular"),this.data({messageKey:n,invalidAttrs:r,ownerRole:t}),!1)}var ym={row:vm,checkbox:bm};var Fm={};function wm(e){return 3===(e=e.vNode).props.nodeType?0<e.props.nodeValue.trim().length:ql(e,!1,!0)}function Em(e,t,n,r){var a=mu(e);if(!(n=n||mm(a)))return null;for(var o=n.includes("group"),i=r?e:e.parent;i;){var u=Hu(i,{noPresentational:!0});if(u){if("group"!==u||!o)return n.includes(u)?null:n;t.includes(a)&&n.push(a),n=n.filter((function(e){return"group"!==e}))}i=i.parent}return n}te(Fm,{getAriaRolesByType:function(){return tm},getAriaRolesSupportingNameFromContent:function(){return rm},getElementSpec:function(){return qu},getElementsByContentType:function(){return Du},getGlobalAriaAttrs:function(){return hu},implicitHtmlRoles:function(){return xu}});var Cm={ARTICLE:!0,ASIDE:!0,NAV:!0,SECTION:!0},xm={app\
lication:!0,article:!0,banner:!1,complementary:!0,contentinfo:!0,form:!0,main:!0,navigation:!0,region:!0,search:!1};var Am={},km=(te(Am,{Color:function(){return $d},centerPointOfRect:function(){return km},elementHasImage:function(){return os},elementIsDistinct:function(){return Bm},filteredRectStack:function(){return Rm},flattenColors:function(){return Sm},flattenShadowColors:function(){return Mm},getBackgroundColor:function(){return Xm},getBackgroundStack:function(){return Pm},getContrast:function(){return Qm},getForegroundColor:function(){return eD},getOwnBackgroundColor:function(){return Ud},getRectStack:function(){return Tm},getStackingContext:function(){return Um},getStrokeColorsFromShadows:function(){return zm},getTextShadowColors:function(){return Hm},hasValidContrastRatio:function(){return tD},incompleteData:function(){return as},parseTextShadows:function(){return $m},stackingContextToColor:function(){return Gm}}),function(e){if(!(e.left>t.innerWidth||e.top>t.innerHeight))retur\
n{x:Math.min(Math.ceil(e.left+e.width/2),t.innerWidth-1),y:Math.min(Math.ceil(e.top+e.height/2),t.innerHeight-1)}});function Nm(e){return e.getPropertyValue("font-family").split(/[,;]/g).map((function(e){return e.trim().toLowerCase()}))}var Bm=function(e,n){var r,a=t.getComputedStyle(e);return"none"!==a.getPropertyValue("background-image")||!!["border-bottom","border-top","outline"].reduce((function(e,t){var n=new $d;return n.parseString(a.getPropertyValue(t+"-color")),e||"none"!==a.getPropertyValue(t+"-style")&&0<parseFloat(a.getPropertyValue(t+"-width"))&&0!==n.alpha}),!1)||(r=t.getComputedStyle(n),Nm(a)[0]!==Nm(r)[0])||(e=["text-decoration-line","text-decoration-style","font-weight","font-style","font-size"].reduce((function(e,t){return e||a.getPropertyValue(t)!==r.getPropertyValue(t)}),!1),(n=a.getPropertyValue("text-decoration")).split(" ").length<3?e||n!==r.getPropertyValue("text-decoration"):e)},Tm=function(e){var t=Wi(e);return!(e=Ml(e))||e.length<=1?[t]:e.some((function(e){ret\
urn void 0===e}))?null:(e.splice(0,0,t),e)},Rm=function(e){var t,n,r=Tm(e);return r&&1===r.length?r[0]:r&&1<r.length?(t=r.shift(),r.forEach((function(a,o){var i,u;0!==o&&(i=r[o-1],u=r[o],n=i.every((function(e,t){return e===u[t]}))||t.includes(e))})),n?r[0]:(as.set("bgColor","elmPartiallyObscuring"),null)):(as.set("bgColor","outsideViewport"),null)},_m={normal:function(e,t){return t},multiply:function(e,t){return t*e},screen:function(e,t){return e+t-e*t},overlay:function(e,t){return this["hard-light"](t,e)},darken:function(e,t){return Math.min(e,t)},lighten:function(e,t){return Math.max(e,t)},"color-dodge":function(e,t){return 0===e?0:1===t?1:Math.min(1,e/(1-t))},"color-burn":function(e,t){return 1===e?1:0===t?0:1-Math.min(1,(1-e)/t)},"hard-light":function(e,t){return t<=.5?this.multiply(e,2*t):this.screen(e,2*t-1)},"soft-light":function(e,t){return t<=.5?e-(1-2*t)*e*(1-e):e+(2*t-1)*((e<=.25?((16*e-12)*e+4)*e:Math.sqrt(e))-e)},difference:function(e,t){return Math.abs(e-t)},exclusion:fun\
ction(e,t){return e+t-2*e*t}};function Om(e,t,n,r,a){return t*(1-r)*e+t*r*_m[a](n/255,e/255)*255+(1-t)*r*n}var Sm=function(e,t){var n,r,a=2<arguments.length&&void 0!==arguments[2]?arguments[2]:"normal",o=Om(e.red,e.alpha,t.red,t.alpha,a),i=Om(e.green,e.alpha,t.green,t.alpha,a),u=(a=Om(e.blue,e.alpha,t.blue,t.alpha,a),n=e.alpha+t.alpha*(1-e.alpha),u=0,r=1,Math.min(Math.max(u,n),r));return 0===u?new $d(o,i,a,u):(n=Math.round(o/u),r=Math.round(i/u),o=Math.round(a/u),new $d(n,r,o,u))};function Mm(e,t){var n=(1-(a=e.alpha))*t.red+a*e.red,r=(1-a)*t.green+a*e.green,a=(1-a)*t.blue+a*e.blue;t=e.alpha+t.alpha*(1-e.alpha);return new $d(n,r,a,t)}function Pm(e){for(var n=Ml(e).map((function(n){return function(e){var n=e.indexOf(r.body),a=Ud(t.getComputedStyle(r.documentElement));return 1<n&&0===a.alpha&&!os(r.documentElement)&&(1<n&&(e.splice(n,1),e.push(r.body)),0<(a=e.indexOf(r.documentElement)))&&(e.splice(a,1),e.push(r.documentElement)),e}(n=Jd(n,e))})),a=0;a<n.length;a++){var o=n[a];if(o[0]!==\
e)return as.set("bgColor","bgOverlap"),null;if(0!==a&&!function(e,t){if(e!==t){if(null===e||null===t)return;if(e.length!==t.length)return;for(var n=0;n<e.length;++n)if(e[n]!==t[n])return}return 1}(o,n[0]))return as.set("bgColor","elmPartiallyObscuring"),null}return n[0]||null}var Im=.54,jm=.5,Lm=1.5,qm=["top","right","bottom","left"];function zm(e){var t=void 0!==(t=(1<arguments.length&&void 0!==arguments[1]?arguments[1]:{}).ignoreEdgeCount)&&t,n=function(e){var t,n={},r=Z(e);try{for(r.s();!(t=r.n()).done;){var a=t.value,o=a.colorStr,i=a.pixels,u=(null!=n[o]||(n[o]={top:[],right:[],bottom:[],left:[]}),n[o]),l=H(i,2),s=l[0],c=l[1];jm<s?u.right.push(s):jm<-s&&u.left.push(-s),jm<c?u.bottom.push(c):jm<-c&&u.top.push(-c)}}catch(e){r.e(e)}finally{r.f()}return n}(e);n=Object.entries(n).map((function(e){var t=(e=H(e,2))[0],n=e[1];e=qm.filter((function(e){return 0!==n[e].length})).length;return{colorStr:t,sides:n,edgeCount:e}}));return!t&&n.some((function(e){return 1<(e=e.edgeCount)&&e<4}))?nul\
l:n.map(Vm).filter((function(e){return null!==e}))}function Vm(e){var t,n,r=e.colorStr,a=e.sides;return 4!==e.edgeCount?null:((e=new $d).parseString(r),n=!(t=0),qm.forEach((function(e){t+=a[e].length/4,n=n&&a[e].every((function(e){return Lm<e}))})),n||(e.alpha=1-Math.pow(Im,t)),e)}function $m(e){var t={pixels:[]},n=[t];if(!(o=e.trim()))return[];for(;o;){var r=o.match(/^[a-z]+(\\([^)]+\\))?/i)||o.match(/^#[0-9a-f]+/i),a=o.match(/^([0-9.-]+)px/i)||o.match(/^(0)/);if(r)Or(!t.colorStr,"Multiple colors identified in text-shadow: ".concat(e)),o=o.replace(r[0],"").trim(),t.colorStr=r[0];else if(a){Or(t.pixels.length<3,"Too many pixel units in text-shadow: ".concat(e));var o=o.replace(a[0],"").trim();r=parseFloat(("."===a[1][0]?"0":"")+a[1]);t.pixels.push(r)}else{if(","!==o[0])throw new Error("Unable to process text-shadows: ".concat(o));Or(2<=t.pixels.length,"Missing pixel value in text-shadow: ".concat(e)),n.push(t={pixels:[]}),o=o.substr(1).trim()}}return n.forEach((function(e){2===(e=e.pixel\
s).length&&e.push(0)})),n}function Hm(e){var n,r=(n=1<arguments.length&&void 0!==arguments[1]?arguments[1]:{}).minRatio,a=n.maxRatio,o=n.ignoreEdgeCount,i=[],u=t.getComputedStyle(e);if("none"!==(n=u.getPropertyValue("text-shadow"))){var l,s=u.getPropertyValue("font-size"),c=parseInt(s),d=(Or(!1===isNaN(c),"Unable to determine font-size value ".concat(s)),[]),p=Z($m(n));try{for(p.s();!(l=p.n()).done;){var f=l.value,m=f.colorStr||u.getPropertyValue("color"),D=H(f.pixels,3),h=D[0],g=D[1],b=D[2],v=void 0===b?0:b;if(!(a&&c*a<=v))if(r&&v<c*r)d.push({colorStr:m,pixels:f.pixels});else{if(0<d.length){var y=zm(d,{ignoreEdgeCount:o});if(null===y)return null;i.push.apply(i,z(y)),d.splice(0,d.length)}var F=function(e){var t=e.colorStr,n=e.offsetX,r=e.offsetY,a=e.blurRadius;e=e.fontSize;return a<n||a<r?new $d(0,0,0,0):((n=new $d).parseString(t),n.alpha*=function(e,t){return 0===e?1:.185/(e/t+.4)}(a,e),n)}({colorStr:m,offsetX:h,offsetY:g,blurRadius:v,fontSize:c});i.push(F)}}}catch(e){p.e(e)}finally{p\
.f()}if(0<d.length){if(null===(s=zm(d,{ignoreEdgeCount:o})))return null;i.push.apply(i,z(s))}}return i}function Um(e,t){var n,r,a,o=ca(e);return o._stackingContext||(r=[],a=new Map,(t=null!=(n=t)?n:Pm(e)).forEach((function(e){var t=(t=e=ca(e),(o=new $d).parseString(t.getComputedStylePropertyValue("background-color")),o),n=e._stackingOrder.filter((function(e){return!!e.vNode})),o=(n.forEach((function(e,t){e=e.vNode;var o=null==(o=n[t-1])?void 0:o.vNode;o=Km(a,e,o);0!==t||a.get(e)||r.unshift(o),a.set(e,o)})),null==(o=n[n.length-1])?void 0:o.vNode);e=Km(a,e,o);n.length||r.unshift(e),e.bgColor=t})),o._stackingContext=r)}function Gm(e){var t;return null!=(t=e.descendants)&&t.length?(t=e.descendants.reduce(Wm,Ym()),(t=Sm(t,e.bgColor,e.descendants[0].blendMode)).alpha*=e.opacity):(t=e.bgColor).alpha*=e.opacity,{color:t,blendMode:e.blendMode}}function Wm(e,t){e=e instanceof $d?e:Gm(e).color;var n=Gm(t).color;return Sm(n,e,t.blendMode)}function Ym(e,t){return{vNode:e,ancestor:t,opacity:parseFlo\
at(null!=(t=null==e?void 0:e.getComputedStylePropertyValue("opacity"))?t:1),bgColor:new $d(0,0,0,0),blendMode:(null==e?void 0:e.getComputedStylePropertyValue("mix-blend-mode"))||void 0,descendants:[]}}function Km(e,t,n){var r=e.get(n);e=null!=(e=e.get(t))?e:Ym(t,r);return r&&n!==t&&!r.descendants.includes(e)&&r.descendants.unshift(e),e}function Xm(e){var n=1<arguments.length&&void 0!==arguments[1]?arguments[1]:[],a=2<arguments.length&&void 0!==arguments[2]?arguments[2]:.1,o=ca(e),i=o._cache.getBackgroundColor;return i?(n.push.apply(n,z(i.bgElms)),as.set("bgColor",i.incompleteData),i.bgColor):(i=function(e,n,a){var o=Pm(e);if(!o)return null;var i=Sl(e);(a=null!=(a=Hm(e,{minRatio:a,ignoreEdgeCount:!0}))?a:[]).length&&(a=[{color:a.reduce(Mm)}]);for(var u=0;u<o.length;u++){var l=o[u],s=t.getComputedStyle(l);if(os(l,s))return n.push(l),null;var c=Ud(s);if(0!==c.alpha){if("inline"!==s.getPropertyValue("display")&&!Zm(l,i))return n.push(l),as.set("bgColor","elmPartiallyObscured"),null;if(n.pu\
sh(l),1===c.alpha)break}}var d=(a=(d=Um(e,o)).map(Gm).concat(a),function(e,n){var a,o,i,u,l=[];return n||(n=r.documentElement,u=r.body,n=t.getComputedStyle(n),a=t.getComputedStyle(u),o=Ud(n),u=0!==(i=Ud(a)).alpha&&Zm(u,e.getBoundingClientRect()),(0!==i.alpha&&0===o.alpha||u&&1!==i.alpha)&&l.unshift({color:i,blendMode:Jm(a.getPropertyValue("mix-blend-mode"))}),0===o.alpha)||u&&1===i.alpha||l.unshift({color:o,blendMode:Jm(n.getPropertyValue("mix-blend-mode"))}),l}(e,o.includes(r.body)));return a.unshift.apply(a,z(d)),0===a.length?new $d(255,255,255,1):(e=a.reduce((function(e,t){return Sm(t.color,e.color instanceof $d?e.color:e,t.blendMode)})),Sm(e.color instanceof $d?e.color:e,new $d(255,255,255,1)))}(e,n,a),o._cache.getBackgroundColor={bgColor:i,bgElms:n,incompleteData:as.get("bgColor")},i)}function Zm(e,n){n=Array.isArray(n)?n:[n];var r=e.getBoundingClientRect(),a=r.right,o=r.bottom,i=t.getComputedStyle(e).getPropertyValue("overflow");return(["scroll","auto"].includes(i)||e instanceof \
t.HTMLHtmlElement)&&(a=r.left+e.scrollWidth,o=r.top+e.scrollHeight),n.every((function(e){return e.top>=r.top&&e.bottom<=o&&e.left>=r.left&&e.right<=a}))}function Jm(e){return e||void 0}var Qm=function(e,t){return t&&e?(t.alpha<1&&(t=Sm(t,e)),e=e.getRelativeLuminance(),t=t.getRelativeLuminance(),(Math.max(t,e)+.05)/(Math.min(t,e)+.05)):null};function eD(e,n,r){for(var a=3<arguments.length&&void 0!==arguments[3]?arguments[3]:{},o=t.getComputedStyle(e),i=[],u=0,l=[function(){var e,t,n=o,r=void 0===(r=(r=a).textStrokeEmMin)?0:r;return 0===(t=parseFloat(n.getPropertyValue("-webkit-text-stroke-width")))||(e=n.getPropertyValue("font-size"),t/=parseFloat(e),isNaN(t))||t<r?null:(e=n.getPropertyValue("-webkit-text-stroke-color"),(new $d).parseString(e))},function(){return e=o,(new $d).parseString(e.getPropertyValue("-webkit-text-fill-color")||e.getPropertyValue("color"));var e},function(){return Hm(e,{minRatio:0})}];u<l.length;u++){var s=(0,l[u])();if(s&&(i=i.concat(s),1===s.alpha))break}var c,d\
,p=i.reduce((function(e,t){return Sm(e,t)}));return null===(r=null==r?Xm(e,[]):r)?(c=as.get("bgColor"),as.set("fgColor",c),null):(d=function e(t,n){var r,a=Z(t);try{for(a.s();!(r=a.n()).done;){var o,i=r.value;if((null==(o=i.vNode)?void 0:o.actualNode)===n)return i;var u=e(i.descendants,n);if(u)return u}}catch(e){a.e(e)}finally{a.f()}}(c=Um(e),e),Sm(function(e,t,n){for(;t;){var r;1===t.opacity&&t.ancestor||(e.alpha*=t.opacity,r=(null==(r=t.ancestor)?void 0:r.descendants)||n,(r=(r=1!==t.opacity?r.slice(0,r.indexOf(t)):r).map(Gm)).length&&(r=r.reduce((function(e,t){return Sm(t.color,e.color instanceof $d?e.color:e)}),{color:new $d(0,0,0,0),blendMode:"normal"}),e=Sm(e,r))),t=t.ancestor}return e}(p,d,c),new $d(255,255,255,1)))}var tD=function(e,t,n,r){return e=Qm(e,t),{isValid:(t=r&&Math.ceil(72*n)/96<14||!r&&Math.ceil(72*n)/96<18?4.5:3)<e,contrastRatio:e,expectedContrastRatio:t}},nD=$r((function(e,n){function r(e,t){return a.getPropertyValue(e)===t}var a=t.getComputedStyle(e,n);return r("c\
ontent","none")||r("display","none")||r("visibility","hidden")||!1===r("position","absolute")||0===Ud(a).alpha&&r("background-image","none")?0:(e=rD(a.getPropertyValue("width")),n=rD(a.getPropertyValue("height")),"px"!==e.unit||"px"!==n.unit?0===e.value||0===n.value?0:1/0:e.value*n.value)}));function rD(e){var t=(e=H(e.match(/^([0-9.]+)([a-z]+)$/i)||[],3))[1];e=void 0===(e=e[2])?"":e;return{value:parseFloat(void 0===t?"":t),unit:e.toLowerCase()}}function aD(e,t){return e=e.getRelativeLuminance(),t=t.getRelativeLuminance(),(Math.max(e,t)+.05)/(Math.min(e,t)+.05)}var oD=["block","list-item","table","flex","grid","inline-block"];function iD(e){return e=t.getComputedStyle(e).getPropertyValue("display"),-1!==oD.indexOf(e)||"table-"===e.substr(0,6)}var uD=["block","list-item","table","flex","grid","inline-block"];function lD(e){return e=t.getComputedStyle(e).getPropertyValue("display"),-1!==uD.indexOf(e)||"table-"===e.substr(0,6)}function sD(e){return e=parseInt(e.attr("tabindex"),10),!isNaN\
(e)&&e<0}function cD(e,t){return t=dD(t),e=dD(e),!(!t||!e)&&t.includes(e)}function dD(e){return e=Cl(e,{emoji:!0,nonBmp:!0,punctuations:!0}),Eu(e)}function pD(e){return""!==(e||"").trim()}function fD(e,t){var n=1<arguments.length&&void 0!==t&&t;return e.map((function(e){return{vChild:e,nested:n}}))}function mD(e,t){return e=e.boundingClientRect,t=t.boundingClientRect,e.top>=t.top&&e.left>=t.left&&e.bottom<=t.bottom&&e.right<=t.right}function DD(e){return{width:Math.round(10*e.width)/10,height:Math.round(10*e.height)/10}}function hD(e,t){return e.actualNode.contains(t.actualNode)&&!Zi(t)}function gD(e){return e.map((function(e){return e.actualNode}))}function bD(e,t){var n=null==(n=t.data)?void 0:n.headingOrder,r=yD(t.node.ancestry,1);return n&&(t=n.map((function(e){return $({},e,{ancestry:r.concat(e.ancestry)})})),-1===(n=function(e,t){for(;t.length;){var n=vD(e,t);if(-1!==n)return n;t=yD(t,1)}return-1}(e,r))?e.push.apply(e,z(t)):e.splice.apply(e,[n,0].concat(z(t)))),e}function vD(e,t)\
{return e.findIndex((function(e){return ef(e.ancestry,t)}))}function yD(e,t){return e.slice(0,e.length-t)}te(Cc={},{aria:function(){return Wf},color:function(){return Am},dom:function(){return Ao},forms:function(){return FD},matches:function(){return Lu},math:function(){return li},standards:function(){return Fm},table:function(){return CD},text:function(){return eu},utils:function(){return yr}});var FD={},wD=(te(FD,{isAriaCombobox:function(){return al},isAriaListbox:function(){return rl},isAriaRange:function(){return il},isAriaTextbox:function(){return nl},isDisabled:function(){return ED},isNativeSelect:function(){return tl},isNativeTextbox:function(){return el}}),["fieldset","button","select","input","textarea"]),ED=function e(t){var n,r,a=t._isDisabled;return"boolean"!=typeof a&&(n=t.props.nodeName,r=t.attr("aria-disabled"),a=!(!wD.includes(n)||!t.hasAttr("disabled"))||(r?"true"===r.toLowerCase():!!t.parent&&e(t.parent)),t._isDisabled=a),a},CD={},xD=(te(CD,{getAllCells:function(){ret\
urn xD},getCellPosition:function(){return bu},getHeaders:function(){return kD},getScope:function(){return vu},isColumnHeader:function(){return yu},isDataCell:function(){return ND},isDataTable:function(){return BD},isHeader:function(){return TD},isRowHeader:function(){return Fu},toArray:function(){return gu},toGrid:function(){return gu},traverse:function(){return RD}}),function(e){for(var t,n,r=[],a=0,o=e.rows.length;a<o;a++)for(t=0,n=e.rows[a].cells.length;t<n;t++)r.push(e.rows[a].cells[t]);return r});function AD(e,t,n){for(var r,a="row"===e?"_rowHeaders":"_colHeaders",i="row"===e?Fu:yu,u=(s=n[t.y][t.x]).colSpan-1,l=s.getAttribute("rowspan"),s=(l=0===parseInt(l)||0===s.rowspan?n.length:s.rowSpan,t.y+(l-1)),c=t.x+u,d="row"===e?t.y:0,p="row"===e?0:t.x,f=[],m=s;d<=m&&!r;m--)for(var D=c;p<=D;D--){var h=n[m]?n[m][D]:void 0;if(h){var g=o.utils.getNodeFromTree(h);if(g[a]){r=g[a];break}f.push(h)}}return r=(r||[]).concat(f.filter(i)),f.forEach((function(e){o.utils.getNodeFromTree(e)[a]=r})),r}v\
ar kD=function(e,t){if(e.getAttribute("headers")){var n=tu(e,"headers");if(n.filter((function(e){return e})).length)return n}return t=t||gu(Ro(e,"table")),e=AD("row",n=bu(e,t),t),n=AD("col",n,t),[].concat(e,n).reverse()},ND=function(e){var t;return!(!e.children.length&&!e.textContent.trim())&&(t=e.getAttribute("role"),fu(t)?["cell","gridcell"].includes(t):"TD"===e.nodeName.toUpperCase())},BD=function(e){var n=(e.getAttribute("role")||"").toLowerCase();if(("presentation"===n||"none"===n)&&!Xi(e))return!1;if("true"===e.getAttribute("contenteditable")||Ro(e,'[contenteditable="true"]'))return!0;if("grid"===n||"treegrid"===n||"table"===n)return!0;if("landmark"===Yl(n))return!0;if("0"===e.getAttribute("datatable"))return!1;if(e.getAttribute("summary"))return!0;if(e.tHead||e.tFoot||e.caption)return!0;for(var r=0,a=e.children.length;r<a;r++)if("COLGROUP"===e.children[r].nodeName.toUpperCase())return!0;for(var o,i,u,l=0,s=e.rows.length,c=!1,d=0;d<s;d++)for(var p,f=0,m=(p=e.rows[d]).cells.length\
;f<m;f++){if("TH"===(o=p.cells[f]).nodeName.toUpperCase())return!0;if(c||o.offsetWidth===o.clientWidth&&o.offsetHeight===o.clientHeight||(c=!0),o.getAttribute("scope")||o.getAttribute("headers")||o.getAttribute("abbr"))return!0;if(["columnheader","rowheader"].includes((o.getAttribute("role")||"").toLowerCase()))return!0;if(1===o.children.length&&"ABBR"===o.children[0].nodeName.toUpperCase())return!0;l++}if(e.getElementsByTagName("table").length)return!1;if(s<2)return!1;if(1===(n=e.rows[Math.ceil(s/2)]).cells.length&&1===n.cells[0].colSpan)return!1;if(5<=n.cells.length)return!0;if(c)return!0;for(d=0;d<s;d++){if(p=e.rows[d],i&&i!==t.getComputedStyle(p).getPropertyValue("background-color"))return!0;if(i=t.getComputedStyle(p).getPropertyValue("background-color"),u&&u!==t.getComputedStyle(p).getPropertyValue("background-image"))return!0;u=t.getComputedStyle(p).getPropertyValue("background-image")}return 20<=s||!(ei(e).width>.95*ti(t).width||l<10||e.querySelector("object, embed, iframe, appl\
et"))},TD=function(e){return!(!yu(e)&&!Fu(e))||!!e.getAttribute("id")&&(e=Mr(e.getAttribute("id")),!!r.querySelector('[headers~="'.concat(e,'"]')))},RD=function(e,t,n,r){if(Array.isArray(t)&&(r=n,n=t,t={x:0,y:0}),"string"==typeof e)switch(e){case"left":e={x:-1,y:0};break;case"up":e={x:0,y:-1};break;case"right":e={x:1,y:0};break;case"down":e={x:0,y:1}}return function e(t,n,r,a){var o,i=r[n.y]?r[n.y][n.x]:void 0;return i?"function"==typeof a&&!0===(o=a(i,n,r))?[i]:((o=e(t,{x:n.x+t.x,y:n.y+t.y},r,a)).unshift(i),o):[]}(e,{x:t.x+e.x,y:t.y+e.y},n,r)};var _D=/[;,\\s]/,OD=/^[0-9.]+$/;function SD(e){return e=t.getComputedStyle(function(e){for(var t=e,n=e.textContent.trim(),r=n;r===n&&void 0!==t;){var a=-1;if(0===(e=t).children.length)return e;for(;a++,""===(r=e.children[a].textContent.trim())&&a+1<e.children.length;);t=e.children[a]}return e}(e)),{fontWeight:function(e){switch(e){case"lighter":return 100;case"normal":return 400;case"bold":return 700;case"bolder":return 900}return e=parseInt(e),i\
sNaN(e)?400:e}(e.getPropertyValue("font-weight")),fontSize:parseInt(e.getPropertyValue("font-size")),isItalic:"italic"===e.getPropertyValue("font-style")}}function MD(e,t,n){return n.reduce((function(n,r){return n||(!r.size||e.fontSize/r.size>t.fontSize)&&(!r.weight||e.fontWeight-r.weight>t.fontWeight)&&(!r.italic||e.isItalic&&!t.isItalic)}),!1)}var PD=["alert","log","status"];function ID(e){return"caption"===e.props.nodeName}Wt=ai;var jD=function(e,t,n){return n.initiator};var LD={emoji:!0,nonBmp:!1,punctuations:!0};var qD=function(e,t){try{return"svg"===t.props.nodeName||!!xa(t,"svg")}catch(e){return!1}};var zD=["article","aside","main","nav","section"].join(",");var VD=function(e,t){var n=mu(t);return!(n&&!["none","presentation"].includes(n)&&!(iu[n]||{}).accessibleNameRequired&&!Xi(t))};var $D=[function(e,t){return HD(t)},function(e,t){return"area"!==t.props.nodeName},function(e,t){return!qD(0,t)},function(e,t){return Xi(t)},function(e,t){return Zi(t)||!UD(t)},function(e){return!Zl\
(e,{noLengthCompare:!0})}];function HD(e){return"widget"===Yl(e)}var UD=$r((function e(t){return!(null==t||!t.parent)&&(!(!HD(t.parent)||!Zi(t.parent))||e(t.parent))})),GD={"abstractrole-evaluate":function(e,t,n){return 0<(n=sp(n.attr("role")).filter((function(e){return"abstract"===Yl(e)}))).length&&(this.data(n),!0)},"accesskeys-after":function(e){var t={};return e.filter((function(e){if(e.data){var n=e.data.toUpperCase();if(!t[n])return(t[n]=e).relatedNodes=[],!0;t[n].relatedNodes.push(e.relatedNodes[0])}return!1})).map((function(e){return e.result=!!e.relatedNodes.length,e}))},"accesskeys-evaluate":function(e,t,n){return Ko(n)||(this.data(n.attr("accesskey")),this.relatedNodes([e])),!0},"alt-space-value-evaluate":function(e,t,n){return"string"==typeof(n=n.attr("alt"))&&/^\\s+$/.test(n)},"aria-allowed-attr-evaluate":function(e,t,n){var r,a=[],o=Hu(n),i=Yf(o),u=(Array.isArray(t[o])&&(i=pf(t[o].concat(i))),Z(n.attrNames));try{for(u.s();!(r=u.n()).done;){var l=r.value;gm(l)&&!i.includes(\
l)&&a.push(l)}}catch(e){u.e(e)}finally{u.f()}return!a.length||(this.data(a.map((function(e){return e+'="'+n.attr(e)+'"'}))),!(o||Zp(n)||Xi(n))&&void 0)},"aria-allowed-attr-matches":function(e,t){var n=/^aria-/,r=t.attrNames;if(r.length)for(var a=0,o=r.length;a<o;a++)if(n.test(r[a]))return!0;return!1},"aria-allowed-role-evaluate":function(e){var t=2<arguments.length?arguments[2]:void 0,n=void 0===(n=(r=1<arguments.length&&void 0!==arguments[1]?arguments[1]:{}).allowImplicit)||n,r=void 0===(r=r.ignoredTags)?[]:r,a=t.props.nodeName;return!!r.map((function(e){return e.toLowerCase()})).includes(a)||!(r=em(t,n)).length||(this.data(r),!Xu(t)&&void 0)},"aria-allowed-role-matches":function(e,t){return null!==mu(t,{dpub:!0,fallback:!0})},"aria-busy-evaluate":function(e,t,n){return"true"===n.attr("aria-busy")},"aria-conditional-attr-evaluate":function(e,t,n){var r=Hu(n);return!ym[r]||ym[r].call(this,e,t,n)},"aria-conditional-checkbox-attr-evaluate":bm,"aria-conditional-row-attr-evaluate":vm,"aria\
-errormessage-evaluate":function(e,t,n){t=Array.isArray(t)?t:[];var r=n.attr("aria-errormessage"),a=n.hasAttr("aria-errormessage"),o=n.attr("aria-invalid");return!n.hasAttr("aria-invalid")||"false"===o||-1!==t.indexOf(r)||!a||(this.data(sp(r)),function(e){if(""===e.trim())return du.ariaAttrs["aria-errormessage"].allowEmpty;var t;try{t=e&&tu(n,"aria-errormessage")[0]}catch(t){return void this.data({messageKey:"idrefs",values:sp(e)})}return t?Xu(t)?"alert"===t.getAttribute("role")||"assertive"===t.getAttribute("aria-live")||"polite"===t.getAttribute("aria-live")||-1<sp(n.attr("aria-describedby")).indexOf(e):(this.data({messageKey:"hidden",values:sp(e)}),!1):void 0}.call(this,r))},"aria-has-attr-matches":function(e,t){var n=/^aria-/;return t.attrNames.some((function(e){return n.test(e)}))},"aria-hidden-body-evaluate":function(e,t,n){return"true"!==n.attr("aria-hidden")},"aria-hidden-focus-matches":function(e){return function e(t){return!t||"true"!==t.getAttribute("aria-hidden")&&e(Jo(t))}\
(Jo(e))},"aria-label-evaluate":function(e,t,n){return!!Eu(au(n))},"aria-labelledby-evaluate":function(e,t,n){try{return!!Eu(ru(n))}catch(e){}},"aria-level-evaluate":function(e,t,n){if(n=n.attr("aria-level"),!(6<(n=parseInt(n,10))))return!0},"aria-prohibited-attr-evaluate":function(e){var t,n=2<arguments.length?arguments[2]:void 0,r=(null==(r=1<arguments.length&&void 0!==arguments[1]?arguments[1]:{})?void 0:r.elementsAllowedAriaLabel)||[],a=n.props.nodeName,o=Hu(n,{chromium:!0});return 0!==(r=function(e,t,n){var r=du.ariaRoles[e];return r?r.prohibitedAttrs||[]:e||n.includes(t)?[]:["aria-label","aria-labelledby"]}(o,a,r).filter((function(e){return!!n.attrNames.includes(e)&&""!==Eu(n.attr(e))}))).length&&(t=n.hasAttr("role")?"hasRole":"noRole",t+=1<r.length?"Plural":"Singular",this.data({role:o,nodeName:a,messageKey:t,prohibited:r}),o=pl(n,{subtreeDescendant:!0}),""===Eu(o)||void 0)},"aria-required-attr-evaluate":function(e){var t,n=1<arguments.length&&void 0!==arguments[1]?arguments[1]:{\
},r=2<arguments.length?arguments[2]:void 0,a=mu(r),o=r.attrNames,i=fm(a);return Array.isArray(n[a])&&(i=pf(n[a],i)),!(a&&o.length&&i.length&&(n=r,"separator"!==a||Xi(n))&&(o=r,"combobox"!==a||"false"!==o.attr("aria-expanded"))&&(t=qu(r),(n=i.filter((function(e){return!(r.attr(e)||void 0!==(null==(n=(n=t).implicitAttrs)?void 0:n[e]));var n}))).length&&(this.data(n),1)))},"aria-required-children-evaluate":function(e,t,n){t=t&&Array.isArray(t.reviewEmpty)?t.reviewEmpty:[];var r,a,o=mu(n,{dpub:!0}),i=Dm(o);return null===i||((r=(n=function(e,t){function n(){if(3===r.props.nodeType&&a.push({vNode:r,role:null}),1!==r.props.nodeType||!Xu(r))return"continue";var e,n=Hu(r,{noPresentational:!0}),i=(e=r,hu().find((function(t){return e.hasAttr(t)}))),u=!!i||Xi(r);!n&&!u||["group","rowgroup"].includes(n)&&t.some((function(e){return e===n}))?o.push.apply(o,z(r.children)):(n||u)&&a.push({role:n,attr:i||"tabindex",vNode:r})}for(var r,a=[],o=Yu(e);r=o.shift();)n();return a}(n,i)).filter((function(e){var\
 t=e.role;return 1===e.vNode.props.nodeType&&!i.includes(t)}))).length?(this.relatedNodes(r.map((function(e){return e.vNode}))),this.data({messageKey:"unallowed",values:r.map((function(e){var t=e.vNode,n=(e=e.attr,t.props),r=n.nodeName;return 3===n.nodeType?"#text":(n=mu(t,{dpub:!0}))?"[role=".concat(n,"]"):e?r+"[".concat(e,"]"):r})).filter((function(e,t,n){return n.indexOf(e)===t})).join(", ")}),!1):(a=i,!!n.some((function(e){return(e=e.role)&&a.includes(e)}))||(this.data(i),!(!t.includes(o)||n.some(wm))&&void 0)))},"aria-required-children-matches":function(e,t){return t=mu(t,{dpub:!0}),!!Dm(t)},"aria-required-parent-evaluate":function(e,t,n){var r=t&&Array.isArray(t.ownGroupRoles)?t.ownGroupRoles:[],a=Em(n,r);if(!a)return!0;var o=function(e){for(var t,n=[];e;)e.getAttribute("id")&&(t=Mr(e.getAttribute("id")),t=No(e).querySelector("[aria-owns~=".concat(t,"]")))&&n.push(t),e=e.parentElement;return n.length?n:null}(e);if(o)for(var i=0,u=o.length;i<u;i++)if(!(a=Em(ca(o[i]),r,a,!0)))retur\
n!0;return this.data(a),!1},"aria-required-parent-matches":function(e,t){return t=mu(t),!!mm(t)},"aria-roledescription-evaluate":function(e){var t=1<arguments.length&&void 0!==arguments[1]?arguments[1]:{},n=Hu(2<arguments.length?arguments[2]:void 0);return!!(t.supportedRoles||[]).includes(n)||!(!n||"presentation"===n||"none"===n)&&void 0},"aria-unsupported-attr-evaluate":function(e,t,n){return!!(n=n.attrNames.filter((function(t){var n=du.ariaAttrs[t];return!!gm(t)&&(t=n.unsupported,"object"!==a(t)?!!t:!Lu(e,t.exceptions))}))).length&&(this.data(n),!0)},"aria-valid-attr-evaluate":function(e,t,n){t=Array.isArray(t.value)?t.value:[];var r=[],a=/^aria-/;return n.attrNames.forEach((function(e){-1===t.indexOf(e)&&a.test(e)&&!gm(e)&&r.push(e)})),!r.length||(this.data(r),!1)},"aria-valid-attr-value-evaluate":function(e,t,n){t=Array.isArray(t.value)?t.value:[];var r="",a="",i=[],u=/^aria-/,l=["aria-errormessage"],s={"aria-controls":function(){return"false"!==n.attr("aria-expanded")&&"false"!==n\
.attr("aria-selected")},"aria-current":function(e){e||(r='aria-current="'.concat(n.attr("aria-current"),'"'),a="ariaCurrent")},"aria-owns":function(){return"false"!==n.attr("aria-expanded")},"aria-describedby":function(e){e||(r='aria-describedby="'.concat(n.attr("aria-describedby"),'"'),a=o._tree&&o._tree[0]._hasShadowRoot?"noIdShadow":"noId")},"aria-labelledby":function(e){e||(r='aria-labelledby="'.concat(n.attr("aria-labelledby"),'"'),a=o._tree&&o._tree[0]._hasShadowRoot?"noIdShadow":"noId")}};return n.attrNames.forEach((function(e){if(!l.includes(e)&&!t.includes(e)&&u.test(e)){var o,c=n.attr(e);try{o=hm(n,e)}catch(o){return r="".concat(e,'="').concat(c,'"'),void(a="idrefs")}s[e]&&!s[e](o)||o||(""===c&&(o=e,"string"!==(null==(o=du.ariaAttrs[e])?void 0:o.type))?(r=e,a="empty"):i.push("".concat(e,'="').concat(c,'"')))}})),i.length?(this.data(i),!1):!r||void this.data({messageKey:a,needsReview:r})},"attr-non-space-content-evaluate":function(e){var t=1<arguments.length&&void 0!==argument\
s[1]?arguments[1]:{},n=2<arguments.length?arguments[2]:void 0;if(t.attribute&&"string"==typeof t.attribute)return n.hasAttr(t.attribute)?(n=n.attr(t.attribute),!!Eu(n)||(this.data({messageKey:"emptyAttr"}),!1)):(this.data({messageKey:"noAttr"}),!1);throw new TypeError("attr-non-space-content requires options.attribute to be a string")},"autocomplete-appropriate-evaluate":function(e,t,n){var r,o,i;return"input"!==n.props.nodeName||(o={bday:["text","search","date"],email:["text","search","email"],username:["text","search","email"],"street-address":["text"],tel:["text","search","tel"],"tel-country-code":["text","search","tel"],"tel-national":["text","search","tel"],"tel-area-code":["text","search","tel"],"tel-local":["text","search","tel"],"tel-local-prefix":["text","search","tel"],"tel-local-suffix":["text","search","tel"],"tel-extension":["text","search","tel"],"cc-number":r=["text","search","number","tel"],"cc-exp":["text","search","month","tel"],"cc-exp-month":r,"cc-exp-year":r,"cc-cs\
c":r,"transaction-amount":r,"bday-day":r,"bday-month":r,"bday-year":r,"new-password":["text","search","password"],"current-password":["text","search","password"],url:i=["text","search","url"],photo:i,impp:i},"object"===a(t)&&Object.keys(t).forEach((function(e){o[e]||(o[e]=[]),o[e]=o[e].concat(t[e])})),i=(r=n.attr("autocomplete").split(/\\s+/g).map((function(e){return e.toLowerCase()})))[r.length-1],!!Al.stateTerms.includes(i))||(r=o[i],i=n.hasAttr("type")?Eu(n.attr("type")).toLowerCase():"text",i=Of().includes(i)?i:"text",void 0===r?"text"===i:r.includes(i))},"autocomplete-matches":function(e,t){if(!(n=t.attr("autocomplete"))||""===Eu(n))return!1;if(n=t.props.nodeName,!1===["textarea","input","select"].includes(n))return!1;if("input"===n&&["submit","reset","button","hidden"].includes(t.props.type))return!1;if(n=t.attr("aria-disabled")||"false",t.hasAttr("disabled")||"true"===n.toLowerCase())return!1;var n=t.attr("role"),r=t.attr("tabindex");return("-1"!==r||!n||void 0!==(n=du.ariaRoles[\
n])&&"widget"===n.type)&&!("-1"===r&&t.actualNode&&!ai(t)&&!Xu(t))},"autocomplete-valid-evaluate":function(e,t,n){return n=n.attr("autocomplete")||"",kl(n,t)},"avoid-inline-spacing-evaluate":function(e,t){return!(0<(t=t.cssProperties.filter((function(t){if("important"===e.style.getPropertyPriority(t))return t}))).length&&(this.data(t),1))},"braille-label-equivalent-evaluate":function(e,t,n){var r;if(!(null!=(r=n.attr("aria-braillelabel"))?r:"").trim())return!0;try{return""!==Eu(wl(n))}catch(e){}},"braille-roledescription-equivalent-evaluate":function(e,t,n){var r=null!=(r=n.attr("aria-brailleroledescription"))?r:"";return""===Eu(r)||("string"!=typeof(r=n.attr("aria-roledescription"))?(this.data({messageKey:"noRoleDescription"}),!1):""!==Eu(r)||(this.data({messageKey:"emptyRoleDescription"}),!1))},"bypass-matches":function(e,t,n){return!jD(0,0,n)||!!e.querySelector("a[href]")},"caption-evaluate":function(e,t,n){return!Cf(n,"track").some((function(e){return"captions"===(e.attr("kind")||"\
").toLowerCase()}))&&void 0},"caption-faked-evaluate":function(e){var t=gu(e),n=t[0];return t.length<=1||n.length<=1||e.rows.length<=1||n.reduce((function(e,t,r){return e||t!==n[r+1]&&void 0!==n[r+1]}),!1)},"color-contrast-evaluate":function(e,n,r){var a=n.ignoreUnicode,o=n.ignoreLength,i=n.ignorePseudo,u=n.boldValue,l=n.boldTextPt,s=n.largeTextPt,c=n.contrastRatio,d=n.shadowOutlineEmMax,p=n.pseudoSizeThreshold;if(!ai(e))return this.data({messageKey:"hidden"}),!0;var f=Ju(r,!1,!0);if(a&&(D=yl(a=f,m={nonBmp:!0}),a=""===Eu(Cl(a,m)),D)&&a)this.data({messageKey:"nonBmp"});else{var m=t.getComputedStyle(e),D=parseFloat(m.getPropertyValue("font-size"));a=m.getPropertyValue("font-weight"),u=parseFloat(a)>=u||"bold"===a,a=Math.ceil(72*D)/96,a=(l=u&&a<l||!u&&a<s?c.normal:c.large).expected,s=l.minThreshold,c=l.maxThreshold,l=function(e,t){var n=void 0===(n=t.pseudoSizeThreshold)?.25:n;if(!(t=void 0!==(t=t.ignorePseudo)&&t)){var r=(t=e.boundingClientRect).width*t.height*n;do{if(r<nD(e.actualNode,"\
:before")+nD(e.actualNode,":after"))return e}while(e=e.parent)}}(r,{ignorePseudo:i,pseudoSizeThreshold:p});if(l)this.data({fontSize:"".concat((72*D/96).toFixed(1),"pt (").concat(D,"px)"),fontWeight:u?"bold":"normal",messageKey:"pseudoContent",expectedContrastRatio:a+":1"}),this.relatedNodes(l.actualNode);else{var h,g,b;if(null!==(r=Hm(e,{minRatio:.001,maxRatio:d})))return l=eD(e,!(i=[]),p=Xm(e,i,d),n),n=d=e=null,0===r.length?e=Qm(p,l):l&&p&&(n=[].concat(z(r),[p]).reduce(Mm),r=Qm(p,l),b=Qm(p,n),h=Qm(n,l),(e=Math.max(r,b,h))!==r)&&(d=h<b?"shadowOnBgColor":"fgOnShadowColor"),r=a<e,"number"==typeof s&&("number"!=typeof e||e<s)||"number"==typeof c&&("number"!=typeof e||c<e)?(this.data({contrastRatio:e}),!0):(h=Math.floor(100*e)/100,null===p?g=as.get("bgColor"):r||(g=d),b=1===f.length,(s=1==h)?g=as.set("bgColor","equalRatio"):r||!b||o||(g="shortTextContent"),this.data({fgColor:l?l.toHexString():void 0,bgColor:p?p.toHexString():void 0,contrastRatio:h,fontSize:"".concat((72*D/96).toFixed(1),"p\
t (").concat(D,"px)"),fontWeight:u?"bold":"normal",messageKey:g,expectedContrastRatio:a+":1",shadowColor:n?n.toHexString():void 0}),null===l||null===p||s||b&&!o&&!r?(g=null,as.clear(),void this.relatedNodes(i)):(r||this.relatedNodes(i),r));this.data({messageKey:"complexTextShadows"})}}},"color-contrast-matches":function(e,n){var a=(o=n.props).nodeName,o=o.type;if("option"!==a&&("select"!==a||e.options.length)&&!("input"===a&&["hidden","range","color","checkbox","radio","image"].includes(o)||ED(n)||Mi(n))){if(["input","select","textarea"].includes(a)){if(o=t.getComputedStyle(e),o=parseInt(o.getPropertyValue("text-indent"),10)){var i={top:(i=e.getBoundingClientRect()).top,bottom:i.bottom,left:i.left+o,right:i.right+o};if(!ap(i,e))return!1}return!0}if(o=To(n,"label"),"label"===a||o){if(i=o||e,a=o?ca(o):n,i.htmlFor&&(i=(o=No(i).getElementById(i.htmlFor))&&ca(o))&&ED(i))return!1;if((o=Cf(a,'input:not([type="hidden"],[type="image"],[type="button"],[type="submit"],[type="reset"]), select, tex\
tarea')[0])&&ED(o))return!1}for(var u,l=[],s=n;s;)s.props.id&&(u=Xf(s).filter((function(e){return sp(e.getAttribute("aria-labelledby")||"").includes(s.props.id)})).map((function(e){return ca(e)})),l.push.apply(l,z(u))),s=s.parent;if(!(0<l.length&&l.every(ED))&&""!==(a=Ju(i=n,!1,!0))&&""!==Cl(a,LD)&&i.children.some((function(e){return"#text"===e.props.nodeName&&!Fl(e)}))){for(var c=r.createRange(),d=n.children,p=0;p<d.length;p++){var f=d[p];3===f.actualNode.nodeType&&""!==Eu(f.actualNode.nodeValue)&&c.selectNodeContents(f.actualNode)}for(var m=c.getClientRects(),D=0;D<m.length;D++)if(ap(m[D],e))return!0}}return!1},"css-orientation-lock-evaluate":function(e,t,n,r){r=void 0===(r=(r||{}).cssom)?void 0:r;var a=void 0===(t=(t||{}).degreeThreshold)?0:t;if(r&&r.length){function o(){var e=c[s],t=(e=l[e]).root;if(!(e=e.rules.filter(d)).length)return"continue";e.forEach((function(e){e=e.cssRules,Array.from(e).forEach((function(e){var n=function(e){var t=e.selectorText;e=e.style;return!(!t||e.leng\
th<=0)&&(!(!(t=e.transform||e.webkitTransform||e.msTransform||!1)&&!e.rotate)&&(t=function(e){return e&&(e=e.match(/(rotate|rotateZ|rotate3d|matrix|matrix3d)\\(([^)]+)\\)(?!.*(rotate|rotateZ|rotate3d|matrix|matrix3d))/))?p((e=H(e,3))[1],e=e[2]):0}(t),!!(t+=e=p("rotate",e.rotate))&&(t=Math.abs(t),!(Math.abs(t-180)%180<=a)&&Math.abs(t-90)%90<=a)))}(e);n&&"HTML"!==e.selectorText.toUpperCase()&&(e=Array.from(t.querySelectorAll(e.selectorText))||[],u=u.concat(e)),i=i||n}))}))}for(var i=!1,u=[],l=r.reduce((function(e,t){var n=t.sheet,r=t.root;return e[t=(t=t.shadowId)||"topDocument"]||(e[t]={root:r,rules:[]}),n&&n.cssRules&&(r=Array.from(n.cssRules),e[t].rules=e[t].rules.concat(r)),e}),{}),s=0,c=Object.keys(l);s<c.length;s++)o();return!i||(u.length&&this.relatedNodes(u),!1)}function d(e){var t=e.type;e=e.cssText;return 4===t&&(/orientation:\\s*landscape/i.test(e)||/orientation:\\s*portrait/i.test(e))}function p(e,t){switch(e){case"rotate":case"rotateZ":return f(t);case"rotate3d":var n=H(t.split(\
",").map((function(e){return e.trim()})),4),r=n[2];n=n[3];return 0===parseInt(r)?void 0:f(n);case"matrix":case"matrix3d":var a,o;return(r=(r=t).split(",")).length<=6?(a=(o=H(r,2))[0],o=o[1],m(Math.atan2(parseFloat(o),parseFloat(a)))):(o=parseFloat(r[8]),a=Math.asin(o),o=Math.cos(a),m(Math.acos(parseFloat(r[0])/o)));default:return 0}}function f(e){var t=H(e.match(/(deg|grad|rad|turn)/)||[],1)[0];if(!t)return 0;var n=parseFloat(e.replace(t,""));switch(t){case"rad":return m(n);case"grad":var r=n;return(r%=400)<0&&(r+=400),Math.round(r/400*360);case"turn":return Math.round(360/(1/n));default:return parseInt(n)}}function m(e){return Math.round(e*(180/Math.PI))}},"data-table-large-matches":function(e){return!!BD(e)&&3<=(e=gu(e)).length&&3<=e[0].length&&3<=e[1].length&&3<=e[2].length},"data-table-matches":function(e){return BD(e)},"deprecatedrole-evaluate":function(e,t,n){n=Hu(n,{dpub:!0,fallback:!0});var r=du.ariaRoles[n];return!(null==r||!r.deprecated||(this.data(n),0))},"dlitem-evaluate":f\
unction(e){var t=(e=Jo(e)).nodeName.toUpperCase(),n=mu(e);return"DIV"===t&&["presentation","none",null].includes(n)&&(t=(e=Jo(e)).nodeName.toUpperCase(),n=mu(e)),"DL"===t&&!(n&&!["presentation","none","list"].includes(n))},"doc-has-title-evaluate":function(){var e=r.title;return!!Eu(e)},"duplicate-id-active-matches":function(e){var t=e.getAttribute("id").trim();return t='*[id="'.concat(Mr(t),'"]'),t=Array.from(No(e).querySelectorAll(t)),!sm(e)&&t.some(Xi)},"duplicate-id-after":function(e){var t=[];return e.filter((function(e){return-1===t.indexOf(e.data)&&(t.push(e.data),!0)}))},"duplicate-id-aria-matches":function(e){return sm(e)},"duplicate-id-evaluate":function(e){var t,n=e.getAttribute("id").trim();return!n||(t=No(e),(t=Array.from(t.querySelectorAll('[id="'.concat(Mr(n),'"]'))).filter((function(t){return t!==e}))).length&&this.relatedNodes(t),this.data(n),0===t.length)},"duplicate-id-misc-matches":function(e){var t=e.getAttribute("id").trim();return t='*[id="'.concat(Mr(t),'"]'),t=\
Array.from(No(e).querySelectorAll(t)),!sm(e)&&t.every((function(e){return!Xi(e)}))},"duplicate-img-label-evaluate":function(e,t,n){return!["none","presentation"].includes(Hu(n))&&!!(t=xa(n,t.parentSelector))&&""!==(t=Ju(t,!0).toLowerCase())&&t===wl(n).toLowerCase()},"exists-evaluate":function(){},"explicit-evaluate":function(e,t,n){var r=this;if(!n.attr("id"))return!1;if(n.actualNode){var a=No(n.actualNode),o=Mr(n.attr("id"));a=Array.from(a.querySelectorAll('label[for="'.concat(o,'"]')));if(this.relatedNodes(a),!a.length)return!1;try{return a.some((function(e){return!ai(e)||(e=Eu(nu(e,{inControlContext:!0,startNode:n})),r.data({explicitLabel:e}),!!e)}))}catch(e){}}},"fallbackrole-evaluate":function(e,t,n){var r=sp(n.attr("role"));return!(r.length<=1)&&(!(!zu(n)&&2===r.length&&r.includes("none")&&r.includes("presentation"))||void 0)},"focusable-content-evaluate":function(e,t,n){var r=n.tabbableElements;return!!r&&0<r.filter((function(e){return e!==n})).length},"focusable-disabled-evalua\
te":function(e,t,n){var r=["button","fieldset","input","select","textarea"];return!((n=n.tabbableElements)&&n.length&&(n=n.filter((function(e){return r.includes(e.props.nodeName)})),this.relatedNodes(n.map((function(e){return e.actualNode}))),0!==n.length)&&!Jl())||!!n.every((function(e){var t=e.getComputedStylePropertyValue("pointer-events"),n=parseInt(e.getComputedStylePropertyValue("width")),r=parseInt(e.getComputedStylePropertyValue("height"));return e.actualNode.onfocus||(0===n||0===r)&&"none"===t}))&&void 0},"focusable-element-evaluate":function(e,t,n){return!(!n.hasAttr("contenteditable")||!function e(t){return"true"===(t=t.attr("contenteditable"))||""===t||"false"!==t&&(!!(t=xa(n.parent,"[contenteditable]"))&&e(t))}(n))||Zi(n)},"focusable-modal-open-evaluate":function(e,t,n){return!(n=n.tabbableElements.map((function(e){return e.actualNode})))||!n.length||!Jl()||void this.relatedNodes(n)},"focusable-no-name-evaluate":function(e,t,n){var r=n.attr("tabindex");if(!(Xi(n)&&-1<r))re\
turn!1;try{return!wl(n)}catch(e){}},"focusable-not-tabbable-evaluate":function(e,t,n){var r=["button","fieldset","input","select","textarea"];return!((n=n.tabbableElements)&&n.length&&(n=n.filter((function(e){return!r.includes(e.props.nodeName)})),this.relatedNodes(n.map((function(e){return e.actualNode}))),0!==n.length)&&!Jl())||!!n.every((function(e){var t=e.getComputedStylePropertyValue("pointer-events"),n=parseInt(e.getComputedStylePropertyValue("width")),r=parseInt(e.getComputedStylePropertyValue("height"));return e.actualNode.onfocus||(0===n||0===r)&&"none"===t}))&&void 0},"frame-focusable-content-evaluate":function(e,t,n){if(n.children)try{return!n.children.some((function e(t){if(Zi(t))return!0;if(!t.children){if(1===t.props.nodeType)throw new Error("Cannot determine children");return!1}return t.children.some((function(t){return e(t)}))}))}catch(e){}},"frame-focusable-content-matches":function(e,t,n){var r;return!n.initiator&&!n.focusable&&1<(null==(r=n.size)?void 0:r.width)*(nu\
ll==(r=n.size)?void 0:r.height)},"frame-tested-after":function(e){var t={};return e.filter((function(e){var n;return"html"!==e.node.ancestry[e.node.ancestry.length-1]?(n=e.node.ancestry.flat(1/0).join(" > "),t[n]=e,!0):(n=e.node.ancestry.slice(0,e.node.ancestry.length-1).flat(1/0).join(" > "),t[n]&&(t[n].result=!0),!1)}))},"frame-tested-evaluate":function(e,t){return!t.isViolation&&void 0},"frame-title-has-text-matches":function(e){return e=e.getAttribute("title"),!!Eu(e)},"has-alt-evaluate":function(e,t,n){var r=n.props.nodeName;return!!["img","input","area"].includes(r)&&n.hasAttr("alt")},"has-descendant-after":function(e){return e.some((function(e){return!0===e.result}))&&e.forEach((function(e){e.result=!0})),e},"has-descendant-evaluate":function(e,t,n){if(t&&t.selector&&"string"==typeof t.selector)return!(!t.passForModal||!Jl())||(n=mf(n,t.selector,Xu),this.relatedNodes(n.map((function(e){return e.actualNode}))),0<n.length);throw new TypeError("has-descendant requires options.selec\
tor to be a string")},"has-global-aria-attribute-evaluate":function(e,t,n){var r=hu().filter((function(e){return n.hasAttr(e)}));return this.data(r),0<r.length},"has-implicit-chromium-role-matches":function(e,t){return null!==zu(t,{chromium:!0})},"has-lang-evaluate":function(e,t,n){var a=void 0!==r&&Hr(r);return t.attributes.includes("xml:lang")&&t.attributes.includes("lang")&&pD(n.attr("xml:lang"))&&!pD(n.attr("lang"))&&!a?(this.data({messageKey:"noXHTML"}),!1):!!t.attributes.some((function(e){return pD(n.attr(e))}))||(this.data({messageKey:"noLang"}),!1)},"has-text-content-evaluate":function(e,t,n){try{return""!==Eu(pl(n))}catch(e){}},"has-widget-role-evaluate":function(e){return null!==(e=e.getAttribute("role"))&&("widget"===(e=Yl(e))||"composite"===e)},"heading-matches":function(e,t){return"heading"===Hu(t)},"heading-order-after":function(e){(t=z(t=e)).sort((function(e,t){return e=e.node,t=t.node,e.ancestry.length-t.ancestry.length}));var t,n=t.reduce(bD,[]).filter((function(e){ret\
urn-1!==e.level}));return e.forEach((function(e){e.result=function(e,t){var n=null!=(n=null==(n=t[e=vD(t,e.node.ancestry)])?void 0:n.level)?n:-1;t=null!=(t=null==(t=t[e-1])?void 0:t.level)?t:-1;return 0===e||(-1!==n?n-t<=1:void 0)}(e,n)})),e},"heading-order-evaluate":function(){var e,t=sa.get("headingOrder");return t||(t=(e=mf(o._tree[0],"h1, h2, h3, h4, h5, h6, [role=heading], iframe, frame",Xu)).map((function(e){return{ancestry:[ia(e.actualNode)],level:(t=(t=Hu(e))&&t.includes("heading"),n=e.attr("aria-level"),r=parseInt(n,10),e=H(e.props.nodeName.match(/h(\\d)/)||[],2)[1],t?e&&!n?parseInt(e,10):isNaN(r)||r<1?e?parseInt(e,10):2:r||-1:-1)};var t,n,r})),this.data({headingOrder:t}),sa.set("headingOrder",e)),!0},"help-same-as-label-evaluate":function(e,t,n){n=Tl(n);var r=e.getAttribute("title");return!!n&&(r||(r="",e.getAttribute("aria-describedby")&&(r=tu(e,"aria-describedby").map((function(e){return e?nu(e):""})).join(""))),Eu(r)===Eu(n))},"hidden-content-evaluate":function(e,n,r){if(![\
"SCRIPT","HEAD","TITLE","NOSCRIPT","STYLE","TEMPLATE"].includes(e.nodeName.toUpperCase())&&ql(r)){if("none"===(r=t.getComputedStyle(e)).getPropertyValue("display"))return;if("hidden"===r.getPropertyValue("visibility")&&(!(e=(r=Jo(e))&&t.getComputedStyle(r))||"hidden"!==e.getPropertyValue("visibility")))return}return!0},"hidden-explicit-label-evaluate":function(e,t,n){if(n.hasAttr("id")){if(!n.actualNode)return;var r,a=No(e);e=Mr(e.getAttribute("id"));if((a=a.querySelector('label[for="'.concat(e,'"]')))&&!Xu(a)){try{r=wl(n).trim()}catch(e){return}return""===r}}return!1},"html-namespace-matches":function(e,t){return!qD(0,t)},"html5-scope-evaluate":function(e){return!Wl(r)||"TH"===e.nodeName.toUpperCase()},"identical-links-same-purpose-after":function(e){if(e.length<2)return e;function t(e){var t=n[e],i=t.data,u=i.name,l=i.urlProps;if(o[u])return"continue";var s=(i=n.filter((function(t,n){return t.data.name===u&&n!==e}))).every((function(e){return function e(t,n){var r,o;return!(!t||!n)&&\
(r=Object.getOwnPropertyNames(t),o=Object.getOwnPropertyNames(n),r.length===o.length)&&r.every((function(r){var o=t[r];r=n[r];return a(o)===a(r)&&("object"===a(o)||"object"===a(r)?e(o,r):o===r)}))}(e.data.urlProps,l)}));i.length&&!s&&(t.result=void 0),t.relatedNodes=[],(s=t.relatedNodes).push.apply(s,z(i.map((function(e){return e.relatedNodes[0]})))),o[u]=i,r.push(t)}for(var n=e.filter((function(e){return void 0!==e.result})),r=[],o={},i=0;i<n.length;i++)t(i);return r},"identical-links-same-purpose-evaluate":function(e,t,n){if(n=eu.accessibleTextVirtual(n),n=eu.sanitize(eu.removeUnicode(n,{emoji:!0,nonBmp:!0,punctuations:!0})).toLowerCase())return n={name:n,urlProps:Ao.urlPropsFromAttribute(e,"href")},this.data(n),this.relatedNodes([e]),!0},"identical-links-same-purpose-matches":function(e,t){return!(!wl(t)||(t=Hu(e))&&"link"!==t)},"implicit-evaluate":function(e,t,n){try{var r,a=xa(n,"label");return!!a&&(r=Eu(wl(a,{inControlContext:!0,startNode:n})),a.actualNode&&this.relatedNodes([a.a\
ctualNode]),this.data({implicitLabel:r}),!!r)}catch(e){}},"inline-style-property-evaluate":function(e,n){var r=n.cssProperty,a=n.absoluteValues,o=n.minValue,i=n.maxValue,u=void 0===(u=n.normalValue)?0:u,l=n.noImportant;n=n.multiLineOnly;return!!(!l&&"important"!==e.style.getPropertyPriority(r)||n&&!Ql(e))||(l={},"number"==typeof o&&(l.minValue=o),"number"==typeof i&&(l.maxValue=i),n=e.style.getPropertyValue(r),["inherit","unset","revert","revert-layer"].includes(n)?(this.data($({value:n},l)),!0):(n=function(e,n){var r=n.cssProperty,a=n.absoluteValues;n=n.normalValue;return"normal"===(r=(e=t.getComputedStyle(e)).getPropertyValue(r))?n:(n=parseFloat(r),a?n:(a=parseFloat(e.getPropertyValue("font-size")),e=Math.round(n/a*100)/100,isNaN(e)?r:e))}(e,{absoluteValues:a,cssProperty:r,normalValue:u}),this.data($({value:n},l)),"number"==typeof n?("number"!=typeof o||o<=n)&&("number"!=typeof i||n<=i):void 0))},"inserted-into-focus-order-matches":function(e){return $l(e)},"internal-link-present-eva\
luate":function(e,t,n){return Cf(n,"a[href]").some((function(e){return/^#[^/!]/.test(e.attr("href"))}))},"invalid-children-evaluate":function(e){var t=1<arguments.length&&void 0!==arguments[1]?arguments[1]:{},n=2<arguments.length?arguments[2]:void 0,r=[],a=[];if(n.children){for(var o=fD(n.children);o.length;){var i=(u=o.shift()).vChild,u=u.nested;if(t.divGroups&&!u&&"div"===(l=i).props.nodeName&&null===mu(l)){if(!i.children)return;var l=fD(i.children,!0);o.push.apply(o,z(l))}else l=function(e,t,n){var r=void 0===(r=n.validRoles)?[]:r,a=(n=void 0===(n=n.validNodeNames)?[]:n,(i=e.props).nodeName),o=i.nodeType,i=i.nodeValue;t=t?"div > ":"";return 3===o&&""!==i.trim()?t+"#text":!(1!==o||!Xu(e))&&((i=mu(e))?!r.includes(i)&&t+"[role=".concat(i,"]"):!n.includes(a)&&t+a)}(i,u,t),l&&(a.includes(l)||a.push(l),1===(null==i||null==(u=i.actualNode)?void 0:u.nodeType))&&r.push(i.actualNode)}return 0!==a.length&&(this.data({values:a.join(", ")}),this.relatedNodes(r),!0)}},"invalidrole-evaluate":funct\
ion(e,t,n){return!!(n=sp(n.attr("role"))).every((function(e){return!fu(e,{allowAbstract:!0})}))&&(this.data(n),!0)},"is-element-focusable-evaluate":function(e,t,n){return Xi(n)},"is-initiator-matches":jD,"is-on-screen-evaluate":Wt,"is-visible-matches":ai,"is-visible-on-screen-matches":function(e,t){return ai(t)},"label-content-name-mismatch-evaluate":function(e,t,n){var r=null==t?void 0:t.pixelThreshold,a=null!=(a=null==t?void 0:t.occurrenceThreshold)?a:null==t?void 0:t.occuranceThreshold;if(t=nu(e).toLowerCase(),!(xl(t)<1))return!(e=Eu(pl(n,{subtreeDescendant:!0,ignoreIconLigature:!0,pixelThreshold:r,occurrenceThreshold:a})).toLowerCase())||(xl(e)<1?!!cD(e,t)||void 0:cD(e,t))},"label-content-name-mismatch-matches":function(e,t){var n=Hu(e);return!!(n&&tm("widget").includes(n)&&rm().includes(n)&&(Eu(au(t))||Eu(ru(e)))&&Eu(Ju(t)))},"label-matches":function(e,t){return"input"!==t.props.nodeName||!1===t.hasAttr("type")||(t=t.attr("type").toLowerCase(),!1===["hidden","image","button","subm\
it","reset"].includes(t))},"landmark-has-body-context-matches":function(e,t){return e.hasAttribute("role")||!To(t,"article, aside, main, nav, section")},"landmark-is-top-level-evaluate":function(e){var t=tm("landmark"),n=Jo(e),r=Hu(e);for(this.data({role:r});n;){var a=n.getAttribute("role");if((a=a||"FORM"===n.nodeName.toUpperCase()?a:zu(n))&&t.includes(a)&&("main"!==a||"complementary"!==r))return!1;n=Jo(n)}return!0},"landmark-is-unique-after":function(e){var t=[];return e.filter((function(e){var n=t.find((function(t){return e.data.role===t.data.role&&e.data.accessibleText===t.data.accessibleText}));return n?(n.result=!1,n.relatedNodes.push(e.relatedNodes[0]),!1):(t.push(e),e.relatedNodes=[],!0)}))},"landmark-is-unique-evaluate":function(e,t,n){var r=Hu(e);return n=(n=wl(n))?n.toLowerCase():null,this.data({role:r,accessibleText:n}),this.relatedNodes([e]),!0},"landmark-unique-matches":function(e,t){return n=t,a=tm("landmark"),!!(o=Hu(n))&&("header"!==(r=n.props.nodeName)&&"footer"!==r?"\
section"!==r&&"form"!==r?0<=a.indexOf(o)||"region"===o:!!wl(n):!xa(n,zD))&&Xu(t);var n,r,a,o},"layout-table-matches":function(e){return!BD(e)&&!Xi(e)},"link-in-text-block-evaluate":function(e,t){var n=t.requiredContrastRatio;if(t=t.allowSameColor,iD(e))return!1;for(var r=Jo(e);r&&1===r.nodeType&&!iD(r);)r=Jo(r);if(r){this.relatedNodes([r]);var a=eD(e),o=eD(r),i=(e=Xm(e),Xm(r)),u=a&&o?aD(a,o):void 0;if((u=u&&Math.floor(100*u)/100)&&n<=u)return!0;var l=e&&i?aD(e,i):void 0;if((l=l&&Math.floor(100*l)/100)&&n<=l)return!0;if(l){if(u)return!(!t||1!==u||1!==l)||(1===u&&1<l?this.data({messageKey:"bgContrast",contrastRatio:l,requiredContrastRatio:n,nodeBackgroundColor:e?e.toHexString():void 0,parentBackgroundColor:i?i.toHexString():void 0}):this.data({messageKey:"fgContrast",contrastRatio:u,requiredContrastRatio:n,nodeColor:a?a.toHexString():void 0,parentColor:o?o.toHexString():void 0}),!1)}else l=null!=(t=as.get("bgColor"))?t:"bgContrast",this.data({messageKey:l}),as.clear()}},"link-in-text-blo\
ck-matches":function(e){var t=Eu(e.innerText),n=e.getAttribute("role");return!(n&&"link"!==n||!t||!ai(e))&&Zl(e)},"link-in-text-block-style-evaluate":function(e){if(lD(e))return!1;for(var n=Jo(e);n&&1===n.nodeType&&!lD(n);)n=Jo(n);return n?(this.relatedNodes([n]),!!Bm(e,n)||!!function(e){for(var n=0,r=["before","after"];n<r.length;n++){var a=r[n];if("none"!==t.getComputedStyle(e,":".concat(a)).getPropertyValue("content"))return 1}}(e)&&void this.data({messageKey:"pseudoContent"})):void 0},"listitem-evaluate":function(e,t,n){var r;if(n=n.parent)return r=n.props.nodeName,n=mu(n),!!["presentation","none","list"].includes(n)||(n&&fu(n)?(this.data({messageKey:"roleNotValid"}),!1):["ul","ol","menu"].includes(r))},"matches-definition-evaluate":function(e,t,n){return Lu(n,t.matcher)},"meta-refresh-evaluate":function(e,t,n){var r=(a=t||{}).minDelay,a=a.maxDelay;return!(n=H((n.attr("content")||"").trim().split(_D),1)[0]).match(OD)||(n=parseFloat(n),this.data({redirectDelay:n}),"number"==typeof r\
&&n<=t.minDelay)||"number"==typeof a&&n>t.maxDelay},"meta-viewport-scale-evaluate":function(e,t,n){var r,a=void 0===(a=(t=t||{}).scaleMinimum)?2:a;return t=void 0!==(t=t.lowerBound)&&t,!((n=n.attr("content")||"")&&(n=n.split(/[;,]/).reduce((function(e,t){var n;return(t=t.trim())&&(n=(t=H(t.split("="),2))[0],t=t[1],n)&&t&&(n=n.toLowerCase().trim(),t=t.toLowerCase().trim(),"maximum-scale"===n&&"yes"===t&&(t=1),"maximum-scale"===n&&parseFloat(t)<0||(e[n]=t)),e}),{}),!(t&&n["maximum-scale"]&&parseFloat(n["maximum-scale"])<t))&&(t||"no"!==n["user-scalable"]?(r=parseFloat(n["user-scalable"]),!t&&n["user-scalable"]&&(r||0===r)&&-1<r&&r<1?(this.data("user-scalable"),1):n["maximum-scale"]&&parseFloat(n["maximum-scale"])<a&&(this.data("maximum-scale"),1)):(this.data("user-scalable=no"),1)))},"multiple-label-evaluate":function(e){var t=Mr(e.getAttribute("id")),n=e.parentNode,r=(r=No(e)).documentElement||r,a=Array.from(r.querySelectorAll('label[for="'.concat(t,'"]')));for(a.length&&(a=a.filter((fu\
nction(e){return!Ko(e)})));n;)"LABEL"===n.nodeName.toUpperCase()&&-1===a.indexOf(n)&&a.push(n),n=n.parentNode;return this.relatedNodes(a),1<a.length&&(1<(r=a.filter(Xu)).length||!tu(e,"aria-labelledby").includes(r[0]))&&void 0},"nested-interactive-matches":function(e,t){return!!(t=Hu(t))&&!!du.ariaRoles[t].childrenPresentational},"no-autoplay-audio-evaluate":function(e,t){var n,r;if(e.duration)return t=void 0===(t=t.allowedDuration)?3:t,((n=e).currentSrc?(r=function(e){if(e=e.match(/#t=(.*)/))return H(e,2)[1].split(",").map((function(e){if(/:/.test(e)){for(var t=e.split(":"),n=0,r=1;0<t.length;)n+=r*parseInt(t.pop(),10),r*=60;return parseFloat(n)}return parseFloat(e)}))}(n.currentSrc))?1!==r.length?Math.abs(r[1]-r[0]):Math.abs(n.duration-r[0]):Math.abs(n.duration-(n.currentTime||0)):0)<=t&&!e.hasAttribute("loop")||!!e.hasAttribute("controls");console.warn("axe.utils.preloadMedia did not load metadata")},"no-autoplay-audio-matches":function(e){return!!e.currentSrc&&!e.hasAttribute("paus\
ed")&&!e.hasAttribute("muted")},"no-empty-role-matches":function(e,t){return!!t.hasAttr("role")&&!!t.attr("role").trim()},"no-explicit-name-required-matches":VD,"no-focusable-content-evaluate":function(e,t,n){if(n.children)try{var r,a=function e(t){if(!t.children){if(1===t.props.nodeType)throw new Error("Cannot determine children");return[]}var n=[];return t.children.forEach((function(t){"widget"===Yl(t)&&Xi(t)?n.push(t):n.push.apply(n,z(e(t)))})),n}(n);return!a.length||(0<(r=a.filter(sD)).length?(this.data({messageKey:"notHidden"}),this.relatedNodes(r)):this.relatedNodes(a),!1)}catch(e){}},"no-implicit-explicit-label-evaluate":function(e,t,n){var r,a,o=Hu(n,{noImplicit:!0});this.data(o);try{r=Eu(fl(n)).toLowerCase(),a=Eu(wl(n)).toLowerCase()}catch(e){return}return!(!a&&!r||(a||!r)&&a.includes(r))&&void 0},"no-naming-method-matches":function(e,t){var n=qu(t).namingMethods;return!(n&&0!==n.length||"combobox"===mu(t)&&Cf(t,'input:not([type="hidden"])').length||cm(t,{popupRoles:["listbox"\
]}))},"no-negative-tabindex-matches":function(e,t){return t=parseInt(t.attr("tabindex"),10),isNaN(t)||0<=t},"no-role-matches":function(e,t){return!t.attr("role")},"non-empty-if-present-evaluate":function(e,t,n){var r=n.props.nodeName,a=(n.attr("type")||"").toLowerCase();return(n=n.attr("value"))&&this.data({messageKey:"has-label"}),!("input"!==r||!["submit","reset"].includes(a))&&null===n},"not-html-matches":function(e,t){return"html"!==t.props.nodeName},"object-is-loaded-matches":function(e,t){return[VD,function(e){var t;return null==e||null==(t=e.ownerDocument)||!t.createRange||((t=e.ownerDocument.createRange()).setStart(e,0),t.setEnd(e,e.childNodes.length),0===t.getClientRects().length)}].every((function(n){return n(e,t)}))},"only-dlitems-evaluate":function(e,t,n){var r=["definition","term","list"];return(n=n.children.reduce((function(e,t){var n=t.actualNode;return"DIV"===n.nodeName.toUpperCase()&&null===Hu(n)?e.concat(t.children):e.concat(t)}),[]).reduce((function(e,t){var n,a=(t=t\
.actualNode).nodeName.toUpperCase();return 1===t.nodeType&&Xu(t)?(n=mu(t),("DT"!==a&&"DD"!==a||n)&&!r.includes(n)&&e.badNodes.push(t)):3===t.nodeType&&""!==t.nodeValue.trim()&&(e.hasNonEmptyTextNode=!0),e}),{badNodes:[],hasNonEmptyTextNode:!1})).badNodes.length&&this.relatedNodes(n.badNodes),!!n.badNodes.length||n.hasNonEmptyTextNode},"only-listitems-evaluate":function(e,t,n){var r=!1,a=!1,o=!0,i=[],u=[],l=[];if(n.children.forEach((function(e){var t,n,s=e.actualNode;3===s.nodeType&&""!==s.nodeValue.trim()?r=!0:1===s.nodeType&&Xu(s)&&(o=!1,t="LI"===s.nodeName.toUpperCase(),n="listitem"===(e=Hu(e)),t||n||i.push(s),t&&!n&&(u.push(s),l.includes(e)||l.push(e)),n)&&(a=!0)})),r||i.length)this.relatedNodes(i);else{if(o||a)return!1;this.relatedNodes(u),this.data({messageKey:"roleNotValid",roles:l.join(", ")})}return!0},"p-as-heading-evaluate":function(e,t,n){var r=(i=Array.from(e.parentNode.children)).indexOf(e),a=(t=t||{}).margins||[],o=i.slice(r+1).find((function(e){return"P"===e.nodeName.toU\
pperCase()})),i=i.slice(0,r).reverse().find((function(e){return"P"===e.nodeName.toUpperCase()})),u=(r=SD(e),o?SD(o):null),l=(i=i?SD(i):null,t.passLength);return t=t.failLength,e=e.textContent.trim().length,(o=null==o?void 0:o.textContent.trim().length)*l<e||!u||!MD(r,u,a)||!!((l=To(n,"blockquote"))&&"BLOCKQUOTE"===l.nodeName.toUpperCase()||i&&!MD(r,i,a)||o*t<e)&&void 0},"p-as-heading-matches":function(e){var t=Array.from(e.parentNode.childNodes),n=e.textContent.trim();return!(0===n.length||2<=(n.match(/[.!?:;](?![.!?:;])/g)||[]).length)&&0!==t.slice(t.indexOf(e)+1).filter((function(e){return"P"===e.nodeName.toUpperCase()&&""!==e.textContent.trim()})).length},"page-no-duplicate-after":function(e){return e.filter((function(e){return"ignored"!==e.data}))},"page-no-duplicate-evaluate":function(e,t,n){if(!t||!t.selector||"string"!=typeof t.selector)throw new TypeError("page-no-duplicate requires options.selector to be a string");var r="page-no-duplicate;"+t.selector;if(!sa.get(r))return sa.\
set(r,!0),r=mf(o._tree[0],t.selector,Xu),"string"==typeof t.nativeScopeFilter&&(r=r.filter((function(e){return e.actualNode.hasAttribute("role")||!To(e,t.nativeScopeFilter)}))),"string"==typeof t.role&&(r=r.filter((function(e){return Hu(e)===t.role}))),this.relatedNodes(r.filter((function(e){return e!==n})).map((function(e){return e.actualNode}))),r.length<=1;this.data("ignored")},"presentation-role-conflict-matches":function(e,t){return null!==zu(t,{chromiumRoles:!0})},"presentational-role-evaluate":function(e,t,n){var r=mu(n);if(["presentation","none"].includes(r)&&["iframe","frame"].includes(n.props.nodeName)&&n.hasAttr("title"))this.data({messageKey:"iframe",nodeName:n.props.nodeName});else{var a,o=Hu(n);if(["presentation","none"].includes(o))return this.data({role:o}),!0;["presentation","none"].includes(r)&&(r=hu().some((function(e){return n.hasAttr(e)})),a=Xi(n),this.data({messageKey:r&&!a?"globalAria":!r&&a?"focusable":"both",role:o}))}return!1},"region-after":function(e){var t=\
e.filter((function(e){return e.data.isIframe}));return e.forEach((function(e){if(!e.result&&1!==e.node.ancestry.length){var n,r=e.node.ancestry.slice(0,-1),a=Z(t);try{for(a.s();!(n=a.n()).done;){var o=n.value;if(ef(r,o.node.ancestry)){e.result=o.result;break}}}catch(e){a.e(e)}finally{a.f()}}})),t.forEach((function(e){e.result||(e.result=!0)})),e},"region-evaluate":function(e,t,n){return this.data({isIframe:["iframe","frame"].includes(n.props.nodeName)}),!sa.get("regionlessNodes",(function(){return function e(t,n){var a=t.actualNode;if("button"===Hu(t)||function(e,t){var n=e.actualNode,r=Hu(e),a=(n=(n.getAttribute("aria-live")||"").toLowerCase().trim(),tm("landmark"));return!!(["assertive","polite"].includes(n)||PD.includes(r)||a.includes(r)||t.regionMatcher&&Lu(e,t.regionMatcher))}(t,n)||["iframe","frame"].includes(t.props.nodeName)||Wd(t.actualNode)&&$i(t.actualNode,"href")||!Xu(a)){for(var o=t;o;)o._hasRegionDescendant=!0,o=o.parent;return["iframe","frame"].includes(t.props.nodeName)\
?[t]:[]}return a!==r.body&&zl(a,!0)?[t]:t.children.filter((function(e){return 1===(e=e.actualNode).nodeType})).map((function(t){return e(t,n)})).reduce((function(e,t){return e.concat(t)}),[])}(o._tree[0],t).map((function(e){for(;e.parent&&!e.parent._hasRegionDescendant&&e.parent.actualNode!==r.body;)e=e.parent;return e})).filter((function(e,t,n){return n.indexOf(e)===t}))})).includes(n)},"same-caption-summary-evaluate":function(e,t,n){var r;if(void 0!==n.children)return r=n.attr("summary"),!(!(n=!!(n=n.children.find(ID))&&Eu(pl(n)))||!r)&&Eu(r).toLowerCase()===Eu(n).toLowerCase()},"scope-value-evaluate":function(e,t){return e=e.getAttribute("scope").toLowerCase(),-1!==t.values.indexOf(e)},"scrollable-region-focusable-matches":function(e,t){return void 0!==Hp(e,13)&&!1===cm(t)&&Cf(t,"*").some((function(e){return ql(e,!0,!0)}))},"skip-link-evaluate":function(e){return!!(e=$i(e,"href"))&&(Xu(e)||void 0)},"skip-link-matches":function(e){return Wd(e)&&ni(e)},"structured-dlitems-evaluate":fu\
nction(e,t,n){var r=n.children;if(!r||!r.length)return!1;for(var a,o=!1,i=!1,u=0;u<r.length;u++){if((o="DT"===(a=r[u].props.nodeName.toUpperCase())||o)&&"DD"===a)return!1;"DD"===a&&(i=!0)}return o||i},"svg-namespace-matches":qD,"svg-non-empty-title-evaluate":function(e,t,n){if(n.children){if(n=n.children.find((function(e){return"title"===e.props.nodeName})),!n)return this.data({messageKey:"noTitle"}),!1;try{if(""===pl(n,{includeHidden:!0}).trim())return this.data({messageKey:"emptyTitle"}),!1}catch(e){return}return!0}},"tabindex-evaluate":function(e,t,n){return n=parseInt(n.attr("tabindex"),10),!!isNaN(n)||n<=0},"table-or-grid-role-matches":function(e,t){return t=Hu(t),["treegrid","grid","table"].includes(t)},"target-offset-evaluate":function(e,t,n){var r,a,o=(null==t?void 0:t.minOffset)||24,i=[],u=o,l=Z(_i(n,o));try{for(l.s();!(r=l.n()).done;){var s,c=r.value;"widget"===Yl(c)&&Xi(c)&&(o<=.05+(s=2*(a=fi(n,c,o/2),Math.round(10*a)/10))||(u=Math.min(u,s),i.push(c)))}}catch(e){l.e(e)}final\
ly{l.f()}return 0===i.length?(this.data({closestOffset:u,minOffset:o}),!0):(this.relatedNodes(i.map((function(e){return e.actualNode}))),i.some(Zi)?(this.data({closestOffset:u,minOffset:o}),!Zi(n)&&void 0):void this.data({messageKey:"nonTabbableNeighbor",closestOffset:u,minOffset:o}))},"target-size-evaluate":function(e,t,n){t=(null==t?void 0:t.minSize)||24;var r,a,o=n.boundingClientRect,i=pi.bind(null,t),u=_i(n),l=(r=n,u.filter((function(e){return!mD(e,r)&&hD(r,e)}))),s=(u=function(e,t){var n,r=[],a=[],o=Z(t);try{for(o.s();!(n=o.n()).done;){var i=n.value;!hD(e,i)&&Di(e,i)&&"none"!==i.getComputedStylePropertyValue("pointer-events")&&(mD(e,i)?r:a).push(i)}}catch(e){o.e(e)}finally{o.f()}return{fullyObscuringElms:r,partialObscuringElms:a}}(n,u)).fullyObscuringElms;u=u.partialObscuringElms;return s.length&&!l.length?(this.relatedNodes(gD(s)),this.data({messageKey:"obscured"}),!0):(a=!Zi(n)&&void 0,i(o)||l.length?(u=function(e,t){return e=e.boundingClientRect,0===t.length?null:(t=t.map((func\
tion(e){return e.boundingClientRect})),function(e,t){return e.reduce((function(e,n){var r=pi(t,e);return r!==pi(t,n)?r?e:n:(r=e.width*e.height,n.width*n.height<r?e:n)}))}(hi(e,t)))}(n,n=u.filter((function(e){return"widget"===Yl(e)&&Xi(e)}))),!l.length||!s.length&&i(u||o)?0===n.length||i(u)?(this.data($({minSize:t},DD(u||o))),this.relatedNodes(gD(n)),!0):(s=n.every(Zi),i="partiallyObscured".concat(s?"":"NonTabbable"),this.data($({messageKey:i,minSize:t},DD(u))),this.relatedNodes(gD(n)),s?a:void 0):(this.data({minSize:t,messageKey:"contentOverflow"}),void this.relatedNodes(gD(l)))):(this.data($({minSize:t},DD(o))),a))},"td-has-header-evaluate":function(e){var t=[],n=xD(e),r=gu(e);return n.forEach((function(e){zl(e)&&ND(e)&&!pm(e)&&!kD(e,r).some((function(e){return null!==e&&!!zl(e)}))&&t.push(e)})),!t.length||(this.relatedNodes(t),!1)},"td-headers-attr-evaluate":function(e){for(var t=[],n=[],r=[],a=0;a<e.rows.length;a++)for(var o=e.rows[a],i=0;i<o.cells.length;i++)t.push(o.cells[i]);var \
u=t.filter((function(e){return e.getAttribute("id")})).map((function(e){return e.getAttribute("id")}));return t.forEach((function(e){var t,a=!1;if(e.hasAttribute("headers")&&Xu(e))return(t=e.getAttribute("headers").trim())?void(0!==(t=sp(t)).length&&(e.getAttribute("id")&&(a=-1!==t.indexOf(e.getAttribute("id").trim())),t=t.some((function(e){return!u.includes(e)})),a||t)&&r.push(e)):n.push(e)})),0<r.length?(this.relatedNodes(r),!1):!n.length||void this.relatedNodes(n)},"th-has-data-cells-evaluate":function(e){var t=xD(e),n=this,r=[],a=(t=(t.forEach((function(e){var t;(t=((t=e.getAttribute("headers"))&&(r=r.concat(t.split(/\\s+/))),e.getAttribute("aria-labelledby")))&&(r=r.concat(t.split(/\\s+/)))})),t.filter((function(e){return""!==Eu(e.textContent)&&("TH"===e.nodeName.toUpperCase()||-1!==["rowheader","columnheader"].indexOf(e.getAttribute("role")))}))),gu(e)),o=!0;return t.forEach((function(e){var t,i;e.getAttribute("id")&&r.includes(e.getAttribute("id"))||(t=bu(e,a),i=!1,(i=!(i=yu(e)?RD\
("down",t,a).find((function(t){return!yu(t)&&kD(t,a).includes(e)})):i)&&Fu(e)?RD("right",t,a).find((function(t){return!Fu(t)&&kD(t,a).includes(e)})):i)||n.relatedNodes(e),o=o&&i)})),!!o||void 0},"title-only-evaluate":function(e,t,n){var r=Tl(n),a=Gu(n);return n=n.attr("aria-describedby"),!(r||!a&&!n)},"unique-frame-title-after":function(e){var t={};return e.forEach((function(e){t[e.data]=void 0!==t[e.data]?++t[e.data]:0})),e.forEach((function(e){e.result=!!t[e.data]})),e},"unique-frame-title-evaluate":function(e,t,n){return n=Eu(n.attr("title")).toLowerCase(),this.data(n),!0},"unsupportedrole-evaluate":function(e,t,n){n=Hu(n,{dpub:!0,fallback:!0});var r=pu(n);return r&&this.data(n),r},"valid-lang-evaluate":function(e,t,n){var r=[];return t.attributes.forEach((function(e){var a,o,i=n.attr(e);"string"==typeof i&&(a=bp(i),o=t.value?!t.value.map(bp).includes(a):!If(a),""!==a&&o||""!==i&&!Eu(i))&&r.push(e+'="'+n.attr(e)+'"')})),!!r.length&&!("html"!==n.props.nodeName&&!Vl(n)||(this.data(r),\
0))},"valid-scrollable-semantics-evaluate":function(e,t){return(n=mu(n=e))&&(xm[n]||t.roles.includes(n))||(t=(t=e).nodeName.toUpperCase(),Cm[t])||!1;var n},"widget-not-inline-matches":function(e,t){return $D.every((function(n){return n(e,t)}))},"window-is-top-matches":function(e){return e.ownerDocument.defaultView.self===e.ownerDocument.defaultView.top},"xml-lang-mismatch-evaluate":function(e,t,n){return bp(n.attr("lang"))===bp(n.attr("xml:lang"))},"xml-lang-mismatch-matches":function(e){var t=bp(e.getAttribute("lang"));e=bp(e.getAttribute("xml:lang"));return If(t)&&If(e)}},WD=function(e){this.id=e.id,this.data=null,this.relatedNodes=[],this.result=null};function YD(e){if("string"!=typeof e)return e;if(GD[e])return GD[e];if(/^\\s*function[\\s\\w]*\\(/.test(e))return new Function("return "+e+";")();throw new ReferenceError("Function ID does not exist in the metadata-function-map: ".concat(e))}function KD(e){var t=0<arguments.length&&void 0!==e?e:{};return Array.isArray(t)||"object"!==a(t)?{\
value:t}:t}function XD(e){e&&(this.id=e.id,this.configure(e))}XD.prototype.enabled=!0,XD.prototype.run=function(e,t,n,r,a){var o=((t=t||{}).hasOwnProperty("enabled")?t:this).enabled,i=this.getOptions(t.options);if(o){var u;o=new WD(this),t=ma(o,t,r,a);try{u=this.evaluate.call(t,e.actualNode,i,e,n)}catch(t){return e&&e.actualNode&&(t.errorNode=Do.toSpec(e)),void a(t)}t.isAsync||(o.result=u,r(o))}else r(null)},XD.prototype.runSync=function(e,t,n){if(!(void 0===(a=(t=t||{}).enabled)?this.enabled:a))return null;var r,a=this.getOptions(t.options),o=new WD(this);(t=ma(o,t)).async=function(){throw new Error("Cannot run async check while in a synchronous run")};try{r=this.evaluate.call(t,e.actualNode,a,e,n)}catch(t){throw e&&e.actualNode&&(t.errorNode=Do.toSpec(e)),t}return o.result=r,o},XD.prototype.configure=function(e){var t=this;e.evaluate&&!GD[e.evaluate]||(this._internalCheck=!0),e.hasOwnProperty("enabled")&&(this.enabled=e.enabled),e.hasOwnProperty("options")&&(this._internalCheck?this.\
options=KD(e.options):this.options=e.options),["evaluate","after"].filter((function(t){return e.hasOwnProperty(t)})).forEach((function(n){return t[n]=YD(e[n])}))},XD.prototype.getOptions=function(e){return this._internalCheck?wo(this.options,KD(e||{})):e||this.options};var ZD=XD,JD=function(e){this.id=e.id,this.result=Dr.NA,this.pageLevel=e.pageLevel,this.impact=null,this.nodes=[]};function QD(e,t){this._audit=t,this.id=e.id,this.selector=e.selector||"*",e.impact&&(Or(Dr.impact.includes(e.impact),"Impact ".concat(e.impact," is not a valid impact")),this.impact=e.impact),this.excludeHidden="boolean"!=typeof e.excludeHidden||e.excludeHidden,this.enabled="boolean"!=typeof e.enabled||e.enabled,this.pageLevel="boolean"==typeof e.pageLevel&&e.pageLevel,this.reviewOnFail="boolean"==typeof e.reviewOnFail&&e.reviewOnFail,this.any=e.any||[],this.all=e.all||[],this.none=e.none||[],this.tags=e.tags||[],this.preload=!!e.preload,this.actIds=e.actIds,e.matches&&(this.matches=YD(e.matches))}function e\
h(e){var t,n;if(e.length)return t=!1,n={},e.forEach((function(e){var r=e.results.filter((function(e){return e}));(n[e.type]=r).length&&(t=!0)})),t?n:null}QD.prototype.matches=function(){return!0},QD.prototype.gather=function(e){var t=1<arguments.length&&void 0!==arguments[1]?arguments[1]:{},n="mark_gather_start_"+this.id,r="mark_gather_end_"+this.id,a="mark_isVisibleToScreenReaders_start_"+this.id,o="mark_isVisibleToScreenReaders_end_"+this.id,i=(t.performanceTimer&&cf.mark(n),Bf(this.selector,e));return this.excludeHidden&&(t.performanceTimer&&cf.mark(a),i=i.filter(Xu),t.performanceTimer)&&(cf.mark(o),cf.measure("rule_"+this.id+"#gather_axe.utils.isVisibleToScreenReaders",a,o)),t.performanceTimer&&(cf.mark(r),cf.measure("rule_"+this.id+"#gather",n,r)),i},QD.prototype.runChecks=function(e,t,n,r,a,o){var i=this,u=Ra();this[e].forEach((function(e){var a=i._audit.checks[e.id||e],o=Np(a,i.id,n);u.defer((function(e,n){a.run(t,o,r,e,n)}))})),u.then((function(t){t=t.filter((function(e){return\
 e})),a({type:e,results:t})})).catch(o)},QD.prototype.runChecksSync=function(e,t,n,r){var a=this,o=[];return this[e].forEach((function(e){e=a._audit.checks[e.id||e];var i=Np(e,a.id,n);o.push(e.runSync(t,i,r))})),{type:e,results:o=o.filter((function(e){return e}))}},QD.prototype.run=function(e){var t,n=this,r=1<arguments.length&&void 0!==arguments[1]?arguments[1]:{},a=2<arguments.length?arguments[2]:void 0,o=3<arguments.length?arguments[3]:void 0,u=(r.performanceTimer&&this._trackPerformance(),Ra()),l=new JD(this);try{t=this.gatherAndMatchNodes(e,r)}catch(t){return void o(new i({cause:t,ruleId:this.id}))}r.performanceTimer&&this._logGatherPerformance(t),t.forEach((function(t){u.defer((function(a,o){var i=Ra();["any","all","none"].forEach((function(a){i.defer((function(o,i){n.runChecks(a,t,r,e,o,i)}))})),i.then((function(e){var r=eh(e);r&&(r.node=new fa(t),l.nodes.push(r),n.reviewOnFail)&&(["any","all"].forEach((function(e){r[e].forEach((function(e){!1===e.result&&(e.result=void 0)}))}))\
,r.none.forEach((function(e){!0===e.result&&(e.result=void 0)}))),a()})).catch((function(e){return o(e)}))}))})),u.defer((function(e){return setTimeout(e,0)})),r.performanceTimer&&this._logRulePerformance(),u.then((function(){return a(l)})).catch((function(e){return o(e)}))},QD.prototype.runSync=function(e){var t,n=this,r=1<arguments.length&&void 0!==arguments[1]?arguments[1]:{},a=(r.performanceTimer&&this._trackPerformance(),new JD(this));try{t=this.gatherAndMatchNodes(e,r)}catch(t){throw new i({cause:t,ruleId:this.id})}return r.performanceTimer&&this._logGatherPerformance(t),t.forEach((function(t){var o=[],i=(["any","all","none"].forEach((function(a){o.push(n.runChecksSync(a,t,r,e))})),eh(o));i&&(i.node=t.actualNode?new fa(t):null,a.nodes.push(i),n.reviewOnFail)&&(["any","all"].forEach((function(e){i[e].forEach((function(e){!1===e.result&&(e.result=void 0)}))})),i.none.forEach((function(e){!0===e.result&&(e.result=void 0)})))})),r.performanceTimer&&this._logRulePerformance(),a},QD.pr\
ototype._trackPerformance=function(){this._markStart="mark_rule_start_"+this.id,this._markEnd="mark_rule_end_"+this.id,this._markChecksStart="mark_runchecks_start_"+this.id,this._markChecksEnd="mark_runchecks_end_"+this.id},QD.prototype._logGatherPerformance=function(e){hr("gather (",e.length,"):",cf.timeElapsed()+"ms"),cf.mark(this._markChecksStart)},QD.prototype._logRulePerformance=function(){cf.mark(this._markChecksEnd),cf.mark(this._markEnd),cf.measure("runchecks_"+this.id,this._markChecksStart,this._markChecksEnd),cf.measure("rule_"+this.id,this._markStart,this._markEnd)},QD.prototype.gatherAndMatchNodes=function(e,t){var n=this,r="mark_matches_start_"+this.id,a="mark_matches_end_"+this.id,o=this.gather(e,t);return t.performanceTimer&&cf.mark(r),o=o.filter((function(t){return n.matches(t.actualNode,t,e)})),t.performanceTimer&&(cf.mark(a),cf.measure("rule_"+this.id+"#matches",r,a)),o},QD.prototype.after=function(e,t){var n,r,a,o=this,i=ho(n=this).map((function(e){return(e=n._audit.\
checks[e.id||e])&&"function"==typeof e.after?e:null})).filter(Boolean),u=this.id;return i.forEach((function(n){i=e.nodes,r=n.id,a=[],i.forEach((function(e){ho(e).forEach((function(t){t.id===r&&(t.node=e.node,a.push(t))}))}));var r,a,i=a,l=Np(n,u,t),s=n.after(i,l.options);o.reviewOnFail&&s.forEach((function(e){var t=(o.any.includes(e.id)||o.all.includes(e.id))&&!1===e.result,n=o.none.includes(e.id)&&!0===e.result;(t||n)&&(e.result=void 0)})),i.forEach((function(e){delete e.node,-1===s.indexOf(e)&&(e.filtered=!0)}))})),e.nodes=(r=["any","all","none"],a=(i=e).nodes.filter((function(e){var t=0;return r.forEach((function(n){e[n]=e[n].filter((function(e){return!0!==e.filtered})),t+=e[n].length})),0<t})),a=i.pageLevel&&a.length?[a.reduce((function(e,t){if(e)return r.forEach((function(n){e[n].push.apply(e[n],t[n])})),e}))]:a),e},QD.prototype.configure=function(e){e.hasOwnProperty("selector")&&(this.selector=e.selector),e.hasOwnProperty("excludeHidden")&&(this.excludeHidden="boolean"!=typeof e.\
excludeHidden||e.excludeHidden),e.hasOwnProperty("enabled")&&(this.enabled="boolean"!=typeof e.enabled||e.enabled),e.hasOwnProperty("pageLevel")&&(this.pageLevel="boolean"==typeof e.pageLevel&&e.pageLevel),e.hasOwnProperty("reviewOnFail")&&(this.reviewOnFail="boolean"==typeof e.reviewOnFail&&e.reviewOnFail),e.hasOwnProperty("any")&&(this.any=e.any),e.hasOwnProperty("all")&&(this.all=e.all),e.hasOwnProperty("none")&&(this.none=e.none),e.hasOwnProperty("tags")&&(this.tags=e.tags),e.hasOwnProperty("actIds")&&(this.actIds=e.actIds),e.hasOwnProperty("matches")&&(this.matches=YD(e.matches)),e.impact&&(Or(Dr.impact.includes(e.impact),"Impact ".concat(e.impact," is not a valid impact")),this.impact=e.impact)};var th=ne(fr()),nh=/\\{\\{.+?\\}\\}/g;function rh(e){W(this,rh),this.lang="en",this.defaultConfig=e,this.standards=du,this._init(),this._defaultLocale=null}K(rh,[{key:"_setDefaultLocale",value:function(){if(!this._defaultLocale){for(var e={checks:{},rules:{},failureSummaries:{},incompleteFall\
backMessage:"",lang:this.lang},t=Object.keys(this.data.checks),n=0;n<t.length;n++){var r=t[n],a=(i=this.data.checks[r].messages).pass,o=i.fail,i=i.incomplete;e.checks[r]={pass:a,fail:o,incomplete:i}}for(var u=Object.keys(this.data.rules),l=0;l<u.length;l++){var s=u[l],c=(d=this.data.rules[s]).description,d=d.help;e.rules[s]={description:c,help:d}}for(var p=Object.keys(this.data.failureSummaries),f=0;f<p.length;f++){var m=p[f],D=this.data.failureSummaries[m].failureMessage;e.failureSummaries[m]={failureMessage:D}}e.incompleteFallbackMessage=this.data.incompleteFallbackMessage,this._defaultLocale=e}}},{key:"_resetLocale",value:function(){var e=this._defaultLocale;e&&this.applyLocale(e)}},{key:"_applyCheckLocale",value:function(e){for(var t=Object.keys(e),n=0;n<t.length;n++){var r=t[n];if(!this.data.checks[r])throw new Error('Locale provided for unknown check: "'.concat(r,'"'));this.data.checks[r]=uh(this.data.checks[r],e[r])}}},{key:"_applyRuleLocale",value:function(e){for(var t=Object.k\
eys(e),n=0;n<t.length;n++){var r=t[n];if(!this.data.rules[r])throw new Error('Locale provided for unknown rule: "'.concat(r,'"'));this.data.rules[r]=lh(this.data.rules[r],e[r])}}},{key:"_applyFailureSummaries",value:function(e){for(var t=Object.keys(e),n=0;n<t.length;n++){var r=t[n];if(!this.data.failureSummaries[r])throw new Error('Locale provided for unknown failureMessage: "'.concat(r,'"'));this.data.failureSummaries[r]=sh(this.data.failureSummaries[r],e[r])}}},{key:"applyLocale",value:function(e){this._setDefaultLocale(),e.checks&&this._applyCheckLocale(e.checks),e.rules&&this._applyRuleLocale(e.rules),e.failureSummaries&&this._applyFailureSummaries(e.failureSummaries,"failureSummaries"),e.incompleteFallbackMessage&&(this.data.incompleteFallbackMessage=ch(this.data.incompleteFallbackMessage,e.incompleteFallbackMessage)),e.lang&&(this.lang=e.lang)}},{key:"setAllowedOrigins",value:function(e){var t,n=oh(),r=(this.allowedOrigins=[],Z(e));try{for(r.s();!(t=r.n()).done;){var a=t.value;i\
f(a===Dr.allOrigins)return void(this.allowedOrigins=["*"]);a!==Dr.sameOrigin?this.allowedOrigins.push(a):n&&this.allowedOrigins.push(n)}}catch(e){r.e(e)}finally{r.f()}}},{key:"_init",value:function(){var e=function(e){var t;return e?(t=Da(e)).commons=e.commons:t={},t.reporter=t.reporter||null,t.noHtml=t.noHtml||!1,t.allowedOrigins||(e=oh(),t.allowedOrigins=e?[e]:[]),t.rules=t.rules||[],t.checks=t.checks||[],t.data=$({checks:{},rules:{}},t.data),t}(this.defaultConfig);this.lang=e.lang||"en",this.reporter=e.reporter,this.commands={},this.rules=[],this.checks={},this.brand="axe",this.application="axeAPI",this.tagExclude=["experimental"],this.noHtml=e.noHtml,this.allowedOrigins=e.allowedOrigins,ih(e.rules,this,"addRule"),ih(e.checks,this,"addCheck"),this.data={},this.data.checks=e.data&&e.data.checks||{},this.data.rules=e.data&&e.data.rules||{},this.data.failureSummaries=e.data&&e.data.failureSummaries||{},this.data.incompleteFallbackMessage=e.data&&e.data.incompleteFallbackMessage||"",thi\
s._constructHelpUrls()}},{key:"registerCommand",value:function(e){this.commands[e.id]=e.callback}},{key:"addRule",value:function(e){e.metadata&&(this.data.rules[e.id]=e.metadata);var t=this.getRule(e.id);t?t.configure(e):this.rules.push(new QD(e,this))}},{key:"addCheck",value:function(e){var t=e.metadata;"object"===a(t)&&(this.data.checks[e.id]=t,"object"===a(t.messages))&&Object.keys(t.messages).filter((function(e){return t.messages.hasOwnProperty(e)&&"string"==typeof t.messages[e]})).forEach((function(e){0===t.messages[e].indexOf("function")&&(t.messages[e]=new Function("return "+t.messages[e]+";")())})),this.checks[e.id]?this.checks[e.id].configure(e):this.checks[e.id]=new ZD(e)}},{key:"run",value:function(e,t,n,r){this.normalizeOptions(t),fa.setRunOptions(t),o._selectCache=[],u=this.rules,a=e,i=t;var a,i,u=u.reduce((function(e,t){return Af(t,a,i)&&(t.preload?e.later:e.now).push(t),e}),{now:[],later:[]}),l=u.now,s=u.later,c=Ra();l.forEach((function(n){c.defer(dh(n,e,t))})),u=Ra();(l\
=(s.length&&u.defer((function(e){vf(t).then((function(t){return e(t)})).catch((function(t){console.warn("Couldn't load preload assets: ",t),e(void 0)}))})),Ra())).defer(c),l.defer(u),l.then((function(a){var i,u=a.pop(),l=(u&&u.length&&(u=u[0])&&(e=$({},e,u)),a[0]);s.length?(i=Ra(),s.forEach((function(n){n=dh(n,e,t),i.defer(n)})),i.then((function(e){o._selectCache=void 0,n(l.concat(e).filter((function(e){return!!e})))})).catch(r)):(o._selectCache=void 0,n(l.filter((function(e){return!!e}))))})).catch(r)}},{key:"after",value:function(e,t){var n=this.rules;return e.map((function(e){var r=go(n,"id",e.id);if(r)return r.after(e,t);throw new Error("Result for unknown rule. You may be running mismatch axe-core versions")}))}},{key:"getRule",value:function(e){return this.rules.find((function(t){return t.id===e}))}},{key:"normalizeOptions",value:function(e){var t=[],n=[];if(this.rules.forEach((function(e){n.push(e.id),e.tags.forEach((function(e){t.includes(e)||t.push(e)}))})),["object","string"]\
.includes(a(e.runOnly))){if("string"==typeof e.runOnly&&(e.runOnly=[e.runOnly]),Array.isArray(e.runOnly)){var r=e.runOnly.find((function(e){return t.includes(e)})),i=e.runOnly.find((function(e){return n.includes(e)}));if(r&&i)throw new Error("runOnly cannot be both rules and tags");e.runOnly=i?{type:"rule",values:e.runOnly}:{type:"tag",values:e.runOnly}}if((r=e.runOnly).value&&!r.values&&(r.values=r.value,delete r.value),!Array.isArray(r.values)||0===r.values.length)throw new Error("runOnly.values must be a non-empty array");if(["rule","rules"].includes(r.type))r.type="rule",r.values.forEach((function(e){if(!n.includes(e))throw new Error("unknown rule \`"+e+"\` in options.runOnly")}));else{if(!["tag","tags",void 0].includes(r.type))throw new Error("Unknown runOnly type '".concat(r.type,"'"));r.type="tag",i=r.values.filter((function(e){return!t.includes(e)&&!/wcag2[1-3]a{1,3}/.test(e)})),0!==i.length&&o.log("Could not find tags \`"+i.join("\`, \`")+"\`")}}return"object"===a(e.rules)&&Object.k\
eys(e.rules).forEach((function(e){if(!n.includes(e))throw new Error("unknown rule \`"+e+"\` in options.rules")})),e}},{key:"setBranding",value:function(e){var t={brand:this.brand,application:this.application};"string"==typeof e&&(this.application=e),e&&e.hasOwnProperty("brand")&&e.brand&&"string"==typeof e.brand&&(this.brand=e.brand),e&&e.hasOwnProperty("application")&&e.application&&"string"==typeof e.application&&(this.application=e.application),this._constructHelpUrls(t)}},{key:"_constructHelpUrls",value:function(){var e=this,t=0<arguments.length&&void 0!==arguments[0]?arguments[0]:null,n=(o.version.match(/^[1-9][0-9]*\\.[0-9]+/)||["x.y"])[0];this.rules.forEach((function(r){e.data.rules[r.id]||(e.data.rules[r.id]={});var a=e.data.rules[r.id];("string"!=typeof a.helpUrl||t&&a.helpUrl===ph(t,r.id,n))&&(a.helpUrl=ph(e,r.id,n))}))}},{key:"resetRulesAndChecks",value:function(){this._init(),this._resetLocale()}}]);var ah=rh;function oh(){return t.origin&&"null"!==t.origin?t.origin:t.location\
&&t.location.origin&&"null"!==t.location.origin?t.location.origin:void 0}function ih(e,t,n){for(var r=0,a=e.length;r<a;r++)t[n](e[r])}var uh=function(e,t){var n=t.pass,r=t.fail;return"string"==typeof n&&nh.test(n)&&(n=th.default.compile(n)),"string"==typeof r&&nh.test(r)&&(r=th.default.compile(r)),$({},e,{messages:{pass:n||e.messages.pass,fail:r||e.messages.fail,incomplete:"object"===a(e.messages.incomplete)?$({},e.messages.incomplete,t.incomplete):t.incomplete}})},lh=function(e,t){var n=t.help;t=t.description;return"string"==typeof n&&nh.test(n)&&(n=th.default.compile(n)),"string"==typeof t&&nh.test(t)&&(t=th.default.compile(t)),$({},e,{help:n||e.help,description:t||e.description})},sh=function(e,t){return $({},e,{failureMessage:(t="string"==typeof(t=t.failureMessage)&&nh.test(t)?th.default.compile(t):t)||e.failureMessage})},ch=function(e,t){return(t="string"==typeof t&&nh.test(t)?th.default.compile(t):t)||e};function dh(e,t,n){return n.performanceTimer&&cf.mark("mark_rule_start_"+e.i\
d),function(r,a){e.run(t,n,(function(e){r(e)}),(function(t){n.debug?a(t):(t=Object.assign(new JD(e),{result:Dr.CANTTELL,description:"An error occured while running this rule",message:t.message,stack:t.stack,error:t,errorNode:t.errorNode}),r(t))}))}}function ph(e,t,n){var r=e.brand,a=e.application;e=e.lang;return Dr.helpUrlBase+r+"/"+(n||o.version.substring(0,o.version.lastIndexOf(".")))+"/"+t+"?application="+encodeURIComponent(a)+(e&&"en"!==e?"&lang="+encodeURIComponent(e):"")}function fh(e){var n=t&&"Node"in t&&"NodeList"in t,a=!!r;if(!n||!a){if(!e||!e.ownerDocument)throw new Error('Required "window" or "document" globals not defined and cannot be deduced from the context. Either set the globals before running or pass in a valid Element.');a||(sa.set("globalDocumentSet",!0),r=e.ownerDocument),n||(sa.set("globalWindowSet",!0),t=r.defaultView)}}var mh=function(){sa.get("globalDocumentSet")&&(sa.set("globalDocumentSet",!1),r=null),sa.get("globalWindowSet")&&(sa.set("globalWindowSet",!1),\
t=null),o._memoizedFns.forEach((function(e){return e.clear()})),sa.clear(),o._tree=void 0,o._selectorData=void 0,o._selectCache=void 0};function Dh(e,t,n,r){try{e=new qp(e),o._tree=e.flatTree,o._selectorData=ea(e.flatTree)}catch(a){return mh(),r(a)}var a=Ra(),i=o._audit;t.performanceTimer&&cf.auditStart(),e.frames.length&&!1!==t.iframes&&a.defer((function(n,r){yo(e,t,"rules",null,n,r)})),a.defer((function(n,r){i.run(e,t,n,r)})),a.then((function(a){try{t.performanceTimer&&cf.auditEnd();var o=vo(a.map((function(e){return{results:e}})));e.initiator&&((o=i.after(o,t)).forEach(wf),o=o.map(Nr));try{n(o,mh)}catch(a){mh(),hr(a)}}catch(a){mh(),r(a)}})).catch((function(e){mh(),r(e)}))}function hh(e){this._run=e.run,this._collect=e.collect,this._registry={},e.commands.forEach((function(e){o._audit.registerCommand(e)}))}function gh(e){var t,n=(e=H(e,3))[0],i=e[1],u=(e=e[2],new TypeError("axe.run arguments are invalid"));if(!_p(t=n)&&!Op(t)){if(void 0!==e)throw u;e=i,i=n,n=r}if("object"!==a(i)){if(\
void 0!==e)throw u;e=i,i={}}if("function"!=typeof e&&void 0!==e)throw u;return(i=Da(i)).reporter=null!=(t=null!=(t=i.reporter)?t:null==(u=o._audit)?void 0:u.reporter)?t:"v1",{context:n,options:i,callback:e}}t.top!==t&&(uo.subscribe("axe.start",(function(e,t,n){function a(e){e instanceof Error==0&&(e=new Error(e)),n(e)}var i=n,u=e&&e.context||{},l=(u.hasOwnProperty("include")&&!u.include.length&&(u.include=[r]),e&&e.options||{});switch(e.command){case"rules":return Dh(u,l,(function(e,t){e=Do.mapRawResults(e),i(e),t()}),a);case"cleanup-plugin":return $f(i,a);default:if(o._audit&&o._audit.commands&&o._audit.commands[e.command])return o._audit.commands[e.command](e,n)}})),uo.subscribe("axe.ping",(function(e,t,n){n({axe:!0})}))),hh.prototype.run=function(){return this._run.apply(this,arguments)},hh.prototype.collect=function(){return this._collect.apply(this,arguments)},hh.prototype.cleanup=function(e){var t=o.utils.queue(),n=this;Object.keys(this._registry).forEach((function(e){t.defer((fu\
nction(t){n._registry[e].cleanup(t)}))})),t.then(e)},hh.prototype.add=function(e){this._registry[e.id]=e};var bh=function(){};var vh=function(e,t,n){if("function"==typeof t&&(n=t,t={}),!e||!Array.isArray(e))return n(e);n(e.map((function(e){for(var t=$({},e),n=0,r=["passes","violations","incomplete","inapplicable"];n<r.length;n++){var a=r[n];t[a]=Do.mapRawNodeResults(t[a])}return t})))};$t={base:{Audit:ah,CheckResult:WD,Check:ZD,Context:qp,RuleResult:JD,Rule:QD,metadataFunctionMap:GD},public:{reporters:Hf},helpers:{failureSummary:vp,incompleteFallbackMessage:yp,processAggregate:wp},utils:{setDefaultFrameMessenger:oo,cacheNodeSelectors:Dp,getNodesMatchingExpression:dp,convertSelector:Ea},commons:{dom:{nativelyHidden:Io,displayHidden:jo,visibilityHidden:Lo,contentVisibiltyHidden:qo,ariaHidden:zo,opacityHidden:Vo,scrollHidden:$o,overflowHidden:Ho,clipHidden:Uo,areaHidden:Go,detailsHidden:Wo}}};o._thisWillBeDeletedDoNotUse=$t,o.constants=Dr,o.log=hr,o.AbstractVirtualNode=vr,o.SerialVirtualN\
ode=Vf,o.VirtualNode=lp,o._cache=sa,o.imports=uu,o.cleanup=$f,o.configure=function(e){var t=o._audit;if(!t)throw new Error("No audit configured");if(e.axeVersion||e.ver){var n=e.axeVersion||e.ver;if(!/^\\d+\\.\\d+\\.\\d+(-canary)?/.test(n))throw new Error("Invalid configured version ".concat(n));var r=(a=H(n.split("-"),2))[0],a=a[1],i=(r=H(r.split(".").map(Number),3))[0],u=r[1],l=(r=r[2],(s=H(o.version.split("-"),2))[0]),s=s[1],c=(l=H(l.split(".").map(Number),3))[0],d=l[1];l=l[2];if(i!==c||d<u||d===u&&l<r||i===c&&u===d&&r===l&&a&&a!==s)throw new Error("Configured version ".concat(n," is not compatible with current axe version ").concat(o.version))}if(e.reporter&&("function"==typeof e.reporter||Uf(e.reporter))&&(t.reporter=e.reporter),e.checks){if(!Array.isArray(e.checks))throw new TypeError("Checks property must be an array");e.checks.forEach((function(e){if(!e.id)throw new TypeError("Configured check ".concat(JSON.stringify(e)," is invalid. Checks must be an object with at least an id prop\
erty"));t.addCheck(e)}))}var p,f=[];if(e.rules){if(!Array.isArray(e.rules))throw new TypeError("Rules property must be an array");e.rules.forEach((function(e){if(!e.id)throw new TypeError("Configured rule ".concat(JSON.stringify(e)," is invalid. Rules must be an object with at least an id property"));f.push(e.id),t.addRule(e)}))}if(e.disableOtherRules&&t.rules.forEach((function(e){!1===f.includes(e.id)&&(e.enabled=!1)})),void 0!==e.branding?t.setBranding(e.branding):t._constructHelpUrls(),e.tagExclude&&(t.tagExclude=e.tagExclude),e.locale&&t.applyLocale(e.locale),e.standards&&(p=e.standards,Object.keys(cu).forEach((function(e){p[e]&&(cu[e]=wo(cu[e],p[e]))}))),e.noHtml&&(t.noHtml=!0),e.allowedOrigins){if(!Array.isArray(e.allowedOrigins))throw new TypeError("Allowed origins property must be an array");if(e.allowedOrigins.includes("*"))throw new Error('"*" is not allowed. Use "'.concat(Dr.allOrigins,'" instead'));t.setAllowedOrigins(e.allowedOrigins)}},o.frameMessenger=function(e){uo.upda\
teMessenger(e)},o.getRules=function(e){var t=(e=e||[]).length?o._audit.rules.filter((function(t){return!!e.filter((function(e){return-1!==t.tags.indexOf(e)})).length})):o._audit.rules,n=o._audit.data.rules||{};return t.map((function(e){var t=n[e.id]||{};return{ruleId:e.id,description:t.description,help:t.help,helpUrl:t.helpUrl,tags:e.tags,actIds:e.actIds}}))},o._load=function(e){o._audit=new ah(e)},o.plugins={},o.registerPlugin=function(e){o.plugins[e.id]=new hh(e)},o.hasReporter=Uf,o.getReporter=Gf,o.addReporter=function(e,t,n){Hf[e]=t,n&&(Lf=t)},o.reset=function(){var e=o._audit;if(!e)throw new Error("No audit configured");e.resetRulesAndChecks(),Object.keys(cu).forEach((function(e){cu[e]=su[e]}))},o._runRules=Dh,o.runVirtualRule=function(e,t){var n=2<arguments.length&&void 0!==arguments[2]?arguments[2]:{},r=(n.reporter=n.reporter||o._audit.reporter||"v1",o._selectorData={},t instanceof vr||(t=new Vf(t)),Vp(e));if(r)return wf(r=(r=Object.create(r,{excludeHidden:{value:!1}})).runSync(\
{initiator:!0,include:[t],exclude:[],frames:[],page:!1,focusable:!0,size:{},flatTree:[]},n)),Nr(r),(r=Rr([r])).violations.forEach((function(e){return e.nodes.forEach((function(e){e.failureSummary=vp(e)}))})),$({},Bp(),r,{toolOptions:n});throw new Error("unknown rule \`"+e+"\`")},o.run=function(){for(var e=arguments.length,t=new Array(e),n=0;n<e;n++)t[n]=arguments[n];fh(t[0]);var r=(c=gh(t)).context,a=c.options,i=void 0===(c=c.callback)?bh:c,u=(c=function(e){var t,n,r;return"function"==typeof Promise&&e===bh?t=new Promise((function(e,t){n=t,r=e})):(r=function(t){return e(null,t)},n=function(t){return e(t)}),{thenable:t,reject:n,resolve:r}}(i)).thenable,l=c.resolve,s=c.reject;try{Or(o._audit,"No audit configured"),Or(!o._running,"Axe is already running. Use \`await axe.run()\` to wait for the previous run to finish before starting a new run.")}catch(e){var c=e;if("function"!=typeof i||i===bh)throw c;return void i(c.message)}return o._running=!0,a.performanceTimer&&o.utils.performanceTimer.st\
art(),o._runRules(r,a,(function(e,t){function n(e){o._running=!1,t();try{s(e)}catch(e){o.log(e)}}a.performanceTimer&&o.utils.performanceTimer.end();try{var r=e,i=a,u=function(e){o._running=!1,t();try{l(e)}catch(e){o.log(e)}},c=n;void 0!==(r=Gf(i.reporter)(r,i,u,c))&&u(r)}catch(e){n(e)}}),(function(e){a.performanceTimer&&o.utils.performanceTimer.end(),o._running=!1,i(e),s(e)})),u},o.setup=function(e){if(o._tree)throw new Error("Axe is already setup. Call \`axe.teardown()\` before calling \`axe.setup\` again.");return fh(e=e&&"object"===a(e.documentElement)&&"object"===a(e.defaultView)?e.documentElement:e),o._tree=hp(e),o._selectorData=ea(o._tree),o._tree[0]},o.teardown=mh,o.runPartial=function(){for(var e=arguments.length,t=new Array(e),n=0;n<e;n++)t[n]=arguments[n];var r=(a=gh(t)).options,a=a.context,i=(Or(o._audit,"Axe is not configured. Audit is missing."),Or(!o._running,"Axe is already running. Use \`await axe.run()\` to wait for the previous run to finish before starting a new run."),new\
 qp(a,o._tree));return o._tree=i.flatTree,o._selectorData=ea(i.flatTree),o._running=!0,r.elementRef=!1,new Promise((function(e,t){o._audit.run(i,r,e,t)})).then((function(e){e=Do.mapRawResults(e);var t,n=i.frames.map((function(e){return e=e.node,Do.toSpec(e)}));return i.initiator&&(t=Bp()),o._running=!1,mh(),{results:e,frames:n,environmentData:t}})).catch((function(e){return o._running=!1,mh(),Promise.reject(e)}))},o.finishRun=function(e){var t,n=Da(n=1<arguments.length&&void 0!==arguments[1]?arguments[1]:{}),r=(e.find((function(e){return e.environmentData}))||{}).environmentData;o._audit.normalizeOptions(n),n.reporter=null!=(p=null!=(p=n.reporter)?p:null==(p=o._audit)?void 0:p.reporter)?p:"v1";var a=[],i=Z(p=e);try{for(i.s();!(t=i.n()).done;){var u,l=t.value,s=a.shift();l&&(l.frameSpec=null!=s?s:null,u=function(e){var t=e.frames,n=e.frameSpec;return n?t.map((function(e){return Do.mergeSpecs(e,n)})):t}(l),a.unshift.apply(a,z(u)))}}catch(e){i.e(e)}finally{i.f()}var c,d,p=vo(e);return(p=o\
._audit.after(p,n)).forEach(wf),p=p.map(Nr),c=p,d=$({environmentData:r},n),new Promise((function(e,t){Gf(d.reporter)(c,d,e,t)}))},o.commons=Cc,o.utils=yr,o.addReporter("na",(function(e,t,n){console.warn('"na" reporter will be deprecated in axe v4.0. Use the "v2" reporter instead.'),"function"==typeof t&&(n=t,t={});var r=t.environmentData,a=q(a=t,F);n($({},Bp(r),{toolOptions:a},wp(e,t)))})),o.addReporter("no-passes",(function(e,t,n){"function"==typeof t&&(n=t,t={});var r=t.environmentData,a=q(a=t,w);t.resultTypes=["violations"],e=wp(e,t).violations,n($({},Bp(r),{toolOptions:a,violations:e}))})),o.addReporter("rawEnv",(function(e,t,n){"function"==typeof t&&(n=t,t={});var r=t.environmentData;t=q(t,E),vh(e,t,(function(e){var t=Bp(r);n({raw:e,env:t})}))})),o.addReporter("raw",vh),o.addReporter("v1",(function(e,t,n){function r(e){e.nodes.forEach((function(e){e.failureSummary=vp(e)}))}"function"==typeof t&&(n=t,t={});var a=t.environmentData,o=q(o=t,C);(e=wp(e,t)).incomplete.forEach(r),e.viola\
tions.forEach(r),n($({},Bp(a),{toolOptions:o},e))})),o.addReporter("v2",(function(e,t,n){"function"==typeof t&&(n=t,t={});var r=t.environmentData,a=q(a=t,x);e=wp(e,t),n($({},Bp(r),{toolOptions:a},e))}),!0),o._load({lang:"en",data:{rules:{accesskeys:{description:"Ensures every accesskey attribute value is unique",help:"accesskey attribute value should be unique"},"area-alt":{description:"Ensures <area> elements of image maps have alternate text",help:"Active <area> elements must have alternate text"},"aria-allowed-attr":{description:"Ensures an element's role supports its ARIA attributes",help:"Elements must only use supported ARIA attributes"},"aria-allowed-role":{description:"Ensures role attribute has an appropriate value for the element",help:"ARIA role should be appropriate for the element"},"aria-braille-equivalent":{description:"Ensure aria-braillelabel and aria-brailleroledescription have a non-braille equivalent",help:"aria-braille attributes must have a non-braille equivalent"\
},"aria-command-name":{description:"Ensures every ARIA button, link and menuitem has an accessible name",help:"ARIA commands must have an accessible name"},"aria-conditional-attr":{description:"Ensures ARIA attributes are used as described in the specification of the element's role",help:"ARIA attributes must be used as specified for the element's role"},"aria-deprecated-role":{description:"Ensures elements do not use deprecated roles",help:"Deprecated ARIA roles must not be used"},"aria-dialog-name":{description:"Ensures every ARIA dialog and alertdialog node has an accessible name",help:"ARIA dialog and alertdialog nodes should have an accessible name"},"aria-hidden-body":{description:'Ensures aria-hidden="true" is not present on the document body.',help:'aria-hidden="true" must not be present on the document body'},"aria-hidden-focus":{description:"Ensures aria-hidden elements are not focusable nor contain focusable elements",help:"ARIA hidden element must not be focusable or contai\
n focusable elements"},"aria-input-field-name":{description:"Ensures every ARIA input field has an accessible name",help:"ARIA input fields must have an accessible name"},"aria-meter-name":{description:"Ensures every ARIA meter node has an accessible name",help:"ARIA meter nodes must have an accessible name"},"aria-progressbar-name":{description:"Ensures every ARIA progressbar node has an accessible name",help:"ARIA progressbar nodes must have an accessible name"},"aria-prohibited-attr":{description:"Ensures ARIA attributes are not prohibited for an element's role",help:"Elements must only use permitted ARIA attributes"},"aria-required-attr":{description:"Ensures elements with ARIA roles have all required ARIA attributes",help:"Required ARIA attributes must be provided"},"aria-required-children":{description:"Ensures elements with an ARIA role that require child roles contain them",help:"Certain ARIA roles must contain particular children"},"aria-required-parent":{description:"Ensures \
elements with an ARIA role that require parent roles are contained by them",help:"Certain ARIA roles must be contained by particular parents"},"aria-roledescription":{description:"Ensure aria-roledescription is only used on elements with an implicit or explicit role",help:"aria-roledescription must be on elements with a semantic role"},"aria-roles":{description:"Ensures all elements with a role attribute use a valid value",help:"ARIA roles used must conform to valid values"},"aria-text":{description:'Ensures role="text" is used on elements with no focusable descendants',help:'"role=text" should have no focusable descendants'},"aria-toggle-field-name":{description:"Ensures every ARIA toggle field has an accessible name",help:"ARIA toggle fields must have an accessible name"},"aria-tooltip-name":{description:"Ensures every ARIA tooltip node has an accessible name",help:"ARIA tooltip nodes must have an accessible name"},"aria-treeitem-name":{description:"Ensures every ARIA treeitem node h\
as an accessible name",help:"ARIA treeitem nodes should have an accessible name"},"aria-valid-attr-value":{description:"Ensures all ARIA attributes have valid values",help:"ARIA attributes must conform to valid values"},"aria-valid-attr":{description:"Ensures attributes that begin with aria- are valid ARIA attributes",help:"ARIA attributes must conform to valid names"},"audio-caption":{description:"Ensures <audio> elements have captions",help:"<audio> elements must have a captions track"},"autocomplete-valid":{description:"Ensure the autocomplete attribute is correct and suitable for the form field",help:"autocomplete attribute must be used correctly"},"avoid-inline-spacing":{description:"Ensure that text spacing set through style attributes can be adjusted with custom stylesheets",help:"Inline text spacing must be adjustable with custom stylesheets"},blink:{description:"Ensures <blink> elements are not used",help:"<blink> elements are deprecated and must not be used"},"button-name":{d\
escription:"Ensures buttons have discernible text",help:"Buttons must have discernible text"},bypass:{description:"Ensures each page has at least one mechanism for a user to bypass navigation and jump straight to the content",help:"Page must have means to bypass repeated blocks"},"color-contrast-enhanced":{description:"Ensures the contrast between foreground and background colors meets WCAG 2 AAA enhanced contrast ratio thresholds",help:"Elements must meet enhanced color contrast ratio thresholds"},"color-contrast":{description:"Ensures the contrast between foreground and background colors meets WCAG 2 AA minimum contrast ratio thresholds",help:"Elements must meet minimum color contrast ratio thresholds"},"css-orientation-lock":{description:"Ensures content is not locked to any specific display orientation, and the content is operable in all display orientations",help:"CSS Media queries must not lock display orientation"},"definition-list":{description:"Ensures <dl> elements are struct\
ured correctly",help:"<dl> elements must only directly contain properly-ordered <dt> and <dd> groups, <script>, <template> or <div> elements"},dlitem:{description:"Ensures <dt> and <dd> elements are contained by a <dl>",help:"<dt> and <dd> elements must be contained by a <dl>"},"document-title":{description:"Ensures each HTML document contains a non-empty <title> element",help:"Documents must have <title> element to aid in navigation"},"duplicate-id-active":{description:"Ensures every id attribute value of active elements is unique",help:"IDs of active elements must be unique"},"duplicate-id-aria":{description:"Ensures every id attribute value used in ARIA and in labels is unique",help:"IDs used in ARIA and labels must be unique"},"duplicate-id":{description:"Ensures every id attribute value is unique",help:"id attribute value must be unique"},"empty-heading":{description:"Ensures headings have discernible text",help:"Headings should not be empty"},"empty-table-header":{description:"En\
sures table headers have discernible text",help:"Table header text should not be empty"},"focus-order-semantics":{description:"Ensures elements in the focus order have a role appropriate for interactive content",help:"Elements in the focus order should have an appropriate role"},"form-field-multiple-labels":{description:"Ensures form field does not have multiple label elements",help:"Form field must not have multiple label elements"},"frame-focusable-content":{description:"Ensures <frame> and <iframe> elements with focusable content do not have tabindex=-1",help:"Frames with focusable content must not have tabindex=-1"},"frame-tested":{description:"Ensures <iframe> and <frame> elements contain the axe-core script",help:"Frames should be tested with axe-core"},"frame-title-unique":{description:"Ensures <iframe> and <frame> elements contain a unique title attribute",help:"Frames must have a unique title attribute"},"frame-title":{description:"Ensures <iframe> and <frame> elements have an\
 accessible name",help:"Frames must have an accessible name"},"heading-order":{description:"Ensures the order of headings is semantically correct",help:"Heading levels should only increase by one"},"hidden-content":{description:"Informs users about hidden content.",help:"Hidden content on the page should be analyzed"},"html-has-lang":{description:"Ensures every HTML document has a lang attribute",help:"<html> element must have a lang attribute"},"html-lang-valid":{description:"Ensures the lang attribute of the <html> element has a valid value",help:"<html> element must have a valid value for the lang attribute"},"html-xml-lang-mismatch":{description:"Ensure that HTML elements with both valid lang and xml:lang attributes agree on the base language of the page",help:"HTML elements with lang and xml:lang must have the same base language"},"identical-links-same-purpose":{description:"Ensure that links with the same accessible name serve a similar purpose",help:"Links with the same name mus\
t have a similar purpose"},"image-alt":{description:"Ensures <img> elements have alternate text or a role of none or presentation",help:"Images must have alternate text"},"image-redundant-alt":{description:"Ensure image alternative is not repeated as text",help:"Alternative text of images should not be repeated as text"},"input-button-name":{description:"Ensures input buttons have discernible text",help:"Input buttons must have discernible text"},"input-image-alt":{description:'Ensures <input type="image"> elements have alternate text',help:"Image buttons must have alternate text"},"label-content-name-mismatch":{description:"Ensures that elements labelled through their content must have their visible text as part of their accessible name",help:"Elements must have their visible text as part of their accessible name"},"label-title-only":{description:"Ensures that every form element has a visible label and is not solely labeled using hidden labels, or the title or aria-describedby attribu\
tes",help:"Form elements should have a visible label"},label:{description:"Ensures every form element has a label",help:"Form elements must have labels"},"landmark-banner-is-top-level":{description:"Ensures the banner landmark is at top level",help:"Banner landmark should not be contained in another landmark"},"landmark-complementary-is-top-level":{description:"Ensures the complementary landmark or aside is at top level",help:"Aside should not be contained in another landmark"},"landmark-contentinfo-is-top-level":{description:"Ensures the contentinfo landmark is at top level",help:"Contentinfo landmark should not be contained in another landmark"},"landmark-main-is-top-level":{description:"Ensures the main landmark is at top level",help:"Main landmark should not be contained in another landmark"},"landmark-no-duplicate-banner":{description:"Ensures the document has at most one banner landmark",help:"Document should not have more than one banner landmark"},"landmark-no-duplicate-content\
info":{description:"Ensures the document has at most one contentinfo landmark",help:"Document should not have more than one contentinfo landmark"},"landmark-no-duplicate-main":{description:"Ensures the document has at most one main landmark",help:"Document should not have more than one main landmark"},"landmark-one-main":{description:"Ensures the document has a main landmark",help:"Document should have one main landmark"},"landmark-unique":{help:"Ensures landmarks are unique",description:"Landmarks should have a unique role or role/label/title (i.e. accessible name) combination"},"link-in-text-block":{description:"Ensure links are distinguished from surrounding text in a way that does not rely on color",help:"Links must be distinguishable without relying on color"},"link-name":{description:"Ensures links have discernible text",help:"Links must have discernible text"},list:{description:"Ensures that lists are structured correctly",help:"<ul> and <ol> must only directly contain <li>, <sc\
ript> or <template> elements"},listitem:{description:"Ensures <li> elements are used semantically",help:"<li> elements must be contained in a <ul> or <ol>"},marquee:{description:"Ensures <marquee> elements are not used",help:"<marquee> elements are deprecated and must not be used"},"meta-refresh-no-exceptions":{description:'Ensures <meta http-equiv="refresh"> is not used for delayed refresh',help:"Delayed refresh must not be used"},"meta-refresh":{description:'Ensures <meta http-equiv="refresh"> is not used for delayed refresh',help:"Delayed refresh under 20 hours must not be used"},"meta-viewport-large":{description:'Ensures <meta name="viewport"> can scale a significant amount',help:"Users should be able to zoom and scale the text up to 500%"},"meta-viewport":{description:'Ensures <meta name="viewport"> does not disable text scaling and zooming',help:"Zooming and scaling must not be disabled"},"nested-interactive":{description:"Ensures interactive controls are not nested as they are \
not always announced by screen readers or can cause focus problems for assistive technologies",help:"Interactive controls must not be nested"},"no-autoplay-audio":{description:"Ensures <video> or <audio> elements do not autoplay audio for more than 3 seconds without a control mechanism to stop or mute the audio",help:"<video> or <audio> elements must not play automatically"},"object-alt":{description:"Ensures <object> elements have alternate text",help:"<object> elements must have alternate text"},"p-as-heading":{description:"Ensure bold, italic text and font-size is not used to style <p> elements as a heading",help:"Styled <p> elements must not be used as headings"},"page-has-heading-one":{description:"Ensure that the page, or at least one of its frames contains a level-one heading",help:"Page should contain a level-one heading"},"presentation-role-conflict":{description:"Elements marked as presentational should not have global ARIA or tabindex to ensure all screen readers ignore them\
",help:"Ensure elements marked as presentational are consistently ignored"},region:{description:"Ensures all page content is contained by landmarks",help:"All page content should be contained by landmarks"},"role-img-alt":{description:'Ensures [role="img"] elements have alternate text',help:'[role="img"] elements must have an alternative text'},"scope-attr-valid":{description:"Ensures the scope attribute is used correctly on tables",help:"scope attribute should be used correctly"},"scrollable-region-focusable":{description:"Ensure elements that have scrollable content are accessible by keyboard",help:"Scrollable region must have keyboard access"},"select-name":{description:"Ensures select element has an accessible name",help:"Select element must have an accessible name"},"server-side-image-map":{description:"Ensures that server-side image maps are not used",help:"Server-side image maps must not be used"},"skip-link":{description:"Ensure all skip links have a focusable target",help:"The\
 skip-link target should exist and be focusable"},"svg-img-alt":{description:"Ensures <svg> elements with an img, graphics-document or graphics-symbol role have an accessible text",help:"<svg> elements with an img role must have an alternative text"},tabindex:{description:"Ensures tabindex attribute values are not greater than 0",help:"Elements should not have tabindex greater than zero"},"table-duplicate-name":{description:"Ensure the <caption> element does not contain the same text as the summary attribute",help:"tables should not have the same summary and caption"},"table-fake-caption":{description:"Ensure that tables with a caption use the <caption> element.",help:"Data or header cells must not be used to give caption to a data table."},"target-size":{description:"Ensure touch target have sufficient size and space",help:"All touch targets must be 24px large, or leave sufficient space"},"td-has-header":{description:"Ensure that each non-empty data cell in a <table> larger than 3 by \
3  has one or more table headers",help:"Non-empty <td> elements in larger <table> must have an associated table header"},"td-headers-attr":{description:"Ensure that each cell in a table that uses the headers attribute refers only to other cells in that table",help:"Table cells that use the headers attribute must only refer to cells in the same table"},"th-has-data-cells":{description:"Ensure that <th> elements and elements with role=columnheader/rowheader have data cells they describe",help:"Table headers in a data table must refer to data cells"},"valid-lang":{description:"Ensures lang attributes have valid values",help:"lang attribute must have a valid value"},"video-caption":{description:"Ensures <video> elements have captions",help:"<video> elements must have captions"}},checks:{abstractrole:{impact:"serious",messages:{pass:"Abstract roles are not used",fail:{singular:"Abstract role cannot be directly used: \${data.values}",plural:"Abstract roles cannot be directly used: \${data.valu\
es}"}}},"aria-allowed-attr":{impact:"critical",messages:{pass:"ARIA attributes are used correctly for the defined role",fail:{singular:"ARIA attribute is not allowed: \${data.values}",plural:"ARIA attributes are not allowed: \${data.values}"},incomplete:"Check that there is no problem if the ARIA attribute is ignored on this element: \${data.values}"}},"aria-allowed-role":{impact:"minor",messages:{pass:"ARIA role is allowed for given element",fail:{singular:"ARIA role \${data.values} is not allowed for given element",plural:"ARIA roles \${data.values} are not allowed for given element"},incomplete:{singular:"ARIA role \${data.values} must be removed when the element is made visible, as it is not allowed for the element",plural:"ARIA roles \${data.values} must be removed when the element is made visible, as they are not allowed for the element"}}},"aria-busy":{impact:"serious",messages:{pass:"Element has an aria-busy attribute",fail:'Element uses aria-busy="true" while showing a loader'}},"ari\
a-conditional-attr":{impact:"serious",messages:{pass:"ARIA attribute is allowed",fail:{checkbox:'Remove aria-checked, or set it to "\${data.checkState}" to match the real checkbox state',rowSingular:"This attribute is supported with treegrid rows, but not \${data.ownerRole}: \${data.invalidAttrs}",rowPlural:"These attributes are supported with treegrid rows, but not \${data.ownerRole}: \${data.invalidAttrs}"}}},"aria-errormessage":{impact:"critical",messages:{pass:"aria-errormessage exists and references elements visible to screen readers that use a supported aria-errormessage technique",fail:{singular:"aria-errormessage value \`\${data.values}\` must use a technique to announce the message (e.g., aria-live, aria-describedby, role=alert, etc.)",plural:"aria-errormessage values \`\${data.values}\` must use a technique to announce the message (e.g., aria-live, aria-describedby, role=alert, etc.)",hidden:"aria-errormessage value \`\${data.values}\` cannot reference a hidden element"},incomplete:{singul\
ar:"ensure aria-errormessage value \`\${data.values}\` references an existing element",plural:"ensure aria-errormessage values \`\${data.values}\` reference existing elements",idrefs:"unable to determine if aria-errormessage element exists on the page: \${data.values}"}}},"aria-hidden-body":{impact:"critical",messages:{pass:"No aria-hidden attribute is present on document body",fail:"aria-hidden=true should not be present on the document body"}},"aria-level":{impact:"serious",messages:{pass:"aria-level values are valid",incomplete:"aria-level values greater than 6 are not supported in all screenreader and browser combinations"}},"aria-prohibited-attr":{impact:"serious",messages:{pass:"ARIA attribute is allowed",fail:{hasRolePlural:'\${data.prohibited} attributes cannot be used with role "\${data.role}".',hasRoleSingular:'\${data.prohibited} attribute cannot be used with role "\${data.role}".',noRolePlural:"\${data.prohibited} attributes cannot be used on a \${data.nodeName} with no valid role attri\
bute.",noRoleSingular:"\${data.prohibited} attribute cannot be used on a \${data.nodeName} with no valid role attribute."},incomplete:{hasRoleSingular:'\${data.prohibited} attribute is not well supported with role "\${data.role}".',hasRolePlural:'\${data.prohibited} attributes are not well supported with role "\${data.role}".',noRoleSingular:"\${data.prohibited} attribute is not well supported on a \${data.nodeName} with no valid role attribute.",noRolePlural:"\${data.prohibited} attributes are not well supported on a \${data.nodeName} with no valid role attribute."}}},"aria-required-attr":{impact:"critical",messages:{pass:"All required ARIA attributes are present",fail:{singular:"Required ARIA attribute not present: \${data.values}",plural:"Required ARIA attributes not present: \${data.values}"}}},"aria-required-children":{impact:"critical",messages:{pass:"Required ARIA children are present",fail:{singular:"Required ARIA child role not present: \${data.values}",plural:"Required ARIA children role \
not present: \${data.values}",unallowed:"Element has children which are not allowed: \${data.values}"},incomplete:{singular:"Expecting ARIA child role to be added: \${data.values}",plural:"Expecting ARIA children role to be added: \${data.values}"}}},"aria-required-parent":{impact:"critical",messages:{pass:"Required ARIA parent role present",fail:{singular:"Required ARIA parent role not present: \${data.values}",plural:"Required ARIA parents role not present: \${data.values}"}}},"aria-roledescription":{impact:"serious",messages:{pass:"aria-roledescription used on a supported semantic role",incomplete:"Check that the aria-roledescription is announced by supported screen readers",fail:"Give the element a role that supports aria-roledescription"}},"aria-unsupported-attr":{impact:"critical",messages:{pass:"ARIA attribute is supported",fail:"ARIA attribute is not widely supported in screen readers and assistive technologies: \${data.values}"}},"aria-valid-attr-value":{impact:"critical",messages:{p\
ass:"ARIA attribute values are valid",fail:{singular:"Invalid ARIA attribute value: \${data.values}",plural:"Invalid ARIA attribute values: \${data.values}"},incomplete:{noId:"ARIA attribute element ID does not exist on the page: \${data.needsReview}",noIdShadow:"ARIA attribute element ID does not exist on the page or is a descendant of a different shadow DOM tree: \${data.needsReview}",ariaCurrent:'ARIA attribute value is invalid and will be treated as "aria-current=true": \${data.needsReview}',idrefs:"Unable to determine if ARIA attribute element ID exists on the page: \${data.needsReview}",empty:"ARIA attribute value is ignored while empty: \${data.needsReview}"}}},"aria-valid-attr":{impact:"critical",messages:{pass:"ARIA attribute name is valid",fail:{singular:"Invalid ARIA attribute name: \${data.values}",plural:"Invalid ARIA attribute names: \${data.values}"}}},"braille-label-equivalent":{impact:"serious",messages:{pass:"aria-braillelabel is used on an element with accessible text",fail:"\
aria-braillelabel is used on an element with no accessible text",incomplete:"Unable to compute accessible text"}},"braille-roledescription-equivalent":{impact:"serious",messages:{pass:"aria-brailleroledescription is used on an element with aria-roledescription",fail:{noRoleDescription:"aria-brailleroledescription is used on an element with no aria-roledescription",emptyRoleDescription:"aria-brailleroledescription is used on an element with an empty aria-roledescription"}}},deprecatedrole:{impact:"minor",messages:{pass:"ARIA role is not deprecated",fail:"The role used is deprecated: \${data}"}},fallbackrole:{impact:"serious",messages:{pass:"Only one role value used",fail:"Use only one role value, since fallback roles are not supported in older browsers",incomplete:"Use only role 'presentation' or 'none' since they are synonymous."}},"has-global-aria-attribute":{impact:"minor",messages:{pass:{singular:"Element has global ARIA attribute: \${data.values}",plural:"Element has global ARIA attr\
ibutes: \${data.values}"},fail:"Element does not have global ARIA attribute"}},"has-widget-role":{impact:"minor",messages:{pass:"Element has a widget role.",fail:"Element does not have a widget role."}},invalidrole:{impact:"critical",messages:{pass:"ARIA role is valid",fail:{singular:"Role must be one of the valid ARIA roles: \${data.values}",plural:"Roles must be one of the valid ARIA roles: \${data.values}"}}},"is-element-focusable":{impact:"minor",messages:{pass:"Element is focusable.",fail:"Element is not focusable."}},"no-implicit-explicit-label":{impact:"serious",messages:{pass:"There is no mismatch between a <label> and accessible name",incomplete:"Check that the <label> does not need be part of the ARIA \${data} field's name"}},unsupportedrole:{impact:"critical",messages:{pass:"ARIA role is supported",fail:"The role used is not widely supported in screen readers and assistive technologies: \${data}"}},"valid-scrollable-semantics":{impact:"minor",messages:{pass:"Element has valid sem\
antics for an element in the focus order.",fail:"Element has invalid semantics for an element in the focus order."}},"color-contrast-enhanced":{impact:"serious",messages:{pass:"Element has sufficient color contrast of \${data.contrastRatio}",fail:{default:"Element has insufficient color contrast of \${data.contrastRatio} (foreground color: \${data.fgColor}, background color: \${data.bgColor}, font size: \${data.fontSize}, font weight: \${data.fontWeight}). Expected contrast ratio of \${data.expectedContrastRatio}",fgOnShadowColor:"Element has insufficient color contrast of \${data.contrastRatio} between the foreground and shadow color (foreground color: \${data.fgColor}, text-shadow color: \${data.shadowColor}, font size: \${data.fontSize}, font weight: \${data.fontWeight}). Expected contrast ratio of \${data.expectedContrastRatio}",shadowOnBgColor:"Element has insufficient color contrast of \${data.contrastRatio} between the shadow color and background color (text-shadow color: \${data.shadowColor},\
 background color: \${data.bgColor}, font size: \${data.fontSize}, font weight: \${data.fontWeight}). Expected contrast ratio of \${data.expectedContrastRatio}"},incomplete:{default:"Unable to determine contrast ratio",bgImage:"Element's background color could not be determined due to a background image",bgGradient:"Element's background color could not be determined due to a background gradient",imgNode:"Element's background color could not be determined because element contains an image node",bgOverlap:"Element's background color could not be determined because it is overlapped by another element",fgAlpha:"Element's foreground color could not be determined because of alpha transparency",elmPartiallyObscured:"Element's background color could not be determined because it's partially obscured by another element",elmPartiallyObscuring:"Element's background color could not be determined because it partially overlaps other elements",outsideViewport:"Element's background color could not be deter\
mined because it's outside the viewport",equalRatio:"Element has a 1:1 contrast ratio with the background",shortTextContent:"Element content is too short to determine if it is actual text content",nonBmp:"Element content contains only non-text characters",pseudoContent:"Element's background color could not be determined due to a pseudo element"}}},"color-contrast":{impact:"serious",messages:{pass:{default:"Element has sufficient color contrast of \${data.contrastRatio}",hidden:"Element is hidden"},fail:{default:"Element has insufficient color contrast of \${data.contrastRatio} (foreground color: \${data.fgColor}, background color: \${data.bgColor}, font size: \${data.fontSize}, font weight: \${data.fontWeight}). Expected contrast ratio of \${data.expectedContrastRatio}",fgOnShadowColor:"Element has insufficient color contrast of \${data.contrastRatio} between the foreground and shadow color (foreground color: \${data.fgColor}, text-shadow color: \${data.shadowColor}, font size: \${data.fontSize},\
 font weight: \${data.fontWeight}). Expected contrast ratio of \${data.expectedContrastRatio}",shadowOnBgColor:"Element has insufficient color contrast of \${data.contrastRatio} between the shadow color and background color (text-shadow color: \${data.shadowColor}, background color: \${data.bgColor}, font size: \${data.fontSize}, font weight: \${data.fontWeight}). Expected contrast ratio of \${data.expectedContrastRatio}"},incomplete:{default:"Unable to determine contrast ratio",bgImage:"Element's background color could not be determined due to a background image",bgGradient:"Element's background color could not be determined due to a background gradient",imgNode:"Element's background color could not be determined because element contains an image node",bgOverlap:"Element's background color could not be determined because it is overlapped by another element",complexTextShadows:"Element's contrast could not be determined because it uses complex text shadows",fgAlpha:"Element's foreground color \
could not be determined because of alpha transparency",elmPartiallyObscured:"Element's background color could not be determined because it's partially obscured by another element",elmPartiallyObscuring:"Element's background color could not be determined because it partially overlaps other elements",outsideViewport:"Element's background color could not be determined because it's outside the viewport",equalRatio:"Element has a 1:1 contrast ratio with the background",shortTextContent:"Element content is too short to determine if it is actual text content",nonBmp:"Element content contains only non-text characters",pseudoContent:"Element's background color could not be determined due to a pseudo element"}}},"link-in-text-block-style":{impact:"serious",messages:{pass:"Links can be distinguished from surrounding text by visual styling",incomplete:{default:"Check if the link needs styling to distinguish it from nearby text",pseudoContent:"Check if the link's pseudo style is sufficient to disti\
nguish it from the surrounding text"},fail:"The link has no styling (such as underline) to distinguish it from the surrounding text"}},"link-in-text-block":{impact:"serious",messages:{pass:"Links can be distinguished from surrounding text in some way other than by color",fail:{fgContrast:"The link has insufficient color contrast of \${data.contrastRatio}:1 with the surrounding text. (Minimum contrast is \${data.requiredContrastRatio}:1, link text: \${data.nodeColor}, surrounding text: \${data.parentColor})",bgContrast:"The link background has insufficient color contrast of \${data.contrastRatio} (Minimum contrast is \${data.requiredContrastRatio}:1, link background color: \${data.nodeBackgroundColor}, surrounding background color: \${data.parentBackgroundColor})"},incomplete:{default:"Element's foreground contrast ratio could not be determined",bgContrast:"Element's background contrast ratio could not be determined",bgImage:"Element's contrast ratio could not be determined due to a background \
image",bgGradient:"Element's contrast ratio could not be determined due to a background gradient",imgNode:"Element's contrast ratio could not be determined because element contains an image node",bgOverlap:"Element's contrast ratio could not be determined because of element overlap"}}},"autocomplete-appropriate":{impact:"serious",messages:{pass:"the autocomplete value is on an appropriate element",fail:"the autocomplete value is inappropriate for this type of input"}},"autocomplete-valid":{impact:"serious",messages:{pass:"the autocomplete attribute is correctly formatted",fail:"the autocomplete attribute is incorrectly formatted"}},accesskeys:{impact:"serious",messages:{pass:"Accesskey attribute value is unique",fail:"Document has multiple elements with the same accesskey"}},"focusable-content":{impact:"serious",messages:{pass:"Element contains focusable elements",fail:"Element should have focusable content"}},"focusable-disabled":{impact:"serious",messages:{pass:"No focusable elements\
 contained within element",incomplete:"Check if the focusable elements immediately move the focus indicator",fail:"Focusable content should be disabled or be removed from the DOM"}},"focusable-element":{impact:"serious",messages:{pass:"Element is focusable",fail:"Element should be focusable"}},"focusable-modal-open":{impact:"serious",messages:{pass:"No focusable elements while a modal is open",incomplete:"Check that focusable elements are not tabbable in the current state"}},"focusable-no-name":{impact:"serious",messages:{pass:"Element is not in tab order or has accessible text",fail:"Element is in tab order and does not have accessible text",incomplete:"Unable to determine if element has an accessible name"}},"focusable-not-tabbable":{impact:"serious",messages:{pass:"No focusable elements contained within element",incomplete:"Check if the focusable elements immediately move the focus indicator",fail:'Focusable content should have tabindex="-1" or be removed from the DOM'}},"frame-focu\
sable-content":{impact:"serious",messages:{pass:"Element does not have focusable descendants",fail:"Element has focusable descendants",incomplete:"Could not determine if element has descendants"}},"landmark-is-top-level":{impact:"moderate",messages:{pass:"The \${data.role} landmark is at the top level.",fail:"The \${data.role} landmark is contained in another landmark."}},"no-focusable-content":{impact:"serious",messages:{pass:"Element does not have focusable descendants",fail:{default:"Element has focusable descendants",notHidden:'Using a negative tabindex on an element inside an interactive control does not prevent assistive technologies from focusing the element (even with aria-hidden="true")'},incomplete:"Could not determine if element has descendants"}},"page-has-heading-one":{impact:"moderate",messages:{pass:"Page has at least one level-one heading",fail:"Page must have a level-one heading"}},"page-has-main":{impact:"moderate",messages:{pass:"Document has at least one main landmark\
",fail:"Document does not have a main landmark"}},"page-no-duplicate-banner":{impact:"moderate",messages:{pass:"Document does not have more than one banner landmark",fail:"Document has more than one banner landmark"}},"page-no-duplicate-contentinfo":{impact:"moderate",messages:{pass:"Document does not have more than one contentinfo landmark",fail:"Document has more than one contentinfo landmark"}},"page-no-duplicate-main":{impact:"moderate",messages:{pass:"Document does not have more than one main landmark",fail:"Document has more than one main landmark"}},tabindex:{impact:"serious",messages:{pass:"Element does not have a tabindex greater than 0",fail:"Element has a tabindex greater than 0"}},"alt-space-value":{impact:"critical",messages:{pass:"Element has a valid alt attribute value",fail:"Element has an alt attribute containing only a space character, which is not ignored by all screen readers"}},"duplicate-img-label":{impact:"minor",messages:{pass:"Element does not duplicate existin\
g text in <img> alt text",fail:"Element contains <img> element with alt text that duplicates existing text"}},"explicit-label":{impact:"critical",messages:{pass:"Form element has an explicit <label>",fail:"Form element does not have an explicit <label>",incomplete:"Unable to determine if form element has an explicit <label>"}},"help-same-as-label":{impact:"minor",messages:{pass:"Help text (title or aria-describedby) does not duplicate label text",fail:"Help text (title or aria-describedby) text is the same as the label text"}},"hidden-explicit-label":{impact:"critical",messages:{pass:"Form element has a visible explicit <label>",fail:"Form element has explicit <label> that is hidden",incomplete:"Unable to determine if form element has explicit <label> that is hidden"}},"implicit-label":{impact:"critical",messages:{pass:"Form element has an implicit (wrapped) <label>",fail:"Form element does not have an implicit (wrapped) <label>",incomplete:"Unable to determine if form element has an i\
mplicit (wrapped} <label>"}},"label-content-name-mismatch":{impact:"serious",messages:{pass:"Element contains visible text as part of it's accessible name",fail:"Text inside the element is not included in the accessible name"}},"multiple-label":{impact:"moderate",messages:{pass:"Form field does not have multiple label elements",incomplete:"Multiple label elements is not widely supported in assistive technologies. Ensure the first label contains all necessary information."}},"title-only":{impact:"serious",messages:{pass:"Form element does not solely use title attribute for its label",fail:"Only title used to generate label for form element"}},"landmark-is-unique":{impact:"moderate",messages:{pass:"Landmarks must have a unique role or role/label/title (i.e. accessible name) combination",fail:"The landmark must have a unique aria-label, aria-labelledby, or title to make landmarks distinguishable"}},"has-lang":{impact:"serious",messages:{pass:"The <html> element has a lang attribute",fail:\
{noXHTML:"The xml:lang attribute is not valid on HTML pages, use the lang attribute.",noLang:"The <html> element does not have a lang attribute"}}},"valid-lang":{impact:"serious",messages:{pass:"Value of lang attribute is included in the list of valid languages",fail:"Value of lang attribute not included in the list of valid languages"}},"xml-lang-mismatch":{impact:"moderate",messages:{pass:"Lang and xml:lang attributes have the same base language",fail:"Lang and xml:lang attributes do not have the same base language"}},dlitem:{impact:"serious",messages:{pass:"Description list item has a <dl> parent element",fail:"Description list item does not have a <dl> parent element"}},listitem:{impact:"serious",messages:{pass:'List item has a <ul>, <ol> or role="list" parent element',fail:{default:"List item does not have a <ul>, <ol> parent element",roleNotValid:'List item does not have a <ul>, <ol> parent element without a role, or a role="list"'}}},"only-dlitems":{impact:"serious",messages:{pa\
ss:"dl element only has direct children that are allowed inside; <dt>, <dd>, or <div> elements",fail:"dl element has direct children that are not allowed: \${data.values}"}},"only-listitems":{impact:"serious",messages:{pass:"List element only has direct children that are allowed inside <li> elements",fail:"List element has direct children that are not allowed: \${data.values}"}},"structured-dlitems":{impact:"serious",messages:{pass:"When not empty, element has both <dt> and <dd> elements",fail:"When not empty, element does not have at least one <dt> element followed by at least one <dd> element"}},caption:{impact:"critical",messages:{pass:"The multimedia element has a captions track",incomplete:"Check that captions is available for the element"}},"frame-tested":{impact:"critical",messages:{pass:"The iframe was tested with axe-core",fail:"The iframe could not be tested with axe-core",incomplete:"The iframe still has to be tested with axe-core"}},"no-autoplay-audio":{impact:"moderate",mess\
ages:{pass:"<video> or <audio> does not output audio for more than allowed duration or has controls mechanism",fail:"<video> or <audio> outputs audio for more than allowed duration and does not have a controls mechanism",incomplete:"Check that the <video> or <audio> does not output audio for more than allowed duration or provides a controls mechanism"}},"css-orientation-lock":{impact:"serious",messages:{pass:"Display is operable, and orientation lock does not exist",fail:"CSS Orientation lock is applied, and makes display inoperable",incomplete:"CSS Orientation lock cannot be determined"}},"meta-viewport-large":{impact:"minor",messages:{pass:"<meta> tag does not prevent significant zooming on mobile devices",fail:"<meta> tag limits zooming on mobile devices"}},"meta-viewport":{impact:"critical",messages:{pass:"<meta> tag does not disable zooming on mobile devices",fail:"\${data} on <meta> tag disables zooming on mobile devices"}},"target-offset":{impact:"serious",messages:{pass:"Target \
has sufficient space from its closest neighbors. Safe clickable space has a diameter of \${data.closestOffset}px which is at least \${data.minOffset}px.",fail:"Target has insufficient space to its closest neighbors. Safe clickable space has a diameter of \${data.closestOffset}px instead of at least \${data.minOffset}px.",incomplete:{default:"Element with negative tabindex has insufficient space to its closest neighbors. Safe clickable space has a diameter of \${data.closestOffset}px instead of at least \${data.minOffset}px. Is this a target?",nonTabbableNeighbor:"Target has insufficient space to its closest neighbors. Safe clickable space has a diameter of \${data.closestOffset}px instead of at least \${data.minOffset}px. Is the neighbor a target?"}}},"target-size":{impact:"serious",messages:{pass:{default:"Control has sufficient size (\${data.width}px by \${data.height}px, should be at least \${data.minSize}px by \${data.minSize}px)",obscured:"Control is ignored because it is fully obscured and t\
hus not clickable"},fail:{default:"Target has insufficient size (\${data.width}px by \${data.height}px, should be at least \${data.minSize}px by \${data.minSize}px)",partiallyObscured:"Target has insufficient size because it is partially obscured (smallest space is \${data.width}px by \${data.height}px, should be at least \${data.minSize}px by \${data.minSize}px)"},incomplete:{default:"Element with negative tabindex has insufficient size (\${data.width}px by \${data.height}px, should be at least \${data.minSize}px by \${data.minSize}px). Is this a target?",contentOverflow:"Element size could not be accurately determined due to overflow content",partiallyObscured:"Element with negative tabindex has insufficient size because it is partially obscured (smallest space is \${data.width}px by \${data.height}px, should be at least \${data.minSize}px by \${data.minSize}px). Is this a target?",partiallyObscuredNonTabbable:"Target has insufficient size because it is partially obscured by a neighbor with negative\
 tabindex (smallest space is \${data.width}px by \${data.height}px, should be at least \${data.minSize}px by \${data.minSize}px). Is the neighbor a target?"}}},"header-present":{impact:"serious",messages:{pass:"Page has a heading",fail:"Page does not have a heading"}},"heading-order":{impact:"moderate",messages:{pass:"Heading order valid",fail:"Heading order invalid",incomplete:"Unable to determine previous heading"}},"identical-links-same-purpose":{impact:"minor",messages:{pass:"There are no other links with the same name, that go to a different URL",incomplete:"Check that links have the same purpose, or are intentionally ambiguous."}},"internal-link-present":{impact:"serious",messages:{pass:"Valid skip link found",fail:"No valid skip link found"}},landmark:{impact:"serious",messages:{pass:"Page has a landmark region",fail:"Page does not have a landmark region"}},"meta-refresh-no-exceptions":{impact:"minor",messages:{pass:"<meta> tag does not immediately refresh the page",fail:"<meta> tag\
 forces timed refresh of page"}},"meta-refresh":{impact:"critical",messages:{pass:"<meta> tag does not immediately refresh the page",fail:"<meta> tag forces timed refresh of page (less than 20 hours)"}},"p-as-heading":{impact:"serious",messages:{pass:"<p> elements are not styled as headings",fail:"Heading elements should be used instead of styled <p> elements",incomplete:"Unable to determine if <p> elements are styled as headings"}},region:{impact:"moderate",messages:{pass:"All page content is contained by landmarks",fail:"Some page content is not contained by landmarks"}},"skip-link":{impact:"moderate",messages:{pass:"Skip link target exists",incomplete:"Skip link target should become visible on activation",fail:"No skip link target"}},"unique-frame-title":{impact:"serious",messages:{pass:"Element's title attribute is unique",fail:"Element's title attribute is not unique"}},"duplicate-id-active":{impact:"serious",messages:{pass:"Document has no active elements that share the same id a\
ttribute",fail:"Document has active elements with the same id attribute: \${data}"}},"duplicate-id-aria":{impact:"critical",messages:{pass:"Document has no elements referenced with ARIA or labels that share the same id attribute",fail:"Document has multiple elements referenced with ARIA with the same id attribute: \${data}"}},"duplicate-id":{impact:"minor",messages:{pass:"Document has no static elements that share the same id attribute",fail:"Document has multiple static elements with the same id attribute: \${data}"}},"aria-label":{impact:"serious",messages:{pass:"aria-label attribute exists and is not empty",fail:"aria-label attribute does not exist or is empty"}},"aria-labelledby":{impact:"serious",messages:{pass:"aria-labelledby attribute exists and references elements that are visible to screen readers",fail:"aria-labelledby attribute does not exist, references elements that do not exist or references elements that are empty",incomplete:"ensure aria-labelledby references an existing \
element"}},"avoid-inline-spacing":{impact:"serious",messages:{pass:"No inline styles with '!important' that affect text spacing has been specified",fail:{singular:"Remove '!important' from inline style \${data.values}, as overriding this is not supported by most browsers",plural:"Remove '!important' from inline styles \${data.values}, as overriding this is not supported by most browsers"}}},"button-has-visible-text":{impact:"critical",messages:{pass:"Element has inner text that is visible to screen readers",fail:"Element does not have inner text that is visible to screen readers",incomplete:"Unable to determine if element has children"}},"doc-has-title":{impact:"serious",messages:{pass:"Document has a non-empty <title> element",fail:"Document does not have a non-empty <title> element"}},exists:{impact:"minor",messages:{pass:"Element does not exist",incomplete:"Element exists"}},"has-alt":{impact:"critical",messages:{pass:"Element has an alt attribute",fail:"Element does not have an alt a\
ttribute"}},"has-visible-text":{impact:"minor",messages:{pass:"Element has text that is visible to screen readers",fail:"Element does not have text that is visible to screen readers",incomplete:"Unable to determine if element has children"}},"important-letter-spacing":{impact:"serious",messages:{pass:"Letter-spacing in the style attribute is not set to !important, or meets the minimum",fail:"letter-spacing in the style attribute must not use !important, or be at \${data.minValue}em (current \${data.value}em)"}},"important-line-height":{impact:"serious",messages:{pass:"line-height in the style attribute is not set to !important, or meets the minimum",fail:"line-height in the style attribute must not use !important, or be at \${data.minValue}em (current \${data.value}em)"}},"important-word-spacing":{impact:"serious",messages:{pass:"word-spacing in the style attribute is not set to !important, or meets the minimum",fail:"word-spacing in the style attribute must not use !important, or be at \${\
data.minValue}em (current \${data.value}em)"}},"is-on-screen":{impact:"serious",messages:{pass:"Element is not visible",fail:"Element is visible"}},"non-empty-alt":{impact:"critical",messages:{pass:"Element has a non-empty alt attribute",fail:{noAttr:"Element has no alt attribute",emptyAttr:"Element has an empty alt attribute"}}},"non-empty-if-present":{impact:"critical",messages:{pass:{default:"Element does not have a value attribute","has-label":"Element has a non-empty value attribute"},fail:"Element has a value attribute and the value attribute is empty"}},"non-empty-placeholder":{impact:"serious",messages:{pass:"Element has a placeholder attribute",fail:{noAttr:"Element has no placeholder attribute",emptyAttr:"Element has an empty placeholder attribute"}}},"non-empty-title":{impact:"serious",messages:{pass:"Element has a title attribute",fail:{noAttr:"Element has no title attribute",emptyAttr:"Element has an empty title attribute"}}},"non-empty-value":{impact:"critical",messages:{p\
ass:"Element has a non-empty value attribute",fail:{noAttr:"Element has no value attribute",emptyAttr:"Element has an empty value attribute"}}},"presentational-role":{impact:"minor",messages:{pass:'Element\\'s default semantics were overriden with role="\${data.role}"',fail:{default:'Element\\'s default semantics were not overridden with role="none" or role="presentation"',globalAria:"Element's role is not presentational because it has a global ARIA attribute",focusable:"Element's role is not presentational because it is focusable",both:"Element's role is not presentational because it has a global ARIA attribute and is focusable",iframe:'Using the "title" attribute on an \${data.nodeName} element with a presentational role behaves inconsistently between screen readers'}}},"role-none":{impact:"minor",messages:{pass:'Element\\'s default semantics were overriden with role="none"',fail:'Element\\'s default semantics were not overridden with role="none"'}},"role-presentation":{impact:"minor",mess\
ages:{pass:'Element\\'s default semantics were overriden with role="presentation"',fail:'Element\\'s default semantics were not overridden with role="presentation"'}},"svg-non-empty-title":{impact:"serious",messages:{pass:"Element has a child that is a title",fail:{noTitle:"Element has no child that is a title",emptyTitle:"Element child title is empty"},incomplete:"Unable to determine element has a child that is a title"}},"caption-faked":{impact:"serious",messages:{pass:"The first row of a table is not used as a caption",fail:"The first child of the table should be a caption instead of a table cell"}},"html5-scope":{impact:"moderate",messages:{pass:"Scope attribute is only used on table header elements (<th>)",fail:"In HTML 5, scope attributes may only be used on table header elements (<th>)"}},"same-caption-summary":{impact:"minor",messages:{pass:"Content of summary attribute and <caption> are not duplicated",fail:"Content of summary attribute and <caption> element are identical",incom\
plete:"Unable to determine if <table> element has a caption"}},"scope-value":{impact:"critical",messages:{pass:"Scope attribute is used correctly",fail:"The value of the scope attribute may only be 'row' or 'col'"}},"td-has-header":{impact:"critical",messages:{pass:"All non-empty data cells have table headers",fail:"Some non-empty data cells do not have table headers"}},"td-headers-attr":{impact:"serious",messages:{pass:"The headers attribute is exclusively used to refer to other cells in the table",incomplete:"The headers attribute is empty",fail:"The headers attribute is not exclusively used to refer to other cells in the table"}},"th-has-data-cells":{impact:"serious",messages:{pass:"All table header cells refer to data cells",fail:"Not all table header cells refer to data cells",incomplete:"Table data cells are missing or empty"}},"hidden-content":{impact:"minor",messages:{pass:"All content on the page has been analyzed.",fail:"There were problems analyzing the content on this page.\
",incomplete:"There is hidden content on the page that was not analyzed. You will need to trigger the display of this content in order to analyze it."}}},failureSummaries:{any:{failureMessage:function(e){var t="Fix any of the following:",n=e;if(n)for(var r=-1,a=n.length-1;r<a;)t+="\\n  "+n[r+=1].split("\\n").join("\\n  ");return t}},none:{failureMessage:function(e){var t="Fix all of the following:",n=e;if(n)for(var r=-1,a=n.length-1;r<a;)t+="\\n  "+n[r+=1].split("\\n").join("\\n  ");return t}}},incompleteFallbackMessage:"axe couldn't tell the reason. Time to break out the element inspector!"},rules:[{id:"accesskeys",impact:"serious",selector:"[accesskey]",excludeHidden:!1,tags:["cat.keyboard","best-practice"],all:[],any:[],none:["accesskeys"]},{id:"area-alt",impact:"critical",selector:"map area[href]",excludeHidden:!1,tags:["cat.text-alternatives","wcag2a","wcag244","wcag412","section508","section508.22.a","TTv5","TT6.a","EN-301-549","EN-9.2.4.4","EN-9.4.1.2","ACT"],actIds:["c487ae"],all:[],\
any:[{options:{attribute:"alt"},id:"non-empty-alt"},"aria-label","aria-labelledby",{options:{attribute:"title"},id:"non-empty-title"}],none:[]},{id:"aria-allowed-attr",impact:"critical",matches:"aria-allowed-attr-matches",tags:["cat.aria","wcag2a","wcag412","EN-301-549","EN-9.4.1.2"],actIds:["5c01ea"],all:[{options:{validTreeRowAttrs:["aria-posinset","aria-setsize","aria-expanded","aria-level"]},id:"aria-allowed-attr"}],any:[],none:["aria-unsupported-attr"]},{id:"aria-allowed-role",impact:"minor",excludeHidden:!1,selector:"[role]",matches:"aria-allowed-role-matches",tags:["cat.aria","best-practice"],all:[],any:[{options:{allowImplicit:!0,ignoredTags:[]},id:"aria-allowed-role"}],none:[]},{id:"aria-braille-equivalent",reviewOnFail:!0,impact:"serious",selector:"[aria-brailleroledescription], [aria-braillelabel]",tags:["cat.aria","wcag2a","wcag412","EN-301-549","EN-9.4.1.2"],all:["braille-roledescription-equivalent","braille-label-equivalent"],any:[],none:[]},{id:"aria-command-name",impact\
:"serious",selector:'[role="link"], [role="button"], [role="menuitem"]',matches:"no-naming-method-matches",tags:["cat.aria","wcag2a","wcag412","TTv5","TT6.a","EN-301-549","EN-9.4.1.2","ACT"],actIds:["97a4e1"],all:[],any:["has-visible-text","aria-label","aria-labelledby",{options:{attribute:"title"},id:"non-empty-title"}],none:[]},{id:"aria-conditional-attr",impact:"serious",matches:"aria-allowed-attr-matches",tags:["cat.aria","wcag2a","wcag412","EN-301-549","EN-9.4.1.2"],actIds:["5c01ea"],all:[{options:{invalidTableRowAttrs:["aria-posinset","aria-setsize","aria-expanded","aria-level"]},id:"aria-conditional-attr"}],any:[],none:[]},{id:"aria-deprecated-role",impact:"minor",selector:"[role]",matches:"no-empty-role-matches",tags:["cat.aria","wcag2a","wcag412","EN-301-549","EN-9.4.1.2"],actIds:["674b10"],all:[],any:[],none:["deprecatedrole"]},{id:"aria-dialog-name",impact:"serious",selector:'[role="dialog"], [role="alertdialog"]',matches:"no-naming-method-matches",tags:["cat.aria","best-pra\
ctice"],all:[],any:["aria-label","aria-labelledby",{options:{attribute:"title"},id:"non-empty-title"}],none:[]},{id:"aria-hidden-body",impact:"critical",selector:"body",excludeHidden:!1,matches:"is-initiator-matches",tags:["cat.aria","wcag2a","wcag412","EN-301-549","EN-9.4.1.2"],all:[],any:["aria-hidden-body"],none:[]},{id:"aria-hidden-focus",impact:"serious",selector:'[aria-hidden="true"]',matches:"aria-hidden-focus-matches",excludeHidden:!1,tags:["cat.name-role-value","wcag2a","wcag412","TTv5","TT6.a","EN-301-549","EN-9.4.1.2"],actIds:["6cfa84"],all:["focusable-modal-open","focusable-disabled","focusable-not-tabbable"],any:[],none:[]},{id:"aria-input-field-name",impact:"serious",selector:'[role="combobox"], [role="listbox"], [role="searchbox"], [role="slider"], [role="spinbutton"], [role="textbox"]',matches:"no-naming-method-matches",tags:["cat.aria","wcag2a","wcag412","TTv5","TT5.c","EN-301-549","EN-9.4.1.2","ACT"],actIds:["e086e5"],all:[],any:["aria-label","aria-labelledby",{option\
s:{attribute:"title"},id:"non-empty-title"}],none:["no-implicit-explicit-label"]},{id:"aria-meter-name",impact:"serious",selector:'[role="meter"]',matches:"no-naming-method-matches",tags:["cat.aria","wcag2a","wcag111","EN-301-549","EN-9.1.1.1"],all:[],any:["aria-label","aria-labelledby",{options:{attribute:"title"},id:"non-empty-title"}],none:[]},{id:"aria-progressbar-name",impact:"serious",selector:'[role="progressbar"]',matches:"no-naming-method-matches",tags:["cat.aria","wcag2a","wcag111","EN-301-549","EN-9.1.1.1"],all:[],any:["aria-label","aria-labelledby",{options:{attribute:"title"},id:"non-empty-title"}],none:[]},{id:"aria-prohibited-attr",impact:"serious",matches:"aria-allowed-attr-matches",tags:["cat.aria","wcag2a","wcag412","EN-301-549","EN-9.4.1.2"],actIds:["5c01ea"],all:[],any:[],none:[{options:{elementsAllowedAriaLabel:["applet","input"]},id:"aria-prohibited-attr"}]},{id:"aria-required-attr",impact:"critical",selector:"[role]",tags:["cat.aria","wcag2a","wcag412","EN-301-54\
9","EN-9.4.1.2"],actIds:["4e8ab6"],all:[],any:["aria-required-attr"],none:[]},{id:"aria-required-children",impact:"critical",selector:"[role]",matches:"aria-required-children-matches",tags:["cat.aria","wcag2a","wcag131","EN-301-549","EN-9.1.3.1"],actIds:["bc4a75","ff89c9"],all:[],any:[{options:{reviewEmpty:["doc-bibliography","doc-endnotes","grid","list","listbox","menu","menubar","table","tablist","tree","treegrid","rowgroup"]},id:"aria-required-children"},"aria-busy"],none:[]},{id:"aria-required-parent",impact:"critical",selector:"[role]",matches:"aria-required-parent-matches",tags:["cat.aria","wcag2a","wcag131","EN-301-549","EN-9.1.3.1"],actIds:["ff89c9"],all:[],any:[{options:{ownGroupRoles:["listitem","treeitem"]},id:"aria-required-parent"}],none:[]},{id:"aria-roledescription",impact:"serious",selector:"[aria-roledescription]",tags:["cat.aria","wcag2a","wcag412","EN-301-549","EN-9.4.1.2","deprecated"],enabled:!1,all:[],any:[{options:{supportedRoles:["button","img","checkbox","radio\
","combobox","menuitemcheckbox","menuitemradio"]},id:"aria-roledescription"}],none:[]},{id:"aria-roles",impact:"critical",selector:"[role]",matches:"no-empty-role-matches",tags:["cat.aria","wcag2a","wcag412","EN-301-549","EN-9.4.1.2"],actIds:["674b10"],all:[],any:[],none:["invalidrole","abstractrole","unsupportedrole"]},{id:"aria-text",impact:"serious",selector:"[role=text]",tags:["cat.aria","best-practice"],all:[],any:["no-focusable-content"],none:[]},{id:"aria-toggle-field-name",impact:"serious",selector:'[role="checkbox"], [role="menuitemcheckbox"], [role="menuitemradio"], [role="radio"], [role="switch"], [role="option"]',matches:"no-naming-method-matches",tags:["cat.aria","wcag2a","wcag412","TTv5","TT5.c","EN-301-549","EN-9.4.1.2","ACT"],actIds:["e086e5"],all:[],any:["has-visible-text","aria-label","aria-labelledby",{options:{attribute:"title"},id:"non-empty-title"}],none:["no-implicit-explicit-label"]},{id:"aria-tooltip-name",impact:"serious",selector:'[role="tooltip"]',matches:"n\
o-naming-method-matches",tags:["cat.aria","wcag2a","wcag412","EN-301-549","EN-9.4.1.2"],all:[],any:["has-visible-text","aria-label","aria-labelledby",{options:{attribute:"title"},id:"non-empty-title"}],none:[]},{id:"aria-treeitem-name",impact:"serious",selector:'[role="treeitem"]',matches:"no-naming-method-matches",tags:["cat.aria","best-practice"],all:[],any:["has-visible-text","aria-label","aria-labelledby",{options:{attribute:"title"},id:"non-empty-title"}],none:[]},{id:"aria-valid-attr-value",impact:"critical",matches:"aria-has-attr-matches",tags:["cat.aria","wcag2a","wcag412","EN-301-549","EN-9.4.1.2"],actIds:["6a7281"],all:[{options:[],id:"aria-valid-attr-value"},"aria-errormessage","aria-level"],any:[],none:[]},{id:"aria-valid-attr",impact:"critical",matches:"aria-has-attr-matches",tags:["cat.aria","wcag2a","wcag412","EN-301-549","EN-9.4.1.2"],actIds:["5f99a7"],all:[],any:[{options:[],id:"aria-valid-attr"}],none:[]},{id:"audio-caption",impact:"critical",selector:"audio",enabled:\
!1,excludeHidden:!1,tags:["cat.time-and-media","wcag2a","wcag121","EN-301-549","EN-9.1.2.1","section508","section508.22.a","deprecated"],actIds:["2eb176","afb423"],all:[],any:[],none:["caption"]},{id:"autocomplete-valid",impact:"serious",matches:"autocomplete-matches",tags:["cat.forms","wcag21aa","wcag135","EN-301-549","EN-9.1.3.5","ACT"],actIds:["73f2c2"],all:[{options:{stateTerms:["none","false","true","disabled","enabled","undefined","null"]},id:"autocomplete-valid"}],any:[],none:[]},{id:"avoid-inline-spacing",impact:"serious",selector:"[style]",matches:"is-visible-on-screen-matches",tags:["cat.structure","wcag21aa","wcag1412","EN-301-549","EN-9.1.4.12","ACT"],actIds:["24afc2","9e45ec","78fd32"],all:[{options:{cssProperty:"letter-spacing",minValue:.12},id:"important-letter-spacing"},{options:{cssProperty:"word-spacing",minValue:.16},id:"important-word-spacing"},{options:{multiLineOnly:!0,cssProperty:"line-height",minValue:1.5,normalValue:1},id:"important-line-height"}],any:[],none:[\
]},{id:"blink",impact:"serious",selector:"blink",excludeHidden:!1,tags:["cat.time-and-media","wcag2a","wcag222","section508","section508.22.j","TTv5","TT2.b","EN-301-549","EN-9.2.2.2"],all:[],any:[],none:["is-on-screen"]},{id:"button-name",impact:"critical",selector:"button",matches:"no-explicit-name-required-matches",tags:["cat.name-role-value","wcag2a","wcag412","section508","section508.22.a","TTv5","TT6.a","EN-301-549","EN-9.4.1.2","ACT"],actIds:["97a4e1","m6b1q3"],all:[],any:["button-has-visible-text","aria-label","aria-labelledby",{options:{attribute:"title"},id:"non-empty-title"},"presentational-role"],none:[]},{id:"bypass",impact:"serious",selector:"html",pageLevel:!0,matches:"bypass-matches",reviewOnFail:!0,tags:["cat.keyboard","wcag2a","wcag241","section508","section508.22.o","TTv5","TT9.a","EN-301-549","EN-9.2.4.1"],actIds:["cf77f2","047fe0","b40fd1","3e12e1","ye5d6e"],all:[],any:["internal-link-present",{options:{selector:":is(h1, h2, h3, h4, h5, h6):not([role]), [role=headi\
ng]"},id:"header-present"},{options:{selector:"main, [role=main]"},id:"landmark"}],none:[]},{id:"color-contrast-enhanced",impact:"serious",matches:"color-contrast-matches",excludeHidden:!1,enabled:!1,tags:["cat.color","wcag2aaa","wcag146","ACT"],actIds:["09o5cg"],all:[],any:[{options:{ignoreUnicode:!0,ignoreLength:!1,ignorePseudo:!1,boldValue:700,boldTextPt:14,largeTextPt:18,contrastRatio:{normal:{expected:7,minThreshold:4.5},large:{expected:4.5,minThreshold:3}},pseudoSizeThreshold:.25,shadowOutlineEmMax:.1,textStrokeEmMin:.03},id:"color-contrast-enhanced"}],none:[]},{id:"color-contrast",impact:"serious",matches:"color-contrast-matches",excludeHidden:!1,tags:["cat.color","wcag2aa","wcag143","TTv5","TT13.c","EN-301-549","EN-9.1.4.3","ACT"],actIds:["afw4f7","09o5cg"],all:[],any:[{options:{ignoreUnicode:!0,ignoreLength:!1,ignorePseudo:!1,boldValue:700,boldTextPt:14,largeTextPt:18,contrastRatio:{normal:{expected:4.5},large:{expected:3}},pseudoSizeThreshold:.25,shadowOutlineEmMax:.2,textStr\
okeEmMin:.03},id:"color-contrast"}],none:[]},{id:"css-orientation-lock",impact:"serious",selector:"html",tags:["cat.structure","wcag134","wcag21aa","EN-301-549","EN-9.1.3.4","experimental"],actIds:["b33eff"],all:[{options:{degreeThreshold:2},id:"css-orientation-lock"}],any:[],none:[],preload:!0},{id:"definition-list",impact:"serious",selector:"dl",matches:"no-role-matches",tags:["cat.structure","wcag2a","wcag131","EN-301-549","EN-9.1.3.1"],all:[],any:[],none:["structured-dlitems",{options:{validRoles:["definition","term","listitem"],validNodeNames:["dt","dd"],divGroups:!0},id:"only-dlitems"}]},{id:"dlitem",impact:"serious",selector:"dd, dt",matches:"no-role-matches",tags:["cat.structure","wcag2a","wcag131","EN-301-549","EN-9.1.3.1"],all:[],any:["dlitem"],none:[]},{id:"document-title",impact:"serious",selector:"html",matches:"is-initiator-matches",tags:["cat.text-alternatives","wcag2a","wcag242","TTv5","TT12.a","EN-301-549","EN-9.2.4.2","ACT"],actIds:["2779a5"],all:[],any:["doc-has-titl\
e"],none:[]},{id:"duplicate-id-active",impact:"serious",selector:"[id]",matches:"duplicate-id-active-matches",excludeHidden:!1,tags:["cat.parsing","wcag2a-obsolete","wcag411","deprecated"],enabled:!1,actIds:["3ea0c8"],all:[],any:["duplicate-id-active"],none:[]},{id:"duplicate-id-aria",impact:"critical",selector:"[id]",matches:"duplicate-id-aria-matches",excludeHidden:!1,tags:["cat.parsing","wcag2a","wcag412","EN-301-549","EN-9.4.1.2"],reviewOnFail:!0,actIds:["3ea0c8"],all:[],any:["duplicate-id-aria"],none:[]},{id:"duplicate-id",impact:"minor",selector:"[id]",matches:"duplicate-id-misc-matches",excludeHidden:!1,tags:["cat.parsing","wcag2a-obsolete","wcag411","deprecated"],enabled:!1,actIds:["3ea0c8"],all:[],any:["duplicate-id"],none:[]},{id:"empty-heading",impact:"minor",selector:'h1, h2, h3, h4, h5, h6, [role="heading"]',matches:"heading-matches",tags:["cat.name-role-value","best-practice"],actIds:["ffd0e9"],all:[],any:["has-visible-text","aria-label","aria-labelledby",{options:{attrib\
ute:"title"},id:"non-empty-title"}],none:[]},{id:"empty-table-header",impact:"minor",selector:'th:not([role]), [role="rowheader"], [role="columnheader"]',tags:["cat.name-role-value","best-practice"],all:[],any:["has-visible-text"],none:[]},{id:"focus-order-semantics",impact:"minor",selector:"div, h1, h2, h3, h4, h5, h6, [role=heading], p, span",matches:"inserted-into-focus-order-matches",tags:["cat.keyboard","best-practice","experimental"],all:[],any:[{options:[],id:"has-widget-role"},{options:{roles:["tooltip"]},id:"valid-scrollable-semantics"}],none:[]},{id:"form-field-multiple-labels",impact:"moderate",selector:"input, select, textarea",matches:"label-matches",tags:["cat.forms","wcag2a","wcag332","TTv5","TT5.c","EN-301-549","EN-9.3.3.2"],all:[],any:[],none:["multiple-label"]},{id:"frame-focusable-content",impact:"serious",selector:"html",matches:"frame-focusable-content-matches",tags:["cat.keyboard","wcag2a","wcag211","TTv5","TT4.a","EN-301-549","EN-9.2.1.1"],actIds:["akn7bn"],all:[\
],any:["frame-focusable-content"],none:[]},{id:"frame-tested",impact:"critical",selector:"html, frame, iframe",tags:["cat.structure","best-practice","review-item"],all:[{options:{isViolation:!1},id:"frame-tested"}],any:[],none:[]},{id:"frame-title-unique",impact:"serious",selector:"frame[title], iframe[title]",matches:"frame-title-has-text-matches",tags:["cat.text-alternatives","wcag2a","wcag412","TTv5","TT12.d","EN-301-549","EN-9.4.1.2"],actIds:["4b1c6c"],all:[],any:[],none:["unique-frame-title"],reviewOnFail:!0},{id:"frame-title",impact:"serious",selector:"frame, iframe",matches:"no-negative-tabindex-matches",tags:["cat.text-alternatives","wcag2a","wcag412","section508","section508.22.i","TTv5","TT12.d","EN-301-549","EN-9.4.1.2"],actIds:["cae760"],all:[],any:[{options:{attribute:"title"},id:"non-empty-title"},"aria-label","aria-labelledby","presentational-role"],none:[]},{id:"heading-order",impact:"moderate",selector:"h1, h2, h3, h4, h5, h6, [role=heading]",matches:"heading-matches",\
tags:["cat.semantics","best-practice"],all:[],any:["heading-order"],none:[]},{id:"hidden-content",impact:"minor",selector:"*",excludeHidden:!1,tags:["cat.structure","best-practice","experimental","review-item"],all:[],any:["hidden-content"],none:[]},{id:"html-has-lang",impact:"serious",selector:"html",matches:"is-initiator-matches",tags:["cat.language","wcag2a","wcag311","TTv5","TT11.a","EN-301-549","EN-9.3.1.1","ACT"],actIds:["b5c3f8"],all:[],any:[{options:{attributes:["lang","xml:lang"]},id:"has-lang"}],none:[]},{id:"html-lang-valid",impact:"serious",selector:'html[lang]:not([lang=""]), html[xml\\\\:lang]:not([xml\\\\:lang=""])',tags:["cat.language","wcag2a","wcag311","TTv5","TT11.a","EN-301-549","EN-9.3.1.1","ACT"],actIds:["bf051a"],all:[],any:[],none:[{options:{attributes:["lang","xml:lang"]},id:"valid-lang"}]},{id:"html-xml-lang-mismatch",impact:"moderate",selector:"html[lang][xml\\\\:lang]",matches:"xml-lang-mismatch-matches",tags:["cat.language","wcag2a","wcag311","EN-301-549","EN-9.3\
.1.1","ACT"],actIds:["5b7ae0"],all:["xml-lang-mismatch"],any:[],none:[]},{id:"identical-links-same-purpose",impact:"minor",selector:'a[href], area[href], [role="link"]',excludeHidden:!1,enabled:!1,matches:"identical-links-same-purpose-matches",tags:["cat.semantics","wcag2aaa","wcag249"],actIds:["b20e66"],all:["identical-links-same-purpose"],any:[],none:[]},{id:"image-alt",impact:"critical",selector:"img",matches:"no-explicit-name-required-matches",tags:["cat.text-alternatives","wcag2a","wcag111","section508","section508.22.a","TTv5","TT7.a","TT7.b","EN-301-549","EN-9.1.1.1","ACT"],actIds:["23a2a8"],all:[],any:["has-alt","aria-label","aria-labelledby",{options:{attribute:"title"},id:"non-empty-title"},"presentational-role"],none:["alt-space-value"]},{id:"image-redundant-alt",impact:"minor",selector:"img",tags:["cat.text-alternatives","best-practice"],all:[],any:[],none:[{options:{parentSelector:"button, [role=button], a[href], p, li, td, th"},id:"duplicate-img-label"}]},{id:"input-butto\
n-name",impact:"critical",selector:'input[type="button"], input[type="submit"], input[type="reset"]',matches:"no-explicit-name-required-matches",tags:["cat.name-role-value","wcag2a","wcag412","section508","section508.22.a","TTv5","TT5.c","EN-301-549","EN-9.4.1.2","ACT"],actIds:["97a4e1"],all:[],any:["non-empty-if-present",{options:{attribute:"value"},id:"non-empty-value"},"aria-label","aria-labelledby",{options:{attribute:"title"},id:"non-empty-title"},"presentational-role"],none:[]},{id:"input-image-alt",impact:"critical",selector:'input[type="image"]',matches:"no-explicit-name-required-matches",tags:["cat.text-alternatives","wcag2a","wcag111","wcag412","section508","section508.22.a","TTv5","TT7.a","EN-301-549","EN-9.1.1.1","EN-9.4.1.2","ACT"],actIds:["59796f"],all:[],any:[{options:{attribute:"alt"},id:"non-empty-alt"},"aria-label","aria-labelledby",{options:{attribute:"title"},id:"non-empty-title"}],none:[]},{id:"label-content-name-mismatch",impact:"serious",matches:"label-content-na\
me-mismatch-matches",tags:["cat.semantics","wcag21a","wcag253","EN-301-549","EN-9.2.5.3","experimental"],actIds:["2ee8b8"],all:[],any:[{options:{pixelThreshold:.1,occurrenceThreshold:3},id:"label-content-name-mismatch"}],none:[]},{id:"label-title-only",impact:"serious",selector:"input, select, textarea",matches:"label-matches",tags:["cat.forms","best-practice"],all:[],any:[],none:["title-only"]},{id:"label",impact:"critical",selector:"input, textarea",matches:"label-matches",tags:["cat.forms","wcag2a","wcag412","section508","section508.22.n","TTv5","TT5.c","EN-301-549","EN-9.4.1.2","ACT"],actIds:["e086e5"],all:[],any:["implicit-label","explicit-label","aria-label","aria-labelledby",{options:{attribute:"title"},id:"non-empty-title"},{options:{attribute:"placeholder"},id:"non-empty-placeholder"},"presentational-role"],none:["hidden-explicit-label"]},{id:"landmark-banner-is-top-level",impact:"moderate",selector:"header:not([role]), [role=banner]",matches:"landmark-has-body-context-matches\
",tags:["cat.semantics","best-practice"],all:[],any:["landmark-is-top-level"],none:[]},{id:"landmark-complementary-is-top-level",impact:"moderate",selector:"aside:not([role]), [role=complementary]",tags:["cat.semantics","best-practice"],all:[],any:["landmark-is-top-level"],none:[]},{id:"landmark-contentinfo-is-top-level",impact:"moderate",selector:"footer:not([role]), [role=contentinfo]",matches:"landmark-has-body-context-matches",tags:["cat.semantics","best-practice"],all:[],any:["landmark-is-top-level"],none:[]},{id:"landmark-main-is-top-level",impact:"moderate",selector:"main:not([role]), [role=main]",tags:["cat.semantics","best-practice"],all:[],any:["landmark-is-top-level"],none:[]},{id:"landmark-no-duplicate-banner",impact:"moderate",selector:"header:not([role]), [role=banner]",tags:["cat.semantics","best-practice"],all:[],any:[{options:{selector:"header:not([role]), [role=banner]",role:"banner"},id:"page-no-duplicate-banner"}],none:[]},{id:"landmark-no-duplicate-contentinfo",imp\
act:"moderate",selector:"footer:not([role]), [role=contentinfo]",tags:["cat.semantics","best-practice"],all:[],any:[{options:{selector:"footer:not([role]), [role=contentinfo]",role:"contentinfo"},id:"page-no-duplicate-contentinfo"}],none:[]},{id:"landmark-no-duplicate-main",impact:"moderate",selector:"main:not([role]), [role=main]",tags:["cat.semantics","best-practice"],all:[],any:[{options:{selector:"main:not([role]), [role='main']"},id:"page-no-duplicate-main"}],none:[]},{id:"landmark-one-main",impact:"moderate",selector:"html",tags:["cat.semantics","best-practice"],all:[{options:{selector:"main:not([role]), [role='main']",passForModal:!0},id:"page-has-main"}],any:[],none:[]},{id:"landmark-unique",impact:"moderate",selector:"[role=banner], [role=complementary], [role=contentinfo], [role=main], [role=navigation], [role=region], [role=search], [role=form], form, footer, header, aside, main, nav, section",tags:["cat.semantics","best-practice"],matches:"landmark-unique-matches",all:[],an\
y:["landmark-is-unique"],none:[]},{id:"link-in-text-block",impact:"serious",selector:"a[href], [role=link]",matches:"link-in-text-block-matches",excludeHidden:!1,tags:["cat.color","wcag2a","wcag141","TTv5","TT13.a","EN-301-549","EN-9.1.4.1"],all:[],any:[{options:{requiredContrastRatio:3,allowSameColor:!0},id:"link-in-text-block"},"link-in-text-block-style"],none:[]},{id:"link-name",impact:"serious",selector:"a[href]",tags:["cat.name-role-value","wcag2a","wcag244","wcag412","section508","section508.22.a","TTv5","TT6.a","EN-301-549","EN-9.2.4.4","EN-9.4.1.2","ACT"],actIds:["c487ae"],all:[],any:["has-visible-text","aria-label","aria-labelledby",{options:{attribute:"title"},id:"non-empty-title"}],none:["focusable-no-name"]},{id:"list",impact:"serious",selector:"ul, ol",matches:"no-role-matches",tags:["cat.structure","wcag2a","wcag131","EN-301-549","EN-9.1.3.1"],all:[],any:[],none:[{options:{validRoles:["listitem"],validNodeNames:["li"]},id:"only-listitems"}]},{id:"listitem",impact:"serious\
",selector:"li",matches:"no-role-matches",tags:["cat.structure","wcag2a","wcag131","EN-301-549","EN-9.1.3.1"],all:[],any:["listitem"],none:[]},{id:"marquee",impact:"serious",selector:"marquee",excludeHidden:!1,tags:["cat.parsing","wcag2a","wcag222","TTv5","TT2.b","EN-301-549","EN-9.2.2.2"],all:[],any:[],none:["is-on-screen"]},{id:"meta-refresh-no-exceptions",impact:"minor",selector:'meta[http-equiv="refresh"][content]',excludeHidden:!1,enabled:!1,tags:["cat.time-and-media","wcag2aaa","wcag224","wcag325"],actIds:["bisz58"],all:[],any:[{options:{minDelay:72e3,maxDelay:!1},id:"meta-refresh-no-exceptions"}],none:[]},{id:"meta-refresh",impact:"critical",selector:'meta[http-equiv="refresh"][content]',excludeHidden:!1,tags:["cat.time-and-media","wcag2a","wcag221","TTv5","TT8.a","EN-301-549","EN-9.2.2.1"],actIds:["bc659a","bisz58"],all:[],any:[{options:{minDelay:0,maxDelay:72e3},id:"meta-refresh"}],none:[]},{id:"meta-viewport-large",impact:"minor",selector:'meta[name="viewport"]',matches:"is-i\
nitiator-matches",excludeHidden:!1,tags:["cat.sensory-and-visual-cues","best-practice"],all:[],any:[{options:{scaleMinimum:5,lowerBound:2},id:"meta-viewport-large"}],none:[]},{id:"meta-viewport",impact:"critical",selector:'meta[name="viewport"]',matches:"is-initiator-matches",excludeHidden:!1,tags:["cat.sensory-and-visual-cues","wcag2aa","wcag144","EN-301-549","EN-9.1.4.4","ACT"],actIds:["b4f0c3"],all:[],any:[{options:{scaleMinimum:2},id:"meta-viewport"}],none:[]},{id:"nested-interactive",impact:"serious",matches:"nested-interactive-matches",tags:["cat.keyboard","wcag2a","wcag412","TTv5","TT6.a","EN-301-549","EN-9.4.1.2"],actIds:["307n5z"],all:[],any:["no-focusable-content"],none:[]},{id:"no-autoplay-audio",impact:"moderate",excludeHidden:!1,selector:"audio[autoplay], video[autoplay]",matches:"no-autoplay-audio-matches",reviewOnFail:!0,tags:["cat.time-and-media","wcag2a","wcag142","TTv5","TT2.a","EN-301-549","EN-9.1.4.2","ACT"],actIds:["80f0bf"],preload:!0,all:[{options:{allowedDuratio\
n:3},id:"no-autoplay-audio"}],any:[],none:[]},{id:"object-alt",impact:"serious",selector:"object[data]",matches:"object-is-loaded-matches",tags:["cat.text-alternatives","wcag2a","wcag111","section508","section508.22.a","EN-301-549","EN-9.1.1.1"],actIds:["8fc3b6"],all:[],any:["aria-label","aria-labelledby",{options:{attribute:"title"},id:"non-empty-title"},"presentational-role"],none:[]},{id:"p-as-heading",impact:"serious",selector:"p",matches:"p-as-heading-matches",tags:["cat.semantics","wcag2a","wcag131","EN-301-549","EN-9.1.3.1","experimental"],all:[{options:{margins:[{weight:150,italic:!0},{weight:150,size:1.15},{italic:!0,size:1.15},{size:1.4}],passLength:1,failLength:.5},id:"p-as-heading"}],any:[],none:[]},{id:"page-has-heading-one",impact:"moderate",selector:"html",tags:["cat.semantics","best-practice"],all:[{options:{selector:"h1:not([role], [aria-level]), :is(h1, h2, h3, h4, h5, h6):not([role])[aria-level=1], [role=heading][aria-level=1]",passForModal:!0},id:"page-has-heading-o\
ne"}],any:[],none:[]},{id:"presentation-role-conflict",impact:"minor",selector:'img[alt=\\'\\'], [role="none"], [role="presentation"]',matches:"has-implicit-chromium-role-matches",tags:["cat.aria","best-practice","ACT"],actIds:["46ca7f"],all:[],any:[],none:["is-element-focusable","has-global-aria-attribute"]},{id:"region",impact:"moderate",selector:"body *",tags:["cat.keyboard","best-practice"],all:[],any:[{options:{regionMatcher:"dialog, [role=dialog], [role=alertdialog], svg"},id:"region"}],none:[]},{id:"role-img-alt",impact:"serious",selector:"[role='img']:not(img, area, input, object)",matches:"html-namespace-matches",tags:["cat.text-alternatives","wcag2a","wcag111","section508","section508.22.a","TTv5","TT7.a","EN-301-549","EN-9.1.1.1","ACT"],actIds:["23a2a8"],all:[],any:["aria-label","aria-labelledby",{options:{attribute:"title"},id:"non-empty-title"}],none:[]},{id:"scope-attr-valid",impact:"moderate",selector:"td[scope], th[scope]",tags:["cat.tables","best-practice"],all:["html5-s\
cope",{options:{values:["row","col","rowgroup","colgroup"]},id:"scope-value"}],any:[],none:[]},{id:"scrollable-region-focusable",impact:"serious",selector:"*:not(select,textarea)",matches:"scrollable-region-focusable-matches",tags:["cat.keyboard","wcag2a","wcag211","TTv5","TT4.a","EN-301-549","EN-9.2.1.1"],actIds:["0ssw9k"],all:[],any:["focusable-content","focusable-element"],none:[]},{id:"select-name",impact:"critical",selector:"select",tags:["cat.forms","wcag2a","wcag412","section508","section508.22.n","TTv5","TT5.c","EN-301-549","EN-9.4.1.2","ACT"],actIds:["e086e5"],all:[],any:["implicit-label","explicit-label","aria-label","aria-labelledby",{options:{attribute:"title"},id:"non-empty-title"},"presentational-role"],none:["hidden-explicit-label"]},{id:"server-side-image-map",impact:"minor",selector:"img[ismap]",tags:["cat.text-alternatives","wcag2a","wcag211","section508","section508.22.f","TTv5","TT4.a","EN-301-549","EN-9.2.1.1"],all:[],any:[],none:["exists"]},{id:"skip-link",impact:\
"moderate",selector:'a[href^="#"], a[href^="/#"]',matches:"skip-link-matches",tags:["cat.keyboard","best-practice"],all:[],any:["skip-link"],none:[]},{id:"svg-img-alt",impact:"serious",selector:'[role="img"], [role="graphics-symbol"], svg[role="graphics-document"]',matches:"svg-namespace-matches",tags:["cat.text-alternatives","wcag2a","wcag111","section508","section508.22.a","TTv5","TT7.a","EN-301-549","EN-9.1.1.1","ACT"],actIds:["7d6734"],all:[],any:["svg-non-empty-title","aria-label","aria-labelledby",{options:{attribute:"title"},id:"non-empty-title"}],none:[]},{id:"tabindex",impact:"serious",selector:"[tabindex]",tags:["cat.keyboard","best-practice"],all:[],any:["tabindex"],none:[]},{id:"table-duplicate-name",impact:"minor",selector:"table",tags:["cat.tables","best-practice"],all:[],any:[],none:["same-caption-summary"]},{id:"table-fake-caption",impact:"serious",selector:"table",matches:"data-table-matches",tags:["cat.tables","experimental","wcag2a","wcag131","section508","section508\
.22.g","EN-301-549","EN-9.1.3.1"],all:["caption-faked"],any:[],none:[]},{id:"target-size",impact:"serious",selector:"*",enabled:!1,matches:"widget-not-inline-matches",tags:["cat.sensory-and-visual-cues","wcag22aa","wcag258"],all:[],any:[{options:{minSize:24},id:"target-size"},{options:{minOffset:24},id:"target-offset"}],none:[]},{id:"td-has-header",impact:"critical",selector:"table",matches:"data-table-large-matches",tags:["cat.tables","experimental","wcag2a","wcag131","section508","section508.22.g","TTv5","TT14.b","EN-301-549","EN-9.1.3.1"],all:["td-has-header"],any:[],none:[]},{id:"td-headers-attr",impact:"serious",selector:"table",matches:"table-or-grid-role-matches",tags:["cat.tables","wcag2a","wcag131","section508","section508.22.g","TTv5","TT14.b","EN-301-549","EN-9.1.3.1"],actIds:["a25f45"],all:["td-headers-attr"],any:[],none:[]},{id:"th-has-data-cells",impact:"serious",selector:"table",matches:"data-table-matches",tags:["cat.tables","wcag2a","wcag131","section508","section508.2\
2.g","TTv5","TT14.b","EN-301-549","EN-9.1.3.1"],actIds:["d0f69e"],all:["th-has-data-cells"],any:[],none:[]},{id:"valid-lang",impact:"serious",selector:"[lang]:not(html), [xml\\\\:lang]:not(html)",tags:["cat.language","wcag2aa","wcag312","TTv5","TT11.b","EN-301-549","EN-9.3.1.2","ACT"],actIds:["de46e4"],all:[],any:[],none:[{options:{attributes:["lang","xml:lang"]},id:"valid-lang"}]},{id:"video-caption",impact:"critical",selector:"video",tags:["cat.text-alternatives","wcag2a","wcag122","section508","section508.22.a","TTv5","TT17.a","EN-301-549","EN-9.1.2.2"],actIds:["eac66b"],all:[],any:[],none:["caption"]}],checks:[{id:"abstractrole",evaluate:"abstractrole-evaluate"},{id:"aria-allowed-attr",evaluate:"aria-allowed-attr-evaluate",options:{validTreeRowAttrs:["aria-posinset","aria-setsize","aria-expanded","aria-level"]}},{id:"aria-allowed-role",evaluate:"aria-allowed-role-evaluate",options:{allowImplicit:!0,ignoredTags:[]}},{id:"aria-busy",evaluate:"aria-busy-evaluate"},{id:"aria-conditional-\
attr",evaluate:"aria-conditional-attr-evaluate",options:{invalidTableRowAttrs:["aria-posinset","aria-setsize","aria-expanded","aria-level"]}},{id:"aria-errormessage",evaluate:"aria-errormessage-evaluate"},{id:"aria-hidden-body",evaluate:"aria-hidden-body-evaluate"},{id:"aria-level",evaluate:"aria-level-evaluate"},{id:"aria-prohibited-attr",evaluate:"aria-prohibited-attr-evaluate",options:{elementsAllowedAriaLabel:["applet","input"]}},{id:"aria-required-attr",evaluate:"aria-required-attr-evaluate"},{id:"aria-required-children",evaluate:"aria-required-children-evaluate",options:{reviewEmpty:["doc-bibliography","doc-endnotes","grid","list","listbox","menu","menubar","table","tablist","tree","treegrid","rowgroup"]}},{id:"aria-required-parent",evaluate:"aria-required-parent-evaluate",options:{ownGroupRoles:["listitem","treeitem"]}},{id:"aria-roledescription",evaluate:"aria-roledescription-evaluate",options:{supportedRoles:["button","img","checkbox","radio","combobox","menuitemcheckbox","men\
uitemradio"]}},{id:"aria-unsupported-attr",evaluate:"aria-unsupported-attr-evaluate"},{id:"aria-valid-attr-value",evaluate:"aria-valid-attr-value-evaluate",options:[]},{id:"aria-valid-attr",evaluate:"aria-valid-attr-evaluate",options:[]},{id:"braille-label-equivalent",evaluate:"braille-label-equivalent-evaluate"},{id:"braille-roledescription-equivalent",evaluate:"braille-roledescription-equivalent-evaluate"},{id:"deprecatedrole",evaluate:"deprecatedrole-evaluate"},{id:"fallbackrole",evaluate:"fallbackrole-evaluate"},{id:"has-global-aria-attribute",evaluate:"has-global-aria-attribute-evaluate"},{id:"has-widget-role",evaluate:"has-widget-role-evaluate",options:[]},{id:"invalidrole",evaluate:"invalidrole-evaluate"},{id:"is-element-focusable",evaluate:"is-element-focusable-evaluate"},{id:"no-implicit-explicit-label",evaluate:"no-implicit-explicit-label-evaluate"},{id:"unsupportedrole",evaluate:"unsupportedrole-evaluate"},{id:"valid-scrollable-semantics",evaluate:"valid-scrollable-semantics\
-evaluate",options:{roles:["tooltip"]}},{id:"color-contrast-enhanced",evaluate:"color-contrast-evaluate",options:{ignoreUnicode:!0,ignoreLength:!1,ignorePseudo:!1,boldValue:700,boldTextPt:14,largeTextPt:18,contrastRatio:{normal:{expected:7,minThreshold:4.5},large:{expected:4.5,minThreshold:3}},pseudoSizeThreshold:.25,shadowOutlineEmMax:.1,textStrokeEmMin:.03}},{id:"color-contrast",evaluate:"color-contrast-evaluate",options:{ignoreUnicode:!0,ignoreLength:!1,ignorePseudo:!1,boldValue:700,boldTextPt:14,largeTextPt:18,contrastRatio:{normal:{expected:4.5},large:{expected:3}},pseudoSizeThreshold:.25,shadowOutlineEmMax:.2,textStrokeEmMin:.03}},{id:"link-in-text-block-style",evaluate:"link-in-text-block-style-evaluate"},{id:"link-in-text-block",evaluate:"link-in-text-block-evaluate",options:{requiredContrastRatio:3,allowSameColor:!0}},{id:"autocomplete-appropriate",evaluate:"autocomplete-appropriate-evaluate",deprecated:!0},{id:"autocomplete-valid",evaluate:"autocomplete-valid-evaluate",option\
s:{stateTerms:["none","false","true","disabled","enabled","undefined","null"]}},{id:"accesskeys",evaluate:"accesskeys-evaluate",after:"accesskeys-after"},{id:"focusable-content",evaluate:"focusable-content-evaluate"},{id:"focusable-disabled",evaluate:"focusable-disabled-evaluate"},{id:"focusable-element",evaluate:"focusable-element-evaluate"},{id:"focusable-modal-open",evaluate:"focusable-modal-open-evaluate"},{id:"focusable-no-name",evaluate:"focusable-no-name-evaluate"},{id:"focusable-not-tabbable",evaluate:"focusable-not-tabbable-evaluate"},{id:"frame-focusable-content",evaluate:"frame-focusable-content-evaluate"},{id:"landmark-is-top-level",evaluate:"landmark-is-top-level-evaluate"},{id:"no-focusable-content",evaluate:"no-focusable-content-evaluate"},{id:"page-has-heading-one",evaluate:"has-descendant-evaluate",after:"has-descendant-after",options:{selector:"h1:not([role], [aria-level]), :is(h1, h2, h3, h4, h5, h6):not([role])[aria-level=1], [role=heading][aria-level=1]",passForMod\
al:!0}},{id:"page-has-main",evaluate:"has-descendant-evaluate",after:"has-descendant-after",options:{selector:"main:not([role]), [role='main']",passForModal:!0}},{id:"page-no-duplicate-banner",evaluate:"page-no-duplicate-evaluate",after:"page-no-duplicate-after",options:{selector:"header:not([role]), [role=banner]",role:"banner"}},{id:"page-no-duplicate-contentinfo",evaluate:"page-no-duplicate-evaluate",after:"page-no-duplicate-after",options:{selector:"footer:not([role]), [role=contentinfo]",role:"contentinfo"}},{id:"page-no-duplicate-main",evaluate:"page-no-duplicate-evaluate",after:"page-no-duplicate-after",options:{selector:"main:not([role]), [role='main']"}},{id:"tabindex",evaluate:"tabindex-evaluate"},{id:"alt-space-value",evaluate:"alt-space-value-evaluate"},{id:"duplicate-img-label",evaluate:"duplicate-img-label-evaluate",options:{parentSelector:"button, [role=button], a[href], p, li, td, th"}},{id:"explicit-label",evaluate:"explicit-evaluate"},{id:"help-same-as-label",evaluate\
:"help-same-as-label-evaluate"},{id:"hidden-explicit-label",evaluate:"hidden-explicit-label-evaluate"},{id:"implicit-label",evaluate:"implicit-evaluate"},{id:"label-content-name-mismatch",evaluate:"label-content-name-mismatch-evaluate",options:{pixelThreshold:.1,occurrenceThreshold:3}},{id:"multiple-label",evaluate:"multiple-label-evaluate"},{id:"title-only",evaluate:"title-only-evaluate"},{id:"landmark-is-unique",evaluate:"landmark-is-unique-evaluate",after:"landmark-is-unique-after"},{id:"has-lang",evaluate:"has-lang-evaluate",options:{attributes:["lang","xml:lang"]}},{id:"valid-lang",evaluate:"valid-lang-evaluate",options:{attributes:["lang","xml:lang"]}},{id:"xml-lang-mismatch",evaluate:"xml-lang-mismatch-evaluate"},{id:"dlitem",evaluate:"dlitem-evaluate"},{id:"listitem",evaluate:"listitem-evaluate"},{id:"only-dlitems",evaluate:"invalid-children-evaluate",options:{validRoles:["definition","term","listitem"],validNodeNames:["dt","dd"],divGroups:!0}},{id:"only-listitems",evaluate:"in\
valid-children-evaluate",options:{validRoles:["listitem"],validNodeNames:["li"]}},{id:"structured-dlitems",evaluate:"structured-dlitems-evaluate"},{id:"caption",evaluate:"caption-evaluate"},{id:"frame-tested",evaluate:"frame-tested-evaluate",after:"frame-tested-after",options:{isViolation:!1}},{id:"no-autoplay-audio",evaluate:"no-autoplay-audio-evaluate",options:{allowedDuration:3}},{id:"css-orientation-lock",evaluate:"css-orientation-lock-evaluate",options:{degreeThreshold:2}},{id:"meta-viewport-large",evaluate:"meta-viewport-scale-evaluate",options:{scaleMinimum:5,lowerBound:2}},{id:"meta-viewport",evaluate:"meta-viewport-scale-evaluate",options:{scaleMinimum:2}},{id:"target-offset",evaluate:"target-offset-evaluate",options:{minOffset:24}},{id:"target-size",evaluate:"target-size-evaluate",options:{minSize:24}},{id:"header-present",evaluate:"has-descendant-evaluate",after:"has-descendant-after",options:{selector:":is(h1, h2, h3, h4, h5, h6):not([role]), [role=heading]"}},{id:"heading-\
order",evaluate:"heading-order-evaluate",after:"heading-order-after"},{id:"identical-links-same-purpose",evaluate:"identical-links-same-purpose-evaluate",after:"identical-links-same-purpose-after"},{id:"internal-link-present",evaluate:"internal-link-present-evaluate"},{id:"landmark",evaluate:"has-descendant-evaluate",options:{selector:"main, [role=main]"}},{id:"meta-refresh-no-exceptions",evaluate:"meta-refresh-evaluate",options:{minDelay:72e3,maxDelay:!1}},{id:"meta-refresh",evaluate:"meta-refresh-evaluate",options:{minDelay:0,maxDelay:72e3}},{id:"p-as-heading",evaluate:"p-as-heading-evaluate",options:{margins:[{weight:150,italic:!0},{weight:150,size:1.15},{italic:!0,size:1.15},{size:1.4}],passLength:1,failLength:.5}},{id:"region",evaluate:"region-evaluate",after:"region-after",options:{regionMatcher:"dialog, [role=dialog], [role=alertdialog], svg"}},{id:"skip-link",evaluate:"skip-link-evaluate"},{id:"unique-frame-title",evaluate:"unique-frame-title-evaluate",after:"unique-frame-title\
-after"},{id:"duplicate-id-active",evaluate:"duplicate-id-evaluate",after:"duplicate-id-after"},{id:"duplicate-id-aria",evaluate:"duplicate-id-evaluate",after:"duplicate-id-after"},{id:"duplicate-id",evaluate:"duplicate-id-evaluate",after:"duplicate-id-after"},{id:"aria-label",evaluate:"aria-label-evaluate"},{id:"aria-labelledby",evaluate:"aria-labelledby-evaluate"},{id:"avoid-inline-spacing",evaluate:"avoid-inline-spacing-evaluate",options:{cssProperties:["line-height","letter-spacing","word-spacing"]}},{id:"button-has-visible-text",evaluate:"has-text-content-evaluate"},{id:"doc-has-title",evaluate:"doc-has-title-evaluate"},{id:"exists",evaluate:"exists-evaluate"},{id:"has-alt",evaluate:"has-alt-evaluate"},{id:"has-visible-text",evaluate:"has-text-content-evaluate"},{id:"important-letter-spacing",evaluate:"inline-style-property-evaluate",options:{cssProperty:"letter-spacing",minValue:.12}},{id:"important-line-height",evaluate:"inline-style-property-evaluate",options:{multiLineOnly:!0,\
cssProperty:"line-height",minValue:1.5,normalValue:1}},{id:"important-word-spacing",evaluate:"inline-style-property-evaluate",options:{cssProperty:"word-spacing",minValue:.16}},{id:"is-on-screen",evaluate:"is-on-screen-evaluate"},{id:"non-empty-alt",evaluate:"attr-non-space-content-evaluate",options:{attribute:"alt"}},{id:"non-empty-if-present",evaluate:"non-empty-if-present-evaluate"},{id:"non-empty-placeholder",evaluate:"attr-non-space-content-evaluate",options:{attribute:"placeholder"}},{id:"non-empty-title",evaluate:"attr-non-space-content-evaluate",options:{attribute:"title"}},{id:"non-empty-value",evaluate:"attr-non-space-content-evaluate",options:{attribute:"value"}},{id:"presentational-role",evaluate:"presentational-role-evaluate"},{id:"role-none",evaluate:"matches-definition-evaluate",deprecated:!0,options:{matcher:{attributes:{role:"none"}}}},{id:"role-presentation",evaluate:"matches-definition-evaluate",deprecated:!0,options:{matcher:{attributes:{role:"presentation"}}}},{id:\
"svg-non-empty-title",evaluate:"svg-non-empty-title-evaluate"},{id:"caption-faked",evaluate:"caption-faked-evaluate"},{id:"html5-scope",evaluate:"html5-scope-evaluate"},{id:"same-caption-summary",evaluate:"same-caption-summary-evaluate"},{id:"scope-value",evaluate:"scope-value-evaluate",options:{values:["row","col","rowgroup","colgroup"]}},{id:"td-has-header",evaluate:"td-has-header-evaluate"},{id:"td-headers-attr",evaluate:"td-headers-attr-evaluate"},{id:"th-has-data-cells",evaluate:"th-has-data-cells-evaluate"},{id:"hidden-content",evaluate:"hidden-content-evaluate"}]})}("object"==typeof window?window:this);`});function hre(e){return(!e||typeof e=="string")&&(e=new Error(e)),{__failedInBrowser:!0,name:e.name||"Error",message:e.message||"unknown error",stack:e.stack}}function gre(e){let t=window.__ElementMatches||window.Element.prototype.matches,n=[],r=s(a=>{for(let i of a){if(!e||t.call(i,e)){let o=i;n.push(o)}i.shadowRoot&&r(i.shadowRoot.querySelectorAll("*"))}},"_findAllElements");return r(document.querySelectorAll("*")),n}function Tl(e,t=[],n=500){let a=["autofill-information","autofill-prediction","title"];e instanceof ShadowRoot&&(e=e.host);try{let i=e.cloneNode();e.ownerDocument.createElement("template").content.append(i),t.concat(a).forEach(m=>{i.removeAttribute(m)});let c=0;for(let m of i.getAttributeNames()){if(c>n){i.removeAttribute(m);continue}let p=i.getAttribute(m);if(p===null)continue;let h=!1;if(m==="src"&&"currentSrc"in e){let g=e,b=g.currentSrc,w=g.ownerDocument.location.href;new URL(p,w).toString()!==b&&(p=b,h=!0)}let f=ci(p,75);if(f!==p&&(h=!0),p=f,h)if(m==="style"){let g=i;
g.style.cssText=p}else i.setAttribute(m,p);c+=m.length+p.length}let u=/^[\s\S]*?>/,[l]=i.outerHTML.match(u)||[];return l&&c>n?l.slice(0,l.length-1)+" …>":l||""}catch{return`<${e.localName}>`}}function yre(){function e(){let n=Date.now(),r=0;for(;Date.now()-n<500;){let i="";for(let o=0;o<1e4;o++)i+="a";if(i.length===1)throw new Error("will never happen, but prevents compiler optimizations");r++}let a=(Date.now()-n)/1e3;return Math.round(r/10/a)}s(e,"benchmarkIndexGC");function t(){let n=[],r=[];for(let c=0;c<1e5;c++)n[c]=r[c]=c;let a=Date.now(),i=0;for(;i%10!==0||Date.now()-a<500;){let c=i%2===0?n:r,u=i%2===0?r:n;for(let l=0;l<c.length;l++)u[l]=c[l];i++}let o=(Date.now()-a)/1e3;return Math.round(i/10/o)}return s(t,"benchmarkIndexNoGC"),(e()+t())/2}function bb(e){let t=s(o=>o.nodeType===Node.DOCUMENT_FRAGMENT_NODE,"isShadowRoot"),n=s(o=>t(o)?o.host:o.parentNode,"getNodeParent");function r(o){if(t(o))return"a";let c=0,u;for(;u=o.previousSibling;)o=u,!(o.nodeType===Node.TEXT_NODE&&(o.nodeValue||
"").trim().length===0)&&c++;return c}s(r,"getNodeIndex");let a=e,i=[];for(;a&&n(a);){let o=r(a);i.push([o,a.nodeName]),a=n(a)}return i.reverse(),i.join(",")}function wb(e){function t(r){let a=r.tagName.toLowerCase();return r.id?a+="#"+r.id:r.classList.length>0&&(a+="."+r.classList[0]),a}s(t,"getSelectorPart");let n=[];for(;n.length<4&&(n.unshift(t(e)),!(!e.parentElement||(e=e.parentElement,e.tagName==="HTML"))););return n.join(" > ")}function vre(e){function t(a,i){return a.style[i]||window.getComputedStyle(a)[i]}s(t,"getStyleAttrValue");let n=document.querySelector("html");if(!n)throw new Error("html element not found in document");if(n.scrollHeight<=n.clientHeight||!["scroll","auto","visible"].includes(t(n,"overflowY")))return!1;let r=e;for(;r;){let a=t(r,"position");if(a==="fixed"||a==="sticky")return!0;r=r.parentElement}return!1}function Hs(e){let t=e.tagName.toLowerCase();if(t!=="html"&&t!=="body"){let n=e instanceof HTMLElement&&e.innerText||e.getAttribute("alt")||e.getAttribute(
"aria-label");if(n)return ci(n,80);{let r=e.querySelector("[alt], [aria-label]");if(r)return Hs(r)}}return null}function Db(e){let n=(window.__HTMLElementBoundingClientRect||window.HTMLElement.prototype.getBoundingClientRect).call(e);return{top:Math.round(n.top),bottom:Math.round(n.bottom),left:Math.round(n.left),right:Math.round(n.right),width:Math.round(n.width),height:Math.round(n.height)}}function bre(e){let n=Math.floor(40/e),r=window.requestIdleCallback;window.requestIdleCallback=(a,i)=>r(s(c=>{let u=Date.now();c.__timeRemaining=c.timeRemaining,c.timeRemaining=()=>{let l=c.__timeRemaining();return Math.min(l,Math.max(0,n-(Date.now()-u)))},c.timeRemaining.toString=()=>"function timeRemaining() { [native code] }",a(c)},"cbWrap"),i),window.requestIdleCallback.toString=()=>"function requestIdleCallback() { [native code] }"}function $f(e){window.__lighthouseNodesDontTouchOrAllVarianceGoesAway||(window.__lighthouseNodesDontTouchOrAllVarianceGoesAway=new Map),e=e instanceof ShadowRoot?e.
host:e;let t=wb(e),n=window.__lighthouseNodesDontTouchOrAllVarianceGoesAway.get(e);return n||(n=[window.__lighthouseExecutionContextUniqueIdentifier===void 0?"page":window.__lighthouseExecutionContextUniqueIdentifier,window.__lighthouseNodesDontTouchOrAllVarianceGoesAway.size,e.tagName].join("-"),window.__lighthouseNodesDontTouchOrAllVarianceGoesAway.set(e,n)),{lhId:n,devtoolsNodePath:bb(e),selector:t,boundingRect:Db(e),snippet:Tl(e),nodeLabel:Hs(e)||t}}function ci(e,t){return ze.truncate(e,t)}function wre(){if(globalThis.isDevtools||globalThis.isLightrider)return!0;let e=fo("core/lib/page-functions.js");try{return e.resolve("lighthouse-logger"),!1}catch{return!0}}function Ere(){if(!wre())return"";let t=(()=>{let a=s(()=>{},"a")}).toString().replace("/* @__PURE__ */","").match(/=\s*([\w_]+)\(/);if(!t)throw new Error("Could not determine esbuild function wrapper name");let n=s((a,i)=>Object.defineProperty(a,"name",{value:i,configurable:!0}),"esbuildFunctionWrapper");return`let ${t[1]}=${n}`}
function El(e){let t=e.toString().match(/function ([\w$]+)/);if(!t)throw new Error(`could not find function name for: ${e}`);return t[1]}var Dre,Yf,cP,uP,Tre,he,ln=v(()=>{"use strict";d();Fs();Vn();s(hre,"wrapRuntimeEvalErrorInBrowser");s(gre,"getElementsInDocument");s(Tl,"getOuterHTMLSnippet");s(yre,"computeBenchmarkIndex");s(bb,"getNodePath");s(wb,"getNodeSelector");s(vre,"isPositionFixed");s(Hs,"getNodeLabel");s(Db,"getBoundingClientRect");s(bre,"wrapRequestIdleCallback");s($f,"getNodeDetails");s(ci,"truncate");s(wre,"isBundledEnvironment");Dre=Ere();s(Ere,"createEsbuildFunctionWrapper");s(El,"getRuntimeFunctionName");Yf={truncate:El(ci),getNodeLabel:El(Hs),getOuterHTMLSnippet:El(Tl),getNodeDetails:El($f)};ci.toString=()=>`function ${Yf.truncate}(string, characterLimit) {
  const Util = { ${ze.truncate} };
  return Util.truncate(string, characterLimit);
}`;cP=Hs.toString();Hs.toString=()=>`function ${Yf.getNodeLabel}(element) {
  ${ci};
  return (${cP})(element);
}`;uP=Tl.toString();Tl.toString=()=>`function ${Yf.getOuterHTMLSnippet}(element, ignoreAttrs = [], snippetCharacterLimit = 500) {
  ${ci};
  return (${uP})(element, ignoreAttrs, snippetCharacterLimit);
}`;Tre=$f.toString();$f.toString=()=>`function ${Yf.getNodeDetails}(element) {
  ${ci};
  ${bb};
  ${wb};
  ${Db};
  ${uP};
  ${cP};
  return (${Tre})(element);
}`;he={wrapRuntimeEvalErrorInBrowser:hre,getElementsInDocument:gre,getOuterHTMLSnippet:Tl,computeBenchmarkIndex:yre,getNodeDetails:$f,getNodePath:bb,getNodeSelector:wb,getNodeLabel:Hs,isPositionFixed:vre,wrapRequestIdleCallback:bre,getBoundingClientRect:Db,truncate:ci,esbuildFunctionWrapperString:Dre,getRuntimeFunctionName:El}});var lP={};T(lP,{default:()=>Sre});async function Eb(){let e=window.axe,t=`lighthouse-${Math.random()}`;e.configure({branding:{application:t},noHtml:!0});let n=await e.run(document,{elementRef:!0,runOnly:{type:"tag",values:["wcag2a","wcag2aa"]},resultTypes:["violations","inapplicable"],rules:{accesskeys:{enabled:!0},"area-alt":{enabled:!1},"aria-allowed-role":{enabled:!0},"aria-braille-equivalent":{enabled:!1},"aria-conditional-attr":{enabled:!1},"aria-deprecated-role":{enabled:!1},"aria-dialog-name":{enabled:!0},"aria-prohibited-attr":{enabled:!1},"aria-roledescription":{enabled:!1},"aria-treeitem-name":{enabled:!0},"aria-text":{enabled:!0},"audio-caption":{enabled:!1},blink:{enabled:!1},"duplicate-id-active":{enabled:!0},"duplicate-id":{enabled:!1},"empty-heading":{enabled:!0},"frame-focusable-content":{enabled:!1},"frame-title-unique":{enabled:!1},"heading-order":{enabled:!0},"html-xml-lang-mismatch":{enabled:!0},"identical-links-same-purpose":{enabled:!0},"image-redundant-alt":{enabled:!0},
"input-button-name":{enabled:!0},"label-content-name-mismatch":{enabled:!0},"landmark-one-main":{enabled:!0},"link-in-text-block":{enabled:!0},marquee:{enabled:!1},"meta-viewport":{enabled:!0},"nested-interactive":{enabled:!1},"no-autoplay-audio":{enabled:!1},"role-img-alt":{enabled:!1},"scrollable-region-focusable":{enabled:!1},"select-name":{enabled:!0},"server-side-image-map":{enabled:!1},"skip-link":{enabled:!0},"svg-img-alt":{enabled:!1},tabindex:{enabled:!0},"table-duplicate-name":{enabled:!0},"table-fake-caption":{enabled:!0},"target-size":{enabled:!0},"td-has-header":{enabled:!0}}});return document.documentElement.scrollTop=0,{violations:n.violations.map(Kf),incomplete:n.incomplete.map(Kf),notApplicable:n.inapplicable.map(r=>({id:r.id})),passes:n.passes.map(r=>({id:r.id})),version:n.testEngine.version}}async function xre(){let e={x:window.scrollX,y:window.scrollY};try{return await Eb()}finally{window.scrollTo(e.x,e.y)}}function Kf(e){let t=e.nodes.map(a=>{let{target:i,failureSummary:o,
element:c}=a,u=getNodeDetails(c),l=new Set,m=s(f=>[null,"minor","moderate","serious","critical"].indexOf(f),"impactToNumber"),p=[...a.any,...a.all,...a.none].sort((f,g)=>m(g.impact)-m(f.impact));for(let f of p)for(let g of f.relatedNodes||[]){let b=g.element;if(l.size>=3)break;b&&c!==b&&l.add(b)}let h=[...l].map(getNodeDetails);return{target:i,failureSummary:o,node:u,relatedNodes:h}}),n=e.error,r;return n instanceof Error&&(r={name:n.name,message:n.message}),{id:e.id,impact:e.impact||void 0,tags:e.tags,nodes:t,error:r}}var Tb,Sre,dP=v(()=>{"use strict";d();Ie();sP();ln();s(Eb,"runA11yChecks");s(xre,"runA11yChecksAndResetScroll");s(Kf,"createAxeRuleResultArtifact");Tb=class extends X{static{s(this,"Accessibility")}meta={supportedModes:["snapshot","navigation"]};static pageFns={runA11yChecks:Eb,createAxeRuleResultArtifact:Kf};getArtifact(t){return t.driver.executionContext.evaluate(xre,{args:[],useIsolation:!0,deps:[oP,he.getNodeDetails,Kf,Eb]})}},Sre=Tb});function mP(e){if(!(/No node.*found/.test(e.message)||/Node.*does not belong to the document/.test(e.message)))throw e}async function pP(e,t){try{return(await e.sendCommand("DOM.resolveNode",{backendNodeId:t})).object.objectId}catch(n){return mP(n)}}async function fP(e,t){try{let{nodeId:n}=await e.sendCommand("DOM.pushNodeByPathToFrontend",{path:t}),{object:{objectId:r}}=await e.sendCommand("DOM.resolveNode",{nodeId:n});return r}catch(n){return mP(n)}}var xb=v(()=>{"use strict";d();s(mP,"handlePotentialMissingNodeError");s(pP,"resolveNodeIdToObjectId");s(fP,"resolveDevtoolsNodePathToObjectId")});var hP={};T(hP,{default:()=>Are});function Cre(){let e=s(r=>{try{return new URL(r,window.location.href).href}catch{return""}},"resolveURLOrEmpty");function t(r){return(r.getAttribute("onclick")||"").slice(0,1024)}return s(t,"getTruncatedOnclick"),getElementsInDocument("a").map(r=>r instanceof HTMLAnchorElement?{href:r.href,rawHref:r.getAttribute("href")||"",onclick:t(r),role:r.getAttribute("role")||"",name:r.name,text:r.innerText,rel:r.rel,target:r.target,id:r.getAttribute("id")||"",node:getNodeDetails(r)}:{href:e(r.href.baseVal),rawHref:r.getAttribute("href")||"",onclick:t(r),role:r.getAttribute("role")||"",text:r.textContent||"",rel:"",target:r.target.baseVal||"",id:r.getAttribute("id")||"",node:getNodeDetails(r)})}async function kre(e,t){let n=await fP(e,t);return n?(await e.sendCommand("DOMDebugger.getEventListeners",{objectId:n})).listeners.map(({type:a})=>({type:a})):[]}var Sb,Are,gP=v(()=>{"use strict";d();Ie();ln();xb();s(Cre,"collectAnchorElements");s(kre,"getEventListeners");
Sb=class extends X{static{s(this,"AnchorElements")}meta={supportedModes:["snapshot","navigation"]};async getArtifact(t){let n=t.driver.defaultSession,r=await t.driver.executionContext.evaluate(Cre,{args:[],useIsolation:!0,deps:[he.getElementsInDocument,he.getNodeDetails]});await n.sendCommand("DOM.enable"),await n.sendCommand("DOM.getDocument",{depth:-1,pierce:!0});let a=r.map(async o=>{let c=await kre(n,o.node.devtoolsNodePath);return{...o,listeners:c}}),i=await Promise.all(a);return await n.sendCommand("DOM.disable"),i}},Are=Sb});var ui,Xf=v(()=>{"use strict";d();Yt();ln();ui=class e{static{s(this,"ExecutionContext")}constructor(t){this._session=t,this._executionContextId=void 0,this._executionContextIdentifiersCreated=0,t.on("Page.frameNavigated",()=>this.clearContextId()),t.on("Runtime.executionContextDestroyed",n=>{n.executionContextId===this._executionContextId&&this.clearContextId()})}getContextId(){return this._executionContextId}clearContextId(){this._executionContextId=void 0}async _getOrCreateIsolatedContextId(){if(typeof this._executionContextId=="number")return this._executionContextId;await this._session.sendCommand("Page.enable"),await this._session.sendCommand("Runtime.enable");let n=(await this._session.sendCommand("Page.getFrameTree")).frameTree.frame.id,r=await this._session.sendCommand("Page.createIsolatedWorld",{frameId:n,worldName:"lighthouse_isolated_context"});return this._executionContextId=r.executionContextId,this._executionContextIdentifiersCreated++,r.executionContextId}async _evaluateInContext(t,n){
let r=this._session.hasNextProtocolTimeout()?this._session.getNextProtocolTimeout():6e4,a=n===void 0?void 0:this._executionContextIdentifiersCreated,i={expression:`(function wrapInNativePromise() {
        ${e._cachedNativesPreamble};
        globalThis.__lighthouseExecutionContextUniqueIdentifier =
          ${a};
        ${he.esbuildFunctionWrapperString}
        return new Promise(function (resolve) {
          return Promise.resolve()
            .then(_ => ${t})
            .catch(${he.wrapRuntimeEvalErrorInBrowser})
            .then(resolve);
        });
      }())
      //# sourceURL=_lighthouse-eval.js`,includeCommandLineAPI:!0,awaitPromise:!0,returnByValue:!0,timeout:r,contextId:n};this._session.setNextProtocolTimeout(r);let o=await this._session.sendCommand("Runtime.evaluate",i),c=o.exceptionDetails;if(c){let m=["Runtime.evaluate exception",`Expression: ${t.replace(/\s+/g," ").substring(0,100)}
---- (elided)`,c.stackTrace?null:`Parse error at: ${c.lineNumber+1}:${c.columnNumber+1}`,c.exception?.description||c.text].filter(Boolean),p=new Error(m.join(`
`));return Promise.reject(p)}if(o.result===void 0)return Promise.reject(new Error('Runtime.evaluate response did not contain a "result" object'));let u=o.result.value;return u?.__failedInBrowser?Promise.reject(Object.assign(new Error,u)):u}async evaluateAsync(t,n={}){let r=n.useIsolation?await this._getOrCreateIsolatedContextId():void 0;try{return await this._evaluateInContext(t,r)}catch(a){if(r&&a.message.includes("Cannot find context")){this.clearContextId();let i=await this._getOrCreateIsolatedContextId();return this._evaluateInContext(t,i)}throw a}}evaluate(t,n){let r=e.serializeArguments(n.args),i=`(() => {
      ${e.serializeDeps(n.deps)}
      return (${t})(${r});
    })()`;return this.evaluateAsync(i,n)}async evaluateOnNewDocument(t,n){let r=e.serializeArguments(n.args),a=e.serializeDeps(n.deps),i=`(() => {
      ${e._cachedNativesPreamble};
      ${a};
      (${t})(${r});
    })()
    //# sourceURL=_lighthouse-eval.js`;await this._session.sendCommand("Page.addScriptToEvaluateOnNewDocument",{source:i})}async cacheNativesOnNewDocument(){await this.evaluateOnNewDocument(()=>{window.__nativePromise=window.Promise,window.__nativeURL=window.URL,window.__nativePerformance=window.performance,window.__nativeFetch=window.fetch,window.__ElementMatches=window.Element.prototype.matches,window.__HTMLElementBoundingClientRect=window.HTMLElement.prototype.getBoundingClientRect},{args:[]})}static _cachedNativesPreamble=["const Promise = globalThis.__nativePromise || globalThis.Promise","const URL = globalThis.__nativeURL || globalThis.URL","const performance = globalThis.__nativePerformance || globalThis.performance","const fetch = globalThis.__nativeFetch || globalThis.fetch"].join(`;
`);static serializeArguments(t){return t.map(n=>n===void 0?"undefined":JSON.stringify(n)).join(",")}static serializeDeps(t){return t=[he.esbuildFunctionWrapperString,...t||[]],t.map(n=>{if(typeof n=="function"){let r=n.toString(),a=he.getRuntimeFunctionName(n);return a!==n.name?`${r}; const ${n.name} = ${a};`:r}else return n}).join(`
`)}}});function yP(){return{promise:Promise.resolve(),cancel(){}}}function Jf(e){let t=s(()=>{throw new Error("waitForFrameNavigated.cancel() called before it was defined")},"cancel");return{promise:new Promise((r,a)=>{e.once("Page.frameNavigated",r),t=s(()=>{e.off("Page.frameNavigated",r),a(new Error("Wait for navigated cancelled"))},"cancel")}),cancel:t}}function Rre(e,t,n){let r=s(()=>{throw new Error("waitForFcp.cancel() called before it was defined")},"cancel");return{promise:new Promise((i,o)=>{let c=setTimeout(()=>{o(new G(G.errors.NO_FCP))},n),u,l=s(p=>{p.name==="firstContentfulPaint"&&(u=setTimeout(()=>{i(),r()},t))},"lifecycleListener");e.on("Page.lifecycleEvent",l);let m=!1;r=s(()=>{m||(m=!0,e.off("Page.lifecycleEvent",l),c&&clearTimeout(c),u&&clearTimeout(u),o(new Error("Wait for FCP canceled")))},"cancel")}),cancel:r}}function Cb(e,t,n){let r=!1,a,i=s(()=>{throw new Error("waitForNetworkIdle.cancel() called before it was defined")},"cancel"),{networkQuietThresholdMs:o,busyEvent:c,
idleEvent:u,isIdle:l}=n;return{promise:new Promise((p,h)=>{let f=s(()=>{t.once(c,g),a=setTimeout(()=>{i(),p()},o)},"onIdle"),g=s(()=>{t.once(u,f),a&&clearTimeout(a)},"onBusy"),b=s(()=>{r=!0,l(t)?f():g()},"domContentLoadedListener"),w=s(()=>{if(!r){F.verbose("waitFor","Waiting on DomContentLoaded");return}let x=t.getInflightRequests();if(F.isVerbose()&&x.length<20&&x.length>0){F.verbose("waitFor",`=== Waiting on ${x.length} requests to finish`);for(let S of x)F.verbose("waitFor",`Waiting on ${S.url.slice(0,120)} to finish`)}},"logStatus");t.on("requeststarted",w),t.on("requestfinished",w),t.on(c,w),n.pretendDCLAlreadyFired?b():e.once("Page.domContentEventFired",b);let E=!1;i=s(()=>{E||(E=!0,a&&clearTimeout(a),n.pretendDCLAlreadyFired||e.off("Page.domContentEventFired",b),t.removeListener(c,g),t.removeListener(u,f),t.removeListener("requeststarted",w),t.removeListener("requestfinished",w),t.removeListener(c,w))},"cancel")}),cancel:i}}function _re(e,t){if(!t)return{promise:Promise.resolve(),
cancel:()=>{}};let n,r=!1;async function a(u,l){if(r)return;let m=await u.evaluate(Fre,{args:[],useIsolation:!0});if(!r&&typeof m=="number")if(m>=t)F.verbose("waitFor",`CPU has been idle for ${m} ms`),l();else{F.verbose("waitFor",`CPU has been idle for ${m} ms`);let p=t-m;n=setTimeout(()=>a(u,l),p)}}s(a,"checkForQuiet");let i=s(()=>{throw new Error("waitForCPUIdle.cancel() called before it was defined")},"cancel"),o=new ui(e);return{promise:new Promise((u,l)=>{o.evaluate(Ire,{args:[],useIsolation:!0}).then(()=>a(o,u)).catch(l),i=s(()=>{r||(r=!0,n&&clearTimeout(n),l(new Error("Wait for CPU idle canceled")))},"cancel")}),cancel:i}}function Ire(){if(window.____lastLongTask!==void 0)return;window.____lastLongTask=performance.now(),new window.PerformanceObserver(t=>{let n=t.getEntries();for(let r of n)if(r.entryType==="longtask"){let a=r.startTime+r.duration;window.____lastLongTask=Math.max(window.____lastLongTask||0,a)}}).observe({type:"longtask",buffered:!0})}function Fre(){return new Promise(
e=>{let t=performance.now(),n=window.____lastLongTask||0;setTimeout(()=>{let r=window.____lastLongTask||0,a=n===r?t-n:0;e(a)},150)})}function kb(e,t){let n=s(()=>{throw new Error("waitForLoadEvent.cancel() called before it was defined")},"cancel");return{promise:new Promise((a,i)=>{let o,c=s(function(){o=setTimeout(a,t)},"loadListener");e.once("Page.loadEventFired",c);let u=!1;n=s(()=>{u||(u=!0,e.off("Page.loadEventFired",c),o&&clearTimeout(o))},"cancel")}),cancel:n}}async function Nre(e){try{return e.setNextProtocolTimeout(1e3),await e.sendCommand("Runtime.evaluate",{expression:'"ping"',returnByValue:!0,timeout:1e3}),!1}catch{return!0}}async function vP(e,t,n){let{pauseAfterFcpMs:r,pauseAfterLoadMs:a,networkQuietThresholdMs:i,cpuQuietThresholdMs:o,maxWaitForLoadedMs:c,maxWaitForFcpMs:u}=n,{waitForFcp:l,waitForLoadEvent:m,waitForNetworkIdle:p,waitForCPUIdle:h}=n._waitForTestOverride