### 🎯 Goal

Describe the big picture of your changes here to communicate to the maintainers why we should accept this pull request. If it fixes a bug or
resolves a feature request, be sure to link to that issue.

### 🛠 Implementation details

Describe the implementation details for this Pull Request.

### ✍️ Explain examples

Explain examples with code for these updates.

### 🔠 Naming pull requests

1. If its a new feature: [feat: *]
2. If it's a bug fix: [fix: *]
3. If it's a documentation update: [doc: *]

### Preparing a pull request for review

1. Before pushing your changes makes sure to run `./gradlew ktlintCheck --continue`. If there are any linting issues please fix them
   before creating a pull request.
2. Your pull request must pass the `CI workflow` before requesting a review to any of the maintainers, if not fix the issue first:
3. Always have descriptive commit messages explaining what you did.
4. Always have a description for your pull request to explain what you did in-depth, it will be great if you include video recordings or
   screenshots if possible.
5. If you need help with the above please feel to reach out to me and I will help you out.

## Code reviews

All submissions, including submissions by project members, require review. We use GitHub pull requests for this purpose.
Consult [GitHub Help](https://docs.github.com/en/github/collaborating-with-pull-requests/proposing-changes-to-your-work-with-pull-requests/about-pull-requests)
for more information on using pull requests.
