<!-- ---------- Header ---------- -->
<div align="center">
  <img src="app/src/main/res/drawable/circletosearch.png" width="200" height="200">
  <h1>Circle To Search</h1>
  <h3>Circle To Search: Multi-Engine Reverse Image Search</h3>
  <p>🔒 <em>Google • Bing • Yandex • Tineye</em></p>

<!-- ---------- Badges ---------- -->
  <div align="center">
    <img alt="License" src="https://img.shields.io/badge/License-Apache%202.0-blue.svg?style=flat-square">
    <img alt="Downloads" src="https://img.shields.io/github/downloads/AKS-Labs/CircleToSearch/total?color=c3e7ff&style=flat-square">
    <img alt="Last commit" src="https://img.shields.io/github/last-commit/AKS-Labs/CircleToSearch?color=c3e7ff&style=flat-square">
    <img alt="Repo size" src="https://img.shields.io/github/repo-size/AKS-Labs/CircleToSearch?color=c3e7ff&style=flat-square">
    <img alt="Stars" src="https://img.shields.io/github/stars/AKS-Labs/CircleToSearch?color=c3e7ff&style=flat-square">
    <br>
</div>

<!-- ----------   Labels ---------- -->
<div align="center">
  <img alt="API" src="https://img.shields.io/badge/Api%2029+-50f270?logo=android&logoColor=black&style=for-the-badge"/>
  <img alt="Kotlin" src="https://img.shields.io/badge/Kotlin-a503fc?logo=kotlin&logoColor=white&style=for-the-badge"/>
  <img alt="Jetpack Compose" src="https://img.shields.io/static/v1?style=for-the-badge&message=Jetpack+Compose&color=4285F4&logo=Jetpack+Compose&logoColor=FFFFFF&label="/>
  <img alt="material" src="https://custom-icon-badges.demolab.com/badge/material%20you-lightblue?style=for-the-badge&logocolor=333&logo=material-you"/>
</div>
</div>

---
## 🎯 What is Circle To Search?

Ever wanted to search for something you see on your phone screen? **Circle To Search** brings that power to your fingertips on *any* Android device. Simply draw a circle around what you're looking for, and instantly get results from your favorite search engine.

Think of it as having Google Lens, Bing Visual Search, Yandex, and TinEye all in one place—and it works everywhere.


---
## ✨ Features

-   **Universal Compatibility**: Works on any Android device (Android 10+).
-   **Instant Search**: Double-tap the status bar or use the floating bubble to trigger.
-   **Multi-Engine Support**: Search using Google Lens, Bing, Yandex, TinEye.
-   **Set As Default Assistant**: Use As Default Assistant to Search Images Using Circle To Search.
-   **It Can Talk With Humour**: Show Friendly Playful Message Every Time User Uses Circle To Search.
-   **Desktop Mode**: See Results In Desktop Mode.
-   **Dark Mode**: Browse Search Results in Dark Mode.
-   **Copy Url**: Copy Url Of Search Results.
-   **Open In Browser**: Open Search Results In Favourite Browser.
-   **Smart Selection**: Draw a circle, scribble to select.
-   **Beautiful UI**: Modern Material 3 design with dark mode support and smooth animations.
-   **Customizable**: Toggle dark mode, desktop mode, and UI elements like the gradient border.

---

## 🛠️ Built With

-   **Kotlin** - First-class and official programming language for Android development.
-   **Jetpack Compose** - Android’s modern toolkit for building native UI.
-   **Coroutines** - For asynchronous programming.
-   **Retrofit** - Type-safe HTTP client for Android.
-   **Coil** - Image loading library for Android backed by Kotlin Coroutines.

---



## 📥 **Get Circle To Search**

<div align="center">
    <!-- <p align="center">
  <a href="https://f-droid.org/packages/com.akslabs.cloudgallery/">
    <img src="https://fdroid.gitlab.io/artwork/badge/get-it-on.png"
         alt="Get it on F-Droid"
         height="80">
  </a> -->
  <a href="https://github.com/AKS-Labs/CircleToSearch/releases">
    <img alt="Get it on GitHub" src="https://user-images.githubusercontent.com/69304392/148696068-0cfea65d-b18f-4685-82b5-329a330b1c0d.png" height="80px">
  </a>
  <br>
  <p><strong>• 🔓 Open Source    • 🚀 Ready to Use</strong></p>
</div>

---


## 📱 **Screenshots**

<table align="center">
  <tr>
    <td><img src="fastlane/metadata/android/en-US/images/phoneScreenshots/1.png" width="200"/></td>
    <td><img src="fastlane/metadata/android/en-US/images/phoneScreenshots/2.png" width="200"/></td>
    <td><img src="fastlane/metadata/android/en-US/images/phoneScreenshots/3.png" width="200"/></td>
    <td><img src="fastlane/metadata/android/en-US/images/phoneScreenshots/4.png" width="200"/></td>
  </tr>
  <tr>
    <td><img src="fastlane/metadata/android/en-US/images/phoneScreenshots/5.png" width="200"/></td>
    <td><img src="fastlane/metadata/android/en-US/images/phoneScreenshots/6.png" width="200"/></td>
    <td><img src="fastlane/metadata/android/en-US/images/phoneScreenshots/7.png" width="200"/></td>
    <td><img src="fastlane/metadata/android/en-US/images/phoneScreenshots/8.png" width="200"/></td>
  </tr>
</table>

---

## 🤝 **Community**

- 🐛 **Bug reports:** [GitHub Issues](https://github.com/AKS-Labs/CircleToSearch/issues)
- 💡 **Feature requests:** [GitHub Issues](https://github.com/AKS-Labs/CircleToSearch/issues)
- 👨‍💻 **Contribute:** Fork and submit pull requests
- ⭐ Star the repo
* 💬 Join the [AKS-Labs Telegram group](https://t.me/AKSLabs)
* ☕ Maybe [**Donate**](https://github.com/sponsors/AKS-Labs), if you can.

---



## 🙏 Acknowledgments

-   Inspired by Google's Circle to Search feature.
-   Icons by [Material Design Icons](https://fonts.google.com/icons).

---

<p align="center">
  Made with ❤️ by <a href="https://github.com/akslabs">AKSLabs</a>
</p>
