@file:Suppress("UnstableApiUsage")

pluginManagement {
    repositories {
        google {
            content {
                includeGroupByRegex("com\\.android.*")
                includeGroupByRegex("com\\.google.*")
                includeGroupByRegex("androidx.*")
            }
        }
        mavenCentral()
        gradlePluginPortal()
    }
    resolutionStrategy {
        eachPlugin {
            if (requested.id.id == "com.google.android.gms.oss-licenses-plugin") {
                useModule("com.google.android.gms:oss-licenses-plugin:${requested.version}")
            }
        }
    }
}
dependencyResolutionManagement {
    repositoriesMode.set(RepositoriesMode.FAIL_ON_PROJECT_REPOS)
    repositories {
        google()
        mavenCentral()
    }
}

rootProject.name = "Ruam Mij"
include(
    ":app",
    ":base:common",
    ":base:data",
    ":base:resource",
    ":base:ui",
    ":base:utility",
    ":functional:core",
    ":functional:device",
    ":functional:mediaprojection",
    ":feature:aboutapp",
    ":feature:accessibility",
    ":feature:installedapp",
    ":feature:osslicense",
    ":feature:overview",
    ":feature:unverified",
)
