# Aisleron Shopping List

Streamline your shopping with this intuitive, easy-to-use shopping list app. Whether you're preparing for a weekly grocery run or shopping for a special occasion, this app helps you stay organized and efficient.

<p>
  <img src="https://aisleron.com/assets/images/alr-feature-graphic.png"  alt="Aisleron Feature Graphic"/>
</p>

## Key Features:

* Create Custom Shops & Aisles: Add your favorite stores, categorize items by aisles, and easily organize your shopping list based on your local layout.
* Smart Product Management: Add products to your list and assign them to the appropriate area in your home. Rearrange products by aisle within each store to match your shopping route.
* Swipe-to-Track: Keep track of your shopping progress with a simple swipe. Swipe left or right to mark items as "Needed" or "In Stock."
* Show on Lock Screen: No need to unlock your screen at the end of each aisle. Your shopping list will be displayed over the lock screen for convenience.
* Easy Editing: Long-press any item to edit or delete it

## Why you'll love it:

* Stay organized by shopping smarter.
* Reduce time spent navigating the store.
* Never forget an item again — track everything you need with ease.
* Light and Dark themes.
* Free, no ads.
* Everything is done on the local device, no sharing of location data or shopping habits.

Get started today and make your shopping trips faster and more efficient!

## Documentation

Documentation is available at [Aisleron.com](https://aisleron.com/docs/documentation/) 

## Screenshots

<p>
  <img src="https://aisleron.com/assets/images/screenshots/light-mode/alr-210-all-items-list.png" width=250px  alt="All Items List"/>
  <img src="https://aisleron.com/assets/images/screenshots/light-mode/alr-220-search.png" width=250px  alt="Search Products"/>
  <img src="https://aisleron.com/assets/images/screenshots/light-mode/alr-240-status-change-snackbar.png" width=250px  alt="Status Change"/>
</p>

<p>
  <img src="https://aisleron.com/assets/images/screenshots/light-mode/alr-010-welcome-page.png" width=250px  alt="Welcome Page"/>
  <img src="https://aisleron.com/assets/images/screenshots/light-mode/alr-040-navigation-drawer.png" width=250px  alt="Navigation Drawer"/>
  <img src="https://aisleron.com/assets/images/screenshots/light-mode/alr-050-settings.png" width=250px  alt="Settings"/>
</p>

<p>
  <img src="https://aisleron.com/assets/images/screenshots/light-mode/alr-270-shop-list-full.png" width=250px  alt="Light Theme"/>
  <img src="https://aisleron.com/assets/images/screenshots/mixed-mode/alr-270-shop-list-full.png" width=250px  alt="Theme Transition"/>
  <img src="https://aisleron.com/assets/images/screenshots/dark-mode/alr-270-shop-list-full.png" width=250px  alt="Dark Theme"/>
</p>

<p>
  <img src="https://aisleron.com/assets/images/screenshots/light-mode/alr-300-emoji-in-stock.png" width=250px  alt="Emoji In Stock"/>
  <img src="https://aisleron.com/assets/images/screenshots/light-mode/alr-310-emoji-needed.png" width=250px  alt="Emoji Needed"/>
  <img src="https://aisleron.com/assets/images/screenshots/light-mode/alr-320-emoji-all-items.png" width=250px  alt="Emoji All Items"/>
</p>

## Translating

[![Translation status](https://hosted.weblate.org/widget/aisleron-shopping-list/open-graph.png)](https://hosted.weblate.org/engage/aisleron-shopping-list/)

Contribute to translations on
the [Aisleron Hosted Weblate page](https://hosted.weblate.org/projects/aisleron-shopping-list/).
