/*
 * Copyright (C) 2025 aisleron.com
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */

package com.aisleron

import android.graphics.Color
import android.os.Bundle
import androidx.activity.SystemBarStyle
import androidx.activity.enableEdgeToEdge
import androidx.core.view.ViewCompat
import androidx.core.view.WindowInsetsCompat
import androidx.core.view.updatePadding
import com.aisleron.databinding.ActivityAboutBinding
import com.aisleron.ui.settings.DisplayPreferencesImpl


class AboutActivity : AisleronActivity() {

    private lateinit var binding: ActivityAboutBinding

    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)

        setDisplayPreferences()

        binding = ActivityAboutBinding.inflate(layoutInflater)

        setContentView(binding.root)
        setSupportActionBar(binding.toolbar)
        supportActionBar?.setDisplayHomeAsUpEnabled(true)

        setWindowInsetListeners()
    }

    private fun setDisplayPreferences() {
        val displayPreferences = DisplayPreferencesImpl()
        applyDynamicColors(displayPreferences)
        applyPureBlackStyle(displayPreferences)
    }

    private fun setWindowInsetListeners() {
        enableEdgeToEdge(statusBarStyle = SystemBarStyle.auto(Color.TRANSPARENT, Color.TRANSPARENT))

        val appBar = binding.appBarLayout
        ViewCompat.setOnApplyWindowInsetsListener(appBar) { view, windowInsets ->
            val insets = windowInsets.getInsets(
                WindowInsetsCompat.Type.statusBars()
                        or WindowInsetsCompat.Type.navigationBars()
                        or WindowInsetsCompat.Type.displayCutout()
            )

            view.updatePadding(top = insets.top, right = insets.right, left = insets.left)

            windowInsets
        }

        // Need a toolbar shim here as the application toolbar is defined in the main activity.
        /*val toolbarShim = binding.aboutToolbarShim
        ViewCompat.setOnApplyWindowInsetsListener(toolbarShim) { view, windowInsets ->
            val insets = windowInsets.getInsets(WindowInsetsCompat.Type.statusBars())

            val params = view.layoutParams
            params.height = insets.top
            view.layoutParams = params

            windowInsets
        }*/
    }
}