/*
 * Copyright (C) 2025 aisleron.com
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */

import org.jetbrains.kotlin.gradle.dsl.JvmTarget
import java.io.FileInputStream
import java.util.Properties

plugins {
    id("com.android.application")
    id("org.jetbrains.kotlin.android")
    id("com.google.devtools.ksp")
    id("org.jetbrains.kotlin.plugin.parcelize")

    id("com.autonomousapps.dependency-analysis")
}

apply("../gradle/jacoco.gradle")



android {
    dependenciesInfo {
        // Disables dependency metadata when building APKs.
        includeInApk = false
        // Sets dependency metadata when building Android App Bundles.
        includeInBundle = true
    }

        // Create a variable called keystorePropertiesFile, and initialize it to your
        // keystore.properties file, in the rootProject folder.
        // Initialize a new Properties() object called keystoreProperties.
        // Load your keystore.properties file into the keystoreProperties object.
    namespace = "com.aisleron"
    compileSdk = 35

    defaultConfig {
        applicationId = "com.aisleron"
        minSdk = 24
        targetSdk = 35
        versionCode = 14
        versionName = "2025.10.0"
        base.archivesName = "$applicationId-$versionName"

        testInstrumentationRunner = "com.aisleron.di.KoinInstrumentationTestRunner"

        testInstrumentationRunnerArguments["notPackage"] = "com.aisleron.screenshots"
    }

    ksp {
        arg("room.schemaLocation", "$projectDir/schemas")
    }

    buildTypes {
        release {
            isDebuggable = false
            isMinifyEnabled = true
            isShrinkResources = true
            proguardFiles(
                getDefaultProguardFile("proguard-android-optimize.txt"),
                "proguard-rules.pro"
            )
        }

        debug {
            isDebuggable = true
            enableAndroidTestCoverage = true
            enableUnitTestCoverage = true
            applicationIdSuffix = ".debug"
            versionNameSuffix = "-DEBUG"
        }
    }

    compileOptions {
        sourceCompatibility = JavaVersion.VERSION_17
        targetCompatibility = JavaVersion.VERSION_17
    }

    kotlin {
        compilerOptions {
            jvmTarget.set(JvmTarget.JVM_17)
        }
    }

    buildFeatures {
        viewBinding = true
        buildConfig = true
    }

    tasks.withType<Test> {
        useJUnitPlatform() // Make all tests use JUnit 5
    }

    packaging {
        resources.excludes.addAll(
            listOf(
                "META-INF/LICENSE.md",
                "META-INF/LICENSE-notice.md"
            )
        )
    }

    sourceSets {
        // Adds exported schema location as test app assets.
        getByName("androidTest").assets.srcDir("$projectDir/schemas")
    }

    //testOptions {
    //    animationsDisabled = true
    //}
}

dependencies {

    implementation("androidx.core:core-ktx:1.16.0") // 1.17.0 requires API 36
    implementation("androidx.appcompat:appcompat:1.7.1")
    implementation("com.google.android.material:material:1.13.0")
    implementation("androidx.recyclerview:recyclerview:1.4.0")
    implementation("androidx.fragment:fragment-ktx:1.8.9")
    implementation("androidx.activity:activity-ktx:1.10.1") // 1.11.0 requires API 36
    implementation("androidx.collection:collection-ktx:1.5.0")
    implementation("androidx.cardview:cardview:1.0.0")
    implementation("androidx.drawerlayout:drawerlayout:1.2.0")
    implementation("androidx.constraintlayout:constraintlayout:2.2.1")
    implementation("androidx.coordinatorlayout:coordinatorlayout:1.3.0")
    implementation("androidx.customview:customview:1.2.0")
    implementation("androidx.annotation:annotation:1.9.1")
    implementation("androidx.documentfile:documentfile:1.1.0")
    implementation("androidx.preference:preference-ktx:1.2.1")
    implementation("androidx.lifecycle:lifecycle-runtime-ktx:2.9.4")
    implementation("androidx.lifecycle:lifecycle-viewmodel-ktx:2.9.4")
    implementation("androidx.navigation:navigation-fragment-ktx:2.9.4")
    implementation("androidx.navigation:navigation-ui-ktx:2.9.4")
    implementation("androidx.navigation:navigation-common:2.9.4")
    implementation("androidx.navigation:navigation-runtime-ktx:2.9.4")
    implementation("org.jetbrains.kotlin:kotlin-parcelize-runtime:2.2.20")

    //Database
    implementation("androidx.sqlite:sqlite-ktx:2.6.0")
    implementation("androidx.room:room-ktx:2.8.0")
    implementation("androidx.room:room-runtime:2.8.0")
    implementation("androidx.room:room-common:2.8.0")
    implementation("androidx.room:room-testing-android:2.8.0")
    ksp("androidx.room:room-compiler:2.8.0")

    //Dependency Injection
    implementation("io.insert-koin:koin-android:4.1.1")
    implementation("io.insert-koin:koin-core-viewmodel:4.1.1")
    implementation("io.insert-koin:koin-core:4.1.1")

    //Coroutines
    implementation("org.jetbrains.kotlinx:kotlinx-coroutines-core:1.10.2")

    //Testing
    implementation("androidx.lifecycle:lifecycle-runtime-testing:2.9.4")
    implementation("androidx.test.espresso:espresso-contrib:3.7.0")

    testImplementation(project(":testData"))
    testImplementation("org.junit.jupiter:junit-jupiter:5.13.4")
    testImplementation("org.jetbrains.kotlinx:kotlinx-coroutines-test:1.10.2")
    testImplementation("androidx.room:room-testing:2.8.0")

    testRuntimeOnly("org.junit.platform:junit-platform-launcher")

    androidTestImplementation(project(":testData"))
    androidTestImplementation("androidx.test.ext:junit:1.3.0")
    androidTestImplementation("org.jetbrains.kotlinx:kotlinx-coroutines-test:1.10.2")
    androidTestImplementation("io.insert-koin:koin-test:4.1.1")
    androidTestImplementation("androidx.test:core-ktx:1.7.0")
    androidTestImplementation("androidx.navigation:navigation-testing:2.9.4")
    androidTestImplementation("androidx.test.uiautomator:uiautomator:2.3.0")

    androidTestImplementation("androidx.test.espresso:espresso-intents:3.7.0")
    androidTestImplementation("androidx.test.espresso:espresso-core:3.7.0")
    //org.hamcrest:hamcrest:2.2 dependency of:
    // androidx.test.espresso:espresso-core:3.6.1
    // androidx.test.espresso:espresso-intents:3.7.0
    androidTestImplementation("org.hamcrest:hamcrest:2.2")

    androidTestImplementation("tools.fastlane:screengrab:2.1.1")

    debugImplementation("androidx.fragment:fragment-testing:1.8.9")
}
java {
    toolchain {
    }
}

