/*
 * Copyright 2018 Aurélien Gâteau <mail@agateau.com>
 *
 * This file is part of Pixel Wheels.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License.
 *
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */
package com.agateau.ui;

import com.badlogic.gdx.Preferences;

/** Turn events of an input device into virtual keys */
public interface InputMapper {
    boolean isKeyPressed(VirtualKey vkey);

    boolean isKeyJustPressed(VirtualKey vkey);

    /** playerIdx is used by some input mappers (keyboard for example) to select default values */
    void loadConfig(Preferences preferences, String prefix, int playerIdx);

    void saveConfig(Preferences preferences, String prefix);

    boolean isAvailable();
}
