package com.afkanerd.smswithoutborders_libsmsmms.extensions

fun ByteArray.toIntLittleEndian(): Int {
    var result = 0
    for (i in this.indices) {
        result = result or (this[i].toInt() shl 8 * i)
    }
    return result
}

fun ByteArray.toShortLittleEndian(
    offset: Int = 0
): Short {
    require(this.size >= offset + 2) { "ByteArray must contain at least two bytes from the specified offset." }

    val byte1 = this[offset].toInt()
    val byte2 = this[offset + 1].toInt()

    return ((byte2 and 0xFF) shl 8 or (byte1 and 0xFF)).toShort()
}

fun ByteArray.isHexBytes(): Boolean {
    val text = try {
        this.toString(Charsets.US_ASCII)
    } catch (e: Exception) {
        return false
    }
    if (text.isEmpty()) return false
    return text.all { it in '0'..'9' || it in 'a'..'f' || it in 'A'..'F' }
}
