"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.getCliVersionAsNumber = exports.getCliVersion = void 0;
const schematics_1 = require("@angular-devkit/schematics");
function getCliVersion(tree, withPatch = false) {
    try {
        const cliPackageJsonBuffer = tree.read('./node_modules/@angular/cli/package.json');
        if (cliPackageJsonBuffer == null) {
            return '';
        }
        const packageJson = JSON.parse(cliPackageJsonBuffer.toString());
        const currentCliVersion = packageJson['version'];
        if (withPatch) {
            return currentCliVersion;
        }
        else {
            return currentCliVersion.substring(0, currentCliVersion.lastIndexOf('.'));
        }
    }
    catch (e) {
        throw new schematics_1.SchematicsException('Could not identify @angular/cli version. Make sure you have @angular/cli installed.');
    }
}
exports.getCliVersion = getCliVersion;
function getCliVersionAsNumber(tree) {
    return Number(getCliVersion(tree, false));
}
exports.getCliVersionAsNumber = getCliVersionAsNumber;
//# sourceMappingURL=ng-cli-version.js.map