/**
 * Dom7 4.0.4
 * Minimalistic JavaScript library for DOM manipulation, with a jQuery-compatible API
 * https://framework7.io/docs/dom7.html
 *
 * Copyright 2022, Vladimir Kharlampidi
 *
 * Licensed under MIT
 *
 * Released on: January 11, 2022
 */
!function(t,e){"object"==typeof exports&&"undefined"!=typeof module?module.exports=e():"function"==typeof define&&define.amd?define(e):(t="undefined"!=typeof globalThis?globalThis:t||self).Dom7=e()}(this,(function(){"use strict";function t(t){return null!==t&&"object"==typeof t&&"constructor"in t&&t.constructor===Object}function e(n={},i={}){Object.keys(i).forEach((o=>{void 0===n[o]?n[o]=i[o]:t(i[o])&&t(n[o])&&Object.keys(i[o]).length>0&&e(n[o],i[o])}))}const n={body:{},addEventListener(){},removeEventListener(){},activeElement:{blur(){},nodeName:""},querySelector:()=>null,querySelectorAll:()=>[],getElementById:()=>null,createEvent:()=>({initEvent(){}}),createElement:()=>({children:[],childNodes:[],style:{},setAttribute(){},getElementsByTagName:()=>[]}),createElementNS:()=>({}),importNode:()=>null,location:{hash:"",host:"",hostname:"",href:"",origin:"",pathname:"",protocol:"",search:""}};function i(){const t="undefined"!=typeof document?document:{};return e(t,n),t}const o={document:n,navigator:{userAgent:""},location:{hash:"",host:"",hostname:"",href:"",origin:"",pathname:"",protocol:"",search:""},history:{replaceState(){},pushState(){},go(){},back(){}},CustomEvent:function(){return this},addEventListener(){},removeEventListener(){},getComputedStyle:()=>({getPropertyValue:()=>""}),Image(){},Date(){},screen:{},setTimeout(){},clearTimeout(){},matchMedia:()=>({}),requestAnimationFrame:t=>"undefined"==typeof setTimeout?(t(),null):setTimeout(t,0),cancelAnimationFrame(t){"undefined"!=typeof setTimeout&&clearTimeout(t)}};function s(){const t="undefined"!=typeof window?window:{};return e(t,o),t}class r extends Array{constructor(t){"number"==typeof t?super(t):(super(...t||[]),function(t){const e=t.__proto__;Object.defineProperty(t,"__proto__",{get:()=>e,set(t){e.__proto__=t}})}(this))}}function l(t=[]){const e=[];return t.forEach((t=>{Array.isArray(t)?e.push(...l(t)):e.push(t)})),e}function h(t,e){return Array.prototype.filter.call(t,e)}function u(t,e){const n=s(),o=i();let l=[];if(!e&&t instanceof r)return t;if(!t)return new r(l);if("string"==typeof t){const n=t.trim();if(n.indexOf("<")>=0&&n.indexOf(">")>=0){let t="div";0===n.indexOf("<li")&&(t="ul"),0===n.indexOf("<tr")&&(t="tbody"),0!==n.indexOf("<td")&&0!==n.indexOf("<th")||(t="tr"),0===n.indexOf("<tbody")&&(t="table"),0===n.indexOf("<option")&&(t="select");const e=o.createElement(t);e.innerHTML=n;for(let t=0;t<e.childNodes.length;t+=1)l.push(e.childNodes[t])}else l=function(t,e){if("string"!=typeof t)return[t];const n=[],i=e.querySelectorAll(t);for(let t=0;t<i.length;t+=1)n.push(i[t]);return n}(t.trim(),e||o)}else if(t.nodeType||t===n||t===o)l.push(t);else if(Array.isArray(t)){if(t instanceof r)return t;l=t}return new r(function(t){const e=[];for(let n=0;n<t.length;n+=1)-1===e.indexOf(t[n])&&e.push(t[n]);return e}(l))}u.fn=r.prototype;var a=Object.freeze({__proto__:null,addClass:function(...t){const e=l(t.map((t=>t.split(" "))));return this.forEach((t=>{t.classList.add(...e)})),this},removeClass:function(...t){const e=l(t.map((t=>t.split(" "))));return this.forEach((t=>{t.classList.remove(...e)})),this},toggleClass:function(...t){const e=l(t.map((t=>t.split(" "))));this.forEach((t=>{e.forEach((e=>{t.classList.toggle(e)}))}))},hasClass:function(...t){const e=l(t.map((t=>t.split(" "))));return h(this,(t=>e.filter((e=>t.classList.contains(e))).length>0)).length>0},attr:function(t,e){if(1===arguments.length&&"string"==typeof t)return this[0]?this[0].getAttribute(t):void 0;for(let n=0;n<this.length;n+=1)if(2===arguments.length)this[n].setAttribute(t,e);else for(const e in t)this[n][e]=t[e],this[n].setAttribute(e,t[e]);return this},removeAttr:function(t){for(let e=0;e<this.length;e+=1)this[e].removeAttribute(t);return this},prop:function(t,e){if(1!==arguments.length||"string"!=typeof t){for(let n=0;n<this.length;n+=1)if(2===arguments.length)this[n][t]=e;else for(const e in t)this[n][e]=t[e];return this}return this[0]?this[0][t]:this},data:function(t,e){let n;if(void 0===e){if(n=this[0],!n)return;if(n.dom7ElementDataStorage&&t in n.dom7ElementDataStorage)return n.dom7ElementDataStorage[t];const e=n.getAttribute(`data-${t}`);return e||void 0}for(let i=0;i<this.length;i+=1)n=this[i],n.dom7ElementDataStorage||(n.dom7ElementDataStorage={}),n.dom7ElementDataStorage[t]=e;return this},removeData:function(t){for(let e=0;e<this.length;e+=1){const n=this[e];n.dom7ElementDataStorage&&n.dom7ElementDataStorage[t]&&(n.dom7ElementDataStorage[t]=null,delete n.dom7ElementDataStorage[t])}},dataset:function(){const t=this[0];if(!t)return;const e={};if(t.dataset)for(const n in t.dataset)e[n]=t.dataset[n];else for(let i=0;i<t.attributes.length;i+=1){const o=t.attributes[i];o.name.indexOf("data-")>=0&&(e[(n=o.name.split("data-")[1],n.toLowerCase().replace(/-(.)/g,((t,e)=>e.toUpperCase())))]=o.value)}var n;for(const t in e)"false"===e[t]?e[t]=!1:"true"===e[t]?e[t]=!0:parseFloat(e[t])===1*e[t]&&(e[t]*=1);return e},val:function(t){if(void 0===t){const t=this[0];if(!t)return;if(t.multiple&&"select"===t.nodeName.toLowerCase()){const e=[];for(let n=0;n<t.selectedOptions.length;n+=1)e.push(t.selectedOptions[n].value);return e}return t.value}for(let e=0;e<this.length;e+=1){const n=this[e];if(Array.isArray(t)&&n.multiple&&"select"===n.nodeName.toLowerCase())for(let e=0;e<n.options.length;e+=1)n.options[e].selected=t.indexOf(n.options[e].value)>=0;else n.value=t}return this},value:function(t){return this.val(t)},transform:function(t){for(let e=0;e<this.length;e+=1)this[e].style.transform=t;return this},transition:function(t){for(let e=0;e<this.length;e+=1)this[e].style.transitionDuration="string"!=typeof t?`${t}ms`:t;return this},on:function(...t){let[e,n,i,o]=t;function s(t){const e=t.target;if(!e)return;const o=t.target.dom7EventData||[];if(o.indexOf(t)<0&&o.unshift(t),u(e).is(n))i.apply(e,o);else{const t=u(e).parents();for(let e=0;e<t.length;e+=1)u(t[e]).is(n)&&i.apply(t[e],o)}}function r(t){const e=t&&t.target&&t.target.dom7EventData||[];e.indexOf(t)<0&&e.unshift(t),i.apply(this,e)}"function"==typeof t[1]&&([e,i,o]=t,n=void 0),o||(o=!1);const l=e.split(" ");let h;for(let t=0;t<this.length;t+=1){const e=this[t];if(n)for(h=0;h<l.length;h+=1){const t=l[h];e.dom7LiveListeners||(e.dom7LiveListeners={}),e.dom7LiveListeners[t]||(e.dom7LiveListeners[t]=[]),e.dom7LiveListeners[t].push({listener:i,proxyListener:s}),e.addEventListener(t,s,o)}else for(h=0;h<l.length;h+=1){const t=l[h];e.dom7Listeners||(e.dom7Listeners={}),e.dom7Listeners[t]||(e.dom7Listeners[t]=[]),e.dom7Listeners[t].push({listener:i,proxyListener:r}),e.addEventListener(t,r,o)}}return this},off:function(...t){let[e,n,i,o]=t;"function"==typeof t[1]&&([e,i,o]=t,n=void 0),o||(o=!1);const s=e.split(" ");for(let t=0;t<s.length;t+=1){const e=s[t];for(let t=0;t<this.length;t+=1){const s=this[t];let r;if(!n&&s.dom7Listeners?r=s.dom7Listeners[e]:n&&s.dom7LiveListeners&&(r=s.dom7LiveListeners[e]),r&&r.length)for(let t=r.length-1;t>=0;t-=1){const n=r[t];i&&n.listener===i||i&&n.listener&&n.listener.dom7proxy&&n.listener.dom7proxy===i?(s.removeEventListener(e,n.proxyListener,o),r.splice(t,1)):i||(s.removeEventListener(e,n.proxyListener,o),r.splice(t,1))}}}return this},once:function(...t){const e=this;let[n,i,o,s]=t;function r(...t){o.apply(this,t),e.off(n,i,r,s),r.dom7proxy&&delete r.dom7proxy}return"function"==typeof t[1]&&([n,o,s]=t,i=void 0),r.dom7proxy=o,e.on(n,i,r,s)},trigger:function(...t){const e=s(),n=t[0].split(" "),i=t[1];for(let o=0;o<n.length;o+=1){const s=n[o];for(let n=0;n<this.length;n+=1){const o=this[n];if(e.CustomEvent){const n=new e.CustomEvent(s,{detail:i,bubbles:!0,cancelable:!0});o.dom7EventData=t.filter(((t,e)=>e>0)),o.dispatchEvent(n),o.dom7EventData=[],delete o.dom7EventData}}}return this},transitionEnd:function(t){const e=this;return t&&e.on("transitionend",(function n(i){i.target===this&&(t.call(this,i),e.off("transitionend",n))})),this},animationEnd:function(t){const e=this;return t&&e.on("animationend",(function n(i){i.target===this&&(t.call(this,i),e.off("animationend",n))})),this},width:function(){const t=s();return this[0]===t?t.innerWidth:this.length>0?parseFloat(this.css("width")):null},outerWidth:function(t){if(this.length>0){if(t){const t=this.styles();return this[0].offsetWidth+parseFloat(t.getPropertyValue("margin-right"))+parseFloat(t.getPropertyValue("margin-left"))}return this[0].offsetWidth}return null},height:function(){const t=s();return this[0]===t?t.innerHeight:this.length>0?parseFloat(this.css("height")):null},outerHeight:function(t){if(this.length>0){if(t){const t=this.styles();return this[0].offsetHeight+parseFloat(t.getPropertyValue("margin-top"))+parseFloat(t.getPropertyValue("margin-bottom"))}return this[0].offsetHeight}return null},offset:function(){if(this.length>0){const t=s(),e=i(),n=this[0],o=n.getBoundingClientRect(),r=e.body,l=n.clientTop||r.clientTop||0,h=n.clientLeft||r.clientLeft||0,u=n===t?t.scrollY:n.scrollTop,a=n===t?t.scrollX:n.scrollLeft;return{top:o.top+u-l,left:o.left+a-h}}return null},hide:function(){for(let t=0;t<this.length;t+=1)this[t].style.display="none";return this},show:function(){const t=s();for(let e=0;e<this.length;e+=1){const n=this[e];"none"===n.style.display&&(n.style.display=""),"none"===t.getComputedStyle(n,null).getPropertyValue("display")&&(n.style.display="block")}return this},styles:function(){const t=s();return this[0]?t.getComputedStyle(this[0],null):{}},css:function(t,e){const n=s();let i;if(1===arguments.length){if("string"!=typeof t){for(i=0;i<this.length;i+=1)for(const e in t)this[i].style[e]=t[e];return this}if(this[0])return n.getComputedStyle(this[0],null).getPropertyValue(t)}if(2===arguments.length&&"string"==typeof t){for(i=0;i<this.length;i+=1)this[i].style[t]=e;return this}return this},each:function(t){return t?(this.forEach(((e,n)=>{t.apply(e,[e,n])})),this):this},filter:function(t){return u(h(this,t))},html:function(t){if(void 0===t)return this[0]?this[0].innerHTML:null;for(let e=0;e<this.length;e+=1)this[e].innerHTML=t;return this},text:function(t){if(void 0===t)return this[0]?this[0].textContent.trim():null;for(let e=0;e<this.length;e+=1)this[e].textContent=t;return this},is:function(t){const e=s(),n=i(),o=this[0];let l,h;if(!o||void 0===t)return!1;if("string"==typeof t){if(o.matches)return o.matches(t);if(o.webkitMatchesSelector)return o.webkitMatchesSelector(t);if(o.msMatchesSelector)return o.msMatchesSelector(t);for(l=u(t),h=0;h<l.length;h+=1)if(l[h]===o)return!0;return!1}if(t===n)return o===n;if(t===e)return o===e;if(t.nodeType||t instanceof r){for(l=t.nodeType?[t]:t,h=0;h<l.length;h+=1)if(l[h]===o)return!0;return!1}return!1},index:function(){let t,e=this[0];if(e){for(t=0;null!==(e=e.previousSibling);)1===e.nodeType&&(t+=1);return t}},eq:function(t){if(void 0===t)return this;const e=this.length;if(t>e-1)return u([]);if(t<0){const n=e+t;return u(n<0?[]:[this[n]])}return u([this[t]])},append:function(...t){let e;const n=i();for(let i=0;i<t.length;i+=1){e=t[i];for(let t=0;t<this.length;t+=1)if("string"==typeof e){const i=n.createElement("div");for(i.innerHTML=e;i.firstChild;)this[t].appendChild(i.firstChild)}else if(e instanceof r)for(let n=0;n<e.length;n+=1)this[t].appendChild(e[n]);else this[t].appendChild(e)}return this},appendTo:function(t){return u(t).append(this),this},prepend:function(t){const e=i();let n,o;for(n=0;n<this.length;n+=1)if("string"==typeof t){const i=e.createElement("div");for(i.innerHTML=t,o=i.childNodes.length-1;o>=0;o-=1)this[n].insertBefore(i.childNodes[o],this[n].childNodes[0])}else if(t instanceof r)for(o=0;o<t.length;o+=1)this[n].insertBefore(t[o],this[n].childNodes[0]);else this[n].insertBefore(t,this[n].childNodes[0]);return this},prependTo:function(t){return u(t).prepend(this),this},insertBefore:function(t){const e=u(t);for(let t=0;t<this.length;t+=1)if(1===e.length)e[0].parentNode.insertBefore(this[t],e[0]);else if(e.length>1)for(let n=0;n<e.length;n+=1)e[n].parentNode.insertBefore(this[t].cloneNode(!0),e[n])},insertAfter:function(t){const e=u(t);for(let t=0;t<this.length;t+=1)if(1===e.length)e[0].parentNode.insertBefore(this[t],e[0].nextSibling);else if(e.length>1)for(let n=0;n<e.length;n+=1)e[n].parentNode.insertBefore(this[t].cloneNode(!0),e[n].nextSibling)},next:function(t){return this.length>0?t?this[0].nextElementSibling&&u(this[0].nextElementSibling).is(t)?u([this[0].nextElementSibling]):u([]):this[0].nextElementSibling?u([this[0].nextElementSibling]):u([]):u([])},nextAll:function(t){const e=[];let n=this[0];if(!n)return u([]);for(;n.nextElementSibling;){const i=n.nextElementSibling;t?u(i).is(t)&&e.push(i):e.push(i),n=i}return u(e)},prev:function(t){if(this.length>0){const e=this[0];return t?e.previousElementSibling&&u(e.previousElementSibling).is(t)?u([e.previousElementSibling]):u([]):e.previousElementSibling?u([e.previousElementSibling]):u([])}return u([])},prevAll:function(t){const e=[];let n=this[0];if(!n)return u([]);for(;n.previousElementSibling;){const i=n.previousElementSibling;t?u(i).is(t)&&e.push(i):e.push(i),n=i}return u(e)},siblings:function(t){return this.nextAll(t).add(this.prevAll(t))},parent:function(t){const e=[];for(let n=0;n<this.length;n+=1)null!==this[n].parentNode&&(t?u(this[n].parentNode).is(t)&&e.push(this[n].parentNode):e.push(this[n].parentNode));return u(e)},parents:function(t){const e=[];for(let n=0;n<this.length;n+=1){let i=this[n].parentNode;for(;i;)t?u(i).is(t)&&e.push(i):e.push(i),i=i.parentNode}return u(e)},closest:function(t){let e=this;return void 0===t?u([]):(e.is(t)||(e=e.parents(t).eq(0)),e)},find:function(t){const e=[];for(let n=0;n<this.length;n+=1){const i=this[n].querySelectorAll(t);for(let t=0;t<i.length;t+=1)e.push(i[t])}return u(e)},children:function(t){const e=[];for(let n=0;n<this.length;n+=1){const i=this[n].children;for(let n=0;n<i.length;n+=1)t&&!u(i[n]).is(t)||e.push(i[n])}return u(e)},remove:function(){for(let t=0;t<this.length;t+=1)this[t].parentNode&&this[t].parentNode.removeChild(this[t]);return this},detach:function(){return this.remove()},add:function(...t){const e=this;let n,i;for(n=0;n<t.length;n+=1){const o=u(t[n]);for(i=0;i<o.length;i+=1)e.push(o[i])}return e},empty:function(){for(let t=0;t<this.length;t+=1){const e=this[t];if(1===e.nodeType){for(let t=0;t<e.childNodes.length;t+=1)e.childNodes[t].parentNode&&e.childNodes[t].parentNode.removeChild(e.childNodes[t]);e.textContent=""}}return this}});var c=Object.freeze({__proto__:null,scrollTo:function(...t){const e=s();let[n,i,o,r,l]=t;return 4===t.length&&"function"==typeof r&&(l=r,[n,i,o,l,r]=t),void 0===r&&(r="swing"),this.each((function(){const t=this;let s,h,u,a,c,f,d,p,m=i>0||0===i,g=n>0||0===n;if(void 0===r&&(r="swing"),m&&(s=t.scrollTop,o||(t.scrollTop=i)),g&&(h=t.scrollLeft,o||(t.scrollLeft=n)),!o)return;m&&(u=t.scrollHeight-t.offsetHeight,c=Math.max(Math.min(i,u),0)),g&&(a=t.scrollWidth-t.offsetWidth,f=Math.max(Math.min(n,a),0));let y=null;m&&c===s&&(m=!1),g&&f===h&&(g=!1),e.requestAnimationFrame((function n(i=(new Date).getTime()){null===y&&(y=i);const u=Math.max(Math.min((i-y)/o,1),0),a="linear"===r?u:.5-Math.cos(u*Math.PI)/2;let v;m&&(d=s+a*(c-s)),g&&(p=h+a*(f-h)),m&&c>s&&d>=c&&(t.scrollTop=c,v=!0),m&&c<s&&d<=c&&(t.scrollTop=c,v=!0),g&&f>h&&p>=f&&(t.scrollLeft=f,v=!0),g&&f<h&&p<=f&&(t.scrollLeft=f,v=!0),v?l&&l():(m&&(t.scrollTop=d),g&&(t.scrollLeft=p),e.requestAnimationFrame(n))}))}))},scrollTop:function(...t){let[e,n,i,o]=t;3===t.length&&"function"==typeof i&&([e,n,o,i]=t);const s=this;return void 0===e?s.length>0?s[0].scrollTop:null:s.scrollTo(void 0,e,n,i,o)},scrollLeft:function(...t){let[e,n,i,o]=t;3===t.length&&"function"==typeof i&&([e,n,o,i]=t);const s=this;return void 0===e?s.length>0?s[0].scrollLeft:null:s.scrollTo(e,void 0,n,i,o)}});var f=Object.freeze({__proto__:null,animate:function(t,e){const n=s(),i=this,o={props:Object.assign({},t),params:Object.assign({duration:300,easing:"swing"},e),elements:i,animating:!1,que:[],easingProgress:(t,e)=>"swing"===t?.5-Math.cos(e*Math.PI)/2:"function"==typeof t?t(e):e,stop(){o.frameId&&n.cancelAnimationFrame(o.frameId),o.animating=!1,o.elements.each((t=>{delete t.dom7AnimateInstance})),o.que=[]},done(t){if(o.animating=!1,o.elements.each((t=>{delete t.dom7AnimateInstance})),t&&t(i),o.que.length>0){const t=o.que.shift();o.animate(t[0],t[1])}},animate(t,e){if(o.animating)return o.que.push([t,e]),o;const s=[];o.elements.each(((e,i)=>{let r,l,h,u,a;e.dom7AnimateInstance||(o.elements[i].dom7AnimateInstance=o),s[i]={container:e},Object.keys(t).forEach((o=>{r=n.getComputedStyle(e,null).getPropertyValue(o).replace(",","."),l=parseFloat(r),h=r.replace(l,""),u=parseFloat(t[o]),a=t[o]+h,s[i][o]={initialFullValue:r,initialValue:l,unit:h,finalValue:u,finalFullValue:a,currentValue:l}}))}));let r,l,h=null,u=0,a=0,c=!1;return o.animating=!0,o.frameId=n.requestAnimationFrame((function f(){let d,p;r=(new Date).getTime(),c||(c=!0,e.begin&&e.begin(i)),null===h&&(h=r),e.progress&&e.progress(i,Math.max(Math.min((r-h)/e.duration,1),0),h+e.duration-r<0?0:h+e.duration-r,h),s.forEach((n=>{const i=n;l||i.done||Object.keys(t).forEach((n=>{if(l||i.done)return;d=Math.max(Math.min((r-h)/e.duration,1),0),p=o.easingProgress(e.easing,d);const{initialValue:c,finalValue:f,unit:m}=i[n];i[n].currentValue=c+p*(f-c);const g=i[n].currentValue;(f>c&&g>=f||f<c&&g<=f)&&(i.container.style[n]=f+m,a+=1,a===Object.keys(t).length&&(i.done=!0,u+=1),u===s.length&&(l=!0)),l?o.done(e.complete):i.container.style[n]=g+m}))})),l||(o.frameId=n.requestAnimationFrame(f))})),o}};if(0===o.elements.length)return i;let r;for(let t=0;t<o.elements.length;t+=1)o.elements[t].dom7AnimateInstance?r=o.elements[t].dom7AnimateInstance:o.elements[t].dom7AnimateInstance=o;return r||(r=o),"stop"===t?r.stop():r.animate(o.props,o.params),i},stop:function(){const t=this;for(let e=0;e<t.length;e+=1)t[e].dom7AnimateInstance&&t[e].dom7AnimateInstance.stop()}});const d="resize scroll".split(" ");function p(t){return function(...e){if(void 0===e[0]){for(let e=0;e<this.length;e+=1)d.indexOf(t)<0&&(t in this[e]?this[e][t]():u(this[e]).trigger(t));return this}return this.on(t,...e)}}const m=p("click"),g=p("blur"),y=p("focus"),v=p("focusin"),b=p("focusout"),E=p("keyup"),L=p("keydown"),x=p("keypress"),S=p("submit"),A=p("change"),T=p("mousedown"),N=p("mousemove"),O=p("mouseup"),_=p("mouseenter"),C=p("mouseleave"),w=p("mouseout"),M=p("mouseover"),D=p("touchstart"),k=p("touchend"),F=p("touchmove"),I=p("resize"),V=p("scroll");return[a,c,f,Object.freeze({__proto__:null,click:m,blur:g,focus:y,focusin:v,focusout:b,keyup:E,keydown:L,keypress:x,submit:S,change:A,mousedown:T,mousemove:N,mouseup:O,mouseenter:_,mouseleave:C,mouseout:w,mouseover:M,touchstart:D,touchend:k,touchmove:F,resize:I,scroll:V})].forEach((t=>{Object.keys(t).forEach((e=>{u.fn[e]=t[e]}))})),u}));
//# sourceMappingURL=dom7.min.js.map