"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.registerTsProject = void 0;
const read_default_tsconfig_1 = require("@swc-node/register/read-default-tsconfig");
const register_1 = require("@swc-node/register/register");
const path_1 = require("path");
/**
 * Optionally, if swc-node and tsconfig-paths are available in the current workspace, apply the require
 * register hooks so that .ts files can be used for writing custom workspace projects.
 *
 * If ts-node and tsconfig-paths are not available, the user can still provide an index.js file in
 * the root of their project and the fundamentals will still work (but
 * workspace path mapping will not, for example).
 */
const registerTsProject = (path, configFilename = 'tsconfig.json') => {
    try {
        const tsConfig = (0, read_default_tsconfig_1.readDefaultTsConfig)((0, path_1.join)(path, configFilename));
        (0, register_1.register)(tsConfig);
        /**
         * Load the ts config from the source project
         */
        const tsconfigPaths = require('tsconfig-paths');
        const tsConfigResult = tsconfigPaths.loadConfig(path);
        /**
         * Register the custom workspace path mappings with node so that workspace libraries
         * can be imported and used within project
         */
        return tsconfigPaths.register({
            baseUrl: tsConfigResult.absoluteBaseUrl,
            paths: tsConfigResult.paths,
        });
    }
    catch (err) { }
};
exports.registerTsProject = registerTsProject;
//# sourceMappingURL=register.js.map