"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.mergePluginTargetsWithNxTargets = exports.loadNxPlugins = void 0;
const fast_glob_1 = require("fast-glob");
const fs_1 = require("fs");
const path_1 = require("path");
const app_root_1 = require("../utils/app-root");
const fileutils_1 = require("../utils/fileutils");
function findPluginPackageJson(path, plugin) {
    while (true) {
        if (!path.startsWith(app_root_1.appRootPath)) {
            throw new Error("Couldn't find a package.json for Nx plugin:" + plugin);
        }
        if ((0, fs_1.existsSync)((0, path_1.join)(path, 'package.json'))) {
            return (0, path_1.join)(path, 'package.json');
        }
        path = (0, path_1.dirname)(path);
    }
}
let nxPluginCache = null;
function loadNxPlugins(plugins) {
    return (plugins === null || plugins === void 0 ? void 0 : plugins.length)
        ? nxPluginCache ||
            (nxPluginCache = plugins.map((path) => {
                const pluginPath = require.resolve(path, {
                    paths: [app_root_1.appRootPath],
                });
                const { name } = (0, fileutils_1.readJsonFile)(findPluginPackageJson(pluginPath, path));
                const plugin = require(pluginPath);
                plugin.name = name;
                return plugin;
            }))
        : [];
}
exports.loadNxPlugins = loadNxPlugins;
function mergePluginTargetsWithNxTargets(projectRoot, targets, plugins) {
    var _a;
    let newTargets = {};
    for (const plugin of plugins) {
        if (!((_a = plugin.projectFilePatterns) === null || _a === void 0 ? void 0 : _a.length) || !plugin.registerProjectTargets) {
            continue;
        }
        const projectFiles = (0, fast_glob_1.sync)(`+(${plugin.projectFilePatterns.join('|')})`, {
            cwd: (0, path_1.join)(app_root_1.appRootPath, projectRoot),
        });
        for (const projectFile of projectFiles) {
            newTargets = Object.assign(Object.assign({}, newTargets), plugin.registerProjectTargets((0, path_1.join)(projectRoot, projectFile)));
        }
    }
    return Object.assign(Object.assign({}, newTargets), targets);
}
exports.mergePluginTargetsWithNxTargets = mergePluginTargetsWithNxTargets;
//# sourceMappingURL=nx-plugin.js.map