import { ProjectGraphProcessor } from './project-graph';
import { TargetConfiguration } from './workspace';
export declare type ProjectTargetConfigurator = (file: string) => Record<string, TargetConfiguration>;
/**
 * A plugin for Nx
 */
export interface NxPlugin {
    name: string;
    processProjectGraph?: ProjectGraphProcessor;
    registerProjectTargets?: ProjectTargetConfigurator;
    /**
     * A glob pattern to search for non-standard project files.
     * @example: ["*.csproj", "pom.xml"]
     */
    projectFilePatterns?: string[];
}
export declare function loadNxPlugins(plugins?: string[]): NxPlugin[];
export declare function mergePluginTargetsWithNxTargets(projectRoot: string, targets: Record<string, TargetConfiguration>, plugins: NxPlugin[]): Record<string, TargetConfiguration>;
