/*!
 * (C) Ionic http://ionicframework.com - MIT License
 */
import { proxyCustomElement, HTMLElement, h, Host } from '@stencil/core/internal/client';
import { b as getIonMode } from './ionic-global.js';

const itemGroupIosCss = "ion-item-group{display:block}";

const itemGroupMdCss = "ion-item-group{display:block}";

const ItemGroup = /*@__PURE__*/ proxyCustomElement(class extends HTMLElement {
  constructor() {
    super();
    this.__registerHost();
  }
  render() {
    const mode = getIonMode(this);
    return (h(Host, { role: "group", class: {
        [mode]: true,
        // Used internally for styling
        [`item-group-${mode}`]: true,
        item: true,
      } }));
  }
  static get style() { return {
    ios: itemGroupIosCss,
    md: itemGroupMdCss
  }; }
}, [32, "ion-item-group"]);
function defineCustomElement$1() {
  if (typeof customElements === "undefined") {
    return;
  }
  const components = ["ion-item-group"];
  components.forEach(tagName => { switch (tagName) {
    case "ion-item-group":
      if (!customElements.get(tagName)) {
        customElements.define(tagName, ItemGroup);
      }
      break;
  } });
}

const IonItemGroup = ItemGroup;
const defineCustomElement = defineCustomElement$1;

export { IonItemGroup, defineCustomElement };
