import { AliasedMap } from '@ionic/utils-object';
import { CommandInstanceInfo, CommandLineInputs, CommandLineOptions, CommandMapGetter, CommandMetadata, CommandMetadataInput, CommandMetadataOption, CommandPathItem, HydratedCommandMetadata, HydratedNamespaceMetadata, ICommand, ICommandMap, INamespace, INamespaceMap, NamespaceLocateOptions, NamespaceLocateResult, NamespaceMapGetter, NamespaceMetadata } from '../definitions';
export declare abstract class BaseCommand<C extends ICommand<C, N, M, I, O>, N extends INamespace<C, N, M, I, O>, M extends CommandMetadata<I, O>, I extends CommandMetadataInput, O extends CommandMetadataOption> {
    namespace: N;
    constructor(namespace: N);
    abstract getMetadata(): Promise<M>;
    abstract run(inputs: CommandLineInputs, options: CommandLineOptions, runtime?: Partial<CommandInstanceInfo<C, N, M, I, O>>): Promise<void>;
    validate(argv: CommandLineInputs): Promise<void>;
}
export declare const CommandMapDefault: unique symbol;
export declare class BaseCommandMap<C extends ICommand<C, N, M, I, O>, N extends INamespace<C, N, M, I, O>, M extends CommandMetadata<I, O>, I extends CommandMetadataInput, O extends CommandMetadataOption> extends AliasedMap<string, CommandMapGetter<C, N, M, I, O>> implements ICommandMap<C, N, M, I, O> {
}
export declare class BaseNamespaceMap<C extends ICommand<C, N, M, I, O>, N extends INamespace<C, N, M, I, O>, M extends CommandMetadata<I, O>, I extends CommandMetadataInput, O extends CommandMetadataOption> extends AliasedMap<string, NamespaceMapGetter<C, N, M, I, O>> implements INamespaceMap<C, N, M, I, O> {
}
export declare abstract class BaseNamespace<C extends ICommand<C, N, M, I, O>, N extends INamespace<C, N, M, I, O>, M extends CommandMetadata<I, O>, I extends CommandMetadataInput, O extends CommandMetadataOption> implements INamespace<C, N, M, I, O> {
    parent: N | undefined;
    constructor(parent?: N);
    get root(): N;
    abstract getMetadata(): Promise<NamespaceMetadata>;
    getNamespaces(): Promise<INamespaceMap<C, N, M, I, O>>;
    getCommands(): Promise<ICommandMap<C, N, M, I, O>>;
    /**
     * Locate commands and namespaces given a set of inputs.
     *
     * Recursively walk down the tree of namespaces available within this
     * namespace to find the command that we will execute or the right-most
     * namespace matched if the command is not found.
     *
     * The resolved object looks like this:
     *
     *    {
     *      obj: command or namespace,
     *      args: the leftover arguments,
     *      path: the path taken to get to the result which comprises tuples of <arg, command or namespace>
     *    }
     *
     * @param argv The set of command-line arguments to use to locate.
     */
    locate(argv: readonly string[], { useAliases }?: NamespaceLocateOptions): Promise<NamespaceLocateResult<C, N, M, I, O>>;
    /**
     * Get all command metadata in a flat structure.
     */
    getCommandMetadataList(): Promise<readonly HydratedCommandMetadata<C, N, M, I, O>[]>;
    groupCommandsByNamespace(commands: readonly HydratedCommandMetadata<C, N, M, I, O>[]): Promise<readonly (HydratedNamespaceMetadata<C, N, M, I, O> & {
        commands: readonly HydratedCommandMetadata<C, N, M, I, O>[];
    })[]>;
}
export declare abstract class Command extends BaseCommand<Command, Namespace, CommandMetadata, CommandMetadataInput, CommandMetadataOption> {
}
export declare abstract class Namespace extends BaseNamespace<Command, Namespace, CommandMetadata, CommandMetadataInput, CommandMetadataOption> {
}
export declare class CommandMap extends BaseCommandMap<Command, Namespace, CommandMetadata, CommandMetadataInput, CommandMetadataOption> {
}
export declare class NamespaceMap extends BaseNamespaceMap<Command, Namespace, CommandMetadata, CommandMetadataInput, CommandMetadataOption> {
}
/**
 * Given a command object, backtrack through the command's namespace to compile
 * a list of command path items which represents how the command was
 * found/constructed.
 */
export declare function generateCommandPath<C extends ICommand<C, N, M, I, O>, N extends INamespace<C, N, M, I, O>, M extends CommandMetadata<I, O>, I extends CommandMetadataInput, O extends CommandMetadataOption>(cmd: C): Promise<CommandPathItem<C, N, M, I, O>[]>;
