"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const core_1 = require("@angular-devkit/core");
const schematics_1 = require("@angular-devkit/schematics");
const tasks_1 = require("@angular-devkit/schematics/tasks");
const workspace_1 = require("@schematics/angular/utility/workspace");
const ast_1 = require("./../utils/ast");
const config_1 = require("./../utils/config");
const package_1 = require("./../utils/package");
function addIonicAngularToPackageJson() {
    return (host) => {
        package_1.addPackageToPackageJson(host, 'dependencies', '@ionic/angular', 'latest');
        return host;
    };
}
function addIonicAngularToolkitToPackageJson() {
    return (host) => {
        package_1.addPackageToPackageJson(host, 'devDependencies', '@ionic/angular-toolkit', 'latest');
        return host;
    };
}
function addIonicAngularModuleToAppModule(projectSourceRoot) {
    return (host) => {
        ast_1.addModuleImportToRootModule(host, projectSourceRoot, 'IonicModule.forRoot()', '@ionic/angular');
        return host;
    };
}
function addIonicStyles(projectName, projectSourceRoot) {
    return (host) => {
        const ionicStyles = [
            'node_modules/@ionic/angular/css/core.css',
            'node_modules/@ionic/angular/css/normalize.css',
            'node_modules/@ionic/angular/css/structure.css',
            'node_modules/@ionic/angular/css/typography.css',
            'node_modules/@ionic/angular/css/display.css',
            'node_modules/@ionic/angular/css/padding.css',
            'node_modules/@ionic/angular/css/float-elements.css',
            'node_modules/@ionic/angular/css/text-alignment.css',
            'node_modules/@ionic/angular/css/text-transformation.css',
            'node_modules/@ionic/angular/css/flex-utils.css',
            `${projectSourceRoot}/theme/variables.css`,
        ];
        ionicStyles.forEach((entry) => {
            config_1.addStyle(host, projectName, entry);
        });
        return host;
    };
}
function addIonicons(projectName) {
    return (host) => {
        const ioniconsGlob = {
            glob: '**/*.svg',
            input: 'node_modules/ionicons/dist/ionicons/svg',
            output: './svg',
        };
        config_1.addAsset(host, projectName, 'build', ioniconsGlob);
        config_1.addAsset(host, projectName, 'test', ioniconsGlob);
        return host;
    };
}
function addIonicBuilder(projectName) {
    return (host) => {
        config_1.addArchitectBuilder(host, projectName, 'ionic-cordova-serve', {
            builder: '@ionic/angular-toolkit:cordova-serve',
            options: {
                cordovaBuildTarget: `${projectName}:ionic-cordova-build`,
                devServerTarget: `${projectName}:serve`,
            },
            configurations: {
                production: {
                    cordovaBuildTarget: `${projectName}:ionic-cordova-build:production`,
                    devServerTarget: `${projectName}:serve:production`,
                },
            },
        });
        config_1.addArchitectBuilder(host, projectName, 'ionic-cordova-build', {
            builder: '@ionic/angular-toolkit:cordova-build',
            options: {
                browserTarget: `${projectName}:build`,
            },
            configurations: {
                production: {
                    browserTarget: `${projectName}:build:production`,
                },
            },
        });
        return host;
    };
}
function installNodeDeps() {
    return (_host, context) => {
        context.addTask(new tasks_1.NodePackageInstallTask());
    };
}
function ngAdd(options) {
    return async (host) => {
        const workspace = await workspace_1.getWorkspace(host);
        if (!options.project) {
            options.project = config_1.getDefaultAngularAppName(workspace);
        }
        const project = workspace.projects.get(options.project);
        if (!project || project.extensions.projectType !== 'application') {
            throw new schematics_1.SchematicsException(`Ionic Add requires a project type of "application".`);
        }
        const sourcePath = core_1.join(project.sourceRoot);
        const rootTemplateSource = schematics_1.apply(schematics_1.url('./files/root'), [schematics_1.template(Object.assign({}, options)), schematics_1.move(sourcePath)]);
        return schematics_1.chain([
            // @ionic/angular
            addIonicAngularToPackageJson(),
            addIonicAngularToolkitToPackageJson(),
            addIonicAngularModuleToAppModule(sourcePath),
            addIonicBuilder(options.project),
            addIonicStyles(options.project, sourcePath),
            addIonicons(options.project),
            schematics_1.mergeWith(rootTemplateSource),
            // install freshly added dependencies
            installNodeDeps(),
        ]);
    };
}
exports.default = ngAdd;
